@extends('layouts.factor-master')

@section('content')
    <?php
    

    $report = customeReport('item_none_cost');
    $_date = in_array('date', $report);
    $_description = in_array('description', $report);
    $_reference_number = in_array('reference_number', $report);
    $_total_amount = in_array('_total_amount', $report);
    $_total_amount_a = in_array('total_amount', $report);
    $_category = in_array('category', $report);
    $_account = in_array('account', $report);
    $_quantity = in_array('quantity', $report);
    ?>

    <h3 class="table-caption" style="text-align: center;">@lang('layout.ItemNoneCostReport')</h3>
    @if($category)
    <p>
        <span>@lang('layout.Category'):{{__('layout.'.ucfirst($category))}}</span>
    </p>
    @endif
    <table class="main-table">
        <thead>
        <tr class="bg">
            <td  class="center" >
                <div >@lang('layout.Record') </div>
            </td>
            <td  class="center" >
                <div >@lang('layout.ID')</div>
            </td>
            @if($_date)
                <td class="center">@lang('layout.Date')</td>@endif
            @if($_description)
                <td class="center">@lang('layout.Description')</td>@endif
            @if($_reference_number)
                <td class="center">@lang('layout.ReferenceNumber')</td>@endif
            @if($_category)
             <td class="center">@lang('layout.Category')</td>@endif
             <td class="center">@lang('layout.User')</td>
        </tr>
        </thead>
        <?php
        $count = 0;
        ?>
        @foreach($data AS $record)
            <tr>
                <td class="center">{{++$count}}</td>
                <td class="center">{{$record->id}}</td>
                @if($_date)
                    <td class="center">{{convertDate($record->date)}}</td>@endif
                @if($_description)
                    <td style="text-align: justify">{{$record->description}}</td>@endif
                @if($_reference_number)
                    <td class="center">{{$record->ref_no}}</td>@endif
                @if($_category)
                    <td class="center">{{$record->category}}</td>@endif
                    <td class="center">{{$record->user}}</td>
               
            </tr>
        @endforeach
    </table>
 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection