@extends('layouts.app')

@section('content')

    <div class="portlet">
        <div class="portlet-title">
            <div class="caption">
                <i class=""></i>@lang('layout.ItemNoneCost')
            </div>
            <div class="tools">
                <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                {{--<a href="javascript:;" class="reload" data-original-title="" title=""> </a>--}}
                {{--<a href="javascript:;" class="remove" data-original-title="" title=""> </a>--}}
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                    <tr>
                        <th>
                            <i class="fa  fa-bars"></i> @lang('layout.ReferenceNumber')
                        </th>
                        <th>
                            <i class="fa  fa-bars"></i> @lang('layout.Category')
                        </th>
                        <th>
                            <i class="fa fa-clock-o"></i> @lang('layout.Date')
                        </th>
                        @if(systemConfig()[20] == 1)
                        <th>
                            <i class="fa "></i> @lang('layout.Contract')
                        </th>
                        <th>
                            <i class="fa "></i> @lang('layout.WagonNumber')
                        </th>
                        @endif
                        <th>
                            <i class="fa fa-file-excel-o"></i> @lang('layout.Description')
                        </th>
                    </tr>
                    </thead>
                    <tbody>
                    <tr>
                        <td class=""> {{ $itemNoneCost->ref_no }}  </td>
                        <td class=""> {{$itemNoneCost->category}}  </td>
                        <td class=""> {{ convertDate($itemNoneCost->date) }}</td>
                        @if(systemConfig()[20] == 1)
                        <td class=""> {{$itemNoneCost->company_name}}  </td>
                        <td class=""> {{$itemNoneCost->wagon_number}}  </td>
                        @endif
                        <td class=""> {{ $itemNoneCost->description }}  </td>

                    </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div class="">

        <div class="tabbable tabbable-tabdrop">

            <ul class="nav nav-tabs">
                <li class="active">
                    <a href="#tab1" data-toggle="tab" id="tab_sale">@lang('layout.AdjustmentDetails')</a>
                </li>
                <li class="">
                    <a href="#tab2" data-toggle="tab" id="tab_payment">@lang('layout.Attachments')</a>
                </li>
            </ul>
            <div class="tab-content">
                <div class="tab-pane active" id="tab1">
                    <div class="row">
                        <div class="col-md-12">
                            <!-- BEGIN EXAMPLE TABLE PORTLET-->
                            <div class="portlet light bordered">
                                <div class="portlet-title">
                                    <div class="caption font-dark">
                                        <i class="icon-settings font-dark"></i>
                                        <span class="caption-subject bold uppercase">@lang('layout.AdjustmentDetails')</span>
                                    </div>
                                    <div class="tools"></div>
                                    <div class="actions">
                                        {{Form::open(['route' => 'export.exportCsv','method' => 'DELETE','class' => 'inline'])}}
                                        <input type="hidden" name="type" value="item_none_cost_detail"/>
                                        <input type="hidden" name="id" value="{{$itemNoneCost->id}}"/>
                                        <button type="submit" class="btn btn-success"><i
                                                    class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                                        {{Form::close()}}

                                        {{Form::open(['route' => 'export.PDFAny','method' => 'DELETE','class' => 'inline'])}}
                                        <input type="hidden" name="type" value="item_none_cost_detail"/>
                                        <input type="hidden" name="id" value="{{$itemNoneCost->id}}"/>
                                        <button type="submit" class="btn btn-success"><i
                                                    class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                                        {{Form::close()}}
                                    </div>
                                </div>
                                <div class="portlet-body">
                                    <table class="table table-striped table-bordered table-hover" id="itemNoneCost">
                                        <thead>
                                        <tr>
                                            <th>@lang('layout.ItemName')</th>
                                            <th>@lang('layout.InventoryCategory')</th>
                                            <th>@lang('layout.Site')</th>
                                            <th>@lang('layout.MeasureUnit')</th>
                                            <th>@lang('layout.Quantity')</th>
                                            <th>@lang('layout.Cost')</th>
                                        </tr>
                                        </thead>
                                    </table>
                                </div>
                            </div>
                            <!-- END EXAMPLE TABLE PORTLET-->
                        </div>
                    </div>
                </div>
                <div class="tab-pane" id="tab2">
                    <div class="portlet light bordered">
                        <div class="portlet-title">
                            <div class="caption font-dark">
                                <i class="icon-settings font-dark"></i>
                                <span class="caption-subject bold uppercase">@lang('layout.Attachments')</span>
                            </div>
                        </div>
                        <div class="portlet-body">
                            <div class="portlet light bordered">
                                <div class="portlet-body">

                                    <form role="form" action="{{route('attachment.store')}}" method="post"
                                          enctype="multipart/form-data">

                                        @csrf
                                        <input type="hidden" name="redirect_route" value="itemNoneCost.show">
                                        <input type="hidden" name="foreign_data_id" value="{{$itemNoneCost->id}}">
                                        <input type="hidden" name="path" value="uploads/itemNoneCost">
                                        <input type="hidden" name="table_name" value="item_none_costs">

                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.AttachmentTitle')</label>
                                                    <input type="text" name="title" class="form-control">
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.Description')</label>
                                                    <textarea name="description" class="form-control"></textarea>
                                                </div>
                                            </div>
                                            <div class="col-md-7">
                                                <div class="form-group">
                                                    <div class="fileinput fileinput-new" data-provides="fileinput">
                                                        <div class="fileinput-new thumbnail"
                                                             style="width: 200px; height: 150px;">
                                                            <img src="" alt=""></div>
                                                        <div class="fileinput-preview fileinput-exists thumbnail"
                                                             style="max-width: 200px; max-height: 150px; line-height: 10px;"></div>
                                                        <div>
                                                                    <span class="btn default btn-file">
                                                                        <span class="fileinput-new">@lang('layout.SelectFile')</span>
                                                                        <span class="fileinput-exists">@lang('layout.Change')</span>
                                                                        <input type="hidden" value="" name=""><input
                                                                                type="file" name="photo"> </span>

                                                            <a href="javascript:;" class="btn default fileinput-exists"
                                                               data-dismiss="fileinput"> @lang('layout.Remove') </a>
                                                        </div>

                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="margiv-top-10">
                                            <button type="button" onclick="regForm(this)"
                                                    class="btn green"> @lang('layout.Submit') </button>
                                            <a href="{{route('adjustment.index')}}"
                                               class="btn default">@lang('layout.Cancel')</a>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <table class="table table-striped table-bordered table-hover" id="attachment">
                                <thead>
                                <tr>
                                    <th>@lang('layout.AttachmentTitle')</th>
                                    <th>@lang('layout.Description')</th>
                                    <th>@lang('layout.Action')</th>
                                </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
@endsection
@push('scripts')
    <script>
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#itemNoneCost').DataTable({
                ajax: {
                    url: '{{route("itemNoneCost.show",$itemNoneCost->id)}}',
                    data: {type: 'itemNoneCost'}
                },
                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                columns: [

                    {data: 'item_name', name: 'item_name',orderable: false, searchable: false},
                    {data: 'category_name', name: 'category_name',orderable: false, searchable: false},
                    {data: 'site_name', name: 'site_name',orderable: false, searchable: false},
                    {data: 'selected_measure', name: 'selected_measure',orderable: false, searchable: false},
                    {data: 'quantity', name: 'quatity',orderable: false, searchable: false},
                    {data: 'cost', name: 'cost',orderable: false, searchable: false},
                ]
            });

            $('#attachment').DataTable({
                ajax: {
                    url: '{{route("itemNoneCost.show",$itemNoneCost->id)}}',
                    data: {type: 'attachment'}
                },

                scrollCollapse: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                columns: [

                    {data: 'title', name: 'attachments.title'},
                    {data: 'description', name: 'attachments.description'},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false},
                ]
            });

        });
    </script>


@endpush 