@extends('layouts.factor-master')

@section('content')
    <?php
    $report = customeReport('item_none_cost_detail');
    $_date = true;
    $_description = true;
    $_reference_number = true;
    $_total_amount = true;
    $_total_amount_a = in_array('total_amount', $report);
    ?>

    <h3 class="table-caption" style="text-align: center;">@lang('layout.ItemNoneCostReport')</h3>
    @if($category)
    <p>
        <span>@lang('layout.Category'):{{__('layout.'.ucfirst($category))}}</span>
    </p>
    @endif
    <table class="main-table">
        <thead>
        <tr class="bg">
            <td>
                <div class="center"> #</div>
            </td>
            <td>
                <div class="center">@lang('layout.ID')</div>
            </td>
            @if($_date)
                <td class="center">@lang('layout.Date')</td>@endif
            @if($_description)
                <td class="center">@lang('layout.Description')</td>@endif
            @if($_reference_number)
                <td class="center">@lang('layout.ReferenceNumber')</td>@endif
            @if($_total_amount)
             <td class="center">@lang('layout.Category')</td>@endif
            @if($_total_amount)
             <td class="center">@lang('layout.ItemName')</td>@endif
            @if($_total_amount)
             <td class="center">@lang('layout.InventorySite')</td>@endif
             @if($_total_amount)
             <td class="center">@lang('layout.Measure')</td>@endif
            @if($_total_amount)
             <td class="center">@lang('layout.Quantity')</td>@endif
            @if($_total_amount)
             <td class="center">@lang('layout.Cost')</td>@endif
             <td class="center">@lang('layout.User')</td>
        </tr>
        </thead>
        <?php
        $count = 0;
        ?>
        @foreach($data AS $record)
            <tr>
                <td class="center">{{++$count}}</td>
                <td class="center">{{$record->id}}</td>
                @if($_date)
                    <td class="center">{{convertDate($record->date)}}</td>@endif
                @if($_description)
                    <td class="center">{{$record->description}}</td>@endif
                @if($_reference_number)
                    <td class="center">{{$record->ref_no}}</td>@endif
                @if($_reference_number)
                    <td class="center">{{$record->category}}</td>@endif
                @if($_reference_number)
                    <td class="center">{{$record->item_name}}</td>@endif
                @if($_reference_number)
                    <td class="center">{{$record->site_name}}</td>@endif
                @if($_reference_number)
                    <td class="center">{{$record->measure}}</td>@endif
                @if($_reference_number)
                    <td class="center">{{$record->qut_in}}</td>@endif
                @if($_reference_number)
                    <td class="center">{{$record->cost}}</td>@endif
                    <td class="center">{{$record->user}}</td>
               
            </tr>
        @endforeach
    </table>

@endsection