@extends('layouts.factor-master')

@section('content')
<?php
$report = customeReport('item_expense_detail');
$_name=in_array('name', $report);
$_symbol=in_array('symbol', $report);
$_quantity=in_array('quantity', $report);
$_price=in_array('price', $report);
$_total=in_array('total', $report);
$_otherCost=in_array('otherCost', $report);

?>



<h3 class="table-caption" style="text-align: center;">@lang('layout.ItemExpenseDetail')</h3>
@if($from_date || $to_date)
<table   class="main-table">
  <tr>
    @if($from_date)
   <td>
    <span>@lang('layout.FromDate')</span>:
    <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
  </td>
  @endif
  @if($to_date)
  <td>
    <span>@lang('layout.ToDate')</span>:
    <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
  </td>
  @endif
</tr>
</table>
@endif

@if($expense_category_name  || $expense_type || $type_number)
<table class="main-table" style="margin: 6px 0px;" >
  <tr>
      @if($expense_type)
      <td>
        <span>@lang('layout.Type')</span>: {{__('layout.'.ucfirst($expense_type))}}
      </td>
      @endif
      @if($type_number)
      <td>
        <span>@lang('layout.TypeNumber')</span>: {{$type_number}}
      </td>
      @endif
      @if($expense_category_name)
      <td>
        <span>@lang('menu.ExpenseCategory')</span>: {{$expense_category_name}}
      </td>
      @endif
    </tr>
</table>
@endif

<table class="main-table">
<thead>
  <tr class="bg">
 <td class="center"><div >@lang('layout.Record') </div></td>

 <td class="center"><div > @lang('layout.Type')</div></td>
 <td class="center"><div > @lang('layout.TypeNumber')</div></td>
 <td class="center"><div > @lang('layout.Number')</div></td>
 <td class="center"><div > @lang('layout.Date')</div></td>
 <td class="center"><div > @lang('layout.Member')</div></td>
 <td class="center"><div > @lang('layout.Description')</div></td>
 <td class="center"><div > @lang('layout.Category')</div></td>
 <td class="center"><div > @lang('layout.ItemName')</div></td>
  <td class="center"><div > @lang('layout.Measure')</div></td>
 <td class="center"><div > @lang('layout.Quantity')</div></td>
  <td class="center"><div > @lang('layout.Cost') {{getHomeCurrency()["code"]}}</div></td>
 @foreach($itemExpenseCategory AS $rec)
  <td class="center"><div > {{$rec->name}}</div></td>
 @endforeach
 @if($_total)<td class="center"><div > @lang('layout.Currency')</div></td>@endif
 @if($_total)<td class="center"><div > @lang('layout.Rate')</div></td>@endif
 @if($_total)<td class="center"><div > @lang('layout.Total')</div></td>@endif
 @if($_total)<td class="center"><div > @lang('layout.Total') {{getHomeCurrency()[getCurrencyType()]}}</div></td>@endif


</tr>
</thead>
<?php
$count = 0;
$total_home_currency=0;
$per_category=[];

?>
@foreach($data AS $record)

@if(is_array($record['expense_category_data']))
 
   @foreach($record['expense_category_data'][0] AS $rec)
    <?php
      $sub_total=0;
    ?>
    <tr>
    <td class="center">{{++$count}}</td>
    <td  class="center">{{__('layout.'.ucfirst($record['type']))}}</td>
    <td  class="center">{{$record['type_number']}}</td>
    <td  class="center">{{$record['number']}}</td>
    <td  class="center">{{convertDate($record['date'])}}</td>
    <td  class="center">{{$record['member_name']}}</td>
    <td  class="center">{{$record['description']}}</td>
    <td  class="center">{{__('layout.'.ucfirst($rec['items']['category']))}}</td>
    <td  class="center">{{$rec['items']['name']}}</td>
    <td  class="center">{{$rec['items']['measure']}}</td>

    <td class="center">{{$rec['items']['qut_in']}}</td>
    <td class="center">{{$rec['items']['cost']}}</td>
  
    @if(is_array($rec['itemExpenseCategory']) && count($rec['itemExpenseCategory']) > 0) 
       @foreach($rec['itemExpenseCategory'] AS $cat)
       
       <?php
       $t=$cat['amount'];
       if($rec['items']['category']=='perUnit')
       {
          $t=$t*$rec['items']['qut_in'];
       }
       else
       {
          $t=$t;
       }
       $sub_total+=$t; 

       if(systemConfig()[30] == 1){
         $total_home_currency+=$t/ $record['static_rate'] * $record['rate'];
        }else{
         $total_home_currency+=$t/$record['rate'];
       }
       
 
       if(array_key_exists($cat['name'], $per_category) && $t>0)
       {
        if(systemConfig()[30] == 1){
          $per_category[$cat['name']]=$per_category[$cat['name']]+$t/$record['static_rate'] * $record['rate'];
        }else{
          $per_category[$cat['name']]=$per_category[$cat['name']]+$t/$record['rate'];
        }
      }
      else
      {
        if($t>0)
        {
          if(systemConfig()[30] == 1){
            $per_category[$cat['name']]=$t/ $record['static_rate'] * $record['rate'];
          }else{
            $per_category[$cat['name']]=$t/$record['rate'];
          }
        }
      }

       ?>
        <td><div class="center"> {{$cat['amount']}}</div></td>
       @endforeach
    @else
    @if($record['money_type'] != null && $record['money_type'] != '')
      @foreach($itemExpenseCategory AS $recp)
        <td></td>
      @endforeach
      <?php
      // dd($rec,$rec['items']['totalAmount']);
      $t = $rec['items']['totalAmount'];
      $sub_total+=$t ;
      if(systemConfig()[30] == 1){
        $total_home_currency+=$t/ $record['static_rate'] * $record['rate'];
    }else{
        $total_home_currency+=$t/$record['rate'];
      }

      $cat_name = __('layout.GeneralExpense');

      if(array_key_exists($cat_name, $per_category) && $t>0)
       {
        if(systemConfig()[30] == 1){
          $per_category[$cat_name]=$per_category[$cat_name]+$t/ $record['static_rate'] * $record['rate'];
        }else{
          $per_category[$cat_name]=$per_category[$cat_name]+$t/$record['rate'];
        }
      }
      else
      {
        if($t>0)
        {
          if(systemConfig()[30] == 1){
          $per_category[$cat_name]=$t/ $record['static_rate'] * $record['rate'];
        }else{
            $per_category[$cat_name]=$t/$record['rate'];
          }
        }
      }

      ?>
    @endif  
    @endif  
    @if($_total)<td class="center">{{$record['currency']}}</td>@endif
    @if($_total)<td class="center">{{$record['rate']}}</td>@endif
    @if($_total)<td class="center">{{myRound($sub_total)}}</td>@endif
    @if(systemConfig()[30] == 1)
    @if($_total)<td class="center">{{Currency()->format($sub_total/ $record['static_rate'] * $record['rate'],getHomeCurrency()["code"])}}</td>@endif
    @else 
    @if($_total)<td class="center">{{Currency()->format($sub_total/$record['rate'],getHomeCurrency()["code"])}}</td>@endif
    @endif


    </tr>
   @endforeach

@endif

@endforeach  
</table>


<table class="main-table">
<thead>
  <tr>
  <th>@lang('layout.Name')</th>
  <th>@lang('layout.Amount')</th>
</tr>
</thead>
<tbody>
  <?php 
  $toalExpenses = 0;

  ?>
  @foreach($per_category AS $key=>$value)
  <?php 
    $toalExpenses += $value;
  ?>
  <tr>
    <td>{{$key}}</td>
    <td>{{myRound($value)}} {{getHomeCurrency()[getCurrencyType()]}}</td>
  </tr>
  @endforeach

</tbody>

</table>


<table class="main-table" style="margin-top: 10px;">
  <thead>
    <tr style="background-color: rgb(88, 194, 233);">
      <td style="width: 50%; color: white; font-size: 18px;"> @lang('layout.TotalsExpense') </td>
      <td style="width: 50%; color: white; font-size: 18px;"> {{myRound($toalExpenses)}} {{getHomeCurrency()[getCurrencyType()]}} </td>
    </tr>
  </thead>
</table>

 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->

@endsection
