@extends('layouts.app')
@section('style')
<style>
    .modal-container {
        width: 60% !important;
    }
</style>
@endsection
@section('content')
<!-- END PAGE HEADER-->
<!-- /new modal -->
<div id="print-modal">
    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'item_expense'" @closed="closeModal">
        <div slot="body">
            <!----------------------------------------------
            ----Begin Report Body And Custome Report-------
            ----------------------------------------------->
            <div class="row" v-cloak>
                <div class="tabbable tabbable-tabdrop">
                    <ul class="nav nav-tabs">
                        <li class="active">
                            <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                        </li>
                        @if(systemConfig()[2] != 0 )
                        @permission(['itemexpense-list'])
                        <li class="">
                            <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                        </li>
                        @endpermission
                        @endif
                    </ul>
                    <div class="tab-content">
                        <div class="tab-pane active" id="tab1">
                            <div class="portlet light bordered">
                                <div class="portlet-body">
                                    <div class="row">
                                        <div class="form-group">
                                            <div class="col-md-12">
                                                <div class="row">
                                                    <div class="col-md-6">
                                                        <label class="control-label ">@lang('layout.Type')</label>
                                                        <select name="expense_type" class="form-control">
                                                            <option value="">@lang('layout.SelectType')</option>
                                                            <option value="purchase">@lang('layout.Purchases')</option>
                                                            <option value="build">@lang('layout.Build')</option>
                                                            <option value="inventoryTransfer">@lang('layout.InventoryTransfer')</option>
                                                            <option value="branchTransfer">@lang('layout.BranchTransfer')</option>
                                                        </select>
                                                    </div>
                                                    <div class="col-md-6">
                                                        <label class="control-label ">@lang('layout.Number')</label>
                                                        <input type="number" name="type_number" class="form-control">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <div class="row">
                                                    <div class="col-md-4">
                                                        <label class="control-label ">@lang('menu.ExpenseCategory') </label>
                                                        <select name="category_id" id="" class="form-control">
                                                            <option value="">@lang('layout.SelectCategory')</option>
                                                            @foreach($category as  $rec)
                                                                <option value="{{$rec->id}}">{{$rec->name}}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <label class="control-label ">@lang('layout.Category') </label>
                                                        <select name="ex_category_id" id="" class="form-control">
                                                            <option value="">@lang('layout.SelectCategory')</option>
                                                            @foreach($ex_category as  $rec)
                                                                <option value="{{$rec->id}}">{{$rec->name}}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <label class="control-label ">@lang('layout.Type') </label>
                                                        <div class="input-group">
                                                            <input type="radio" checked name="report_type" value="simple">@lang('layout.Simple')
                                                            <input type="radio" name="report_type" value="detail">@lang('layout.Details')
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="col-md-12">
                                                    <label class="control-label ">@lang('layout.Date')</label>
                                                    <select name="period" v-model="period" @input="getDates()" class="form-control">
                                                        <option value="CustomDates">@lang('type.CustomDates')</option>
                                                        <option value="Today">@lang('type.Today')</option>
                                                        <option value="Yesterday">@lang('type.Yesterday')</option>
                                                        <option value="ThisWeek">@lang('type.ThisWeek')</option>
                                                        <option value="LastWeek">@lang('type.LastWeek')</option>
                                                        <option value="WeekToDate">@lang('type.WeekToDate')</option>
                                                        <option value="ThisMonth">@lang('type.ThisMonth')</option>
                                                        <option value="MonthToDate">@lang('type.MonthToDate')</option>
                                                        <option value="ThisQuarter">@lang('type.ThisQuarter')</option>
                                                        <option value="QuarterToDate">@lang('type.QuarterToDate')</option>
                                                        <option value="ThisYear">@lang('type.ThisYear')</option>
                                                        <option value="YearToDate">@lang('type.YearToDate')</option>
                                                    </select>
                                                </div>
                                                <div class="col-md-12" v-show="period == 'CustomDates'">
                                                    <div class="form-group">
                                                        <label class="control-label"> @lang('layout.Date')</label>
                                                        <div class="input-group">
                                                            <input class="form-control date" id="range-from-example" v-model="from_date" name="from_date" autocomplete="off">
                                                            <span class="input-group-addon"> @lang('layout.To') </span>
                                                            <input class="form-control date" id="range-to-example" v-model="to_date" name="to_date" autocomplete="off">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>                                                                     
                        <div class="tab-pane" id="tab2">
                            <div class="portlet light bordered">
                                <div class="portlet-body">
                                    <form id="saveCustomeReport" role="form"
                                        action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                        @csrf
                                        <input type="hidden" name="part_name" value="item_expense">
                                        <div class="col-md-12 col-sm-12 col-xs-12">
                                            <div class="mt-checkbox-inline col-md-2" style="padding: 0px;" v-for="(row,itemIndex) in customReportData">
                                                <div class="form-group">
                                                    <table class="table table-striped table-bordered table-advance table-hover">
                                                        <tr>
                                                            <td style="text-align: center;">@{{ row.Name }}</td>
                                                        </tr>
                                                        <tr>
                                                            <td style="text-align: center;">
                                                                <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
                                                                <label class="switch">
                                                                    <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                    :checked="row.checkedColumn" >
                                                                    <span class="slider round"></span>
                                                                </label>
                                                                <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                    <option value="">@lang('layout.Select')</option>
                                                                    <option value="2">2 %</option>
                                                                    <option value="6">6 %</option>
                                                                    <option value="10">10 %</option>
                                                                    <option value="15">15 %</option>
                                                                    <option value="20">20 %</option>
                                                                    <option value="25">25 %</option>
                                                                    <option value="30">30 %</option>
                                                                    <option value="40">40 %</option>
                                                                    <option value="50">50 %</option>
                                                                    <option value="60">60 %</option>
                                                                </select>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="margiv-top-10">
                                            <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->
                                            <button type="button" onclick="saveCustomeReport(this)" class="btn blue"> 
                                                <i class="fa fa-save"></i> 
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </report-modal>
</div>
<!-- BEGIN TAB PORTLET-->
<div class="row">
    <!-- app -->
    <!-- BEGIN EXAMPLE TABLE PORTLET-->
    <div class="portlet light bortdered">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>
                <span class="caption-subject bold uppercase">@lang('layout.ItemExpense')</span>
            </div>
            <div class="tools"></div>
            <div class="pull-right">
                @permission('itemexpense-export')
                <span id="anchore-modal">
                    <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                        <i class="fa fa-print"></i>
                    </a>
                </span>
                @endpermission
                @permission('itemexpense-create')
                <a href="{{route('itemExpense.create')}}">
                    <!-- <button id="sample_editable_1_new" class="btn green btn-sm btn-outline"> -->
                    <button id="sample_editable_1_new" class="btn btn-success">
                        <i class="fa fa-plus"></i> @lang('layout.AddNew')
                    </button>
                </a>
                <a href="{{route('itemExpense.createTotal')}}">
                    <button id="sample_editable_1_new" class="btn btn-success">
                        <i class="fa fa-plus"></i> @lang('layout.AddNewTotal')
                    </button>
                </a>
                @endpermission
            </div>
        </div>
        <div class="portlet-body">
            <template v-cloak id="company_all">
                <company @company="setCompany"></company>
            </template>
            <table class="table table-striped table-bordered table-hover" id="itemExpense">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>@lang('layout.Type')</th>
                        <th>@lang('layout.Number')</th>
                        <th>@lang('layout.ExpenseType')</th>
                        <th>@lang('layout.Currency')</th>
                        <th>@lang('layout.Rate')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.Hour')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
    <!-- END EXAMPLE TABLE PORTLET-->
</div>
<!-- END TAB PORTLET-->
<!-- END CONTENT BODY -->
@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')
    <script>
        Vue.component("v-select", VueSelect.VueSelect);

         //GRN Print
        // grnPrint("{{Session('sale_id')}}")

        Vue.component('v-select', VueSelect.VueSelect)

        function factorPrint(id,sendWhatsapp = null,type = null) {
            if (sendWhatsapp == null || sendWhatsapp == '') {
                sendWhatsapp = 'not';
            }
            if (type == null || type == '') {
                type = 1;
            }
            var a = document.createElement('a');
            a.href = "{{url('printItemExpense')}}/" + id + "/" + sendWhatsapp + "/" + type;
            a.target = "_blank";
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
        }

        var cust_rep = {!!customeReportNewData('item_expense')!!};
        let data_table;
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            data_table =$('#itemExpense').DataTable({
                ajax: '{{route("itemExpense.index")}}',
                pageLength:'{{getPageRows()}}',
                order: [["{{orderByColumn()=='number'?0:5}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                paging: true,
                serverSide: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
                    {data: 'number', name: 'item_expenses.number'},
                    {data: 'type', name: 'item_expenses.type', searchable: false},
                    {data: 'part_number', name: 'item_expenses.part_number'},
                    {data: 'expense_type', name: 'expense_type', orderable: false, searchable: false},
                    {data: 'currency', name: 'item_expenses.currency'},
                    {data: 'rate', name: 'item_expenses.rate', orderable: false, searchable: false},
                    {data: 'date', name: 'item_expenses.date', searchable: false},
                    {data: 'hour', name: 'purchases.hour', searchable: false},
                    {data: 'description', name: 'item_expenses.description'},
                    {data: 'user', name: 'users.name'},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false}
                ]
            });
        });
        var vm = new Vue({
            el: '#print-modal',
            data: {
                period: 'CustomDates',
                from_date: null,
                to_date: null,
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',
                customReportData:
                [
                 {Name: '@lang("layout.Record")', column_name: 'record',checkedColumn:(cust_rep.record)?'checked':'',column_percentage:(cust_rep.record___percent)?cust_rep.record___percent:''},
                 {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_rep.date)?'checked':'',column_percentage:(cust_rep.date___percent)?cust_rep.date___percent:''},
                 {Name: '@lang("layout.Hour")', column_name: 'hour',checkedColumn:(cust_rep.hour)?'checked':'',column_percentage:(cust_rep.hour___percent)?cust_rep.hour___percent:''},
                 {Name: '@lang("layout.Member")', column_name: 'member',checkedColumn:(cust_rep.member)?'checked':'',column_percentage:(cust_rep.member___percent)?cust_rep.member___percent:''},
                 {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_rep.description)?'checked':'',column_percentage:(cust_rep.description___percent)?cust_rep.description___percent:''},
                 {Name: '@lang("layout.Type")', column_name: 'type',checkedColumn:(cust_rep.type)?'checked':'',column_percentage:(cust_rep.type___percent)?cust_rep.type___percent:''},
                 {Name: '@lang("layout.TypeNumber")', column_name: 'type_number',checkedColumn:(cust_rep.type_number)?'checked':'',column_percentage:(cust_rep.type_number___percent)?cust_rep.type_number___percent:''},
                 {Name: '@lang("layout.ExpenseType")', column_name: 'expense_type',checkedColumn:(cust_rep.expense_type)?'checked':'',column_percentage:(cust_rep.expense_type___percent)?cust_rep.expense_type___percent:''},
                 {Name: '@lang("layout.Category")', column_name: 'category',checkedColumn:(cust_rep.category)?'checked':'',column_percentage:(cust_rep.category___percent)?cust_rep.category___percent:''},
                 {Name: '@lang("layout.Currency")', column_name: 'currency',checkedColumn:(cust_rep.currency)?'checked':'',column_percentage:(cust_rep.currency___percent)?cust_rep.currency___percent:''},
                 {Name: '@lang("layout.Rate")', column_name: 'rate',checkedColumn:(cust_rep.rate)?'checked':'',column_percentage:(cust_rep.rate___percent)?cust_rep.rate___percent:''},
                 {Name: '@lang("layout.Total")', column_name: 'total',checkedColumn:(cust_rep.total)?'checked':'',column_percentage:(cust_rep.total___percent)?cust_rep.total___percent:''},
                 {Name: '@lang("layout.User")', column_name: 'user',checkedColumn:(cust_rep.user)?'checked':'',column_percentage:(cust_rep.user___percent)?cust_rep.user___percent:''},
                 {Name: '@lang("layout.Total")', column_name: 'total',checkedColumn:(cust_rep.total)?'checked':'',column_percentage:(cust_rep.total___percent)?cust_rep.total___percent:''},
                ],
                cust_rep:cust_rep
            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },
                //ajax call to get dates
                getDates() {
                    setTimeout((function () {
                    vm.getDate(vm.period);
                        // console.log(12);
                    }), 2e2);
                },
                getDate(period) {
                    if (period) {
                    // console.log(3232, period);
                    if (period != 'CustomDates') {
                        axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'getDatesByPeriod',
                            period: period,
                        }
                        })
                        .then(function(response) {
                        vm.from_date = null;
                        vm.to_date = null;
                        if (response.data) {
                            vm.from_date = response.data.start;
                            vm.to_date = response.data.end;
                            // console.log('data', response.data);
                        }
                        })
                        .catch(function(error) {
                        vm.period = 'CustomDates';
                        vm.from_date = null;
                        vm.to_date = null;
                        })
                    } else {
                        vm.from_date = null;
                        vm.to_date = null;
                    }
                    }
                },
            }
        });
        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;
                }
            }
        });
        new Vue({
            el: '#company_all',
            methods: {
                setCompany: function (event) {
                   if (typeof data_table == 'object'){
                       data_table.clear();
                       data_table.ajax.reload();
                   }
                }
            }
        });
    </script>
@endpush