@extends('layouts.factor-master')

@section('content')
<?php
$report = customeReport('item_expense_detail');
$_name=in_array('name', $report);
$_symbol=in_array('symbol', $report);
$_quantity=in_array('quantity', $report);
$_price=in_array('price', $report);
$_total=in_array('total', $report);
$_otherCost=in_array('otherCost', $report);
$rate = 1;
$static_rate = 1;
?>
<h4></h4>
<table class="main-table">
 @if($info && $info !=[])
 <?php
 $rate = ($info->rate > 0)?$info->rate:1;
 $static_rate = ($info->static_rate > 0)?$info->static_rate:1;
 ?>
 <tr>
  <td>
    <span>@lang('layout.Number')</span>:
    <span>{{$info->number}}</span>
  </td>
  <td>
    <span>@lang('layout.Type')</span>:
    <span>{{__('layout.'.ucfirst($info->type))}}</span>
  </td>
<td>
    <span>@lang('layout.TypeNumber')</span>:
    <span>{{$info->type_number}}</span>
  </td>
<td>
    <span>@lang('layout.Date')</span>:
    <span>{{ convertDate($info->date)}}</span>
  </td>
 
</tr>
<tr>

 <td>
  <span>@lang('layout.Account')</span>:
  <span>{{$info->account_name}}</span>
</td>
 <td>
  <span>@lang('layout.Amount')</span>:
  <span>{{$info->amount}}</span>
</td>
 <td>
  <span>@lang('layout.Currency')</span>:
  <span>{{$info->currency}}</span>
</td>
 <td>
  <span>@lang('layout.Rate')</span>:
  <span>{{$info->rate}}</span>
</td>

</tr>
@endif
</table>


<h3 class="table-caption" style="text-align: center;">@lang('layout.ItemExpenseDetail')</h3>
@if(count($item_expense_detail))

<table class="main-table">

<thead>
  <tr class="bg">
 <td class="center" ><div > @lang('layout.Record') </div></td>

 <td class="center" ><div > @lang('layout.Category')</div></td>
 <td class="center" ><div > @lang('layout.ItemName')</div></td>
  <td class="center" ><div > @lang('layout.Measure')</div></td>
 <td class="center" ><div > @lang('layout.Quantity')</div></td>
 @foreach($itemExpenseCategory AS $cat)
  <td class="center" ><div > {{$cat->name}}</div></td>
 @endforeach
 @if($_total)<td class="center" ><div > @lang('layout.UnitPrice')</div></td>@endif
 @if($_total)<td class="center" ><div > @lang('layout.Total')</div></td>@endif


</tr>
</thead>
<?php
$count = 0;
$home_currency_total=0;

?>
@foreach($item_expense_detail AS $record)
<?php

$sub_total=0;
$sub_total1=0;

if($record['items']['category'] != null){

?>
<tr>
<td class="center">{{++$count}}</td>
<td  class="center">{{__('layout.'.ucfirst($record['items']['category']))}}</td>
<td  class="center">{{$record['items']['name']}}</td>
<td  class="center">{{$record['items']['measure']}}</td>

<td  class="center">{{$record['items']['qut_in']}}</td>

@foreach($record['itemExpenseCategory'] AS $cat)
<?php

      
       $t=$cat['amount'];
       $t1=$cat['amount'];
       $t2=$cat['amount'];
       if($record['items']['category']=='perUnit')
       {
          // $t=$t*$record['items']['qut_in'];
          $t2=$t2*$record['items']['qut_in'];
       }
       else
       {
          $t=$t/$record['items']['qut_in'];
       }
       $sub_total+=$t;
       $sub_total1+=$t2;
       $home_currency_total+=$t2;
?>
<td  class="center">{{myRound($t1)}}</td>
@endforeach
@if($_total)<td class="center">{{myRound($sub_total)}}</td>@endif
@if($_total)<td class="center">{{$sub_total1}}</td>@endif


</tr>
      <?php } ?>
@endforeach  
</table>
@if(systemConfig()[30] == 1)
<p>
{{myRound(($home_currency_total > 0)?($home_currency_total/ $static_rate * $rate):0)}} {{getHomeCurrency()[getCurrencyType()]}}
</p>
@else 
<p>
{{myRound(($home_currency_total > 0)?($home_currency_total/$rate):0)}} {{getHomeCurrency()[getCurrencyType()]}}
</p>
@endif
@else

<table class="main-table">

<thead>
  <tr class="bg">
 <td class="center" ><div > @lang('layout.Record') </div></td>
 <th class="center" >@lang('layout.FromDate')</th>
 <th class="center" >@lang('layout.ToDate')</th>
 <th class="center" >@lang('layout.Day')</th>
 <th class="center" >@lang('layout.RemoveDays')</th>
 <td class="center" ><div > @lang('layout.Category')</div></td>
 <td class="center" ><div > @lang('layout.CategoryName')</div></td>
 <td class="center" ><div > @lang('layout.ItemName')</div></td>
 @if(systemConfig()[9] == 1 )
  <td class="center" ><div > @lang('layout.Code')</div></td>
@endif
  <td class="center" ><div > @lang('layout.Measure')</div></td>
 <td class="center" ><div > @lang('layout.Quantity')</div></td>
 @if($_total)<td class="center" ><div > @lang('layout.Total')</div></td>@endif


</tr>
</thead>
<?php
$count = 0;

?>
@foreach($data AS $record)
<tr>
<td class="center">{{++$count}}</td>
<td  class="center">{{($record->from_date)?convertDate($record->from_date):null}}</td>
<td  class="center">{{($record->to_date)?convertDate($record->to_date):null}}</td>
<td  class="center">{{$record->holdingDays}}</td>
<td  class="center">{{$record->remove_days}}</td>
<td  class="center">{{__('layout.'.ucfirst($record->category))}}</td>
<td  class="center">{{$record->category_name}}</td>
<td  class="center">{{$record->item_name}}</td>
@if(systemConfig()[9] == 1 )
<td  class="center">{{$record->code}}</td>
@endif
<td  class="center">{{$record->measure_name}}</td>

<td  class="center">{{$record->quantity}}</td>
@if($_total)<td class="center">{{myRound($record->total)}}</td>@endif


</tr>
@endforeach  
</table>

@endif

 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->

@endsection