@extends('layouts.app')
@section('content')
    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.ItemExpenseCategoryList')</span>
                </div>
                <div class="tools"></div>
                <div class="btn-group pull-right">
                    <span id="print-modal">
                        <a href="#" @click.prevent="is_show_modal = !is_show_modal" class="btn  btn-success">
                            <i class="fa fa-print"></i>
                        </a>

                        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show_modal"  :value-type="'item_expense_cagories_all'" @closed="closeModal">
                        </report-modal>
                    </span>

                    @permission('itemExpenseCategory-create')
                    <a href="{{route('itemExpenseCategory.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission
                </div>
            </div>
            <div class="portlet-body" id="app" v-cloak>
                <table class="table table-striped table-bordered table-hover" cellspacing="0" id="itemExpenseCategory">
                     <thead>
                     <tr>
                         <th>#</th>
                         <th>@lang('layout.Name')</th>
                         <th>@lang('layout.Amount')</th>
                         <th>@lang('layout.CreatedAt')</th>
                         <th>@lang('layout.Actions')</th>
                     </tr>
                     </thead>
                 </table>

                <!-- <div class="col-md-12">
                    <div class="row">
                        <div class="col-sm-6">
                            <select class="form-control" style="width: 100px"
                                    v-model="tableData.length"
                                    @change="fetchData()">
                                <option v-for="(records, index) in perPage"
                                        :key="index"
                                        :value="records">
                                    @{{records}}
                                </option>
                            </select>
                        </div>
                        <div class="col-sm-6">
                            <input type="text" v-model="tableData.search" style="width: 200px;float: left"
                                   class="form-control form-control-primary"
                                   placeholder="@lang('layout.Search')"
                                   @keyup="fetchData()">
                        </div>
                    </div>
                </div>

                <div class="col-md-12">
                    <datatable :columns="columns" :sort-key="sortKey"
                               :sort-orders="sortOrders" @sort="sortBy">
                      
                        <template v-if="itemExpense.data.length">
                            <tr v-for="item in itemExpense.data">
                                <td>
                                    @{{ item.id }}
                                </td>
                                <td>
                                    @{{ item.name }}
                                </td>
                                <td class="number-field">
                                    @{{ item.created_at }}
                                </td>
                                <td>
                                    @if(\Entrust::can('itemExpenseCategory-edit'))
                                        <a :href="`{{url('/')}}/itemExpenseCategory/${item.id}/edit`"
                                           class="btn btn-primary"
                                           role="button"
                                           
                                           >
                                            <i class="fa fa-pencil"></i>
                                        </a>
                                    @endif

                                    @if(\Entrust::can('itemExpenseCategory-delete'))
                                        <button type="button" @click="deleteRecord(item.id)" class="btn btn-danger "
                                                role="button">
                                            <span class="fa fa-times"></span>
                                        </button>
                                    @endif
                                </td>
                            </tr>
                        </template>
                      
                    </datatable>
                </div>
                <div class="col-md-12">
                    <div>
                        asd
                        <pagination :data="itemExpense"  
                                    @pagination-change-page="fetchData"></pagination>
                    </div>
                </div> -->

            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>

    <!-- END TAB PORTLET-->
    <!-- END CONTENT BODY -->

@stop
@include('datatable.datatable')
@include('print.modal')
@push('scripts')
    <script>
        //Vue.component('pagination',require('laravel-vue-pagination'));

        // Vue.component('pagination',pagination)
        $(document).ready(function() { 
        $('#itemExpenseCategory').DataTable( {
        ajax:           '{{route("itemExpenseCategory.index")}}',
        pageLength:'{{getPageRows()}}',
        scrollCollapse: true,
        serverSide: true,
        paging:         true,
        columns: [
        { data: 'id', name: 'id' },
        { data: 'name', name: 'name' },
        { data: 'amount', name: 'amount' },
        { data: 'created_at', name: 'created_at' },
        { data: 'actions', name: 'actions' ,orderable:false,searchable:false },

        ] 
        }); 
        });

        new Vue({
            el: '#app',
            data() {
                let sortOrders = {};
                let columns = [
                    {label: '#', name: '#'},
                    {label: '@lang('layout.Name')', name: 'name'},
                    {label: '@lang("layout.CreatedAt")', name: 'created_at'},
                    {label: '@lang("layout.Actions")', name: 'id'}
                ];
                columns.forEach((column) => {
                    sortOrders[column.name] = -1;
                });

                return {
                    sortKey: 'id',
                    columns: columns,
                    sortOrders: sortOrders,
                    perPage: [10, 20, 30],
                    tableData: {
                        draw: 0,
                        length: 10,
                        search: '',
                        column: 0,
                        dir: 'desc'
                    },
                    itemExpense: {data: []}
                }

            },
            methods: {
                sortBy(key) {
                    this.sortKey = key;
                    this.sortOrders[key] = this.sortOrders[key] * -1;
                    this.tableData.column = this.getIndex(this.columns, 'name', key);
                    this.tableData.dir = this.sortOrders[key] == 1 ? 'asc' : 'desc';
                    this.fetchData();
                },
                getIndex(array, key, value) {
                    return array.findIndex(i => i[key] == value)
                },
                fetchData(page = 1) {
                    this.tableData.draw = this.tableData.draw + 1;
                    axios.get('{{route("itemExpenseCategory.index")}}?page=' + page, {params: this.tableData})
                        .then((response) => {
                            if (this.tableData.draw == response.data.draw) {
                                this.itemExpense = response.data.itemExpense;
                                console.log('length', this.itemExpense)
                            }
                        })
                },
                deleteRecord(id) {

                    if (confirm('@lang('message.DeleteMessage')')) {
                        axios.post('{!! url('/') !!}/itemExpenseCategory/' + id, {
                            _method: 'DELETE',
                            _token: '{!!  csrf_token() !!}'
                        })
                            .then((response) => {
                                this.fetchData()
                            });
                    }

                },

            },
            created() {
                this.fetchData();
            }
        });

        var print = new Vue({
            el: '#print-modal',
            data:{
                is_show_modal: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}'
            },
    
            methods:{
                closeModal: function(){
                    print.is_show_modal = !print.is_show_modal;
                }
            }
        });

    </script>


@endpush
