@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('style')

    <style>


    </style>
@stop
@section('content')
    @include("layouts.Cmodal")
    @include("invoices.modal")

    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.EditAdjustment') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                </div>
            </div>
            <div id="appInvoice" v-cloak class="portlet-body form" style="margin-bottom:50%;">
                {{Form::model($adjustment,['route' => ['adjustment.update',$adjustment->id],'method' => 'PATCH','class' => 'form-horizontal','id'=>'sales-form'])}}
                <div class="form-body">
                    <div class="row">
                        <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12">
                            <!-- begin inputs -->
                            <div class="row">
                                <p style="color: red">@lang('layout.Note'): @lang('layout.AdjustmentNote')</p>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.ReferenceNumber')</label>
                                            {{Form::number('ref_no',null,['class' => 'form-control' ,'step' => 'any','min' =>'0'])}}

                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Date')</label>
                                            {{Form::text('date',null,['class' => 'form-control date' ,'step' => 'any','min' =>'0','autocomplete'=>'off'])}}
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Account')</label>
                                            <v-select label="name" v-model="selected_account"
                                                      :options="accounts"></v-select>
                                            <input type="hidden" name="account_id"
                                                   :value="(selected_account)?selected_account.id:null">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Category')</label>

                                            <select class="form-control" name="category" v-model="category">
                                                <option value="adjustment">@lang('layout.Adjustment')</option>
                                                <option value="repair">@lang('layout.Repair')</option>
                                                <option value="minorUse">@lang('layout.MinorUse')</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-lg-8 col-md-9 col-sm-12 col-xs-12">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label">@lang('layout.Description')</label>
                                            {!! Form::textarea('description', null, array('placeholder' => __('layout.Description'),'class' => 'form-control','rows' => 3)) !!}

                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- end inputs -->
                        </div>
                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                            <!-- begin total -->
                            <div class="dashboard-stat2 ">
                                <table class="dashboard-tabel" width="100%">
                                    <tr>
                                        <td>
                                            <small>@lang('layout.Total') :</small>
                                        </td>
                                        <td class="text-right"><span data-counter="counterup"
                                                                     data-value="7800">@{{ Number.parseFloat((subtotal))}}</span>
                                        </td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>

                    <div class="row" v-if="inventories.length>0" style="overflow-x: scroll;">
                        <table id="table_content" class="table table-bordered table-advance">
                            <thead>
                            <tr>
                                <th class="text-center" style="min-width: 8px;"> #</th>
                                <th v-show="showWhat('sale_category')=='yes'"
                                    style="min-width: 130px">@lang('layout.Category') </th>
                                <th class="text-center" style="min-width: 160px;">@lang('layout.ItemName')</th>
                                <th class="text-center" style="min-width: 120px;">@lang('layout.SiteName') </th>
                                <th class="text-center" style="min-width: 80px;"> @lang('layout.Westage')</th>
                                <th v-show="showWhat('other_measure')=='yes'"
                                    style="min-width: 80px">@lang('layout.OMeasureValue') 1
                                </th>
                                <th v-show="showWhat('other_measure')=='yes'"
                                    style="min-width: 80px">@lang('layout.OMeasureValue') 2
                                </th>
                                <th class="text-center" style="min-width: 60px;"> @lang('layout.OnHand')</th>
                                <th class="text-center" style="min-width: 120px;"> @lang('layout.Measure')</th>
                                <th class="text-center" style="min-width: 40px;"> @lang('layout.Price')</th>
                                <th class="text-center" style="min-width: 40px;">@lang('layout.Total')</th>
                                <th style="min-width: 20px;"></th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr v-for="(item,index) in inventories">
                                <td @click="addNew('inventory',index)">@{{index+1}}</td>
                                <td @click="addNew('inventory',index)" v-show="showWhat('sale_category')=='yes'">
                                    <v-select label="name" v-model="item.item_category" :options="inventory_category"
                                              @input="itemCategoryChange(index)"></v-select>
                                    <input type="hidden" name="inventory_category_id[]"
                                           :value="(!item.item_category)?null:item.item_category.id">
                                </td>
                                <td @click="addNew('inventory',index)" class="highlight">
                                    <v-select label="name" @keyup.native="onItemload(index)"
                                              @Click.native="onItemload
                                              (index)"
                                              v-model="item.inventory" :options="temp_items"
                                              @search="onItemSearch"></v-select>
                                    <input type="hidden" name="item[]" :value="(!item.item)?null:item.item.id">

                                </td>
                                <td class="highlight">
                                    <select v-model="(item.item==null)?null:item.item.site" class="form-control">
                                        <option value="null">@lang('layout.Select')</option>
                                        <span v-if="(item.item != null)">
                                          <option v-for="site in (item.item==null)?null:item.item.site_list"
                                                  :value="site">
                                            @{{site.site_name}}
                                          </option> 
                                        </span>
                                    </select>

                                    <input type="hidden" name="from_site[]"
                                           :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.site_id)">
                                </td>

                                <td>
                                    <input type="number" name="quantity[]"
                                           v-model.number="(item.item==null)?null:item.item.quantity"
                                           
                                           class="form-control input-style input-number"
                                           placeholder="@lang('layout.Quantity')">
                                </td>
                                <td v-show="showWhat('other_measure')=='yes'">
                                    <input type="number" name="other_measure_amount[]"
                                           v-model.number="(item.item==null)?null:item.item.other_measure"
                                           class="form-control input-style input-number"
                                           placeholder="@lang('layout.OMeasureValue')">
                                </td>
                                <td v-show="showWhat('other_measure')=='yes'">
                                    <input type="number" name="other_measure_amount2[]"
                                           v-model.number="(item.item==null)?null:item.item.other_measure2"
                                           class="form-control input-style input-number"
                                           placeholder="@lang('layout.OMeasureValue')">
                                </td>
                                <td>

                                    @{{myRound((item.item==null)?null:saleItemQuantity(item.item,item.item.quantity))}}
                                </td>
                                <td class="highlight">


                                    <select v-model="(item.item == null)?null:item.item.measure" class="form-control"
                                            @change="measureChange(index)">
                                        <option value="null">@lang('layout.Select')</option>
                                        <span v-if="(item.item ==null)?false:true">
                                        <option v-for="measure in (item.item==null)?null:item.item.measure_list"
                                                :value="measure">
                                          @{{measure.measure_name}}
                                        </option> 
                                      </span>


                                    </select>
                                    <input type="hidden" name="inventory_measure[]"
                                           :value="(item.item==null)?null:item.item.measure.measure_id">


                                </td>

                                <td>
                                    <div class="input-group">
                                        <input type="number" name="cost[]" placeholder="@lang('layout.Cost')"
                                               @click="addNew('inventory',index)"
                                               :value="(item.item==null)?null:(item.item.cost)" ref="in"
                                               @input="setNewRate('inventory',index)" class="form-control" readonly>
                                    </div>

                                </td>
                                <td>
                                    <div class="input-group">
                                        <input type="number" class="form-control inner_input"
                                               :value="(item.item==null)?null:getItemTotal(item.item,1)"
                                               placeholder="@lang('layout.Total')" disabled>

                                    </div>
                                </td>
                                <td>
                                    <span v-on:click="deleteItem('inventory',index)"><i
                                                class="paddint-both glyphicon glyphicon-trash"></i></span>

                                </td>
                            </tr>
                            </tbody>
                        </table>

                        <hr>
                        <!-- begin service -->

                        <!-- end service -->
                        <hr>
                        <!-- begin payments -->

                        <!-- end payments -->
                    </div>
                    <button v-if="inventories.length <= 0 " type="button" class="btn default"
                            @click="addNew('inventory',0)">@lang('layout.AddItem')
                    </button>

                    <div class="row">
                        <div class="col-md-offset-3 col-md-9">
                            <button v-if="!isError" type="button" onclick="regForm(this)"
                                    class="btn green">@lang('layout.Submit')</button>
                            <a href="{{route('adjustment.index')}}" class="btn default"><i
                                        class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>

                        </div>
                    </div>


                </div>

                {!! Form::close() !!}

            </div>
            <!-- END FORM-->
        </div>
    </div>

@endsection
@push('scripts')


    <script type="text/javascript">
        Vue.component('v-select', VueSelect.VueSelect);

        var selected_item =
                {!!$selectedItems!!}
        var inventory_category = {!! $inventory_category !!};
        var accounts = {!! $accounts !!};
        var adjustment = {!! $adjustment !!};

        // end new member

        var v = new Vue({
            el: '#appInvoice',
            data: {
                temp_items: [],
                selected_item: selected_item,
                inventory_category: inventory_category,
                selected_index: 0,
                selected_iventory_category: null,
               
                inventories: [],
                accounts: accounts,
                selected_account: null,
                adjustment: adjustment,
                category:'adjustment'

            },
            computed: {


                // calculate subtotal
                subtotal: function () {
                    var sum = 0;
                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].item && this.inventories[i].item != null) {
                            var quantity = this.inventories[i]['item']['quantity'];
                            var rate = this.inventories[i]['item']['rate'];
                            var new_rate = this.inventories[i]['item']['cost'];
                            var smeasure_unit = this.inventories[i]['item']['measure']['measure_unit'];
                            var measure_unit = this.inventories[i]['item']['measure_unit'];
                            if (new_rate != rate && quantity > 0) {
                                sum += new_rate * quantity;
                            }
                            else {
                                sum += quantity * ((rate * smeasure_unit / measure_unit));
                            }

                        }

                    }

                    return sum;
                },

                // check data validation
                isError: function () {
                    var isError = false;
                    var flag = false;
                    for (var i = 0; i < this.inventories.length; i++) {

                        if (this.inventories[i].item) {
                            flag = true;
                            if (((this.inventories[i]['item']['rate'] <= 0))) {
                                rate = this.inventories[i]['item']['rate'];
                                new_rate = this.inventories[i]['item']['price'];
                                if (rate <= 0 && new_rate <= 0) {
                                    // isError = true;
                                }

                            }
                        }
                    }
                    if (this.inventories.length == 0 || flag == false) {
                        isError = true;
                    }
                    return isError;


                },
            },
            mounted: function () {
                // initialize the selected item
                if (this.adjustment) {
                    this.category=this.adjustment.category;
                    for (var i = 0; i < this.selected_item.length; i++) {

                        this.inventories.push({
                            item: this.selected_item[i],
                            inventory: this.selected_item[i],
                            item_category: this.selected_item[i].item_category
                        });
                    }
                    for (var m = 4; m > this.selected_item.length; m--) {
                        this.inventories.push({item: null});
                    }
                    this.selected_account = _.find(this.accounts, (a) => a.id == this.adjustment.account_id);

                }
            },
            methods:
                {
                    // set new price
                    setNewRate(type = null, index) {
                        if (type == 'inventory') {
                            if (this.inventories[index].item) {
                                this.inventories[index].item.price = this.$refs.in[index].value;
                            }
                        }

                    },
                    // calculate item price based on measure change
                    measureChange(index) {

                        if (this.inventories[index].item != null) {
                            var item = this.inventories[index].item;

                            var temp = ((item.rate * item.measure.measure_unit / item.measure_unit));
                            result = Number.parseFloat(temp).toFixed(precision());

                            this.inventories[index].item.new_rate = result;

                            // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;

                        }
                    },

                    // calculate item price based on measure change

                    // detect member change and searh


                    // sale order change

                     onItemSearch: _.debounce((search, loading) => {

                        loading(true);
                        let inventory_category_id = (v.inventories[v.selected_index]['item_category'] != undefined) ? v.inventories[v.selected_index]['item_category'].id : '';

                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                member_id: v.member_id,
                                method_name: 'itemesSearchSale',
                                keyword: search,
                                inventory_category_id: inventory_category_id,
                            }
                        })
                            .then(function (response) {
                                v.temp_items = [];
                                if (response.data.length > 0) {
                                    v.temp_items = response.data;
                                }
                                loading(false);
                            })
                            .catch(function (error) {
                                console.log(error);
                            })
                    }, getDebounceTime()),

                    onItemload(index) {
                        v.selected_index = index;
                        if (v.inventories[index].inventory != null) {
                            // console.log('klk',v.inventories[index].inventory,v.inventories);
                            var inventory_id = v.inventories[index].inventory.id;
                            let inventory_category_id = (v.inventories[index]['item_category'] != undefined) ? v.inventories[index]['item_category'].id : '';

                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    member_id: v.member_id,
                                    method_name: 'itemSearchSale',
                                    inventory_id: inventory_id,
                                    inventory_category_id: inventory_category_id,
                                }
                            })
                                .then(function (response) {
                                    v.inventories[index].item = null;
                                    if (response.data.length > 0) {
                                        v.inventories[index].item = response.data[0];
                                    }
                                })
                                .catch(function (error) {
                                    console.log(error);
                                })
                        }
                    },

                    // end item search

                    // contract search

                    //ajax call to get items
                    setIndex(e) {
                        //v.temp_items=[];
                        this.selected_index = e;
                    },

                    itemCategoryChange(index) {
                        v.setIndex(index);
                        v.selected_iventory_category = this.inventories[this.selected_index]['item_category'];
                        if (this.inventories[this.selected_index]['item_category'] != null) {
                            let inventory_category_id = (v.inventories[v.selected_index]['item_category'] != undefined) ? v.inventories[v.selected_index]['item_category'].id : '';

                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    member_id: v.member_id,
                                    method_name: 'itemesSearchSale',
                                    inventory_category_id: inventory_category_id
                                }
                            })
                                .then(function (response) {
                                    v.temp_items = [];
                                    if (response.data.length > 0) {
                                        v.temp_items = response.data;
                                    }
                                })
                                .catch(function (error) {
                                    console.log(error);
                                });
                        }

                    },


                    // end contract search

                    // generic function for adding item to list
                    addNew(type = null, index) {
                        this.temp_items = [];
                        if (type != null) {
                            if (type == 'inventory') {
                                if (this.inventories[index + 1] == undefined) {
                                    this.temp_items = [];
                                    this.inventories.push({item: null,inventory:null});
                                }
                            }


                        }

                    },

                    // in here you can check and decide to allow duplicate bank for payment or not


                    // delete item from list
                    deleteItem(type = null, index) {
                        if (type != null) {
                            console.log(type);
                            if (type == 'inventory') {
                                this.inventories.splice(index, 1);
                            }

                        }

                    },
                    // submit the form

                },


        });

    </script>



@endpush