@extends('layouts.factor-master')

@section('content')
    <?php
    $report = customeReport('adjustment');
    $_date = in_array('date', $report);
    $_description = in_array('description', $report);
    $_reference_number = in_array('reference_number', $report);
    $_total_amount = in_array('total_amount', $report);
    ?>

    <h3 class="table-caption" style="text-align: center;">@lang('layout.AdjustmentReport')</h3>
    @if($category)
    <p>
        <span>@lang('layout.Category'):{{__('layout.'.ucfirst($category))}}</span>
    </p>
    @endif
    <table class="main-table">
        <thead>
        <tr class="bg">
            <td>
                <div class="center"> @lang('layout.Record') </div>
            </td>
            @if($_date)
                <td class="center">@lang('layout.Date')</td>@endif
            @if($_description)
                <td class="center">@lang('layout.Description')</td>@endif
            @if($_reference_number)
                <td class="center">@lang('layout.ReferenceNumber')</td>@endif
            @if($_total_amount)
             <td class="center">@lang('layout.Category')</td>@endif
            @if($_total_amount)
                <td class="center">@lang('layout.TotalAmount')</td>@endif
        </tr>
        </thead>
        <?php
        $count = 0;
        ?>
        @foreach($data AS $record)
            <tr>
                <td class="center">{{++$count}}</td>
                @if($_date)
                    <td class="center">{{convertDate($record->date)}}</td>@endif
                @if($_description)
                    <td class="center">{{$record->description}}</td>@endif
                @if($_reference_number)
                    <td class="center">{{$record->ref_no}}</td>@endif
                @if($_reference_number)
                    <td class="center">{{__('layout.'.ucfirst($record->category))}}</td>@endif
                @if($_total_amount)
                    <td class="center">{{$record->total}}</td>@endif
            </tr>
        @endforeach
    </table>
 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection