@extends('layouts.app')

@section('content')

    <div class="portlet">
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('layout.AssemblyInformation')
            </div>
            <div class="tools">
                <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                {{--<a href="javascript:;" class="reload" data-original-title="" title=""> </a>--}}
                {{--<a href="javascript:;" class="remove" data-original-title="" title=""> </a>--}}
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead >
                    <tr style="background-color:#9998ee"> 
                        <th class="hidden-xs">
                            <i class="fa fa-bars"></i> @lang('layout.ProjectName')
                        </th>
                        <th class="hidden-xs">
                            <i class="fa fa-briefcase"></i> @lang('layout.ProjectCode')
                        </th>
                        <th>
                            <i class="fa "></i> @lang('layout.Type')
                        </th> 
                        <th>
                            <i class="fa "></i> @lang('layout.Code')
                        </th> 

                         <th>
                            <i class="fa fa-dashboard"></i> @lang('layout.Description')
                        </th>
                         <th>
                            <i class="fa fa-user"></i> @lang('layout.Date')
                        </th>
                    </tr>
                 
                    </thead>
                    <tbody>
                    <tr>  
                        <td class=" "> {{ $assemblyItemInfo->name}}  </td>
                        <td class=" "> {{ $assemblyItemInfo->project_code}}  </td>
                        <td class=" "> {{ $assemblyItemInfo->type}}  </td>
                        <td class=" "> {{ $assemblyItemInfo->code}}  </td>
                        <td class=" "> {{ $assemblyItemInfo->description}}  </td>
                        <td class=" "> {{ convertDate($assemblyItemInfo->date)}}  </td>
             
                    </tr>
                
                    </tbody>
                </table>
            </div>
        </div>
    </div>
      <div class="row">
        <div class="col-md-12">
            <!-- BEGIN EXAMPLE TABLE PORTLET-->
            <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption font-dark">
                        <i class="icon-settings font-dark"></i>
                        <span class="caption-subject bold uppercase">@lang('layout.Item')</span>
                    </div>
                    <div class="tools"></div>
                      <div class="actions">
                        @permission('builditem-export')
                         {{Form::open(['route' => 'export.exportCsv','method' => 'DELETE','class' => 'inline'])}}
                           <input type="hidden" name="type" value="itemAssemblyDetails"/>
                           <input type="hidden" name="id" value="{{$assemblyItemInfo->id}}"/> 
                           <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                        {{Form::close()}} 

                         {{Form::open(['route' => 'export.PDFAny','method' => 'DELETE','class' => 'inline'])}}
                           <input type="hidden" name="type" value="itemAssemblyDetails"/>
                           <input type="hidden" name="id" value="{{$assemblyItemInfo->id}}"/> 
                           <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                        {{Form::close()}} 
                        @endpermission 
                    </div>
                  
                </div>
                <div class="portlet-body">
                    <table class="table table-striped table-bordered table-hover" id="assemblyitem">
                        <thead>
                        <tr>
                            <th>@lang('layout.ItemName')</th>
                            <th>@lang('layout.Description')</th>
                            <th>@lang('layout.Quantity')</th>
                            <th>@lang('layout.Measure')</th>
                            <th>@lang('layout.Site')</th>
                        </tr>
                        </thead>
                    </table>
                </div>
            </div>
            <!-- END EXAMPLE TABLE PORTLET-->
        </div>
    </div>
@endsection
@push('scripts')

<script>
   $(document).ready(function () {
        $('#assemblyitem').DataTable({
            ajax: '{{route("itemAssembly.show",$assemblyItemInfo->id)}}',
            scrollCollapse: true,
            serverSide: true,
            paging: true,

            columns: [
                {data: 'name', name: 'name'},
                {data: 'description', name: 'description'},
                {data: 'quantity', name: 'quantity',},
                {data: 'measure', name: 'measure',orderable:false,searchable:false},
                {data: 'site_name', name: 'site_name',orderable:false,searchable:false},
//            { data: 'measure_unit_id', name: 'quantity' },
//            { data: 'measure_unit', name: 'rate' },


            ]

        });
    }); 

</script>


@endpush
