@extends('layouts.app')

@section('content')
<!-- BEGIN CONTENT -->
<!-- BEGIN PAGE BAR -->
<div class="page-bar">
    <ul class="page-breadcrumb">
        <li>
            <a href="index.html">Home</a>
            <i class="fa fa-circle"></i>
        </li>
        <li>
            <a href="#">Tables</a>
            <i class="fa fa-circle"></i>
        </li>
        <li>
            <span>Datatables</span>
        </li>
    </ul>
    <div class="page-toolbar">
        <div class="btn-group pull-right">

            <a href="{{route('account.create')}}">
                <button id="sample_editable_1_new" class="btn green btn-sm btn-outline">
                    <i class="fa fa-plus"></i> Add New
                </button></a>
        </div>
    </div>
</div>
<!-- END PAGE BAR -->
<!-- BEGIN PAGE TITLE-->
<h1 class="page-title"> Responsive Extension
    <small>responsive extension demos</small>
</h1>
<!-- END PAGE TITLE-->
<!-- END PAGE HEADER-->
@if (Session('message'))
    <div class="m-heading-1 border-green m-bordered">
        <h3>DataTables Responsive Extension Demo</h3>
        <p> Responsive is an extension for DataTables that resolves that problem by optimising the table's layout for different screen sizes through the dynamic insertion and removal of columns from the table. </p>
        <p >{{ Session('message') }}</p>
    </div>
    {{--<div class="alert alert-success ">--}}
        {{--<ul>--}}
            {{--<li >{{ Session('message') }}</li>--}}
        {{--</ul>--}}
    {{--</div>--}}
@endif
@if (count($errors) > 0)

    <div class="m-heading-1 border-green m-bordered">
        <h3>DataTables Responsive Extension Demo</h3>
        <p> Responsive is an extension for DataTables that resolves that problem by optimising the table's layout for different screen sizes through the dynamic insertion and removal of columns from the table. </p>

    {{--</div>--}}
    {{--<div class="alert alert-danger">--}}
        {{--<ul>--}}
            @foreach ($errors->all() as $error)
                <p>{{ $error }}</p>
            @endforeach
        {{--</ul>--}}
    </div>

@endif

<div class="row">
    <div class="col-md-12">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet box green">
            <div class="portlet-title">
                <div class="caption">
                    <i class="fa fa-globe"></i>Row & Column Reordering </div>
                <div class="tools"> </div>
            </div>
            <div class="portlet-body">
                <table class="table table-striped table-bordered table-hover dt-responsive" width="100%" id="account-datatable" cellspacing="0" width="100%">
                    <thead>
                    <tr>
                        <th>id</th>
                        <th>policy Number</th>
                        <th>product Id</th>
                        <th>Risk Inception Date</th>
                        <th>Risk Expiry Date</th>
                        <th>Name of the Applicant</th>
                        <th>Address of the Applicant</th>
                        <th>updated_at</th>
                        <th>created_at</th>
                    </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>
</div>

<!-- END CONTENT BODY -->


@stop

@push('scripts')

<script>
    jQuery(document).ready(function() {
        $(function() {
            $('#account-datatable').DataTable({
                processing: false,
                serverSide: false,
                pageLength: 5,
                ajax: '{{route("account.index")}}',
                columns: [
                    { data: 'id', name: 'id' },
                    { data: 'name', name: 'name' },
                    { data: 'type', name: 'type' },
                    { data: 'currency', name: 'currency' },
                    { data: 'description', name: 'description' },
                    { data: 'user_id', name: 'user_id' },
                    { data: 'balance', name: 'balance' },
                    { data: 'updated_at', name: 'Updated_at' },
                    { data: 'created_at', name: 'created_at' },
//                    { data: 'actions', name: 'actions' },


                ]
            });
        });
    });
</script>
<!-- END INTERNAL SCRIPT -->
@endpush
