@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet">

@section('style')


@stop
@section('content')
@include("layouts.Cmodal")

<div class="row" >
        @if (count($errors) > 0)
            <div class="m-heading-1 border-red m-bordered errors-action">
                <h4 class="error-title"><strong>Whoops!</strong> There were some problems with your input</h4>
                <ul class="error-body">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul> 
            </div>
        @endif 
        <div id="app" class="portlet light bg-inverse">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.AddNewAssembly') </span>
                    <span v-if="this.selected_project">
                        @lang('layout.Number'): <span>@{{(!selected_project)?null:selected_project.number}}</span> |
                         @lang('layout.Type'): <span>@{{(!selected_project)?null:selected_project.type}}</span>
                    </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                    <a href="" class="collapse" data-original-title="" title=""> </a>
                    <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                    <a href="" class="reload" data-original-title="" title=""> </a>
                    <a href="" class="remove" data-original-title="" title=""> </a>
                </div>
            </div>
            <div id="app" v-cloak class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                {{Form::open(['route' => 'itemAssembly.store','method' => 'POST','class' => 'form-','id'=>'assembly-form'])}}
                {{ csrf_field() }}

                    <div class="form-body">
                      <div class="row">
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                          <!-- begin inputs -->
                          <div class="row">
                             <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                              <div class="form-group">
                                  
                                  <div class="col-md-12">
                                    <label class="control-label">@lang('layout.Project')</label>
          
                                       <v-select  label="name" v-model="selected_project" :options="project_list" @search="onProjectSearch" v-model="selected_project"></v-select>
                                       <input type="hidden" name="project" :value="!selected_project?null:selected_project.id" required>
                                  </div>
                              </div> 
                          </div>
                          
                              
                          
                           <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                              <div class="form-group">
                                  
                                  <div class="col-md-12">
                                    <label class="control-label">@lang('layout.Date')</label>
          
                                       <input type="text" name="date" class="form-control date" autocomplete="off">
                                  </div>
                              </div> 
                          </div>
                          <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                              <div class="form-group">
                                  
                                  <div class="col-md-12">
                                    <label class="control-label">@lang('layout.Code')</label>
          
                                       <input type="text" name="code" class="form-control" value="{{$code}}" readonly>
                                  </div>
                              </div> 
                          </div>
                       

                          </div>

                                   <div class="row">
                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                          <!-- begin inputs -->
                          <div class="row">
                             <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                  <div class="form-group">
                                      
                                      <div class="col-md-12">
                                        <label class="control-label">@lang('layout.Type')</label>
              
                                           <select class="form-control" name="type">
                                                <option value="">@lang('layout.SelectType')</option>
                                                <option value="glass">@lang('layout.Glass')</option>
                                                <option selected="selected" value="item">@lang('layout.Item')</option>
                                            </select>
                                      </div>
                                  </div> 
                              </div>
                              <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                  <div class="form-group">
                                      
                                      <div class="col-md-12">
                                        <label class="control-label">@lang('layout.Category')</label>
              
                                             <select class="form-control" v-model="selected_category" name="category">
                                                <option value="">@lang('layout.SelectCategory')</option>
                                                <option value="withMetrazh">@lang('layout.WithMetrazh')</option>
                                                <option selected="selected" value="withoutMetrazh">@lang('layout.WithoutMetrazh')</option>
                                            </select>
                                      </div>
                                  </div> 
                              </div>
                              <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                  <div class="form-group">
                                      
                                      <div class="col-md-12">
                                        <label class="control-label">@lang('layout.Description')</label>
              
                                           <textarea name="description" class="form-control" rows="2"></textarea>
                                      </div>
                                  </div> 
                              </div> 
                          </div> 
                          <!-- end inputs -->
                      </div>
                     

                      </div> 
                      <br>
                     <div class="row" v-if="inventories.length>0">
                         <table id="table_content" class="table table-striped table-bordered table-advance table-hover" >
                          <thead>
                              <tr>
                                  <th>#</th>
                                  <th style="min-width: 130px">@lang('layout.CategoryName') </th>
                                  <th style="min-width: 130px">@lang('layout.ItemName') </th>
                                  <th style="min-width: 100px">@lang('layout.SiteName') </th>
                                  <th v-if="selected_category=='withMetrazh'" style="min-width: 18px;"> @lang('layout.Width')</th>
                                  <th v-if="selected_category=='withMetrazh'" style="min-width: 18px;"> @lang('layout.Height')</th>
                                  <th  style="min-width: 40px;"> @lang('layout.Quantity')</th>
                                  <th style="min-width: 100px">@lang('layout.OnHand') </th>
                                  <th style="min-width: 100px">@lang('layout.Measure') </th>
                                 <th style="min-width: 60px;"> @lang('layout.Description')</th>
                                  <th></th>
                              </tr>
                          </thead>
                          <tbody>
                              <tr v-for="(item,index) in inventories">
                                  <td>@{{index+1}}</td>
                                   <td class="highlight">
                                    <v-select label="name" v-model="item.category" :options="category" @input="getItemsWithCategory(index)" @click.native="addNew('inventory',index)"></v-select> 
                                    <input type="hidden" name="inventory_category[]" :value="(!item.category)?null:item.category.id">
                                  </td>
                                  <td class="highlight">
                                      <v-select label="name" v-model="item.item" :options="item.items">
                                      </v-select>
                                      <input type="hidden" name="inventory_id[]" :value="(!item.item)?null:item.item.id">
                                  </td>
                                  <td class="highlight">
                                      <select v-model="(item.item==null)?null:item.item.site" class="form-control">
                                         <option value="null">@lang('layout.Select')</option>
                                         <span v-if="(item.item != null)">
                                          <option v-for="site in (item.item==null)?null:item.item.site_list" :value="site">
                                            @{{site.site_name}}
                                          </option> 
                                        </span>
                                      </select>
                                      <input type="hidden" name="inventory_site[]" :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.site_id)">
                                  </td>
                               
                                  <td v-if="selected_category=='withMetrazh'">
                                     <input type="number" v-model="(!item.item)?null:item.item.width" placeholder="@lang('layout.Width')" name="width[]" class="form-control">
                                  </td>
                                   <td v-if="selected_category=='withMetrazh'">
                                     <input type="number" v-model="(!item.item)?null:item.item.height" placeholder="@lang('layout.Height')" name="height[]" class="form-control">
                                  </td>
                                   <td>
                                     <input type="number" v-model="(!item.item)?null:item.item.quantity" placeholder="@lang('layout.Quantity')" name="quantity[]" class="form-control">
                                  </td>
                          
                                  <td>
                                     @{{myRound((item.item==null)?null:projectItemQuantity(item.item,item.item.quantity,item.item.width,item.item.height))}}
                                  </td>
                                  <td class="highlight">
                                      <select  v-model="(item.item == null)?null:item.item.measure" class="form-control" @change="measureChange(index)">
                                          <option value="null">@lang('layout.Select')</option>
                                          <span v-if="(item.item ==null)?false:true">
                                              <option  v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure">
                                              @{{measure.measure_name}}
                                            </option> 
                                          </span>
                                          
                                         
                                      </select>
                                     
                                      <input type="hidden" name="inventory_measure[]" :value="(item.item==null)?null:item.item.measure.measure_id">
                                  </td>
                           
                                   
                                    <td>
                                        <div class="input-group input_style">
                                            <input type="text" class="form-control"  placeholder="@lang('layout.Description')"  name="inventory_description[]">
                                        </div>
                                    </td>
                                  <td>
                                       <span  v-on:click="deleteItem('inventory',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                  </td>
                              </tr>
                          </tbody>
                      </table>
                     <hr>
                 
                     </div>
                                        
                                   
                     
                    </div>
                    <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                        <button type="button" v-if="!isError" @click="submitForm" class="btn green">@lang('layout.Submit')</button>
                        <a href="{{route('inventorySite.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                    </div>  
                {!! Form::close() !!}
                <cmodal :show='showModal' @close="showModal=false">
                  
                </cmodal>
            </div>                  
            <!-- END FORM-->
        </div>
    </div> 

@endsection
@push('scripts')


<script type="text/javascript">
  Vue.component('v-select', VueSelect.VueSelect);
 
 
  var v = new Vue({
    el: '#app',
    data: {
       selected_category:'withMetrazh',
       showModal: false,
       project_list:[],
       selected_project:null,
       temp_items:[],
       temp_other_items:[],
       totalAmountes: [],
       newCost:[
       null,
       null,
       null,
       null],
       category:{!! json_encode($inventoryCategory) !!},
       inventories:[
          {item:null,items:[],category:null},
          {item:null,items:[],category:null},
          {item:null,items:[],category:null},
       ],
      
      
    },
    computed:{
         
       isError:function()
       {

       }
        
    },
    methods:
    {
      WindowTypeChange(index)
      {

      },
       // calculate item price based on measure change
       measureChange(index)
       {
    
           if(this.inventories[index].item !=null){
            var item=this.inventories[index].item;
          
            var temp=((item.rate*item.measure.measure_unit/item.measure_unit));
            result=Number.parseFloat(temp).toFixed(precision());

            this.inventories[index].item.new_rate =result;

            // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;
            
            }
       },
     
       // set new price
       setNewRate(index)
       {
           if(this.inventories[index].item){
            this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;
            }

       },

      getItemsWithCategory(index=null)
      {
        
         if(index !=null)
         {
          if(this.inventories[index].category)
          {
            this.inventories[index].items=[];
            this.onItemSearch(this.inventories[index].category.id,index);      
          }
         }
      },
 
       //ajax call to get items
       onItemSearch:_.debounce((category_id,index)=>{
           axios.get("{{route('callMethod.search')}}",{
            params:{
              method_name:'itemSearchExtra',
              category_id:category_id,
            }
           })
           .then(function (response)
           {
             v.inventories[index].items=[];
             if(response.data.length>0)
             {
                 v.inventories[index].items=response.data;
             }
           })
           .catch(function (error)
           {
              console.log(error);
           });
       },getDebounceTime()),
      

       // end item search

       // contract search


        onProjectSearch:_.debounce((search,loading)=>{
            loading(true);
           axios.get("{{route('callMethod.search')}}",{
            params:{
              method_name:'project',
              keyword:search,
              
            }
           })
           .then(function (response)
           {
             if(response.data.length>0)
             {

                v.project_list=response.data;
             }
             loading(false);
           })
           .catch(function (error)
           {
              console.log(error);
           });
        },getDebounceTime()),
      
       // end contract search

       // generic function for adding item to list
       addNew(type=null,index)
       {
          this.inventories[index].items=[];
          if(type !=null)
          {
             if(type=='inventory')
             {
                if(this.inventories[index+1]==undefined)
                {
                  this.inventories[index].items=[];
                  this.inventories.push({item:null,items:[],category:null});
                }
             }
          }
       },

       // in here you can check and decide to allow duplicate bank for payment or not
       checkExistingPayment(index=null,name='')
       {      
              var bank_temp=this.banks.slice();
              var bank_temp1=[];
              for(var i=0;i<this.payments.length;i++)
              {
                  if(this.payments[i].item !=null)
                  {
                      var fined=bank_temp.findIndex((item)=> item.name == this.payments[i].item.name);
                      if(fined !=-1)
                      {
                        var o=bank_temp.splice(bank_temp.findIndex((item)=>item.name == this.payments[i].item.name),1);
                      }
                  }
              }
              this.payments[index].items = bank_temp.filter((item) => {
                        return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                    });
               //this.payments[index].items =bank_temp; 


       },
       // delete item from list
       deleteItem(type=null,index)
       {
         if(type !=null)
         {
             console.log(type);
             if(type=='inventory')
             {
                this.inventories.splice(index, 1);
             }
              if(type=='payment')
             {
                this.payments.splice(index, 1);
             }
         }
          
       },
       // submit the form
       submitForm() 
       {

          if(this.isError==true) {
            alert('there is no item');
            return false;
          }
          swal({
                title:"@lang('layout.AreYouSure?')",
                buttons: ["@lang('layout.Cancel')","@lang('layout.Submit')"],
                text: "",
                icon: "info",
                dangerMode: true,
            }).then((willDelete) => {
                if (willDelete)
                {
                    document.getElementById("assembly-form").submit()

                }
                else
                {

                }
            });

        },
    },
   

  });

</script>


@endpush