@extends('layouts.app')
@section('content')
    <?php
        $seeCost = \Entrust::can('cost-create');
    ?>
    <div class="portlet">
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('layout.InvoiceInformation')
            </div>
            <div class="tools">
                <a href="javascript:;" class="collapse" data-original-title="" title=""> </a>
                <a href="#portlet-config" data-toggle="modal" class="config" data-original-title="" title=""> </a>
                {{--<a href="javascript:;" class="reload" data-original-title="" title=""> </a>--}}
                {{--<a href="javascript:;" class="remove" data-original-title="" title=""> </a>--}}
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                        <tr>
                            <th width="20px;">
                            <i class="fa  fa-bars"></i> @lang('layout.SalesNumber') 
                            </th>
                            
                            <th class="">
                                <i class="fa fa-user"></i>  @lang('layout.Customer')
                            </th>
                            <th class="">
                                <i class="fa fa-user"></i>  @lang('layout.ReferenceNumber')
                            </th>
                            <th>
                                <i class="fa fa-file-excel-o"></i> @lang('layout.Account')
                            </th>
                            <th>
                                <i class="fa fa-clock-o"></i> @lang('layout.Date')
                            </th>
                            <th>
                                <i class="fa fa-clock-o"></i> @lang('layout.OverdueDate')
                            </th>
                            <th>
                                <i class="fa fa-clock-o"></i> @lang('layout.Hour')
                            </th> 
                            <th>
                                <i class="fa "></i> @lang('layout.Quantity')
                            </th>
                            <th width="20px;">
                                <i class="fa fa-money"></i> @lang('layout.Rate')
                            </th>
                            <th> 
                                <i class="fa fa-dollar"></i> @lang('layout.Amount') 
                            </th>
                            <th> 
                                <i class="fa fa-dollar"></i> @lang('layout.DiscountType') 
                            </th>
                            <th> 
                                <i class="fa fa-dollar"></i> @lang('layout.Discount') 
                            </th>
                            <th>
                                <i class="fa fa-money"></i> @lang('layout.Currency') 
                            </th>
                            @if(getSaleCommission()=="true")
                            <th>
                                <i class="fa  "></i> @lang('layout.Commission') @lang('layout.Percentage')%
                            </th>
                            @endif
                        </tr>
                    </thead>
                    <tbody>
                        <tr>  
                            <td class=" "> {{ $invoice->number}}  </td>
                            <td class=""> {{ $invoice->member_name }}  </td>
                            <td class=""> {{ $invoice->ref_no }}  </td>
                            <td class=""> {{ $invoice->account_name}}  </td>
                            <td class=""> {{ convertDate($invoice->date)}}  </td>
                            <td class=""> {{ convertDate($invoice->overdue_date)}}  </td>
                            <td class=""> {{ $invoice->hour}} </td>
                            <td class=""> {{ myRound($invoice->qty) }}  </td>
                            <td class=""> {{ $invoice->rate }}  </td>
                            <td class=""> {{ myRound($invoice->amount) }}  </td>
                            <td class=""> {{ $invoice->discount_type }}  </td>
                            <td class=""> {{ myRound($invoice->discount) }}  </td>
                            <td class=""> {{ $invoice->currency }}  </td>
                            @if(getSaleCommission()=="true")
                            <td class=""> {{ myRound($invoice->commission_percent)}}  </td>
                            @endif
                        </tr>
                    </tbody>
                </table>
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                        <tr>
                            <th width="">
                                <i class=" fa fa-text-width"></i> @lang('layout.Description')
                            </th>
                            <th width=" ">
                                <i class=" fa fa-text-width"></i> @lang('layout.Memo')
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td class=" "> {{ $invoice->description}}  </td>
                            <td class=" "> {{ $invoice->memo}}  </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            @if(getTransferRent()=="true" && $transferRent && $transferRent!=null)
                <div class="table-scrollable">
                    <h4>@lang('layout.TransferRent')</h4>
                    <table class="table table-striped table-bordered table-advance table-hover">
                        <thead>
                            <tr>
                                <th >@lang('layout.Number')</th>
                                <th >@lang('layout.Type')</th>
                                <th >@lang('layout.Transmitter')</th>
                                <th >@lang('layout.Account')</th>
                                <th >@lang('layout.Amount')</th>
                                <th >@lang('layout.Currency')</th>
                                <th >@lang('layout.Rate')</th>
                                <th >@lang('layout.Description')</th>          
                            </tr>
                        </thead>
                        <tbody>
                            <td class=""> {{$transferRent->id }}  </td>
                            <td class=""> {{__('type.'.$transferRent->type)}}</td>
                            <td class=""> {{$transferRent->vendor_name}}  </td>
                            @if($transferRent->type=="cash")
                            <td class=""> {{$transferRent->b_account_name }}  </td>
                            @endif
                            @if($transferRent->type=="credit")
                            <td class=""> {{$transferRent->p_account_name }}  </td>
                            @endif
                            <td class="">{{myRound($transferRent->receivable_amount)}}</td>
                            <td class=""> {{$transferRent->currency }}  </td>
                            <td class=""> {{$transferRent->rate }}  </td>
                            <td class=""> {{$transferRent->description }}  </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            @endif  
        </div>
    </div>
    <div class="">
        <div class="tabbable tabbable-tabdrop">
            <ul class="nav nav-tabs">
                <li class="active">
                    <a href="#tab1" data-toggle="tab" id="tab_sale">@lang('layout.InvoiceDetails')</a>
                </li>
                <li>
                    <a href="#tab2" data-toggle="tab" id="tab_payment">@lang('layout.Attachments')</a>
                </li>
                @if(getInstallments()=="true")
                <li class="">
                    <a href="#tab3" data-toggle="tab" id="tab_invoice_payment">@lang('layout.Installments')</a>
                </li>
                @endif
            </ul>
            <div class="tab-content">
                <div class="tab-pane active" id="tab1">
                    <div class="row">
                        <div class="col-md-12">
                            <!-- BEGIN EXAMPLE TABLE PORTLET-->
                            <div class="portlet light bordered">
                                <div class="portlet-title">
                                    <div class="caption font-dark">
                                        <i class="icon-settings font-dark"></i>
                                        <span class="caption-subject bold uppercase">@lang('layout.InvoiceDetails') </span>
                                    </div>
                                    <div class="tools"></div>
                                     <div class="actions">
                                         {{Form::open(['route' => 'export.exportCsv','method' => 'DELETE','class' => 'inline'])}}
                                           <input type="hidden" name="type" value="Inoice_DetailsRoll"/>
                                           <input type="hidden" name="id" value="{{$invoice->invoice_id}}"/> 
                                           <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                                        {{Form::close()}} 
                
                                         {{Form::open(['route' => 'export.PDFAny','method' => 'DELETE','class' => 'inline'])}}
                                           <input type="hidden" name="type" value="Inoice_DetailsRoll"/>
                                           <input type="hidden" name="id" value="{{$invoice->invoice_id}}"/> 
                                           <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                                        {{Form::close()}}  
                                    </div>
                                </div>
                                <div class="portlet-body">
                                    <table class="table table-striped table-bordered table-hover" id="invoices">
                                        <thead>
                                            <tr>
                                                <th>@lang('layout.ItemName')</th>
                                                <th>@lang('layout.Site')</th>
                                                <th>@lang('layout.Code')</th>
                                                @if(systemConfig()[9] == 0 )
                                                <th>@lang('layout.Length')</th>
                                                <th>@lang('layout.Width')</th>
                                                @endif
                                                @if(itemBrand()=="true")
                                                <th>@lang('layout.Brand')</th>
                                                @endif
                                                @if(ImportEngineNumberByExcel()=="true")
                                                <th>@lang('layout.DocumentReceived')</th>
                                                @endif
                                                @if(showLocation()=="true")
                                                <th>@lang('layout.Location')</th>
                                                @endif
                                                <th>@lang('layout.Unit/M')</th>
                                                <th>@lang('layout.PurchaseDate')</th>
                                                <th>@lang('layout.SleepStaff')</th>
                                                @if(getCustomHouseLitter()=="true")
                                                <th>@lang('layout.CustomHouseLitterNumber') </th>
                                                <th>@lang('layout.CustomHouseLitterDate') </th>
                                                <th>@lang('layout.Province') </th>
                                                @endif 
                                                @if(getOtherMeasure()=="true")
                                                <th>@lang('layout.OMeasureValue') 1</th>
                                                <th>@lang('layout.OMeasureValue') 2</th>
                                                @endif
                                                <th>@lang('layout.Quantity')</th>
                                                <th>@lang('layout.Price')</th>
                                                @if(getSaleCommission()=="true")
                                                <th>@lang('layout.Commission') @lang('layout.Percentage')%</th>
                                                <th>@lang('layout.Commission') @lang('layout.Amount')</th>
                                                @endif
                                                @if($seeCost==true)
                                                <th>@lang('layout.Cost')</th>
                                                <th>@lang('layout.Income')</th>
                                                @endif
                                                <th>@lang('layout.Total')</th>
                                            </tr>
                                        </thead>
                                    </table>
                                </div>
                            </div>
                            <!-- END EXAMPLE TABLE PORTLET-->
                        </div>
                    </div>
                </div>
                <div class="tab-pane" id="tab2">
                    <div class="portlet light bordered">
                        <div class="portlet-title">
                            <div class="caption font-dark">
                                <i class="icon-settings font-dark"></i>
                                <span class="caption-subject bold uppercase">@lang('layout.Attachments')</span>
                            </div>
                        </div>
                        <div class="portlet-body">
                            <div class="portlet light bordered">
                                <div class="portlet-body">
                                    <form role="form" action="{{route('attachment.store')}}" method="post" enctype="multipart/form-data">
                                        @csrf
                                        <input type="hidden" name="redirect_route" value="invoice_roll.show">
                                        <input type="hidden" name="foreign_data_id" value="{{$invoice->invoice_id}}">
                                        <input type="hidden" name="path" value="uploads/Invoice">
                                        <input type="hidden" name="table_name" value="sales">

                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.AttachmentTitle')</label>
                                                    <input type="text" name="title" class="form-control">
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.Description')</label>
                                                    <textarea name="description" class="form-control"></textarea>
                                                </div>
                                            </div>
                                            <div class="col-md-7">
                                                <div class="form-group">
                                                    <div class="fileinput fileinput-new" data-provides="fileinput">
                                                        <div class="fileinput-new thumbnail"
                                                             style="width: 200px; height: 150px;">
                                                            <img src="" alt=""></div>
                                                        <div class="fileinput-preview fileinput-exists thumbnail"
                                                             style="max-width: 200px; max-height: 150px; line-height: 10px;"></div>
                                                        <div>
                                                                    <span class="btn default btn-file">
                                                                        <span class="fileinput-new">@lang('layout.SelectFile')</span>
                                                                        <span class="fileinput-exists">@lang('layout.Change')</span>
                                                                        <input type="hidden" value="" name=""><input
                                                                                type="file" name="photo"> </span>
                                                            <a href="javascript:;" class="btn default fileinput-exists"
                                                               data-dismiss="fileinput"> @lang('layout.Remove') </a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="margiv-top-10">
                                            <button type="button" onclick="regForm(this)"
                                                    class="btn green"> @lang('layout.Submit') </button>
                                            <a href="{{route('dailyExpense.index')}}"
                                               class="btn default">@lang('layout.Cancel')</a>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <table class="table table-striped table-bordered table-hover" id="attachment">
                                <thead>
                                    <tr>
                                        <th>@lang('layout.AttachmentTitle')</th>
                                        <th>@lang('layout.Description')</th>
                                        <th>@lang('layout.Action')</th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>  
                <div class="tab-pane" id="tab3">
                    <div class="portlet light bordered">
                        <div class="portlet-title">
                            <div class="caption font-dark">
                                <i class="icon-settings font-dark"></i>
                                <span class="caption-subject bold uppercase">@lang('layout.Installments')</span>
                            </div>
                            <div class="tools"></div>
                                <div class="actions">
                                    {{Form::open(['route' => 'export.exportCsv','method' => 'DELETE','class' => 'inline'])}}
                                    <input type="hidden" name="type" value="Inoice_installment"/>
                                    <input type="hidden" name="id" value="{{$invoice->invoice_id}}"/> 
                                    <button type="submit" class="btn btn-success"> <i class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                                {{Form::close()}} 
                                {{Form::open(['route' => 'export.PDFAny','method' => 'DELETE','class' => 'inline'])}}
                                    <input type="hidden" name="type" value="Inoice_installment"/>
                                    <input type="hidden" name="id" value="{{$invoice->invoice_id}}"/> 
                                    <button type="submit" class="btn btn-success"> <i class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                                {{Form::close()}}  
                            </div>
                        </div>
                        <div class="portlet-body">
                            <table class="table table-striped table-bordered table-hover" id="installment">
                                <thead>
                                    <tr>
                                        <th>@lang('layout.Amount')</th>
                                        <th>@lang('layout.Currency')</th>
                                        <th>@lang('layout.Date')</th>
                                        <th>@lang('layout.Description')</th>
                                        <th>@lang('layout.Status') </th>
                                        <th>@lang('layout.Action')</th>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>    
<!--Transport Company And Drivers-->
@if(getTransportCompany()=="true")
@if($transportCompany)
@if($transportCompany->driver_name || $transportCompany->trasnport_name!=null )
    <div class="portlet">
        <div class="portlet-title">
            <div class="caption">
                <i class=""></i>@lang('layout.TransportCompanyAndDriver')
            </div>
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <div class="col-md-12">
                    <div class="col-md-6 col-sm-12">
                        <table class="table table-striped table-bordered table-advance table-hover" style="width: 100%;">
                            <thead>
                                <tr>
                                    <th width="20px;">
                                        <i class="fa  fa-bars"></i> @lang('layout.Number')
                                    </th>   
                                    <th width="20px;">
                                        <i class="fa  fa-bars"></i> @lang('layout.LicenseNumber')
                                    </th>  
                                    <th width="20px;">
                                        <i class="fa  fa-user"></i> @lang('layout.Name')
                                    </th>
                                    <th width="20px;">
                                        <i class="fa  fa-phone"></i> @lang('layout.Phone')
                                    </th>
                                    <th width="20px;">
                                        <i class="fa  fa-bars"></i> @lang('layout.Email')
                                    </th> 
                                    <th width="20px;">
                                        <i class="fa  fa-bars"></i> @lang('layout.City')
                                    </th> 
                                    <th width="20px;">
                                        <i class="fa  fa-bars"></i> @lang('layout.Address')
                                    </th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td align="right"><b>{{$transportCompany->trasnport_number}}</b></td>
                                    <td align="right"><b>{{$transportCompany->trasnport_license_number}}</b></td>
                                    <td align="right"><b>{{$transportCompany->trasnport_name}}</b></td>
                                    <td align="right"><b>{{$transportCompany->trasnport_phone}}</b></td>
                                    <td align="right"><b>{{$transportCompany->trasnport_email}}</b></td>
                                    <td align="right"><b>{{$transportCompany->trasnport_city}}</b></td>
                                    <td align="right"><b>{{$transportCompany->trasnport_address}}</b></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>                         
                    <div class="col-md-6 col-sm-12">
                        <table class="table table-striped table-bordered table-advance table-hover" style="width: 100%;">
                            <thead>
                                <tr>
                                    <th width="20px;">
                                        <i class="fa  fa-bars"></i> @lang('layout.Number')
                                    </th>   
                                    <th width="20px;">
                                        <i class="fa  fa-bars"></i> @lang('layout.SSID')
                                    </th>  
                                    <th width="20px;">
                                        <i class="fa  fa-user"></i> @lang('layout.Name')
                                    </th>
                                    <th width="20px;">
                                        <i class="fa  fa-bars"></i> @lang('layout.LastName')
                                    </th>
                                    <th width="20px;">
                                        <i class="fa  fa-phone"></i> @lang('layout.Phone')
                                    </th> 
                                    <th width="20px;">
                                        <i class="fa  fa-bars"></i> @lang('layout.City')
                                    </th> 
                                    <th width="20px;">
                                        <i class="fa  fa-bars"></i> @lang('layout.Address')
                                    </th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td align="right"><b>{{$transportCompany->driver_code}}</b></td>
                                    <td align="right"><b>{{$transportCompany->driver_ss_idr}}</b></td>
                                    <td align="right"><b>{{$transportCompany->driver_name}}</b></td>
                                    <td align="right"><b>{{$transportCompany->driver_last_name}}</b></td>
                                    <td align="right"><b>{{$transportCompany->driver_phone}}</b></td>
                                    <td align="right"><b>{{$transportCompany->driver_city}}</b></td>
                                    <td align="right"><b>{{$transportCompany->driver_address}}</b></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endif
@endif
@endif
<!--End Transport Company And Driver-->
@endsection
@push('scripts')
<script>
    $(document).ready(function () {
        $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
        $('#invoices').DataTable({
            ajax: {
                url: '{{route("invoice_roll.show",$invoice->invoice_id)}}',
                data: {type: 'invoice'}
            },
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            scrollCollapse: true,
            serverSide: true,
            paging: true,
            columns: [ 
                { data: 'name', name: 'name', orderable:false,searchable:false  },
                { data: 'siteName', name: 'siteName', orderable:false,searchable:false  },
                { data: 'code', name: 'code', orderable:false,searchable:false  },
				@if(systemConfig()[9] == 0 )
                { data: 'lengths', name: 'lengths', orderable:false,searchable:false  },
                { data: 'widths', name: 'widths', orderable:false,searchable:false  },
				@endif
				@if(itemBrand()=="true")
                { data: 'brand', name: 'brand', orderable:false,searchable:false },
				@endif
                @if(ImportEngineNumberByExcel()=="true")
                { data: 'description2', name: 'description2', orderable:false,searchable:false },
                @endif
                @if(showLocation()=="true")
                { data: 'location', name: 'location', orderable:false,searchable:false },
				@endif
                { data: 'symbol', name: 'symbol', orderable:false,searchable:false },
                { data: 'stocks_date', name: 'stocks_date', orderable:false,searchable:false },
                { data: 'sleepDate', name: 'sleepDate', orderable:false,searchable:false },
                @if(getCustomHouseLitter()=="true")
                { data: 'litter_number', name: 'litter_number', orderable:false,searchable:false },
                { data: 'date_litter', name: 'date_litter', orderable:false,searchable:false },
                { data: 'province_litter', name: 'province_litter2', orderable:false,searchable:false },
                @endif 
                @if(getOtherMeasure()=="true")
                { data: 'other_measure', name: 'other_measure', orderable:false,searchable:false },
                { data: 'other_measure2', name: 'other_measure2', orderable:false,searchable:false },
                @endif
                { data: 'qty', name: 'qty', orderable:false,searchable:false },
                { data: 'price', name: 'price', orderable:false,searchable:false},
                @if(getSaleCommission()=="true")
                { data: 'row_commission_percent', name: 'row_commission_percent', orderable:false,searchable:false },
                { data: 'total_commission', name: 'total_commission', orderable:false,searchable:false },
                @endif
				@if($seeCost==true)
                { data: 'avgCost', name: 'avgCost', orderable:false,searchable:false},
                { data: 'income', name: 'income', orderable:false,searchable:false},
				@endif
                { data: 'total', name: 'total', orderable:false,searchable:false},
            ]
        });      
        $('#attachment').DataTable({
            ajax: {
                url: '{{route("invoice_roll.show",$invoice->invoice_id)}}',
                data: {type: 'attachment'}
            },
            pageLength:'{{getPageRows()}}',
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            scrollCollapse: true,
            serverSide: true,
            paging: true,
            columns: [

                {data: 'title', name: 'attachments.title'},
                {data: 'description', name: 'attachments.description'},
                {data: 'actions', name: 'actions', orderable: false, searchable: false},
            ]
        });              
        $('#installment').DataTable({
            ajax: {
                url: '{{route("invoice_roll.show",$invoice->invoice_id)}}',
                data: {type: 'installment'}
            },
            responsive:'{{responsiveDataTable()}}',
            pagingType:'{{paginationType()}}',
            scrollCollapse: true,
            serverSide: true,
            paging: true,
            columns: [ 
                { data: 'amount', name: 'amount', orderable:false,searchable:false  },
                { data: 'code', name: 'code', orderable:false,searchable:false  },
                { data: 'date', name: 'date', orderable:false,searchable:false  },
                { data: 'description', name: 'description', orderable:false,searchable:false  },
                { data: 'status', name: 'status', orderable:false,searchable:false  },
                {
                    data: 'actions',
                    name: 'actions',
                    orderable: false,
                    searchable: false
                }
                  ]
        });
    });
</script>
@endpush