@extends('layouts.factor-master')
<?php 
$reportTitle = __('layout.InvoiceReport');
?>
@section('content')
<?php
$report = customeReport('invoice','detail');
$seeCost = \Entrust::can('cost-create');
?>
<h3 class="table-caption" style="text-align: center;">@lang('layout.InvoiceReport')</h3>

<table  class="main-table">
 @if($info && $info !=[])

 <tr>
  <td>
    <span>@lang('layout.InvoiceNumber')</span>:&nbsp;&nbsp;
    <span>{{$info->number}}</span>
  </td>
  <td>
    <span>@lang('layout.Customer')</span>:&nbsp;&nbsp;
    <span>{{$info->member_name}}</span>
  </td>
  <td>
    <span>@lang('layout.Account')</span>:&nbsp;&nbsp;
    <span>{{$info->account_name}}</span>
  </td>
  <td>
    <span>@lang('layout.Amount')</span>:&nbsp;&nbsp;
    <span>{{$info->amount}}</span>
  </td>
   <td>
  <span>@lang('layout.Currency')</span>:&nbsp;&nbsp;
  <span>{{$info->currency}}</span>
</td>
</tr>
<tr>

<td>
  <span>@lang('layout.Rate')</span>:&nbsp;&nbsp;
  <span>{{$info->rate}}</span>
</td>
<td>
  <span>@lang('layout.DiscountType')</span>:&nbsp;&nbsp;
  <span>{{$info->discount_type}}</span>
</td>
<td>
  <span>@lang('layout.Discount')</span>:&nbsp;&nbsp;
  <span>{{$info->discount}}</span>
</td>
<td>
  <span>@lang('layout.Type')</span>:&nbsp;&nbsp;
  <span>{{$info->type}}</span>
</td>
<td>
  <span>@lang('layout.Quantity')</span>:&nbsp;&nbsp;
  <span>{{$info->qty}}</span>
</td>

</tr>
@endif

</table>
<br>
<h3 class="table-caption" style="text-align: center;">@lang('layout.Installments')</h3>
<table class="report-table">


<tr class="bg">

<th>#</th>
<th>@lang('layout.Amount')</th>
<th>@lang('menu.Currency')</th>
<th>@lang('layout.Status') </th>
<th>@lang('layout.Date')</th>
<th>@lang('layout.Description')</th>

</tr>
<?php
$count = 0;
foreach($data AS $record)
{
 $install_status = '';
 if($record->status ==0){
   $install_status = __('layout.Done');
 }
 elseif($record->status ==1){
  $install_status = __('layout.Undone');
 }
 elseif($record->status ==2){
  $install_status = __('layout.Canceled');
 }

?>
<tr>
<td class="center">{{++$count}}</td>

<td  class="center">{{$record->amount}}</td>
<td  class="center">{{$record->currency}}</td>
<td  class="center">{{$install_status}}</td>
<td  class="center">{{convertDate($record->date)}}</td>
<td  class="center">{{$record->description}}</td>
</tr>
<?php
}

?>
</table>

 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection