@extends('layouts.app')
@section('style')
    <style>
        .hide_btn{
            display: none; 
        }
    </style>
@endsection
@section('content')
    @include('invoices.modal')
    @include('sales.modal')
    <!-- END PAGE HEADER-->
    <div id="ww" v-cloak>
        {{Form::open(['route' => 'refund.findRefund','method' => 'POST','class' => 'inline'])}}
        <button id="show-modalww" style="display: none" type="button" @click="editExampleww">Show Modal</button>
        <!-- use the modal component, pass in the prop -->
        <modal v-if="showModal" @close="showModal = false">
            <div slot="body">
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <label class="control-label ">@lang('layout.InvoiceNumber') </label>
                            <input type="number" name="number" class="form-control">
                            <input type="hidden" name="type" value="Invoice">
                        </div>
                    </div>
                </div>
            </div>
            <div slot="footer">
                <button type="submit" class="btn btn-success" @click="ok">
                    @lang('layout.Submit')
                </button>
                <button type="button" class="btn btn-danger" @click="close">
                    @lang('layout.Cancel')
                </button>
            </div>
        </modal>
        {{Form::close()}}
    </div>
    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'invoicelistRoll'" @closed="closeModal">  
            <div slot="body">
                <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->
                <div class="row" v-cloak>
                    <div class="tabbable tabbable-tabdrop"> 
                        <ul class="nav nav-tabs"> 
                            <li class="active">
                                <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                            </li>
                            @if(systemConfig()[2] != 0 )
                            @permission(['EmployeeRewards-list'])
                            <li class="">
                                <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                            </li>
                            @endpermission
                            @endif
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane active" id="tab1">
                                <div class="form-group" style="border: 1px solid rgb(226, 226, 226);padding: 20px;border-radius: 8px;">
                                    <div class="row">
                                        <div class="form-group">
                                            <div class="col-md-6">
                                                <label class="control-label ">@lang('layout.SelectMember') </label>
                                                <v-select class="vue-select2" v-model="selectedMember" label="name" @search="onMemberSearch" :options="memberlist">
                                                </v-select>
                                                <input type="hidden" name="member_id" v-model.number="(!selectedMember)?null:selectedMember.id">
                                            </div>
                                            <div class="col-md-6">
                                                <label class="control-label ">@lang('layout.SelectSite') </label>
                                                <v-select class="vue-select2" v-model="selectedInventorySite" label="name" :options="InventorySite">
                                                </v-select>
                                                <input type="hidden" name="inventory_id" v-model.number="(!selectedInventorySite)?null:selectedInventorySite.id">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="form-group">
                                            <div class="col-md-12">
                                                <label class="control-label ">@lang('layout.Date')</label>
                                                    <select name="period" v-model="period" @input="getDates()" class="form-control">
                                                    <option value="CustomDates">@lang('type.CustomDates')</option>
                                                    <option value="Today">@lang('type.Today')</option>
                                                    <option value="Yesterday">@lang('type.Yesterday')</option>
                                                    <option value="ThisWeek">@lang('type.ThisWeek')</option>
                                                    <option value="LastWeek">@lang('type.LastWeek')</option>
                                                    <option value="WeekToDate">@lang('type.WeekToDate')</option>
                                                    <option value="ThisMonth">@lang('type.ThisMonth')</option>
                                                    <option value="MonthToDate">@lang('type.MonthToDate')</option>
                                                    <option value="ThisQuarter">@lang('type.ThisQuarter')</option>
                                                    <option value="QuarterToDate">@lang('type.QuarterToDate')</option>
                                                    <option value="ThisYear">@lang('type.ThisYear')</option>
                                                    <option value="YearToDate">@lang('type.YearToDate')</option>
                                                </select>
                                            </div>
                                            <div class="col-md-12" v-show="period == 'CustomDates'">
                                                <div class="form-group">
                                                    <label class="control-label"> @lang('layout.Date')</label>
                                                    <div class="input-group">
                                                        <input class="form-control date" id="range-from-example" v-model="from_date" name="from_date" autocomplete="off">
                                                        <span class="input-group-addon"> @lang('layout.To') </span>
                                                        <input class="form-control date" id="range-to-example" v-model="to_date" name="to_date" autocomplete="off">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane" id="tab2">
                                <div class="portlet light bordered">
                                    <div class="portlet-body">
                                        <form id="saveCustomeReport" role="form"
                                            action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                            @csrf
                                            <input type="hidden" name="part_name" value="invoice_roll_index">
                                            <div class="col-md-12 col-sm-12 col-xs-12">
                                                <div class="mt-checkbox-inline col-md-2" style="padding: 0px;" v-for="(row,itemIndex) in customReportData">
                                                    <div class="form-group">
                                                        <table class="table table-striped table-bordered table-advance table-hover">
                                                            <tr>
                                                                <td style="text-align: center;">@{{ row.Name }}</td>
                                                            </tr>
                                                            <tr>
                                                                <td style="text-align: center;">
                                                                    <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
                                                                    <label class="switch">
                                                                        <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                        :checked="row.checkedColumn" >
                                                                        <span class="slider round"></span>
                                                                    </label>
                                                                    <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                        <option value="">@lang('layout.Select')</option>
                                                                        <option value="2">2 %</option>
                                                                        <option value="6">6 %</option>
                                                                        <option value="10">10 %</option>
                                                                        <option value="15">15 %</option>
                                                                        <option value="20">20 %</option>
                                                                        <option value="25">25 %</option>
                                                                        <option value="30">30 %</option>
                                                                        <option value="40">40 %</option>
                                                                        <option value="50">50 %</option>
                                                                        <option value="60">60 %</option>
                                                                    </select>
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="margiv-top-10">
                                                <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->
                                                <button type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i class="fa fa-save"></i> </button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>    
            </div>
        </report-modal>
    </div>
    {{-- custom part start  --}}
    <div id="settingModal" v-cloak>
        <setting-modal :pdf-route="route" v-if="is_show" :value-type="'invoiceRoll'" @closed="closeModal">
            <div slot="header" class="text-center">
                <h4 style="font-weight: bold;">@lang('layout.CustomForms')</h4>
            </div>
            <div slot="body">
                <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->
                <div class="row" v-cloak>
                    <div class="col-md-12 col-sm-12 col-xs-12">
                        <div class="mt-checkbox-inline col-md-2" style="padding: 0px;margin-bottom: 10px;" v-for="(row,itemIndex) in customReportData">
                            <div class="form-group">
                                <table class="table table-striped table-bordered table-advance">
                                    <tr style="background-color: rgba(227, 227, 227, 0.757)">
                                        <th style="text-align: center;">@{{ row.Name }}</th>
                                    </tr>
                                    <tr>
                                        <td style="text-align: center;">
                                            <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
                                            <label class="switch">
                                                <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                :checked="row.checkedColumn" >
                                                <span class="slider round"></span>
                                            </label>
                                        </td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->
            </div>
        </setting-modal>
    </div>
    {{-- custom part end  --}}
    <!-- BEGIN TAB PORTLET-->
    {{-- <div id="app" v-cloak>
        {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}}
        <input type="hidden" name="type" value="invoicelistRoll"/>
        <button id="show-modal" style="display: none" type="button" @click="editExample">Show Modal</button>
        <!-- use the modal component, pass in the prop -->
        <modal v-if="showModal" @close="showModal = false">
            <div slot="body">
                <div class="tabbable tabbable-tabdrop">
                    <ul class="nav nav-tabs">  
                        <li class="active">
                            <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                        </li>
                       @if(systemConfig()[2] != 0 )
                                @permission(['customreport-list'])
                        <li class="">
                            <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                        </li>
                        @endpermission
                        @endif
                    </ul>
                    <div class="tab-content">
                        <div class="tab-pane active" id="tab1">
                            <div class="form-group" style="border: 1px solid rgb(226, 226, 226);padding: 20px;border-radius: 8px;">
                                <div class="row">
                                    <div class="form-group">
                                        <div class="col-md-6">
                                            <label class="control-label ">@lang('layout.SelectMember') </label>
                                            <v-select class="vue-select2" v-model="selectedMember" label="name" @search="onMemberSearch" :options="memberlist">
                                            </v-select>
                                            <input type="hidden" name="member_id" v-model.number="(!selectedMember)?null:selectedMember.id">
                                        </div>
                                        <div class="col-md-6">
                                            <label class="control-label ">@lang('layout.SelectSite') </label>
                                            <v-select class="vue-select2" v-model="selectedInventorySite" label="name" :options="InventorySite">
                                            </v-select>
                                            <input type="hidden" name="inventory_id" v-model.number="(!selectedInventorySite)?null:selectedInventorySite.id">
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="form-group">
                                        <div class="col-md-12">
                                            <label class="control-label ">@lang('layout.Date')</label>
                                                <select name="period" v-model="period" @input="getDates()" class="form-control">
                                                <option value="CustomDates">@lang('type.CustomDates')</option>
                                                <option value="Today">@lang('type.Today')</option>
                                                <option value="Yesterday">@lang('type.Yesterday')</option>
                                                <option value="ThisWeek">@lang('type.ThisWeek')</option>
                                                <option value="LastWeek">@lang('type.LastWeek')</option>
                                                <option value="WeekToDate">@lang('type.WeekToDate')</option>
                                                <option value="ThisMonth">@lang('type.ThisMonth')</option>
                                                <option value="MonthToDate">@lang('type.MonthToDate')</option>
                                                <option value="ThisQuarter">@lang('type.ThisQuarter')</option>
                                                <option value="QuarterToDate">@lang('type.QuarterToDate')</option>
                                                <option value="ThisYear">@lang('type.ThisYear')</option>
                                                <option value="YearToDate">@lang('type.YearToDate')</option>
                                            </select>
                                        </div>
                                        <div class="col-md-12" v-show="period == 'CustomDates'">
                                            <div class="form-group">
                                                <label class="control-label"> @lang('layout.Date')</label>
                                                <div class="input-group">
                                                    <input class="form-control date" id="range-from-example" v-model="from_date" name="from_date" autocomplete="off">
                                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                                    <input class="form-control date" id="range-to-example" v-model="to_date" name="to_date" autocomplete="off">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="tab-pane" id="tab2">
                            <div class="portlet light bordered">
                                <div class="portlet-body">

                                    <form id="saveCustomeReport" role="form"
                                        action="{{route('customeReport.storeCustomeReport')}}" method="post">
                                        @csrf
                                        <input type="hidden" name="part_name" value="invoice_roll_index">


                                        <div class="col-md-12 col-sm-12 col-xs-12">

                                            <div class="mt-checkbox-inline col-md-2" style="padding: 0px;" v-for="(row,itemIndex) in customReportData">

                                                <div class="form-group">
                                                <table class="table table-striped table-bordered table-advance table-hover">
                                                                <tr>
                                                                    <td style="text-align: center;">@{{ row.Name }}</td>
                                                                </tr>
                                                                <tr>
                                                                    <td style="text-align: center;">
                                                                        <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                                        <label class="switch">
                                                                            <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                            :checked="row.checkedColumn" >
                                                                            <span class="slider round"></span>
                                                                        </label>
                                                                        <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                            <option value="">@lang('layout.Select')</option>
                                                                            <option value="2">2 %</option>
                                                                            <option value="6">6 %</option>
                                                                            <option value="10">10 %</option>
                                                                            <option value="15">15 %</option>
                                                                            <option value="20">20 %</option>
                                                                            <option value="25">25 %</option>
                                                                            <option value="30">30 %</option>
                                                                            <option value="40">40 %</option>
                                                                            <option value="50">50 %</option>
                                                                            <option value="60">60 %</option>
                                                                        </select>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="margiv-top-10">
                                            <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->

                                            <button type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i
                                                    class="fa fa-save"></i> </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div slot="footer">
                <button type="submit" class="btn btn-success" @click="ok">
                    @lang('layout.Submit')
                </button>
                <button type="button" class="btn btn-danger" @click="close">
                    @lang('layout.Cancel')
                </button>
            </div>
        </modal>
        {{Form::close()}}
    </div> --}}
    <!-- app -->
    {{-- <div id="app2" v-cloak>
        {{Form::open(['route' => 'export.ExcelAll','method' => 'DELETE','class' => 'inline'])}}
        <input type="hidden" name="type" value="invoicelistRoll"/>
        <button id="show-modal2" style="display: none" type="button" @click="editExample2">Show Modal</button>
        <!-- use the modal component, pass in the prop -->
        <modal v-if="showModal" @close="showModal = false">
            <div slot="body">
                <div class="row">
                    <div class="form-group">

                        <div class="col-md-6">
                            <label class="control-label ">@lang('layout.SelectMember') </label>
                            <v-select class="vue-select2" v-model="selectedMember" label="name" @search="onMemberSearch"
                                      :options="memberlist">
                            </v-select>
                            <input type="hidden" name="member_id"
                                   v-model.number="(!selectedMember)?null:selectedMember.id">
                        </div>

                        <div class="col-md-6">
                            <label class="control-label ">@lang('layout.SelectSite') </label>
                            <v-select class="vue-select2" v-model="selectedInventorySite" label="name" :options="InventorySite">
                            </v-select>
                            <input type="hidden" name="inventory_id" v-model.number="(!selectedInventorySite)?null:selectedInventorySite.id">
                        </div>


                    </div>
                </div>
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <label class="control-label ">@lang('layout.Date')</label>
                                <select name="period" v-model="period" @input="getDates()" class="form-control">
                                <option value="CustomDates">@lang('type.CustomDates')</option>
                                <option value="Today">@lang('type.Today')</option>
                                <option value="Yesterday">@lang('type.Yesterday')</option>
                                <option value="ThisWeek">@lang('type.ThisWeek')</option>
                                <option value="LastWeek">@lang('type.LastWeek')</option>
                                <option value="WeekToDate">@lang('type.WeekToDate')</option>
                                <option value="ThisMonth">@lang('type.ThisMonth')</option>
                                <option value="MonthToDate">@lang('type.MonthToDate')</option>
                                <option value="ThisQuarter">@lang('type.ThisQuarter')</option>
                                <option value="QuarterToDate">@lang('type.QuarterToDate')</option>
                                <option value="ThisYear">@lang('type.ThisYear')</option>
                                <option value="YearToDate">@lang('type.YearToDate')</option>
                            </select>
                        </div>
                        <div class="col-md-12" v-show="period == 'CustomDates'">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example2" v-model="from_date" name="from_date" autocomplete="off">
                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example2" v-model="to_date" name="to_date" autocomplete="off">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div slot="footer">
                <button type="submit" class="btn btn-success" @click="ok">
                    @lang('layout.Submit')
                </button>
                <button type="button" class="btn btn-danger" @click="close">
                    @lang('layout.Cancel')
                </button>
            </div>
        </modal>
        {{Form::close()}}
    </div> --}}
    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="col-md-2 col-sm-2">
                <span class="caption-subject bold uppercase" style="font-size: 20px;">@lang('layout.InvoiceList')</span>
            </div>
            <div class="col-md-5 col-sm-6" id="date_part">
                <div class="form-group">
                    <div class="input-group">
                        <input name="from_date" class="form-control date" ref="from_date" placeholder="@lang('layout.FromDate')" autocomplete="off" />
                        <span class="input-group-addon"> @lang('layout.To') </span>
                        <input name="to_date" class="form-control date" ref="to_date" placeholder="@lang('layout.ToDate')" autocomplete="off" />
                        <span class="input-group-addon btn"  @Click="getData()" > @lang('layout.Search') </span>
                    </div>
                </div>
            </div>
            <div class="portlet-title">
                <div class="caption font-dark">
                    <!-- <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.InvoiceList')</span> -->
                </div>
                <div class="tools"></div>
                <div class="pull-right">
                    <span id="setting-modal">
                        <button type="submit" @click.prevent="showModal" class="btn" style="background-color: rgb(80, 129, 141);color: white;">
                            <i class="fa fa-wrench"></i>
                        </button>
                    </span>
                    @if(getNegativeSale() == 'true')
					<a href="{{route('invoice_roll.index_na')}}">
						<button class="btn btn-success">
                            <i class="fa"></i> @lang('layout.ShowNegativeSale')
                            @if ($nagativeInvoice > 0)
                            <span class="badge badge-default" style="color: #ffffff; background-color: #f90000; font-size: 15px !important;"> {{$nagativeInvoice}} </span>
                            @endif
                        </button>
                    </a>
					@endif
                    @if(getFactorPending() == 'true')
                    <a href="{{route('invoice_roll.index_pending')}}">
						<button class="btn btn-success">
                            <i class="fa"></i> @lang('layout.Factor') @lang('layout.Pending')
                        </button>
                    </a>
                    @endif
                    {{-- @permission('invoiceRoll-export')
                    <button type="submit" id="excell_all" class="btn btn-success"><i
                                class="fa fa-file-excel-o"></i> @lang('layout.Excel') </button>
                    <button type="button" class="btn btn-success" id="print_pdf_all"><i
                                class="fa fa-file-pdf-o"></i> @lang('layout.PDF') </button>
                    @endpermission --}}
                    @permission('invoiceRoll-export')
                    <span id="anchore-modal">
                        <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                            <i class="fa fa-print"></i>
                        </a>
                    </span>
                    @endpermission
                    @permission('invoiceRoll-create')
                    <!-- a href="{{route('invoice_roll.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a -->
					<a href="{{route('invoice_roll.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    <!-- <button class="btn btn-success" id="addNewRefundd">
                            <i class="icon-action-redo"></i> @lang('menu.Refund')
                    </button> -->
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">
                <template v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered table-hover" cellspacing="0" id="invoice">
                    <thead>
                        <tr>
                            <th>@lang('layout.InvoiceNumber')</th>
                            @if(getCustomeForm('invoiceRoll','referenceNumber'))
                            <th>@lang('layout.ReferenceNumber')</th>
                            @endif
                            <th>@lang('layout.CustomerName')</th>
                            <th>@lang('layout.Account')</th>
                            @if(getCustomeForm('invoiceRoll','date'))
                            <th>@lang('layout.Date')</th>
                            @endif
                            @if(getCustomeForm('invoiceRoll','hour'))
                            <th>@lang('layout.Hour')</th>
                            @endif
                            <th>@lang('layout.Currency')</th>
                            <th>@lang('layout.Amount')</th>
                            <th>@lang('layout.Discount')</th>
                            @if(getCustomeForm('invoiceRoll','status'))
                            @if(getFactorPending() == 'true')
                            <th>@lang('layout.Status')</th>
                            @endif
                            @endif
                            @if(getCustomeForm('invoiceRoll','user'))
                            <th>@lang('layout.User')</th>
                            @endif
                            @if(getCustomeForm('invoiceRoll','description'))
                            <th>@lang('layout.Description')</th>
                            @endif
                            <th>@lang('layout.Actions')</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>

    <div id="factor-obj">
    </div>
    <iframe id="saleFrames" style="display: none;"></iframe>
    <!-- end for factor -->
@stop
@include('layouts.setting_model')
@include('groupCompanyFilter.select')
@include('print.modal')
@push('scripts')
    <script>
        var cust_rep = {!!customeReportNewData('invoice_roll_index')!!};
        var settingAll = {!! getUserSetting() !!};
        @if(Session('sale_id') && getFactorPrint()== "automatic")
        factorPrint("{{Session('sale_id')}}", "{{Session('whatsapp')}}")
        @endif
        function factorPrint(id,sendWhatsapp = null,type = null) {
            if (sendWhatsapp == null || sendWhatsapp == '') {
                sendWhatsapp = 'not';
            }
            // console.log(234, type);
            var a = document.createElement('a');
            a.href = "{{url('invoiceRollFactorPrint')}}/" + id + "/" + sendWhatsapp + "/" + type;
            a.target = "_blank";
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
        }        
        function sendVoucherToWhatsapp(id,sendWhatsapp) {
            if (id && sendWhatsapp) {
                axios.get("{{url('invoiceRollFactorPrint')}}/" + id + "/1", {
                    // params: {
                        // method_name: 'SearchMember',
                        // class_id: class_id
                    // }
                })
                .then(function(response) {
                    // console.log(response);
                    if (response.data) {
                        if (sendWhatsapp == 1) {
                            var a = document.createElement('a');
                            a.href = "https://wa.me/?text=" + response.data;
                            a.target = "_blank";
                            document.body.appendChild(a);
                            a.click();
                            document.body.removeChild(a);
                        }
                        if (sendWhatsapp == 2) {
                            var a = document.createElement('a');
                            a.href = "https://telegram.me/share/url?url=Hi&text=" + response.data;
                            a.target = "_blank";
                            document.body.appendChild(a);
                            a.click();
                            document.body.removeChild(a);
                        }
                    }
                })
                .catch(function(error) {
                    console.log(error);
                })
            }
        }
        function voucherOffering(id) { 
            // console.log(234, type);
            var a = document.createElement('a');
            a.href = "{{url('invoiceRollVoucherOffering')}}/" + id;
            a.target = "_blank";
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
        }
        function grnPrint(id,type = null) {
            var a = document.createElement('a');
            a.href = "{{url('grnFactorPrintRoll')}}/" + id + "/" + type;
            a.target = "_blank";
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
        }		
        let data_table;
        function getRecord() {
            // console.log(234, vtr.from_date, vtr.to_date);
            data_table = $('#invoice').DataTable({
                ajax: {
                    ajax: '{{route("invoice_roll.index")}}',
                    data: {
                        from_date: vtr.from_date,
                        to_date: vtr.to_date
                    }
                },
                pageLength: '{{getPageRows()}}',
                scrollCollapse: true,
                order: [["{{orderByColumn()=='number'?0:3}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                destroy: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
                    {data: 'number', name: 'sales.number'},
                    @if(getCustomeForm('invoiceRoll','referenceNumber'))
                    {data: 'ref_no', name: 'sales.ref_no'},
                    @endif
                    {data: 'member_name', name: 'members.name'},
                    {data: 'account_name', name: 'accounts.name'},
                    @if(getCustomeForm('invoiceRoll','date'))
                    {data: 'date', name: 'sales.date', searchable: false},
                    @endif
                    @if(getCustomeForm('invoiceRoll','hour'))
                    {data: 'hour', name: 'invoice.hour', searchable: false},
                    @endif
                    {data: 'currency', name: 'transactions.unit'},
                    {data: 'amount', name: 'transactions.amount'},
                    {data: 'discount', name: 'discount', orderable: false, searchable: false},
                    @if(getCustomeForm('invoiceRoll','status'))
                    @if(getFactorPending() == 'true')
                    {data: 'status', name: 'status', orderable: false, searchable: false},
                    @endif
                    @endif
                    @if(getCustomeForm('invoiceRoll','user'))
                    {data: 'username', name: 'users.name'},
                    @endif
                    @if(getCustomeForm('invoiceRoll','description'))
                    {data: 'description', name: 'sales.description' @if(getGeneralSearch()) , searchable: false @endif},
                    @endif
                    {data: 'actions', name: 'account', orderable: false, searchable: false},
                    //              { data: 'measure_unit_id', name: 'quantity' },
                    //              { data: 'measure_unit', name: 'rate' },

                ]
            });
        }
        $(document).ready(function() {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            getRecord();
        });
        Vue.component('v-select', VueSelect.VueSelect)
        var Modal = Vue.component('modal', {
            template: '#modal-template',
            methods: {
                ok: function () {
                    this.$emit('ok')
                }
            }
        });
        // start app
        inventorySite = {!! $inventorySite !!};

        // var app = new Vue({
            //     el: '#app',
            //     data: {
            //         period: 'CustomDates',
            //         from_date: null,
            //         to_date: null,
            //         selectedInventorySite: null,
            //         InventorySite: inventorySite,
            //         showModal: false,
            //         selectedMember: null,
            //         memberlist: [],
            //         customReportData:
            //         [
            //         {Name: '@lang("layout.Record")', column_name: 'record',checkedColumn:(cust_rep.record)?'checked':'',column_percentage:(cust_rep.record___percent)?cust_rep.record___percent:''},
            //          {Name: '@lang("layout.Number")', column_name: 'number',checkedColumn:(cust_rep.number)?'checked':'',column_percentage:(cust_rep.number___percent)?cust_rep.number___percent:''},
            //          {Name: '@lang("layout.AccountName")', column_name: 'account_name',checkedColumn:(cust_rep.account_name)?'checked':'',column_percentage:(cust_rep.account_name___percent)?cust_rep.account_name___percent:''},
            //          {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_rep.date)?'checked':'',column_percentage:(cust_rep.date___percent)?cust_rep.date___percent:''},
            //          {Name: '@lang("layout.Employee")', column_name: 'employee',checkedColumn:(cust_rep.employee)?'checked':'',column_percentage:(cust_rep.employee___percent)?cust_rep.employee___percent:''},
            //          {Name: '@lang("layout.Amount")', column_name: 'amount',checkedColumn:(cust_rep.amount)?'checked':'',column_percentage:(cust_rep.amount___percent)?cust_rep.amount___percent:''},
            //          {Name: '@lang("layout.Currency")', column_name: 'currency',checkedColumn:(cust_rep.currency)?'checked':'',column_percentage:(cust_rep.currency___percent)?cust_rep.currency___percent:''},
            //          {Name: '@lang("layout.Rate")', column_name: 'rate',checkedColumn:(cust_rep.rate)?'checked':'',column_percentage:(cust_rep.rate___percent)?cust_rep.rate___percent:''},
            //          {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_rep.description)?'checked':'',column_percentage:(cust_rep.description___percent)?cust_rep.description___percent:''},
            //           ],
            //           cust_rep:cust_rep
            //     },
            //     methods: {
            //         onMemberSearch(search, loading) {
            //             loading(true);
            //             this.searchMember(search, loading, this);
            //         },
            //         //ajax call to get items
            //         searchMember(search, loading, vm) {
            //             axios.get("{{route('callMethod.search')}}", {
            //                 params: {
            //                     method_name: 'member',
            //                     type: 'Customer',
            //                     search: search,
            //                 }
            //             })
            //                 .then(function (response) {
            //                     this.memberlist = [];
            //                     if (response.data.length > 0) {
            //                         vm.memberlist = response.data;
            //                         console.log('data', vm.memberlist);
            //                     }
            //                     loading(false);
            //                 })
            //                 .catch(function (error) {
            //                     console.log(error);
            //                 })
            //         },
            //         ok: function () {
            //             //alert('you clicked me');
            //             this.showModal = !this.showModal;
            //         },
            //         close: function (e) {
            //             this.showModal = !this.showModal;
            //         },
            //         editExample: function () {

            //             //Your other code that launches the modal
            //             this.showModal = true;
            //             this.$nextTick(function () {
            //                 $(document).ready(function () {
            //                     $(".date").persianDatepicker(modelDate());
            //                 });
            //             })
            //         },
            //         //ajax call to get dates
            //         getDates() {
            //             setTimeout((function () {
            //             app.getDate(app.period);
            //                 // console.log(12);
            //             }), 2e2);
            //         },
            //         getDate(period) {
            //             if (period) {
            //             // console.log(3232, period);
            //             if (period != 'CustomDates') {
            //                 axios.get("{{route('callMethod.search')}}", {
            //                 params: {
            //                     method_name: 'getDatesByPeriod',
            //                     period: period,
            //                 }
            //                 })
            //                 .then(function(response) {
            //                 app.from_date = null;
            //                 app.to_date = null;
            //                 if (response.data) {
            //                     app.from_date = response.data.start;
            //                     app.to_date = response.data.end;
            //                     // console.log('data', response.data);
            //                 }
            //                 })
            //                 .catch(function(error) {
            //                 app.period = 'CustomDates';
            //                 app.from_date = null;
            //                 app.to_date = null;
            //                 })
            //             } else {
            //                 app.from_date = null;
            //                 app.to_date = null;
            //             }
            //             }
            //         },
            //     },
            // });
            // $('#print_pdf_all').on('click', function (e) {
            //     $('#show-modal').click();
            //     e.preventDefault();
            // })


            // var app2 = new Vue({
            //     el: '#app2',
            //     data: {
            //         period: 'CustomDates',
            //         from_date: null,
            //         to_date: null,
            //         selectedInventorySite: null,
            //         InventorySite: inventorySite,
            //         showModal: false,
            //         selectedMember: null,
            //         memberlist: [],
                
            //     },
            //     methods: {
            //         onMemberSearch(search, loading) {
            //             loading(true);
            //             this.searchMember(search, loading, this);
            //         },

            //         //ajax call to get items
            //         searchMember(search, loading, vm) {
            //             axios.get("{{route('callMethod.search')}}", {
            //                 params: {
            //                     method_name: 'member',
            //                     type: 'Customer',
            //                     search: search,
            //                 }
            //             })
            //                 .then(function (response) {
            //                     this.memberlist = [];
            //                     if (response.data.length > 0) {
            //                         vm.memberlist = response.data;
            //                         console.log('data', vm.memberlist);
            //                     }
            //                     loading(false);
            //                 })
            //                 .catch(function (error) {
            //                     console.log(error);
            //                 })
            //         },
            //         ok: function () {
            //             //alert('you clicked me');
            //             this.showModal = !this.showModal;
            //         },
            //         close: function (e) {
            //             this.showModal = !this.showModal;
            //         },
            //         editExample2: function () {

            //             //Your other code that launches the modal
            //             this.showModal = true;
            //             this.$nextTick(function () {
            //                 $(document).ready(function () {
            //                     $(".date").persianDatepicker(modelDate());
            //                 });
            //             })
            //         },
            //         //ajax call to get dates
            //         getDates() {
            //             setTimeout((function () {
            //             app2.getDate(app2.period);
            //                 // console.log(12);
            //             }), 2e2);
            //         },
            //         getDate(period) {
            //             if (period) {
            //             // console.log(3232, period);
            //             if (period != 'CustomDates') {
            //                 axios.get("{{route('callMethod.search')}}", {
            //                 params: {
            //                     method_name: 'getDatesByPeriod',
            //                     period: period,
            //                 }
            //                 })
            //                 .then(function(response) {
            //                 app2.from_date = null;
            //                 app2.to_date = null;
            //                 if (response.data) {
            //                     app2.from_date = response.data.start;
            //                     app2.to_date = response.data.end;
            //                     // console.log('data', response.data);
            //                 }
            //                 })
            //                 .catch(function(error) {
            //                 app2.period = 'CustomDates';
            //                 app2.from_date = null;
            //                 app2.to_date = null;
            //                 })
            //             } else {
            //                 app2.from_date = null;
            //                 app2.to_date = null;
            //             }
            //             }
            //         },
            //     },
            // });
            // $('#excell_all').on('click', function (e) {
            //     $('#show-modal2').click();
            //     e.preventDefault();
        // })

        // Refund Modal
        new Vue({
            el: '#ww',
            data: {
                showModal: false
            },
            methods: {
                ok: function () {
                    //alert('you clicked me');
                    this.showModal = !this.showModal;
                },
                close: function (e) {
                    this.showModal = !this.showModal;
                },
                editExampleww: function () {

                    //Your other code that launches the modal
                    this.showModal = true;
                    this.$nextTick(function () {
                        $(document).ready(function () {
                            $(".date").persianDatepicker(modelDate());
                        });
                    })
                }

            },
        });
        $('#addNewRefundd').on('click', function (e) {
            $('#show-modalww').click();
            e.preventDefault();
        })
        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    if (typeof data_table == 'object') {
                        data_table.clear();
                        data_table.ajax.reload();
                    }
                }
            }
        });
        var vtr = new Vue({
            el: '#date_part',
            data: {
                from_date: null,
                to_date: null,
            },
            methods: {
                getData() {
                    this.from_date = this.$refs.from_date.value;
                    this.to_date = this.$refs.to_date.value;
                    getRecord();
                }
            }
        });
        var vm = new Vue({
            el: '#print-modal',
            data: {
                period: 'CustomDates',
                from_date: null,
                to_date: null,
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',
                selected_member:null,
                selectedMember: null,
                selectedInventorySite: null,
                InventorySite: inventorySite,
                memberlist:[],
                customReportData:
                [
                {Name: '@lang("layout.Record")', column_name: 'record',checkedColumn:(cust_rep.record)?'checked':'',column_percentage:(cust_rep.record___percent)?cust_rep.record___percent:''},
                 {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_rep.date)?'checked':'',column_percentage:(cust_rep.date___percent)?cust_rep.date___percent:''},
                 {Name: '@lang("layout.Hour")', column_name: 'hour',checkedColumn:(cust_rep.hour)?'checked':'',column_percentage:(cust_rep.hour___percent)?cust_rep.hour___percent:''},
                 {Name: '@lang("layout.InvoiceNumber")', column_name: 'invoiceNumber',checkedColumn:(cust_rep.invoiceNumber)?'checked':'',column_percentage:(cust_rep.invoiceNumber___percent)?cust_rep.invoiceNumber___percent:''},
                 {Name: '@lang("layout.ReferenceNumber")', column_name: 'referenceNumber',checkedColumn:(cust_rep.referenceNumber)?'checked':'',column_percentage:(cust_rep.referenceNumber___percent)?cust_rep.referenceNumber___percent:''},
                 {Name: '@lang("layout.Customer")', column_name: 'customer',checkedColumn:(cust_rep.customer)?'checked':'',column_percentage:(cust_rep.customer___percent)?cust_rep.customer___percent:''},
                 {Name: '@lang("menu.TransportCompany")', column_name: 'transportCompany',checkedColumn:(cust_rep.transportCompany)?'checked':'',column_percentage:(cust_rep.transportCompany___percent)?cust_rep.transportCompany___percent:''},
                 {Name: '@lang("layout.Driver")', column_name: 'driver',checkedColumn:(cust_rep.driver)?'checked':'',column_percentage:(cust_rep.driver___percent)?cust_rep.driver___percent:''},
                 {Name: '@lang("layout.AccountName")', column_name: 'accountName',checkedColumn:(cust_rep.accountName)?'checked':'',column_percentage:(cust_rep.accountName___percent)?cust_rep.accountName___percent:''},
                 {Name: '@lang("layout.Amount")', column_name: 'amount',checkedColumn:(cust_rep.amount)?'checked':'',column_percentage:(cust_rep.amount___percent)?cust_rep.amount___percent:''},
                 {Name: '@lang("layout.Currency")', column_name: 'currency',checkedColumn:(cust_rep.currency)?'checked':'',column_percentage:(cust_rep.currency___percent)?cust_rep.currency___percent:''},
                 {Name: '@lang("layout.Rate")', column_name: 'rate',checkedColumn:(cust_rep.rate)?'checked':'',column_percentage:(cust_rep.rate___percent)?cust_rep.rate___percent:''},
                 {Name: '@lang("layout.DiscountType")', column_name: 'discountType',checkedColumn:(cust_rep.discountType)?'checked':'',column_percentage:(cust_rep.discountType___percent)?cust_rep.discountType___percent:''},
                 {Name: '@lang("layout.Discount")', column_name: 'discount',checkedColumn:(cust_rep.discount)?'checked':'',column_percentage:(cust_rep.discount___percent)?cust_rep.discount___percent:''},
                 {Name: '@lang("layout.User")', column_name: 'user',checkedColumn:(cust_rep.user)?'checked':'',column_percentage:(cust_rep.user___percent)?cust_rep.user___percent:''},
                 {Name: '@lang("layout.Total")', column_name: 'total',checkedColumn:(cust_rep.total)?'checked':'',column_percentage:(cust_rep.total___percent)?cust_rep.total___percent:''},
                  ],
                  cust_rep:cust_rep
            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show;
                },
                onMemberSearch(search, loading) {
                    loading(true);
                    this.searchMember(search, loading, this);
                },

                searchMember(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'member',
                            type: 'Employee',
                            search: search,
                        }
                    })
                    .then(function (response) {
                        this.memberlist = [];
                        if (response.data.length > 0) {
                            vm.memberlist = response.data;
                        }
                        loading(false);
                    })
                    .catch(function (error) {
                        console.log(error);
                    })
                },
                //ajax call to get dates
                getDates() {
                    setTimeout((function () {
                    vm.getDate(vm.period);
                        // console.log(12);
                    }), 2e2);
                },
                getDate(period) {
                    if (period) {
                    // console.log(3232, period);
                    if (period != 'CustomDates') {
                        axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'getDatesByPeriod',
                            period: period,
                        }
                        })
                        .then(function(response) {
                        vm.from_date = null;
                        vm.to_date = null;
                        if (response.data) {
                            vm.from_date = response.data.start;
                            vm.to_date = response.data.end;
                            // console.log('data', response.data);
                        }
                        })
                        .catch(function(error) {
                        vm.period = 'CustomDates';
                        vm.from_date = null;
                        vm.to_date = null;
                        })
                    } else {
                        vm.from_date = null;
                        vm.to_date = null;
                    }
                    }
                },
            }
        });
        var anchor = new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;
                }
            }
        });
        // custom part start 
        var cust_form = {!!customeForm('invoiceRoll')!!};
        var sm = new Vue({
            el: '#settingModal',
            data: {
                is_show: false,
                route: '{!!route("customForm.store") !!}',
                customReportData:
                [    
                    {Name: '@lang("layout.ReferenceNumber")', column_name: 'referenceNumber',checkedColumn:(cust_form.referenceNumber)?'checked':''},   
                    {Name: '@lang("layout.Commission")', column_name: 'commission',checkedColumn:(cust_form.commission)?'checked':''},
                    {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_form.description)?'checked':''},
                    {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_form.date)?'checked':''},
                    {Name: '@lang("layout.OverdueDate")', column_name: 'overdueDate',checkedColumn:(cust_form.overdueDate)?'checked':''},
                    {Name: '@lang("layout.Hour")', column_name: 'hour',checkedColumn:(cust_form.hour)?'checked':''},
                    {Name: '@lang("layout.Status")', column_name: 'status',checkedColumn:(cust_form.status)?'checked':''},
                    {Name: '@lang("layout.User")', column_name: 'user',checkedColumn:(cust_form.user)?'checked':''},
                ],
                cust_form:cust_form
            },
            watch: {
            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },
            }
        });
        new Vue({
            el: '#setting-modal',
            methods: {
                showModal: function () {
                    // console.log('trr')
                    sm.$data.is_show = true
                }
            }
        });
        // custom part end
    </script>
@endpush