@extends('layouts.factor-master')
@section('style')

<style>
  .small-table td,
  .main-table td,
  .main-table tr,
  .small-table th,
  .main-table th {}
  .mt {
    background-color: #afb6bf;
    text-align: center;
    font-weight: bold;
  }

  .t1 {
    font-size: 14px;
    font-weight: bold;

    background-color: {
        {
        company()['color']
      }
    }

    ;
  }
</style>
@stop
@section('content')

<div>
  <div style=" font-size: 12px !important">

    <!--End Table 2 For Invoice Information-->
    <?php
    $str_date = convertdate($sales->date);

    $date_string = substr($str_date, 0, 10);
    ?>
    <table style="width: 100%; margin-top: 10px;">
      <tr>
        <td style="text-align: left; width:35%">
          <table class="main-table">
            <tr>
              <td align="right"><b>@lang('layout.InvoiceNumber') : {{$sales->number}}</b></td>
            </tr>
            <tr>
              <td align="right"><b>@lang('layout.Date') : 
                  @if(getInvoiceDateFormat() == "shamsi")
                  <?php
                  $str_date = convertdate($sales->date, 0, 'jalali');

                  $date_string = substr($str_date, 0, 10)
                  ?>
                  {{$date_string}}

                  @elseif(getInvoiceDateFormat() =='both')

                  <?php
                  $str_date = convertdate($sales->date, 0, 'jalali');

                  $date_string = substr($str_date, 0, 10);
                  echo $date_string;
                  ?>
                  &nbsp;/&nbsp;
                  {{substr($sales->date,0,10)}}

                  @elseif(getInvoiceDateFormat() =="meladi")
                  {{substr($sales->date,0,10)}}

                  @else

                  {{$str_date}}

                  @endif
                </b></td>
            </tr>
            <tr>
              <td align="right"><b>@lang('layout.Name') : {{$member->name}}</b></td>
            </tr>
          </table>
        </td>

        <td width="30%"><center><b style="font-size: 40px;">@lang('layout.Invoice')</b></center></td>
        <td style="text-align: right; width:35%">
          <table class="main-table">
            <tr>
              <td align="right"><b>@lang('layout.Address') : {{$address.' '.$city}}</b></td>
            </tr>
            <tr>
              <td align="right"><b>@lang('layout.Phone') : {{$phone}}</b></td>
            </tr>
            <tr>
              <td align="right"><b>@lang('layout.Code') @lang('layout.Customer') : {{$member->code}}</b></td>
            </tr>
          </table>
        </td>
      </tr>
    </table>




    <!--Table 3 For Data  Information-->
    <table class="main-table" style="margin-top: 20px;" cellpadding="5px">
      <tr style="font-weight: bold; font-size: 17px">
        <td class="mt">
          <div class="center">@lang('layout.Number')</div>
        </td>
        <!--<td class="mt"><div class="center">@lang('layout.ItemCode')</div></td>-->
        <td class="mt" >
          <div class="center">@lang('layout.Item')</div>
        </td>

        @if(systemConfig()[9] == 1 )
        <td class="mt">
          <div class="center">@lang('layout.Code')</div>
        </td>
        @endif

        @if(getItemImage()=="true")
        <td class="mt">
          <div class="center">@lang('layout.ItemImage')</div>
        </td>
        @endif
        @if(getItemOtherName()=="true")
        <td class="mt">
          <div class="center">@lang('layout.ItemOtherName')</div>
        </td>
        @endif
        @if(getInventorySite()=="true")
        <td class="mt">
          <div class="center">@lang('layout.Site')</div>
        </td>
        @endif
        @if(systemConfig()[9] == 0 )
        @if(getShowWing()!="false")
        <td class="mt">
          <div class="center">@lang('layout.Bundl')</div>
        </td>
        <td class="mt">
          <div class="center">@lang('layout.Wing')</div>
        </td>
        @endif
        @endif

        @if(getInventoryBrand()=="true")
        <td class="mt">
          <div class="center">@lang('layout.Brand')</div>
        </td>
        @endif
        @if($type == 3 && getOtherMeasure()=="true")
        <td class="mt">
          <div class="center">@lang('layout.Quantity')</div>
        </td>
        @else
        <td class="mt">
          <div class="center">@lang('layout.Quantity')</div>
        </td>
        <td class="mt">
          <div class="center">@lang('layout.Unit/M')</div>
        </td>
        @endif
        @if($type != 2 && $type != 3)
        @if(getOtherMeasure()=="true")
        <td class="mt">
            <div class="center">@lang('layout.Measure2')</div>
        </td>
        @endif
        @if(getOtherMeasure2()=="true")
        <td class="mt">
            <div class="center">@lang('layout.Measure3')</div>
        </td>
        @endif
        @endif

        @if(getM2()!="")
        @if(getFactorMeasure2()=="true")
        <td class="mt">
          <div class="center">@lang('layout.Measure2')</div>
        </td>
        @endif
        @endif
        @if(getM3()!="")
        @if(getFactorMeasure3()=="true")
        <td class="mt">
          <div class="center">@lang('layout.Measure3')</div>
        </td>
        @endif
        @endif
        @if(getM4()!="")
        @if(getFactorMeasure4()=="true")
        <td class="mt">
          <div class="center">@lang('layout.Measure4')</div>
        </td>
        @endif
        @endif
        <!-- @if(getSaleDescription()=="true")
        <td class="mt">
          <div class="center">@lang('layout.Description')</div>
        </td>
        @endif -->
        <td class="mt">
          <div class="center">@lang('layout.Rate')</div>
        </td>
        @if(getSaleDiscount()=="true")
        <!--td class="mt"><div class="center">@lang('layout.Sub-Total')</div></td>
        <td class="mt"><div class="center">@lang('layout.Discount')</div></td -->
        @endif
        <td class="mt">
          <div class="center">@lang('layout.Total')</div>
        </td>

      </tr>
      <?php

      $count = 0;
      $empty = 0;
      $fullCount = count($data);
      $total_discount = 0;

      if ($transportCompany->driver_name || $transportCompany->trasnport_name != null) {
        if ($fullCount < 12) {
          $empty = 12 - $fullCount;
        }
      } else {
        if ($fullCount < 15) {
          $empty = 15 - $fullCount;
        }
      }
      ?>
      @foreach($data AS $key1=>$record)
      <?php

      if ($sales->discount_type == "currency") {
        $total_discount += $record['discount'] * $record['qty'];
      } else {
        $t = ($record['price'] * $record['qty']);
        $total_discount += ($record['discount']) * $t / 100;
      }

      ?>
      <tr>

        <td class="center">{{++$count}}</td>
        <!--<td class="center">{{$record['number']}}</td>-->
        <td class="center">{{$record['name']}}</td>
        @if(systemConfig()[9] == 1 )
        <td class="center">{{$record['code']}}</td>
        @endif

        @if(getItemImage()=="true")
        <td class="center" style="margin: 0px;padding: 0px;"><img alt="" style="height: 80px;width: 80px;" class="img-circle" src="{{public_path().'/uploads/codes/'.$record['image']}}" /></td>
        @endif
        @if(getItemOtherName()=="true")
        <td class="center">{{$record['item_other_name']}}</td>
        @endif
        @if(getInventorySite()=="true")
        <td class="center">{{$record['siteName']}}</td>
        @endif
        @if(systemConfig()[9] == 0 )
        @if(getShowWing()!="false")
        <td class="center">{{$record['bandl']}}</td>
        <td class="center">{{$record['total_khada']}}</td>
        @endif
        @endif
        @if(getInventoryBrand()=="true")
        <td class="center">{{$record['brand_name']}}</td>
        @endif

        @if($type == 3 && getOtherMeasure()=="true")
        <td class="center">{{$record['other_measure']}} {{$record['o_measure_name']}}</td>
        @else
        <td class="center">{{$record['qty']}}</td>
        <td class="center">{{$record['symbol']}}</td>
        @endif

        @if($type != 2 && $type != 3)
        @if(getOtherMeasure()=="true")
        <td class="center">{{$record['other_measure']}} {{$record['o_measure_name']}}</td>
        @endif

        @if(getOtherMeasure2()=="true")
        <td class="center">{{$record['other_measure2']}} {{$record['o_measure_name2']}}</td>
        @endif
        @endif

        @if(getM2()!="")
        @if(getFactorMeasure2()=="true")
        <td class="center">{{$record['qty1']}}</td>
        @endif
        @endif
        @if(getM3()!="")
        @if(getFactorMeasure3()=="true")
        <td class="center">{{$record['qty2']}}</td>
        @endif
        @endif
        @if(getM4()!="")
        @if(getFactorMeasure4()=="true")
        <td class="center">{{$record['qty3']}}</td>
        @endif
        @endif

        <!-- @if(getSaleDescription()=="true")
        <td class="center">{{$record['itemDescription']}}</td>
        @endif -->
        @if($per_qty=="on" && $type != 1 && $type != 2)
        <td class="center">{{simpleRound($record['other_price'])}}</td>
        @else
        <td class="center">{{simpleRound($record['price'])}}</td>
        @endif

        @if(getSaleDiscount()=="true")
        <!-- td class="center">{{ Currency()->format($record['price']*$record['qty'],$sales->currency)}}</td>
        <td class="center">{{$record['discount']}} {{($sales->discount_type=="percent")? '%' : $sales->currency}}</td -->
        @endif
        <!-- <td class="center">{{ Currency()->format($record['price']*$record['qty'],$sales->currency)}}</td> -->

        @if($sales->discount_type=="currency")
        <td class="center">{{ Currency()->format(($record['price']*$record['qty'])-$record['discount']*$record['qty'],$sales->currency)}}</td>
        @else
        <td class="center">{{ Currency()->format(($record['price']*$record['qty'])-($record['discount']*$record['price']/100)*$record['qty'],$sales->currency)}}</td>
        @endif
      </tr>

      @endforeach



      @for($i=0;$i<$empty;$i++)
        <?php ?> 
        @if(getPaperSize()=='A4' && getPaperStyle()=='portrait' ) @if(getWhiteRows()=="true" ) 
      <tr>

        <td class="center" style="height: 30px"></td>
        <td class="center"></td>
        @if(systemConfig()[9] == 1 )
        <td class="center"></td>
        @endif
        @if(getItemImage()=="true")
        <td class="center"></td>
        @endif
        @if(getItemOtherName()=="true")
        <td class="center"></td>
        @endif
        @if(getInventorySite()=="true")
        <td class="center"></td>
        @endif
        @if($type == 3 && getOtherMeasure()=="true")
        <td class="center"></td>
        @else
        <td class="center"></td>
        <td class="center"></td>
        @endif
        @if(systemConfig()[9] == 0 )
        @if(getShowWing()!="false")
        <td class="center"></td>
        <td class="center"></td>
        @endif
        @endif
        @if(getInventoryBrand()=="true")
        <td class="center"></td>
        @endif
        @if($type != 2 && $type != 3)
        @if(getOtherMeasure()=="true")
        <td class="center"></td>
        @endif
        @if(getOtherMeasure2()=="true")
        <td class="center"></td>
        @endif
        @endif
        @if(getM2()!="")
        @if(getFactorMeasure2()=="true")
        <td class="center"></td>
        @endif
        @endif

        @if(getM3()!="")
        @if(getFactorMeasure3()=="true")
        <td class="center"></td>
        @endif
        @endif
        @if(getM4()!="")
        @if(getFactorMeasure4()=="true")
        <td class="center"></td>
        @endif
        @endif

        <!-- @if(getSaleDescription()=="true")
        <td class="center"></td>
        @endif -->
        <td class="center"></td>
        @if(getSaleDiscount()=="true")
        <!-- td class="center"></td>
        <td class="center"></td -->
        @endif
        <td class="center"></td>
        </tr>
        @endif
        @endif
        @endfor

        <?php
        if ($sales->discount_type == "currency") {
          echo Currency()->format($discountToShow, $sales->currency);
        } else {
          echo round($discountToShow, 2) . '%';
        }

        $discountTotal = 0;
        foreach ($data as $key => $value) {
          $discountTotal = ($value['discount'] * $value['qty']) + $discountTotal;
        }
        $total_discount = $discountToShow;

        ?>

        </tbody>
    </table>
    <!--End Table 3 For Data Information-->


    <!--Table 4 For Total  Information-->
    <table class="main-table" style="margin-top: 8px;">
      @if(getSaleDiscount()=="true")

      <tr>
        <td colspan="5">
          <div class="center" style="font-size: bold;"><b>@lang('layout.SubTotalInLeters'):&nbsp; {{notowo(round(abs($total)),'fa')}}</b></div>
        </td>

        <td colspan="5">
          <div class="center" style="font-size: bold;"><b>@lang('layout.Sub-Total'):&nbsp;{{simpleRound($total)}} @lang('currency.'.($sales->currency)) <br>

              @if($sales->currency != getHomeCurrency()["code"])
              مجموع دالر: {{simpleRound($total-$total_discount)/$sales->rate}}
              @endif
            </b></div>
        </td>


      </tr>
      @endif





      <tr>
        <td colspan="4">
          <div class="center" style="font-size: bold;"><b>@lang('layout.TotalInLeters'):&nbsp; {{notowo(round(abs($total-$total_discount)),'fa')}}</b></div>
        </td>
        <!-- <td colspan="2"><div class="center" style="font-size: bold;"><b>@lang('layout.Total'):&nbsp;{{round($total)}}  @lang('currency.'.($sales->currency)) <br>

        @if($sales->currency != getHomeCurrency()["code"])
        مجموع  دالر: {{round($total)/$sales->rate}}
        @endif
        </b></div></td> -->

        <td colspan="2">
          <div class="center">@lang('layout.Recipt'):&nbsp;
            @if($sales->type == "InvoiceRoll")
            {{simpleRound($paid)}} @lang('currency.'.($sales->currency))
            @endif
          </div>
        </td>
        <td colspan="4">
          <div class="center" style="font-size: bold;"><b>@lang('layout.Total'):&nbsp;{{simpleRound($total-$total_discount)}} @lang('currency.'.($sales->currency)) <br>

              @if($sales->currency != getHomeCurrency()["code"])
              مجموع به : {{simpleRound(($total-$total_discount)/$sales->rate)}} {{getHomeCurrency()["code"]}}
              @endif
            </b></div>
        </td>


      </tr>


      <tr>

        <td colspan="2">
          <div class="center">@lang('layout.Discount'):&nbsp;
            <span>
              @if($sales->discount_type=="currency")
              {{simpleRound(($discountToShow))}} @lang('currency.'.($sales->currency))
              @else
              {{simpleRound($discountToShow)}} @lang('currency.'.($sales->currency))
              <!-- span></span -->
              @endif
            </span>

          </div>
        </td>


        <td colspan="2">
          <div class="center">@lang('layout.Remined'):&nbsp;
            @if($sales->type == "InvoiceRoll")
            {{simpleRound((($total) - (($discount * $total) / 100)-$paid))}} @lang('currency.'.($sales->currency))
            @endif</div>
        </td>

        <td colspan="3">
          @if(getHesabSabeqa() =='true')
          <div class="center">@lang('layout.HesabSabiqa'): &nbsp;
            @if($sales->type == "InvoiceRoll")
            @if(getHesabSabeqahType()=="currency")
            {{simpleRound($balance - $total + ($discountToShow+$paid))}} 
            @else
            {{simpleRound($balance - ($total/$sales->rate) + (($discountToShow+$paid)/$sales->rate))}} {{getHomeCurrency()["code"]}}
            @endif
            @endif
          </div>

        </td>

        <td colspan="3">
          <div class="center"><b>@lang('layout.AmountPayable'):&nbsp;
              @if($sales->type == "InvoiceRoll")
              @if(getHesabSabeqahType()=="currency")
              {{simpleRound(((($balance)-$total+$discountToShow)+$paid)+($total - (($discount * $total) / 100)-$paid))}}
              @else
              {{simpleRound(((($balance * $sales->rate)-$total+$discountToShow)+$paid)+($total - (($discount * $total) / 100)-$paid))}} @lang('currency.'.($sales->currency))
              @endif
              @endif
            </b></div>
        </td>
        @endif
        @if(getHesabSabeqa() =='false')
        <td colspan="3">
          <div class="center"><b>@lang('layout.AmountPayable'):&nbsp;
              @if($sales->type =="InvoiceRoll")
              {{simpleRound(($total - (($discount * $total) / 100)-$paid))}} @lang('currency.'.($sales->currency))
              @endif
            </b></div>
        </td>
        @endif

      </tr>

    </table>
    @if($invoice_des)
    <table width="60%" border="1" style="border-collapse: collapse; margin-top: 7px;">
      <tr>
        <td style="font-size: 14px;">{{$invoice_des}}</td>
      </tr>
    </table>
    @endif
    <!--End Table 4 For Total  Information-->



    @if(getTransportCompany()=="true")
    @if(transportCompanyFactor()=="true")
    @if($transportCompany)
    @if($transportCompany->driver_name || $transportCompany->trasnport_name!=null )
    <!--Driver Info-->

    <table style="width: 100%; margin-top: 10px;">
      <tr>
        <td style="text-align: left; width:50%">
          <table class="main-table">
            <tr>
              <td align="center" colspan="2">
                <b style="font-size: 20px;">@lang('menu.TransportCompany')</b>
              </td>

            </tr>

            <tr style="font-weight: bold; font-size: 17px">
              <td align="right"><b>@lang('layout.Number')</b></td>
              <td align="right"><b>{{$transportCompany->trasnport_number}}</b></td>
            </tr>
            <tr>
              <td align="right"><b>@lang('layout.LicenseNumber')</b></td>
              <td align="right"><b>{{$transportCompany->trasnport_license_number}}</b></td>
            </tr>
            <tr>
              <td align="right"><b>@lang('layout.Name')</b></td>
              <td align="right"><b>{{$transportCompany->trasnport_name}}</b></td>
            </tr>
            <tr>
              <td align="right"><b>@lang('layout.Phone')</b></td>
              <td align="right"><b>{{$transportCompany->trasnport_phone}}</b></td>
            </tr>
            <tr>
              <td align="right"><b>@lang('layout.Email')</b></td>
              <td align="right"><b>{{$transportCompany->trasnport_email}}</b></td>
            </tr>
            <tr>
              <td align="right"><b>@lang('layout.City')</b></td>
              <td align="right"><b>{{$transportCompany->trasnport_city}}</b></td>
            </tr>
            <tr>
              <td align="right"><b>@lang('layout.Address')</b></td>
              <td align="right"><b>{{$transportCompany->trasnport_address}}</b></td>
            </tr>

          </table>
        </td>

        <td style="text-align: right; width:50%">
          <table class="main-table">
            <tr>
              <td align="center" colspan="2">
                <b style="font-size: 20px;">@lang('layout.Driver')</b>
              </td>

            </tr>
            <tr style="font-weight: bold; font-size: 17px">
              <td align="right"><b>@lang('layout.Number')</b></td>
              <td align="right"><b>{{$transportCompany->driver_code}}</b></td>
            </tr>
            <tr>
              <td align="right"><b>@lang('layout.SSID')</b></td>
              <td align="right"><b>{{$transportCompany->driver_ss_id}}</b></td>
            </tr>
            <tr>
              <td align="right"><b>@lang('layout.Name')</b></td>
              <td align="right"><b>{{$transportCompany->driver_name}}</b></td>
            </tr>
            <tr>
              <td align="right"><b>@lang('layout.LastName')</b></td>
              <td align="right"><b>{{$transportCompany->driver_last_name}}</b></td>
            </tr>
            <tr>
              <td align="right"><b>@lang('layout.Phone')</b></td>
              <td align="right"><b>{{$transportCompany->driver_phone}}</b></td>
            </tr>
            <tr>
              <td align="right"><b>@lang('layout.City')</b></td>
              <td align="right"><b>{{$transportCompany->driver_city}}</b></td>
            </tr>
            <tr>
              <td align="right"><b>@lang('layout.Address')</b></td>
              <td align="right"><b>{{$transportCompany->driver_address}}</b></td>
            </tr>

          </table>
        </td>
      </tr>
    </table>

    <table class="main-table">
      <tr>
        <td align="right"><b>@lang('layout.Commitment')</b></td>
      </tr>
      <tr>
        <td align="right" style="white-space: normal; font-size:15px;"><b>{{$transportCompany->commitment}}</b></td>
      </tr>

    </table>

    <!--End Driver Info-->
    @endif
    @endif
    @endif
    @endif

    <!--  signature -->
    <table style="width: 100%" class="signtable">
      <tr>
        @foreach(getCompanyInfo('sign','invoice') AS $info)
        <td style="text-align: left; width:40%">
          <table>

            <tr>
              <td align="right" class="signsize">{{$info['name']}}</td>
            </tr>

          </table>
        </td>
        @endforeach
      </tr>
    </table>
    <!-- End signature -->

  </div>

</div>

</div>

<script type="text/javascript">
  window.print();
</script>
@endsection