@extends('layouts.factor-master')
@section('style')

<style>
 .small-table td, .main-table td, .main-table tr,
  .small-table th, .main-table th {
    
  }
  .t1{
    font-size: 14px;
    font-weight: bold;
    background-color: {{company()['color']}};
  }
  .headCol{
    background-color: #248cd0;
    color: white;
    font-size: 18px;
  }
  .mt{
    background-color: #248cd0;
    color: white;
    font-size: 18px;
  }
  .boldHead{
    font-weight: bold;
  }
</style>
@stop
@section('content')

<div>
  <div style=" font-size: 12px !important">


    <!--Table 2 For Customer Information-->
    <table style="width: 100%;" cellpadding="5px">
      <tr>
        <td style="text-align: left; width:20%">
          <table class="main-table">
            <tr>
              <td align="center" colspan="2" class="headCol">
                <b style="font-size: 20px;">@lang('layout.Invoice')</b>
              </td>

            </tr>

            <tr>
              <td align="right"><b>@lang('layout.InvoiceNumber')</b></td>
              <td align="right"><b>@lang('layout.Date')</b></td>
            </tr>
            <?php
            $str_date = convertdate($sales->date);

            $date_string = substr($str_date, 0, 10);
            ?>
            <tr>
              <td align="right"><b>{{$sales->number}}</b></td>
              <td align="right"><b>
                  @if(getInvoiceDateFormat() == "shamsi")
                  <?php
                  $str_date = convertdate($sales->date, 0, 'jalali');

                  $date_string = substr($str_date, 0, 10)
                  ?>
                  {{$date_string}}

                  @elseif(getInvoiceDateFormat() =='both')

                  <?php
                  $str_date = convertdate($sales->date, 0, 'jalali');

                  $date_string = substr($str_date, 0, 10);
                  echo $date_string;
                  ?>
                  &nbsp;/&nbsp;
                  {{substr($sales->date,0,10)}}

                  @elseif(getInvoiceDateFormat() =="meladi")
                  {{substr($sales->date,0,10)}}

                  @else

                  {{$str_date}}

                  @endif
                </b></td>
            </tr>
          </table>
        </td>

        <td width="20%"></td>
        <td style="text-align: right; width:60%">

        </td>
      </tr>
    </table>
    <!--End Table 2 For Invoice Information-->

    <table style="width: 100%; margin-top: 10px;">
      <tr>
        <td style="text-align: left; width:55%">
          <table class="main-table" cellpadding="5px">
            <tr>
              <td align="center" colspan="4" class="headCol">
                <b>مشخصات مشتری</b>
              </td>

            </tr>
            <tr>
              <td align="right"><b>اسم مشتری</b></td>
              <td align="right"><b>{{$member->name}}</b></td>
              <td align="right"><b>@lang('layout.CustomerClass')</b></td>
              <td align="right"><b>{{$memberClass}}</b></td>
            </tr>
            <tr>
              <td align="right"><b>کد مشتری</b></td>
              <td align="right"><b>{{$member->code}}</b></td>
              <td align="right"><b>@lang('layout.SaleArea')</b></td>
              <td align="right"><b>{{$saleArea}}</b></td>
            </tr>
          </table>
        </td>
        <td width="10%"></td>
        <td style="text-align: right; width:25%">
          <table class="main-table" cellpadding="5px">
            <tr>
              <td align="center" colspan="2" class="headCol"><b>آدرس مشتری</b></td>
            </tr>
            <tr>
              <td align="right"><b>آدرس مشتری</b></td>
              <td align="right"><b>{{$address.' '.$city}}</b></td>
            </tr>
            <tr>
              <td align="right"><b>شماره تماس مشتری</b></td>
              <td align="right"><b>{{$phone}}</b></td>
            </tr>
          </table>
        </td>
      </tr>
    </table>




    <!--Table 3 For Data  Information-->
    <table class="main-table" style="margin-top: 20px;" cellpadding="5px">
      <tr style="font-weight: bold; font-size: 17px">
        <td class="mt center boldHead">
          <div>@lang('layout.Number')</div>
        </td>
        <!--<td class="mt center boldHead"><div >@lang('layout.ItemCode')</div></td>-->
        <td class="mt center boldHead">
          <div>@lang('layout.Item')</div>
        </td>

        @if(systemConfig()[9] == 1 )
        <td class="mt center boldHead">
          <div>@lang('layout.Code')</div>
        </td>
        @endif

        @if(getItemImage()=="true")
        <td class="mt center boldHead">
          <div>@lang('layout.ItemImage')</div>
        </td>
        @endif
        @if(getItemOtherName()=="true")
        <td class="mt center boldHead">
          <div>@lang('layout.ItemOtherName')</div>
        </td>
        @endif
        @if(getInventorySite()=="true")
        <td class="mt center boldHead">
          <div>@lang('layout.Site')</div>
        </td>
        @endif

        @if(systemConfig()[9] == 0 )
        <td class="mt center boldHead">
          <div>@lang('layout.Bundl')</div>
        </td>
        <td class="mt center boldHead">
          <div>@lang('layout.Wing')</div>
        </td>
        @endif

        @if(itemBrand()=="true")
        <td class="mt center boldHead">
          <div>@lang('layout.Brand')</div>
        </td>
        @endif

        <td class="mt center boldHead">
          <div>@lang('layout.Quantity')</div>
        </td>
        <td class="mt center boldHead">
          <div>@lang('layout.Unit/M')</div>
        </td>
        @if(getM2()!="")
        <td class="mt center boldHead">
          <div>@lang('layout.Measure2')</div>
        </td>
        @endif
        @if(getM3()!="")
        <td class="mt center boldHead">
          <div>@lang('layout.Measure3')</div>
        </td>
        @endif
        @if(getM4()!="")
        <td class="mt center boldHead">
          <div>@lang('layout.Measure4')</div>
        </td>
        @endif
        @if(getSaleDescription()=="true")
        <td class="mt center boldHead">
          <div>@lang('layout.Description')</div>
        </td>
        @endif
        <td class="mt center boldHead">
          <div>@lang('layout.Rate')</div>
        </td>
        @if(getSaleDiscount()=="true")
        <!--td class="mt center boldHead"><div >@lang('layout.Sub-Total')</div></td>
   <td class="mt center boldHead"><div >@lang('layout.Discount')</div></td -->
        @endif
        <td class="mt center boldHead">
          <div>@lang('layout.Total')</div>
        </td>

      </tr>
      <?php

      $count = 0;
      $empty = 0;
      $fullCount = count($data);
      $total_discount = 0;

      if ($transportCompany->driver_name || $transportCompany->trasnport_name != null) {
        if ($fullCount < 12) {
          $empty = 12 - $fullCount;
        }
      } else {
        if ($fullCount < 15) {
          $empty = 15 - $fullCount;
        }
      }
      ?>
      @foreach($data AS $key1=>$record)
      <?php

      if ($sales->discount_type == "currency") {
        $total_discount += $record['discount'] * $record['qty'];
      } else {
        $t = ($record['price'] * $record['qty']);
        $total_discount += ($record['discount']) * $t / 100;
      }

      ?>
      <tr>

        <td class="center">{{++$count}}</td>
        <!--<td class="center">{{$record['number']}}</td>-->
        <td class="center">{{$record['name']}}</td>
        @if(systemConfig()[9] == 1 )
        <td class="center">{{$record['code']}}</td>
        @endif

        @if(getItemImage()=="true")
        <td class="center" style="margin: 0px;padding: 0px;"><img alt="" style="height: 80px;width: 80px;" class="img-circle" src="{{public_path().'/uploads/codes/'.$record['image']}}" /></td>
        @endif
        @if(getItemOtherName()=="true")
        <td class="center">{{$record['item_other_name']}}</td>
        @endif
        @if(getInventorySite()=="true")
        <td class="center">{{$record['siteName']}}</td>
        @endif
        @if(systemConfig()[9] == 0 )
        <td class="center">{{$record['bandl']}}</td>
        <td class="center">{{$record['total_khada']}}</td>
        @endif
        @if(itemBrand()=="true")
        <td class="center">{{$record['brand_name']}}</td>
        @endif

        <td class="center">{{simpleRound($record['qty'])}}</td>
        <td class="center">{{$record['symbol']}}</td>

        @if(getM2()!="")
        <td class="center">{{$record['qty1']}}</td>
        @endif
        @if(getM3()!="")
        <td class="center">{{$record['qty2']}}</td>
        @endif
        @if(getM4()!="")
        <td class="center">{{$record['qty3']}}</td>
        @endif

        @if(getSaleDescription()=="true")
        <td class="center">{{$record['itemDescription']}}</td>
        @endif
        <td class="center">{{simpleRound($record['price'])}}</td>
        @if(getSaleDiscount()=="true")
        <!-- td class="center">{{ Currency()->format($record['price']*$record['qty'],$sales->currency)}}</td>
<td class="center">{{$record['discount']}} {{($sales->discount_type=="percent")? '%' : $sales->currency}}</td -->
        @endif
        <!-- <td class="center">{{ Currency()->format($record['price']*$record['qty'],$sales->currency)}}</td> -->

        @if($sales->discount_type=="currency")
        <td class="center">{{ Currency()->format(($record['price']*$record['qty'])-$record['discount']*$record['qty'],$sales->currency)}}</td>
        @else
        <td class="center">{{ Currency()->format(($record['price']*$record['qty'])-($record['discount']*$record['price']/100)*$record['qty'],$sales->currency)}}</td>
        @endif
      </tr>

      @endforeach



      @for($i=0;$i<$empty;$i++) <?php
                                ?> @if(getPaperSize()=='A4' && getPaperStyle()=='portrait' ) @if(getWhiteRows()=="true" ) <tr>

        <td class="center" style="height: 30px"></td>
        <td class="center"></td>
        @if(getItemImage()=="true")
        <td class="center"></td>
        @endif
        @if(getItemOtherName()=="true")
        <td class="center"></td>
        @endif
        <td class="center"></td>
        @if(systemConfig()[9] == 1 )
        <td class="center"></td>
        @endif
        @if(systemConfig()[9] == 0 )
        <td class="center"></td>
        <td class="center"></td>
        @endif
        @if(getInventorySite()=="true")
        <td class="center"></td>
        @endif
        @if(getM2()!="")
        <td class="center"></td>
        @endif

        @if(getM3()!="")
        <td class="center"></td>
        @endif
        @if(getM4()!="")
        <td class="center"></td>
        @endif

        @if(getSaleDescription()=="true")
        <td class="center"></td>
        @endif
        <td class="center"></td>
        @if(getSaleDiscount()=="true")
        <!-- td class="center"></td>
        <td class="center"></td -->
        @endif
        <td class="center"></td>
        <td class="center"></td>
        </tr>
        @endif
        @endif
        @endfor

        <?php
        if ($sales->discount_type == "currency") {
          echo Currency()->format($discountToShow, $sales->currency);
        } else {
          echo simpleRound($discountToShow) . '%';
        }

        $discountTotal = 0;
        foreach ($data as $key => $value) {
          $discountTotal = ($value['discount'] * $value['qty']) + $discountTotal;
        }
        $total_discount = $discountToShow;

        ?>

        </tbody>
    </table>
    <!--End Table 3 For Data Information-->
    @if(systemConfig()[9] == 0 )
    <table width="100%" class="main-table" style="margin-top: 0px;" cellpadding="5px">
      <tr>
          <td class="center boldHead" style="background-color: #248cd0; color: white;"> <div>@lang('layout.Total') @lang('layout.Wing')</div></td>
          <td class="center boldHead" style="background-color: #248cd0; color: white;"> <div>@lang('layout.Total') @lang('layout.Bundl')</div></td>
          <td class="center boldHead" style="background-color: #248cd0; color: white;"> <div>@lang('layout.TotalQty')</div></td>
      </tr>
      <tr>
          <td class="center" colspan="1" style="color: green;">{{$totalKhada}}</td>
          <td class="center" colspan="1" style="color: green;">{{$bandles}}</td>
          <td class="center" colspan="1" style="color: green;">{{simpleRound($jomla)}}</td>
        </tr>
    </table>
    @endif
    <!--Table 4 For Total  Information-->
    <table width="100%" class="main-table" style="margin-top: 8px;" cellpadding="5px">
      @if(getSaleDiscount()=="true")

      <tr>
        <td colspan="5" class="center">
          <div style="font-size: bold;"><b>@lang('layout.SubTotalInLeters'):&nbsp; {{notowo(round(abs($total)),'fa')}}</b></div>
        </td>

        <td colspan="5" class="center">
          <div style="font-size: bold;"><b>@lang('layout.Sub-Total'):&nbsp;{{simpleRound($total)}} @lang('currency.'.($sales->currency)) <br>

              @if($sales->currency != getHomeCurrency()["code"])
              مجموع دالر: {{simpleRound(($total-$total_discount)/$sales->rate)}}
              @endif
            </b></div>
        </td>
      </tr>
      @endif

      <tr>
        <td colspan="4" class="center">
          <div style="font-size: bold;"><b>@lang('layout.TotalInLeters'):&nbsp; {{notowo(round(abs($total-$total_discount)),'fa')}}</b></div>
        </td>
        <!-- <td colspan="2" class="center"><div  style="font-size: bold;"><b>@lang('layout.Total'):&nbsp;{{round($total)}}  @lang('currency.'.($sales->currency)) <br>

        @if($sales->currency != getHomeCurrency()["code"])
        مجموع  دالر: {{round($total)/$sales->rate}}
        @endif
      </b></div></td> -->

        <td colspan="3" class="center">
          <div>@lang('layout.Recipt'):&nbsp;
            @if($sales->type == "InvoiceRoll")
            {{simpleRound($paid)}} @lang('currency.'.($sales->currency))
            @endif
          </div>
        </td>
        <td colspan="3" class="center">
          <div style="font-size: bold; color:green"><b>@lang('layout.Total'):&nbsp;{{simpleRound($total-$total_discount)}} @lang('currency.'.($sales->currency)) <br>

              @if($sales->currency != getHomeCurrency()["code"])
              مجموع به : {{simpleRound(($total-$total_discount)/$sales->rate)}} {{getHomeCurrency()["code"]}}
              @endif
            </b></div>
        </td>


      </tr>


      <tr>

        <td colspan="2">
          <div class="center">@lang('layout.Discount'):&nbsp;
            <span>
              @if($sales->discount_type=="currency")
              {{round(($discountToShow))}} @lang('currency.'.($sales->currency))
              @else
              {{round($discountToShow)}} @lang('currency.'.($sales->currency))
              <!-- span></span -->
              @endif
            </span>

          </div>
        </td>


        <td colspan="2">
          <div class="center">@lang('layout.Remined'):&nbsp;
            @if($sales->type == "InvoiceRoll")
            {{simpleRound((($total) - (($discount * $total) / 100)-$paid))}} @lang('currency.'.($sales->currency))
            @endif</div>
        </td>

        @if(getHesabSabeqa() =='true')
        <td colspan="3">
          <div class="center">@lang('layout.HesabSabiqa'): &nbsp;
            @if($sales->type == "InvoiceRoll")
            @if(getHesabSabeqahType()=="currency")
            {{simpleRound($balance - $total + ($discountToShow+$paid))}} 
            @else
            {{simpleRound($balance - ($total/$sales->rate) + (($discountToShow+$paid)/$sales->rate))}} {{getHomeCurrency()["code"]}}
            @endif
            @endif
          </div>

        </td>

        <td colspan="3">
          <div class="center" style="color: red;"><b>@lang('layout.AmountPayable'):&nbsp;
              @if($sales->type == "InvoiceRoll")
              @if(getHesabSabeqahType()=="currency")
              {{simpleRound(((($balance)-$total+$discountToShow)+$paid)+($total - (($discount * $total) / 100)-$paid))}}
              @else
              {{simpleRound(((($balance * $sales->rate)-$total+$discountToShow)+$paid)+($total - (($discount * $total) / 100)-$paid))}} @lang('currency.'.($sales->currency))
              @endif
              @endif
            </b></div>
        </td>
        @endif
        @if(getHesabSabeqa() =='false')
        <td colspan="6">
          <div class="center"><b>@lang('layout.AmountPayable'):&nbsp;
              @if($sales->type =="InvoiceRoll")
              {{simpleRound(($total - (($discount * $total) / 100)-$paid))}} @lang('currency.'.($sales->currency))
              @endif
            </b></div>
        </td>
        @endif

      </tr>

    </table>
    @if($invoice_des)
    <table width="60%" border="1" style="border-collapse: collapse; margin-top: 7px; " cellpadding="5px">
      <tr>
        <td style="font-size: 14px;">یاد آوری: {{$invoice_des}}</td>
      </tr>
    </table>
    @endif
    <!--End Table 4 For Total  Information-->
    <br>
    <br>
    <table style="width: 100%;">
      <tr>
        <td style="text-align: left; width:70%">

        </td>

        <td width="30%" style="font-size:22px;font-weight:bold;color:royalblue">
          تشکر از اعتماد تان!
        </td>

      </tr>
    </table>


    @if(getDriverInfo()=="true")
    @if(getFactorDriverInfo()=="true")
    @if(getTransportCompany()=="true")
    @if(transportCompanyFactor()=="true")
    @if($transportCompany)
    @if($transportCompany->driver_name || $transportCompany->trasnport_name!=null )
    <!--Driver Info-->

    <table style="width: 100%; margin-top: 10px;">
      <tr>
        <td style="text-align: left; width:50%">
          <table class="main-table">
            <tr>
              <td align="center" colspan="2">
                <b style="font-size: 20px;">@lang('menu.TransportCompany')</b>
              </td>

            </tr>

            <tr style="font-weight: bold; font-size: 17px">
              <td align="right"><b>@lang('layout.Number')</b></td>
              <td align="right"><b>{{$transportCompany->trasnport_number}}</b></td>
            </tr>
            <tr>
              <td align="right"><b>@lang('layout.LicenseNumber')</b></td>
              <td align="right"><b>{{$transportCompany->trasnport_license_number}}</b></td>
            </tr>
            <tr>
              <td align="right"><b>@lang('layout.Name')</b></td>
              <td align="right"><b>{{$transportCompany->trasnport_name}}</b></td>
            </tr>
            <tr>
              <td align="right"><b>@lang('layout.Phone')</b></td>
              <td align="right"><b>{{$transportCompany->trasnport_phone}}</b></td>
            </tr>
            <tr>
              <td align="right"><b>@lang('layout.Email')</b></td>
              <td align="right"><b>{{$transportCompany->trasnport_email}}</b></td>
            </tr>
            <tr>
              <td align="right"><b>@lang('layout.City')</b></td>
              <td align="right"><b>{{$transportCompany->trasnport_city}}</b></td>
            </tr>
            <tr>
              <td align="right"><b>@lang('layout.Address')</b></td>
              <td align="right"><b>{{$transportCompany->trasnport_address}}</b></td>
            </tr>

          </table>
        </td>

        <td style="text-align: right; width:50%">
          <table class="main-table">
            <tr>
              <td align="center" colspan="2">
                <b style="font-size: 20px;">@lang('layout.Driver')</b>
              </td>

            </tr>
            <tr style="font-weight: bold; font-size: 17px">
              <td align="right"><b>@lang('layout.Number')</b></td>
              <td align="right"><b>{{$transportCompany->driver_code}}</b></td>
            </tr>
            <tr>
              <td align="right"><b>@lang('layout.SSID')</b></td>
              <td align="right"><b>{{$transportCompany->driver_ss_id}}</b></td>
            </tr>
            <tr>
              <td align="right"><b>@lang('layout.Name')</b></td>
              <td align="right"><b>{{$transportCompany->driver_name}}</b></td>
            </tr>
            <tr>
              <td align="right"><b>@lang('layout.LastName')</b></td>
              <td align="right"><b>{{$transportCompany->driver_last_name}}</b></td>
            </tr>
            <tr>
              <td align="right"><b>@lang('layout.Phone')</b></td>
              <td align="right"><b>{{$transportCompany->driver_phone}}</b></td>
            </tr>
            <tr>
              <td align="right"><b>@lang('layout.City')</b></td>
              <td align="right"><b>{{$transportCompany->driver_city}}</b></td>
            </tr>
            <tr>
              <td align="right"><b>@lang('layout.Address')</b></td>
              <td align="right"><b>{{$transportCompany->driver_address}}</b></td>
            </tr>

          </table>
        </td>
      </tr>
    </table>

    <table class="main-table">
      <tr>
        <td align="right"><b>@lang('layout.Commitment')</b></td>
      </tr>
      <tr>
        <td align="right" style="white-space: normal; font-size:15px;"><b>{{$transportCompany->commitment}}</b></td>
      </tr>

    </table>

    <!--End Driver Info-->
    @endif
    @endif
    @endif
    @endif
    @endif
    @endif

    <!--  signature -->
    <table style="width: 100%" class="signtable">
      <tr>
        @foreach(getCompanyInfo('sign','invoice') AS $info)
        <td style="text-align: left; width:40%">
          <table>

            <tr>
              <td align="right" class="signsize">{{$info['name']}}</td>
            </tr>

          </table>
        </td>
        @endforeach
      </tr>
    </table>
    <!-- End signature -->

  </div>

</div>

</div>

<script type="text/javascript">
  window.print();
</script>
@endsection