@extends('layouts.factor-master')
@section('style')

<style>
  .headCol {
    background-color: #36c6d3;
    color: white;
    font-size: 15px;
  }

  .mt {
    background-color: #36c6d3;
    color: white;
    font-size: 15px;
  }

  .boldHead {
    font-weight: bold;
  }

  .small-table td,
  .main-table td,
  .main-table tr,
  .small-table th,
  .main-table th {
    border: 1px solid #e67979;
  }

  .thc {
    background-color: #afdcbe52;
  }

  .thc1 {
    background-color: #f6fff94a;
  }

  .t1 {
    font-size: 14px;
    font-weight: bold;
  }
</style>
@stop
@section('content')

<div>
  <div style=" font-size: 12px !important">

    <?php
    $str_date = convertdate($sales->date);

    $date_string = substr($str_date, 0, 10);
    ?>

    <!--End Table 2 For Invoice Information-->

    <table style="width: 100% ; margin-top: 5px;">
      <tr>
        <td class="t1" style="width: 35%;height: 35px;font-size: 15px"><span > @lang('layout.CustomerName1') </span>: &nbsp;<span>{{$member->name}}</span></td>

        <td class="t1" style="width: 25%;height: 35px;font-size: 15px;"><span >موبایل</span>: &nbsp;<span>{{$member->phone}}</span></td>

        <td class="t1" style="width: 20%;height: 35px;font-size: 15px;"><span >@lang('layout.InvoiceNumber')</span>: &nbsp;<span><u>{{$sales->number}}</u></span></td>

        <td class="t1" style="width: 20%;height: 35px; font-size: 15px;"><span >@lang('layout.Date')</span>: &nbsp;
          @if(getInvoiceDateFormat() == "shamsi")
          <?php
          $str_date = convertdate($sales->date, 0, 'jalali');

          $date_string = substr($str_date, 0, 10)
          ?>
          {{$date_string}}

          @elseif(getInvoiceDateFormat() =='both')

          <?php
          $str_date = convertdate($sales->date, 0, 'jalali');

          $date_string = substr($str_date, 0, 10);
          echo $date_string;
          ?>
          &nbsp;/&nbsp;
          {{substr($sales->date,0,10)}}

          @elseif(getInvoiceDateFormat() =="meladi")
          {{substr($sales->date,0,10)}}

          @else

          {{$str_date}}

          @endif
        </td>
      </tr>
    </table>

    <!--Table 3 For Data  Information-->
    <table class="main-table" style="margin-top: 2px;" cellpadding="2px">
      <tr style="font-weight: bold; font-size: 15px">
        <td class="mt center boldHead" style="width: 16px;" >
          <div>@lang('layout.Number')</div>
        </td>
        <td class="mt center boldHead">
          <div>@lang('layout.Item')</div>
        </td>

        @if(getInventorySite()=="true")
        <td class="mt center boldHead">
          <div>@lang('layout.Site')</div>
        </td>
        @endif
        @if($sales->show_qty_factor != "off")
        <td class="mt center boldHead">
        <div>@lang('layout.Quantity')</div>
        </td>
        @endif
        @if(getCubicMetereItems()=="true")
        <td class="mt center boldHead">@lang('layout.Width')</td>
        <td class="mt center boldHead">@lang('layout.Length')</td>
        <td class="mt center boldHead">@lang('layout.Gauge') </td>
        <td class="mt center boldHead">@lang('layout.SquareMetere') </td>
        @endif
        <td class="mt center boldHead">
          <div>@lang('layout.UnitPrice')</div>
        </td>
        <td class="mt center boldHead">
          <div>@lang('layout.Total')</div>
        </td>

      </tr>
      <?php

      $count = 0;
      $empty = 0;
      $fullCount = count($data);
      $total_discount = 0;

      if ($fullCount < 18) {
        $empty = 18 - $fullCount;
      }
      ?>
      @foreach($data AS $key1=>$record)
      <?php

      if ($sales->discount_type == "currency") {
        $total_discount += $record['discount'] * $record['qty'];
      } else {
        $t = ($record['price'] * $record['qty']);
        $total_discount += ($record['discount']) * $t / 100;
      }

      ?>
      <tr>

        <td class="center">{{++$count}}</td>
        <td class="center">{{$record['name']}}</td>
        @if(getInventorySite()=="true")
        <td class="center">{{$record['siteName']}}</td>
        @endif
        @if($sales->quantityByWing && getCubicMetereItems()=="true")
        <td class="center">{{simpleRound($record['total_bundl'])}}</td>
        @else
        <td class="center">{{simpleRound($record['qty'])}} {{$record['symbol']}}</td>
        @endif
        @if(getCubicMetereItems()=="true")
        <td class="center">{{simpleRound($record['width_out'])}}</td>
        <td class="center">{{simpleRound($record['length_out'])}}</td>
        <td class="center">{{simpleRound($record['out_gauge'])}}</td>
        <td class="center">{{simpleRound($record['total_khada'])}}</td>
        @endif
        @if($sales->quantityByWing && ShowQuantityByWing() == "true")
        <td class="center">{{simpleRound($record['price_of_khada'])}}</td>
        @else
        <td class="center">{{simpleRound($record['price'])}}</td>
        @endif
        @if($sales->discount_type=="currency")
        <td class="center">{{ Currency()->format(($record['price']*$record['qty'])-$record['discount']*$record['qty'],$sales->currency)}}</td>
        @else
        <td class="center">{{ Currency()->format(($record['price']*$record['qty'])-($record['discount']*$record['price']/100)*$record['qty'],$sales->currency)}}</td>
        @endif
      </tr>

      @endforeach

      @for($i=0;$i<$empty;$i++)
      @if(getPaperSize()=='A4' && getPaperStyle()=='portrait' ) 
      @if(getWhiteRows()=="true" ) 
      <tr>

        <td class="center" style="height: 30px">{{++$count}}</td>
        <td class="center"></td>
        @if(getInventorySite()=="true")
        <td class="center"></td>
        @endif
        @if($sales->show_qty_factor != "off")
        <td class="center"></td>
        @endif
        @if(getCubicMetereItems()=="true")
        <td class="center"></td>
        <td class="center"></td>
        <td class="center"></td>
        @endif
        <td class="center"></td>
        <td class="center"></td>
        <td class="center"></td>
        </tr>
        @endif
        @endif
        @endfor

        <?php
        if ($sales->discount_type == "currency") {
          echo Currency()->format($discountToShow, $sales->currency);
        } else {
          echo simpleRound($discountToShow) . '%';
        }

        $discountTotal = 0;
        foreach ($data as $key => $value) {
          $discountTotal = ($value['discount'] * $value['qty']) + $discountTotal;
        }
        $total_discount = $discountToShow;

        ?>

        </tbody>
    </table>
    <!--End Table 3 For Data Information-->

    <table width="100%" class="main-table" style="margin-top: 0px;" cellpadding="2px">
      <tr>
        @if($sales->show_qty_factor != "off")
        <td class="center ">
          {{-- <div>@lang('layout.TotalWazn') : {{simpleRound($jomla)}}</div> --}}
        </td>
        @endif
        <td class="center ">
          <div>@lang('layout.Total') @lang('layout.SquareMetere') : {{simpleRound($totalKhada)}}</div>
        </td>
        <td class="center ">
          <div>@lang('layout.Total') : {{simpleRound($total)}}</div>
        </td>
      </tr>
    </table>

    <!--Table 4 For Total  Information-->
    <table width="100%" class="main-table" style="margin-top: 8px;" cellpadding="5px">
      @if(getSaleDiscount()=="true")

      <tr>
        <td colspan="5" class="center">
          <div style="font-size: bold;"><b>@lang('layout.SubTotalInLeters'):&nbsp; {{notowo(round(abs($total)),'fa')}}</b></div>
        </td>

        <td colspan="5" class="center">
          <div style="font-size: bold;">
            <b>@lang('layout.Sub-Total'):&nbsp;{{simpleRound($total)}} @lang('currency.'.($sales->currency))  </b>
          </div>
        </td>
      </tr>
      @endif

      <tr>
        <td colspan="4" class="center">
          <div style="font-size: bold;"><b>@lang('layout.TotalInLeters'):&nbsp; {{notowo(round(abs($total-$total_discount)),'fa')}}</b></div>
        </td>
        <td colspan="3" class="center">
          <div>@lang('layout.Recipt'):&nbsp;
            @if($sales->type == "InvoiceRoll")
            {{simpleRound($paid)}} @lang('currency.'.($sales->currency))
            @endif
          </div>
        </td>
        <td colspan="3" class="center">
          <div style="font-size: bold; color:green"><b>@lang('layout.Total'):&nbsp;{{simpleRound($total-$total_discount)}} @lang('currency.'.($sales->currency))
            </b></div>
        </td>


      </tr>


      <tr>

        <td colspan="2">
          <div class="center">@lang('layout.Discount'):&nbsp;
            <span>
              @if($sales->discount_type=="currency")
              {{round(($discountToShow))}} @lang('currency.'.($sales->currency))
              @else
              {{round($discountToShow)}} @lang('currency.'.($sales->currency))
              <!-- span></span -->
              @endif
            </span>

          </div>
        </td>


        <td colspan="2">
          <div class="center">@lang('layout.Remined'):&nbsp;
            @if($sales->type == "InvoiceRoll")
            {{simpleRound((($total) - (($discount * $total) / 100)-$paid))}} @lang('currency.'.($sales->currency))
            @endif</div>
        </td>

        @if(getHesabSabeqa() =='true')
        <td colspan="3">
          <div class="center">@lang('layout.HesabSabiqa'): &nbsp;
            @if($sales->type == "InvoiceRoll")
            @if(getHesabSabeqahType()=="currency")
            {{simpleRound($balance - $total + ($discountToShow+$paid))}}
            @else
            {{simpleRound($balance - ($total/$sales->rate) + (($discountToShow+$paid)/$sales->rate))}} {{getHomeCurrency()["code"]}}
            @endif
            @endif
          </div>

        </td>

        <td colspan="3">
          <div class="center" style="color: red;"><b>@lang('layout.AmountPayable'):&nbsp;
              @if($sales->type == "InvoiceRoll")
              @if(getHesabSabeqahType()=="currency")
              {{simpleRound(((($balance)-$total+$discountToShow)+$paid)+($total - (($discount * $total) / 100)-$paid))}}
              @else
              {{simpleRound(((($balance * $sales->rate)-$total+$discountToShow)+$paid)+($total - (($discount * $total) / 100)-$paid))}} @lang('currency.'.($sales->currency))
              @endif
              @endif
            </b></div>
        </td>
        @endif
        @if(getHesabSabeqa() =='false')
        <td colspan="6">
          <div class="center"><b>@lang('layout.AmountPayable'):&nbsp;
              @if($sales->type =="InvoiceRoll")
              {{simpleRound(($total - (($discount * $total) / 100)-$paid))}} @lang('currency.'.($sales->currency))
              @endif
            </b></div>
        </td>
        @endif

      </tr>

    </table>

    <!--End Table 4 For Total  Information-->

    @if(company()['invoice_message'])
    <table width="100%">
        <tr>
            <td style="font-size: 14px;">{!!company()['invoice_message']!!}</td>
        </tr>

        <tr>
            <td></td>
            <td></td>
        </tr>


    </table>
    @endif
    <br>


    <!--  signature -->
    <table style="width: 100%" class="signtable">
      <tr>
        @foreach(getCompanyInfo('sign','invoice') AS $info)
        <td style="text-align: left; width:40%">
          <table>

            <tr>
              <td align="right" class="signsize">{{$info['name']}}</td>
            </tr>

          </table>
        </td>
        @endforeach
      </tr>
    </table>
    <!-- End signature -->

  </div>

</div>

</div>

<script type="text/javascript">
  window.print();
</script>
@endsection