@extends('layouts.factor-master')
@section('style')

<style>

</style>
@stop
@section('content')

    {!!company()['name']!!}  
    
    <h1>@lang('layout.Invoice') #{{$sales->number}}</h1>
    <h3>
        <?php
            $str_date = convertdate($sales->date);
            $date_string = substr($str_date, 0, 10);
        ?>
        <b> @if(getInvoiceDateFormat() == "shamsi")
            <?php
            $str_date = convertdate($sales->date, 0, 'jalali');

            $date_string = substr($str_date, 0, 10)
            ?>
            {{$date_string}}

            @elseif(getInvoiceDateFormat() =='both')

            <?php
            $str_date = convertdate($sales->date, 0, 'jalali');

            $date_string = substr($str_date, 0, 10);
            echo $date_string;
            ?>
            &nbsp;/&nbsp;
            {{substr($sales->date,0,10)}}

            @elseif(getInvoiceDateFormat() =="meladi")
            {{substr($sales->date,0,10)}}

            @else

            {{$str_date}}

            @endif 
        </b> ---
        <b> @lang('layout.Hour') ( <?php echo Date('h:i A', strtotime($sales->date)); ?> ) </b>
    </h3>


    <h3>
        <b> @lang('layout.CustomerDetails') ( @if(getDescriptionASMemberName()=="true")
        {{$member->name}}
                                    @else
                                    {{$member->name}}
                                    @endif ) 
        @lang('layout.Code') ( {{$member->code}} ) @lang('layout.Phone') ( {{$phone}} ) </b>
    </h3>

    <h3>@lang('layout.Items')</h3>
    <?php
    $discountTotal = 0;
    $count = 0;
    $empty = 0;
    $total_discount = 0;
    $total_discount_per_item = 0;

    $totalQty = 0;
    $measure_total = [];
    ?>

    @foreach($data AS $key1=>$record)
    <?php
    $discountTotal = ($record['discount'] * $record['qty']) + $discountTotal;
    if ($sales->discount_type == "currency") {
        $total_discount += $record['discount'] * $record['qty'];
    } else {
        $t = ($record['price'] * $record['qty']);
        $total_discount += ($record['discount']) * $t / 100;
    }

    //Total Items
    if (array_key_exists($record['symbol'], $measure_total)) {
        $measure_total[$record['symbol']] = $measure_total[$record['symbol']] + $record['qty'];
    } else {
        $measure_total[$record['symbol']] = $record['qty'];
    }
    $totalQty += $record['qty'];

    ?>

    <h4> 
        <b> ( @lang('layout.Number') = {{++$count}} ) </b> -- 
        <b> ( @lang('layout.Item') = {{$record['name']}} ) </b> -- 
        @if(getInventorySite()=="true")
            <b> ( @lang('layout.Site') = {{$record['siteName']}} ) </b> -- 
        @endif
        @if(systemConfig()[9] == 1)
            <b> ( @lang('layout.Code') => {{$record['code']}} ) </b> -- 
        @endif
        @if(systemConfig()[9] == 0)
            <b> ( @lang('layout.Bundl') => {{$record['bandl']}} ) </b> -- 
            <b> ( @lang('layout.Wing') => {{$record['total_khada']}} ) </b> -- 
        @endif
        <b> ( @lang('layout.Quantity') = {{$record['qty']}}  {{$record['symbol']}} ) </b> -- 
        @if(getOtherMeasure()=="true" && $record['other_measure'] > 0)
            <b> ( {{$record['o_measure_name']}} = {{$record['other_measure']}} ) </b> -- 
        @endif
        <b> ( @lang('layout.Rate') = {{myRound($record['price'])}} {{$sales->currency}} )</b> -- 
        @if(getSaleDiscount()=="true")
        <b> ( @lang('layout.Sub-Total') = {{ myRound($record['price']*$record['qty'])}} {{$sales->currency}} ) </b> -- 
        <b> ( @lang('layout.Discount') = {{$record['discount']}} {{($sales->discount_type=="percent")? '%' : $sales->currency}} ) </b> -- 
        @endif
        <b> ( @lang('layout.Total') = 
            @if($sales->discount_type=="currency")
            {{ myRound(($record['price']*$record['qty'])-$record['discount']*$record['qty'])}} {{$sales->currency}}
            @else
            {{ myRound(($record['price']*$record['qty'])-($record['discount']*$record['price']/100)*$record['qty'])}} {{$sales->currency}}
            @endif
        )
        </b>
        
    </h4> 
    @endforeach


    
    @if(getTotalItemQuantity()!='' ||getTotalItemQuantity()!="defualt")
    <h3>@lang('layout.TotalQuantity')</h3>
    
    @if(getTotalItemQuantity() == "per_unit")
    @foreach($measure_total AS $key=>$measure)
    <h4> 
        <b>{{$measure}} = {{$key}}</b>
         
    </h4>
    @endforeach  
    @endif
    @if(getTotalItemQuantity() == "all_unit")
    <h4>  
        <b>@lang('layout.TotalQuantity') = {{$totalQty}}</b>
         
    </h4>
    @endif
    @endif
   
    


    <h3>@lang('layout.Total')</h3>
    <h4> 
        @if(App::isLocale('fa') || App::isLocale('pa'))
        <b>@lang('layout.TotalInLeters') = {{notowo(abs(round($total)),'fa')}}</b> -- 
        @else
        <b>@lang('layout.TotalInLeters') = {{notowo(abs(round($total)),'en')}}</b> -- 
        @endif
        @if($sales->type == "InvoiceRoll")
        <b>@lang('layout.Recipt') = {{myRound($paid)}} @lang('currency.'.($sales->currency))</b> -- 
        @endif
        <b> ( @lang('layout.Total') = {{myRound($total)}} @lang('currency.'.($sales->currency))  @if($sales->currency != getReportCurrency()) &nbsp; --- مجموع دالر : {{myRound(($total)/$sales->rate)}}  @endif ) </b> -- 
        
    </h4>
    <h4> 
        <b>@lang('layout.Discount') = 
        @if($sales->discount_type=="currency")
        {{myRound(($discountToShow))}} @lang('currency.'.($sales->currency))
        @else
        {{myRound($discountToShow)}} @lang('currency.'.($sales->currency))
        @endif    
        </b> -- 
        @if($sales->type == "InvoiceRoll")
        <b>@lang('layout.Remined') = {{myRound((($total-$discountToShow) -$paid))}} @lang('currency.'.($sales->currency))</b> -- 
        @endif
        
      
        

        @if(getHesabSabeqa() =='true')

        <b>@lang('layout.HesabSabiqa') = 
        @if($sales->type == "InvoiceRoll")
        {{myRound($balance - ($total/$sales->rate) + (($discountToShow+$paid)/$sales->rate))}} {{getHomeCurrency()["code"]}}
        @endif
        </b> -- 
        
        <b> ( @lang('layout.AmountPayable') = 
        @if($sales->type == "InvoiceRoll")
            {{myRound(((($balance * $sales->rate)-($total)+$discountToShow)+$paid)+($total - $discountToShow - $paid))}} @lang('currency.'.($sales->currency))
        @endif
        ) 
        </b> 
        
        @endif
      
        

        @if(getHesabSabeqa() =='false')
        <b> ( @lang('layout.AmountPayable') =  
        @if($sales->type =="InvoiceRoll")
        {{myRound(($total - $discountToShow -$paid))}} @lang('currency.'.($sales->currency))
        @endif
        ) 
        </b>
        @endif
         
    </h4>
 
    @if($invoice_des)
    <h4>
        <b>@lang('layout.Description') => {{$invoice_des}}</b>
    </h4>
    @endif

@endsection