@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('content')
@include("layouts.Cmodal")
@include("invoices.modal")
<?php

?>
<div class="row"> 
    <div class="portlet light bordered">
          <!-- BEGIN TAB PORTLET-->
          <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption">
                        <i class="icon-anchor font-green-sharp"></i>
                        <span class="caption-subject font-green-sharp bold uppercase">@lang('layout.EditInvoice')</span>
                    </div>
                    <div class="actions">
                    </div>
                </div>
                <div id="appInvoice" class="portlet-body">
        
                    <div class="tabbable tabbable-tabdrop">
          
                        <div>
                          {{Form::model($invoice,['route' => ['invoice_roll.update',$invoice->id],'method' => 'PATCH','class' => 'form-horizontal','id'=>'sales-form'])}}
                           {{ csrf_field() }}
                           <div class="tab-content">

                               <div class="tab-pane active" id="tab1">
                                 
                                <div id="appInvoice" v-cloak class="portlet-body form" style="margin-bottom:50%;">
                  <!-- begin sale order modal -->
              
                <!-- end sale order modal -->

                <!-- BEGIN FORM-->
            

                                    <div class="form-body">
                                      <div class="row">
                                        <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12">
                                          <!-- begin inputs -->
                                          <div class="row">
                                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                              <div class="form-group">
                                                  
                                                  <div class="col-md-12">
                                                    <label class="control-label">@lang('layout.Customer')</label>
                                                      
                                                       <v-select  label="name" @input="memberChange()" :options="customer" v-model="selected_customer"></v-select>
                                                       <input type="hidden" name="customer" :value="!selected_customer?null:selected_customer.id" required>
                                                  </div>
                                              </div> 
                                            </div>


                                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                              <div class="form-group">
                                                  <div class="col-md-12">
                                                  <label class="control-label col-md-12"><br></label>
                                                      
                                                      <button type="button" class="btn blue btn-block" @click="showModal = true">@lang('layout.NewCustomer')</button>
                                                  </div>
                                              </div> 
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                              <div class="form-group">
                                                  
                                                  <div class="col-md-12">
                                                    <label class="control-label">@lang('layout.InvoiceNumber')</label>
                        
                                                       <input type="number" name="number" value="{{$invoice->number}}" class="form-control">
                                                  </div>
                                              </div> 
                                            </div>
                                            
                                          </div>

                                        <div class="row">
                                            

                                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                              <div class="form-group">
                                                    
                                                    <div class="col-md-12">
                                                      <label class="control-label">@lang('layout.Currency')</label>
                          
                                                      
                                                        <v-select  label="code" @input="selectedRate" :options="currency" v-model="selected_currency"></v-select>
                                                        <input type="hidden" name="currency" :value="selected_currency.code">

                                                    </div>
                                              </div> 
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    
                                                    <div class="col-md-12">
                                                      <label class="control-label">@lang('layout.Rate')</label>
                                                        <input type="hidden" name="hqRate" :value="selected_currency.hq_rate" v-if="selected_currency">
                                                         <input type="number" name="currency_rate" name="rate" v-model="!selected_currency?0:selected_currency.rate" class="form-control" :class="{'has-error':rate<=0}">
                                                    </div>
                                                </div> 
                                            </div>

                                          <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                              <div class="form-group">
                                                  
                                                  <div class="col-md-12">
                                                    <label class="control-label">@lang('layout.Discount')</label>
                                                        
                                                         <div class="input-group">
                                                       
                                                        <input  v-model="discountFiled" class="form-control"
                                                       type="number" min="0" max="100">
                                                            <span  v-if="discountIsAmount"  @click="discountIsAmount = !discountIsAmount" class="input-group-addon">@{{selected_currency.symbol}}
                                                              <input type="hidden" class="input-group-addon" name="discount_type" value="currency">
                                                          </span>
                                                          <span  v-else @click="discountIsAmount = !discountIsAmount" class="input-group-addon" >%
                                                              <input type="hidden" name="discount_type" value="percent">
                                                          </span>
                                                          <input type="hidden" name="discountTotal" :value="discount">
                                                          <input type="hidden" name="discount" :value="discountFiled">
                                                     </div>

                                                  </div>
                                              </div> 
                                          </div>
                                        </div>

                                        <div class="row">
                                           
                                           <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                              <div class="form-group">
                                                  <div class="col-md-12">
                                                    <label class="control-label">@lang('layout.Description')</label>
                                                    <textarea  name="description" class="form-control" rows="1" >{{$invoice->description}}</textarea>
                                                  </div>
                                              </div> 
                                          </div>
                                          <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    
                                                    <div class="col-md-12">
                                                      <label class="control-label">@lang('layout.Date')</label>
                          
                                                         <input type="text" name="date"  class="form-control date" value="{{$invoice->date}}" autocomplete="off">
                                                    </div>
                                                </div> 
                                            </div>
                                             <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    
                                                    <div class="col-md-12">
                                                      <label class="control-label">@lang('layout.OverdueDate')</label>
                          
                                                         <input type="text" name="overdue_date"  class="form-control date" value="{{$invoice->overdue_date}}" autocomplete="off">
                                                    </div>
                                                </div> 
                                            </div>
                                        </div>

                                        <!--Begin Transport Company-->
                                        @if(getTransportCompany()=="true")
                                          <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                              <div class="form-group">

                                                <div class="col-md-12">
                                                  <label class="control-label">@lang('menu.TransportCompany')</label>
                                                    <v-select 
                                                      v-model="selected_transportCompany"
                                                      label="name" 
                                                      :options="transportCompany"
                                                      @input="getDrivers"
                                                      @click.native="getAllDrivers"
                                                      >
                                                        
                                                    </v-select>

                                                      <input type="hidden" name="transportCompany_id"
                                                       :value="!selected_transportCompany?null:selected_transportCompany.id">
                                                </div>
                                              </div>
                                            </div>
                                             <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                <div class="form-group">

                                                  <div class="col-md-12">
                                                    <label class="control-label">@lang('layout.Driver')</label>
                                                              
                                                      <v-select 
                                                        label="name" 
                                                        :options="t_drivers"
                                                        
                                                        v-model="selected_transportDriver"
                                                        >
                                                          
                                                      </v-select>
                                                      <input type="hidden" name="trasnsport_driver_id"
                                                         :value="!selected_transportDriver?null:selected_transportDriver.id">

                                                      

                                                  </div>
                                                </div>
                                               </div>
                                           @endif
                                        <!--End Transport Company-->
                                          <!-- end inputs -->
                                      </div>
                                       <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">

                                        <!-- begin total -->
                                           <div class="dashboard-stat2 ">
                                            <table class="dashboard-tabel" width="100%">
                                              <tr>
                                                  <td>
                                                    <small>@lang('layout.Total') :</small>
                                                  </td>
                                                  <td class="text-right"><span data-counter="counterup"
                                                     data-value="7800">@{{ Number.parseFloat((subtotal - (discount*subtotal/100))-payeds).toFixed(precision())}}</span>
                                                    <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                                 </td>
                                             </tr>

                                             <tr>
                                              <td>
                                                  <small>@lang('layout.Discount'): (@{{ Number.parseFloat(discount).toFixed(precision()) }}%)</small>
                                              </td>
                                              <td class="text-right">
                                               <span class="text-right" data-counter="counterup"
                                               data-value="7800">@{{ Number.parseFloat(discount*subtotal/100).toFixed(precision()) }}</span>
                                               <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                           </td>
                                       </tr>

                                       <tr>
                                          <td>
                                              <small>@lang('layout.Payment'):</small>
                                          </td>
                                          <td class="text-right">
                                              <small class="font-green-sharp">
                                                  <span class="text-right" data-counter="counterup"
                                                  data-value="7800">@{{ payeds.toFixed(precision())}}</span>
                                                  <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                              </small>
                                          </td>
                                      </tr>


                                      <tr>
                                          <td>
                                              <small>@lang('layout.Sub-Total'):</small>
                                          </td>
                                          <td class="text-right">
                                              <span class="text-right" data-counter="counterup"
                                              data-value="7800">@{{ subtotal.toFixed(precision())}}</span>
                                              <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                          </td>
                                      </tr>


                                  </table>

                                           </div>

                                        <!-- end total -->
                                       </div>

                                      </div>

					 <div class="row" v-if="inventories.length>0" style="overflow-x: scroll;">
					   <table id="table_content" class="table table-bordered table-advance">
                          <thead>
                              <tr>
                                  <th>#</th>
								  <th style="min-width: {{itemFieldWidth()}}px">@lang('layout.ItemName') </th>
                                  <th style="min-width: 100px">@lang('layout.SiteName') </th>
                                  <!-- th class="purchase_description">@lang('layout.Description') </th -->
                                  <th style="min-width: 100px">@lang('layout.Code') </th>
                                  <th style="min-width: 100px">@lang('layout.Quantity') </th>
                                  <th style="min-width: 50px">@lang('layout.Weight') </th>
                                  <th style="min-width: 50px">@lang('layout.OnHand') </th>
                                  <!-- th class="other_measure" style="min-width: 100px">@lang('layout.OMeasureValue') </th -->
                                  <th style="min-width: 100px">@lang('layout.Measure') </th>
                                @if(getM2()!="")  
                                  <th style="min-width: 100px">@lang('layout.Measure2') </th>
                                @endif
                                @if(getM3()!="")  
                                  <th style="min-width: 100px">@lang('layout.Measure3') </th>
                                @endif
                                @if(getM4()!="")  
                                 <th style="min-width: 100px">@lang('layout.Measure4') </th>
                                @endif  
                                  <th style="min-width: 100px">@lang('layout.NewCost') </th>
                                  <th style="min-width: 50px">@lang('layout.Wing') </th>
                                  <th style="min-width: 100px">@lang('layout.Total') </th>
                                  <th></th>
                              </tr>
                          </thead>
                          <tbody>
                              <tr v-for="(item,index) in inventories">
								  <td>@{{index+1}}</td>
                                  <td class="highlight">
								  <!-- @click.native="addNew('inventory',index)" -->
                                      <v-select  label="name" v-model="item.item" :options="temp_items"  @search="onItemSearch" @click.native="addNew('inventory',index)" ></v-select>
                                      <input type="hidden" id="item_id" :name="'inventory_id['+index+']'" :value="(!item.item)?null:item.item.id">
                                      <input type="hidden" :value="(!item.item)?null:item.item.sale_order_detail_id" :name="'sale_order_detail_id['+index+']'" >
                                  </td>
									<td class="highlight">
                                      <select v-model="(item.item==null)?null:item.item.site" class="form-control">
                                         <option value="null">@lang('layout.Select')</option>
                                         <span v-if="(item.item != null)">
                                          <option v-for="site in (item.item==null)?null:item.item.site_list" :value="site">
                                            @{{site.site_name}}
                                          </option> 
                                        </span>
                                      </select>
                                     
                                      <input type="hidden" id="inventory_site" :name="'inventory_site['+index+']'" :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.site_id)">
                                  </td>
								  
								  <td class="highlight">
									<v-select label="name" @click.native="addIndex(index)" v-model="(item.item==null)?null:item.item.code" :options="subItems" @search="onItemSearchCode" placeholder="@lang('layout.Code')" style=""></v-select>
									<input type="hidden" :name="'cost_roll['+index+']'" :value="(item.item==null)?null:((item.item.code==null)?null:item.item.code.per_price)">
									<input type="hidden" :name="'cost['+index+']'" :value="(item.item==null)?null:((item.item.code==null)?null:item.item.code.cost)">
									<input type="hidden" :name="'m_stocks_in_id['+index+']'" :value="(item.item==null)?null:((item.item.code==null)?null:item.item.code.id)" >
									<input type="hidden" :name="'main_stock_id['+index+']'" :value="(item.item==null)?null:((item.item.code==null)?null:item.item.code.main_stock_id)" >
								  </td>
								  
                                  <!-- td class="purchase_description">
                                     <input type="text" placeholder="@lang('layout.Description')" name="inventory_description" class="form-control">
                                  </td -->
                                  <td>
                                     <input type="number" :name="'inventory_quantity['+index+']'"  ref="qut_temp" @input="setNewRate('inventory',index)" :value="(item.item==null)?null:((item.item.code==null)?null:item.item.code.qut_temp)" class="form-control input-style input-number"  placeholder="@lang('layout.Quantity')">
									
								  </td>

                                  <td>
                                     @{{myRound((item.item==null)?null:((item.item.code==null)?null:item.item.code.OnHand))}}
                                  </td>
								  
                                  <td>
                                     @{{myRound((item.item==null)?null:saleItemQuantity(item.item,item.item.quantity))}}
                                  </td>
                                  <!-- td class="other_measure">
                                     <input type="number" name="other_measure_amount"  class="form-control input-style input-number"  placeholder="@lang('layout.OMeasureValue')">
                                  </td -->
                                  <td class="highlight">
                                      <select  v-model="(item.item == null)?null:item.item.measure" class="form-control" @change="measureChange(index)">
                                          <option value="null">@lang('layout.Select')</option>
                                          <span v-if="(item.item ==null)?false:true">
                                              <option  v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure">
                                              @{{measure.measure_name}}
                                            </option> 
                                          </span>
                                      </select>
                                     
                                      <input type="hidden" :name="'inventory_measure['+index+']'"  :value="(item.item==null)?null:item.item.measure.measure_id">
                                  </td>

                                  @if(getM2()!="")    
                                         <td>
                                            <select name="measure1[]" class="form-control" v-model="(item.item==null)?null:item.item.measure1.measure_id">
                                              <option value="null">@lang('layout.Select')</option>
                                              <span v-if="(item.item ==null)?false:true">
                                                <option  v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure.measure_id">
                                                @{{measure.measure_name}}
                                              </option> 
                                              </span>
                                            </select>
                                          </td>
                                        @endif
                                        @if(getM3()!="")    
                                          <td>
                                            <select name="measure2[]" class="form-control"  v-model="(item.item==null)?null:item.item.measure2.measure_id">
                                              <option value="null">@lang('layout.Select')</option>
                                              <span v-if="(item.item ==null)?false:true">
                                                <option  v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure.measure_id">
                                                @{{measure.measure_name}}
                                              </option> 
                                              </span>
                                            </select>
                                          </td>
                                        @endif
                                        @if(getM4()!="")  
                                          <td>
                                            <select name="measure3[]" class="form-control"  v-model="(item.item==null)?null:item.item.measure3.measure_id">
                                              <option value="null">@lang('layout.Select')</option>
                                              <span v-if="(item.item ==null)?false:true">
                                                <option  v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure.measure_id">
                                                @{{measure.measure_name}}
                                              </option> 
                                              </span>
                                            </select>
                                          </td>
                                        @endif

                                  <td>
                                    <div class="input-group">
                                      <input type="number" :name="'inventory_price['+index+']'"  placeholder="@lang('layout.Price')"   v-bind:value="(item.item==null)?null:saleNewRate(item.item,selected_currency.rate)" ref="in" @input="setNewRate('inventory',index)" class="form-control">
                                      <span class="input-group-addon">
                                        @{{selected_currency.symbol}}
                                      </span>
                                    </div>
                                     
                                  </td>
								  <td>
										<input :name="'khada['+index+']'"  type="number" :value="(item.item==null)?null:((item.item.code==null)?null:item.item.code.khada)"  ref="khada" @input="setNewRate('inventory',index)" class="form-control" placeholder="@lang('layout.Wing')" >
							      </td>
                                  <td>
                                         <div class="input-group">
                                            <input type="number" class="form-control inner_input" :value="(item.item==null)?null:((item.item.code==null)?null:item.item.code.qut_temp * selected_currency.rate * item.item.new_rate)"   :value="(item.item==null)?null: * selected_currency.rate" placeholder="@lang('layout.Total')" disabled>
                                            <span class="input-group-addon" >
                                            <b>@{{selected_currency.symbol}}</b>
                                        </span>
                                         </div>
                                  </td>
                                  <td>
                                       <span v-if="index > 0"  v-on:click="deleteItem('inventory',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>

                                  </td>
                              </tr>
							  
							  <!-- tr><td></td><td style="padding: 0px;"><li class="list-group-item bg-green bg-font-green"> @lang('layout.Roll') </li></td></tr -->
							
							<!--/row-->
							<!-- tr v-if="inventories[0].item !=null" v-for="(service,index) in ItemRoll">
						
								<td>@{{index+1}}</td>
								<td colspan="2" >
									<v-select label="name" v-model="service.selected_sub_item" :options="subItems" @search="onItemSearchCode" @click.native="addNew_roll(index)" placeholder="@lang('layout.Code')" style=""></v-select>
									<input type="hidden" name="sub_item[]" :value="(!service.selected_sub_item)?null:service.selected_sub_item.id">
									<input type="hidden" name="m_stocks_in_id[]" :value="(!service.selected_sub_item)?null:service.selected_sub_item.id" >
									<input type="hidden" name="main_stock_id[]" :value="(!service.selected_sub_item)?null:service.selected_sub_item.main_stock_id" >
								</td>
								<td>
										<input name="qut_out[]" ref="OnHand" type="number"  @input="change_qut(index)" :value="(!service.selected_sub_item)?null:service.selected_sub_item.OnHand" class="form-control" placeholder="@lang('layout.Quantity')"   >
								</td>
								<td>
										<input name="lengths[]" ref="lengths" type="number" @input="change_lengths(index)" :value="(!service.selected_sub_item)?null:service.selected_sub_item.lengths.toFixed(1)" class="form-control" placeholder="@lang('layout.Length')" >
								 </td>
								
								<td>
										<input type="number"  name="" :value="(!service.selected_sub_item)?null:service.selected_sub_item.qut_temp * inventories[0].item.measure_unit/inventories[0].item.measure.measure_unit" disabled  placeholder="@lang('layout.OnHand')" class = 'form-control' >
								</td>
								<td>
										<input name="widths[]" type="number" readonly :value="(!service.selected_sub_item)?null:service.selected_sub_item.widths" class="form-control" placeholder="@lang('layout.Width')" >
							   </td>
								
								<td>
									<input name="cost[]" type="hidden" readonly :value="(!service.selected_sub_item)?null:service.selected_sub_item.cost" class="form-control" placeholder="@lang('layout.Cost')" >
									<input name="cost_roll[]" type="hidden" :value="(!service.selected_sub_item)?null:service.selected_sub_item.per_price" ref="per_price" @input="change_lengths(index)" class="form-control" placeholder="@lang('layout.Price')" >
									<div class="input-group">
									<input type="number"  placeholder="@lang('layout.Total')"   v-bind:value="(!service.selected_sub_item)?null:getItemTotalRoll(service.selected_sub_item.OnHand)" class="form-control">
                                      <span class="input-group-addon" >
                                            <b>@{{selected_currency.symbol}}</b>
                                        </span>
                                      </div>
								</td>
								<td>
									 <span  v-if="index != 0" v-on:click="deleteItem_roll(index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
								</td>
								
							</tr -->
                          </tbody>
                      </table>

                     <hr>
                                       <!-- begin service -->
                                     <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                                          <thead>
                                              <tr>
                                                  <th class="text-center" style="min-width: 8px;"> # </th>
                                                  <th class="text-center" style="min-width: 160px;">@lang('layout.ServiceName')</th>
                                                  <th class="text-center" style="min-width: 160px;">@lang('layout.Quantity')</th>
                                                  <th class="text-center" style="min-width: 160px;">@lang('layout.Measure')</th>
                                                  <th class="text-center" style="min-width: 160px;">@lang('layout.Price')</th>
                                                  
                                                  <th class="text-center" style="min-width: 120px;">@lang('layout.Total')</th>
                                                  <th></th>
                                            
                                              </tr>
                                          </thead>
                                          <tbody>
                                              <tr v-for="(service,index) in services">
                                                  <td>@{{index+1}}</td>
                                                  <td class="highlight">
                                                      <v-select label="name" v-model="service.item"  :options="(service.items)" @click.native="addNew('service',index)" @input="checkExistingService(index)">
                                                        
                                                      </v-select>
                                                      <input type="hidden" name="service_id[]" :value="(service.item==null)?null:service.item.id">
                                                  </td>
                                              
                                                  <td>
                                                    <input class="form-control" name="service_quantity[]" v-model.number="(!service.item)?null:service.item.quantity" placeholder="@lang('layout.Quantity')">
                                                  </td>
                                                  <td class="highlight">
                                                      <select  v-model="(service.item == null)?null:service.item.measure" class="form-control" @change="measureChangeservice(index)">
                                                          <option value="null">@lang('layout.Select')</option>
                                                          <span v-if="(service.item ==null)?false:true">
                                                              <option  v-for="measure in (service.item==null)?null:service.item.measure_list" :value="measure">
                                                              @{{measure.measure_name}}
                                                            </option> 
                                                          </span>
                                                          
                                                      </select>
                                                     
                                                      <input type="hidden" name="service_measure[]" :value="(service.item==null)?null:service.item.measure.measure_id">
                                                  </td>
                                                  <td>
                                                      <div class="input-group">
                                                        <input type="number" name="service_price[]"  placeholder="@lang('layout.Price')"   :value="(service.item==null)?null:saleNewRate(service.item,selected_currency.rate)" ref="ser" @input="setNewRate('service',index)" class="form-control">


                                                        


                                                        <span class="input-group-addon">
                                                          @{{selected_currency.symbol}}
                                                        </span>
                                                      </div>
                                                    
                                                  </td>
                                                  <td>
                                                      <div class="input-group">
                                                            <input type="number" class="form-control inner_input"   :value="(service.item==null)?null:getItemTotalService(service.item,selected_currency.rate).result" placeholder="@lang('layout.Total')" disabled>
                                                        <span class="input-group-addon" >
                                                            <b>@{{selected_currency.symbol}}</b>
                                                        </span>
                                                         </div>


                                                  </td>
                                                  <td>
                                                       <span  v-on:click="deleteItem('service',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                                  </td>
                                              </tr>
                                          </tbody>
                                      </table>
                                     <!-- end service -->
                                     <hr>
                                     <!-- begin payments -->
                                     <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                                          <thead>
                                              <tr>
                                                  <th class="text-center" style="min-width: 8px;"> # </th>
                                                  <th class="text-center" style="min-width: 160px;">@lang('layout.SelectBank')</th>
                                                  <th class="text-center" style="min-width: 100px;"> @lang('layout.Amount')</th>
                                                  <th class="text-center" style="min-width: 120px;"> @lang('layout.Rate')</th>
                                                  <th class="text-center" style="min-width: 80px;">@lang('layout.Currency')</th>
                                                  <th class="text-center" style="min-width: 80px;"> @lang('layout.Amount')</th>
                                                  <th class="text-center" style="min-width: 120px;">@lang('layout.Total')</th>
                                                  <th></th>
                                            
                                              </tr>
                                          </thead>
                                          <tbody>
                                              <tr v-for="(payment,index) in payments">
                                                  <td>@{{index+1}}</td>
                                                  <td class="highlight">
                                                      <v-select label="name" v-model="payment.item"  :options="(payment.items)" @click.native="addNew('payment',index)" @input="checkExistingPayment(index)">
                                                        
                                                      </v-select>
                                                      <input type="hidden" name="payment_id[]" :value="(payment.item==null)?null:payment.item.id">
                                                  </td>
                                              
                                                 <td>
                                                 
                                                      <span v-if="payment.item !=null">
                                                        @{{myRound(Number((payment.item==null)?null:payment.item.balance)-Number((payment.item==null)?null:payment.item.amount))}}
                                                      </span>
                                                 </td>
                                                 <td>
                                                     <input v-bind:disabled="(payment.item==null)?false:(payment.item.code =='{{getHomeCurrency()["code"]}}')" type="number"   v-model.number="(payment.item==null)?null:payment.item.rate "
                                                      class="form-control"
                                                      placeholder="@lang('layout.Rate')" />
                                                      <input v-if="payment.item !=null" type="hidden" name="payment_rate[]"
                                                      v-bind:value="payment.item.rate">
                                                 </td>
                                                 <td>
                                                     <input type="text" name="payment_currency[]" class="form-control"
                                                      v-model="(payment.item==null)?null:payment.item.code"
                                                      placeholder="@lang('layout.Currency')" disabled reqiured/>

                                                      <input v-if="payment.item !==null" type="hidden" name="payment_currency[]"
                                                      v-bind:value="payment.item.code"/>
                                                 </td>
                                                 <td>
                                                    <div class="input-group">
                                                      <input type="number" class="form-control"
                                                      v-model.number="(payment.item==null)?null:payment.item.amount "
                                                      placeholder="@lang('layout.PayAmount')"/>

                                                      <input v-if="payment.item !=null" type="hidden" name="payment_amount[]"
                                                      v-bind:value="payment.item.amount">

                                                      <span class="input-group-addon">@{{(payment.item==null)?null:payment.item.code}}</span>
                                                  </div>
                                                 </td>
                                                 <td>
                                                     <div class="input-group">
                                                      <input type="number" class="form-control"
                                                      :value="(payment.item==null)?null:totalPayments(payment.item,selected_currency.rate)"
                                                      placeholder="@lang('layout.Total')" style="min-width: 100px"/>
                                                      <span class="input-group-addon">@{{selected_currency.symbol}}</span>
                                                  </div>
                                                 </td>
                                                  <td>
                                                       <span  v-on:click="deleteItem('payment',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                                  </td>
                                              </tr>
                                          </tbody>
                                          
                                      </table>
                                     <!-- end payments -->
                                     </div>
                                                        
                                                   
                                     
                                    </div>
                                    <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                                        <button type="button" v-if="!isError" @click="submitForm" class="btn green">@lang('layout.Submit')</button>
                                        <a href="{{route('inventorySite.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>

                                    </div>  
                                <cmodal :show='showModal' @close="showModal=false">
                                  
                                </cmodal>
                            </div>


                               </div>



                             

 {!! Form::close() !!}

                           </div>
                          
                        </div>


                        </div>
                    <p> &nbsp; </p>
                    <p> &nbsp; </p>
                </div>
          </div>
          <!-- END TAB PORTLET-->
    </div>
</div> 

@endsection
@push('scripts')


<script type="text/javascript">

@if(App::getLocale())
  Vue.use(VeeValidate, {
      locale: '{{App::getLocale()}}',
  });
  @else
Vue.use(VeeValidate, {
    locale: 'en',
});
@endif


  Vue.component('v-select', VueSelect.VueSelect);

  Vue.component("modal",{
    template:"#modal-template",
    props:['show'],

  });

  //begin new member
  Vue.component("cmodal",{
    template:'#cmodal-template',

    props: ['show'],
    data(){
        return {
            types: [],
            classes:[],
            receivables: [],
            payables: [],
            code: null,
            selectType: null,
            selectPay: null,
            selectedClass: null,
            selectReceive: null,
        }
    },
    created(){
      
      axios.get('{{route("customer.create")}}').then(
        response=>{
          this.types = response.data.types;
          if(this.types)
          {
            for(var i=0;i<this.types.length;i++)
            {
              if(this.types[i].type=="Customer")
              {
                 this.selectType=this.types[i];
              }
            }
          }
          this.receivables = response.data.receivable;
          this.payables = response.data.payable;
          this.code = response.data.code;
          this.classes = response.data.member_class;
          if(this.receivables.length>0)
          {
              this.selectReceive=this.receivables[0];
          }
          if(this.payables.length>0)
          {
              this.selectPay=this.payables[0];
          }


        }).catch(error=> console.log(error));
    },
    methods:{
      onSubmit(){

        v.showModal = false;
        //this.member.type = this.member.type.id;
        var datas = $("#modalForm").serializeArray();
        $.ajax({
          headers:{'X-CSRF-TOKEN':"{{csrf_token()}}"},
          url:'{{route("customer.store")}}',
          method:'post',
          data: {
            "name": datas[0]['value'],
            'code': datas[1]['value'],
            'email': datas[2]['value'],
            'phone': datas[3]['value'],
            'address1': datas[4]['value'],
            'type':this.selectType.id,
            'receivable':this.selectReceive.id,
            'payable':this.selectPay.id,
            'class':(this.selectedClass)?this.selectedClass.id:null
          },
          dataType: 'json',

        }).done(function(response){
          axios.get('{{route("invoice.create")}}').then(response=>{
            
            v.customer =response.data.customer;
            document.getElementById("modalForm").reset();

          }).catch(error=> console.log(error));

        }).fail(function(error){
          console.log('error',error);
        });
        
      }
    }
  });

// end new member


  var customer={!! $customer !!};
  var currency={!! $currency !!};
  var selectedCurrency = {!! $selectedCurrency !!};
  var banks = {!! $banks !!};
  var selectedBanks = {!! $selectedBanks !!};
  var all_services = {!! $all_services !!};
  var selectedService = {!! $selectedService !!};
  var selectedCustomer= {!! $selectedCustomer !!};
  var selectedItem= {!! $selectedItem !!};
  var ItemStockRoll = {!! $ItemStockRoll !!};
  var invoice = {!! $invoice !!};
  var selectedTransportCompany = {!! $selectedTransportCompany !!};
  var selectedDriver = {!! $selectedDriver !!};

  var transportCompany = {!! $transportCompany !!};
  var allDrivers               = {!! $allDrivers !!};
  var v = new Vue({
    el: '#appInvoice',
    data: {
       showModal: false,
       invoice:invoice,
       customer:customer,
       selected_customer:selectedCustomer,
       selected_customer_id:selectedCustomer.id,
       selected_item:selectedItem,
       ItemStockRoll:ItemStockRoll,
       banks:banks,
       selected_banks:selectedBanks,
       all_services:all_services,
       selected_service:selectedService,
       currency:currency,
       selected_currency:selectedCurrency,
       rate:0,
       discountFiled: 0,
       selectedIndex: 0,
       discountIsAmount:false,
       temp_items:[],
       totalAmountes: [],
       
     
       
       newCost:[
       null,
       null,
       null,
       null],
       inventories:[

       ],
	   subItems:[],
		ItemRoll:[],
       services:[

        ],
        payments: [

        ],
        CusTypes: null,

        transportCompany: transportCompany,
        allDrivers: allDrivers,
        selected_transportCompany: selectedTransportCompany,
        selected_transportDriver: selectedDriver,
        t_drivers: allDrivers
    },
    computed:{
      selectedRate()
      {            
         this.rate= (this.selected_currency)?this.selected_currency.rate:0;
         
      },
        discount()
        {
          if(this.discountIsAmount){

              if(this.subtotal>0 && this.discountFiled) {
                  return  (parseFloat(this.discountFiled) * 100) / (this.subtotal);
              }else {
                  return 0;
              }
              }else {

                  return this.discountFiled
              }

          },
		  
		  
		   
		  // calculate subtotal
          subtotal: function ()
          {
                var sum = 0;
                var sumRoll = 0;
                // for (var i = 0; i < this.ItemRoll.length; i++) {
                    // if (this.ItemRoll[i].selected_sub_item && this.ItemRoll[i].selected_sub_item !=null && this.inventories[0].item !=null)
                    // {  

                        // var quantity=this.ItemRoll[i]['selected_sub_item']['OnHand'];
                        // var rate=this.inventories[0]['item']['rate'];
                        // var new_rate=this.inventories[0]['item']['new_rate'];
                        // var smeasure_unit=this.inventories[0]['item']['measure']['measure_unit'];
                        // var measure_unit=this.inventories[0]['item']['measure_unit'];
                        // if(new_rate !=rate && quantity>0)
                        // {
                           // sum +=new_rate*quantity*this.selected_currency.rate;
                           // sumRoll +=new_rate*quantity*this.selected_currency.rate;
                        // }
                        // else
                        // {
                          // sum +=quantity*((rate*smeasure_unit/measure_unit)*this.selected_currency.rate);
                          // sumRoll +=quantity*((rate*smeasure_unit/measure_unit)*this.selected_currency.rate);
                        // }
                        
                    // }

                // }
				for (var i = 0; i < this.inventories.length; i++) {
                    if (this.inventories[i].item)
                    { 
				if (this.inventories[i].item.code !=null)
                    {  

                        var quantity=this.inventories[i]['item']['code']['qut_temp'];
                        var rate=this.inventories[i]['item']['rate'];
                        var new_rate=this.inventories[i]['item']['new_rate'];
                        var smeasure_unit=this.inventories[i]['item']['measure']['measure_unit'];
                        var measure_unit=this.inventories[i]['item']['measure_unit'];
                        if(new_rate !=rate && quantity>0)
                        {
                           sum +=new_rate*quantity*this.selected_currency.rate;
                           sumRoll +=new_rate*quantity*this.selected_currency.rate;
                        }
                        else
                        {
                          sum +=quantity*((rate*smeasure_unit/measure_unit)*this.selected_currency.rate);
                          sumRoll +=quantity*((rate*smeasure_unit/measure_unit)*this.selected_currency.rate);
                        }
                        
                    }
                    }

                }
				
				
				
                for (var i = 0; i < this.services.length; i++) {
                    if (this.services[i].item && this.services[i].item !=null)
                    {

                        var rate=this.services[i]['item']['rate'];
                        var new_rate=this.services[i]['item']['new_rate'];
                        var smeasure_unit=this.services[i]['item']['measure']['measure_unit'];
                        var measure_unit=this.services[i]['item']['measure_unit'];
                         var quantity=this.services[i]['item']['quantity'];
                        if(new_rate !=rate && quantity>0)
                        { 
                           sum +=new_rate*quantity*this.selected_currency.rate;
                        }
                        else
                        {
                           sum += quantity *((rate*smeasure_unit/measure_unit)*this.selected_currency.rate);
                        }
                       
                    }
                }
				this.totalCos = sumRoll;
                
				return sum;
          },

/**
          // calculate subtotal
          subtotal: function ()
          {
                var sum = 0;
                for (var i = 0; i < this.inventories.length; i++) {
                    if (this.inventories[i].item && this.inventories[i].item !=null)
                    {  

                        var quantity=this.inventories[i]['item']['quantity'];
                        var rate=this.inventories[i]['item']['rate'];
                        var new_rate=this.inventories[i]['item']['new_rate'];
                        var smeasure_unit=this.inventories[i]['item']['measure']['measure_unit'];
                        var measure_unit=this.inventories[i]['item']['measure_unit'];
                        if(new_rate !=rate && quantity>0)
                        {
                           sum +=new_rate*quantity*this.selected_currency.rate;
                        }
                        else
                        {
                          sum +=quantity*((rate*smeasure_unit/measure_unit)*this.selected_currency.rate);
                        }
                        
                    }

                }
                for (var i = 0; i < this.services.length; i++) {
                    if (this.services[i].item && this.services[i].item !=null)
                    {

                        var rate=this.services[i]['item']['rate'];
                        var new_rate=this.services[i]['item']['new_rate'];
                        var smeasure_unit=this.services[i]['item']['measure']['measure_unit'];
                        var measure_unit=this.services[i]['item']['measure_unit'];
                         var quantity=this.services[i]['item']['quantity'];
                        if(new_rate !=rate && quantity>0)
                        { 
                           sum +=new_rate*quantity*this.selected_currency.rate;
                        }
                        else
                        {
                           sum += quantity *((rate*smeasure_unit/measure_unit)*this.selected_currency.rate);
                        }
                       
                    }
                }
                return sum;
          },
**/
          // check payed amount
          payeds: function ()
           {
              var sum = 0;
              for (var i = 0; i < this.payments.length; i++)
               {

                  if(this.payments[i].item !=null && this.payments[i].item)
                  {
                     if (this.payments[i].item !=null && this.payments[i]['item']['rate']>0)
                     {
                      //
                      sum += (this.payments[i]['item']['amount'] * this.selected_currency.rate / this.payments[i]['item']['rate']) ;
                    }
                  }
                }
                return sum;
            },

            // check data validation
            isError: function () 
            {
                var isError = false;
                var flag=false;
                  for (var i = 0; i < this.inventories.length; i++)
                 {
                    
                    if (this.inventories[i].item)
                    {
                      flag=true;
                        // rate=this.inventories[i]['item']['rate'];
                        new_rate=this.inventories[i]['item']['new_rate'];
                        if(new_rate <=0)
                        {
                             isError = true;
                        }
                       
                      
                    } 
                 }
                 if(this.selected_customer==undefined || this.selected_customer==null)
                 {
                    isError = true;
                 }
                return isError;
              

            },
    },
    mounted:function(){
    
 
      // initialize the selected item
     
       for(var i=0;i<this.selected_item.length;i++)
      {
        this.inventories.push({item:this.selected_item[i]});
		if (this.inventories[i].item.code !=null)
                    {
						this.inventories[i]['item']['code']['qut_temp'] = this.inventories[i]['item']['code']['qut_temp'] * this.inventories[i].item.measure_unit/this.inventories[i].item.measure.measure_unit;
						this.inventories[i]['item']['code']['OnHand'] = this.inventories[i]['item']['code']['OnHand'] * this.inventories[i].item.measure_unit/this.inventories[i].item.measure.measure_unit;
					}
      }
       for(var i=0;i<this.ItemStockRoll.length;i++)
				{
				this.ItemRoll.push({selected_sub_item:this.ItemStockRoll[i]});
				
				this.ItemRoll[i].selected_sub_item.OnHand = this.ItemRoll[i].selected_sub_item.OnHand * this.inventories[0].item.measure_unit/this.inventories[0].item.measure.measure_unit
			
				//console.log(this.ItemRoll[i]);
				}
      // end item

      // begin payment initialization

      for(var t=0;t<this.selected_banks.length;t++)
      {
        var foundFlag=false;
        var tempBank=null;
        for(var y=0;y<this.banks.length;y++)
        {
            if(this.selected_banks[t].id==this.banks[y].id)
            {
               foundFlag=true;
               tempBank=this.banks[y];
               tempBank.amount=this.selected_banks[t].balance;
               tempBank.rate=this.selected_banks[t].rate;
            }
        }
        if(foundFlag)
        {

          this.payments.push({item:tempBank,items:this.banks});
        }
      }
      for(var w=1;w>this.selected_banks.length;w--)
      {
         this.payments.push({item:null,items:banks});
      }
      // end payment initialization

      // begin service

      for(var r=0;r<this.selected_service.length;r++)
      {
         var flag=false;
         var tempService;
         for(var h=0;h<this.all_services.length;h++)
         {
             if(this.all_services[h].id==this.selected_service[r].item_id)
             {
               flag=true;
               tempService=this.all_services[h];
               tempService.quantity=this.selected_service[r].qty;
               tempService.rate=this.selected_service[r].sales_price;
               tempService.new_rate=this.selected_service[r].sales_price;
             }
         }
         if(flag)
         {
            this.services.push({item:tempService,items:this.all_services})
         }
      }
      for(var w=1;w>this.selected_service.length;w--)
      {
         this.services.push({item:null,items:all_services});
      }
      // end service

      if(this.invoice)
      {
         this.discountFiled=this.invoice.discount;
         if(this.invoice.discount_type)
         {
            if(this.invoice.discount_type=='percent')
            { 
               this.discountIsAmount=false;
            }
            else
            {
               this.discountIsAmount=true;
            }
         }
      }
    },
    methods:
    {
   
      
	   // calculte total of item or service
			 getItemTotalRoll(quantity=null)
			 {
				var new_rate=this.inventories[0]['item']['new_rate'];
				var smeasure_unit=this.inventories[0]['item']['measure']['measure_unit'];
				var measure_unit=this.inventories[0]['item']['measure_unit'];
			   var result=0;
			   if(new_rate !=null && smeasure_unit !=null && measure_unit !=null && quantity !=null)
			   {
					
					var price=((measure_unit*new_rate)/smeasure_unit);
					var qty=(smeasure_unit*quantity)/measure_unit;
					var temp=price*qty*v.selected_currency.rate;
					result =Number.parseFloat(temp).toFixed(precision());
				}
			   // console.log(result);
			   return result;
			   
				
			 },
  
       // calculate item price based on measure change
       measureChange(index)
       {
			if(this.inventories[index].item !=null){
            var item=this.inventories[index].item;
          
            var temp=((item.rate*item.measure.measure_unit/item.measure_unit));
            result=Number.parseFloat(temp).toFixed(precision());

            this.inventories[index].item.new_rate =result;
			console.log('lll',item.measure.measure_unit);
			console.log('qwe',item.measure_unit);
            // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;
			
				if (item.code !=null)
                    {
						item['code']['qut_temp'] = item['code']['qut_temp'] * item.measure_unit/item.measure.measure_unit;
						item['code']['OnHand'] = item['code']['OnHand1'] * item.measure_unit/item.measure.measure_unit;
					}
            }
			
       },
       
           // calculate item price based on measure change
       measureChangeservice(index)
       {
    
           if(this.services[index].item !=null){
            var item=this.services[index].item;
          
            var temp=((item.rate*item.measure.measure_unit/item.measure_unit)*this.selected_currency.rate);
            result=Number.parseFloat(temp).toFixed(precision());

            this.services[index].item.new_rate =result;

            // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;
            
            }
       },
       // detect member change and searh
       memberChange()
       {
          if(this.selected_customer.id != this.selected_customer_id)
            {
            
			
			 for(var i=0;i<this.inventories.length;i++)
				  {
					if (this.inventories[i].item !=null)
						{
							this.inventories[i]['item']['sale_order_detail_id'] = null;
						}
				  }
			
			
          }
       },
       // end sale order change

       
      //Get Transport Company Drivers 
        getDrivers() {
          if (this.selected_transportCompany) {
            axios.get("{{route('callMethod.search')}}",
              {
                params: {
                  transport_id: this.selected_transportCompany.id,
                  method_name: 'Search_transport_company_drivers'
                },
              })
              .then(function (response) {
                if (response.data.result != null) {
                  console.log('all Drivers',response.data.result);
                  v.t_drivers=response.data.result;
                  // v.selected_transportDriver=null;
                }
                else {

                }
              })
              .catch(function (error) {
                console.log(error);
              });
          }
        },

       //Get Just Drivers  without Transport Company Select
         getAllDrivers() {
            if (!v.selected_transportCompany) {
            v.t_drivers=v.allDrivers;
            }
        },
       // set new price
       setNewRate(type=null,index=null)
       {
		if(type=='inventory')
		  { 
			  if(this.inventories[index].item)
			  {
				 this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;
			  }
			  if(this.inventories[index].item.code != null)
			  {
				 this.inventories[index].item.code.qut_temp = this.$refs.qut_temp[index].value;
				 this.inventories[index].item.code.khada = this.$refs.khada[index].value;
			  }
		  }  
          if(type=='service')
          {
              if(this.services[index].item)
              {
                 console.log('service changed');
                 this.services[index].item.new_rate = this.$refs.ser[index].value/this.selected_currency.rate;
              }
          }
       },

    
       //ajax call to get items
        onItemSearch:_.debounce((search,loading)=>{
           loading(true);
           axios.get("{{route('callMethod.search')}}",
           {

            params:{
              method_name:'itemSearchSaleRoll',
              keyword:search,
            },
           })
           .then(function (response)
           {
             v.temp_items=[];
			 v.subItems=[];
             if(response.data.length>0)
             {
                v.temp_items=response.data;
                console.log('avg',response.data);
             }
             loading(false);
           })
           .catch(function (error)
           {
              console.log(error);
           });
         
       },getDebounceTime()),

       // end item search

       // contract search
	   
	   //ajax call to get items code
           onItemSearchCode:_.debounce((search,loading)=>{
               item_id = v.inventories[v.selectedIndex].item.id;
               inventory_site = v.inventories[v.selectedIndex].item.site.site_id;
               loading(true);
               axios.get("{{route('callMethod.search')}}",{
                params:{
                  method_name:'getAssebmliesSubSite',
                  keyword:search,
                  item_id:item_id,
                  inventory_site:inventory_site,
                }
               })
               .then(function (response)
               {
                 v.subItems=[];
                 if(response.data.length>0)
                 {
                    v.subItems=response.data;
                    console.log('subItems',v.subItems);
                 }
                 loading(false);
               })
               .catch(function (error)
               {
                  console.log(error);
               });
           },getDebounceTime()),

        

       // end contract search

       // generic function for adding item to list
       addNew(type=null,index)
       {
          this.temp_items=[];
          if(type !=null)
          {
             if(type=='inventory')
             {
                if(this.inventories[index+1]==undefined)
                {
                  this.temp_items=[];
                  this.inventories.push({item:null});
                }
             }
            if(type=='service')
             {
                if(this.services[index+1]==undefined)
                {
                  this.checkExistingService(index,'');
                  this.services.push({
                    items: this.all_services,
                    item: null,
                });
                }
             }
             if(type=='payment')
             {
                if(this.payments[index+1]==undefined)
                {
                  this.checkExistingPayment(index,'');
                  this.payments.push({
                    items: this.banks,
                    item: null,
                });
                }
             }
          }
          
       },

       // in here you can check and decide to allow duplicate bank for payment or not
       checkExistingPayment(index=null,name='')
       {      
              var bank_temp=this.banks.slice();
              var bank_temp1=[];
              for(var i=0;i<this.payments.length;i++)
              {
                  if(this.payments[i].item !=null)
                  {
                      var fined=bank_temp.findIndex((item)=> item.name == this.payments[i].item.name);
                      if(fined !=-1)
                      {
                        var o=bank_temp.splice(bank_temp.findIndex((item)=>item.name == this.payments[i].item.name),1);
                      }
                  }
              }
              this.payments[index].items = bank_temp.filter((item) => {
                        return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                    });
               //this.payments[index].items =bank_temp; 


       },

        // in here you can check and decide to allow duplicate service or not
       checkExistingService(index=null,name='')
       {      
              var service_temp=this.all_services.slice();
              var service_temp1=[];
              for(var i=0;i<this.services.length;i++)
              {
                  if(this.services[i].item !=null)
                  {
                      var fined=service_temp.findIndex((item)=> item.name == this.services[i].item.name);
                      if(fined !=-1)
                      {
                        var o=service_temp.splice(service_temp.findIndex((item)=>item.name == this.services[i].item.name),1);
                      }
                  }
              }
              this.services[index].items = service_temp.filter((item) => {
                        return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                    });
               //this.payments[index].items =bank_temp; 


       },
	   
	   
	    change_lengths(index)
      {       
			if(this.ItemRoll[index].selected_sub_item)
				  {
					var per_qut_in=this.ItemRoll[index].selected_sub_item.per_qut_in;
					var lengths = this.$refs.lengths[index].value;
					 this.ItemRoll[index].selected_sub_item.lengths = this.$refs.lengths[index].value;
					 this.ItemRoll[index].selected_sub_item.OnHand = (per_qut_in * lengths).toFixed(1);
					 this.ItemRoll[index].selected_sub_item.per_price = this.$refs.per_price[index].value;
				}
		 setTimeout(function(){ v.deleteItem_roll(100); }, 30);
      },
	  change_qut(index)
      {       
	  
			if(this.ItemRoll[index].selected_sub_item)
				  {
					var per_qut_in=this.ItemRoll[index].selected_sub_item.per_qut_in;
					var OnHand = this.$refs.OnHand[index].value;
					 this.ItemRoll[index].selected_sub_item.OnHand = this.$refs.OnHand[index].value;
					 this.ItemRoll[index].selected_sub_item.lengths = (OnHand / per_qut_in);
					 this.ItemRoll[index].selected_sub_item.per_price = this.$refs.per_price[index].value;
				}
				
         setTimeout(function(){ v.deleteItem_roll(100); }, 30);
      },
	   
	   // delete item from list
		addIndex(index)
		{
			v.subItems = [];
			v.selectedIndex = index;
		},
	   
       // delete item from list
       deleteItem(type=null,index)
       {
         if(type !=null)
         {
             console.log(type);
             if(type=='inventory')
             {
                this.inventories.splice(index, 1);
             }
              if(type=='service')
             {
                this.services.splice(index, 1);
             }
              if(type=='payment')
             {
                this.payments.splice(index, 1);
             }
         }
          
       },
	   
	   	   
	   // generic function for adding item to list
		addNew_roll(index)
		{
				v.subItems=[];
				if(this.ItemRoll[index+1]==undefined)
				{
				  this.ItemRoll.push({
					selected_sub_item:null,
				});
				}
			 
		  
		},
		// delete item from list
		deleteItem_roll(index)
		{
				this.ItemRoll.splice(index, 1);
		  
		},
	   
       // submit the form
       submitForm() 
       {

          if(this.isError==true) {
            alert('there is no item');
            return false;
          }
          swal({
                title:"@lang('layout.AreYouSure?')",
                buttons: ["@lang('layout.Cancel')","@lang('layout.Submit')"],
                text: "",
                icon: "info",
                dangerMode: true,
            }).then((willDelete) => {
                if (willDelete)
                {
                    document.getElementById("sales-form").submit()

                }
                else
                {

                }
            });

        },
    },
    

  });

</script>



@endpush