@extends('layouts.factor-master')
<?php 
$reportTitle = __('layout.InvoiceReport');
?>
@section('content')
<?php
$report = customeReport('invoice','detail');
$seeCost = \Entrust::can('cost-create');
?>
<h3 class="table-caption" style="text-align: center;">@lang('layout.InvoiceReport')</h3>

<table  class="main-table">
 @if($info && $info !=[])

 <tr>
  <td>
    <span>@lang('layout.InvoiceNumber')</span>:&nbsp;&nbsp;
    <span>{{$info->number}}</span>
  </td>
  <td>
    <span>@lang('layout.Customer')</span>:&nbsp;&nbsp;
    <span>{{$info->member_name}}</span>
  </td>
  <td>
    <span>@lang('layout.Account')</span>:&nbsp;&nbsp;
    <span>{{$info->account_name}}</span>
  </td>
  <td>
    <span>@lang('layout.Amount')</span>:&nbsp;&nbsp;
    <span>{{$info->amount}}</span>
  </td>
   <td>
  <span>@lang('layout.Currency')</span>:&nbsp;&nbsp;
  <span>{{$info->currency}}</span>
</td>
</tr>
<tr>

<td>
  <span>@lang('layout.Rate')</span>:&nbsp;&nbsp;
  <span>{{$info->rate}}</span>
</td>
<td>
  <span>@lang('layout.DiscountType')</span>:&nbsp;&nbsp;
  <span>{{$info->discount_type}}</span>
</td>
<td>
  <span>@lang('layout.Discount')</span>:&nbsp;&nbsp;
  <span>{{$info->discount}}</span>
</td>
<td>
  <span>@lang('layout.Type')</span>:&nbsp;&nbsp;
  <span>{{$info->type}}</span>
</td>
<td>
  <span>@lang('layout.Quantity')</span>:&nbsp;&nbsp;
  <span>{{$info->qty}}</span>
</td>

</tr>
@endif

</table>
<br>

<table class="main-table">

<thead>
<tr class="bg">

 <td class="center"><div > @lang('layout.Record') </div></td>
  <th style="display: <?=(!show('item_name',$report))?'none':'';?>">@lang('layout.ItemName')</th>
  <th style="display: <?=(!show('item_name',$report))?'none':'';?>">@lang('layout.Site')</th>
  <th style="">@lang('layout.Code')</th>
  @if(systemConfig()[9] == 0 )
  <th style="">@lang('layout.Length')</th>
  <th style="">@lang('layout.Width')</th>
	@endif
	@if(itemBrand()=="true")
  <th style="">@lang('layout.Brand')</th>
  @endif
  @if(ImportEngineNumberByExcel()=="true")
  <th>@lang('layout.DocumentReceived')</th>
  @endif
  @if(showLocation()=="true")
  <th style="">@lang('layout.Location')</th>
	@endif
  <th style="display: <?=(!show('symbol',$report))?'none':'';?>">@lang('layout.Symbol')</th>
  <th style="display: <?=(!show('purchase_date',$report))?'none':'';?>">@lang('layout.PurchaseDate')</th>
  <th style="display: <?=(!show('sleep_staff',$report))?'none':'';?>">@lang('layout.SleepStaff')</th>
  @if(getOtherMeasure()=="true")
  <th>@lang('layout.OMeasureValue') 1</th>
  <th>@lang('layout.OMeasureValue') 2</th>
  @endif 
  <th style="display: <?=(!show('quantity',$report))?'none':'';?>">@lang('layout.Quantity')</th>
  <th style="display: <?=(!show('price',$report))?'none':'';?>">@lang('layout.Price')</th>
  <th style="display: <?=(!show('quantity',$report))?'none':'';?>">@lang('layout.Commission') @lang('layout.Percentage')%</th>
  <th style="display: <?=(!show('price',$report))?'none':'';?>">@lang('layout.Commission') @lang('layout.Amount')</th>
  @if($seeCost==true)
  <th style="display: <?=(!show('purchase_rate',$report))?'none':'';?>">@lang('layout.Cost')</th>
  <th style="display: <?=(!show('income',$report))?'none':'';?>">@lang('layout.Income')</th>
  @endif
  <th style="display: <?=(!show('total',$report))?'none':'';?>">@lang('layout.Total')</th>
</tr>
</thead>
<?php
$count = 0;
?>
@foreach($data AS $record)
<tr>
<td class="center">{{++$count}}</td>
<td style="display: <?=(!show('item_name',$report))?'none':'';?>" class="center">{{$record->name}} ({{$record->gauge}})</td>
<td style="display: <?=(!show('item_name',$report))?'none':'';?>" class="center">{{$record->siteName}}</td>
<td style="" class="center">{{$record->code}}</td>
@if(systemConfig()[9] == 0 )
<td style="" class="center">{{$record->lengths}}</td>
<td style="" class="center">{{$record->widths}}</td>
@endif
@if(itemBrand()=="true")
<td style="" class="center">{{$record->brand}}</td>
@endif
@if(ImportEngineNumberByExcel()=="true")
@if($record->description2 == 'yes')
<td>@lang('layout.DocumentDelivered')</td>
@else 
<td></td>
@endif
@endif
@if(showLocation()=="true")
<td style="" class="center">{{$record->location}}</td>
@endif
<td style="display: <?=(!show('symbol',$report))?'none':'';?>" class="center">{{$record->symbol}}</td>
<td style="display: <?=(!show('purchase_date',$report))?'none':'';?>" class="center">{{$record->stocks_date}}</td>
<td style="display: <?=(!show('sleep_staff',$report))?'none':'';?>" class="center">{{$record->sleepDate}}</td>
@if(getOtherMeasure()=="true")
<td style="" class="center">{{$record->other_measure}}</td>
<td style="" class="center">{{$record->other_measure2}}</td>
@endif
<td style="display: <?=(!show('quantity',$report))?'none':'';?>" class="center">{{$record->qty}}</td>
@if(systemConfig()[30] == 1)
<td style="display: <?=(!show('price',$report))?'none':'';?>" class="center">{{myRound($record->price*$info->static_rate / $info->rate)}}</td>
@else 
<td style="display: <?=(!show('price',$report))?'none':'';?>" class="center">{{myRound($record->price*$info->rate)}}</td>
@endif



<td style="display: <?=(!show('price',$report))?'none':'';?>" class="center">{{$record->row_commission_percent}}</td>
@if(systemConfig()[30] == 1)



@if($record->row_commission_percent)
<td style="display: <?=(!show('total',$report))?'none':'';?>" class="center">{{myRound(($record->qty*$record->price*$info->static_rate / $info->rate) * $record->row_commission_percent / 100)}}</td>
@else 
<td style="display: <?=(!show('total',$report))?'none':'';?>" class="center"> </td>
@endif
@else 

@if($record->row_commission_percent)
<td style="display: <?=(!show('total',$report))?'none':'';?>" class="center">{{myRound($record->qty*$record->price*$info->rate * $record->row_commission_percent / 100)}}</td>
@else 
<td style="display: <?=(!show('total',$report))?'none':'';?>" class="center"> </td>
@endif
@endif




@if($seeCost==true)
@if(systemConfig()[30] == 1)
<td style="display: <?=(!show('purchase_rate',$report))?'none':'';?>" class="center">{{myRound(($record->avgCost * $record->saleUnit) / $record->itemUnit * $info->static_rate / $info->rate)}}</td>
@else 
<td style="display: <?=(!show('purchase_rate',$report))?'none':'';?>" class="center">{{myRound(($record->avgCost * $record->saleUnit) / $record->itemUnit * $info->rate)}}</td>
@endif
@if(systemConfig()[30] == 1)
<td style="display: <?=(!show('income',$report))?'none':'';?>" class="center">{{myRound($record->income*$info->static_rate / $info->rate)}}</td>
@else 
<td style="display: <?=(!show('income',$report))?'none':'';?>" class="center">{{myRound($record->income*$info->rate)}}</td>
@endif
@endif
@if(systemConfig()[30] == 1)
<td style="display: <?=(!show('total',$report))?'none':'';?>" class="center">{{myRound($record->qty*$record->price*$info->static_rate / $info->rate)}}</td>
@else 
<td style="display: <?=(!show('total',$report))?'none':'';?>" class="center">{{myRound($record->qty*$record->price*$info->rate)}}</td>
@endif
</tr>
@endforeach  
</table>

<table>
  <tr>

  </tr>
</table>

<!--Transport Company And Drivers-->
@if(getTransportCompany()=="true")
    @if($transportCompany)
    @if($transportCompany->driver_name || $transportCompany->trasnport_name!=null )

        <h4><u>@lang('layout.TransportCompanyAndDriver')</u></h4>
        <table class="main-table">

            <tr>
                <th>
                    @lang('layout.Number')
                </th>   
                <th>
                     @lang('layout.LicenseNumber')
                </th>  
                <th>
                     @lang('layout.Name')
                </th>
                <th>
                    @lang('layout.Phone')
                </th>
                <th>
                    @lang('layout.Email')
                </th> 
                <th>
                     @lang('layout.City')
                </th> 
                <th>
                    @lang('layout.Address')
                </th>
            </tr>
            <tr>
                <td>{{$transportCompany->trasnport_number}}</td>
                <td>{{$transportCompany->trasnport_license_number}}</td>
                <td>{{$transportCompany->trasnport_name}}</td>
                <td>{{$transportCompany->trasnport_phone}}</td>
                <td>{{$transportCompany->trasnport_email}}</td>
                <td>{{$transportCompany->trasnport_city}}</td>
                <td>{{$transportCompany->trasnport_address}}</td>
            </tr>

        </table>
        <br>
        <table class="main-table">
            <tr>
                <th>
                    @lang('layout.Number')
                </th>   
                <th>
                     @lang('layout.SSID')
                </th>  
                <th>
                     @lang('layout.Name')
                </th> 
                <th>
                     @lang('layout.LastName')
                </th>
                <th>
                    @lang('layout.Phone')
                </th>
                <th>
                     @lang('layout.City')
                </th> 
                <th>
                    @lang('layout.Address')
                </th>
            </tr>
            <tr>
                <td>{{$transportCompany->driver_code}}</td>
                <td>{{$transportCompany->driver_ss_idr}}</td>
                <td>{{$transportCompany->driver_name}}</td>
                <td>{{$transportCompany->driver_last_name}}</td>
                <td>{{$transportCompany->driver_phone}}</td>
                <td>{{$transportCompany->driver_city}}</td>
                <td>{{$transportCompany->driver_address}}</td>
            </tr>
        </table>

    @endif
    @endif
    @endif
 <!--  End Transport Company And Drivers  -->


 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection