@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('style')

    <style>

        .modal-container {
            width: 50%;
        }

    </style>

@stop
@section('content')
    @include("layouts.Cmodal")
    @include("invoices.modal")
    <div class="row">
        <div class="portlet light bordered">
            <!-- BEGIN TAB PORTLET-->
            <div class="portlet light bordered">
                <div class="portlet-title">
                    <div class="caption">
                        <i class="icon-anchor font-green-sharp"></i>
                        <span class="caption-subject font-green-sharp bold uppercase">@lang('layout.CreateNewInvoice')</span>
                    </div>
                    <div class="actions">
                    </div>
                </div>
                <div id="appInvoice" class="portlet-body">

                    <div class="tabbable tabbable-tabdrop">


                        <div>
                            {{Form::open(['route' => 'invoice_roll.store','method' => 'POST','class' => 'form-horizontal','id'=>'sales-form'])}}
                            {{ csrf_field() }}
                            <div class="tab-content">

                                <div class="tab-pane active" id="tab1">

                                    <div v-cloak class="portlet-body form" style="margin-bottom:50%;">
                                        <!-- begin sale order modal -->
                                        <div id="salOrderApp" v-cloak>
                                        <!-- {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}} -->
                                            <input type="hidden" name="type" value="invoicelist"/>
                                            <!-- use the modal component, pass in the prop -->
                                            <modal v-if="showModalSaleOrder" @close="showModalSaleOrder = false">
                                                <div slot="body">
                                                    <div class="row">
                                                        <div class="form-group">

                                                            <div class="col-md-12">
                                                                <label class="control-label ">@lang('layout.Select') </label>
                                                                <select class="form-control"
                                                                        style="border: 1px solid black !important"
                                                                        v-model="selected_sale_order"
                                                                        @input="saleOrderChang()">
                                                                    <option v-for="order in saleOrderList"
                                                                            :value="order">
                                                                      <span>
                                                                         @{{order.type+':'+order.number+' '+order.description}}
                                                                      </span>
                                                                    </option>
                                                                </select>
                                                            </div>


                                                        </div>
                                                    </div>

                                                    <div class="row">
                                                        <div class="form-group">

                                                            <div class="col-md-6">
                                                                <label class="control-label ">@lang('layout.Currency') </label>
                                                                <input type="text" name=""
                                                                       :value="(!selected_sale_order)?null:selected_sale_order.currency"
                                                                       class="form-control" disabled="disabled">
                                                            </div>
                                                            <div class="col-md-6">
                                                                <label class="control-label ">@lang('layout.Rate') </label>
                                                                <input type="text" name=""
                                                                       :value="(!selected_sale_order)?null:selected_sale_order.rate"
                                                                       class="form-control" disabled="disabled">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        <div class="form-group">

                                                            <div class="col-md-6">
                                                                <label class="control-label ">@lang('layout.Date') </label>
                                                                <input type="text" name=""
                                                                       :value="(!selected_sale_order)?null:selected_sale_order.date"
                                                                       class="form-control" disabled="disabled">
                                                            </div>
                                                            <div class="col-md-6">
                                                                <label class="control-label ">@lang('layout.DeliveryDate') </label>
                                                                <input type="text" name=""
                                                                       :value="(!selected_sale_order)?null:selected_sale_order.delivery_date"
                                                                       class="form-control" disabled="disabled">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        <div class="form-group">

                                                            <div class="col-md-12">
                                                                <label class="control-label ">@lang('layout.Description') </label>
                                                                <input type="text" name=""
                                                                       :value="(!selected_sale_order)?null:selected_sale_order.description"
                                                                       class="form-control" disabled="disabled">
                                                            </div>

                                                        </div>
                                                    </div>
                                                    <br>
                                                    <p style="color: red">@lang('layout.SOmsg')

                                                </div>

                                                <div slot="footer">
                                                    <button type="button" v-if="selected_sale_order"
                                                            @click="getsalesOrders" class="btn btn-success">
                                                        @lang('layout.Submit')
                                                    </button>
                                                    <button type="button" class="btn btn-danger"
                                                            v-on:click="showModalSaleOrder=false">
                                                        @lang('layout.Cancel')
                                                    </button>
                                                </div>
                                            </modal>
                                        <!-- {{Form::close()}} -->
                                        </div>
                                        <!-- end sale order modal -->

                                        <!-- BEGIN FORM-->


                                        <div class="form-body">
                                            <div class="row">
                                                <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12">
                                                    <!-- begin inputs -->
                                                    <div class="row">
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <div class="form-group">

                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.Customer')</label>

                                                                    <v-select label="name" @input="memberChange()"
                                                                              :options="customer"
                                                                              v-model="selected_customer"></v-select>
                                                                    <input type="hidden" name="customer"
                                                                           v-validate="'required'"
                                                                           data-vv-as="@lang('layout.Customer')"
                                                                           :value="!selected_customer?null:selected_customer.id"
                                                                           required>
                                                                    <span class="required">@{{ errors.first('customer') }}</span>
                                                                </div>
                                                            </div>
                                                        </div>


                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <div class="form-group">
                                                                <div class="col-md-12">
                                                                    <label class="control-label col-md-12"><br></label>

                                                                    <button type="button" class="btn blue btn-block"
                                                                            @click="showModal = true">@lang('layout.NewCustomer')</button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <div class="form-group">

                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.InvoiceNumber')</label>

                                                                    <input type="number" name="number"
                                                                           v-validate="'required|numeric'"
                                                                           data-vv-as="@lang('layout.InvoiceNumber')"
                                                                           value="{{$number}}" class="form-control">
                                                                    <span class="required">@{{ errors.first('number') }}</span>
                                                                </div>
                                                            </div>
                                                        </div>

                                                    </div>

                                                    <div class="row">


                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <div class="form-group">

                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.Currency')</label>


                                                                    <v-select label="code" @input="selectedRate"
                                                                              :options="currency"
                                                                              v-model="selected_currency"></v-select>
                                                                    <input type="hidden" name="currency"
                                                                           v-validate="'required'"
                                                                           data-vv-as="@lang('layout.Currency')"
                                                                           :value="selected_currency.code">
                                                                    <span class="required">@{{ errors.first('currency') }}</span>
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <div class="form-group">

                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.Rate')</label>

                                                                    <input type="number" name="currency_rate"
                                                                           v-validate="'required'"
                                                                           data-vv-as="@lang('layout.Rate')" name="rate"
                                                                           v-model="!selected_currency?0:selected_currency.rate"
                                                                           class="form-control"
                                                                           :class="{'has-error':rate<=0}">

                                                                    <input type="hidden" name="hqRate" :value="selected_currency.hq_rate" v-if="selected_currency">
                                                                    <span class="required">@{{ errors.first('currency_rate') }}</span>
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <div class="form-group">

                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.Discount')</label>

                                                                    <div class="input-group">

                                                                        <input v-model="discountFiled"
                                                                               class="form-control"
                                                                               type="number" min="0" max="100">
                                                                        <span v-if="discountIsAmount"
                                                                              @click="discountIsAmount = !discountIsAmount"
                                                                              class="input-group-addon">@{{selected_currency.symbol}}
                                              <input type="hidden" class="input-group-addon" name="discount_type"
                                                     value="currency">
                                          </span>
                                                                        <span v-else
                                                                              @click="discountIsAmount = !discountIsAmount"
                                                                              class="input-group-addon">%
                                              <input type="hidden" name="discount_type" value="percent">
                                          </span>
                                                                        <input type="hidden" name="discountTotal"
                                                                               :value="discount">
                                                                        <input type="hidden" name="discount"
                                                                               :value="discountFiled">
                                                                    </div>

                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="row">

                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <div class="form-group">
                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.Description')</label>
                                                                    <textarea name="description" class="form-control"
                                                                              rows="1"
                                                                              v-text="invoiceDescription"></textarea>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <div class="form-group">

                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.Date')</label>

                                                                    <input type="text" name="date"
                                                                           class="form-control date" autocomplete="off">
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <div class="form-group">

                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.OverdueDate')</label>

                                                                    <input type="text" name="overdue_date"
                                                                           class="form-control date" autocomplete="off">
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>

                                               <!--Begin Transport Company-->
                                                @if(getTransportCompany()=="true")
                                                  <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <div class="form-group">

                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('menu.TransportCompany')</label>
                                                                        <v-select 
                                                                            v-model="selected_transportCompany"
                                                                            label="name" 
                                                                            :options="transportCompany"
                                                                            @input="getDrivers"
                                                                            @click.native="getAllDrivers"
                                                                            >
                                                                                
                                                                        </v-select>

                                                                          <input type="hidden" name="transportCompany_id"
                                                                           :value="!selected_transportCompany?null:selected_transportCompany.id">
                                                                </div>
                                                            </div>
                                                        </div>
                                                         <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                                <div class="form-group">

                                                                    <div class="col-md-12">
                                                                        <label class="control-label">@lang('layout.Driver')</label>
                                                                                            
                                                                            <v-select 
                                                                                label="name" 
                                                                                :options="t_drivers"
                                                                                
                                                                                v-model="selected_transportDriver"
                                                                                >
                                                                                    
                                                                            </v-select>
                                                                            <input type="hidden" name="trasnsport_driver_id"
                                                                               :value="!selected_transportDriver?null:selected_transportDriver.id">

                                                                            

                                                                    </div>
                                                                </div>
                                                           </div>
                                                     @endif
                                                <!--End Transport Company-->
                                                    <!-- end inputs -->
                                                </div>
                                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">

                                                    <!-- begin total -->
                                                    <div class="dashboard-stat2 ">
                                                        <table class="dashboard-tabel" width="100%">
                                                            <tr>
                                                                <td>
                                                                    <small>@lang('layout.Total') :</small>
                                                                </td>
                                                                <td class="text-right"><span data-counter="counterup"
                                                                                             data-value="7800">@{{ Number.parseFloat((subtotal - (discount*subtotal/100))-payeds).toFixed(precision())}}</span>
                                                                    <small class="font-green-sharp">
                                                                        @{{selected_currency.symbol}}
                                                                    </small>
                                                                </td>
                                                            </tr>

                                                            <tr>
                                                                <td>
                                                                    <small>@lang('layout.Discount'): (@{{
                                                                        Number.parseFloat(discount).toFixed(precision())
                                                                        }}%)
                                                                    </small>
                                                                </td>
                                                                <td class="text-right">
                               <span class="text-right" data-counter="counterup"
                                     data-value="7800">@{{ Number.parseFloat(discount*subtotal/100).toFixed(precision()) }}</span>
                                                                    <small class="font-green-sharp">
                                                                        @{{selected_currency.symbol}}
                                                                    </small>
                                                                </td>
                                                            </tr>

                                                            <tr>
                                                                <td>
                                                                    <small>@lang('layout.Payment'):</small>
                                                                </td>
                                                                <td class="text-right">
                                                                    <small class="font-green-sharp">
                                  <span class="text-right" data-counter="counterup"
                                        data-value="7800">@{{ payeds.toFixed(precision())}}</span>
                                                                        <small class="font-green-sharp">
                                                                            @{{selected_currency.symbol}}
                                                                        </small>
                                                                    </small>
                                                                </td>
                                                            </tr>


                                                            <tr>
                                                                <td>
                                                                    <small>@lang('layout.Sub-Total'):</small>
                                                                </td>
                                                                <td class="text-right">
                              <span class="text-right" data-counter="counterup"
                                    data-value="7800">@{{ subtotal.toFixed(precision())}}</span>
                                                                    <small class="font-green-sharp">
                                                                        @{{selected_currency.symbol}}
                                                                    </small>
                                                                </td>
                                                            </tr>


                                                        </table>

                                                    </div>

                                                    <!-- end total -->
                                                </div>

                                            </div>

                                            <div class="row" v-if="inventories.length>0" style="overflow-x: scroll;">
                                                <table id="table_content" class="table table-bordered table-advance">
                                                    <thead>
                                                    <tr>
                                                        <th>#</th>
                                                        <th style="min-width: {{itemFieldWidth()}}px">@lang('layout.ItemName') </th>
                                                        <th style="min-width: 100px">@lang('layout.SiteName') </th>
                                                    <!-- th class="purchase_description">@lang('layout.Description') </th -->
                                                        <th style="min-width: 100px">@lang('layout.Code') </th>
                                                        <th style="min-width: 100px">@lang('layout.Quantity') </th>
                                                        <th v-if='selected_sale_order != null'
                                                            style="min-width: 50px">@lang('layout.QtyOrder') </th>
                                                        <th style="min-width: 50px">@lang('layout.Weight') </th>
                                                        <th style="min-width: 50px">@lang('layout.OnHand') </th>
                                                    <!-- th class="other_measure" style="min-width: 100px">@lang('layout.OMeasureValue') </th -->
                                                        <th style="min-width: 100px">@lang('layout.Measure') </th>
                                                        @if(getM2()!="")    
                                                        <th style="min-width: 100px">@lang('layout.Measure2') </th>
                                                        @endif
                                                        @if(getM3()!="")    
                                                        <th style="min-width: 100px">@lang('layout.Measure3') </th>
                                                        @endif
                                                        @if(getM4()!="")    
                                                        <th style="min-width: 100px">@lang('layout.Measure4') </th>
                                                        @endif
                                                        <th v-show="seeCost==true" style="min-width: 20px">@lang('layout.Cost')</th>
                                                        <th style="min-width: 100px">@lang('layout.NewCost') </th>
                                                        <th style="min-width: 50px">@lang('layout.Wing') </th>
                                                        <th style="min-width: 100px">@lang('layout.Total') </th>
                                                        <th></th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <tr v-for="(item,index) in inventories">
                                                        <td>@{{index+1}}</td>
                                                        <td class="highlight">
                                                            <!-- @click.native="addNew('inventory',index)" -->
                                                            <v-select label="name" v-model="item.item"
                                                                      :options="temp_items" @input="onItemSearchCodeSelect(index)" @search="onItemSearch"
                                                                      @click.native="addNew('inventory',index)"></v-select>
                                                            <input type="hidden" id="item_id"
                                                                   :name="'inventory_id['+index+']'"
                                                                   :value="(!item.item)?null:item.item.id">
                                                            <input type="hidden"
                                                                   :value="(!item.item)?null:item.item.sale_order_detail_id"
                                                                   :name="'sale_order_detail_id['+index+']'">
                                                        </td>
                                                        <td class="highlight">
                                                            <select v-model="(item.item==null)?null:item.item.site" @input="onItemSearchCodeSelect(index)"
                                                                    class="form-control">
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(item.item != null)">
																  <option v-for="site in (item.item==null)?null:item.item.site_list"
																		  :value="site">
																	@{{site.site_name}}
																  </option> 
																</span>
                                                            </select>

                                                            <input type="hidden" id="inventory_site"
                                                                   :name="'inventory_site['+index+']'"
                                                                   :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.site_id)">
                                                        </td>

                                                        <td class="highlight">
                                                            <v-select label="name" @click.native="addIndex(index)" @input="addIndex(index)" 
                                                                      v-model="(item.item==null)?null:item.item.code"
                                                                      :options="subItemes" @search="onItemSearchCode"
                                                                      placeholder="@lang('layout.Code')"
                                                                      style=""></v-select>
                                                            <input type="hidden" :name="'cost_roll['+index+']'"
                                                                   :value="(item.item==null)?null:((item.item.code==null)?null:item.item.code.per_price)">
                                                            <input type="hidden" :name="'cost['+index+']'"
                                                                   :value="(item.item==null)?null:((item.item.code==null)?null:item.item.code.cost)">
                                                            <input type="hidden" :name="'m_stocks_in_id['+index+']'"
                                                                   :value="(item.item==null)?null:((item.item.code==null)?null:item.item.code.id)">
                                                            <input type="hidden" :name="'main_stock_id['+index+']'"
                                                                   :value="(item.item==null)?null:((item.item.code==null)?null:item.item.code.main_stock_id)">
                                                        </td>

                                                    <!-- td class="purchase_description">
                                     <input type="text" placeholder="@lang('layout.Description')" name="inventory_description" class="form-control">
                                  </td -->
                                                        <td>
                                                            <input type="number" :name="'inventory_quantity['+index+']'"
                                                                   ref="qut_temp" @input="setNewRate('inventory',index)"
                                                                   :value="(item.item==null)?null:((item.item.code==null)?null:item.item.code.qut_temp)"
                                                                   class="form-control input-style input-number"
                                                                   placeholder="@lang('layout.Quantity')">

                                                        </td>

                                                        <td v-if='selected_sale_order != null'>
                                                            @{{myRound((item.item==null)?null:((item.item==null)?null:item.item.quantity_temp))}}
                                                        </td>

                                                        <td>
                                                            @{{myRound((item.item==null)?null:((item.item.code==null)?null:item.item.code.OnHand))}}
                                                        </td>

                                                        <td>
                                                            @{{myRound((item.item==null)?null:saleItemQuantity(item.item,item.item.quantity))}}
                                                        </td>
                                                    <!-- td class="other_measure">
                                     <input type="number" name="other_measure_amount"  class="form-control input-style input-number"  placeholder="@lang('layout.OMeasureValue')">
                                  </td -->
                                                        <td class="highlight">
                                                            <select v-model="(item.item == null)?null:item.item.measure"
                                                                    class="form-control" @change="measureChange(index)">
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(item.item ==null)?false:true">
																	  <option v-for="measure in (item.item==null)?null:item.item.measure_list"
																			  :value="measure">
																	  @{{measure.measure_name}}
																	</option> 
																  </span>
                                                            </select>

                                                            <input type="hidden" :name="'inventory_measure['+index+']'"
                                                                   :value="(item.item==null)?null:item.item.measure.measure_id">
                                                        </td>

                                                    @if(getM2()!="")      
                                                        <td>


                                                              <select  name="measure1[]" class="form-control" v-model="(item.item==null)?null:item.item.measure1.measure_id">
                                                                  <option value="null">@lang('layout.Select')</option>
                                                                  <span v-if="(item.item ==null)?false:true">
                                                                      <option  v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure.measure_id">
                                                                      @{{measure.measure_name}}
                                                                    </option> 
                                                                  </span>
                                                              </select>
                                                          </td>
                                                        @endif
                                                        @if(getM3()!="")      
                                                          <td>
                                                              <select name="measure2[]" class="form-control" v-model="(item.item==null)?null:item.item.measure2.measure_id">
                                                                  <option value="null">@lang('layout.Select')</option>
                                                                  <span v-if="(item.item ==null)?false:true">
                                                                      <option  v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure.measure_id">
                                                                      @{{measure.measure_name}}
                                                                    </option> 
                                                                  </span>
                                                              </select>
                                                          </td>
                                                        @endif
                                                        @if(getM4()!="")    
                                                          <td>
                                                              <select name="measure3[]" class="form-control" v-model="(item.item==null)?null:item.item.measure3.measure_id">
                                                                  <option value="null">@lang('layout.Select')</option>
                                                                  <span v-if="(item.item ==null)?false:true">
                                                                      <option  v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure.measure_id">
                                                                      @{{measure.measure_name}}
                                                                    </option> 
                                                                  </span>
                                                              </select>
                                                          </td>
                                                        @endif
														
														<td v-show="seeCost==true">
                                                            <div class="input-group">
                                                                <input type="number" placeholder="@lang('layout.Price')"
                                                                       v-bind:value="(item.item==null)?null: myRound((item.item.cost * item.item.measure.measure_unit / item.item.measure_unit)*selected_currency.rate)"
                                                                       class="form-control" disabled="disabled">
                                                                <span class="input-group-addon">
                                                                    @{{selected_currency.symbol}}
                                                                </span>
                                                            </div>
                                                        </td>

                                                        <td>
                                                            <div class="input-group">
                                                                <input type="number"
                                                                       :name="'inventory_price['+index+']'"
                                                                       placeholder="@lang('layout.Price')"
                                                                       v-bind:value="(item.item==null)?null:saleNewRate(item.item,selected_currency.rate)"
                                                                       ref="in" @input="setNewRate('inventory',index)"
                                                                       class="form-control">
                                                                 <span class="input-group-addon">
																	@{{selected_currency.symbol}}
																  </span>
																  
                                                            </div>
                                                            <span v-show="((item.item==null)?null:checkCheapCode(item.item,selected_currency.rate))==true" class="required">@lang('layout.SalesToTheDetriment')</span>
                                                        </td>
                                                        <td>
                                                            <input :name="'khada['+index+']'" type="number"
                                                                   :value="(item.item==null)?null:((item.item.code==null)?null:item.item.code.khada)"
                                                                   ref="khada" @input="setNewRate('inventory',index)"
                                                                   class="form-control"
                                                                   placeholder="@lang('layout.Wing')">
                                                        </td>
                                                        <td>
                                                            <div class="input-group">
                                                                <input type="number" class="form-control inner_input"
                                                                       :value="(item.item==null)?null: myRound((item.item.code==null)?null:item.item.code.qut_temp * selected_currency.rate * item.item.new_rate)"
                                                                       placeholder="@lang('layout.Total')" disabled>
                                                                <span class="input-group-addon">
																	<b>@{{selected_currency.symbol}}</b>
																</span>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <span v-if="inventories.length>1"
                                                                  v-on:click="deleteItem('inventory',index)"><i
                                                                        class="paddint-both glyphicon glyphicon-trash"></i></span>

                                                        </td>
                                                    </tr>

                                                    <!--tr><td></td><td style="padding: 0px;"><li class="list-group-item bg-green bg-font-green"> @lang('layout.Roll') </li></td></tr -->

                                                    <!--/row-->
                                                    <!-- tr v-if="inventories[0].item !=null" v-for="(service,index) in ItemRoll">
						
								<td>@{{index+1}}</td>
								<td colspan="2">
									<v-select label="name" v-model="service.selected_sub_item" :options="subItems" @search="onItemSearchCode" @click.native="addNew_roll(index)" placeholder="@lang('layout.Code')" style=""></v-select>
									<input type="hidden" name="sub_item[]" :value="(!service.selected_sub_item)?null:service.selected_sub_item.id">
									<input type="hidden" name="m_stocks_in_id[]" :value="(!service.selected_sub_item)?null:service.selected_sub_item.id" >
									<input type="hidden" name="main_stock_id[]" :value="(!service.selected_sub_item)?null:service.selected_sub_item.main_stock_id" >
								</td>
								<td>
										<input name="qut_out[]" ref="OnHand" type="number"  @input="change_qut(index)"  class="form-control" placeholder="@lang('layout.Quantity')"   >
								</td>
								<td>
										<input name="lengths[]" ref="lengths" type="number" @input="change_lengths(index)" :value="(!service.selected_sub_item)?null:service.selected_sub_item.lengths" class="form-control" placeholder="@lang('layout.Length')" >
								 </td>
								
								<td>
										<input type="number"  name="" :value="(!service.selected_sub_item)?null:service.selected_sub_item.qut_temp * inventories[0].item.measure_unit/inventories[0].item.measure.measure_unit" disabled  placeholder="@lang('layout.OnHand')" class = 'form-control' >
								</td>
								<td>
										<input name="widths[]" type="number" readonly :value="(!service.selected_sub_item)?null:service.selected_sub_item.widths" class="form-control" placeholder="@lang('layout.Width')" >
							   </td>
								
								<td>
									<input name="cost[]" type="hidden" readonly :value="(!service.selected_sub_item)?null:service.selected_sub_item.cost" class="form-control" placeholder="@lang('layout.Cost')" >
									<input name="cost_roll[]" type="hidden" :value="(!service.selected_sub_item)?null:service.selected_sub_item.per_price" ref="per_price" @input="change_lengths(index)" class="form-control" placeholder="@lang('layout.Price')" >
									<div class="input-group">
									<input type="number"  placeholder="@lang('layout.Total')"   v-bind:value="(!service.selected_sub_item)?null:getItemTotalRoll(service.selected_sub_item.OnHand)" class="form-control">
                                      <span class="input-group-addon" >
                                            <b>@{{selected_currency.symbol}}</b>
                                        </span>
                                      </div>
								</td>
								<td>
									 <span  v-if="index != 0" v-on:click="deleteItem_roll(index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
								</td>
								
							</tr -->
                                                    </tbody>
                                                </table>

                                                <hr>
                                                <!-- begin service -->
                                                <table id="table_content"
                                                       class="table table-striped table-bordered table-advance table-hover">
                                                    <thead>
                                                    <tr>
                                                        <th class="text-center" style="min-width: 8px;"> #</th>
                                                        <th class="text-center"
                                                            style="min-width: 160px;">@lang('layout.ServiceName')</th>
                                                        <th class="text-center"
                                                            style="min-width: 160px;">@lang('layout.Quantity')</th>
                                                        <th class="text-center"
                                                            style="min-width: 160px;">@lang('layout.Measure')</th>
                                                        <th class="text-center"
                                                            style="min-width: 160px;">@lang('layout.Price')</th>

                                                        <th class="text-center"
                                                            style="min-width: 120px;">@lang('layout.Total')</th>
                                                        <th></th>

                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <tr v-for="(service,index) in services">
                                                        <td>@{{index+1}}</td>
                                                        <td class="highlight">
                                                            <v-select label="name" v-model="service.item"
                                                                      :options="(service.items)"
                                                                      @click.native="addNew('service',index)"
                                                                      @input="checkExistingService(index)">

                                                            </v-select>
                                                            <input type="hidden" name="service_id[]"
                                                                   :value="(service.item==null)?null:service.item.id">
                                                        </td>

                                                        <td>
                                                            <input class="form-control" name="service_quantity[]"
                                                                   v-model.number="(!service.item)?null:service.item.quantity"
                                                                   placeholder="@lang('layout.Quantity')">
                                                        </td>
                                                        <td class="highlight">
                                                            <select v-model="(service.item == null)?null:service.item.measure"
                                                                    class="form-control"
                                                                    @change="measureChangeservice(index)">
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(service.item ==null)?false:true">
                                              <option v-for="measure in (service.item==null)?null:service.item.measure_list"
                                                      :value="measure">
                                              @{{measure.measure_name}}
                                            </option> 
                                          </span>

                                                            </select>

                                                            <input type="hidden" name="service_measure[]"
                                                                   :value="(service.item==null)?null:service.item.measure.measure_id">
                                                        </td>
                                                        <td>
                                                            <div class="input-group">
                                                                <input type="number" name="service_price[]"
                                                                       placeholder="@lang('layout.Price')"
                                                                       :value="(service.item==null)?null:saleNewRate(service.item,selected_currency.rate)"
                                                                       ref="ser" @input="setNewRate('service',index)"
                                                                       class="form-control">


                                                                <span class="input-group-addon">
                                          @{{selected_currency.symbol}}
                                        </span>
                                                            </div>

                                                        </td>
                                                        <td>
                                                            <div class="input-group">
                                                                <input type="number" class="form-control inner_input"
                                                                       :value="(service.item==null)?null:getItemTotalService(service.item,selected_currency.rate).result"
                                                                       placeholder="@lang('layout.Total')" disabled>
                                                                <span class="input-group-addon">
                                            <b>@{{selected_currency.symbol}}</b>
                                        </span>
                                                            </div>


                                                        </td>
                                                        <td>
                                                            <span v-on:click="deleteItem('service',index)"><i
                                                                        class="paddint-both glyphicon glyphicon-trash"></i></span>
                                                        </td>
                                                    </tr>
                                                    </tbody>
                                                </table>
                                                <!-- end service -->
                                                <hr>
                                                <!-- begin payments -->
                                                <table id="table_content"
                                                       class="table table-striped table-bordered table-advance table-hover">
                                                    <thead>
                                                    <tr>
                                                        <th class="text-center" style="min-width: 8px;"> #</th>
                                                        <th class="text-center"
                                                            style="min-width: 160px;">@lang('layout.SelectBank')</th>
                                                        <th class="text-center"
                                                            style="min-width: 100px;"> @lang('layout.Amount')</th>
                                                        <th class="text-center"
                                                            style="min-width: 120px;"> @lang('layout.Rate')</th>
                                                        <th class="text-center"
                                                            style="min-width: 80px;">@lang('layout.Currency')</th>
                                                        <th class="text-center"
                                                            style="min-width: 80px;"> @lang('layout.Amount')</th>
                                                        <th class="text-center"
                                                            style="min-width: 120px;">@lang('layout.Total')</th>
                                                        <th></th>

                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <tr v-for="(payment,index) in payments">
                                                        <td>@{{index+1}}</td>
                                                        <td class="highlight">
                                                            <v-select label="name" v-model="payment.item"
                                                                      :options="(payment.items)"
                                                                      @click.native="addNew('payment',index)"
                                                                      @input="checkExistingPayment(index)">

                                                            </v-select>
                                                            <input type="hidden" name="payment_id[]"
                                                                   :value="(payment.item==null)?null:payment.item.id">
                                                        </td>

                                                        <td>
                                 
                                      <span v-if="payment.item !=null">
                                        @{{myRound(Number((payment.item==null)?null:payment.item.balance)+Number((payment.item==null)?null:payment.item.amount))}}
                                      </span>
                                                        </td>
                                                        <td>
                                                            <input v-bind:disabled="(payment.item==null)?false:(payment.item.code =='{{getHomeCurrency()["code"]}}')"
                                                                   type="number"
                                                                   v-model.number="(payment.item==null)?null:payment.item.rate "
                                                                   class="form-control"
                                                                   placeholder="@lang('layout.Rate')"/>
                                                            <input v-if="payment.item !=null" type="hidden"
                                                                   name="payment_rate[]"
                                                                   v-bind:value="payment.item.rate">
                                                        </td>
                                                        <td>
                                                            <input type="text" name="payment_currency[]"
                                                                   class="form-control"
                                                                   v-model="(payment.item==null)?null:payment.item.code"
                                                                   placeholder="@lang('layout.Currency')" disabled
                                                                   reqiured/>

                                                            <input v-if="payment.item !==null" type="hidden"
                                                                   name="payment_currency[]"
                                                                   v-bind:value="payment.item.code"/>
                                                        </td>
                                                        <td>
                                                            <div class="input-group">
                                                                <input type="number" class="form-control"
                                                                       v-model.number="(payment.item==null)?null:payment.item.amount "
                                                                       placeholder="@lang('layout.PayAmount')"/>

                                                                <input v-if="payment.item !=null" type="hidden"
                                                                       name="payment_amount[]"
                                                                       v-bind:value="payment.item.amount">

                                                                <span class="input-group-addon">@{{(payment.item==null)?null:payment.item.code}}</span>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <div class="input-group">
                                                                <input type="number" class="form-control"
                                                                       :value="(payment.item==null)?null:totalPayments(payment.item,selected_currency.rate)"
                                                                       placeholder="@lang('layout.Total')"
                                                                       style="min-width: 100px"/>
                                                                <span class="input-group-addon">@{{selected_currency.symbol}}</span>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <span v-on:click="deleteItem('payment',index)"><i
                                                                        class="paddint-both glyphicon glyphicon-trash"></i></span>
                                                        </td>
                                                    </tr>
                                                    </tbody>

                                                </table>
                                                <!-- end payments -->
                                            </div>


                                        </div>
                                        <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                                            <button type="button" v-if="!isError" @click="handleSubmit($event)"
                                                    class="btn green">@lang('layout.Submit')</button>
                                            <a href="{{route('inventorySite.index')}}" class="btn default"><i
                                                        class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>

                                        </div>
                                        <cmodal :show='showModal' @close="showModal=false">

                                        </cmodal>
                                    </div>


                                </div>


                                {!! Form::close() !!}

                            </div>

                        </div>


                    </div>
                    <p> &nbsp; </p>
                    <p> &nbsp; </p>
                </div>
            </div>
            <!-- END TAB PORTLET-->
        </div>
    </div>

@endsection
@push('scripts')


    <script type="text/javascript">

        @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif



        Vue.component('v-select', VueSelect.VueSelect);

        Vue.component("modal", {
            template: "#modal-template",
            props: ['show'],

        });

        //begin new member
        Vue.component("cmodal", {
            template: '#cmodal-template',

            props: ['show'],
            data() {
                return {
                    types: [],
                    classes: [],
                    receivables: [],
                    payables: [],
                    code: null,
                    selectType: null,
                    selectPay: null,
                    selectedClass: null,
                    selectReceive: null,
                }
            },
            created() {

                axios.get('{{route("customer.create")}}').then(
                    response => {
                        this.types = response.data.types;
                        if (this.types) {
                            for (var i = 0; i < this.types.length; i++) {
                                if (this.types[i].type == "Customer") {
                                    this.selectType = this.types[i];
                                }
                            }
                        }
                        this.receivables = response.data.receivable;
                        this.payables = response.data.payable;
                        this.code = response.data.code;
                        this.classes = response.data.member_class;
                        if (this.receivables.length > 0) {
                            this.selectReceive = this.receivables[0];
                        }
                        if (this.payables.length > 0) {
                            this.selectPay = this.payables[0];
                        }


                    }).catch(error => console.log(error));
            },
            methods: {
                onSubmit() {

                    v.showModal = false;
                    var datas = $("#modalForm").serializeArray();

                    $.ajax({
                        headers: {'X-CSRF-TOKEN': "{{csrf_token()}}"},
                        url: '{{route("customer.store")}}',
                        method: 'post',
                        data: {
                            "name": datas[0]['value'],
                            'code': datas[1]['value'],
                            'email': datas[2]['value'],
                            'phone': datas[3]['value'],
                            'address1': datas[4]['value'],
                            'type': this.selectType.id,
                            'receivable': this.selectReceive.id,
                            'payable': this.selectPay.id,
                            'class': (this.selectedClass) ? this.selectedClass.id : null
                        },
                        dataType: 'json',

                    }).done(function (response) {
                        axios.get('{{route("invoice.create")}}').then(response => {

                            v.customer = response.data.customer;
                            document.getElementById("modalForm").reset();

                        }).catch(error => console.log(error));

                    }).fail(function (error) {
                        console.log('error', error);
                    });

                }
            }
        });

        // end new member
        var customer ={!! $customer !!};
        var currency ={!! $currency !!};
        var banks = {!! $banks !!};
        var all_services = {!! $all_services !!};
        var transportCompany = {!! $transportCompany !!};
        var allDrivers     = {!! $allDrivers !!};
        var seeCost        = {!! $seeCost !!};
        var v = new Vue({
            el: '#appInvoice',
            data: {

                showModalSaleOrder: false,
                showModal: false,
                cheap: false,
                invoiceDescription: null,
                saleOrderList: [],
                selected_sale_order: null,
                setDatas: [],
                customer: customer,
                selected_customer: null,
                member_id: null,
                banks: banks,
                all_services: all_services,
                seeCost: seeCost,
                selected_banks: null,
                currency: currency,
                selected_currency: defaultCurrency(),
                rate: 0,
                discountFiled: 0,
                selectedIndex: 0,
                discountIsAmount: false,
                temp_items: [],
                totalAmountes: [],
                types: null,
                totalCos: 0,
                newCost: [
                    null,
                    null,
                    null,
                    null],
                subItems: [],
                subItemes: [],
                ItemRoll: [
                    {
                        selected_sub_item: null,
                    },
                ],
                inventories: [
                    {item: null}
                ],
                services: [
                    {
                        items: all_services,
                        item: null,
                    },
                    {
                        items: all_services,
                        item: null,
                    },
                ],
                payments: [
                    {
                        items: all_services,
                        item: null,
                    }
                ],
                CusTypes: null,
                transportCompany: transportCompany,
                allDrivers: allDrivers,

                selected_transportCompany: null,
                selected_transportDriver: null,
                t_drivers: allDrivers
            },
            computed: {
                selectedRate() {
                    this.rate = (this.selected_currency) ? this.selected_currency.rate : 0;

                },
                discount() {
                    if (this.discountIsAmount) {

                        if (this.subtotal > 0 && this.discountFiled) {
                            return (parseFloat(this.discountFiled) * 100) / (this.subtotal);
                        } else {
                            return 0;
                        }
                    } else {

                        return this.discountFiled
                    }

                },

                // calculate subtotal
                subtotal: function () {
                    var sum = 0;
                    var sumRoll = 0;
                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].item) {
                            if (this.inventories[i].item.code != null) {

                                var quantity = this.inventories[i]['item']['code']['qut_temp'];
                                var rate = this.inventories[i]['item']['rate'];
                                var new_rate = this.inventories[i]['item']['new_rate'];
                                var smeasure_unit = this.inventories[i]['item']['measure']['measure_unit'];
                                var measure_unit = this.inventories[i]['item']['measure_unit'];
                                if (new_rate != rate && quantity > 0) {
                                    sum += new_rate * quantity * this.selected_currency.rate;
                                    sumRoll += new_rate * quantity * this.selected_currency.rate;
                                }
                                else {
                                    sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
                                    sumRoll += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
                                }

                            }
                        }

                    }
                    for (var i = 0; i < this.services.length; i++) {
                        if (this.services[i].item && this.services[i].item != null) {

                            var rate = this.services[i]['item']['rate'];
                            var new_rate = this.services[i]['item']['new_rate'];
                            var smeasure_unit = this.services[i]['item']['measure']['measure_unit'];
                            var measure_unit = this.services[i]['item']['measure_unit'];
                            var quantity = this.services[i]['item']['quantity'];
                            if (new_rate != rate && quantity > 0) {
                                sum += new_rate * quantity * this.selected_currency.rate;
                            }
                            else {
                                sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
                            }

                        }
                    }
                    this.totalCos = sumRoll;

                    return sum;
                },

                // check payed amount
                payeds: function () {
                    var sum = 0;
                    for (var i = 0; i < this.payments.length; i++) {

                        if (this.payments[i].item != null && this.payments[i].item) {
                            if (this.payments[i].item != null && this.payments[i]['item']['rate'] > 0) {
                                //
                                sum += (this.payments[i]['item']['amount'] * this.selected_currency.rate / this.payments[i]['item']['rate']);
                            }
                        }
                    }
                    return sum;
                },

                // check data validation
                isError: function () {
                    var isError = false;
                    var flag = false;
                    for (var i = 0; i < this.inventories.length; i++) {

                        if (this.inventories[i].item) {
                            flag = true;
                            // rate=this.inventories[i]['item']['rate'];
                            new_rate = this.inventories[i]['item']['new_rate'];
                            if (new_rate <= 0) {
                                isError = true;
                            }


                        }
                    }
                    if (this.selected_customer == null) {
                        isError = true;
                    }
                    return isError;


                },
            },
            methods:
                {
                    handleSubmit(e) {
                        this.$validator.validate().then(valid => {
                            if (valid) {
                                // alert(e.target);
                                //console.log(v.member_chack());
                                if (v.member_chack() == 'true') {
                                    var r = confirm("@lang('layout.member_payable_levels')");
                                    if (r == true) {
                                        v.submitForm(e.target);
                                    }
                                } else {
                                    v.submitForm(e.target);
                                }
                            }
                        });
                    },

                    // chack_member_payable_levels
                    member_chack() {
                        var chack = 'false';
                        var member_id = v.member_id;
                        if (member_id != null) {

                            var totals = Number.parseFloat((v.subtotal - (v.discount * v.subtotal / 100)) - v.payeds);
                            var currency = $("input[name=currency]").val();


                            $.ajax({
                                url: "{{route('callMethod.search')}}",
                                async: false,
                                data: {
                                    member_id: v.member_id,
                                    method_name: 'Search_member_payable_levels',
                                    currency: currency,
                                },
                                success: function (data) {
                                    var r_amount = Number.parseFloat(data.amount);
                                    var r_m_amount = Number.parseFloat(data.m_amount);
                                    var totalss = Number.parseFloat(((isNaN(r_m_amount) ? 0 : r_m_amount) + totals));
                                    //console.log(r_m_amount);
                                    //console.log('--');
                                    //console.log(totals);
                                    if (r_amount != 0 && r_amount < totalss) {
                                        chack = 'true';
                                    } else {
                                        chack = 'false';
                                    }


                                }.bind(this),

                                error: function (error) {
                                    console.log(error)
                                }
                            });
                            /*
                            axios.get("{{route('callMethod.search')}}",
				   {

					params:{
					  member_id:v.member_id,
					  method_name:'Search_member_payable_levels',
					  currency:currency,
					  
					},
				   })
				   .then(function (response)
				   {
					 
						var r_amount = response.data.amount;
						var r_m_amount = response.data.m_amount;
						if(r_amount < (r_m_amount + totals)){
							chack = 'true';
						}
				   })
				   .catch(function (error)
				   {
					  console.log(error);
				   });
			  */
                        }
                        return chack;
                    },


                    // calculte total of item or service
                    getItemTotalRoll(quantity = null) {
                        var new_rate = this.inventories[0]['item']['new_rate'];
                        var smeasure_unit = this.inventories[0]['item']['measure']['measure_unit'];
                        var measure_unit = this.inventories[0]['item']['measure_unit'];
                        var result = 0;
                        if (new_rate != null && smeasure_unit != null && measure_unit != null && quantity != null) {

                            var price = ((measure_unit * new_rate) / smeasure_unit);
                            var qty = (smeasure_unit * quantity) / measure_unit;
                            var temp = price * qty * v.selected_currency.rate;
                            result = Number.parseFloat(temp).toFixed(precision());
                        }
                        // console.log(result);
                        return result;


                    },


                    // calculate item price based on measure change
                    measureChange(index) {

                        if (this.inventories[index].item != null) {
                            var item = this.inventories[index].item;

                            var temp = ((item.rate * item.measure.measure_unit / item.measure_unit));
                            result = Number.parseFloat(temp).toFixed(precision());

                            this.inventories[index].item.new_rate = result;

                            // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;

                            if (item.code != null) {
                                item['code']['qut_temp'] = item['code']['qut_temp'] * item.measure_unit / item.measure.measure_unit;
                                item['code']['OnHand'] = item['code']['OnHand1'] * item.measure_unit / item.measure.measure_unit;
                            }
                        }
                    },

                    // calculate item price based on measure change
                    measureChangeservice(index) {

                        if (this.services[index].item != null) {
                            var item = this.services[index].item;

                            var temp = ((item.rate * item.measure.measure_unit / item.measure_unit) * this.selected_currency.rate);
                            result = Number.parseFloat(temp).toFixed(precision());

                            this.services[index].item.new_rate = result;

                            // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;

                        }
                    },
                    // detect member change and searh
                    memberChange() {
                        if (this.selected_customer) {
							v.inventories = [{item: null}],
                            v.member_id = this.selected_customer.id;
                            // get member contract
                            this.saleOrderSearch(this.selected_customer.id, this);
                        }
                    },
                    //Get Transport Company Drivers 
                    getDrivers() {
                        if (this.selected_transportCompany) {
                            axios.get("{{route('callMethod.search')}}",
                                {
                                    params: {
                                        transport_id: this.selected_transportCompany.id,
                                        method_name: 'Search_transport_company_drivers'
                                    },
                                })
                                .then(function (response) {
                                    if (response.data.result != null) {
                                        console.log('all Drivers',response.data.result);
                                        v.t_drivers=response.data.result;
                                        v.selected_transportDriver=null;
                                    }
                                    else {

                                    }
                                })
                                .catch(function (error) {
                                    console.log(error);
                                });
                        }
                    },

                     //Get Just Drivers  without Transport Company Select
                    getAllDrivers() {
                        if (!v.selected_transportCompany) {
                        v.t_drivers=v.allDrivers;
                        }
                    },


                    // sale order change
                    saleOrderChang() {
                        console.log('test 33');
                    },
                    // end sale order change
                    // set new price
                    setNewRate(type = null, index = null) {
                        if (type == 'inventory') {
                            if (this.inventories[index].item != null) {
                                this.inventories[index].item.new_rate = this.$refs.in[index].value / this.selected_currency.rate;
								
                            if (this.inventories[index].item.code != null) {
                                this.inventories[index].item.code.qut_temp = this.$refs.qut_temp[index].value;
                                this.inventories[index].item.code.khada = this.$refs.khada[index].value;
                            }
							}
							
							if(((this.inventories[index].item.cost * this.inventories[index].item.measure.measure_unit / this.inventories[index].item.measure_unit)*this.selected_currency.rate) > (this.inventories[index].item.new_rate*this.selected_currency.rate)){
								this.cheap = true;
							}else{
								this.cheap = false;
							}
							
                        }
                        if (type == 'service') {
                            if (this.services[index].item) {
                                console.log('service changed');
                                this.services[index].item.new_rate = this.$refs.ser[index].value / this.selected_currency.rate;
                            }
                        }
                    },


                    //ajax call to get items
                    onItemSearch: _.debounce((search, loading) => {
                        loading(true);
						if(v.inventories[0].item == null || !v.inventories[0].item.sale_order_detail_id){  
                        axios.get("{{route('callMethod.search')}}",
                            {

                                params: {
                                    member_id: v.member_id,
                                    method_name: 'itemSearchSaleRoll',
                                    keyword: search,
                                },
                            })
                            .then(function (response) {
                                v.temp_items = [];
                                // v.subItems = [];
                                if (response.data.length > 0) {
                                    v.temp_items = response.data;
                                    console.log('pp',response.data);
                                }
                                loading(false);
                            })
                            .catch(function (error) {
                                console.log(error);
                            });
						}else{
                                    console.log('test check', v.selected_sale_order);
							
							axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'SaleOrderItemsRoll',
                                sale_order_id: v.selected_sale_order.id,
                                type: 'saleOrder'
                            }
                        })
                            .then(function (response) {
                                if (response.data.length > 0) {
									v.temp_items = [];
									v.temp_items = response.data;
									
                                    // v.inventories = [];
                                    // for (var r = 0; r < response.data.length; r++) {
                                        // v.inventories.push({item: response.data[r]});
                                    // }
                                    // v.inventories.push({item: null});
                                    console.log('test check', v.inventories);
                                    v.invoiceDescription = v.selected_sale_order.description;
									loading(false);
                                }

                            })
                            .catch(function (error) {
                                console.log(error);
                            })
							
							
						}	

                    }, getDebounceTime()),

                    // end item search

                    // contract search


                    saleOrderSearch(id, vm) {
                        vm.saleOrderList = [];
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'memberSaleOrderRoll',
                                member_id: id,
                            }
                        })
                            .then(function (response) {
                                if (response.data.length > 0) {
                                    vm.showModalSaleOrder = true;
                                    vm.saleOrderList = response.data;
                                }
                                loading(false);
                            })
                            .catch(function (error) {
                                console.log(error);
                            })
                    },
                    getsalesOrders() {
                        this.showModalSaleOrder = false;
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'SaleOrderItemsRoll',
                                sale_order_id: this.selected_sale_order.id,
                                type: 'saleOrder'
                            }
                        })
                            .then(function (response) {
                                if (response.data.length > 0) {
                                    v.inventories = [];
                                    for (var r = 0; r < response.data.length; r++) {
                                        v.inventories.push({item: response.data[r]});
                                    }
                                    v.inventories.push({item: null});
                                    console.log('test check', v.inventories);
                                    v.invoiceDescription = v.selected_sale_order.description;

                                }

                            })
                            .catch(function (error) {
                                console.log(error);
                            })
                    },
                    // end contract search

                    //ajax call to get items code
                    onItemSearchCode: _.debounce((search, loading) => {

                        // console.log('selectedIndex',v.selectedIndex);
                        item_id = v.inventories[v.selectedIndex].item.id;
                        inventory_site = v.inventories[v.selectedIndex].item.site.site_id;
                        loading(true);
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'getAssebmliesSubSite',
                                keyword: search,
                                item_id: item_id,
                                inventory_site: inventory_site,
                            }
                        })
                            .then(function (response) {
                                // v.subItems = [];
                                if (response.data.length > 0) {
									v.subItems[v.selectedIndex] = response.data;
                                    v.subItemes = response.data;
                                    console.log('subItems', v.subItems);
                                }
                                loading(false);
                            })
                            .catch(function (error) {
                                console.log(error);
                            });
                    }, getDebounceTime()),
					
                    //ajax call to get items code
                    onItemSearchCodeSelect(selectedIndex) {
						v.selectedIndex = selectedIndex;
						setTimeout(function(){
						if(v.inventories[selectedIndex].item != null){
						
                        item_id = v.inventories[selectedIndex].item.id;
                        inventory_site = v.inventories[selectedIndex].item.site.site_id;
                        // console.log('selectedIndex',selectedIndex,item_id,inventory_site);
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'getAssebmliesSubSite',
                                item_id: item_id,
                                inventory_site: inventory_site,
                            }
                        })
                            .then(function (response) {
                                // v.subItems = [];
                                if (response.data.length > 0) {
									v.subItems[selectedIndex] = response.data;
                                    v.subItemes = response.data;
									v.inventories[selectedIndex].item.code=null;
									
                                    // v.subItems = response.data;
                                    console.log('subItemss', v.subItems);
                                }
                            })
                            .catch(function (error) {
                                console.log(error);
                            });
							
						}
						}, 400);
                    },

                    // generic function for adding item to list
                    addNew(type = null, index) {
						v.selectedIndex = index;
                        this.temp_items = [];
                        if (type != null) {
                            if (type == 'inventory') {
                                if (this.inventories[index + 1] == undefined) {
                                    this.temp_items = [];
                                    this.inventories.push({item: null});
                                }
                            }
                            if (type == 'service') {
                                if (this.services[index + 1] == undefined) {
                                    this.checkExistingService(index, '');
                                    this.services.push({
                                        items: this.all_services,
                                        item: null,
                                    });
                                }
                            }
                            if (type == 'payment') {
                                if (this.payments[index + 1] == undefined) {
                                    this.checkExistingPayment(index, '');
                                    this.payments.push({
                                        items: this.banks,
                                        item: null,
                                    });
                                }
                            }
                        }

                    },

                    // in here you can check and decide to allow duplicate bank for payment or not
                    checkExistingPayment(index = null, name = '') {
                        var bank_temp = this.banks.slice();
                        var bank_temp1 = [];
                        for (var i = 0; i < this.payments.length; i++) {
                            if (this.payments[i].item != null) {
                                var fined = bank_temp.findIndex((item) => item.name == this.payments[i].item.name);
                                if (fined != -1) {
                                    var o = bank_temp.splice(bank_temp.findIndex((item) => item.name == this.payments[i].item.name), 1);
                                }
                            }
                        }
                        this.payments[index].items = bank_temp.filter((item) => {
                            return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                        });
                        //this.payments[index].items =bank_temp;


                    },

                    // in here you can check and decide to allow duplicate service or not
                    checkExistingService(index = null, name = '') {
                        var service_temp = this.all_services.slice();
                        var service_temp1 = [];
                        for (var i = 0; i < this.services.length; i++) {
                            if (this.services[i].item != null) {
                                var fined = service_temp.findIndex((item) => item.name == this.services[i].item.name);
                                if (fined != -1) {
                                    var o = service_temp.splice(service_temp.findIndex((item) => item.name == this.services[i].item.name), 1);
                                }
                            }
                        }
                        this.services[index].items = service_temp.filter((item) => {
                            return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                        });
                        //this.payments[index].items =bank_temp;


                    },
                    // delete item from list
                    deleteItem(type = null, index) {
                        if (type != null) {
                            console.log(type);
                            if (type == 'inventory') {
                                this.inventories.splice(index, 1);
                            }
                            if (type == 'service') {
                                this.services.splice(index, 1);
                            }
                            if (type == 'payment') {
                                this.payments.splice(index, 1);
                            }
                        }

                    },


                    change_lengths(index) {
                        if (this.ItemRoll[index].selected_sub_item) {
                            var per_qut_in = this.ItemRoll[index].selected_sub_item.per_qut_in;
                            var lengths = this.$refs.lengths[index].value;
                            this.ItemRoll[index].selected_sub_item.lengths = this.$refs.lengths[index].value;
                            this.ItemRoll[index].selected_sub_item.OnHand = (per_qut_in * lengths).toFixed(1);
                            this.ItemRoll[index].selected_sub_item.per_price = this.$refs.per_price[index].value;
                        }
                        setTimeout(function () {
                            v.deleteItem_roll(100);
                        }, 30);
                    },
                    change_qut(index) {

                        if (this.ItemRoll[index].selected_sub_item) {
                            var per_qut_in = this.ItemRoll[index].selected_sub_item.per_qut_in;
                            var OnHand = this.$refs.OnHand[index].value;
                            this.ItemRoll[index].selected_sub_item.OnHand = this.$refs.OnHand[index].value;
                            this.ItemRoll[index].selected_sub_item.lengths = (OnHand / per_qut_in).toFixed(1);
                            this.ItemRoll[index].selected_sub_item.per_price = this.$refs.per_price[index].value;
                        }

                        setTimeout(function () {
                            v.deleteItem_roll(100);
                        }, 30);
                    },

                    // generic function for adding item to list
                    // addNew_roll(index) {
                        // v.subItems = [];
                        // if (this.ItemRoll[index + 1] == undefined) {
                            // this.ItemRoll.push({
                                // selected_sub_item: null,
                            // });
                        // }


                    // },
                    // delete item from list
                    deleteItem_roll(index) {
                        this.ItemRoll.splice(index, 1);

                    },

                    // delete item from list
                    addIndex(index) {
                        v.subItemes=[];
                        v.selectedIndex = index;
						v.subItemes=this.subItems[index];
                    },

                    // submit the form
                    submitForm() {

                        if (this.isError == true) {
                            alert('there is no item');
                            return false;
                        }
                        swal({
                            title: "@lang('layout.AreYouSure?')",
                            buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                            text: "",
                            icon: "info",
                            dangerMode: true,
                        }).then((willDelete) => {
                            if (willDelete) {
                                document.getElementById("sales-form").submit()

                            }
                            else {

                            }
                        });

                    },
                },


        });

    </script>



@endpush