@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
<link href="{{URL::asset('assets/global/plugins/bootstrap-timepicker/css/bootstrap-timepicker.min.css')}}" rel="stylesheet" type="text/css" />
@section('style')
<style>
    .modal-container {
        width: 50%;
    }
</style>
@stop
@section('content')
@include("layouts.Cmodal")
@include("invoices.modal")
<div class="row">
    <div class="portlet light bordered">
        <!-- BEGIN TAB PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-anchor font-green-sharp"></i>
                    <span class="caption-subject font-green-sharp bold uppercase">@lang('layout.CreateNewInvoice')</span>
                </div>
                <div class="actions">
                </div>
            </div>
            <div id="appInvoice" class="portlet-body" v-cloak>
                <div id="measure">
                    <modal v-if="showInfoModal" @close="showInfoModal = false">
                        <div slot="body">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="row col-md-12">
                                        <h4 class=" col-md-3">
                                            @lang('menu.InventoryBrand') :</h4>
                                        <h4 class="col-md-8">
                                            @{{ brand }}
                                        </h4>
                                    </div>
                                    <div class="row col-md-12">
                                        <h4 class=" col-md-3">
                                            @lang('layout.Location') :</h4>
                                        <h4 class="col-md-8">
                                            @{{ location }}
                                        </h4>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="row col-md-12">
                                        <h4 class=" col-md-3">
                                            @lang('layout.Cost') :</h4>
                                        <h4 class="col-md-8">
                                            @{{ cost }}
                                        </h4>
                                    </div>
                                    <div class="row col-md-12">
                                        <h4 class=" col-md-3">
                                            @lang('layout.SerialNum') :</h4>
                                        <h4 class="col-md-8">
                                            @{{ SNumber }}
                                        </h4>
                                    </div>
                                </div>
                            </div>
                            @if(ShowLastSale()=="true")
                            <div class="row" v-if="last_item_sale != null && last_item_sale != ''">
                                <div class="col-md-12">
                                    <h3> @lang('layout.ShowLastSales') </h3>
                                    <table class="table table-striped table-bordered table-hover">
                                        <thead>
                                            <tr>
                                                <th>@lang('layout.CustomerName')</th>
                                                <th>@lang('layout.Measure')</th>
                                                <th>@lang('layout.Price')</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr v-for="(last_it,index) in last_item_sale">
                                                <td>@{{last_it.member}}</td>
                                                <td>@{{last_it.Measure}}</td>
                                                <td>@{{last_it.price}}  @{{last_it.currency}}</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            @endif

                        </div>
                        <h3 slot="header">
                            <div class="col-md-4">
                                <h3>
                                    @lang('layout.OtherInformations') @lang('layout.Item')
                                </h3>
                            </div>
                        </h3>
                        <div slot="footer">
                            <button type=button class="modal-default-button" v-on:click="showInfoModal = false ,measure = null , type=null">
                                @lang('layout.Cancel')
                            </button>
                        </div>
                    </modal>
                </div>
                <div class="tabbable tabbable-tabdrop">
                    <div>
                        {{Form::open(['route' => 'invoice_roll.store','method' => 'POST','class' => 'form-horizontal','id'=>'sales-form','files'=> true])}}
                        {{ csrf_field() }}
                        <div class="tab-content">
                            <div class="tab-pane active" id="tab1">
                                <div v-cloak class="portlet-body form" style="margin-bottom:50%;">
                                    <!-- begin sale order modal -->
                                    <div id="salOrderApp" v-cloak>
                                        <!-- {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}} -->
                                        <input type="hidden" name="type" value="invoicelist" />
                                        <!-- use the modal component, pass in the prop -->
                                        <modal v-if="showModalSaleOrder" @close="showModalSaleOrder = false">
                                            <div slot="body">
                                                <div class="row">
                                                    <div class="form-group">

                                                        <div class="col-md-12">
                                                            <label class="control-label ">@lang('layout.Select') </label>
                                                            <select class="form-control" style="border: 1px solid black !important" v-model="selected_sale_order" @input="saleOrderChang()">
                                                                <option v-for="order in saleOrderList" :value="order">
                                                                    <span>
                                                                        @{{order.type+':'+order.number+' '+order.description}}
                                                                    </span>
                                                                </option>
                                                            </select>
                                                        </div>


                                                    </div>
                                                </div>
                                                
                                               

                                                <div class="row">

                                                    <div class="form-group">
                                                        <div class="col-md-6">
                                                            <label class="control-label ">@lang('layout.Currency') </label>
                                                            <input type="text" name="" :value="(!selected_sale_order)?null:selected_sale_order.currency" class="form-control" disabled="disabled">
                                                        </div>
                                                        <div class="col-md-6">
                                                            <label class="control-label ">@lang('layout.Rate') </label>
                                                            <input type="text" name="" :value="(!selected_sale_order)?null:selected_sale_order.rate" class="form-control" disabled="disabled">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    
                                                    



                                                    <div class="form-group"> 
                                                        <div class="col-md-6">
                                                            <label class="control-label ">@lang('layout.Date') </label>
                                                            <input type="text" name="" :value="(!selected_sale_order)?null:selected_sale_order.date" class="form-control" disabled="disabled">
                                                        </div>
                                                        <div class="col-md-6">
                                                            <label class="control-label ">@lang('layout.DeliveryDate') </label>
                                                            <input type="text" name="" :value="(!selected_sale_order)?null:selected_sale_order.delivery_date" class="form-control" disabled="disabled">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="form-group"> 
                                                        <div class="col-md-12">
                                                            <label class="control-label ">@lang('layout.Description') </label>
                                                            <input type="text" name="" :value="(!selected_sale_order)?null:selected_sale_order.description" class="form-control" disabled="disabled">
                                                        </div>

                                                    </div>
                                                </div>
                                                <br>
                                              


                                            </div> 
                                            <div slot="footer">
                                                <button type="button" v-if="selected_sale_order" @click="getsalesOrders" class="btn btn-success">
                                                    @lang('layout.Submit')
                                                </button>
                                                <button type="button" class="btn btn-danger" v-on:click="showModalSaleOrder=false">
                                                    @lang('layout.Cancel')
                                                </button>
                                            </div>
                                        </modal>
                                        <!-- {{Form::close()}} -->
                                    </div>
                                    <!-- end sale order modal -->
                                    <!-- BEGIN FORM-->
                                    <div class="form-body">
                                        <input type="hidden" name="temp_type" value="invoiceRoll">
                                        <div class="row">
                                            <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px; padding: 20px !important;">
                                                <div class="row">
                                                    <div v-show="showWhat('sale_area')=='yes'" class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                        <div class="form-group">
                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.SaleArea')</label>
                                                                <v-select label="name" :options="saleArea" v-model="selected_area"></v-select>
                                                                <input type="hidden" name="sale_area_id" :value="!selected_area?null:selected_area.id">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div v-show="showWhat('member_class')=='yes'" class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                        <div class="form-group">
                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.MemberClass') </label>
                                                                <v-select label="name" :options="memberClass" v-model="selected_class" @input="memberClassChange()"></v-select>
                                                                <input type="hidden" name="class_id" :value="!selected_class?null:selected_class.id">
                                                            </div>
                                                        </div>
                                                    </div> 
                                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                        <div class="form-group">
                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.Customer')</label>
                                                                <div class="input-group">
                                                                    <v-select label="name" @input="memberChange(),getSummary()" @search="MemberSearch" :options="customer" v-model="selected_customer"></v-select>
                                                                    <input type="hidden" name="customer" v-validate="'required'" data-vv-as="@lang('layout.Customer')" :value="!selected_customer?null:selected_customer.id" required>
                                                                    <span class="btn btn-success input-group-addon " title="@lang('button.AddNewCustomer')" @click="showModal = true" style="background-color:  rgb(84, 199, 211)">
                                                                        <i class="fa fa-plus" style="color: white"></i>
                                                                    </span> 
                                                                </div>
                                                                <span class="required">@{{ errors.first('customer') }}</span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div v-show="showWhat('descriptionASMemberName')=='yes'" class="col-lg-4 col-md-4 col-sm-4 col-xs-12">
                                                        <div class="form-group">
                                                            <div class="col-md-12">
                                                                <label class=" control-label">@lang('layout.OtherMemberName')</label>
                                                                <div>
                                                                    <input type="text" name="other_member_name" v-model="other_member_name" class="form-control">
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                        <div class="form-group"> 
                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.InvoiceNumber')</label> 
                                                                <input type="number" name="number" v-validate="'required|numeric'" data-vv-as="@lang('layout.InvoiceNumber')" @input="checkNo()" v-model="number" class="form-control">
                                                                <span class="required">@{{ errors.first('number') }}</span>
                                                                <span v-if="number_Error ==true" class="input-has-error" style="color: red">@{{number_msg}}</span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-2 @if(!getCustomeForm('invoiceRoll','referenceNumber')) displayNone @endif">
                                                        <div class="form-group">
                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.ReferenceNumber')</label>
                                                                <input type="text" name="ref_no" v-model="ref_no" class="form-control" @input="checkRefNo()">
                                                                <span v-if="isError1 ==true" class="input-has-error" style="color: red">@{{msg}}</span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    @if(getSaleCommission()=="true")
                                                    <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12 @if(!getCustomeForm('invoiceRoll','commission')) displayNone @endif">
                                                        <div class="form-group"> 
                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.Commission')</label>
                                                                <v-select v-model="selected_commission" label="name" :options="commission">
                                                                </v-select>
                                                                <input type="hidden" name="commission_id" :value="!selected_commission?null:selected_commission.id" />
                                                                <input type="hidden" name="commission_vendor_id" :value="!selected_commission?null:selected_commission.member_id" />
                                                                <input type="hidden" name="commission_expense_id" :value="!selected_commission?null:selected_commission.expense_id" />
                                                                <input type="hidden" name="commission_value" :value="subTotalCommi" readonly />
                                                            </div>
                                                        </div>
                                                    </div> 
                                                    <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12 @if(!getCustomeForm('invoiceRoll','commission')) displayNone @endif">
                                                        <div class="form-group"> 
                                                            <div class="col-md-12">
                                                                <label class="control-label"  v-if="commissionIsAmount">@lang('layout.Amount')</label>
                                                                <label class="control-label"  v-else="!commissionIsAmount">@lang('layout.Percentage') %</label>
                                                                <div class="input-group" style="color: black !important">
                                                                    <input class="form-control" type="number" min="0" max="100" name="camission_amount"  v-model="!selected_commission?null:selected_commission.percent">
                                                                    <span v-if="commissionIsAmount" @click="commissionIsAmount = !commissionIsAmount" style="background-color: rgb(80, 129, 141)" class="input-group-addon">@{{selected_currency.symbol}}
                                                                    <input type="hidden" class="input-group-addon" name="commission_type" value="currency">
                                                                </span>
                                                                <span v-else @click="commissionIsAmount = !commissionIsAmount" class="input-group-addon" style="background-color: rgb(80, 129, 141);">%
                                                                    <input type="hidden" name="commission_type" value="percent">
                                                                </span>
                                                                <input type="hidden" name="commissionTotal" :value="commission">
                                                                <input type="hidden" name="commission" :value="commissionFiled"> 
                                                            </div>
                                                            </div>
                                                        </div>
                                                    </div>  
                                                    @endif
                                                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="padding: 0px !important; margin: 0px !important;">
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <div class="form-group">
                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.Currency')</label>
                                                                    <v-select label="code" @input="selectedRate" :options="currency" v-model="selected_currency"></v-select>
                                                                    <input type="hidden" name="currency" v-validate="'required'" data-vv-as="@lang('layout.Currency')" :value="selected_currency.code">
                                                                    <span class="required">@{{ errors.first('currency') }}</span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <div class="form-group">
                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.Rate')</label>
                                                                    <input type="number" name="currency_rate" v-validate="'required'" data-vv-as="@lang('layout.Rate')" name="rate" v-model="!selected_currency?0:selected_currency.rate" class="form-control" :class="{'has-error':rate<=0}">
                                                                    <input type="hidden" name="hqRate" :value="selected_currency.hq_rate" v-if="selected_currency">
                                                                    <span class="required">@{{ errors.first('currency_rate') }}</span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <div class="form-group">
                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.Discount')</label>
                                                                    <div class="input-group">
                                                                        <input v-model="discountFiled" class="form-control" type="number" min="0" max="100">
                                                                        <span v-if="discountIsAmount" @click="discountIsAmount = !discountIsAmount" class="input-group-addon">@{{selected_currency.symbol}}
                                                                            <input type="hidden" class="input-group-addon" name="discount_type" value="currency">
                                                                        </span>
                                                                        <span v-else @click="discountIsAmount = !discountIsAmount" class="input-group-addon">%
                                                                            <input type="hidden" name="discount_type" value="percent">
                                                                        </span>
                                                                        <input type="hidden" name="discountTotal" :value="discount">
                                                                        <input type="hidden" name="discount" :value="discountFiled">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 @if(!getCustomeForm('invoiceRoll','description')) displayNone @endif">
                                                        <div class="form-group">
                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.Description')</label>
                                                                <textarea name="description" class="form-control" rows="1" v-text="invoiceDescription"></textarea>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12 @if(!getCustomeForm('invoiceRoll','date')) displayNone @endif">
                                                        <div class="form-group">
                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.Date')</label>
                                                                <date_picker name="date" v-model="date" placeholder="@lang('layout.Date')" ></date_picker>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12 @if(!getCustomeForm('invoiceRoll','overdueDate')) displayNone @endif">
                                                        <div class="form-group">
                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.OverdueDate')</label>
                                                                <date_picker name="overdue_date" v-model="overdue_date" placeholder="@lang('layout.OverdueDate')" ></date_picker>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12 @if(!getCustomeForm('invoiceRoll','hour')) displayNone @endif">
                                                        <div class="form-group">
                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.Hour')</label>
                                                                <div class="input-group" @click="stopDynamicTime" @mousemove="changeTime"> 
                                                                    @if(getHourType() == 24)
                                                                    <input type="text" class="form-control timepicker timepicker-24" v-model="dynamic_time" ref="time_input" name="hour" @keyup="changeTime">
                                                                    @else
                                                                    <input type="text" class="form-control timepicker timepicker-no-seconds" v-model="dynamic_time" ref="time_input" name="hour" @keyup="changeTime">
                                                                    @endif
                                                                    <span class="input-group-btn">
                                                                        <button class="btn default" type="button">
                                                                            <i class="fa fa-clock-o"></i>
                                                                        </button>
                                                                    </span>
                                                                </div>
                                                                {{-- <date_picker name="overdue_date" v-model="overdue_date" placeholder="@lang('layout.OverdueDate')" ></date_picker> --}}
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!--Begin Transport Company-->
                                                    @if(getTransportCompany()=="true")
                                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                        <div class="form-group">
                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('menu.TransportCompany')</label>
                                                                <v-select v-model="selected_transportCompany" label="name" :options="transportCompany" @input="getDrivers" @click.native="getAllDrivers">
                                                                </v-select>
                                                                <input type="hidden" name="transportCompany_id" :value="!selected_transportCompany?null:selected_transportCompany.id">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                        <div class="form-group">
                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.Driver')</label>
                                                                <v-select label="name" :options="t_drivers" v-model="selected_transportDriver">
                                                                </v-select>
                                                                <input type="hidden" name="trasnsport_driver_id" :value="!selected_transportDriver?null:selected_transportDriver.id">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    @endif
                                                    <!--End Transport Company-->
                                                    <!--Begin Sale Discount Date -->
                                                    @if(getSaleDiscountDate()=="true")
                                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                        <div class="form-group">
                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('menu.DiscountDate')</label>
                                                                <v-select v-model="selected_discount_date" label="name" :options="discount_date" ></v-select>
                                                                <input type="hidden" name="discount_date_id" :value="!selected_discount_date?null:selected_discount_date.id" />
                                                            </div>
                                                        </div>
                                                    </div>
                                                    @endif
                                                    <!--End Sale Discount Date -->
                                                    @if(getSaleToBase() == 'true')
                                                    <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                        <div class="col-md-12 form-group">
                                                            <label class=" control-label">@lang('layout.SaleBaseCurrency')</label>
                                                            <div class="col-md-12 mt-checkbox">
                                                                <label class="mt-checkbox mt-checkbox-outline">
                                                                    <input type="checkbox" name="sale_base_currency" value="ok">
                                                                    <span></span>
                                                                </label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    @endif
                                                    @if(getNegativeSale() == 'true')
                                                    <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                        <div class="col-md-12 form-group">
                                                            <label class=" control-label">@lang('layout.NegativeSale')</label>
                                                            <div class="col-md-12 mt-checkbox">
                                                                <label class="mt-checkbox mt-checkbox-outline">
                                                                    <input type="checkbox" name="negative_sale" value="ok">
                                                                    <span></span>
                                                                </label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    @endif
                                                    {{-- @if(getTelegramBot()=="true")
                                                    <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12" style="margin-top: 1%;">
                                                        <table class="table table-striped table-bordered table-advance">
                                                            <tr>
                                                                <td class="t_body" style="display: flex; justify-content: center; align-content: center; align-items: center;">
                                                                    <div>
                                                                        <label class="mt-checkbox mt-checkbox-outline">
                                                                            <i class="fa fa-telegram" style="color:rgb(14 177 177); font-size:20px; margin-top: 5px;"></i>
                                                                            <input type="checkbox" name="telegram" value="ok">
                                                                            <span></span>
                                                                        </label>
                                                                    </div>
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </div>
                                                    @endif --}}
                                                    @if(getWhatsApp() =='true')                    
                                                        <div class="col-lg-2 col-md-2 col-sm-6 col-xs-12">
                                                            <label class="control-label"> <span class="fa fa-telegram" style="color:rgb(14 177 177);"></span> @lang('layout.Telegram')</label>
                                                            <div class="col-md-12 mt-checkbox">
                                                                <label class="mt-checkbox mt-checkbox-outline">
                                                                    <input type="checkbox" name="telegram" value="ok">
                                                                    <span></span>
                                                                </label>
                                                            </div>
                                                        </div>
                                                    @endif
                                                    @if(getWhatsApp() =='true' && getWhatsAppType() == 'direct')                    
                                                        <div class="col-lg-2 col-md-2 col-sm-6 col-xs-12">
                                                            <label class="control-label"> <span class="fa fa-whatsapp" style="color:green;"></span> @lang('layout.Whatsapp')</label>
                                                            <div class="col-md-12 mt-checkbox">
                                                                <label class="mt-checkbox mt-checkbox-outline">
                                                                    <input type="checkbox"  name="whatsapp" value="5" />
                                                                    <span></span>
                                                                </label>
                                                            </div>
                                                        </div>
                                                    @endif
                                                    @if(getSaleByOtherMeasureRate() == "true")
                                                    <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                        <div class="col-md-12 form-group">
                                                            <label class=" control-label">@lang('layout.SaleByOtherMeasureRate')</label>
                                                            <div>
                                                                <label class="mt-checkbox mt-checkbox-outline">
                                                                    <input type="checkbox" name="per_qty_check" v-model="per_qty_check">
                                                                    <span></span>
                                                                </label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    @endif
                                                    @if(ShowQuantityByWing() == "true")
                                                    <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                        <div class="col-md-12 form-group">
                                                            <label class=" control-label">@lang('layout.QuantityByWing')</label>
                                                            <div>
                                                                <label class="mt-checkbox mt-checkbox-outline">
                                                                    <input type="checkbox" name="quantityByWing" v-model="quantityByWing" @click="totalChangeQuantityByWing()" >
                                                                    <span></span>
                                                                </label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    @endif
                                                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12" style="margin: 0px !important; padding: 0px !important;">
                                                        @if(ShowQuantityByWing() == "true")
                                                        <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                            <div class="col-md-12 form-group">
                                                                <label class=" control-label">@lang('layout.DifferentMeasure')</label>
                                                                <div>
                                                                    <label class="mt-checkbox mt-checkbox-outline">
                                                                        <select name="different_measure" class="form-control" id="">
                                                                            <option value=""> @lang('layout.Select') </option>
                                                                            <option value="SaleByOtherMeasureRate">@lang('layout.SelectQuantityByOtherMeasure')</option>
                                                                            <option value="QuantityByWing">@lang('layout.QuantityByWing')</option>
                                                                        </select>
                                                                    </label>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        @endif 
                                                        @if(ImportEngineNumberByExcel()=="true")
                                                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                            <div class="col-md-12 form-group">
                                                                <label class=" control-label">@lang('layout.ImportEngineNumberByExcel')</label>
                                                                <div>
                                                                    <label class="mt-checkbox mt-checkbox-outline">
                                                                        <input type="checkbox" name="import_engine_number" v-model="import_engine_number">
                                                                        <span></span>
                                                                    </label>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div v-if="import_engine_number" class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                            <a href="{{url('/')}}/import_file/simple_import_engine_chassis_number_sale_excel_file.xlsx">
                                                                <span class="btn btn-success">
                                                                    <i class="fa fa-download"></i>
                                                                    @lang('layout.SampleExcelFile')
                                                                </span>
                                                            </a>
                                                        </div>
                                                        @endif
                                                        @if(getFactorPending()=="true")
                                                        <div class="col-lg-2 col-md-2 col-sm-6 col-xs-12">
                                                            <div class="col-md-12 form-group">
                                                                <label class=" control-label">@lang('layout.Factor') @lang('layout.Pending')</label>
                                                                <div>
                                                                    <label class="mt-checkbox mt-checkbox-outline">
                                                                        <input type="checkbox" name="pending" value="on">
                                                                        <span></span>
                                                                    </label>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        @endif
                                                        @if(getSaleSubMeasure()=="true")
                                                            <div class="col-lg-2 col-md-2 col-sm-6 col-xs-12">
                                                                <div class="col-md-12 form-group">
                                                                    <label class=" control-label">@lang('layout.SubPrice')</label>
                                                                    <div>
                                                                        <label class="mt-checkbox mt-checkbox-outline">
                                                                            <input type="checkbox" v-model="sub_price" name="sub_price" checked>
                                                                            <span></span>
                                                                        </label>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px; padding: 20px !important;">
                                                <div class="dashboard-stat2 " style="padding: 5px 1px 1px 1px; margin-bottom: 5px;">
                                                    <table class="dashboard-tabel" width="100%">
                                                        <tr>
                                                            <td>
                                                                <small>@lang('layout.Total') :</small>
                                                            </td>
                                                            <td class="text-right"><span data-counter="counterup" data-value="7800">@{{ format_number(Number.parseFloat((subtotal - (discount*(subtotal - discountFiledRow)/100) - discountFiledRow)-payeds))}}</span>
                                                                <small class="font-green-sharp">
                                                                    @{{selected_currency.symbol}}
                                                                </small>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                                <small>@lang('layout.Discount'): (@{{
                                                                        Number.parseFloat(discount).toFixed(precision())
                                                                        }}%)
                                                                </small>
                                                            </td>
                                                            <td class="text-right">
                                                                <span class="text-right" data-counter="counterup" data-value="7800">@{{ format_number(Number.parseFloat(discount*(subtotal - discountFiledRow)/100)+Number.parseFloat(discountFiledRow)) }}</span>
                                                                <small class="font-green-sharp"> 
                                                                    @{{selected_currency.symbol}}
                                                                </small>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                                <small>@lang('layout.Payment'):</small>
                                                            </td>
                                                            <td class="text-right">
                                                                <small class="font-green-sharp">
                                                                    <span class="text-right" data-counter="counterup" data-value="7800">@{{ payeds.toFixed(precision())}}</span>
                                                                    <small class="font-green-sharp">
                                                                        @{{selected_currency.symbol}}
                                                                    </small>
                                                                </small>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                                <small>@lang('layout.Sub-Total'):</small>
                                                            </td>
                                                            <td class="text-right">
                                                                <span class="text-right" data-counter="counterup" data-value="7800">@{{ subtotal.toFixed(precision())}}</span>
                                                                <small class="font-green-sharp">
                                                                    @{{selected_currency.symbol}}
                                                                </small>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                                <small>@lang('layout.TotalQuantity'):</small>
                                                            </td>
                                                            <td class="text-right">
                                                                <span class="text-right" data-counter="counterup" data-value="7800">@{{ subtotalQty }}</span>
                                                                <small class="font-green-sharp"></small>
                                                            </td>
                                                        </tr>
                                                        @if(getSaleCommission() =="true")
                                                        <tr>
                                                            <td>
                                                                <small>@lang('layout.TotalCommission'):</small>
                                                            </td>
                                                            <td class="text-right">
                                                                <span class="text-right" data-counter="counterup" data-value="7800">
                                                                    @{{ myRound(Number.parseFloat(totalCommi) + Number.parseFloat(sum_commission))}}    
                                                                </span>
                                                                <small class="font-green-sharp"></small>
                                                            </td>
                                                        </tr>
                                                        @endif
                                                    </table>
                                                </div>
                                                <div class="dashboard-stat2 " v-if="selected_customer" style="padding: 5px 1px 1px 1px; margin-bottom: 5px;">
                                                    <table class="dashboard-tabel table-bordered" width="100%">
                                                        <thead>
                                                            <tr>
                                                                <th style="text-align: center;">@lang('layout.Currency') </th>
                                                                <th style="text-align: center;">@lang('layout.Payable')</th>
                                                                <th style="text-align: center;">@lang('layout.Receivable')</th>
                                                                <th style="text-align: center;">@lang('layout.AverageRate')</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <span>
                                                                <tr v-for="summ in summary">
                                                                    <td class="highlight" style="text-align: center;">
                                                                        @{{ summ.currency }}
                                                                    </td>
                                                                    <td style="text-align: center;"> 
                                                                        @{{ format_number(Number(summ.payment)) }}
                                                                    </td>
                                                                    <td style="text-align: center;">
                                                                        @{{format_number(Number(summ.invoice)) }}
                                                                    </td>
                                                                    <td style="text-align: center">
                                                                        @{{format_number(Number(summ.rate))}}
                                                                    </td>
                                                                </tr>
                                                            </span>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                            {{-- <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12"> --}}
                                                <!-- begin inputs -->
                                                {{-- <div class="row">
                                                    <div v-show="showWhat('sale_area')=='yes'" class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                        <div class="form-group">
                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.SaleArea')</label>
                                                                <v-select label="name" :options="saleArea" v-model="selected_area"></v-select>
                                                                <input type="hidden" name="sale_area_id" :value="!selected_area?null:selected_area.id">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div v-show="showWhat('member_class')=='yes'" class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                        <div class="form-group">
                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.MemberClass') </label>
                                                                <v-select label="name" :options="memberClass" v-model="selected_class" @input="memberClassChange()"></v-select>
                                                                <input type="hidden" name="class_id" :value="!selected_class?null:selected_class.id">
                                                            </div>
                                                        </div>
                                                    </div>    
                                                </div>
                                                <div class="row ">
                                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                        <div class="form-group">
                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.Customer')</label>
                                                                <div class="input-group">
                                                                    <v-select label="name" @input="memberChange(),getSummary()" @search="MemberSearch" :options="customer" v-model="selected_customer"></v-select>
                                                                    <input type="hidden" name="customer" v-validate="'required'" data-vv-as="@lang('layout.Customer')" :value="!selected_customer?null:selected_customer.id" required>
                                                                    <span class="btn btn-success input-group-addon " title="@lang('button.AddNewCustomer')" @click="showModal = true" style="background-color:  rgb(84, 199, 211)">
                                                                        <i class="fa fa-plus" style="color: white"></i>
                                                                    </span> 
                                                                </div>
                                                                <span class="required">@{{ errors.first('customer') }}</span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div v-show="showWhat('descriptionASMemberName')=='yes'" class="col-lg-4 col-md-4 col-sm-4 col-xs-12">
                                                        <div class="form-group">
                                                            <div class="col-md-12">
                                                                <label class=" control-label">@lang('layout.OtherMemberName')</label>
                                                                <div>
                                                                    <input type="text" name="other_member_name" v-model="other_member_name" class="form-control">
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                        <div class="form-group"> 
                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.InvoiceNumber')</label> 
                                                                <input type="number" name="number" v-validate="'required|numeric'" data-vv-as="@lang('layout.InvoiceNumber')" @input="checkNo()" v-model="number" class="form-control">
                                                                <span class="required">@{{ errors.first('number') }}</span>
                                                                <span v-if="number_Error ==true" class="input-has-error" style="color: red">@{{number_msg}}</span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="form-group">
                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.ReferenceNumber')</label>
                                                                <input type="text" name="ref_no" v-model="ref_no" class="form-control" @input="checkRefNo()">
                                                                <span v-if="isError1 ==true" class="input-has-error" style="color: red">@{{msg}}</span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row"> 
                                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                        <div class="form-group">
                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.Currency')</label>
                                                                <v-select label="code" @input="selectedRate" :options="currency" v-model="selected_currency"></v-select>
                                                                <input type="hidden" name="currency" v-validate="'required'" data-vv-as="@lang('layout.Currency')" :value="selected_currency.code">
                                                                <span class="required">@{{ errors.first('currency') }}</span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                        <div class="form-group">
                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.Rate')</label>
                                                                <input type="number" name="currency_rate" v-validate="'required'" data-vv-as="@lang('layout.Rate')" name="rate" v-model="!selected_currency?0:selected_currency.rate" class="form-control" :class="{'has-error':rate<=0}">
                                                                <input type="hidden" name="hqRate" :value="selected_currency.hq_rate" v-if="selected_currency">
                                                                <span class="required">@{{ errors.first('currency_rate') }}</span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                        <div class="form-group">
                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.Discount')</label>
                                                                <div class="input-group">
                                                                    <input v-model="discountFiled" class="form-control" type="number" min="0" max="100">
                                                                    <span v-if="discountIsAmount" @click="discountIsAmount = !discountIsAmount" class="input-group-addon">@{{selected_currency.symbol}}
                                                                        <input type="hidden" class="input-group-addon" name="discount_type" value="currency">
                                                                    </span>
                                                                    <span v-else @click="discountIsAmount = !discountIsAmount" class="input-group-addon">%
                                                                        <input type="hidden" name="discount_type" value="percent">
                                                                    </span>
                                                                    <input type="hidden" name="discountTotal" :value="discount">
                                                                    <input type="hidden" name="discount" :value="discountFiled">
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div> 
                                                <div class="row">
                                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                        <div class="form-group">
                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.Description')</label>
                                                                <textarea name="description" class="form-control" rows="1" v-text="invoiceDescription"></textarea>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                        <div class="form-group">
                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.Date')</label>
                                                                <date_picker name="date" v-model="date" placeholder="@lang('layout.Date')" ></date_picker>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-2 col-md-2 col-sm-6 col-xs-12">
                                                        <div class="form-group">
                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.OverdueDate')</label>
                                                                <date_picker name="overdue_date" v-model="overdue_date" placeholder="@lang('layout.OverdueDate')" ></date_picker>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-2 col-md-2 col-sm-6 col-xs-12">
                                                        <div class="form-group">
                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.Hour')</label>
                                                                <div class="input-group" @click="stopDynamicTime" @mousemove="changeTime"> 
                                                                    @if(getHourType() == 24)
                                                                    <input type="text" class="form-control timepicker timepicker-24" v-model="dynamic_time" ref="time_input" name="hour" @keyup="changeTime">
                                                                    @else
                                                                    <input type="text" class="form-control timepicker timepicker-no-seconds" v-model="dynamic_time" ref="time_input" name="hour" @keyup="changeTime">
                                                                    @endif
                                                                    <span class="input-group-btn">
                                                                        <button class="btn default" type="button">
                                                                            <i class="fa fa-clock-o"></i>
                                                                        </button>
                                                                    </span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>--}}
                                                {{-- <div class="row">
                                                    @if(getSaleToBase() == 'true')
                                                    <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                        <div class="col-md-12 form-group">
                                                            <label class=" control-label">@lang('layout.SaleBaseCurrency')</label>
                                                            <div class="col-md-12 mt-checkbox">
                                                                <label class="mt-checkbox mt-checkbox-outline">
                                                                    <input type="checkbox" name="sale_base_currency" value="ok">
                                                                    <span></span>
                                                                </label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    @endif

                                                    @if(getNegativeSale() == 'true')
                                                    <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                        <div class="col-md-12 form-group">
                                                            <label class=" control-label">@lang('layout.NegativeSale')</label>
                                                            <div class="col-md-12 mt-checkbox">
                                                                <label class="mt-checkbox mt-checkbox-outline">
                                                                    <input type="checkbox" name="negative_sale" value="ok">
                                                                    <span></span>
                                                                </label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    @endif

                                                    @if(getTelegramBot()=="true")
                                                    <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12" style="margin-top: 1%;">
                                                        <table class="table table-striped table-bordered table-advance">
                                                            <tr>
                                                                <td class="t_body" style="display: flex; justify-content: center; align-content: center; align-items: center;">
                                                                    <div>
                                                                        <label class="mt-checkbox mt-checkbox-outline">
                                                                            <i class="fa fa-telegram" style="color:rgb(14 177 177); font-size:20px; margin-top: 5px;"></i>
                                                                            <input type="checkbox" name="telegram" value="ok">
                                                                            <span></span>
                                                                        </label>
                                                                    </div>
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </div>
                                                    @endif

                                                    @if(getSaleByOtherMeasureRate() == "true")
                                                    <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                        <div class="col-md-12 form-group">
                                                            <label class=" control-label">@lang('layout.SaleByOtherMeasureRate')</label>
                                                            <div>
                                                                <label class="mt-checkbox mt-checkbox-outline">
                                                                    <input type="checkbox" name="per_qty_check" v-model="per_qty_check">
                                                                    <span></span>
                                                                </label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    @endif

                                                    @if(ShowQuantityByWing() == "true")
                                                    <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                        <div class="col-md-12 form-group">
                                                            <label class=" control-label">@lang('layout.QuantityByWing')</label>
                                                            <div>
                                                                <label class="mt-checkbox mt-checkbox-outline">
                                                                    <input type="checkbox" name="quantityByWing" v-model="quantityByWing" @click="totalChangeQuantityByWing()" >
                                                                    <span></span>
                                                                </label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    @endif

                                                    @if(ShowQuantityByWing() == "true")
                                                    <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                        <div class="col-md-12 form-group">
                                                            <label class=" control-label">@lang('layout.DifferentMeasure')</label>
                                                            <div>
                                                                <label class="mt-checkbox mt-checkbox-outline">
                                                                    <select name="different_measure" class="form-control" id="">
                                                                        <option value=""> @lang('layout.Select') </option>
                                                                        <option value="SaleByOtherMeasureRate">@lang('layout.SelectQuantityByOtherMeasure')</option>
                                                                        <option value="QuantityByWing">@lang('layout.QuantityByWing')</option>
                                                                    </select>
                                                                </label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    @endif 
                                                    
                                                    @if(ImportEngineNumberByExcel()=="true")
                                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                        <div class="col-md-12 form-group">
                                                            <label class=" control-label">@lang('layout.ImportEngineNumberByExcel')</label>
                                                            <div>
                                                                <label class="mt-checkbox mt-checkbox-outline">
                                                                    <input type="checkbox" name="import_engine_number" v-model="import_engine_number">
                                                                    <span></span>
                                                                </label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div v-if="import_engine_number" class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                        <a href="{{url('/')}}/import_file/simple_import_engine_chassis_number_sale_excel_file.xlsx">
                                                            <span class="btn btn-success">
                                                                <i class="fa fa-download"></i>
                                                                @lang('layout.SampleExcelFile')
                                                            </span>
                                                        </a>
                                                    </div>
                                                    @endif

                                                    @if(getFactorPending()=="true")
                                                    <div class="col-lg-2 col-md-2 col-sm-6 col-xs-12">
                                                        <div class="col-md-12 form-group">
                                                            <label class=" control-label">@lang('layout.Factor') @lang('layout.Pending')</label>
                                                            <div>
                                                                <label class="mt-checkbox mt-checkbox-outline">
                                                                    <input type="checkbox" name="pending" value="on">
                                                                    <span></span>
                                                                </label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    @endif

                                                </div> --}}
                                                {{-- <div class="row">
                                                    <!--Begin Transport Company-->
                                                    @if(getTransportCompany()=="true")
                                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                        <div class="form-group">
                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('menu.TransportCompany')</label>
                                                                <v-select v-model="selected_transportCompany" label="name" :options="transportCompany" @input="getDrivers" @click.native="getAllDrivers">
                                                                </v-select>
                                                                <input type="hidden" name="transportCompany_id" :value="!selected_transportCompany?null:selected_transportCompany.id">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                        <div class="form-group">
                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.Driver')</label>
                                                                <v-select label="name" :options="t_drivers" v-model="selected_transportDriver">
                                                                </v-select>
                                                                <input type="hidden" name="trasnsport_driver_id" :value="!selected_transportDriver?null:selected_transportDriver.id">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    @endif
                                                    <!--End Transport Company-->
                                                    <!--Begin Sale Discount Date -->
                                                    @if(getSaleDiscountDate()=="true")
                                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                        <div class="form-group">
                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('menu.DiscountDate')</label>
                                                                    <v-select 
                                                                        v-model="selected_discount_date"
                                                                        label="name" :options="discount_date" >
                                                                    </v-select>
                                                                    <input type="hidden" name="discount_date_id" :value="!selected_discount_date?null:selected_discount_date.id" />
                                                            </div>
                                                        </div>
                                                    </div>
                                                    @endif
                                                    <!--End Sale Discount Date -->
                                                </div> --}}
                                                <!-- end inputs -->
                                            {{-- </div> --}}
                                            {{-- <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                <!-- begin total -->
                                                <div class="dashboard-stat2 " style="padding: 5px 1px 1px 1px; margin-bottom: 5px;">
                                                    <table class="dashboard-tabel" width="100%">
                                                        <tr>
                                                            <td>
                                                                <small>@lang('layout.Total') :</small>
                                                            </td>
                                                            <td class="text-right"><span data-counter="counterup" data-value="7800">@{{ format_number(Number.parseFloat((subtotal - (discount*(subtotal - discountFiledRow)/100) - discountFiledRow)-payeds))}}</span>
                                                                <small class="font-green-sharp">
                                                                    @{{selected_currency.symbol}}
                                                                </small>
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <td>
                                                                <small>@lang('layout.Discount'): (@{{
                                                                        Number.parseFloat(discount).toFixed(precision())
                                                                        }}%)
                                                                </small>
                                                            </td>
                                                            <td class="text-right">
                                                                <span class="text-right" data-counter="counterup" data-value="7800">@{{ format_number(Number.parseFloat(discount*(subtotal - discountFiledRow)/100)+Number.parseFloat(discountFiledRow)) }}</span>
                                                                <small class="font-green-sharp"> 
                                                                    @{{selected_currency.symbol}}
                                                                </small>
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <td>
                                                                <small>@lang('layout.Payment'):</small>
                                                            </td>
                                                            <td class="text-right">
                                                                <small class="font-green-sharp">
                                                                    <span class="text-right" data-counter="counterup" data-value="7800">@{{ payeds.toFixed(precision())}}</span>
                                                                    <small class="font-green-sharp">
                                                                        @{{selected_currency.symbol}}
                                                                    </small>
                                                                </small>
                                                            </td>
                                                        </tr>


                                                        <tr>
                                                            <td>
                                                                <small>@lang('layout.Sub-Total'):</small>
                                                            </td>
                                                            <td class="text-right">
                                                                <span class="text-right" data-counter="counterup" data-value="7800">@{{ subtotal.toFixed(precision())}}</span>
                                                                <small class="font-green-sharp">
                                                                    @{{selected_currency.symbol}}
                                                                </small>
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <td>
                                                                <small>@lang('layout.TotalQuantity'):</small>
                                                            </td>
                                                            <td class="text-right">
                                                                <span class="text-right" data-counter="counterup" data-value="7800">@{{ subtotalQty }}</span>
                                                                <small class="font-green-sharp">

                                                                </small>
                                                            </td>
                                                        </tr>


                                                    </table>

                                                </div>
                                                <!-- end total -->
                                            </div> --}}
                                            {{-- <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                <!-- begin total -->
                                                <div class="dashboard-stat2 " v-if="selected_customer" style="padding: 5px 1px 1px 1px; margin-bottom: 5px;">
                                                    <table class="dashboard-tabel table-bordered" width="100%">
                                                        <thead>
                                                            <tr>
                                                                <th>@lang('layout.Currency') </th>
                                                                <th>@lang('layout.Payable')</th>
                                                                <th>@lang('layout.Receivable')</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <span>
                                                                <tr v-for="summ in summary">
                                                                    <td class="highlight">
                                                                        @{{ summ.currency }}
                                                                    </td>
                                                                    <td class="hidden-xs"> @{{ format_number(Number(summ.payment)) }}</td>
                                                                    <td>
                                                                        @{{format_number(Number(summ.invoice)) }}
                                                                    </td>
                                                                </tr>
                                                            </span>
                                                        </tbody>
                                                    </table>

                                                </div>
                                                <!-- end total -->
                                            </div> --}}
                                        </div>
                                        @if(saleMainItemInFactorCode()!="false")
                                        <h3 v-if="main_inventories.length>0">@lang('layout.MainItem')</h3>
                                        <div class="row" v-if="main_inventories.length>0" style="overflow-x: scroll;">
                                            <table id="table_content" class="table table-bordered table-advance">
                                                <thead>
                                                    <tr> 
                                                        <th>#</th> 
                                                        @if(getSaleCommission()=="true")
                                                        <th>@lang('layout.Commission')</th>
                                                        @endif 
                                                        <th v-show="showWhat('sale_category')=='yes'" style="min-width: 130px">@lang('layout.Category') </th>
                                                        @if(getSerailNumber() =="true")
                                                        <th style="min-width: 100px">@lang('layout.SerialNum') </th>
                                                        @endif
                                                        <th style="min-width: {{itemFieldWidth()}}px">@lang('layout.ItemName') </th>
                                                        <th style="min-width: 100px;">@lang('layout.SiteName') </th>
                                                        <th v-show="showWhat('sale_description')=='yes'" style="min-width: 100px">@lang('layout.Description') </th>
                                                        <th v-show="showWhat('sale_description2')=='yes'" style="min-width: 100px">@lang('layout.Description')
                                                            :2
                                                        </th>
                                                        <th style="min-width: 100px">@lang('layout.Quantity') </th>
                                                        <th style="min-width: 100px">@lang('layout.OnHand') </th>
                                                        <th v-show="showWhat('other_measure')=='yes'" style="min-width: 100px">@lang('layout.OMeasureValue1')
                                                        </th>
                                                        <th v-show="showWhat('other_measure2')=='yes'" style="min-width: 100px">@lang('layout.OMeasureValue2')
                                                        </th>
                                                        <th style="min-width: 100px">@lang('layout.Measure') </th>
                                                        <th v-show="seeCost==true" style="min-width: 100px">@lang('layout.Cost')</th>
                                                        <th v-show="seePrice==true" style="min-width: 100px">@lang('layout.NewPrice') </th>

                                                        @if(getM2()!="")
                                                        @if(getFactorMeasure2()=="true")
                                                        <th style="min-width: 100px">@lang('layout.Measure2') </th>
                                                        @endif
                                                        @endif
                                                        @if(getM3()!="")
                                                        @if(getFactorMeasure3()=="true")
                                                        <th style="min-width: 100px">@lang('layout.Measure3') </th>
                                                        @endif
                                                        @endif
                                                        @if(getM4()!="")
                                                        @if(getFactorMeasure4()=="true")
                                                        <th style="min-width: 100px">@lang('layout.Measure4') </th>
                                                        @endif
                                                        @endif
                                                        @if(getSaleCommission()=="true")
                                                        <th style="min-width: 100px" v-if="commissionIsAmount">@lang('layout.Commission') @lang('layout.Amount')</th>
                                                        <th style="min-width: 100px" v-else="!commissionIsAmount">@lang('layout.Commission') @lang('layout.Percentage')%</th>
                                                        @endif 
                                                        <th v-show="showWhat('sale_discount')=='yes'" style="min-width: 100px">@lang('layout.Discount') </th>
                                                        <th v-show="seePrice==true" style="min-width: 100px">@lang('layout.Total')</th>
                                                        
                                                        <th></th> 
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr v-for="(item,index) in main_inventories">
                                                        <td>@{{index+1}}</td>  
                                                        @if(getSaleCommission() =="true") 
                                                        <td> 
                                                            <div class="mt-checkbox" style="padding-left: 0px;"> 
                                                                <label class="mt-checkbox mt-checkbox-outline"> 
                                                                    <input type="checkbox" :name="'row_commission_stat['+index+']'" v-model="item.commission" checked /> 
                                                                    <span></span> 
                                                                </label> 
                                                            </div> 
                                                        </td>
                                                        @endif  

                                                        <td v-show="showWhat('sale_category')=='yes'">
                                                            <v-select label="name" v-model="item.item_category" :options="inventory_category" @keyup.native="itemCategoryChange(index)" @Click.native="itemCategoryChange(index), addNew('main_inventory',index)" ></v-select>
                                                            <input type="hidden" :name="'main_inventory_category_id['+index+']'" :value="(!item.item_category)?null:item.item_category.id">
                                                        </td>
                                                        @if(getSerailNumber() =="true")
                                                        <td>
                                                            <input :value="(!item.item)?null:item.item.number" class="form-control input-style input-number" placeholder="@lang('layout.SerialNum')" disabled>
                                                        </td>
                                                        @endif
                                                        <td class="highlight">
                                                            <div class="input-group">
                                                                <v-select label="name" @keyup.native="onItemload(index), addNew('main_inventory',index)" @Click.native="onItemload(index), addNew('main_inventory',index)" v-model="item.inventory" :options="temp_main_items" @search="onMainItemSearch" @if(TabIndexInItemName() =="true") tabindex="1" @endif ></v-select>
                                                                <input type="hidden" :name="'main_inventory_id['+index+']'" v-validate="''" data-vv-as="@lang('layout.ItemName')" :value="(!item.item)?null:item.item.id">
                                                                <span class="required">@{{ errors.first('inventory_id['+index+']') }}</span>
                                                                <input type="hidden" :value="(!item.item)?null:item.item.sale_order_detail_id" :name="'main_sale_order_detail_id['+index+']'">
                                                                <span class="btn btn-success input-group-addon" @click="showInfo(index,'main')">
                                                                    <i class="fa fa-info"></i></span>
                                                            </div>
                                                        </td>
                                                        <td class="highlight">
                                                            <select v-model="(item.item==null)?null:item.item.site" class="form-control">
                                                                <option value="null">@lang('layout.Select')</option>

                                                                <span v-if="(item.item != null)">
                                                                    <option v-for="site in (item.item==null)?null:item.item.site_list" :value="site">
                                                                        @{{site.site_name}}
                                                                    </option>
                                                                </span>
                                                            </select>

                                                            <input type="hidden" :name="'main_inventory_site['+index+']'" :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.site_id)">
                                                        </td>
                                                        <td v-show="showWhat('sale_description')=='yes'">
                                                            <input type="text" placeholder="@lang('layout.Description')" name="main_inventory_description[]"
                                                            oninput = "autowidths(event)"
                                                            class="form-control chan_length">
                                                        </td>
                                                        <td v-show="showWhat('sale_description2')=='yes'">
                                                            <input type="text" placeholder="@lang('layout.Description')" name="main_description2[]" 
                                                            oninput = "autowidths(event)"
                                                            class="form-control chan_length">
                                                        </td>

                                                        <td>
                                                            <input type="number" :name="'main_inventory_quantity['+index+']'" v-validate="(item.item==null)?'':'required'" data-vv-as="@lang('layout.Quantity')" v-model.number="(item.item==null)?null:item.item.quantity"
                                                            oninput = "autowidths(event)" @input="setNewRateMain('inventory',index)" class="form-control input-style input-number chan_length" placeholder="@lang('layout.Quantity')">
                                                            <span class="required">@{{ errors.first('main_inventory_quantity['+index+']') }}</span>
                                                        </td>

                                                        <td>
                                                            @{{myRound((item.item==null)?null:saleItemQuantity(item.item,item.item.quantity))}}
                                                        </td>
                                                        <td v-show="showWhat('other_measure')=='yes'">
                                                            <div class="input-group">
                                                                <input type="number" name="main_other_measure_amount[]"
                                                                oninput = "autowidths(event)" class="form-control input-style input-number chan_length" placeholder="@lang('layout.OMeasureValue1')" v-model.number="(item.item==null)?null:item.item.other_measure">
                                                                <span class="input-group-addon">
                                                                    @{{(item.item==null)?null:item.item.o_measure_v}}
                                                                </span>
                                                            </div>
                                                        </td>
                                                        <td v-show="showWhat('other_measure2')=='yes'">
                                                            <div class="input-group">
                                                                <input type="number" name="main_other_measure_amount2[]" 
                                                                oninput = "autowidths(event)" class="form-control input-style input-number chan_length" placeholder="@lang('layout.OMeasureValue2')" v-model.number="(item.item==null)?null:item.item.other_measure2">
                                                                <span class="input-group-addon">
                                                                    @{{(item.item==null)?null:item.item.o_measure_v1}}
                                                                </span>
                                                            </div>
                                                        </td>
                                                        <td class="highlight">
                                                            <select v-model="(item.item == null)?null:item.item.measure" class="form-control" @change="mainMeasureChange(index)">
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(item.item ==null)?false:true">
                                                                    <option v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure">
                                                                        @{{measure.measure_name}}
                                                                    </option>
                                                                </span>


                                                            </select>

                                                            <input type="hidden" :name="'main_inventory_measure['+index+']'" :value="(item.item==null)?null:item.item.measure.measure_id">
                                                        </td>

                                                        @if(systemConfig()[30] == 1)
                                                        <td v-show="seeCost==true">
                                                            @{{(item.item==null)?null: myRound((item.item.LasCost * item.item.measure.measure_unit / item.item.measure_unit) * selected_currency.static_rate / selected_currency.rate)}}
                                                        </td>
                                                        @else 
                                                        <td v-show="seeCost==true">
                                                            @{{(item.item==null)?null: myRound((item.item.LasCost * item.item.measure.measure_unit / item.item.measure_unit) *selected_currency.rate)}}
                                                        </td>
                                                        @endif


                                                        <td v-show="seePrice==true">
                                                            <vue-numeric v-if="item.item"
                                                                class="form-control chan_length"
                                                                oninput = "autowidths(event)"
                                                                v-model="item.item.cost"
                                                                :max="99999999999999"
                                                                currency=""
                                                                :precision="precision()"
                                                                @input="setNewRateMain('inventory',index)"
                                                                >
                                                            </vue-numeric>
                                                            <input type="hidden" :name="'main_inventory_price['+index+']'" data-vv-as="@lang('layout.Price')" placeholder="@lang('layout.Price')" 
                                                            v-bind:value="(item.item==null)?null:saleNewRate(item.item,selected_currency.rate, null, selected_currency.static_rate)" ref="in_mian" class="form-control">
                                                            <span class="required">@{{ errors.first('main_inventory_price['+index+']') }}</span>
                                                            <span v-show="((item.item==null)?null:checkCheap(item.item,selected_currency.rate, selected_currency.static_rate))==true" class="required">@lang('layout.SalesToTheDetriment')</span>
                                                        </td>

                                                        @if(getM2()!="")
                                                        @if(getFactorMeasure2()=="true")
                                                        <td>
                                                            <select :name="'main_measure1['+index+']'" class="form-control" v-model="(item.item==null)?null:item.item.measure1.measure_id">
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(item.item ==null)?false:true">
                                                                    <option v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure.measure_id">
                                                                        @{{measure.measure_name}}
                                                                    </option>
                                                                </span>
                                                            </select>
                                                        </td>
                                                        @endif
                                                        @endif
                                                        @if(getM3()!="")
                                                        @if(getFactorMeasure3()=="true")
                                                        <td>
                                                            <select :name="'main_measure2['+index+']'" class="form-control" v-model="(item.item==null)?null:item.item.measure2.measure_id">
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(item.item ==null)?false:true">
                                                                    <option v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure.measure_id">
                                                                        @{{measure.measure_name}}
                                                                    </option>
                                                                </span>
                                                            </select>
                                                        </td>
                                                        @endif
                                                        @endif
                                                        
                                                        @if(getM4()!="")
                                                        @if(getFactorMeasure4()=="true")
                                                        <td>
                                                            <select :name="'main_measure3['+index+']'" class="form-control" v-model="(item.item==null)?null:item.item.measure3.measure_id">
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(item.item ==null)?false:true">
                                                                    <option v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure.measure_id">
                                                                        @{{measure.measure_name}}
                                                                    </option>
                                                                </span>
                                                            </select>
                                                        </td>
                                                        @endif   
                                                        @endif    
                                                        
                                                        @if(getSaleCommission()=="true")
                                                        <td>
                                                            <div class="input-group" v-show="!item.commission"> 
                                                                <input type="number" class="form-control chan_length" :name="'row_percent_commission['+index+']'" oninput = "autowidths(event)" v-model="item.row_commission_percent" />
                                                                <span class="input-group-addon" v-if="commissionIsAmount">
                                                                    @{{selected_currency.symbol}}
                                                                </span>
                                                                <span class="input-group-addon" v-if="!commissionIsAmount">
                                                                    %
                                                                </span>
                                                            <input type="hidden" :name="'row_commission_amount['+index+']'" :value="item.row_commission_amount" />
                                                        </div>
                                                        </td>
                                                        @endif  
                                                        

                                                        <td v-show="showWhat('sale_discount')=='yes'">
                                                            <div class="input-group">
                                                                <input type="number" name="main_inventory_discount[]" placeholder="@lang('layout.Discount')" v-model.number="(item.item==null)?null:item.item.discount" oninput = "autowidths(event)" class="form-control chan_length">
                                                                <span class="input-group-addon" v-if="discountIsAmount">
                                                                    @{{selected_currency.symbol}}
                                                                </span>
                                                                <span class="input-group-addon" v-if="!discountIsAmount">
                                                                    %
                                                                </span>

                                                            </div>
                                                        </td>
                                                        <td v-show="seePrice==true">
                                                            @{{(item.item==null)? 0:getItemTotal(item.item,selected_currency.rate,discountIsAmount,item.item.discount,selected_currency.hq_rate,per_qty_check, null, selected_currency.static_rate).result}}
                                                            @{{selected_currency.symbol}}
                                                        </td>
                                                        <td>
                                                            <span v-on:click="deleteItem('main_inventory',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>

                                                        </td>
                                                    </tr>
                                                    <!-- tr style="background-color: #ffffff;">
                                                        <td></td>
                                                        <td>
                                                            <center>
                                                                <button type="button" @click="addNew('main_inventory',100)"
                                                                        class="btn btn-success"><i
                                                                            class="fa fa-plus"></i></button>
                                                            </center>
                                                        </td>
                                                        <td></td>
                                                        <td></td>
                                                        <td></td>
                                                        <td></td>
                                                        <td></td>
                                                        <td></td>
                                                        <td></td>
                                                    </tr -->
                                                </tbody>
                                            </table>
                                        </div>
                                        <hr>
                                        @endif
                                        <h3>@lang('layout.ItemByCode')</h3>
                                        <div class="row" style="overflow-x: scroll;">
                                            <table v-if="inventories.length>0" id="table_content" class="table table-bordered table-advance">
                                                <thead>
                                                    <tr>
                                                        <th>#</th>
                                                        @if(getSaleCommission()=="true")
                                                        <th>@lang('layout.Commission')</th>
                                                        @endif 
                                                        <th v-show="showWhat('sale_category')=='yes'" style="min-width: 130px">@lang('layout.Category') </th>
                                                        @if(getCodeBrand()=="true")
                                                        <th style="min-width: 100px;">@lang('layout.Brand')</th>
                                                        @endif
                                                        @if(getCodeBrand()=="true" || searchByCodeLocation()=="true")
                                                        <th style="min-width: 100px">@lang('layout.PartNumber') </th>
                                                        @endif
                                                        @if(searchByCodeLocation()=="true")
                                                        <th style="min-width: 100px;">@lang('layout.Location')</th>
                                                        @endif
                                                        <th style="min-width: {{itemFieldWidth()}}px">@lang('layout.ItemName') </th>
                                                        <th style="min-width: 100px">@lang('layout.SiteName') </th>
                                                        @if(getCodeBrand()!="true" && searchByCodeLocation()!="true")
                                                        <th v-if="!import_engine_number" style="min-width: 100px">@lang('layout.Code') </th>
                                                        <th v-if="import_engine_number" style="min-width: 100px">@lang('layout.EngineNumber') @lang('layout.File')</th>
                                                        @endif
                                                        <th  v-show="showWhat('sale_description')=='yes'" style="min-width: 100px" class="purchase_description">@lang('layout.Description') </th>
                                                        @if(ImportEngineNumberByExcel()!="true")
                                                        <th  v-show="showWhat('sale_description2')=='yes'" style="min-width: 100px" class="purchase_description">@lang('layout.Description') 2 </th>
                                                        @endif
                                                        @if(ImportEngineNumberByExcel()=="true")
                                                        <th v-if="!import_engine_number" style="min-width: 100px" >@lang('layout.DocumentReceived')</th>
                                                        @endif
                                                        @if(getCustomHouseLitter()=="true")
                                                        <th style="min-width: 100px">@lang('layout.CustomHouseLitterNumber') </th>
                                                        <th style="min-width: 100px">@lang('layout.Province') </th>
                                                        <th style="min-width: 100px">@lang('layout.CustomHouseLitterDate') </th>
                                                        @endif
                                                        <th style="min-width: 100px">@lang('layout.Quantity') </th>
                                                        <th v-if='selected_sale_order != null' style="min-width: 100px">@lang('layout.QtyOrder') </th>
                                                        @if(systemConfig()[9] == 0 )
                                                        <th v-if='selected_sale_order != null' style="min-width: 100px">@lang('layout.BundlOrder') </th>
                                                        @endif
                                                        <th v-if="!import_engine_number" style="min-width: 100px">@lang('layout.Weight') </th>
                                                        <th style="min-width: 100px">@lang('layout.OnHand') </th>
                                                        @if(systemConfig()[21] == 1 || getCubicMetereItems()=="true")
                                                        <th class="text-center" style="min-width: 100px;">@lang('layout.Width')</th>
                                                        <th class="text-center" style="min-width: 100px;">@lang('layout.Length')</th>
                                                        @endif
                                                        @if(getCubicMetereItems()=="true")
                                                        <th>@lang('layout.Gauge') </th>
                                                        @endif
                                                        <th v-show="showWhat('other_measure')=='yes'" style="min-width: 170px">@lang('layout.OMeasureValue1')</th>
                                                        <th v-show="showWhat('other_measure2')=='yes'" style="min-width: 150px">@lang('layout.OMeasureValue2')</th>
                                                        <th style="min-width: 100px">@lang('layout.Measure') </th>
                                                        @if(getM2()!="")
                                                        @if(getFactorMeasure2()=="true")
                                                        <th style="min-width: 100px">@lang('layout.Measure2') </th>
                                                        @endif
                                                        @endif
                                                        @if(getM3()!="")
                                                        @if(getFactorMeasure3()=="true")
                                                        <th style="min-width: 100px">@lang('layout.Measure3') </th>
                                                        @endif
                                                        @endif
                                                        @if(getM4()!="")
                                                        @if(getFactorMeasure4()=="true")
                                                        <th style="min-width: 100px">@lang('layout.Measure4') </th>
                                                        @endif
                                                        @endif
                                                        @if(getSaleSubMeasure()=="true")
                                                        <th v-show="sub_price" style="min-width: 100px">@lang('layout.EquivalentTo') </th>
                                                        <th v-show="sub_price" style="min-width: 100px">@lang('layout.SubPrice') </th>
                                                        @endif
                                                        @if(getSaleCommission()=="true")
                                                        <th style="min-width: 100px" v-if="commissionIsAmount">@lang('layout.Commission') @lang('layout.Amount')</th>
                                                        <th style="min-width: 100px" v-else="!commissionIsAmount">@lang('layout.Commission') @lang('layout.Percentage')%</th>
                                                        @endif 
                                                        @if(showLocation()=="true" && searchByCodeLocation()!="true")
                                                        <th style="min-width: 100px;">@lang('layout.Location')</th>
                                                        @endif
                                                        @if(getShowWing()!="false")
                                                        <th v-if="!import_engine_number" style="min-width: 100px">@lang('layout.Wing') </th>
                                                        @if(ShowQuantityByWing() == "true")
                                                        <th v-if="!import_engine_number" style="min-width: 100px">@lang('layout.ApproxWeight') </th>
                                                        <th v-if="!import_engine_number" v-show="quantityByWing" style="min-width: 100px">@lang('layout.Price') @lang('layout.Wing') </th>
                                                        <th v-if="!import_engine_number" style="min-width: 100px">@lang('layout.Bundl') </th>
                                                        @endif
                                                        @endif
                                                        @if(systemConfig()[21] == 1)
                                                        <th class="text-center" style="min-width: 100px;">@lang('layout.UnitPrice')</th>
                                                        @endif
                                                        @if(getSaleCodePricePercentage() == 'true')
                                                        <th class="text-center" style="min-width: 100px;">@lang('layout.Percentage')%</th>
                                                        @endif
                                                        <th v-show="seeCost==true" style="min-width: 100px">@lang('layout.Cost') ({{getHomeCurrency()['code']}})</th>
                                                        <th v-show="seeCost==true" style="min-width: 100px">@lang('layout.Cost')</th>
                                                        <th style="min-width: 100px">@lang('layout.NewCost') </th>
                                                        <th v-show="showWhat('sale_discount')=='yes'" style="min-width: 100px">@lang('layout.Discount') </th>
                                                        <th style="min-width: 100px">@lang('layout.Total') </th>
                                                        <th></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr v-for="(item,index) in inventories">
                                                        <td>@{{index+1}}</td> 
                                                        @if(getSaleCommission() =="true") 
                                                        <td> 
                                                            <div class="mt-checkbox" style="padding-left: 0px;"> 
                                                                <label class="mt-checkbox mt-checkbox-outline"> 
                                                                    <input type="checkbox" :name="'row_commission_stat_code['+index+']'" v-model="item.commission" checked /> 
                                                                    <span></span> 
                                                                </label> 
                                                            </div> 
                                                        </td>
                                                        @endif    
                                                        <td v-show="showWhat('sale_category')=='yes'">
                                                            <v-select label="name" v-model="item.item_category" :options="inventory_category" @keyup.native="itemCategoryChangeCode(index)" @click.native="addIndex(index), addNew('inventory',index), itemCategoryChangeCode(index)" ></v-select>
                                                            <input type="hidden" :name="'inventory_category_id['+index+']'" :value="(!item.item_category)?null:item.item_category.id">
                                                        </td>
                                                        @if(getCodeBrand()=="true")
                                                        <td class="highlight">
                                                            <v-select label="name" @keyup.native="onItemSearchBrand(index)" @click.native="addIndex(index), addNew('inventory',index), onItemSearchBrand(index)" v-model="item.selectedBrand" :options="brandItem" placeholder="@lang('layout.Brand')" ></v-select>
                                                            <input type="hidden" :name="'brand_id['+index+']'" :value="(item.selectedBrand==null)?null:item.selectedBrand.id">
                                                        </td>
                                                        @endif
                                                        @if(getCodeBrand()=="true" || searchByCodeLocation()=="true")
                                                        <td class="highlight">
                                                            <v-select label="name" @click.native="addIndex(index), addNew('inventory',index)" @input="addIndex(index), onItemLoadByCode(index), editKey = false" v-model="(item==null)?null:item.code" :options="codeList" @search="onSearchCode" placeholder="@lang('layout.PartNumber')" ></v-select>
                                                            <input type="hidden" :name="'cost_roll['+index+']'" :value="(item==null)?null:((item.code==null)?null:item.code.per_price)">
                                                            <input type="hidden" :name="'cost['+index+']'" :value="(item==null)?null:((item.code==null)?null:item.code.cost)">
                                                            <input type="hidden" :name="'m_stocks_in_id['+index+']'" :value="(item==null)?null:((item.code==null)?null:item.code.id)">
                                                            <input type="hidden" :name="'main_stock_id['+index+']'" :value="(item==null)?null:((item.code==null)?null:item.code.main_stock_id)">
                                                            <span v-if='(item==null)?null:((item.code==null)?null:item.code.lengths == "duplicate")' class="required">@lang('layout.DuplicateData')</span>
                                                        </td>
                                                        @endif
                                                        @if(searchByCodeLocation()=="true")
                                                        <td class="highlight">
                                                            <v-select label="name" @click.native="addIndex(index), addNew('inventory',index)" @input="addIndex(index), onItemSearchLocation(index)" v-model="(item==null)?null:item.selectedLocation" :options="locationList" @search="onSearchLocation" placeholder="@lang('layout.Location')" ></v-select>
                                                            <input type="hidden" :value="(item==null)?null:((item.selectedLocation==null)?null:item.selectedLocation.name)">
                                                        </td>
                                                        @endif
                                                        <td class="highlight">
                                                            <!-- @click.native="addNew('inventory',index)" -->
                                                            <div class="input-group">
                                                                <v-select label="name" v-model="item.inventory" :options="temp_items" @search="onItemSearch" @if(searchByCodeLocation()!="true" || getCodeBrand() !="true") @input="(editKey)?onItemLoadCode(index):''" @endif 
                                                                @keyup.native="onItemLoadCode(index), addNew('inventory',index), editKey = true" @Click.native="onItemLoadCode(index), addNew('inventory',index), editKey = true" @if(TabIndexInItemName() =="true") tabindex="1" @endif ></v-select>
                                                                <input type="hidden" id="item_id" :name="'inventory_id['+index+']'" :value="(!item.item)?null:item.item.id">
                                                                <input type="hidden" :value="(!item.item)?null:item.item.sale_order_detail_id" :name="'sale_order_detail_id['+index+']'">
                                                                <span class="btn btn-success input-group-addon" @click="showInfo(index,'code')"> <i class="fa fa-info"></i></span>
                                                            </div>
                                                        </td>
                                                        <td class="highlight">
                                                            <select v-model="(item.item==null)?null:item.item.site" @input="onItemSearchCodeSelect(index)" class="form-control">
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(item.item != null)">
                                                                    <option v-for="site in (item.item==null)?null:item.item.site_list" :value="site">
                                                                        @{{site.site_name}}
                                                                    </option>
                                                                </span>
                                                            </select>
                                                            <input type="hidden" id="inventory_site" :name="'inventory_site['+index+']'" :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.site_id)">
                                                        </td>
                                                        @if(getCodeBrand()!="true" && searchByCodeLocation()!="true")
                                                        <td v-if="!import_engine_number" class="highlight">
                                                            <v-select label="name" @click.native="addIndex(index)" @input="addIndex(index), changeWingPrice(index)" v-model="(item.item==null)?null:item.item.code" :options="subItemes" @search="onItemSearchCode" placeholder="@lang('layout.Code')" style="">
                                                                @if(searchByImage()=="true")
                                                                <template #option="option">
                                                                    <span v-if="option.code_image"><img :src="imagePath+'/'+option.code_image" style="height: 40px;width:40px"> @{{option.name}} </span>
                                                                  </template>
                                                                  @endif
                                                            </v-select>
                                                            <input type="hidden" :name="'cost_roll['+index+']'" :value="(item.item==null)?null:((item.item.code==null)?null:item.item.code.per_price)">
                                                            <input type="hidden" :name="'cost['+index+']'" :value="(item.item==null)?null:((item.item.code==null)?null:item.item.code.cost)">
                                                            <input type="hidden" :name="'m_stocks_in_id['+index+']'" :value="(item.item==null)?null:((item.item.code==null)?null:item.item.code.id)">
                                                            <input type="hidden" :name="'main_stock_id['+index+']'" :value="(item.item==null)?null:((item.item.code==null)?null:item.item.code.main_stock_id)">
                                                            <span v-if='(item.item==null)?null:((item.item.code==null)?null:item.item.code.lengths == "duplicate")' class="required">@lang('layout.DuplicateData')</span>
                                                        </td>
                                                        @if(ImportEngineNumberByExcel()=="true")
                                                        <td v-if="import_engine_number">
                                                        <div class="input-group">
                                                            <input :name="'engine_number_file['+index+']'" type="file" class="form-control" placeholder="@lang('layout.EngineNumber')">
                                                        </div>
                                                        </td>
                                                        @endif
                                                        @endif
                                                        <td  v-show="showWhat('sale_description')=='yes'" class="purchase_description">
                                                            <input type="text" placeholder="@lang('layout.Description')" :name="'inventory_description['+index+']'" :value="(item.item==null)?null:((item.item.code==null)?null:item.item.code.description)" @input="setNewRate('inventory',index)" ref="description"  class="form-control">
                                                        </td>
                                                        @if(ImportEngineNumberByExcel()!="true")
                                                        <td  v-show="showWhat('sale_description2')=='yes'" class="purchase_description">
                                                            <input type="text" placeholder="@lang('layout.Description')" :name="'inventory_description2['+index+']'"  class="form-control">
                                                        </td>
                                                        @endif
                                                        @if(ImportEngineNumberByExcel()=="true")
                                                        <td v-if="!import_engine_number">
                                                            <div class="mt-checkbox" style="padding-left: 0px;">
                                                                <label class="mt-checkbox mt-checkbox-outline">
                                                                    <input type="checkbox" :name="'inventory_description2['+index+']'" value="yes" checked />
                                                                    <span></span>
                                                                </label>
                                                            </div>
                                                        </td>
                                                        @endif
                                                        @if(getCustomHouseLitter()=="true")
                                                         <td> 
                                                            <input type="text" :name="'custom_house_litter_number['+index+']'"    
                                                            oninput = "autowidths(event)" class="form-control input-style input-number chan_length" placeholder="@lang('layout.CustomHouseLitterNumber')">    
                                                        </td>
                                                         <td> 
                                                            <input type="text" :name="'province['+index+']'"    
                                                            oninput = "autowidths(event)" class="form-control input-style input-number chan_length" placeholder="@lang('layout.Province')">    
                                                        </td>
                                                         <td>  
                                                            <date_picker :name="'custom_house_litter_date['+index+']'" placeholder="@lang('layout.CustomHouseLitterDate')" ></date_picker>  
                                                        </td>
                                                        @endif
                                                        <td v-if="!import_engine_number">
                                                            <input type="number" :name="'inventory_quantity['+index+']'" v-validate="(item.item==null)?'':'required'" data-vv-as="@lang('layout.Quantity')" ref="qut_temp" @input="setNewRate('inventory',index), changeQuantityOfWing(index)" :value="(item.item==null)?null:((item.item.code==null)?null:item.item.code.qut_temp)"
                                                            oninput = "autowidths(event)" class="form-control input-style input-number chan_length" placeholder="@lang('layout.Quantity')">
                                                            <span class="required">@{{ errors.first('inventory_quantity['+index+']') }}</span>
                                                        </td>
                                                        <td v-if="import_engine_number">
                                                            <input type="number" :name="'inventory_quantity['+index+']'" v-validate="(item.item==null)?'':'required'" data-vv-as="@lang('layout.Quantity')" ref="inventory_qut" @input="setNewRate('inventory',index)" :value="(item.item==null)?null:item.item.quantity"
                                                            oninput = "autowidths(event)" class="form-control input-style input-number chan_length" placeholder="@lang('layout.Quantity')">
                                                            <span class="required">@{{ errors.first('inventory_quantity['+index+']') }}</span>
                                                        </td>
                                                        <td v-if='selected_sale_order != null'>
                                                            @{{myRound((item.item==null)?null:((item.item==null)?null:item.item.quantity_temp))}}
                                                        </td>
                                                        @if(systemConfig()[9] == 0 )
                                                        <td v-if='selected_sale_order != null'>
                                                            @{{myRound((item.item==null)?null:((item.item==null)?null:item.item.bundl))}}
                                                        </td>
                                                        @endif
                                                        <td v-if="!import_engine_number">
                                                            @{{myRound((item.item==null)?null:((item.item.code==null)?null:item.item.code.OnHand))}}
                                                        </td>
                                                        <td>
                                                            @{{myRound((item.item==null)?null:saleItemQuantity(item.item,((item.item.code==null)?item.item.quantity:item.item.code.qut_temp)))}}
                                                        </td>
                                                        @if(systemConfig()[21] == 1 || getCubicMetereItems()=="true")
                                                        <td>
                                                            <input :name="'widths['+index+']'" type="number" :value="(item.item==null)?null:((item.item.code==null)?null:item.item.code.width)" @input="setNewRate('inventory',index), changeMetraz(index)" ref="width" class="form-control" placeholder="@lang('layout.Width')">
                                                        </td>
                                                        <td>
                                                            <input :name="'lengths['+index+']'" type="number" :value="(item.item==null)?null:((item.item.code==null)?null:item.item.code.length)" @input="setNewRate('inventory',index), changeMetraz(index)" ref="length" class="form-control" placeholder="@lang('layout.Length')">
                                                        </td>
                                                        @endif
                                                        @if(getCubicMetereItems()=="true")
                                                        <td>
                                                            <input :name="'gauge['+index+']'" type="number" :value="(item.item==null)?null:((item.item.code==null)?null:item.item.code.gauge)" @input="setNewRate('inventory',index), changeMetrazByKhada(index)" ref="gauge" class="form-control" placeholder="@lang('layout.Gauge')">
                                                        </td>
                                                        @endif
                                                        <td v-show="showWhat('other_measure')=='yes'">
                                                            <div class="input-group">
                                                                <input type="number" name="other_measure[]"  @input="change_per_qty(index)" 
                                                                oninput = "autowidths(event)" class="form-control input-style input-number chan_length" placeholder="@lang('layout.OMeasureValue1')" v-model.number="(item.item==null)?null:item.item.other_measure">
                                                                <span v-if="!import_engine_number" class="input-group-addon">
                                                                    @{{myRound((item.item==null)?null:((item.item.code==null)?null:item.item.code.other_measure))}}
                                                                </span>
                                                            </div>
                                                        </td>
                                                        <td v-show="showWhat('other_measure2')=='yes'">
                                                            <div class="input-group">
                                                                <input type="number" name="other_measure2[]" 
                                                                oninput = "autowidths(event)" class="form-control input-style input-number chan_length" placeholder="@lang('layout.OMeasureValue2')" v-model.number="(item.item==null)?null:item.item.other_measure2">
                                                                <span v-if="!import_engine_number" class="input-group-addon">
                                                                    @{{myRound((item.item==null)?null:((item.item.code==null)?null:item.item.code.other_measure2))}}
                                                                </span>
                                                            </div>
                                                        </td>
                                                        <td class="highlight">
                                                            <select v-model="(item.item == null)?null:item.item.measure" class="form-control" @change="measureChange(index)">
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(item.item ==null)?false:true">
                                                                    <option v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure">
                                                                        @{{measure.measure_name}}
                                                                    </option>
                                                                </span>
                                                            </select>

                                                            <input type="hidden" :name="'inventory_measure['+index+']'" :value="(item.item==null)?null:item.item.measure.measure_id">
                                                        </td>
                                                        @if(getM2()!="")
                                                        @if(getFactorMeasure2()=="true")
                                                        <td>
                                                            <select :name="'measure1['+index+']'" class="form-control" v-model="(item.item==null)?null:item.item.measure1.measure_id">
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(item.item ==null)?false:true">
                                                                    <option v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure.measure_id">
                                                                        @{{measure.measure_name}}
                                                                    </option>
                                                                </span>
                                                            </select>
                                                        </td>
                                                        @endif
                                                        @endif
                                                        @if(getM3()!="")
                                                        @if(getFactorMeasure3()=="true")
                                                        <td>
                                                            <select :name="'measure2['+index+']'" class="form-control" v-model="(item.item==null)?null:item.item.measure2.measure_id">
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(item.item ==null)?false:true">
                                                                    <option v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure.measure_id">
                                                                        @{{measure.measure_name}}
                                                                    </option>
                                                                </span>
                                                            </select>
                                                        </td>
                                                        @endif
                                                        @endif

                                                        
                                                        @if(getM4()!="")
                                                        @if(getFactorMeasure4()=="true")
                                                        <td>
                                                            <select :name="'measure3['+index+']'" class="form-control" v-model="(item.item==null)?null:item.item.measure3.measure_id">
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(item.item ==null)?false:true">
                                                                    <option v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure.measure_id">
                                                                        @{{measure.measure_name}}
                                                                    </option>
                                                                </span>
                                                            </select>
                                                        </td>
                                                        @endif
                                                        @endif

                                                        @if(getSaleSubMeasure() =="true")
                                                        <td v-if="sub_price==true">
                                                            @{{myRound((item.item==null)?null:subMQuantity(index,item.item,((item.item.code==null)?null:item.item.code.qut_temp)))}}
                                                        </td>
                                                        <td v-if="sub_price==true">
                                                            <div class="input-group">
                                                                <input type="number" placeholder="@lang('layout.SubPrice')" v-model="(item.item==null)?null:item.sub_price" @input="setNewRateTotal(index)" oninput = "autowidths(event)" class="form-control chan_length">
                                                                <span class="input-group-addon">
                                                                    @{{selected_currency.symbol}}
                                                                </span>
                                                            </div>
                                                        </td>
                                                        @endif
  
                                                        @if(getSaleCommission()=="true")
                                                        <td>
                                                            <div class="input-group" v-show="!item.commission"> 
                                                                <input type="number" class="form-control chan_length" :name="'row_percent_commission_code['+index+']'" oninput = "autowidths(event)" v-model="item.row_commission_percent" />
                                                                <span class="input-group-addon" v-if="commissionIsAmount">
                                                                    @{{selected_currency.symbol}}
                                                                </span>
                                                                <span class="input-group-addon" v-if="!commissionIsAmount">
                                                                    %
                                                                </span>
                                                            <input type="hidden" :name="'row_commission_amount_code['+index+']'" :value="item.row_commission_amount" />
                                                        </div>
                                                        </td>
                                                        @endif  


                                                        @if(showLocation()=="true" && searchByCodeLocation()!="true")
                                                        <td >
                                                            @{{(item.item==null)?null:((item.item.code==null)?null:item.item.code.location)}}
                                                        </td>
                                                        @endif
                                                        @if(getShowWing()!="false")
                                                        <td v-if="!import_engine_number">
                                                            <input :name="'khada['+index+']'" type="number" :value="(item.item==null)?null:((item.item.code==null)?null:item.item.code.khada)" ref="khada" @input="setNewRate('inventory',index), changeQuantityByWing(index)"
                                                            oninput = "autowidths(event)" class="form-control chan_length" placeholder="@lang('layout.Wing')">
                                                        </td>
                                                        @if(ShowQuantityByWing() == "true")
                                                        <td v-if="!import_engine_number">
                                                            <input :name="'approx_weight['+index+']'" type="number" :value="(item.item==null)?null:((item.item.code==null)?null:item.item.code.approx_weight)" ref="approx_weight" @input="setNewRate('inventory',index), changeQuantityByWing(index)"
                                                            oninput = "autowidths(event)" class="form-control chan_length" placeholder="@lang('layout.ApproxWeight')">
                                                        </td>
                                                        <td v-if="!import_engine_number" v-show="quantityByWing">
                                                            <input :name="'price_of_khada['+index+']'" type="number" :value="(item.item==null)?null:((item.item.code==null)?null:item.item.code.price_of_khada)" ref="price_of_khada" @input="setNewRate('inventory',index), changePriceByWing(index)"
                                                            oninput = "autowidths(event)" class="form-control chan_length" placeholder="@lang('layout.Wing')">
                                                        </td>
                                                        <td v-if="!import_engine_number">
                                                            <input :name="'bundl['+index+']'" v-model="(item.item==null)?null:item.bundl" @input="changeKhadaByBundle(index)" type="number" oninput = "autowidths(event)" class="form-control chan_length" placeholder="@lang('layout.Bundl')">
                                                        </td>
                                                        @endif
                                                        @endif
                                                        @if(systemConfig()[21] == 1)
                                                        <td>
                                                            <input :name="'unit_price['+index+']'" type="number" :value="(item.item==null)?null:((item.item.code==null)?null:RateUnitPrice(item.item.code.unit_price,selected_currency.rate, selected_currency.static_rate))" @input="setNewRate('inventory',index), changeCost(index)" ref="unit_price" class="form-control" placeholder="@lang('layout.UnitPrice')" >
                                                        </td>
                                                        @endif

                                                        @if(getSaleCodePricePercentage() == 'true')
                                                        <td>
                                                            <input :name="'add_percentage['+index+']'" type="number" :value="(item.item==null)?null:item.item.add_percentage" @input="changePriceByPercentage(index)" ref="add_percentage" class="form-control" placeholder="@lang('layout.Percentage')" >
                                                        </td>
                                                        @endif
                                                        <td v-show="seeCost==true">
                                                            @{{(item.item==null)?null: myRound((item.item.cost * item.item.measure.measure_unit / item.item.measure_unit))}}
                                                        </td>
                                                        @if(systemConfig()[30] == 1)
                                                        <td v-show="seeCost==true">
                                                            @{{(item.item==null)?null: myRound((item.item.cost * item.item.measure.measure_unit / item.item.measure_unit) * selected_currency.static_rate / selected_currency.rate)}}
                                                        </td>
                                                        @else 
                                                        <td v-show="seeCost==true">
                                                            @{{(item.item==null)?null: myRound((item.item.cost * item.item.measure.measure_unit / item.item.measure_unit)*selected_currency.rate)}}
                                                        </td>
                                                        @endif
                                                        <td>
                                                            <vue-numeric v-if="item.item"
                                                                class="form-control chan_length"
                                                                oninput = "autowidths(event)"
                                                                v-model="item.item.temp_price"
                                                                :max="99999999999999"
                                                                currency=""
                                                                :precision="((quantityByWing)?7:precision())"
                                                                @input="setNewRate('inventory',index), changePriceOfWing(index)"
                                                                >
                                                            </vue-numeric>
                                                            <input type="hidden" :name="'inventory_price['+index+']'"  data-vv-as="@lang('layout.Price')" placeholder="@lang('layout.Price')" v-bind:value="(item.item==null)?null:saleNewRateCode(item.item,selected_currency.rate,((quantityByWing)?7:precision()),selected_currency.static_rate)"
                                                                ref="in" class="form-control">
                                                            <span class="required">@{{ errors.first('inventory_price['+index+']') }}</span>
                                                            <span v-show="((item.item==null)?null:checkCheapCode(item.item,selected_currency.rate,selected_currency.static_rate))==true" class="required">@lang('layout.SalesToTheDetriment')</span>
                                                        </td>
                                                        <td v-show="showWhat('sale_discount')=='yes'">
                                                            <div class="input-group">
                                                                <input type="number" name="inventory_discount[]" placeholder="@lang('layout.Discount')" v-model.number="(item.item==null)?null:item.item.discount" oninput = "autowidths(event)" class="form-control chan_length">
                                                                <span class="input-group-addon" v-if="discountIsAmount">
                                                                    @{{selected_currency.symbol}}
                                                                </span>
                                                                <span class="input-group-addon" v-if="!discountIsAmount">
                                                                    %
                                                                </span>
                                                            </div>
                                                        </td>
                                                        <td v-show="seePrice==true">
                                                            @{{(item.item==null)? 0:getItemTotalRollRow(item,selected_currency.rate,per_qty_check,item.item.discount,discountIsAmount, selected_currency.static_rate)}}
                                                            @{{selected_currency.symbol}}
                                                        </td>
                                                        <td>
                                                            <span v-if="inventories.length>1" v-on:click="deleteItem('inventory',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>

                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                            <hr/>
                                            <!-- begin service -->
                                            @if(systemConfig()[26] == 1)
                                            <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                                                <thead>
                                                    <tr>
                                                        <th class="text-center" style="min-width: 8px;"> #</th>
                                                        <th class="text-center" style="min-width: 160px;">@lang('layout.ServiceName')</th>
                                                        <th v-show="showWhat('sale_description')=='yes'">@lang('layout.Description') </th>
                                                        <th v-show="showWhat('sale_description2')=='yes'">@lang('layout.Description') :2 </th>
                                                        <th class="text-center" style="min-width: 160px;">@lang('layout.Quantity')</th>
                                                        <th class="text-center" style="min-width: 160px;">@lang('layout.Measure')</th>
                                                        <th class="text-center" style="min-width: 160px;">@lang('layout.Price')</th>
                                                        <th class="text-center" style="min-width: 120px;">@lang('layout.Total')</th>
                                                        <th></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr v-for="(service,index) in services">
                                                        <td>@{{index+1}}</td>
                                                        <td class="highlight">
                                                            <v-select label="name" v-model="service.item" :options="(service.items)" @click.native="addNew('service',index)" @input="checkExistingService(index)">
                                                            </v-select>
                                                            <input type="hidden" name="sale_order_service_id[]" :value="(service.item==null)?null:service.item.sale_order_service_id">
                                                            <input type="hidden" name="service_id[]" :value="(service.item==null)?null:service.item.id">
                                                        </td>
                                                        <td v-show="showWhat('sale_description')=='yes'">
                                                            <input type="text" placeholder="@lang('layout.Description')" name="service_description[]" v-model="(service.item==null)?null:service.item.description" class="form-control">
                                                        </td>
                                                        <td v-show="showWhat('sale_description2')=='yes'">
                                                            <input type="text" placeholder="@lang('layout.Description')" name="service_description2[]" v-model="(service.item==null)?null:service.item.description2" class="form-control">
                                                        </td>
                                                        <td>
                                                            <input class="form-control" name="service_quantity[]" v-model.number="(!service.item)?null:service.item.quantity" placeholder="@lang('layout.Quantity')">
                                                        </td>
                                                        <td class="highlight">
                                                            <select v-model="(service.item == null)?null:service.item.measure" class="form-control" @change="measureChangeservice(index)">
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(service.item ==null)?false:true">
                                                                    <option v-for="measure in (service.item==null)?null:service.item.measure_list" :value="measure">
                                                                        @{{measure.measure_name}}
                                                                    </option>
                                                                </span>
                                                            </select>
                                                            <input type="hidden" name="service_measure[]" :value="(service.item==null)?null:service.item.measure.measure_id">
                                                        </td>
                                                        <td>
                                                            <div class="input-group">
                                                                <input type="number" name="service_price[]" placeholder="@lang('layout.Price')" :value="(service.item==null)?null:saleNewRate(service.item,selected_currency.rate, null, selected_currency.static_rate)" ref="ser" @input="setNewRate('service',index)" class="form-control">
                                                                <span class="input-group-addon">
                                                                    @{{selected_currency.symbol}}
                                                                </span>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <div class="input-group">
                                                                <input type="number" class="form-control inner_input" :value="(service.item==null)?null:getItemTotalService(service.item,selected_currency.rate, null, selected_currency.static_rate).result" placeholder="@lang('layout.Total')" disabled>
                                                                <span class="input-group-addon">
                                                                    <b>@{{selected_currency.symbol}}</b>
                                                                </span>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <span v-on:click="deleteItem('service',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                            @endif
                                            <!-- end service -->
                                            <hr>
                                            <!-- begin payments -->
                                            @permission('receive-create')
                                            <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                                                <thead>
                                                    <tr>
                                                        <th class="text-center" style="min-width: 8px;"> #</th>
                                                        <th class="text-center" style="min-width: 160px;">@lang('layout.SelectBank')</th>
                                                        <th class="text-center" style="min-width: 100px;"> @lang('layout.Amount')</th>
                                                        <th class="text-center" style="min-width: 120px;"> @lang('layout.Rate')</th>
                                                        <th class="text-center" style="min-width: 80px;">@lang('layout.Currency')</th>
                                                        <th class="text-center" style="min-width: 80px;"> @lang('layout.Amount')</th>
                                                        <th class="text-center" style="min-width: 120px;">@lang('layout.Total')</th>
                                                        <th class="text-center" style="min-width: 120px;">@lang('layout.Description')</th>
                                                        <th></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr v-for="(payment,index) in payments">
                                                        <td>@{{index+1}}</td>
                                                        <td class="highlight">
                                                            <v-select label="name" v-model="payment.item" :options="(payment.items)" @click.native="addNew('payment',index)" @input="checkExistingPayment(index)">
                                                            </v-select>
                                                            <input type="hidden" name="payment_id[]" :value="(payment.item==null)?null:payment.item.id">
                                                        </td>
                                                        <td>
                                                            <span v-if="payment.item !=null">
                                                                @{{myRound(Number((payment.item==null)?null:payment.item.balance)+Number((payment.item==null)?null:payment.item.amount))}}
                                                            </span>
                                                        </td>
                                                        <td>
                                                            <input v-bind:disabled="(payment.item==null)?false:(payment.item.code =='{{getHomeCurrency()["code"]}}')" type="number" v-model.number="(payment.item==null)?null:payment.item.rate " class="form-control" placeholder="@lang('layout.Rate')" />
                                                            <input v-if="payment.item !=null" type="hidden" name="payment_rate[]" v-bind:value="payment.item.rate">
                                                        </td>
                                                        <td>
                                                            <input type="text" name="payment_currency[]" class="form-control" v-model="(payment.item==null)?null:payment.item.code" placeholder="@lang('layout.Currency')" disabled reqiured />
                                                            <input v-if="payment.item !==null" type="hidden" name="payment_currency[]" v-bind:value="payment.item.code" />
                                                        </td>
                                                        <td>
                                                            <vue-numeric v-if="payment.item"
                                                                class="form-control"
                                                                v-model="payment.item.amount"
                                                                :max="99999999999999"
                                                                :currency="payment.item.code"
                                                                :precision="precision()"
                                                                >
                                                            </vue-numeric>
                                                            <input v-if="payment.item !=null" type="hidden" name="payment_amount[]" v-bind:value="payment.item.amount">
                                                        </td>
                                                        <td>
                                                            <div class="input-group">
                                                                {{-- <input type="number" class="form-control" :value="(payment.item==null)?null:totalPayments(payment.item,selected_currency.rate)" placeholder="@lang('layout.Total')" style="min-width: 100px" /> --}}
                                                                <input type="number"  @input="changePaymentRate(index)" ref="total_payment" step="any" v-bind:value="(payment.item==null)?null:totalPayment(payment.item,selected_currency.rate,selected_currency.hq_rate, selected_currency.static_rate).result" class="form-control">
                                                                <span class="input-group-addon">@{{selected_currency.symbol}}</span>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <textarea class="form-control" name="receive_description[]" rows="2" placeholder="@lang('layout.Description')">@{{(payment.item==null)?null:payment.item.description}}</textarea>
                                                        </td>
                                                        <td>
                                                            <span v-on:click="deleteItem('payment',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                            @endpermission
                                            <!-- end payments -->
                                            <hr>
                                            <!--Begin Transfer Rent-->
                                            @if(getTransferRent()=="true")
                                            <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                                                <thead>
                                                    <tr>
                                                        <th colspan="10" style="min-width: 100px;">@lang('layout.TransferRent')</th>
                                                    </tr>
                                                    <tr>
                                                        <th class="text-center" style="min-width: 160px;">@lang('layout.Type')</th>
                                                        <th class="text-center" style="min-width: 160px;">@lang('layout.Transmitter')</th>
                                                        <th class="text-center" style="min-width: 160px;" v-show="transfer_rent_type=='cash'">@lang('layout.SelectBank')</th>
                                                        <th class="text-center" style="min-width: 80px;" >@lang('layout.Currency')</th>
                                                        <th class="text-center" style="min-width: 120px;" > @lang('layout.Rate')</th>
                                                        <th class="text-center" style="min-width: 80px;"> @lang('layout.Amount')</th>
                                                        <th class="text-center" style="min-width: 120px;">@lang('layout.Description')</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr>
                                                        <td>
                                                            <select class="form-control" name="transfer_rent_type" v-model="transfer_rent_type">
                                                                <option value="cash">@lang('type.cash')</option>
                                                                <option value="credit">@lang('type.credit')</option>
                                                            </select>
                                                        </td>
                                                        <td>
                                                            <v-select label="name"  @search="VendorSearch" :options="transfer_rent_vendor" v-model="transfer_rent_vendor_selected"></v-select>
                                                            <input type="hidden" name="transfer_rent_vendor" :value="!transfer_rent_vendor_selected?null:transfer_rent_vendor_selected.id">
                                                        </td>
                                                        <td class="highlight" v-show="transfer_rent_type=='cash'">
                                                            <v-select label="name" v-model="transfer_rent_bank_selected" :options="banks">
                                                            </v-select>
                                                            <input type="hidden" v-if="transfer_rent_bank_selected !=null" name="transfer_rent_bank" :value="(transfer_rent_bank_selected==null)?null:transfer_rent_bank_selected.id">
                                                        </td>
                                                        <td v-if="transfer_rent_type=='cash'">
                                                            <input type="text" name="transferRent_currency[]" class="form-control" v-model="(transfer_rent_bank_selected==null)?null:transfer_rent_bank_selected.code" placeholder="@lang('layout.Currency')" disabled reqiured />
                                                            <input v-if="transfer_rent_bank_selected !==null" type="hidden" name="transfer_rent_currency" v-bind:value="transfer_rent_bank_selected.code" />
                                                        </td>
                                                        <td v-if="transfer_rent_type=='cash'">
                                                            <input v-bind:disabled="(transfer_rent_bank_selected==null)?false:(transfer_rent_bank_selected.code =='{{getHomeCurrency()['code']}}')" type="number" v-model.number="(transfer_rent_bank_selected==null)?null:transfer_rent_bank_selected.rate " class="form-control" placeholder="@lang('layout.Rate')" />
                                                            <input v-if="transfer_rent_bank_selected !=null" type="hidden" name="transfer_rent_rate" v-bind:value="transfer_rent_bank_selected.rate">
                                                        </td>
                                                        <td v-if="transfer_rent_type=='credit'">
                                                            <v-select label="code" :options="currency1" v-model="selected_transfer_currency" auto></v-select>
                                                            <input type="hidden" name="transfer_rent_currency" v-validate="''" data-vv-as="@lang('layout.Currency')" :value="!selected_transfer_currency?'':selected_transfer_currency.code">
                                                        </td>
                                                        <td v-if="transfer_rent_type=='credit'">
                                                            <input type="number" name="transfer_rent_rate" v-validate="''" data-vv-as="@lang('layout.Rate')" v-model="!selected_transfer_currency?0:selected_transfer_currency.rate" class="form-control" >
                                                        </td>
                                                        <td>
                                                            <div class="input-group">
                                                                <input  type="number" name="transfer_rent_amount" class="form-control" placeholder="@lang('layout.PayAmount')">
                                                                <span  v-show="transfer_rent_type=='cash'" class="input-group-addon">@{{(transfer_rent_bank_selected==null)?null:transfer_rent_bank_selected.code}}</span>
                                                                <span  v-show="transfer_rent_type=='credit'" class="input-group-addon">@{{selected_currency.symbol}}</span>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <textarea class="form-control" name="transfer_rent_description" rows="2" placeholder="@lang('layout.Description')"></textarea>
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                            <hr>
                                            @endif
                                            <!--End Transfer Rent-->
                                        </div>
                                        @if(getInvoiceTotal() == 'true')
                                        <!-- begin total -->
                                        <!-- <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                            <div class="dashboard-stat2 " v-show="seePrice== true">
                                                <table class="dashboard-tabel" width="100%">
                                                    <tr>
                                                        <td>
                                                            <small>@lang('layout.GrandTotal'):</small>
                                                        </td>
                                                        <td class="text-right">
                                                            <span class="text-right" data-counter="counterup" data-value="7800">
                                                                @{{ subtotal.toFixed(precision())}}
                                                            </span>
                                                            <small class="font-green-sharp">
                                                                @{{selected_currency.symbol}}
                                                            </small>
                                                        </td>
                                                        <td>
                                                            <small>@lang('layout.Payment'):</small>
                                                        </td>
                                                        <td class="text-right">
                                                            <small class="font-green-sharp">
                                                                <span class="text-right" data-counter="counterup" data-value="7800">
                                                                    @{{ payeds.toFixed(precision())}}
                                                                </span>
                                                                <small class="font-green-sharp">
                                                                    @{{selected_currency.symbol}}
                                                                </small>
                                                            </small>
                                                        </td>
                                                        <td>
                                                            <small>@lang('layout.Discount'): (@{{
                                                                        Number.parseFloat(discount).toFixed(precision())
                                                                        }}%)
                                                            </small>
                                                        </td>
                                                        <td class="text-right">
                                                            <span class="text-right" data-counter="counterup" data-value="7800">
                                                                @{{ format_number(Number.parseFloat(discount*(newSubTotal - newSubDiscountFiledRow)/100)+Number.parseFloat(discountFiledRow)) }}
                                                            </span>
                                                            <small class="font-green-sharp">
                                                                @{{selected_currency.symbol}}
                                                            </small>
                                                        </td>
                                                        <td>
                                                            <small>@lang('layout.Total') :</small>
                                                        </td>
                                                        <td class="text-right"><span data-counter="counterup" data-value="7800">
                                                                @{{ format_number(Number.parseFloat(((subtotal - (discount*(newSubTotal - newSubDiscountFiledRow)/100) - discountFiledRow) - saleTaxation)-payeds))}}
                                                            </span>
                                                            <small class="font-green-sharp">
                                                                @{{selected_currency.symbol}}
                                                            </small>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </div>
                                        </div> -->
                                        <div class="row dashboard-stat2 " style="overflow-x: scroll;" >
                                            <table class="dashboard-tabel" width="100%">
                                                <tr>
                                                    <td>
                                                        <small>@lang('layout.Total') :</small>
                                                    </td>
                                                    <td class="text-right"><span data-counter="counterup" data-value="7800">@{{ Number.parseFloat((subtotal - (discount*subtotal/100))-payeds).toFixed(precision())}}</span>
                                                        <small class="font-green-sharp">
                                                            @{{selected_currency.symbol}}
                                                        </small>
                                                    </td>
                                                    <td>
                                                        <small>@lang('layout.Discount'): (@{{
                                                                Number.parseFloat(discount).toFixed(precision())
                                                                }}%)
                                                        </small>
                                                    </td>
                                                    <td class="text-right">
                                                        <span class="text-right" data-counter="counterup" data-value="7800">@{{ Number.parseFloat(discount*subtotal/100).toFixed(precision()) }}</span>
                                                        <small class="font-green-sharp">
                                                            @{{selected_currency.symbol}}
                                                        </small>
                                                    </td>
                                                    <td>
                                                        <small>@lang('layout.Payment'):</small>
                                                    </td>
                                                    <td class="text-right">
                                                        <small class="font-green-sharp">
                                                            <span class="text-right" data-counter="counterup" data-value="7800">@{{ payeds.toFixed(precision())}}</span>
                                                            <small class="font-green-sharp">
                                                                @{{selected_currency.symbol}}
                                                            </small>
                                                        </small>
                                                    </td>
                                                    <td>
                                                        <small>@lang('layout.Sub-Total'):</small>
                                                    </td>
                                                    <td class="text-right">
                                                        <span class="text-right" data-counter="counterup" data-value="7800">@{{ subtotal.toFixed(precision())}}</span>
                                                        <small class="font-green-sharp">
                                                            @{{selected_currency.symbol}}
                                                        </small>
                                                    </td>
                                                    <td>
                                                        <small>@lang('layout.TotalQuantity'):</small>
                                                    </td>
                                                    <td class="text-right">
                                                        <span class="text-right" data-counter="counterup" data-value="7800">@{{ subtotalQty }}</span>
                                                        <small class="font-green-sharp">
                                                        </small>
                                                    </td>
                                                </tr>
                                            </table>
                                        </div>
                                        <!-- end total -->
                                        @endif
                                        <div class="row">
                                        @if(getWhatsApp() =='true')                   
                                            <!-- <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    <div class="col-md-12">
                                                        <label class="control-label"> <span class="fa fa-whatsapp" style="color:green;"></span> @lang('layout.Whatsapp')</label>
                                                        <label class="mt-checkbox mt-checkbox-outline">
                                                            <input type="checkbox"  name="whatsapp" value="2" />
                                                            <span></span>
                                                        </label>
                                                    </div>
                                                </div>
                                            </div> -->
                                        @endif
                                        </div>
                                        @if(getInstallments()=="true") 
                                        <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                                            <thead>
                                                <tr>
                                                    <th>@lang('layout.Installments')</th>
                                                </tr>
                                                <tr>
                                                    <th class="text-center" style="min-width: 8px;"> #</th>
                                                    <th class="text-center" style="min-width: 160px;">@lang('layout.Amount')</th>
                                                    <th class="text-center" style="min-width: 80px;">@lang('layout.Currency')</th>
                                                    <th class="text-center" style="min-width: 80px;"> @lang('layout.DueDate')</th>
                                                    <th class="text-center" style="min-width: 120px;">@lang('layout.Description')</th>
                                                    <th></th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr v-for="(installment,index) in installments">
                                                    <td>@{{index+1}}</td>
                                                    <td class="highlight">
                                                        <input type="text" @click="addNew('installment',index)"
                                                            name="installment_amount[]" class="form-control" autocomplete="off" tabindex="1">
                                                    </td> 
                                                    <td class="highlight">
                                                        <v-select label="name" v-model="installment.item" :options="(installment.items)">
                                                        </v-select>
                                                        <input type="hidden" name="installment_currency[]" :value="(installment.item==null)?null:installment.item.code">
                                                    </td>
                                                    <td>
                                                        <date_picker :name="'installment_due_date['+index+']'"  ></date_picker>
                                                    </td>
                                                    <td class="highlight">
                                                        {{Form::textarea('installment_description[]',null,['class' => 'form-control','rows' => '1','@click'=>"addNew('installment',index)",'@keyup'=>"addNew('installment',index)"])}}
                                                        </td>
                                                    <td>
                                                        <span v-on:click="deleteItem('installment',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                                    </td>
                                                </tr>
                                            </tbody>
                                        </table>
                                        <!-- end installment -->
                                        @endif
                                        <div class="row" style="margin-top: 20px;">
                                            <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                <table class="table table-striped table-bordered table-advance ">
                                                    <tr>
                                                        <td class="t_body">
                                                            <div>
                                                                <label class="">@lang('layout.PrintFactor') </label>
                                                                    <select name="print_factor_type" id="" class="form-control">
                                                                        <option value=""> @lang('layout.Select') </option>
                                                                        <option value="A4">A4</option>
                                                                        <option value="A5">A5</option>
                                                                    </select>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    <div class="col-md-12">
                                                        <label class="control-label">@lang('layout.Memo')</label>
                                                        <textarea name="memo" class="form-control" rows="2"></textarea>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            @if(getInvoicTypeCode() == 6)
                                            <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                <div class="col-md-12 form-group">
                                                    <label class=" control-label">@lang('layout.NotShowPrice')</label>
                                                    <div class="col-md-12 mt-checkbox">
                                                        <label class="mt-checkbox mt-checkbox-outline">
                                                            <input type="checkbox" name="show_price" value="off">
                                                            <span></span>
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                <div class="col-md-12 form-group">
                                                    <label class=" control-label">@lang('layout.NotShowApproxWeight')</label>
                                                    <div class="col-md-12 mt-checkbox">
                                                        <label class="mt-checkbox mt-checkbox-outline">
                                                            <input type="checkbox" name="show_approx_weight" value="off">
                                                            <span></span>
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                            @endif  
                                            <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                <div class="col-md-12 form-group">
                                                    <label class=" control-label">@lang('layout.NotShowQuantity')</label>
                                                    <div class="col-md-12 mt-checkbox">
                                                        <label class="mt-checkbox mt-checkbox-outline">
                                                            <input type="checkbox" name="show_qty_factor" value="off">
                                                            <span></span>
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>   
                                        </div>
                                    </div>
                                    <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                                        <button type="button" v-if="((!isError) && (number_Error == false))" @click="handleSubmit($event)" :disabled="disabled" class="btn green">@lang('layout.Submit')</button>
                                        <button type="button" v-if="((!isError) && (number_Error == false))" class="btn blue" :disabled="disabled" @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button>
                                        <a href="{{route('invoice_roll.index')}}"  @click="clearTemp" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                                    </div>
                                    <cmodal :show='showModal' @close="showModal=false">
                                    </cmodal>
                                </div>
                            </div>
                            {!! Form::close() !!}
                        </div>
                    </div>
                </div>
                <p> &nbsp; </p>
                <p> &nbsp; </p>
            </div>
        </div>
        <!-- END TAB PORTLET-->
    </div>
</div>
@endsection
@push('scripts')
<script src="{{URL::asset('assets/global/plugins/bootstrap-timepicker/js/bootstrap-timepicker.min.js')}}" type="text/javascript"></script>
<script src="{{URL::asset('assets/pages/scripts/components-date-time-pickers.min.js')}}" type="text/javascript"></script>
<script type="text/javascript">
    @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
    Vue.use(VeeValidate, {
        locale: 'en',
    });
    @endif

    Vue.use(VueInputAutowidth);
    Vue.use(VueNumeric.default);
    Vue.component('v-select', VueSelect.VueSelect);

    Vue.component("modal", {
        template: "#modal-template",
        props: ['show'],

    });

    //begin new member
    Vue.component("cmodal", {
        template: '#cmodal-template',

        props: ['show'],
        data() {
            return {
                types: [],
                classes: [],
                receivables: [],
                payables: [],
                code: null,
                bundl: null,
                sub_price: null,
                selectType: null,
                selectPay: null,
                selectedClass: null,
                selectReceive: null,
            }
        },
        created() {

            axios.get('{{route("customer.create")}}').then(
                response => {
                    this.types = response.data.types;
                    if (this.types) {
                        for (var i = 0; i < this.types.length; i++) {
                            if (this.types[i].type == "Customer") {
                                this.selectType = this.types[i];
                            }
                        }
                    }
                    this.receivables = response.data.receivable;
                    this.payables = response.data.payable;
                    this.code = response.data.code;
                    this.classes = response.data.member_class;
                    if (this.receivables.length > 0) {
                        this.selectReceive = this.receivables[0];
                    }
                    if (this.payables.length > 0) {
                        this.selectPay = this.payables[0];
                    }


                }).catch(error => console.log(error));
        },
        methods: {
           
            onSubmit() {

                v.showModal = false;
                //this.member.type = this.member.type.id;
                var datas = $("#modalForm").serializeArray();
                $.ajax({
                    headers: {
                        'X-CSRF-TOKEN': "{{csrf_token()}}"
                    },
                    url: '{{route("customer.store")}}',
                    method: 'post',
                    data: {
                        "name": datas[0]['value'],
                        'code': datas[1]['value'],
                        'email': datas[2]['value'],
                        'phone': datas[3]['value'],
                        'address1': datas[4]['value'],
                        'type': this.selectType.id,
                        'receivable': this.selectReceive.id,
                        'payable': this.selectPay.id,
                        'class': (this.selectedClass) ? this.selectedClass.id : null
                    },
                    dataType: 'json',

                }).done(function(response) {
                    if (response) {
                        v.selected_customer = response.customer;
                    }
                }).fail(function(error) {
                    console.log('error', error);
                });

            }
        }
    });

    // end new member

    function callSaveTemp() {
        @if(saveTempData() == 'true')
        setTimeout((function() {
            v.saveTemp();
        // console.log(12);
        }), 4e4)
        @endif
    }

    var seePrice ={!! $seePrice !!};
    var seeCost ={!! $seeCost !!};
    var currency ={!! $currency !!};
    var currency1 ={!! $currency !!};
    var banks = {!! $banks !!};
    var all_services = {!! $all_services !!};
    var transportCompany = {!! $transportCompany !!};
    var allDrivers               = {!! $allDrivers !!};
    var inventory_category = {!! $inventory_category !!};
    var inventoryBrand = {!! $inventoryBrand !!};
    var memberClass    = {!! $memberClass !!};
    var saleArea       = {!! $saleArea !!};
    var discountDate       = {!! $discountDate !!};
    var commission       = {!! $commission !!};
    var imagePath = "{{url('uploads/codes/')}}";

    var v = new Vue({
        el: '#appInvoice',
        data: {
            dynamic_time:'',
            number: "{{$number}}",
            number_msg: '',
            msg: '',
            ref_no: '',
            isError1: false,
            editKey: false,
            number_Error: false,
            discount_date: discountDate,
            commission: commission,
            selected_commission: null,
            sum_commission:0,
            subTotalCommi:0,
            commissionIsAmount: false,
            commissionFiled: 0,
            selected_discount_date: null,
            seeCost: seeCost,
            import_engine_number: false,
            showModalSaleOrder: false,
            showModal: false,
            showInfoModal: false,
            disabled: false,
            sub_price: true,
            all_customer: [],
            memberClass: memberClass,
            selected_class: null,
            saleArea: saleArea,
            selected_area: null,
            brand: null,
            location: null,
            cost: null,
            SNumber: null,
            date: null,
            overdue_date: null,
            totalCommi:0,
            cheap: false,
            cheap_main: false,
            invoiceDescription: null,
            saleOrderList: [],
            selected_sale_order: null,
            other_member_name: null,
            setDatas: [],
            customer: [],
            selected_customer: null,
            member_id: null,
            banks: banks,
            all_services: all_services,
            selected_banks: null,
            currency: currency,
            selected_currency: {!!json_encode(getHomeCurrency()) !!},
            currency1: currency1,
            selected_transfer_currency: defaultCurrency(),
            rate: 0,
            discountFiled: 0,
            selectedIndex: 0,
            discountIsAmount: false,
            discountFiledRow: 0,
            subDiscountFiledRow: 0,
            newSubDiscountFiledRow: 0,
            newSubTotal: 0,
            per_qty_check: false,
            quantityByWing: false,
            temp_items: [],
            temp_main_items: [],
            totalAmountes: [],
            inventory_category: inventory_category,
            types: null,
            totalCos: 0,
            newCost: [
                null,
                null,
                null,
                null
            ],
            brandItem: inventoryBrand,
            brandItems: [],
            subItems: [],
            subItemes: [],
            codeList: [],
            locationList: [],
            ItemRoll: [{
                selected_sub_item: null,
            }, ],
            inventories: [{
                item: null,
                selectedBrand: null,
                selectedLocation: null,
                code: null,
                bundl: null,
                sub_price: null,
                commission: 'on',
                row_commission_percent: null,
                row_commission_amount: null,
            }],
            main_inventories: [{
                    item: null,
                    commission: 'on',
                    row_commission_percent: null,
                    row_commission_amount: null,
                },
                {
                    item: null,
                    commission: 'on',
                    row_commission_percent: null,
                    row_commission_amount: null,
                }
            ],
            services: [{
                    items: all_services,
                    item: null,
                },
                {
                    items: all_services,
                    item: null,
                },
            ],
            payments: [],
            installments: [],
            CusTypes: null,
            transportCompany: transportCompany,
            allDrivers: allDrivers,

            selected_transportCompany: null,
            selected_transportDriver: null,
            t_drivers: allDrivers,
            summary: [],
            last_item_sale: null,
            transferRent: [],
            transfer_rent_vendor:[],
            transfer_rent_vendor_selected:null,
            transfer_rent_bank_selected:null,
            transfer_rent_type :null,
            imagePath:imagePath
        },
        computed: {
            selectedRate() {
                if (this.selected_currency) {
                    var newrate = (this.selected_currency) ? this.selected_currency.rate : 0;
                    if (this.discountIsAmount && this.discountFiled && this.rate > 0 && newrate > 0 && this.rate != newrate) {
                        this.discountFiled = ((this.discountFiled / this.rate) * newrate);
                    }
                    this.rate = (this.selected_currency) ? this.selected_currency.rate : 0;

                    for (var i = 0; i < this.main_inventories.length; i++) {
                        if (this.main_inventories[i].item && this.main_inventories[i].item != null) {
                            if (this.main_inventories[i].item.new_rate) {
                                @if(systemConfig()[30] == 1)
                                this.main_inventories[i].item.cost = this.main_inventories[i].item.new_rate * this.selected_currency.static_rate / this.selected_currency.rate;
                                @else 
                                this.main_inventories[i].item.cost = this.main_inventories[i].item.new_rate * this.selected_currency.rate;
                                @endif
                            }
                        }
                    }

                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].item && this.inventories[i].item != null) {
                            if (this.inventories[i].item.code != null) {
                                if (this.inventories[i].item.code.price != null && Number.parseFloat(this.inventories[i].item.code.price) > 0) {
                                    @if(systemConfig()[30] == 1)
                                    this.inventories[i].item.temp_price = this.inventories[i].item.code.price * this.selected_currency.static_rate / this.selected_currency.rate;
                                    @else 
                                    this.inventories[i].item.temp_price = this.inventories[i].item.code.price * this.selected_currency.rate;
                                    @endif
                                } else {
                                    if (this.inventories[i].item.new_rate) {
                                        @if(systemConfig()[30] == 1)
                                        this.inventories[i].item.temp_price = this.inventories[i].item.new_rate * this.selected_currency.static_rate / this.selected_currency.rate;
                                        @else 
                                        this.inventories[i].item.temp_price = this.inventories[i].item.new_rate * this.selected_currency.rate;
                                        @endif
                                    }
                                }
                            } else {
                                if (this.inventories[i].item.new_rate) {
                                    @if(systemConfig()[30] == 1)
                                    this.inventories[i].item.temp_price = this.inventories[i].item.new_rate * this.selected_currency.static_rate / this.selected_currency.rate;
                                    @else 
                                    this.inventories[i].item.temp_price = this.inventories[i].item.new_rate * this.selected_currency.rate;
                                    @endif
                                }
                            }
                        }
                    }
                }
            },
            discount() {
                if (this.discountIsAmount) {

                    if (this.subtotal > 0 && this.discountFiled) {
                        return (parseFloat(this.discountFiled) * 100) / (this.subtotal - this.discountFiledRow);
                    } else {
                        return 0;
                    }
                } else {

                    return this.discountFiled
                }

            }, 

            // calculate subtotal
            subtotal: function() {
                var sum = 0;
                var sumRoll = 0;
                var sum_discount = 0;
                var sum_commission = 0;  
 
                for (var i = 0; i < this.inventories.length; i++) {
                    // console.log(33,this.inventories[i]);
                    if (this.inventories[i].item) {
                        var discount = this.inventories[i]['item']['discount'];
                        if (this.inventories[i].item.code != null) {
                            var quantity = this.inventories[i]['item']['code']['qut_temp'];
                            if (this.inventories[i]['item']['other_measure'] > 0 && this.per_qty_check) {
                                quantity = this.inventories[i]['item']['other_measure'];
                            }
                            var rate = this.inventories[i]['item']['rate'];
                            var new_rate = this.inventories[i]['item']['new_rate'];
                            var smeasure_unit = this.inventories[i]['item']['measure']['measure_unit'];
                            var measure_unit = this.inventories[i]['item']['measure_unit'];
                            var selected_row_commission = this.inventories[i]['row_commission_percent'];
                            if (new_rate != rate && quantity > 0) {
                                @if(systemConfig()[30] == 1)
                                sum += new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate;
                                @else 
                                sum += new_rate * quantity * this.selected_currency.rate;
                                @endif
                                @if(systemConfig()[30] == 1)
                                sumRoll += new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate;
                                @else 
                                sumRoll += new_rate * quantity * this.selected_currency.rate;
                                @endif
                                if (this.discountIsAmount) {
                                    if (discount > 0) {
                                        sum_discount += (discount * quantity);
                                    }
                                } else {
                                    if (discount > 0) {
                                        @if(systemConfig()[30] == 1)
                                        sum_discount += (parseFloat(discount) * (new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate)) / 100;
                                        @else 
                                        sum_discount += (parseFloat(discount) * (new_rate * quantity * this.selected_currency.rate)) / 100;
                                        @endif
                                    }
                                } 
 
 
                            if (this.commissionIsAmount) {
                            if (this.selected_commission && !this.inventories[i].commission && selected_row_commission > 0) {
                                sum_commission += (quantity * selected_row_commission);
                                this.inventories[i]['row_commission_amount'] = (quantity * selected_row_commission);
                            }
                            }else{
                            if (this.selected_commission && !this.inventories[i].commission && selected_row_commission > 0) {
                                @if(systemConfig()[30] == 1)
                                sum_commission += ((new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate) * selected_row_commission) / 100;
                                this.inventories[i]['row_commission_amount'] = ((new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate) * selected_row_commission) / 100;
                                @else 
                                sum_commission += ((new_rate * quantity * this.selected_currency.rate) * selected_row_commission) / 100;
                                this.inventories[i]['row_commission_amount'] = ((new_rate * quantity * this.selected_currency.rate) * selected_row_commission) / 100;
                                @endif
                            }
                            }
 
                            } else {
                                @if(systemConfig()[30] == 1)
                                sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate);
                                @else 
                                sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
                                @endif
                                @if(systemConfig()[30] == 1)
                                sumRoll += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate);
                                @else 
                                sumRoll += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
                                @endif
                                if (this.discountIsAmount) {
                                    if (discount > 0) {
                                        sum_discount += (discount * quantity);
                                    }
                                } else {
                                    if (discount > 0) {
                                        @if(systemConfig()[30] == 1)
                                        sum_discount += (parseFloat(discount) * (quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate))) / 100;
                                        @else 
                                        sum_discount += (parseFloat(discount) * (quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate))) / 100;
                                        @endif
                                    }
                                } 

                                if (this.commissionIsAmount) {
                                if (this.selected_commission && !this.inventories[i].commission && selected_row_commission > 0) {
                                    sum_commission += (quantity * selected_row_commission);
                                    this.inventories[i]['row_commission_amount'] = (quantity * selected_row_commission);
                                }
                                }else{
                                if (this.selected_commission && !this.inventories[i].commission && selected_row_commission > 0) {
                                @if(systemConfig()[30] == 1)
                                sum_commission += ((quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate)) * selected_row_commission) / 100;
                                this.inventories[i]['row_commission_amount'] = ((quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate)) * selected_row_commission) / 100;
                                @else 
                                sum_commission += ((quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate)) * selected_row_commission) / 100;
                                this.inventories[i]['row_commission_amount'] = ((quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate)) * selected_row_commission) / 100;
                                @endif
                                }
                                }
 
                            }

                        } else if (this.import_engine_number && this.inventories[i].item) {
                            var quantity = this.inventories[i]['item']['quantity'];
                            // console.log(2333,quantity);
                            var rate = this.inventories[i]['item']['rate'];
                            var new_rate = this.inventories[i]['item']['new_rate'];
                            var smeasure_unit = this.inventories[i]['item']['measure']['measure_unit'];
                            var measure_unit = this.inventories[i]['item']['measure_unit'];
                            var selected_row_commission = this.inventories[i]['row_commission_percent'];
                            if (new_rate != rate && quantity > 0) {
                                @if(systemConfig()[30] == 1)
                                sum += new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate;
                                @else 
                                sum += new_rate * quantity * this.selected_currency.rate;
                                @endif
                                @if(systemConfig()[30] == 1)
                                sumRoll += new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate;
                                @else 
                                sumRoll += new_rate * quantity * this.selected_currency.rate;
                                @endif

                                if (this.discountIsAmount) {
                                    if (discount > 0) {
                                        sum_discount += (discount * quantity);
                                    }
                                } else {
                                    if (discount > 0) {
                                        @if(systemConfig()[30] == 1)
                                        sum_discount += (parseFloat(discount) * (new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate)) / 100;
                                        @else 
                                        sum_discount += (parseFloat(discount) * (new_rate * quantity * this.selected_currency.rate)) / 100;
                                        @endif
                                    }
                                }


                                if (this.commissionIsAmount) {
                                if (this.selected_commission && !this.inventories[i].commission && selected_row_commission > 0) {
                                    sum_commission += (quantity * selected_row_commission);
                                    this.inventories[i]['row_commission_amount'] = (quantity * selected_row_commission);
                                }
                                }else{
                                    if (this.selected_commission && !this.inventories[i].commission && selected_row_commission > 0) {
                                    @if(systemConfig()[30] == 1)
                                    sum_commission += ((new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate) * selected_row_commission) / 100;
                                    this.inventories[i]['row_commission_amount'] = ((new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate) * selected_row_commission) / 100;
                                    @else 
                                    sum_commission += ((new_rate * quantity * this.selected_currency.rate) * selected_row_commission) / 100;
                                    this.inventories[i]['row_commission_amount'] = ((new_rate * quantity * this.selected_currency.rate) * selected_row_commission) / 100;
                                    @endif
                                } 
                                } 



                            } else {
                                @if(systemConfig()[30] == 1)
                                sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate);
                                @else 
                                sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
                                @endif 

                                @if(systemConfig()[30] == 1)
                                sumRoll += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate);
                                @else 
                                sumRoll += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
                                @endif
                                
                                if (this.discountIsAmount) {
                                    if (discount > 0) {
                                        sum_discount += (discount * quantity);
                                    }
                                } else {
                                    if (discount > 0) {
                                        @if(systemConfig()[30] == 1)
                                        sum_discount += (parseFloat(discount) * (quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate))) / 100;
                                        @else 
                                        sum_discount += (parseFloat(discount) * (quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate))) / 100;
                                        @endif
                                    }
                                }
   

                            if (this.commissionIsAmount) {
                            if (this.selected_commission && !this.inventories[i].commission && selected_row_commission > 0) {
                                sum_commission += (quantity * selected_row_commission);
                                this.inventories[i]['row_commission_amount'] = (quantity * selected_row_commission);
                            }
                            }else{
                            if (this.selected_commission && !this.inventories[i].commission && selected_row_commission > 0) {
                            @if(systemConfig()[30] == 1)
                            sum_commission += ((quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate)) * selected_row_commission) / 100;
                            this.inventories[i]['row_commission_amount'] = ((quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate)) * selected_row_commission) / 100;
                            @else 
                            sum_commission += ((quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate)) * selected_row_commission) / 100;
                            this.inventories[i]['row_commission_amount'] = ((quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate)) * selected_row_commission) / 100;
                            @endif
                            }
                            } 
                            }
                        }
                    }   
                }


 
                // main_inventories ............................................................
                for (var i = 0; i < this.main_inventories.length; i++) {
                    if (this.main_inventories[i].item && this.main_inventories[i].item != null) {
                        var quantity = this.main_inventories[i]['item']['quantity'];
                        if (this.main_inventories[i]['item']['other_measure'] > 0 && this.per_qty_check) {
                            quantity = this.main_inventories[i]['item']['other_measure'];
                        }
                        var rate = this.main_inventories[i]['item']['rate'];
                        var new_rate = this.main_inventories[i]['item']['new_rate'];
                        var smeasure_unit = this.main_inventories[i]['item']['measure']['measure_unit'];
                        var measure_unit = this.main_inventories[i]['item']['measure_unit'];
                        var discount = this.main_inventories[i]['item']['discount'];
                        var selected_row_commission = this.main_inventories[i]['row_commission_percent'];
                        if (new_rate != rate && quantity > 0) {
                            @if(systemConfig()[30] == 1)
                            sum += new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate;
                            @else 
                            sum += new_rate * quantity * this.selected_currency.rate;
                            @endif
                            if (this.discountIsAmount) {
                                if (discount > 0) {
                                    sum_discount += (discount * quantity);
                                }
                            } else {
                                if (discount > 0) {
                                    @if(systemConfig()[30] == 1)
                                    sum_discount += (parseFloat(discount) * (new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate)) / 100;
                                    @else 
                                    sum_discount += (parseFloat(discount) * (new_rate * quantity * this.selected_currency.rate)) / 100;
                                    @endif
                                }
                            }
   

                            
                            if (this.commissionIsAmount) {
                            if (this.selected_commission && !this.main_inventories[i].commission && selected_row_commission > 0) {
                                sum_commission += (quantity * selected_row_commission);
                                this.main_inventories[i]['row_commission_amount'] = (quantity * selected_row_commission);
                            }
                            }
                            else{
                            if (this.selected_commission && !this.main_inventories[i].commission && selected_row_commission > 0) {
                                @if(systemConfig()[30] == 1)
                                sum_commission += ((new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate) * selected_row_commission) / 100;
                                this.main_inventories[i]['row_commission_amount'] = ((new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate) * selected_row_commission) / 100;
                                @else 
                                sum_commission += ((new_rate * quantity * this.selected_currency.rate) * selected_row_commission) / 100;
                                this.main_inventories[i]['row_commission_amount'] = ((new_rate * quantity * this.selected_currency.rate) * selected_row_commission) / 100;
                                @endif
                            }
                            }



                        } else {
                            @if(systemConfig()[30] == 1)
                            sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate);
                            @else 
                            sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
                            @endif
                            if (this.discountIsAmount) {
                                if (discount > 0) {
                                    sum_discount += (discount * quantity);
                                }
                            } else {
                                if (discount > 0) {
                                    @if(systemConfig()[30] == 1)
                                    sum_discount += (parseFloat(discount) * (quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate))) / 100;
                                    @else 
                                    sum_discount += (parseFloat(discount) * (quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate))) / 100;
                                    @endif
                                }
                            }



                            if (this.commissionIsAmount) {
                            if (this.selected_commission && !this.main_inventories[i].commission && selected_row_commission > 0) {
                                sum_commission += (quantity * selected_row_commission);
                                this.main_inventories[i]['row_commission_amount'] = (quantity * selected_row_commission);
                            }
                            }
                            else{
                            if (this.selected_commission && !this.main_inventories[i].commission && selected_row_commission > 0) {
                                @if(systemConfig()[30] == 1)
                                sum_commission += ((quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate)) * selected_row_commission) / 100;
                                this.main_inventories[i]['row_commission_amount'] = ((quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate)) * selected_row_commission) / 100;
                                @else 
                                sum_commission += ((quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate)) * selected_row_commission) / 100;
                                this.main_inventories[i]['row_commission_amount'] = ((quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate)) * selected_row_commission) / 100;
                                @endif
                            }
                            }




                        }
 
                    }
                } 
                


                for (var i = 0; i < this.services.length; i++) {
                    if (this.services[i].item && this.services[i].item != null) {

                        var rate = this.services[i]['item']['rate'];
                        var new_rate = this.services[i]['item']['new_rate'];
                        var smeasure_unit = this.services[i]['item']['measure']['measure_unit'];
                        var measure_unit = this.services[i]['item']['measure_unit'];
                        var quantity = this.services[i]['item']['quantity'];
                        if (new_rate != rate && quantity > 0) {
                            @if(systemConfig()[30] == 1)
                            sum += new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate;
                            @else 
                            sum += new_rate * quantity * this.selected_currency.rate;
                            @endif
                        } else {
                            @if(systemConfig()[30] == 1)
                            sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate);
                            @else 
                            sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
                            @endif
                        }

                    }
                }
   
                if (this.selected_commission) {
                var percent = this.selected_commission.percent;
                if (this.commissionIsAmount) {
                    this.totalCommi = percent;
                    this.subTotalCommi = percent;
                } else {
                    this.totalCommi = ((sum * percent) / 100);
                    this.subTotalCommi = ((sum * percent) / 100);
                }
                }else{
                    this.totalCommi = 0;
                    this.subTotalCommi = 0;
                }

                
                this.discountFiledRow = sum_discount;
                this.totalCos = sumRoll;
                this.sum_commission = sum_commission; 
                // this.totalCommi += this.sum_commission; 
                // console.log("Howing Date", this.totalCommi );

                return sum;
            },

            // calculate subtotalQty
            subtotalQty: function() {
                var sum = 0;
                for (var i = 0; i < this.inventories.length; i++) {
                    if (this.inventories[i].item) {
                        if (this.inventories[i].item.code != null) {

                            var quantity = this.inventories[i]['item']['code']['qut_temp'];
                            if (quantity > 0) {
                                sum += Number.parseFloat(quantity);
                            }
                        }
                    }

                }

                return sum;
            },

            // check payed amount
            payeds: function() {
                var sum = 0;
                for (var i = 0; i < this.payments.length; i++) {

                    if (this.payments[i].item != null && this.payments[i].item) {
                        if (this.payments[i].item != null && this.payments[i]['item']['rate'] > 0) {
                            //
                            @if(systemConfig()[30] == 1)
                            sum += ((this.payments[i]['item']['amount'] / this.payments[i]['item']['static_rate'] * this.payments[i]['item']['rate']) * this.selected_currency.static_rate / this.selected_currency.rate);
                            @else 
                            sum += (this.payments[i]['item']['amount'] * this.selected_currency.rate / this.payments[i]['item']['rate']);
                            @endif
                        }
                    }
                }
                return sum;
            },

            // check data validation
            isError: function() {
                var isError = false;
                var flag = false;
                for (var i = 0; i < this.inventories.length; i++) {

                    if (this.inventories[i].item) {
                        flag = true;
                        // rate=this.inventories[i]['item']['rate'];
                        new_rate = this.inventories[i]['item']['new_rate'];
                        if (new_rate <= 0) {
                            isError = true;
                        }


                    }
                }
                if (this.selected_customer == null) {
                    isError = true;
                }
                return isError;


            },
        },
        watch: {

        },
        mounted: function () {
            this.dynamicTime()
            @if(autoSelectCustomer()!='false')
            this.selectMemeber({!! getDropdown('sale', 'customer') !!});
            @endif
            var selected_banks = null;
            var bank=_.find(this.banks,(v)=>v.id=={!! getDropdown('invoice', 'account') !!});
            if (selected_banks) {
                selected_banks = bank;
            }

            this.payments.push({
                items: this.banks,
                item: selected_banks
            });
            
            this.installments.push({
                items: this.currency,
                item: this.selected_currency

            });
            // console.log('installments',this.selected_currency,this.currency)

            @if(saveTempData() == 'true')
                axios.get("{{route('temp.invoiceRoll.getData')}}", {
                    params: {
                        type: 'invoiceRoll'
                    }
                })
                .then(function(response) {
                        // console.log('myrespo1', response);
                    if (response.data) {
                    if (response.data.form) {
                        
                        // v.purchase_orders = true;

                        v.invoiceDescription = response.data.form.description;
                        v.number = response.data.form.number;
                        v.ref_no = response.data.form.ref_no;
                        v.date = response.data.form.date;
                        v.overdue_date = response.data.form.overdue_date;
                        v.other_member_name = response.data.form.other_member_name;
                        // v.sale_taxation = response.data.form.sale_taxation;
                        // v.print_description = response.data.form.print_description;
                        if (response.data.form.member_id) {
                            this.selectMemeber(response.data.form.member_id);
                        }
                        if (response.data.form.class_id) {
                            v.selected_class = _.find(v.memberClass, (c) => c.id == response.data.form.class_id);
                        }
                        if (response.data.form.sale_area_id) {
                            v.selected_area = _.find(this.saleArea, (s) => s.id == response.data.form.sale_area_id);
                        }

                        v.discountFiled = response.data.form.discount;
                        if (response.data.form.discount_type) {
                            if (response.data.form.discount_type == 'percent') {
                                v.discountIsAmount = false;
                            }
                            else {
                                v.discountIsAmount = true;
                            }
                        }
					
                        // if (this.invoice.taxation_id && this.taxation) {
                        //     this.selected_row_commission = _.find(this.taxation, (s) => s.id == this.invoice.taxation_id);
                        //     this.selected_row_commission.percent = this.invoice.tax_percent;
                        // }
                        // if (this.invoice.sale_discount_id && this.discount_date) {
                        //     this.selected_discount_date = _.find(this.discount_date, (s) => s.id == this.invoice.sale_discount_id);
                        // }
                        
                        for (var a = 0; a < v.currency.length; a++) {
                            if (v.currency[a].code == response.data.form.currency) {
                                v.selected_currency = v.currency[a];
                                v.selected_currency.rate = response.data.form.rate;
                            }
                        }

                    }
                    if (response.data.items) {
                        if (response.data.items.length > 0) {
                            v.inventories = [];
                            for (var f = 0; f < response.data.items.length; f++) {
                                v.inventories.push({
                                    inventory: response.data.items[f],
                                    item: response.data.items[f],
                                    item_category: response.data.items[f].item_category,
                                    commission: 'on',
                                    selected_commission: null,
                                    selectedBrand: null,
                                    selectedLocation: null,
                                    code: null,
                                    bundl: null,
                                    sub_price: null,
                                    sub_total: ''
                                });
                            }
                            v.inventories.push({
                                inventory: null,
                                item: null,
                                commission: 'on',
                                row_commission_percent: null,
                                row_commission_amount: null,
                                selectedBrand: null,
                                selectedLocation: null,
                                code: null,
                                bundl: null,
                                sub_price: null,
                                sub_total: ''
                            });
                            // console.log(333,v.inventories);
                        }
                    }
                    if (response.data.mainInventores) {
                        if (response.data.mainInventores.length > 0) {
                            v.main_inventories = [];
                            for (var r = 0; r < response.data.mainInventores.length; r++) {
                                v.main_inventories.push({
                                    item: response.data.mainInventores[r],
                                    inventory: response.data.mainInventores[r],
                                    commission: 'on',
                                    row_commission_percent: null,
                                    row_commission_amount: null,
                                    item_category: response.data.mainInventores[r].item_category
                                });
                            }
                            v.main_inventories.push({
                                item: null,
                                commission: 'on',
                                row_commission_percent: null,
                                row_commission_amount: null
                            });
                            
                        }
                    }
                    if (response.data.service) {
                        if (response.data.service.length > 0) {
                            v.services = [];
                            for (var r = 0; r < response.data.service.length; r++) {
                                var flag = false;
                                var tempService;
                                for (var h = 0; h < v.all_services.length; h++) {
                                    if (v.all_services[h].id == response.data.service[r].id) {
                                        flag = true;
                                        tempService = v.all_services[h];
                                        tempService.quantity = response.data.service[r].quantity;
                                        tempService.rate = response.data.service[r].new_rate;
                                        tempService.new_rate = response.data.service[r].new_rate;
                                        tempService.order_detail_id = response.data.service[r].order_detail_id;
                                    }
                                }
                                if (flag) {
                                    v.services.push({item: tempService, items: v.all_services})
                                }
                            }
                            for (var w = 1; w > response.data.service.length; w--) {
                                v.services.push({item: null, items: all_services});
                            }

                        }
                    }
                    if (response.data.payment) {
                        if (response.data.payment.length > 0) {
                            v.payments = [];
                            for (var t = 0; t < response.data.payment.length; t++) {
                                var foundFlag = false;
                                var tempBank = null;
                                for (var y = 0; y < v.banks.length; y++) {
                                    if (response.data.payment[t].recevie_payment_id == v.banks[y].id) {
                                        foundFlag = true;
                                        tempBank = v.banks[y];
                                        tempBank.amount = response.data.payment[t].amount;
                                        tempBank.rate = response.data.payment[t].rate; 
                                        tempBank.description = response.data.payment[t].description;
                                        tempBank.number = response.data.payment[t].number;
                                    }
                                }
                                if (foundFlag) {
                                    v.payments.push({item: tempBank, items: v.banks});
                                }
                            }
                            v.payments.push({item: null, items: v.banks});
                        }
                    }
                    // if (response.data.driver) {
                    //     v.driver_data = response.data.driver
                    // }

                    
                    }
                })
                .catch(function(error) {
                    console.log(error);
                })
                @endif
                
            callSaveTemp();
        },
        methods: {
            checkRefNo() {
                var chack = 'false';
                var ref_no = v.ref_no;
                if (ref_no != null) {


                    axios.get("{{route('callMethod.search')}}", { 
                            params: {
                                ref_no: v.ref_no,
                                method_name: 'Search_ref_no',
                                table_name: 'sales'
                            },
                        })
                        .then(function(response) {
                            @if(getDuplicatedRefNo()!="true")
                            if (response.data.result != null) {
                                console.log(response.data.result);
                                v.msg = "@lang('layout.DuplicateData')";
                                v.isError1 = true;
                            } else {
                                v.msg = 'no';
                                v.isError1 = false;

                            }
                            @endif
                        })
                        .catch(function(error) {
                            console.log(error);
                        });

                }
            },
            //BEGIN - Used for dynamic input time
            dynamicTime()
                {
                    this.time_interval = setInterval(() => {
                        const now = new Date()
                        @if(getHourType() == 24)
                            const hours = now.getHours().toString().padStart(2,'0')
                            const minutes = now.getMinutes().toString().padStart(2,'0') 
                            // const seconds = now.getSeconds().toString().padStart(2,'0')
                            this.dynamic_time = `${hours}:${minutes}`
                        @else
                            const timeString = now.toLocaleTimeString('en-US',{hour:'numeric',minute:'numeric',hour12:true});
                            this.dynamic_time = `${timeString}`
                        @endif
                        
                    },1000);
                },
                stopDynamicTime()
                {
                    clearInterval(v.time_interval)
                },
                changeTime()
                {
                    v.dynamic_time = v.$refs.time_input.value
                },
            //END - Used for dynamic input time
            changeMetraz(index) {
                @if(getCubicMetereItems()!="true")
                    @if(systemConfig()[21] == 1)
                    if (this.inventories[index] != null) {
                        if (this.inventories[index].item != null) {
                            if (this.inventories[index].item.code != null) {
                            // console.log(123, this.inventories[index].item.code);
                                if (this.inventories[index].item.code.length != null && this.inventories[index].item.code.width != null) {

                                    var length = this.inventories[index].item.code.length;
                                    var width = this.inventories[index].item.code.width;
                                    this.inventories[index].item.other_measure = myRound(length * width);

                                    if (this.inventories[index].item.other_measure != null && this.inventories[index].item.code.unit_price_temp != null) {
                                        if (this.inventories[index].item.code.unit_price_temp > 0) {
                                            var other_measure = this.inventories[index].item.other_measure;
                                            var unit_price = this.inventories[index].item.code.unit_price_temp;
                                            @if(systemConfig()[30] == 1)
                                            this.inventories[index].item.code.price = myRound((other_measure * unit_price) / this.selected_currency.static_rate * this.selected_currency.rate);
                                            @else 
                                            this.inventories[index].item.code.price = myRound((other_measure * unit_price) / this.selected_currency.rate);
                                            @endif
                                        }
                                    }
                                }
                            }
                        }
                    }
                    @endif
                @endif
            },

            changeMetrazByKhada(index) {
                @if(getCubicMetereItems()=="true")
                    setTimeout(() => {
                        if (v.inventories[index]) {
                            if (v.inventories[index].item != null) {
                                if (v.inventories[index].item.code != null) {
                                    if (v.inventories[index].item.code.khada != null && v.inventories[index].item.code.gauge != null) {
                                    // if (v.inventories[index].item.code.length != null && v.inventories[index].item.code.width != null && v.inventories[index].item.code.khada != null && v.inventories[index].item.code.gauge != null) {

                                        var khada =  Number.parseFloat(v.inventories[index].item.code.khada);
                                        // var width =  Number.parseFloat(v.inventories[index].item.code.width);
                                        // var length =  Number.parseFloat(v.inventories[index].item.code.length);
                                        var gauge =  Number.parseFloat(v.inventories[index].item.code.gauge);
                                        v.inventories[index].item.other_measure = Number.parseFloat(khada * gauge).toFixed(7);
                                        v.change_per_qty(index);
                                        // console.log(3223, v.inventories[index].item.other_measure, khada, gauge);
                                    }
                                    v.changePriceByWing(index);
                                }
                            }
                        }
                    }, 400);
                @endif
            },

            changeKhadaByBundle(index) {
                @if(getCubicMetereItems()=="true")
                    setTimeout(() => {
                        if (v.inventories[index]) {
                            if (v.inventories[index].item != null && v.inventories[index].bundl != null) {
                                if (v.inventories[index].item.code != null) {
                                    if (v.inventories[index].item.code.length != null && v.inventories[index].item.code.width != null) {

                                        var width =  Number.parseFloat(v.inventories[index].item.code.width);
                                        var length =  Number.parseFloat(v.inventories[index].item.code.length);
                                        var bundl =  Number.parseFloat(v.inventories[index].bundl);
                                        var khada =  Number.parseFloat(width * length * bundl).toFixed(7);
                                        v.inventories[index].item.code.khada = khada;
                                        if (v.inventories[index].item.code.khada != null && v.inventories[index].item.code.gauge != null) {
                                            var gauge =  Number.parseFloat(v.inventories[index].item.code.gauge);
                                            v.inventories[index].item.other_measure = Number.parseFloat(khada * gauge).toFixed(7);
                                            v.change_per_qty(index);
                                        }
                                    }
                                    v.changePriceByWing(index);
                                }
                            }
                        }
                    }, 400);
                @endif
            },

            changeCost(index) {
                @if(systemConfig()[21] == 1)
                if (this.inventories[index] != null) {
                    if (this.inventories[index].item != null) {
                        if (this.inventories[index].item.code != null) {
                            if (this.inventories[index].item.other_measure != null && this.inventories[index].item.code.unit_price_temp != null) {
                                if (this.inventories[index].item.code.unit_price_temp > 0) {
                                    var other_measure = this.inventories[index].item.other_measure;
                                    var unit_price = this.inventories[index].item.code.unit_price_temp;
                                    @if(systemConfig()[30] == 1)
                                    this.inventories[index].item.code.price = myRound((other_measure * unit_price) / this.selected_currency.static_rate * this.selected_currency.rate);
                                    @else 
                                    this.inventories[index].item.code.price = myRound((other_measure * unit_price) / this.selected_currency.rate);
                                    @endif
                                }
                            }
                        }
                    }
                }
                @endif
            },

            changePriceByPercentage(index) {
                @if(getSaleCodePricePercentage() == 'true')
                if (this.inventories[index] != null) {
                    if (this.inventories[index].item != null) {
                        this.inventories[index].item.add_percentage = this.$refs.add_percentage[index].value;
                        var add_percentage = this.$refs.add_percentage[index].value;
                        if (this.inventories[index].item.code != null && add_percentage > 0) {
                            if (this.inventories[index].item.code.baseCost > 0) {
                                var cost = this.inventories[index].item.code.baseCost;
                                this.inventories[index].item.code.price = myRound((cost * add_percentage / 100) + cost);
                                this.inventories[index].item.new_rate = myRound((cost * add_percentage / 100) + cost);
                            }
                        }
                    }
                }
                @endif
            },

            subMQuantity(index = null, item = null, quantity = null) {
                if (item != null && quantity) {
                    var result = 0;
                    if (item.measure && item.measure1 && item.measure_list) {
                        // console.log(312, Object.keys(item.measure_list).length);
                        for (let i in item.measure_list) {
                            if (item.measure_list[i].measure_id == item.measure1.measure_id) {
                                result = (Number.parseFloat(quantity) * Number.parseFloat(item.measure.measure_unit)) / Number.parseFloat(item.measure_list[i].measure_unit);
                                v.setNewRateTotal(index, result);
                            }
                        }
                    }
                    return result;
                }
            },

            setNewRateTotal(index = null, quantity = null) {
                if (this.inventories[index].item && this.inventories[index].sub_price > 0) {
                    if (this.inventories[index].item.measure1 && this.inventories[index].item.code) {
                        var item = this.inventories[index].item;
                        if (quantity) {
                            var sub_quantity = quantity;
                        } else {
                            var sub_quantity = v.subMQuantity(index, item, item.code.qut_temp);
                        }
                        var sub_price = this.inventories[index].sub_price;
                        var total_price = (sub_quantity * sub_price);

                        var quantity = item.code.qut_temp;
                        if (quantity > 0) {
                            if (this.selected_currency.rate > 0) {
                                @if(systemConfig()[30] == 1)
                                item.new_rate = Number.parseFloat((total_price / quantity) / this.selected_currency.static_rate * this.selected_currency.rate).toFixed(7);
                                @else 
                                item.new_rate = Number.parseFloat((total_price / quantity) / this.selected_currency.rate).toFixed(7);
                                @endif
                            } else {
                                item.new_rate = Number.parseFloat(total_price / quantity).toFixed(7);
                            }
                        }
                        // console.log('asda changed111', sub_quantity,item.quantity,sub_price,item);
                    }
                }
            },

            RateUnitPrice(unit_price = null, exchange_rate = 1, static_rate = 1) {
                var result = 0;
                if (unit_price != null && unit_price > 0) {
                    @if(systemConfig()[30] == 1)
                        var temp = unit_price * static_rate / exchange_rate;
                    @else
                        var temp = unit_price * exchange_rate;
                   @endif

                    res = Number.parseFloat(temp).toFixed(precision());
                    result = parseFloat(res);
                }
                return result;
            },

            checkNo() {
                var chack = 'false';
                var number = v.number;
                if (number != null) {
                    axios.get("{{route('callMethod.search')}}", {

                            params: {
                                number: v.number,
                                method_name: 'Search_number',
                                table_name: 'sales'
                            },
                        })
                        .then(function(response) {
                            // console.log(response.data.result);
                            if (response.data.result != null) {
                                // console.log(response.data.result);
                                // v.temp_items=response.data;
                                v.number_msg = "@lang('layout.DuplicateData')"; 
                                v.number_Error = true;
                            } else {
                                v.number_msg = 'no';
                                v.number_Error = false;

                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        });

                }
            },
            getSummary() {
                if (this.selected_customer) {
                    this.getSummaryRecor(this.selected_customer.id, this);

                }

            },
            getSummaryRecor(id, v) {

                axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'memberStatment',
                            member_id: id,
                        }
                    })
                    .then(function(response) {
                        // console.log('member', response)
                        if (response.data.length > 0) {
                            v.summary = response.data;
                        } else {
                            v.summary = [];
                        }
                    })
                    .catch(function(error) {
                        console.log(error);
                    });
            },

            handleSubmit(e) {

                this.$validator.validate().then(valid => {
                    if (valid) {
                        // alert(e.target);
                        //console.log(v.member_chack());
                        if (v.member_chack() == 'true') {
                            var r = confirm("@lang('layout.member_payable_levels')");
                            if (r == true) {
                                v.disabled = true;
                                v.submitForm(e.target);
                            }
                        } else {
                            v.disabled = true;
                            v.submitForm(e.target);
                        }
                    }
                });
            },

            selectMemeber(id = null) {
                if (id) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SearchMember',
                            id: id,
                            type: 'Customer'
                        }
                    })
                    .then(function(response) {
                        if (response.data) {
                            // console.log(response.data);
                            v.selected_customer = null;
                            v.selected_customer = response.data;
                        }
                    })
                    .catch(function(error) {
                        console.log(error);
                    })
                }
            },
            memberClassChange() {
                if (v.selected_class) {
                    v.customer = [];
                    // v.selected_customer = null;
                    let class_id = v.selected_class.id;
                
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SearchMember',
                            class_id: class_id,
                            type: 'Customer'
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            // console.log(response.data);
                            v.customer = [];
                            v.customer = response.data;
                        }
                    })
                    .catch(function(error) {
                        console.log(error);
                    })
                }
            },
            MemberSearch: _.debounce((search, loading) => {
                loading(true);
                let class_id = (v.selected_class != undefined) ? v.selected_class.id : null;
                
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'SearchMember', 
                        keyword: search,
                        class_id: class_id,
                        type: 'Customer'
                    }
                })
                .then(function(response) {
                    if (response.data.length > 0) {
                        // console.log(response.data);
                        v.customer = [];
                        v.customer = response.data;
                    }
                    loading(false);
                })
                .catch(function(error) {
                    loading(false);
                    console.log(error);
                })
            }, getDebounceTime()),

            //Vendor Search for Transfer Rent
            VendorSearch: _.debounce((search, loading) => {
                loading(true);
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'SearchMember', 
                        keyword: search,
                        type: 'Vendor'
                    }
                })
                .then(function(response) {
                    if (response.data.length > 0) {
                        // console.log(response.data);
                        v.transfer_rent_vendor = [];
                        v.transfer_rent_vendor = response.data;
                    }
                    loading(false);
                })
                .catch(function(error) {
                    loading(false);
                    console.log(error);
                })
            }, getDebounceTime()),

            // chack_member_payable_levels
            member_chack() {
                var chack = 'false';
                var member_id = v.member_id;
                if (member_id != null) {

                    var totals = Number.parseFloat((v.subtotal - (v.discount * v.subtotal / 100)) - v.payeds);
                    var currency = $("input[name=currency]").val();


                    $.ajax({
                        url: "{{route('callMethod.search')}}",
                        async: false,
                        data: {
                            member_id: v.member_id,
                            method_name: 'Search_member_payable_levels',
                            currency: currency,
                        },
                        success: function(data) {
                            var r_amount = Number.parseFloat(data.amount);
                            var r_m_amount = Number.parseFloat(data.m_amount);
                            var totalss = Number.parseFloat(((isNaN(r_m_amount) ? 0 : r_m_amount) + totals));
                            //console.log(r_m_amount);
                            //console.log('--');
                            //console.log(totals);
                            if (r_amount != 0 && r_amount < totalss) {
                                chack = 'true';
                            } else {
                                chack = 'false';
                            }


                        }.bind(this),

                        error: function(error) {
                            console.log(error)
                        }
                    });
                    /*
                            axios.get("{{route('callMethod.search')}}",
				   {

					params:{
					  member_id:v.member_id,
					  method_name:'Search_member_payable_levels',
					  currency:currency,
					  
					},
				   })
				   .then(function (response)
				   {
					 
						var r_amount = response.data.amount;
						var r_m_amount = response.data.m_amount;
						if(r_amount < (r_m_amount + totals)){
							chack = 'true';
						}
				   })
				   .catch(function (error)
				   {
					  console.log(error);
				   });
			  */
                }
                return chack;
            },

            showInfo(index, type) {
                if (type == 'main') {
                    if (v.main_inventories[index].item != null) {
                        v.showInfoModal = true;
                        v.brand = v.main_inventories[index]['item']['brand'];
                        v.location = v.main_inventories[index]['item']['location'];
                        v.SNumber = v.main_inventories[index]['item']['number'];
                        v.last_item_sale = v.main_inventories[index]['item']['last_item_sale'];
                        // if(v.seeCost==true){
                        @if(systemConfig()[30] == 1)
                        v.cost = (v.main_inventories[index]['item']['LasCost'] * v.selected_currency.static_rate / v.selected_currency.rate);
                        @else 
                        v.cost = (v.main_inventories[index]['item']['LasCost'] * v.selected_currency.rate);
                        @endif
                        // }
                        // console.log('ffff',v.main_inventories[index]['item'],v.cost);
                    }
                }
                if (type == 'code') {
                    if (v.inventories[index].item != null) {
                        v.showInfoModal = true;
                        v.brand = v.inventories[index]['item']['brand'];
                        v.location = v.inventories[index]['item']['location'];
                        v.SNumber = v.inventories[index]['item']['number'];
                        v.last_item_sale = v.inventories[index]['item']['last_item_sale'];
                        // console.log('ffff',v.last_item_sale);
                        // if(v.seeCost==true){
                        @if(systemConfig()[30] == 1)
                        v.cost = myRound((v.inventories[index]['item']['cost'] * v.inventories[index]['item']['measure']['measure_unit'] / (v.inventories[index]['item']['measure_unit']) * v.selected_currency.static_rate / v.selected_currency.rate));
                        @else 
                        v.cost = myRound((v.inventories[index]['item']['cost'] * v.inventories[index]['item']['measure']['measure_unit'] / v.inventories[index]['item']['measure_unit']) * v.selected_currency.rate);
                        @endif
                        // }
                    }
                }
            },

            changeQuantityByWing(index) {
                if (v.quantityByWing) {
                    @if(ShowQuantityByWing() == "true")
                    setTimeout((function() {
                        if (v.inventories[index].item != null) {
                            if (v.inventories[index].item.code != null) {
                                @if(getCubicMetereItems()=="true")
                                v.changeMetrazByKhada(index);
                                @else
                                if (Number.parseFloat(v.inventories[index].item.code.khada) > 0 && Number.parseFloat(v.inventories[index].item.code.approx_weight) > 0) {
                                    v.inventories[index].item.code.qut_temp = Number.parseFloat(Number.parseFloat(v.inventories[index].item.code.khada) * Number.parseFloat(v.inventories[index].item.code.approx_weight)).toFixed(7);
                                    v.changePriceByWing(index);
                                    // console.log(v.inventories[index].item.code.qut_temp);
                                }
                                @endif
                            }
                        }
                    }), 500)
                    @endif
                }
            },

            changeQuantityOfWing(index) {
                if (v.quantityByWing) {
                    @if(ShowQuantityByWing() == "true")
                    setTimeout((function() {
                        if (v.inventories[index].item != null) {
                            if (v.inventories[index].item.code != null) {
                                if (Number.parseFloat(v.inventories[index].item.code.qut_temp) > 0 && Number.parseFloat(v.inventories[index].item.code.approx_weight) > 0) {
                                    v.inventories[index].item.code.khada = Number.parseFloat(Number.parseFloat(v.inventories[index].item.code.qut_temp) / Number.parseFloat(v.inventories[index].item.code.approx_weight)).toFixed(7);
                                    v.changePriceByWing(index);
                                } else if (Number.parseFloat(v.inventories[index].item.code.khada) > 0 && Number.parseFloat(v.inventories[index].item.code.qut_temp) > 0) {
                                    v.inventories[index].item.code.approx_weight = Number.parseFloat(Number.parseFloat(v.inventories[index].item.code.qut_temp) / Number.parseFloat(v.inventories[index].item.code.khada)).toFixed(7);
                                    v.changePriceByWing(index);
                                }
                            }
                        }
                    }), 500)
                    @endif
                }

                if (v.inventories[index].item != null) {
                    if (v.inventories[index].item.code != null) {
                        v.inventories[index].item.code.qut_temp1 = v.inventories[index].item.code.qut_temp * v.inventories[index].item.measure_unit / v.inventories[index].item.measure.measure_unit;
                    }
                }
            },
            changePriceByWing(index) {
                var rate = 1;
                var static_rate = 1;
                if (Number.parseFloat(v.selected_currency.rate) > 0) {
                    rate = Number.parseFloat(v.selected_currency.rate);
                    static_rate = Number.parseFloat(v.selected_currency.static_rate);
                }
                if (v.quantityByWing) {
                    @if(ShowQuantityByWing() == "true")
                    setTimeout((function() {
                        if (v.inventories[index].item != null) {
                            if (v.inventories[index].item.code != null) {
                                if (Number.parseFloat(v.inventories[index].item.code.khada) > 0 && Number.parseFloat(v.inventories[index].item.code.price_of_khada) > 0 && Number.parseFloat(v.inventories[index].item.code.approx_weight) > 0) {
                                    @if(systemConfig()[30] == 1)
                                    var price = (((Number.parseFloat(v.inventories[index].item.code.khada) * Number.parseFloat(v.inventories[index].item.code.price_of_khada))/Number.parseFloat(v.inventories[index].item.code.qut_temp))/ static_rate * rate);
                                    @else 
                                    var price = (((Number.parseFloat(v.inventories[index].item.code.khada) * Number.parseFloat(v.inventories[index].item.code.price_of_khada))/Number.parseFloat(v.inventories[index].item.code.qut_temp))/rate);
                                    @endif
                                    v.inventories[index].item.code.price = price;
                                    v.inventories[index].item.new_rate = price;
                                }
                            }
                        }
                    }), 600)
                    @endif
                }
            },

            changePriceOfWing(index) {
                var rate = 1;
                var static_rate = 1;
                if (Number.parseFloat(v.selected_currency.rate) > 0) {
                    rate = Number.parseFloat(v.selected_currency.rate);
                    static_rate = Number.parseFloat(v.selected_currency.static_rate);
                }
                if (v.quantityByWing) {
                    @if(ShowQuantityByWing() == "true")
                    setTimeout((function() {
                        if (v.inventories[index].item != null) {
                            if (v.inventories[index].item.code != null) {
                                if (Number.parseFloat(v.inventories[index].item.code.khada) > 0 && Number.parseFloat(v.inventories[index].item.new_rate) > 0 && Number.parseFloat(v.inventories[index].item.code.qut_temp) > 0) {
                                    @if(systemConfig()[30] == 1)
                                    var price = (((Number.parseFloat(v.inventories[index].item.new_rate) * Number.parseFloat(v.inventories[index].item.code.qut_temp)) / Number.parseFloat(v.inventories[index].item.code.khada))* static_rate / rate);
                                    @else 
                                    var price = (((Number.parseFloat(v.inventories[index].item.new_rate) * Number.parseFloat(v.inventories[index].item.code.qut_temp)) / Number.parseFloat(v.inventories[index].item.code.khada))*rate);
                                    @endif
                                    v.inventories[index].item.code.price_of_khada = Number.parseFloat(price).toFixed(precision());
                                    v.$refs.price_of_khada[index].value = Number.parseFloat(price).toFixed(precision());
                                }
                            }
                        }
                    }), 600)
                    @endif
                }
            },

            totalChangeQuantityByWing() {
                setTimeout((function() {
                if (v.quantityByWing) {
                        for (var index = 0; index < v.inventories.length; index++) {
                            if (v.inventories[index].item != null) {
                                if (v.inventories[index].item.code != null) {
                                    if (Number.parseFloat(v.inventories[index].item.code.khada) > 0 && Number.parseFloat(v.inventories[index].item.code.approx_weight) > 0) {
                                        v.inventories[index].item.code.qut_temp = Number.parseFloat(Number.parseFloat(v.inventories[index].item.code.khada) * Number.parseFloat(v.inventories[index].item.code.approx_weight)).toFixed(7);
                                        v.changePriceByWing(index);
                                        // console.log(v.inventories[index].item.code.qut_temp);
                                    }
                                }
                            }
                        }
                }
                }), 500)
            },

            changeWingPrice(index) {
                @if(ShowQuantityByWing() == "true")
                if (v.inventories[index].item != null) {
                    if (v.inventories[index].item.code != null) {
                        @if(systemConfig()[30] == 1)
                        v.inventories[index].item.code.price_of_khada = Number.parseFloat(v.inventories[index].item.price_of_khada) * v.selected_currency.static_rate / v.selected_currency.rate;
                        @else 
                        v.inventories[index].item.code.price_of_khada = Number.parseFloat(v.inventories[index].item.price_of_khada) * v.selected_currency.rate;
                        @endif
                    }
                }
                @endif
                @if(getAverageCostByCode() == "true")
                if (v.inventories[index].item != null) {
                    if (v.inventories[index].item.code != null) {
                        if (v.inventories[index].item.code.cost > 0) {
                            v.inventories[index].item.cost = v.inventories[index].item.code.cost;
                        }
                    }
                }
                @endif

            },

            // calculte total of item or service
            getItemTotalRoll(quantity = null) {
                var new_rate = this.inventories[0]['item']['new_rate'];
                var smeasure_unit = this.inventories[0]['item']['measure']['measure_unit'];
                var measure_unit = this.inventories[0]['item']['measure_unit'];
                var result = 0;
                if (new_rate != null && smeasure_unit != null && measure_unit != null && quantity != null) {

                    var price = ((measure_unit * new_rate) / smeasure_unit);
                    var qty = (smeasure_unit * quantity) / measure_unit;
                    @if(systemConfig()[30] == 1)
                    var temp = price * qty * v.selected_currency.static_rate / v.selected_currency.rate;
                    @else 
                    var temp = price * qty * v.selected_currency.rate;
                    @endif
                    result = Number.parseFloat(temp).toFixed(precision());
                }
                // console.log(result);
                return result;


            },

            // calculte total of item or service
            getItemTotalRollRow(item = null, rate = null, per_qty_check = null, discount = null, discount_is_amount = null, static_rate = 1) {
                
                var result = 0;
                if (item.item != null) {
                    var qty = 0;
                    var temp = 0;
                    if (item.item.new_rate != null && item.item.code != null && rate != null) {
                        if (per_qty_check && item.item.other_measure > 0) {
                            qty = item.item.other_measure;
                        }else{
                            qty = item.item.code.qut_temp;
                        }
                        @if(systemConfig()[30] == 1)
                            temp = item.item.new_rate * qty * static_rate / rate;
                        @else
                            temp = item.item.new_rate * qty * rate;
                        @endif

                    } else if (item.item.new_rate != null && this.import_engine_number && rate != null) {
                        qty = item.item.quantity;
                        @if(systemConfig()[30] == 1)
                            temp = item.item.new_rate * qty * static_rate / rate;
                        @else 
                            temp = item.item.new_rate * qty * rate;
                        @endif
                    }

                    if (discount != null && discount_is_amount != null) {
                        if (discount_is_amount) {
                            temp -= (qty * discount);
                        }
                        else {
                            temp -= (temp * discount) / 100;
                        }
                    }
                    result = Number.parseFloat(temp).toFixed(precision());
                }
                // console.log(result);
                return result;
            },


            // calculate item price based on measure change
            measureChange(index) {

                if (this.inventories[index].item != null) {
                    var item = this.inventories[index].item;

                    var temp = ((item.rate * item.measure.measure_unit / item.measure_unit));
                    result = Number.parseFloat(temp).toFixed(precision());

                    this.inventories[index].item.new_rate = result;

                    if (this.inventories[index].item.code != null) {
                    if (this.inventories[index].item.code.price_temp != null && this.inventories[index].item.code.price_temp > 0) {
                        this.inventories[index].item.code.price = ((this.inventories[index].item.code.price_temp * item.measure.measure_unit / item.measure_unit));
                        this.inventories[index].item.new_rate = ((this.inventories[index].item.code.price_temp * item.measure.measure_unit / item.measure_unit));
                    }
                    }

                    // console.log(333333,result, item.rate , item.measure.measure_unit , item.measure_unit, this.inventories[index].item.code.price );
                    // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;

                    if (item.code != null) {
                        item['code']['qut_temp'] = item['code']['qut_temp1'] * item.measure_unit / item.measure.measure_unit;
                        item['code']['OnHand'] = item['code']['OnHand1'] * item.measure_unit / item.measure.measure_unit;
                    }
                }
            },

            // calculate item price based on measure change
            measureChangeservice(index) {

                if (this.services[index].item != null) {
                    var item = this.services[index].item;
                    @if(systemConfig()[30] == 1)
                    var temp = ((item.rate * item.measure.measure_unit / item.measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate);
                    @else 
                    var temp = ((item.rate * item.measure.measure_unit / item.measure_unit) * this.selected_currency.rate);
                    @endif

                    result = Number.parseFloat(temp).toFixed(precision());

                    this.services[index].item.new_rate = result;

                    // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;

                }
            },
            // detect member change and searh
            memberChange() {
                if (this.selected_customer) {
                        v.member_id = this.selected_customer.id;
                    // get member contract
                    this.saleOrderSearch(this.selected_customer.id, this);
                }

            },
            //Get Transport Company Drivers 
            getDrivers() {
                if (this.selected_transportCompany) {
                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                transport_id: this.selected_transportCompany.id,
                                method_name: 'Search_transport_company_drivers'
                            },
                        })
                        .then(function(response) {
                            if (response.data.result != null) {
                                // console.log('all Drivers', response.data.result);
                                v.t_drivers = response.data.result;
                                v.selected_transportDriver = null;
                            } else {

                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        });
                }
            },

            //Get Just Drivers  without Transport Company Select
            getAllDrivers() {
                if (!v.selected_transportCompany) {
                    v.t_drivers = v.allDrivers;
                }
            },


            // sale order change
            saleOrderChang() {
                console.log('test 33');
            },
            // end sale order change
            // set new price
            setNewRate(type = null, index = null) {
                if (type == 'inventory') {
                    if (this.inventories[index].item) {
                        // console.log(30, this.inventories[index].item);
                        if (this.inventories[index].item.code != null) {
                            if (this.inventories[index].item.code.price != null) {
                                @if(systemConfig()[30] == 1)
                                this.inventories[index].item.code.price = this.inventories[index].item.temp_price / this.selected_currency.static_rate * this.selected_currency.rate;
                                @else 
                                this.inventories[index].item.code.price = this.inventories[index].item.temp_price / this.selected_currency.rate;
                                @endif
                                @if(systemConfig()[30] == 1)
                                this.inventories[index].item.code.price_temp = this.inventories[index].item.temp_price / this.selected_currency.static_rate * this.selected_currency.rate;
                                @else 
                                this.inventories[index].item.code.price_temp = this.inventories[index].item.temp_price / this.selected_currency.rate;
                                @endif
                                @if(systemConfig()[30] == 1)
                                this.inventories[index].item.new_rate = this.inventories[index].item.temp_price / this.selected_currency.static_rate * this.selected_currency.rate;
                                @else 
                                this.inventories[index].item.new_rate = this.inventories[index].item.temp_price / this.selected_currency.rate;
                                @endif
                            } else {
                                @if(systemConfig()[30] == 1)
                                this.inventories[index].item.new_rate = this.inventories[index].item.temp_price / this.selected_currency.static_rate * this.selected_currency.rate;
                                @else 
                                this.inventories[index].item.new_rate = this.inventories[index].item.temp_price / this.selected_currency.rate;
                                @endif
                            }
                        } else {
                            @if(systemConfig()[30] == 1)
                            this.inventories[index].item.new_rate = this.inventories[index].item.temp_price / this.selected_currency.static_rate * this.selected_currency.rate;
                            @else 
                            this.inventories[index].item.new_rate = this.inventories[index].item.temp_price / this.selected_currency.rate;
                            @endif
                        }

                        if (this.inventories[index].item.code != null) {
                            this.inventories[index].item.code.qut_temp = this.$refs.qut_temp[index].value;
                            // this.inventories[index].item.code.qut_temp = this.$refs.qut_temp[index].value;
                            @if(getShowWing()!="false")
                            this.inventories[index].item.code.khada = this.$refs.khada[index].value;
                            @if(ShowQuantityByWing() == "true")
                            this.inventories[index].item.code.approx_weight = this.$refs.approx_weight[index].value;
                            this.inventories[index].item.code.price_of_khada = this.$refs.price_of_khada[index].value;
                            @endif
                            @endif


                            if (showWhat('sale_description')=='yes') {
                                this.inventories[index].item.code.description = this.$refs.description[index].value;
                            }

                            @if(getCubicMetereItems()=="true")
                                this.inventories[index].item.code.gauge = this.$refs.gauge[index].value;
                            @endif
                            
                            @if(systemConfig()[21] == 1 || getCubicMetereItems()=="true")
                                this.inventories[index].item.code.width = this.$refs.width[index].value;
                                this.inventories[index].item.code.length = this.$refs.length[index].value;
                                @if(systemConfig()[21] == 1)
                                    this.inventories[index].item.code.unit_price_temp = this.$refs.unit_price[index].value;
                                    @if(systemConfig()[30] == 1)
                                    this.inventories[index].item.code.unit_price = this.$refs.unit_price[index].value / this.selected_currency.static_rate * this.selected_currency.rate;
                                    @else 
                                    this.inventories[index].item.code.unit_price = this.$refs.unit_price[index].value / this.selected_currency.rate;
                                    @endif
                                @endif
                            @endif

                            @if(getAutoSelectOtherMeasureQuantity() == "true")

                            if (this.inventories[index].item.code.other_measure && this.inventories[index].item.code.OnHand1 && this.inventories[index].item.code.qut_temp) {
                            var othe = Number.parseFloat(this.inventories[index].item.code.other_measure) / Number.parseFloat(this.inventories[index].item.code.OnHand1);
                            
                            this.inventories[index].item.other_measure = myRound(Number.parseFloat(this.inventories[index].item.code.qut_temp) * othe);
                            }

                            if (this.inventories[index].item.code.other_measure2 && this.inventories[index].item.code.OnHand1 && this.inventories[index].item.code.qut_temp) {
                            // console.log(222, this.inventories[index].item.code);
                            var othe = Number.parseFloat(this.inventories[index].item.code.other_measure2) / Number.parseFloat(this.inventories[index].item.code.OnHand1);
                            this.inventories[index].item.other_measure2 = myRound(Number.parseFloat(this.inventories[index].item.code.qut_temp) * othe);
                            }
                            
                            @endif
                        }

                        @if(systemConfig()[30] == 1)
                        if (((this.inventories[index].item.cost * this.inventories[index].item.measure.measure_unit / this.inventories[index].item.measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate) > (this.inventories[index].item.new_rate * this.selected_currency.static_rate / this.selected_currency.rate)) {
                            this.cheap = true;
                        } else {
                            this.cheap = false;
                        }
                        if (this.import_engine_number) {
                            this.inventories[index].item.quantity = this.$refs.inventory_qut[index].value;
                        }
                        @else 
                        if (((this.inventories[index].item.cost * this.inventories[index].item.measure.measure_unit / this.inventories[index].item.measure_unit) * this.selected_currency.rate) > (this.inventories[index].item.new_rate * this.selected_currency.rate)) {
                            this.cheap = true;
                        } else {
                            this.cheap = false;
                        }
                        if (this.import_engine_number) {
                            this.inventories[index].item.quantity = this.$refs.inventory_qut[index].value;
                        }
                        @endif
                        
                    }

                }
                if (type == 'service') {
                    if (this.services[index].item) {
                        // console.log('service changed');
                        @if(systemConfig()[30] == 1)
                        this.services[index].item.new_rate = this.$refs.ser[index].value / this.selected_currency.static_rate * this.selected_currency.rate;
                        @else 
                        this.services[index].item.new_rate = this.$refs.ser[index].value / this.selected_currency.rate;
                        @endif
                    }
                }
            },
            change_per_qty(index) {
                if (this.inventories[index]['item'] && this.inventories[index]['item'] != null) {
                    if (this.inventories[index]['item']['code'] && this.inventories[index]['item']['code'] != null) {

                        var other_measure = this.inventories[index]['item']['other_measure'];
                        var qty = this.inventories[index]['item']['code']['OnHand'];
                        var other_qty = this.inventories[index]['item']['code']['other_measure'];
                        @if(getCubicMetereItems()=="true")
                        if (other_measure > 0 && qty > 0 && other_qty > 0) {
                            var per_qty = Number.parseFloat(qty / other_qty);
                            this.inventories[index]['item']['code']['qut_temp'] = Number.parseFloat(other_measure * per_qty).toFixed(7);
                            this.inventories[index]['item']['quantity'] = Number.parseFloat(other_measure * per_qty).toFixed(7);
                        }
                        @endif
                        if (this.per_qty_check && other_measure > 0 && qty > 0 && other_qty > 0) {
                            var per_qty = Number.parseFloat(qty / other_qty);
                            this.inventories[index]['item']['code']['qut_temp'] = Number.parseFloat(other_measure * per_qty).toFixed(7);
                            this.inventories[index]['item']['quantity'] = Number.parseFloat(other_measure * per_qty).toFixed(7);
                        }
                    }
                }
            },
            // set new price
            setNewRateMain(type = null, index = null) {
                if (type == 'inventory') {
                    if (this.main_inventories[index].item) {
                        @if(systemConfig()[30] == 1)
                        this.main_inventories[index].item.new_rate = this.main_inventories[index].item.cost / this.selected_currency.static_rate * this.selected_currency.rate;
                        @else 
                        this.main_inventories[index].item.new_rate = this.main_inventories[index].item.cost / this.selected_currency.rate;
                        @endif
                        // this.main_inventories[index].item.new_rate = this.$refs.in_mian[index].value / this.selected_currency.rate;
                        @if(systemConfig()[30] == 1)
                        if (((this.main_inventories[index].item.LasCost * this.main_inventories[index].item.measure.measure_unit / this.main_inventories[index].item.measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate) > (this.main_inventories[index].item.new_rate * this.selected_currency.static_rate / this.selected_currency.rate)) {
                            this.cheap_main = true;
                        } else {
                            this.cheap_main = false;
                        }
                        @else 
                        if (((this.main_inventories[index].item.LasCost * this.main_inventories[index].item.measure.measure_unit / this.main_inventories[index].item.measure_unit) * this.selected_currency.rate) > (this.main_inventories[index].item.new_rate * this.selected_currency.rate)) {
                            this.cheap_main = true;
                        } else {
                            this.cheap_main = false;
                        }
                        @endif
                    }
                }
            },

            //ajax call to get items
            onItemSearch: _.debounce((search, loading) => {
                var selectedIndex = v.selectedIndex;
                loading(true);
                if (v.inventories[0].item == null || !v.inventories[0].item.sale_order_detail_id) {
                    let inventory_category_id = (v.inventories[selectedIndex]['item_category'] != undefined) ? v.inventories[selectedIndex]['item_category'].id : '';
                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                member_id: v.member_id,
                                method_name: 'itemSearchNameRoll',
                                // method_name: 'itemSearchSaleRoll',
                                keyword: search,
                                inventory_category_id: inventory_category_id,
                            },
                        })
                        .then(function(response) {
                            // v.subItems = [];
                            if (response.data.length > 0) {
                            v.temp_items = [];
                                v.temp_items = response.data;
                                // console.log('pp', response.data);
                            }
                            loading(false);
                        })
                        .catch(function(error) {
                            console.log(error);
                        });
                } else {
                    console.log('test check1', v.selected_sale_order);

                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'SaleOrderItemsRoll',
                                sale_order_id: v.selected_sale_order.id,
                                type: 'saleOrder'
                            }
                        })
                        .then(function(response) {
                            if (response.data.length > 0) {
                                v.temp_items = [];
                                v.temp_items = response.data;

                                // v.inventories = [];
                                // for (var r = 0; r < response.data.length; r++) {
                                // v.inventories.push({item: response.data[r]});
                                // }
                                // v.inventories.push({item: null});
                                // console.log('test check', v.inventories);
                                v.invoiceDescription = v.selected_sale_order.description;
                                loading(false);
                            }

                        })
                        .catch(function(error) {
                            console.log(error);
                        })


                }

            }, getDebounceTime()),

            // end item search
            //ajax call to get items
            onItemLoadByCode(index) {
                if (v.inventories[index].code != null) {
                    v.inventories[index].code.qut_temp = 0;
                    var inventory_id = v.inventories[index].code.inventory_id;
                    var brand_id = v.inventories[index].code.brand_id;
                    var stocks_in_id = v.inventories[index].code.id;
                    // console.log(33, stocks_in_id);
                    if (brand_id>0) {
                        v.inventories[index].selectedBrand = _.find(inventoryBrand, (o) => o.id == brand_id);
                    }
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            member_id: v.member_id,
                            method_name: 'itemSearchSaleRoll',
                            inventory_id: inventory_id,
                            stocks_in_id: stocks_in_id,
                        }
                    })
                    .then(function(response) {
                        // console.log("dddd",response.data)
                        
                            if (v.inventories[0].item && !v.inventories[0].item.sale_order_detail_id) {
                                v.inventories[index].item = null;
                            }

                        if (response.data.length > 0) {
                            // console.log(34,v.inventories[index]);

                            if (v.inventories[0].item && !v.inventories[0].item.sale_order_detail_id) {
                                v.inventories[index].item = response.data[0];
                            }
                            
                            v.inventories[index].inventory = response.data[0];
                            v.inventories[index].item = response.data[0];
                            v.inventories[index].item.code = v.inventories[index].code;
                            v.inventories[index].item.cost = v.inventories[index].code.cost;
                            
                            var site_id = v.inventories[index].code.site_id;
                            var sites = response.data[0]['site_list'];
                            for (let a = 0; a < sites.length; a++) {
                                if(sites[a].site_id == site_id){
                                v.inventories[index].item.site = sites[a];
                                }
                            }
                            v.inventories[index].selectedLocation = response.data[0].selectedLocation;
                            v.locationList = response.data[0].locationList;

                            @if(ShowQuantityByWing() == "true")
                            v.inventories[index].item.code.price_of_khada = response.data[0].price_of_khada;
                            @endif

                            // console.log('gg989', response.data[0],site_id,v.inventories[index].item.site);
                        }
                    })
                    .catch(function(error) {
                        console.log(error);
                    });
                }
            },

            // end item search

            // contract search

            saleOrderSearch(id, vm) {
                vm.saleOrderList = [];
                axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'memberSaleOrderRoll',
                            // type: 'saleOrder',
                            member_id: id,
                        }
                    })
                    .then(function(response) {
                        // console.log(123, response.data);
                        if (response.data.length > 0) {
                            vm.showModalSaleOrder = true;
                            vm.saleOrderList = response.data;
                        }
                        // loading(false);
                    })
                    .catch(function(error) {
                        console.log(error);
                    })
            },
            getsalesOrders() {
                this.showModalSaleOrder = false;
                axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SaleOrderItemsRoll',
                            sale_order_id: this.selected_sale_order.id,
                            type: 'saleOrder'
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            v.inventories = [];
                            v.main_inventories = [];
                            v.services = [];
                            for (var r = 0; r < response.data.length; r++) {
                                if (response.data[r].type == 'roll') {
                                    v.inventories.push({
                                        item: response.data[r],
                                        inventory: response.data[r],
                                        selectedBrand: null,
                                        selectedLocation: null,
                                        code: null,
                                        bundl: null,
                                        sub_price: null
                                    });
                                    v.onItemSearchCodeSelect(r);
                                }
                                if (response.data[r].type == 'item') {
                                    v.main_inventories.push({
                                        item: response.data[r],
                                        inventory: response.data[r],
                                        commission: 'on',
                                        row_commission_percent: null,
                                        row_commission_amount: null,
                                        item_category: null
                                    });
                                }
                                if (response.data[r].type == 'service') {
                                    v.services.push({item: response.data[r], items: v.all_services});
                                }
                            }
                            v.inventories.push({
                                item: null,
                                selectedBrand: null,
                                selectedLocation: null,
                                commission: 'on',
                                row_commission_percent: null,
                                row_commission_amount: null,
                                code: null,
                                bundl: null,
                                sub_price: null
                            });
                            v.main_inventories.push({
                                item: null,
                                commission: 'on',
                                row_commission_percent: null,
                                row_commission_amount: null,
                                 inventory: null});
                            v.services.push({item: null, items: v.all_services});
                            // console.log('test check 1111', v.inventories);
                            v.invoiceDescription = v.selected_sale_order.description;
                            v.discountFiled = v.selected_sale_order.discount;
                            if (v.selected_sale_order.discount_type) {
                                if (v.selected_sale_order.discount_type == 'currency') {
                                    v.discountIsAmount = true;
                                } else {
                                    v.discountIsAmount = false;
                                }
                            }

                            for (var a = 0; a < this.currency.length; a++) {
                                if (v.currency[a].code == v.selected_sale_order.currency) {
                                    v.selected_currency = v.currency[a];
                                    v.selected_currency.rate = v.selected_sale_order.rate;
                                    v.rate = v.selected_sale_order.rate;
                                }
                            }

                        }

                    })
                    .catch(function(error) {
                        console.log(error);
                    })
            },
            // end contract search

            //ajax call to get items code
            onItemSearchCode: _.debounce((search, loading) => {

                if (v.inventories[v.selectedIndex].item != null && v.inventories[v.selectedIndex].item.site != null) {
                    item_id = v.inventories[v.selectedIndex].item.id;
                    inventory_site = v.inventories[v.selectedIndex].item.site.site_id;
                    loading(true);
                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'getAssebmliesSubSite',
                                keyword: search,
                                item_id: item_id,
                                inventory_site: inventory_site,
                            }
                        })
                        .then(function(response) {
                            // v.subItems = [];
                            if (response.data.length > 0) {
                                v.subItems[v.selectedIndex] = response.data;
                                v.subItemes = response.data;
                                // v.codeList = response.data;
                                // console.log('subItems', v.subItems);
                            }
                            loading(false);
                        })
                        .catch(function(error) {
                            console.log(error);
                        });
                }
            }, getDebounceTime()),

            //ajax call to get items code
            onSearchCode: _.debounce((search, loading) => {
                loading(true);
                var selectedIndex = v.selectedIndex;
                let inventory_brand_id = (v.inventories[selectedIndex]['selectedBrand'] != undefined) ? v.inventories[selectedIndex]['selectedBrand'].id : '';
                let location = (v.inventories[selectedIndex]['selectedLocation'] != undefined) ? v.inventories[selectedIndex]['selectedLocation'].name : '';
                let inventory_category_id = (v.inventories[selectedIndex]['item_category'] != undefined) ? v.inventories[selectedIndex]['item_category'].id : '';
                let inventory_site = (v.inventories[selectedIndex]['item'] != undefined) ? ((v.inventories[selectedIndex]['item'].site != undefined) ? v.inventories[selectedIndex]['item']['site'].site_id : '') : '';
                let item_id = (v.inventories[selectedIndex]['item'] != undefined) ? ((v.inventories[selectedIndex]['item'].sale_order_detail_id) ? v.inventories[selectedIndex]['item'].id : '') : '';
                
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'getAssebmliesSubSite',
                        keyword: search,
                        inventory_category_id: inventory_category_id,
                        brand_id: inventory_brand_id,
                        item_id: item_id,
                        location: location,
                        inventory_site: inventory_site,
                    }
                })
                .then(function(response) {
                    // v.subItems = [];
                    if (response.data.length > 0) {
                        v.subItems[v.selectedIndex] = response.data;
                        v.subItemes = response.data;
                        v.codeList = response.data;
                        // console.log('subItems', v.subItems);
                    }
                    loading(false);
                })
                .catch(function(error) {
                    console.log(error);
                });
            }, getDebounceTime()),

            //ajax call to get items code
            onSearchLocation: _.debounce((search, loading) => {
                loading(true);
                var selectedIndex = v.selectedIndex;
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'getLocationList',
                        keyword: search,
                    }
                })
                .then(function(response) {
                    // console.log(response);
                    if (response.data) {
                        if (response.data.data.length > 0) {
                            v.locationList = [];
                            v.locationList = response.data.data;
                        }
                    }
                    loading(false);
                })
                .catch(function(error) {
                    console.log(error);
                });
            }, getDebounceTime()),

            //ajax call to get items code
            onItemLoadCode(selectedIndex) {
                v.selectedIndex = selectedIndex;

                if (v.inventories[selectedIndex].inventory != null) {
                    if (v.inventories[0].item == null || !v.inventories[0].item.sale_order_detail_id) {
                        var inventory_id = v.inventories[selectedIndex].inventory.id;
                        let inventory_category_id = (v.inventories[selectedIndex]['item_category'] != undefined) ? v.inventories[selectedIndex]['item_category'].id : '';

                        // console.log('klk111',inventory_id,inventory_category_id);
                        axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    member_id: v.member_id,
                                    method_name: 'itemSearchSaleRoll',
                                    inventory_id: inventory_id,
                                    inventory_category_id: inventory_category_id,
                                }
                            })
                            .then(function(response) {
                                v.inventories[selectedIndex].item = null;
                                console.log('gg989', response.data);
                                if (response.data.length > 0) {
                                    v.inventories[selectedIndex].item = response.data[0];
                                    v.inventories[selectedIndex].code=null;
                                    v.inventories[selectedIndex].selectedBrand=null;
                                    v.inventories[selectedIndex].codeList=[];
                                    v.codeList=[];
                                    v.inventories[selectedIndex].selectedLocation=null;
                                    // console.log('gg989', response.data[0]);

                                    var sites_id = {{ getDropdown('invoiceRoll', 'site') }}
                                    if(sites_id){
                                        for (var i = 0; i < v.inventories[selectedIndex].item.site_list.length; i++) {
                                            if (v.inventories[selectedIndex].item.site_list[i].site_id == sites_id) {
                                                v.inventories[selectedIndex].item.site = v.inventories[selectedIndex].item.site_list[i];
                                            }
                                        }
                                    }

                                    v.onItemSearchCodeSelect(selectedIndex);
                                    // v.onItemSearchBrand(selectedIndex);

                                }
                            })
                            .catch(function(error) {
                                console.log(error);
                            })
                    } else {
                        v.inventories[selectedIndex].item = v.inventories[selectedIndex].inventory;
                        this.subItemes = null;
                        this.subItems[selectedIndex] = null;

                    }
                }



            },

            //ajax call to get items code
            onItemSearchCodeSelect(selectedIndex) {
                v.selectedIndex = selectedIndex;
                setTimeout(function() {
                    if (v.inventories[selectedIndex].item != null && v.inventories[selectedIndex].item.site != null) {

                        let = brand_id = null;
                        if (v.inventories[selectedIndex].item.selectedBrand != null) {
                            brand_id = v.inventories[selectedIndex].item.selectedBrand.id;
                        }
                        let location = (v.inventories[selectedIndex]['selectedLocation'] != undefined) ? v.inventories[selectedIndex]['selectedLocation'].name : '';
                        item_id = v.inventories[selectedIndex].item.id;
                        inventory_site = v.inventories[selectedIndex].item.site.site_id;
                        // console.log('selectedIndex', selectedIndex, item_id, inventory_site, brand_id);
                        axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    method_name: 'getAssebmliesSubSite',
                                    brand_id: brand_id,
                                    // location: location,
                                    item_id: item_id,
                                    inventory_site: inventory_site,
                                }
                            })
                            .then(function(response) {
                                    v.subItems[selectedIndex] = [];
                                    v.subItemes = [];
                                    v.codeList = [];
                                    v.inventories[selectedIndex].item.code = null;
                                    v.inventories[selectedIndex].code = null;
                                    v.inventories[selectedIndex].selectedLocation=null;
                                if (response.data.length > 0) {
                                    v.subItems[selectedIndex] = response.data;
                                    v.subItemes = response.data;
                                    v.codeList = response.data;
                                    v.inventories[selectedIndex].item.code = null;

                                    // v.subItems = response.data;
                                    // console.log('subItemss', v.subItems);
                                }
                            })
                            .catch(function(error) {
                                console.log(error);
                            });

                    }
                }, 100);

            },

            //ajax call to get items brand
            onItemSearchBrand(selectedIndex) {
                // v.brandItem = [];
                // v.brandItems[selectedIndex] = [];
                v.selectedIndex = selectedIndex;

                if (v.inventories[selectedIndex].selectedBrand != null) {
                    let inventory_brand_id = (v.inventories[selectedIndex]['selectedBrand'] != undefined) ? v.inventories[selectedIndex]['selectedBrand'].id : '';
                    let inventory_category_id = (v.inventories[selectedIndex]['item_category'] != undefined) ? v.inventories[selectedIndex]['item_category'].id : '';
                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'getAssebmliesSubSite',
                                brand_id: inventory_brand_id,
                                inventory_category_id: inventory_category_id,
                            }
                        })
                        .then(function(response) {
                            // v.subItems = [];
                            // m_stocks_in_id
                            console.log('subItems', response.data);
                            if (response.data.length > 0) {
                                // v.subItems[v.selectedIndex] = response.data;
                                // v.subItemes = response.data;
                                v.codeList = response.data;
                                if (response.data.length > 0) {
                                    v.inventories[selectedIndex].code=null;
                                    v.inventories[selectedIndex].item=null;
                                    v.inventories[selectedIndex].inventory=null;
                                    // console.log('subItems', response.data);
                                }
                            } else {
                                v.codeList = [];
                            }
                            // loading(false);
                        })
                        .catch(function(error) {
                            console.log(error);
                        });
                }

            },

            //ajax call to get items Location
            onItemSearchLocation(selectedIndex) {
                v.selectedIndex = selectedIndex;

                if (v.inventories[selectedIndex].selectedLocation != null) {
                    let inventory_brand_id = (v.inventories[selectedIndex]['selectedBrand'] != undefined) ? v.inventories[selectedIndex]['selectedBrand'].id : '';
                    let location = (v.inventories[selectedIndex]['selectedLocation'] != undefined) ? v.inventories[selectedIndex]['selectedLocation'].name : '';
                    let inventory_category_id = (v.inventories[selectedIndex]['item_category'] != undefined) ? v.inventories[selectedIndex]['item_category'].id : '';
                    let item_id = (v.inventories[selectedIndex]['item'] != undefined) ? v.inventories[selectedIndex]['item'].id : '';
                    let code = (v.inventories[selectedIndex]['code'] != undefined) ? v.inventories[selectedIndex]['code'].code : '';
                    // console.log(32, code, item_id, location);
                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'getAssebmliesSubSite',
                                brand_id: inventory_brand_id,
                                location: location,
                                item_id: item_id,
                                code: code,
                                inventory_category_id: inventory_category_id,
                            }
                        })
                        .then(function(response) {
                        if (response.data.length > 0) {
                            v.codeList = response.data;
                            let clear = 3;
                            let dataCode = null;
                            if (response.data.length > 0) {
                                for (var i = 0; i < response.data.length; i++) {
                                    if (response.data[i] && v.inventories[selectedIndex].code && v.inventories[selectedIndex].code != null) {
                                        if (clear != 1) {
                                            if (v.inventories[selectedIndex].code.id == response.data[i].id) {
                                                clear = 1;
                                            } else if (clear != 1 && clear != 2 && location == response.data[i].location && v.inventories[selectedIndex].code.inventory_id == response.data[i].inventory_id) {
                                                clear = 2;
                                                dataCode=response.data[i];
                                            }
                                        }
                                    }
                                }
                                if (clear == 2) {
                                    v.inventories[selectedIndex].code=dataCode;
                                }
                                if (clear == 3) {
                                    v.inventories[selectedIndex].code=null;
                                    v.inventories[selectedIndex].item=null;
                                    v.inventories[selectedIndex].inventory=null;
                                }
                                // console.log('subItems', response.data);
                            }
                        } else {
                            v.codeList = [];
                        }
                    })
                    .catch(function(error) {
                        console.log(error);
                    });
                }

            },

            setIndex(e) {
                this.selected_index = e;
            },
            itemCategoryChange(index) {
                v.setIndex(index);

                v.selected_iventory_category = this.main_inventories[this.selected_index]['item_category'];
                if (this.main_inventories[this.selected_index]['item_category'] != null) {
                    let inventory_category_id = this.main_inventories[this.selected_index]['item_category'].id;
                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                member_id: v.member_id,
                                method_name: 'itemesSearchSale',
                                inventory_category_id: inventory_category_id
                            }
                        })
                        .then(function(response) {
                            if (v.purchase_orders) {} else {
                                v.main_inventories[v.selected_index]['item'] = null;
                                v.main_inventories[v.selected_index]['inventory'] = null;
                            }
                            v.temp_main_items = [];
                            if (response.data.length > 0) {
                                v.temp_main_items = response.data;
                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        });
                }

            },

            itemCategoryChangeCode(index) {
                v.selected_iventory_category = this.inventories[index]['item_category'];
                if (this.inventories[index]['item_category'] != null) {
                    if (v.inventories[0].item == null || !v.inventories[0].item.sale_order_detail_id) {
                    let inventory_category_id = this.inventories[index]['item_category'].id;
                    // console.log(12312312,inventory_category_id);
                    axios.get("{{route('callMethod.search')}}", {

                            params: {
                                member_id: v.member_id,
                                method_name: 'itemSearchNameRoll',
                                inventory_category_id: inventory_category_id,
                            },
                        })
                        .then(function(response) {
                            if (response.data.length > 0) {
                                v.temp_items = [];
                                v.codeList = [];
                                v.inventories[index].code=null;
                                v.inventories[index].item=null;
                                v.inventories[index].inventory=null;
                                v.temp_items = response.data;
                                // console.log('pp', response.data);
                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        });
                } else {
                    // console.log('test check1', v.selected_sale_order);

                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'SaleOrderItemsRoll',
                                sale_order_id: v.selected_sale_order.id,
                                type: 'saleOrder'
                            }
                        })
                        .then(function(response) {
                            if (response.data.length > 0) {
                                v.temp_items = [];
                                v.temp_items = response.data;

                                v.invoiceDescription = v.selected_sale_order.description;
                                loading(false);
                            }

                        })
                        .catch(function(error) {
                            console.log(error);
                        })
                }
                }

            },



            onMainItemSearch: _.debounce((search, loading) => {

                loading(true);
                let inventory_category_id = (v.main_inventories[v.selected_index]['item_category'] != undefined) ? v.main_inventories[v.selected_index]['item_category'].id : '';

                axios.get("{{route('callMethod.search')}}", {
                        params: {
                            member_id: v.member_id,
                            method_name: 'itemesSearchSale',
                            keyword: search,
                            inventory_category_id: inventory_category_id,
                        }
                    })
                    .then(function(response) {
                        v.temp_main_items = [];
                        if (response.data.length > 0) {
                            v.temp_main_items = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        console.log(error);
                    })
            }, getDebounceTime()),


            onItemload(index) {
                v.selected_index = index;
                if (v.main_inventories[index].inventory != null) {
                    // console.log('klk',v.main_inventories[index].inventory,v.main_inventories);
                    var inventory_id = v.main_inventories[index].inventory.id;
                    let inventory_category_id = (v.main_inventories[index]['item_category'] != undefined) ? v.main_inventories[index]['item_category'].id : '';

                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                member_id: v.member_id,
                                method_name: 'itemSearchSale',
                                inventory_id: inventory_id,
                                inventory_category_id: inventory_category_id,
                            }
                        })
                        .then(function(response) {
                            v.main_inventories[index].item = null;
                            if (response.data.length > 0) {
                                v.main_inventories[index].item = response.data[0];

                                var sites_id = {{ getDropdown('invoice', 'site') }}
                                if(sites_id){
                                    for (var i = 0; i < v.main_inventories[index].item.site_list.length; i++) {
                                        if (v.main_inventories[index].item.site_list[i].site_id == sites_id) {
                                            v.main_inventories[index].item.site = v.main_inventories[index].item.site_list[i];
                                        }
                                    }
                                }
                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        })
                }
            },

            // calculate item price based on measure change
            mainMeasureChange(index) {

                if (this.main_inventories[index].item != null) {
                    var item = this.main_inventories[index].item;

                    var temp = ((item.rate * item.measure.measure_unit / item.measure_unit));
                    result = Number.parseFloat(temp).toFixed(precision());

                    this.main_inventories[index].item.new_rate = result;

                    // this.main_inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;

                }
            },

            // generic function for adding item to list
            addNew(type = null, index) {
                v.selectedIndex = index;
                // this.temp_items = [];
                if (type != null) {
                    if (type == 'inventory') {
                        if (this.inventories[index + 1] == undefined) {
                            this.temp_items = [];
                            this.inventories.push({
                                item: null,
                                selectedBrand: null,
                                selectedLocation: null,
                                commission: 'on',
                                row_commission_percent: null,
                                row_commission_amount: null,
                                bundl: null,
                                sub_price: null,
                                code: null
                            });
                        }
                    }
                    if (type == 'main_inventory') {
                        if (this.main_inventories[index + 1] == undefined) {
                            this.temp_main_items = [];
                            this.main_inventories.push({
                                item: null,
                                commission: 'on',
                                row_commission_percent: null,
                                row_commission_amount: null,
                            });
                        }
                    }
                    if (type == 'service') {
                        if (this.services[index + 1] == undefined) {
                            this.checkExistingService(index, '');
                            this.services.push({
                                items: this.all_services,
                                item: null,
                            });
                        }
                    }
                    if (type == 'payment') {
                        if (this.payments[index + 1] == undefined) {
                            this.checkExistingPayment(index, '');
                            this.payments.push({
                                items: this.banks,
                                item: null,
                            });
                        }
                    } 
                    if (type == 'installment') {
                        if (this.installments[index + 1] == undefined) {
                            this.installments.push({
                                items: this.currency,
                                item: null,
                            });
                        }
                    }
                }

            },

            // in here you can check and decide to allow duplicate bank for payment or not
            checkExistingPayment(index = null, name = '') {
                var bank_temp = this.banks.slice();
                var bank_temp1 = [];
                for (var i = 0; i < this.payments.length; i++) {
                    if (this.payments[i].item != null) {
                        var fined = bank_temp.findIndex((item) => item.name == this.payments[i].item.name);
                        if (fined != -1) {
                            var o = bank_temp.splice(bank_temp.findIndex((item) => item.name == this.payments[i].item.name), 1);
                        }
                    }
                }
                this.payments[index].items = bank_temp.filter((item) => {
                    return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                });
                //this.payments[index].items =bank_temp;


            },

            changePaymentRate(index) {
                setTimeout(() => {
                    var total_payment = this.$refs.total_payment[index].value;
                    var amount = this.payments[index].item.amount;
                    if (this.selected_currency.code != this.payments[index].item.code && this.payments[index].item.code != '{{getHomeCurrency()["code"]}}') {
                        @if(systemConfig()[30] == 1)
                        this.payments[index].item.rate = Number.parseFloat(amount) / (Number.parseFloat(total_payment) / this.selected_currency.static_rate * Number.parseFloat(this.selected_currency.rate));
                        @else 
                        this.payments[index].item.rate = Number.parseFloat(amount) / (Number.parseFloat(total_payment) / Number.parseFloat(this.selected_currency.rate));
                        @endif
                    } else if(this.selected_currency.code == this.payments[index].item.code) {
                        this.payments[index].item.rate = this.selected_currency.rate;
                    }
                }, 2000);
                // console.log(1221, total_payment, amount);
            },

            // in here you can check and decide to allow duplicate service or not
            checkExistingService(index = null, name = '') {
                var service_temp = this.all_services.slice();
                var service_temp1 = [];
                for (var i = 0; i < this.services.length; i++) {
                    if (this.services[i].item != null) {
                        var fined = service_temp.findIndex((item) => item.name == this.services[i].item.name);
                        if (fined != -1) {
                            var o = service_temp.splice(service_temp.findIndex((item) => item.name == this.services[i].item.name), 1);
                        }
                    }
                }
                this.services[index].items = service_temp.filter((item) => {
                    return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                });
                //this.payments[index].items =bank_temp;


            },
            // delete item from list
            deleteItem(type = null, index) {
                this.editKey = false;
                if (type != null) {
                    // console.log(type);
                    if (type == 'inventory') {
                        this.inventories.splice(index, 1);
                        this.subItems[index] = null;
                    }
                    if (type == 'main_inventory') {
                        this.main_inventories.splice(index, 1);
                    }
                    if (type == 'service') {
                        this.services.splice(index, 1);
                    }
                    if (type == 'payment') {
                        this.payments.splice(index, 1);
                    }
                    if (type == 'installment') {
                        this.installments.splice(index, 1);
                    }
                }

            },


            change_lengths(index) {
                if (this.ItemRoll[index].selected_sub_item) {
                    var per_qut_in = this.ItemRoll[index].selected_sub_item.per_qut_in;
                    var lengths = this.$refs.lengths[index].value;
                    this.ItemRoll[index].selected_sub_item.lengths = this.$refs.lengths[index].value;
                    this.ItemRoll[index].selected_sub_item.OnHand = (per_qut_in * lengths).toFixed(1);
                    this.ItemRoll[index].selected_sub_item.per_price = this.$refs.per_price[index].value;
                }
                setTimeout(function() {
                    v.deleteItem_roll(600);
                }, 30);
            },
            change_qut(index) {

                if (this.ItemRoll[index].selected_sub_item) {
                    var per_qut_in = this.ItemRoll[index].selected_sub_item.per_qut_in;
                    var OnHand = this.$refs.OnHand[index].value;
                    this.ItemRoll[index].selected_sub_item.OnHand = this.$refs.OnHand[index].value;
                    this.ItemRoll[index].selected_sub_item.lengths = (OnHand / per_qut_in).toFixed(1);
                    this.ItemRoll[index].selected_sub_item.per_price = this.$refs.per_price[index].value;
                }

                setTimeout(function() {
                    v.deleteItem_roll(600);
                }, 30);
            },

            // generic function for adding item to list
            // addNew_roll(index) {
            // v.subItems = [];
            // if (this.ItemRoll[index + 1] == undefined) {
            // this.ItemRoll.push({
            // selected_sub_item: null,
            // });
            // }


            // },
            // delete item from list
            deleteItem_roll(index) {
                this.ItemRoll.splice(index, 1);

            },

            // delete item from list
            addIndex(index) {

                if (v.inventories[index].item) {
                    if (v.inventories[index].item.code) {
                        // console.log('ffffffff',v.inventories[index].item.code)
                        v.inventories[index].item.code.lengths = null;
                    }
                }
                for (var i = 0; i < v.inventories.length; i++) {
                    if (v.inventories[i].item && v.inventories[index].item && i != index) {
                        // console.log(12,index,v.inventories[index].item);
                        if (v.inventories[i].item.code && v.inventories[index].item.code) {
                            if (v.inventories[i].item.code.id == v.inventories[index].item.code.id) {
                                v.inventories[index].item.code.lengths = 'duplicate';
                                // console.log(123213);
                            }
                        }
                    }
                }

                if (v.import_engine_number) {
                    for (var i = 0; i < v.inventories.length; i++) {
                        if (v.inventories[i].item) {
                            if (v.inventories[i].item.code != null) {
                                // var code = v.inventories[i]['item']['code'];
                                // let x = [];
                                // code.forEach(function(e) {
                                //     x.push(e.id);
                                // });
                                // v.inventories[i].item.item_location = x;
                            }
                        }
                    }
                }

                v.subItemes = [];
                // v.codeList = [];
                v.selectedIndex = index;
                v.subItemes = this.subItems[index];
                // v.codeList = this.subItems[index];

                // v.brandItem=[];
                // v.brandItem=this.brandItems[index];
                v.changeQuantityByWing(index);
                v.changeMetraz(index);
            },

            // submit the form
            submitForm() {

                if (this.isError == true) {
                    alert('there is no item');
                    return false;
                }
                swal({
                    title: "@lang('layout.AreYouSure?')",
                    buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                    text: "",
                    icon: "info",
                    dangerMode: true,
                }).then((willDelete) => {
                    if (willDelete) {
                        document.getElementById("sales-form").submit()

                    } else {
                        v.disabled = false;
                    }
                });

            },
            saveAndNew() {
                this.$validator.validate()
                .then(valid => {
                    if (valid) {
                        if (v.member_chack() == 'true') {
                            var r = confirm("@lang('layout.member_payable_levels')");
                            if (r == true) {
                                v.disabled = true;
                                var url = "{{route('invoice_roll.store')}}";
                                form_id = 'sales-form';
                                var data = $('#' + form_id).serialize();
                                toggleBlock(true);
                                axios.post(url, data)
                                .then(function(response) {
                                    toggleBlock(0);
                                    // console.log('sss11', response.data);
                                    if (response.data.result == 1) {
                                        $('#' + form_id).trigger('reset');
                                        //$('#success-sound')[0].play();
                                        toastr.success('', response.data.message);
                                        // v.number = Number(v.old_number) + 1;
                                        // v.old_number = Number(v.old_number) + 1;
                                        // v.ref_no = null;

                                        // v.defaultValue();
                                        location.reload();
                                    } else {
                                        var message = "{{__('message.Warning')}}";
                                        v.disabled = false;
                                        //$('#error-sound')[0].play();
                                        toastr.warning('', response.data[1]);
                                    }
                                })
                                .catch(function(error) {
                                    toggleBlock(0);
                                    v.disabled = false;
                                    console.log(error);
                                    var message = "{{__('message.Warning')}}";
                                    //$('#error-sound')[0].play();
                                    toastr.warning('', message);
                                });
                            }
                        } else {
                            v.disabled = true;
                            var url = "{{route('invoice_roll.store')}}";
                            form_id = 'sales-form';
                            var data = $('#' + form_id).serialize();
                            toggleBlock(true);
                            axios.post(url, data)
                            .then(function(response) {
                                toggleBlock(0);
                                // console.log('sss11', response.data);
                                if (response.data.result == 1) {
                                    $('#' + form_id).trigger('reset');
                                    //$('#success-sound')[0].play();
                                    toastr.success('', response.data.message);
                                    // v.number = Number(v.old_number) + 1;
                                    // v.old_number = Number(v.old_number) + 1;
                                    // v.ref_no = null;

                                    // v.defaultValue();
                                    location.reload();
                                } else {
                                    var message = "{{__('message.Warning')}}";
                                    v.disabled = false;
                                    //$('#error-sound')[0].play();
                                    toastr.warning('', response.data[1]);
                                }
                            })
                            .catch(function(error) {
                                toggleBlock(0);
                                v.disabled = false;
                                console.log(error);
                                var message = "{{__('message.Warning')}}";
                                //$('#error-sound')[0].play();
                                toastr.warning('', message);
                            });
                        }
                    }
                })
            },
            saveTemp() {
                var url = "{{route('temp.invoiceRoll.store')}}";
                form_id = 'sales-form';
                var data = $('#' + form_id).serialize();
                axios.post(url, data)
                    .then(function(response) {
                        // console.log('sss11', response);
                        callSaveTemp();
                    })
                    .catch(function(error) {
                        console.log(error);
                        callSaveTemp();
                    });
            },
            clearTemp() {
                axios.get("{{route('temp.clear')}}", {
                        params: {
                            type: 'invoiceRoll'
                        }
                    })
                    .then(function(response) {
                        // console.log('sss11', response);
                    })
                    .catch(function(error) {
                        console.log(error);
                    });
            },
        },


    });
</script>



@endpush