@extends('layouts.factor-master')
@section('content')
<?php 
  $report = customeReportNew('invoice_roll_index');
    $_record = !in_array('record', $report);
    $_date = !in_array('date', $report);
    $_hour = !in_array('hour', $report);
    $_invoiceNumber = !in_array('invoiceNumber', $report);
    $_referenceNumber = !in_array('referenceNumber', $report);
    $_customer = !in_array('customer', $report);
    $_transportCompany = !in_array('transportCompany', $report);
    $_driver = !in_array('driver', $report);
    $_accountName = !in_array('accountName', $report);
    $_amount = !in_array('amount', $report);
    $_currency = !in_array('currency', $report);
    $_rate = !in_array('rate', $report);
    $_discountType = !in_array('discountType', $report);
    $_discount = !in_array('discount', $report);
    $_user = !in_array('user', $report);
    $_total = !in_array('total', $report);

  $report_percent = customeReportNewPercent('invoice_roll_index');
    $_record_percent= (array_key_exists('record___percent', $report_percent))?$report_percent['record___percent']:null;
    $_date_percent= (array_key_exists('date___percent', $report_percent))?$report_percent['date___percent']:null;
    $_hour_percent= (array_key_exists('hour___percent', $report_percent))?$report_percent['hour___percent']:null;
    $_invoiceNumber_percent= (array_key_exists('invoiceNumber___percent', $report_percent))?$report_percent['invoiceNumber___percent']:null;
    $_referenceNumber_percent= (array_key_exists('referenceNumber___percent', $report_percent))?$report_percent['referenceNumber___percent']:null;
    $_customer_percent= (array_key_exists('customer___percent', $report_percent))?$report_percent['customer___percent']:null;
    $_transportCompany_percent= (array_key_exists('transportCompany___percent', $report_percent))?$report_percent['transportCompany___percent']:null;
    $_driver_percent= (array_key_exists('driver___percent', $report_percent))?$report_percent['driver___percent']:null;
    $_accountName_percent= (array_key_exists('accountName___percent', $report_percent))?$report_percent['accountName___percent']:null;
    $_amount_percent= (array_key_exists('amount___percent', $report_percent))?$report_percent['amount___percent']:null;
    $_currency_percent= (array_key_exists('currency___percent', $report_percent))?$report_percent['currency___percent']:null;
    $_rate_percent= (array_key_exists('rate___percent', $report_percent))?$report_percent['rate___percent']:null;
    $_discountType_percent= (array_key_exists('discountType___percent', $report_percent))?$report_percent['discountType___percent']:null;
    $_discount_percent= (array_key_exists('discount___percent', $report_percent))?$report_percent['discount___percent']:null;
    $_user_percent= (array_key_exists('user___percent', $report_percent))?$report_percent['user___percent']:null;
?>
<h3 class="table-caption" style="text-align: center;">@lang('layout.InvoiceReport')</h3>
<table class="main-table">
  <tr>
      @if($from_date)
          <td>
              <span>@lang('layout.FromDate')</span>:
              <BDO DIR="LTR"> @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($from_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif  {{convertDate($from_date)}}</BDO>
          </td>
      @endif
      @if($to_date)
          <td>
              <span>@lang('layout.ToDate')</span>:
              <BDO DIR="LTR">@if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($to_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif  {{convertDate($to_date)}}</BDO>
          </td>
      @endif
      @if($inventory_site_name)
      <td>
        @lang('layout.SiteName'): {{$inventory_site_name}}
      </td>
      @endif
  </tr>
</table>
<br>
<?php
$report = customeReport('invoice','index');
?>
  <table class="main-table">
    <thead>
      <tr class="bg">
      @if($_record)
      <td  class="center" @if($_record_percent) width="{{$_record_percent}}%" @endif style="text-align: center;font-weight: bold;"><div > @lang('layout.Record') </div></td>
      @endif
      @if($_date)
      <td  class="center" @if($_date_percent) width="{{$_date_percent}}%" @endif style="text-align: center;font-weight: bold;"><div > @lang('layout.Date')</div></td>
      @endif
      @if($_hour)
      <td  class="center" @if($_hour_percent) width="{{$_hour_percent}}%" @endif style="text-align: center;font-weight: bold;"><div > @lang('layout.Hour')</div></td>
      @endif
      @if($_invoiceNumber)
      <td  class="center" @if($_invoiceNumber_percent) width="{{$_invoiceNumber_percent}}%" @endif style="text-align: center;font-weight: bold;"><div > @lang('layout.InvoiceNumber') </div></td>
      @endif
      @if($_referenceNumber)
      <td  class="center" @if($_referenceNumber_percent) width="{{$_referenceNumber_percent}}%" @endif style="text-align: center;font-weight: bold;"><div > @lang('layout.ReferenceNumber') </div></td>
      @endif
      @if($_customer)
      <td  class="center" @if($_customer_percent) width="{{$_customer_percent}}%" @endif style="text-align: center;font-weight: bold;"><div > @lang('layout.Customer')</div></td>
      @endif
      @if(getTransportCompany()=="true")
      @if($_transportCompany)
      <td  class="center" @if($_transportCompany_percent) width="{{$_transportCompany_percent}}%" @endif style="text-align: center;font-weight: bold;"><div > @lang('menu.TransportCompany')</div></td>
      @endif
      @if($_driver)
      <td  class="center" @if($_driver_percent) width="{{$_driver_percent}}%" @endif style="text-align: center;font-weight: bold;"> <div > @lang('layout.Driver')</div></td>
      @endif
      @endif
      @if($_accountName)
      <td  class="center" @if($_accountName_percent) width="{{$_accountName_percent}}%" @endif style="text-align: center;font-weight: bold;"><div > @lang('layout.AccountName')</div></td>
      @endif
      @if($_amount)
      <td  class="center" @if($_amount_percent) width="{{$_amount_percent}}%" @endif style="text-align: center;font-weight: bold;"><div > @lang('layout.Amount')</div></td>
      @endif
      @if($_currency)
      <td  class="center" @if($_currency_percent) width="{{$_currency_percent}}%" @endif style="text-align: center;font-weight: bold;"><div > @lang('layout.Unit')</div></td>
      @endif
      @if($_rate)
      <td  class="center" @if($_rate_percent) width="{{$_rate_percent}}%" @endif style="text-align: center;font-weight: bold;"><div > @lang('layout.Rate')</div></td>
      @endif
      @if($_discountType)
      <td  class="center" @if($_discountType_percent) width="{{$_discountType_percent}}%" @endif style="text-align: center;font-weight: bold;"><div > @lang('layout.DiscountType')</div></td>
      @endif
      @if($_discount)
      <td  class="center" @if($_discount_percent) width="{{$_discount_percent}}%" @endif style="text-align: center;font-weight: bold;"><div > @lang('layout.Discount')</div></td>
      @endif
      @if($_user)
      <td  class="center" @if($_user_percent) width="{{$_user_percent}}%" @endif style="text-align: center;font-weight: bold;"><div > @lang('layout.User')</div></td>
      @endif
      </tr>
    </thead>
    <?php
      $count = 0;
      $total_home_currency=0;
      $currencies=[];
    ?>
    @foreach($data AS $record)
      <tr>
        <?php
          $total_home_currency+=$record->exchanged_amount;
          if(array_key_exists($record->Currency, $currencies))
          {
            $currencies[$record->Currency]=$currencies[$record->Currency]+$record->Amount;
          }
          else
          {
            $currencies[$record->Currency]=$record->Amount;
          }
        ?>
        @if($_record)
          <td class="center">{{++$count}}</td>
        @endif
        @if($_date)
        <td style="display: <?=(!show('date',$report))?'none':'';?>" class="center">
        {{convertDate($record->Date)}}
        </td>
        @endif
        @if($_hour)
        <td  class="center">
          @if(getHourType() == 24)
          {{ (($record->hour != null)?(date_format(date_create($record->hour), 'H:i')):'') }}
          @else
          {{ (($record->hour != null)?(date_format(date_create($record->hour), 'h:i:a')):'') }}
          @endif
        </td> 
        @endif
        @if($_invoiceNumber)
          <td style="display: <?=(!show('invoice_number',$report))?'none':'';?>" class="center">{{$record->Number}}</td>
        @endif
        @if($_referenceNumber)
          <td style="display: <?=(!show('ref_Number',$report))?'none':'';?>" class="center">{{$record->ref_Number}}</td>
        @endif
        @if($_customer)
          <td style="display: <?=(!show('customer',$report))?'none':'';?>" class="center">{{$record->Name}}</td>
        @endif
        @if(getTransportCompany()=="true")
          @if($_transportCompany)
            <td class="center">{{$record->trasnport_name}}</td>
          @endif
          @if($_driver)
            <td class="center">{{$record->driver_name}}</td>
          @endif
        @endif
        @if($_accountName)
          <td style="display: <?=(!show('account_name',$report))?'none':'';?>" class="center">{{$record->Account}}</td>
        @endif
        @if($_amount)
          <td style="display: <?=(!show('amount',$report))?'none':'';?>" class="center">{{$record->Amount}}</td>
        @endif
        @if($_currency)
          <td style="display: <?=(!show('unit',$report))?'none':'';?>" class="center">{{$record->Unit}}</td>
        @endif
        @if($_rate)
          <td style="display: <?=(!show('rate',$report))?'none':'';?>" class="center">{{$record->rate}}</td>
        @endif
        @if($_discountType)
          <td style="display: <?=(!show('discount_type',$report))?'none':'';?>" class="center">{{$record->discount_type}}</td>
        @endif
        @if($_discount)
          @if($record->discount_type == 'percent')<td  class="center">{{$record->discount1}}</td>
          @else<td  class="center">{{$record->Discount}}</td>@endif
        @endif
        @if($_user)
          <td  class="center">{{$record->user}}</td>
        @endif
      </tr>
    @endforeach  
  </table>
  @if($_total)
  <table class="main-table">
    <tr class="bg">
      <td colspan="3" style="font-weight: bold;"><div class="center">@lang('layout.PerCurrency')</div></td>
    </tr>
    <tr>
      <td style="text-align: center; font-weight: bold;"><div class="center"> @lang('layout.Record') </div></td>
      <td style="text-align: center; font-weight: bold;"><div class="center"> @lang('layout.Currency') </div></td>
      <td style="text-align: center; font-weight: bold;"><div class="center"> @lang('layout.Amount') </div></td>
    </tr>
    <?php
    $count=0;
    foreach($currencies As $key=>$currency)
    {
      ?>
      <tr>
        <td style="text-align: center;"><div class="center">{{++$count}}</div></td>
        <td style="text-align: center;"><div class="center">{{$key}}</div></td>
        <td style="text-align: center;"><div class="center">{{round($currency,2)}}</div></td>
      </tr>
      <?php
    }
    ?>
    <tr>
    <td colspan="2" style="text-align: center; font-weight: bold;"><div class="center">@lang('layout.HomeCurrencyTotal')</div></td>
    <td style="text-align: center;"><div class="center">{{round($total_home_currency,2)}}  {{getHomeCurrency()[getCurrencyType()]}}</div></td>
    </tr>
  </table>
  @endif
 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >    
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection