@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

@section('content')
@include("layouts.Cmodal")
@include("invoices.modal")
<div class="row">
    <div class="portlet light bordered sale">
        <!-- BEGIN TAB PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-anchor font-green-sharp"></i>&nbsp;
                    <span class="caption-subject font-green-sharp bold uppercase">@lang('layout.CreateNewInvoice')</span>
                </div>
                <div class="actions">
                </div>
            </div>
            <div id="appInvoice" class="portlet-body" v-cloak>
                <div class="tabbable tabbable-tabdrop">

                    <div>
                        {{Form::open(['route' => 'invoice.store','method' => 'POST','class' => 'form-horizontal','id'=>'sales-form'])}}
                        {{ csrf_field() }}
                        <div class="tab-content">

                            <div class="tab-pane active" id="tab1">

                                <div v-cloak class="portlet-body form" style="margin-bottom:50%;">
                                    

                                    <!-- BEGIN FORM-->


                                    <div class="form-body">
                                        <div class="row">
                                            <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12">
                                            <input type="hidden" name="temp_type" value="invoice">
                                                <!-- begin inputs -->
                                                
                                                <div class="row">
                                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                        <div class="form-group">
                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.Customer') </label>
                                                                <div class="input-group">
                                                                    <v-select label="name"  :options="customer" v-model="selected_customer"></v-select>
                                                                    <input type="hidden" name="customer" v-validate="'required'" data-vv-as="@lang('layout.Customer')" :value="!selected_customer?null:selected_customer.id" required>
                                                                </div>

                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                        <div class="form-group">

                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.InvoiceNumber')</label>

                                                                <input type="number" name="number" v-validate="'required|numeric'" data-vv-as="@lang('layout.InvoiceNumber')" @input="checkNo()" v-model="number" class="form-control">
                                                                <span class="required">@{{ errors.first('number') }}</span>
                                                                <span v-if="number_Error ==true" class="input-has-error" style="color: red">@{{number_msg}}</span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                        <div class="form-group">

                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.ReferenceNumber')</label>

                                                                <input type="text" name="ref_no" v-model="ref_no" class="form-control" @input="checkRefNo()">
                                                                <span v-if="isError1 ==true" class="input-has-error" style="color: red">@{{msg}}</span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                </div>

                                                <div class="row">
                                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                        <div class="form-group">

                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.Currency')</label>
                                                                <v-select label="code" @input="selectedRate" :options="setRates" v-model="selected_currency"></v-select>
                                                                <input type="hidden" name="currency" v-validate="'required'" data-vv-as="@lang('layout.Currency')" :value="selected_currency.code">
                                                                <span class="required">@{{ errors.first('currency') }}</span>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                        <div class="form-group">
                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.Rate')</label>

                                                                <input type="number" name="currency_rate" v-validate="'required'" data-vv-as="@lang('layout.Rate')" v-model="!selected_currency?0:selected_currency.rate" class="form-control" :class="{'has-error':rate<=0}">
                                                                <span class="required">@{{ errors.first('currency_rate') }}</span>

                                                                <input type="hidden" name="currency_rate_hq" v-model="!selected_currency?0:selected_currency.hq_rate" class="form-control">
                                                            </div>
                                                        </div>
                                                    </div>


                                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                        <div class="form-group">

                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.Discount')</label>

                                                                <div class="input-group">

                                                                    <input v-model="discountFiled" class="form-control" type="number" min="0" max="100">
                                                                    <span v-if="discountIsAmount" @click="discountIsAmount = !discountIsAmount" class="input-group-addon">@{{selected_currency.symbol}}
                                                                        <input type="hidden" class="input-group-addon" name="discount_type" value="currency">
                                                                    </span>
                                                                    <span v-else @click="discountIsAmount = !discountIsAmount" class="input-group-addon">%
                                                                        <input type="hidden" name="discount_type" value="percent">
                                                                    </span>
                                                                    <input type="hidden" name="discountTotal" :value="discount">
                                                                    <input type="hidden" name="discount" :value="discountFiled">
                                                                </div>

                                                            </div>
                                                        </div>
                                                    </div>
                                                    
                                                </div>

                                                <div class="row">

                                                    
                                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                        <div class="form-group">

                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.Date')</label>
                                                                <date_picker name="date" v-model="date" placeholder="@lang('layout.Date')" ></date_picker>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                        <div class="form-group">

                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.OverdueDate')</label>
                                                                <date_picker name="overdue_date" v-model="overdue_date" placeholder="@lang('layout.OverdueDate')" ></date_picker>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                        <div class="form-group">
                                                            <div class="col-md-12">
                                                                <label class="control-label">@lang('layout.Description')</label>
                                                                <textarea name="description" class="form-control" rows="1" v-text="invoiceDescription"></textarea>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!-- end inputs -->
                                            </div>
                                            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">

                                                <!-- begin total -->
                                                <div class="dashboard-stat2 " v-show="seePrice== true" style="margin-bottom: 0px; padding-bottom: 10px;">
                                                    <table class="dashboard-tabel" width="100%">
                                                        <tr>
                                                            <td>
                                                                <small>@lang('layout.Total') :</small>
                                                            </td>
                                                            <td class="text-right">
                                                                <span data-counter="counterup" data-value="7800">
                                                                    @{{ format_number(Number.parseFloat(((subtotal - (discount*(newSubTotal - newSubDiscountFiledRow)/100) - discountFiledRow) - saleTaxation)-payeds))}}
                                                                </span>
                                                                <small class="font-green-sharp">
                                                                    @{{selected_currency.symbol}}
                                                                </small>
                                                            </td>
                                                        </tr>

                                                        <tr>
                                                            <td>
                                                                <small>@lang('layout.Discount'): (@{{
                                                                        format_number(Number.parseFloat(discount))
                                                                        }}%)
                                                                </small>
                                                            </td>
                                                            <td class="text-right">
                                                                <span class="text-right" data-counter="counterup" data-value="7800">
                                                                    @{{ format_number(Number.parseFloat(discount*(newSubTotal - newSubDiscountFiledRow)/100)+Number.parseFloat(discountFiledRow)) }}
                                                                </span>
                                                                <small class="font-green-sharp">
                                                                    @{{selected_currency.symbol}}
                                                                </small>
                                                            </td>
                                                        </tr>

                                                        @if(getSaleTaxation() == 'true')
                                                        <tr>
                                                            <td>
                                                                <small>@lang('menu.Taxation'): (@{{
                                                                        format_number(Number.parseFloat(sale_taxation))
                                                                        }}%)
                                                                </small>
                                                            </td>
                                                            <td class="text-right">
                                                                <span class="text-right" data-counter="counterup" data-value="7800">
                                                                    @{{ format_number(Number.parseFloat(saleTaxation)) }}
                                                                </span>
                                                                <small class="font-green-sharp">
                                                                    @{{selected_currency.symbol}}
                                                                </small>
                                                            </td>
                                                        </tr>
                                                        @endif

                                                        <tr>
                                                            <td>
                                                                <small>@lang('layout.Payment'):</small>
                                                            </td>
                                                            <td class="text-right">
                                                                <small class="font-green-sharp">
                                                                    <span class="text-right" data-counter="counterup" data-value="7800">@{{ format_number(Number(payeds))}}</span>
                                                                    <small class="font-green-sharp">
                                                                        @{{selected_currency.symbol}}
                                                                    </small>
                                                                </small>
                                                            </td>
                                                        </tr>


                                                        <tr>
                                                            <td>
                                                                <small>@lang('layout.GrandTotal'):</small>
                                                            </td>
                                                            <td class="text-right">
                                                                <span class="text-right" data-counter="counterup" data-value="7800">
                                                                    @{{ format_number(Number(subtotal))}}
                                                                </span>
                                                                <small class="font-green-sharp">
                                                                    @{{selected_currency.symbol}}
                                                                </small>
                                                            </td>
                                                        </tr>
                                                    </table>

                                                </div>
                                                <!-- end total -->

                                                @if(getTaxation() =="true")
                                                <!-- begin total tax -->
                                                <div class="dashboard-stat2 " v-show="seePrice== true" style="margin-bottom: 0px; padding-bottom: 10px;">
                                                    <table class="dashboard-tabel" width="100%">
                                                        <tr>
                                                            <td>
                                                                <small>@lang('layout.Total') @lang('layout.Tax') :</small>
                                                            </td>
                                                            <td class="text-right">
                                                                <span data-counter="counterup" data-value="7800">
                                                                    @{{ myRound(totalTax)}}
                                                                </span>
                                                                <small class="font-green-sharp">
                                                                    @{{selected_currency.symbol}}
                                                                </small>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td>
                                                                <small>@lang('layout.Sub-Total'):</small>
                                                            </td>
                                                            <td class="text-right">
                                                                <span class="text-right" data-counter="counterup" data-value="7800">
                                                                    @{{ format_number(Number(checkedSubtotal))}}
                                                                </span>
                                                                <small class="font-green-sharp">
                                                                    @{{selected_currency.symbol}}
                                                                </small>
                                                            </td>
                                                        </tr>
                                                    </table>

                                                </div>
                                                <!-- end total -->
                                                @endif

                                                <div class="dashboard-stat2" v-if="selected_customer && summary.length > 0">

                                                    <table class="dashboard-tabel table-bordered" width="100%">
                                                        <thead>
                                                            <tr>
                                                                <th>@lang('layout.Currency') </th>
                                                                <th>@lang('layout.Payable')</th>
                                                                <th>@lang('layout.Receivable')</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <span>
                                                                <tr v-for="summ in summary">
                                                                    <td class="highlight">
                                                                        @{{ summ.currency }}
                                                                    </td>
                                                                    <td class="hidden-xs"> @{{ format_number(Number(summ.payment)) }}</td>
                                                                    <td>
                                                                        @{{format_number(Number(summ.invoice)) }}
                                                                    </td>
                                                                </tr>
                                                            </span>
                                                        </tbody>
                                                    </table>
                                                </div>

                                                @if(getSubTotal() == 'true')
                                                <div class="dashboard-stat2">

                                                    <table class="dashboard-tabel table-bordered" width="100%">
                                                        <thead>
                                                            <tr>
                                                                <th>
                                                                    <center>@lang('layout.Sub-Total')</center>
                                                                </th>
                                                                <th>
                                                                    <center>@lang('layout.Discount'): (@{{
                                                                        format_number(Number.parseFloat(discount))
                                                                        }}%)
                                                                    </center>
                                                                </th>
                                                                <th>
                                                                    <center>@lang('layout.Total')</center>
                                                                </th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <span>
                                                                <tr>
                                                                    <td class="highlight">
                                                                        <center>
                                                                            <span class="text-right" data-counter="counterup" data-value="7800">
                                                                                @{{ format_number(Number(sub_Subtotal))}}
                                                                            </span>
                                                                            <small class="font-green-sharp">
                                                                                @{{selected_currency.symbol}}
                                                                            </small>
                                                                        </center>
                                                                    </td>
                                                                    <td class="hidden-xs">
                                                                        <center>
                                                                            <span class="text-right" data-counter="counterup" data-value="7800">
                                                                                @{{ format_number(Number.parseFloat(sub_discount*(sub_Subtotal - subDiscountFiledRow)/100)+Number.parseFloat(subDiscountFiledRow)) }}
                                                                            </span>
                                                                            <small class="font-green-sharp">
                                                                                @{{selected_currency.symbol}}
                                                                            </small>
                                                                        </center>
                                                                    </td>
                                                                    <td>
                                                                        <center>
                                                                            <span data-counter="counterup" data-value="7800">
                                                                                @{{ format_number(Number.parseFloat((sub_Subtotal - (sub_discount*(sub_Subtotal - subDiscountFiledRow)/100) - subDiscountFiledRow) - saleTaxation))}}
                                                                            </span>
                                                                            <small class="font-green-sharp">
                                                                                @{{selected_currency.symbol}}
                                                                            </small>
                                                                        </center>
                                                                    </td>
                                                                </tr>
                                                            </span>
                                                        </tbody>
                                                    </table>
                                                </div>
                                                @endif

                                                @if(getSaleSubMeasure()=="true")
                                                <div class="dashboard-stat2">

                                                    <table class="dashboard-tabel table-bordered" width="100%">

                                                        <tbody>
                                                            <span>
                                                                <tr>
                                                                    <td class="highlight">
                                                                        @lang('layout.Total')
                                                                    </td>
                                                                    <td>
                                                                        @{{format_number(this.total_qty_amount)}}
                                                                    </td>
                                                                </tr>
                                                            </span>
                                                        </tbody>
                                                    </table>
                                                </div>

                                                @endif

                                            </div>

                                        </div>

                                        <div class="row" style="overflow-x: scroll;">
                                            <table id="table_content" class="table table-bordered table-advance table-hover">
                                                <thead>
                                                    <tr>
                                                        <th>#</th>
                                                        <th v-show="showWhat('sale_category')=='yes'" style="min-width: 130px">@lang('layout.Category') </th>
                                                        <th v-show="showWhat('inventory_brand')=='yes'" style="min-width: 130px">@lang('layout.Brand') </th>
                                                        <th style="min-width: {{itemFieldWidth()}}px">@lang('layout.ItemName') </th>
                                                        <th style="min-width: 100px">@lang('layout.SiteName') </th>
                                                        <th style="min-width: 50px">@lang('layout.Quantity') </th>
                                                        <th v-show="showWhat('other_measure')=='yes'" style="min-width: 100px">@lang('layout.OMeasureValue1')
                                                        </th>
                                                        <th v-show="showWhat('other_measure2')=='yes'" style="min-width: 100px">@lang('layout.OMeasureValue2')
                                                        </th>
                                                        <th style="min-width: 100px">@lang('layout.Measure') </th>
                                                        @if(getShwoPriceLevel()=="per_item")
                                                        <th style="min-width: 100px">@lang('layout.PriceLevel') </th>
                                                        @endif
                                                        @if(getShwoPriceLevel()=="general_percent_per_item")
                                                        <th style="min-width: 100px">@lang('layout.PriceLevel') </th>
                                                        @endif

                                                        <th v-show="seePrice==true" style="min-width: 50px">@lang('layout.NewPrice') </th>

                                                        @if(getM2()!="")
                                                        <th style="min-width: 100px">@lang('layout.Measure2') </th>
                                                        @endif
                                                        @if(getM3()!="" && getSaleSubMeasure()!="true")
                                                        <th style="min-width: 100px">@lang('layout.Measure3') </th>
                                                        @endif
                                                        @if(getSaleSubMeasure()=="true")
                                                        <th style="min-width: 100px">@lang('layout.EquivalentTo') </th>
                                                        <th v-show="seePrice==true && sub_price==true" style="min-width: 50px">@lang('layout.SubPrice') </th>
                                                        @endif
                                                        @if(getM4()!="")
                                                        <th v-if="oil_sale == false" style="min-width: 100px">@lang('layout.Measure4') </th>
                                                        @endif
                                                        @if(getTaxation()=="true")
                                                        <th style="min-width: 100px">@lang('layout.Tax') </th>
                                                        <th style="min-width: 50px">@lang('layout.Percentage')%</th>
                                                        @endif
                                                        <th v-show="showWhat('sale_discount')=='yes'" style="min-width: 50px">@lang('layout.Discount') </th>
                                                        <th v-show="seePrice==true" style="min-width: 80px">@lang('layout.Total')</th>
                                                        @if(getSubTotal() =="true")
                                                        <th v-show="seePrice==true">@lang('layout.Subtotal')</th>
                                                        @endif
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr v-for="(item,index) in inventories">
                                                        <td>@{{index+1}}</td>
                                                        <td v-show="showWhat('sale_category')=='yes'">
                                                            <v-select label="name" v-model="item.item_category" :options="inventory_category" ></v-select>
                                                            <input type="hidden" name="inventory_category_id[]" :value="(!item.item_category)?null:item.item_category.id">
                                                        </td>
                                                        <td v-show="showWhat('inventory_brand')=='yes'">
                                                            <v-select label="name" v-model="item.item_brand" :options="brandItem" ></v-select>
                                                            <input type="hidden" name="inventory_brand_id[]" :value="(!item.item_brand)?null:item.item_brand.id">
                                                        </td>
                                                        <td class="highlight">
                                                            <!-- @click.native="addNew('inventory',index)" -->
                                                            <div class="input-group">
                                                                <v-select label="name"  v-model="item.inventory" :options="temp_items" @search="onItemSearch" @if(TabIndexInItemName() =="true") tabindex="1" @endif ></v-select>
                                                                <input type="hidden" :name="'inventory_id['+index+']'" v-validate="''" data-vv-as="@lang('layout.ItemName')" :value="(!item.item)?null:item.item.id">
                                                                
                                                            </div>
                                                        </td>
                                                        <td class="highlight" >
                                                            <select v-model="(item.item==null)?null:item.item.site" class="form-control">
                                                                <option value="null">@lang('layout.Select')</option>

                                                                <span v-if="(item.item != null)">
                                                                    <option v-for="site in (item.item==null)?null:item.item.site_list" :value="site">
                                                                        @{{site.site_name}}
                                                                    </option>
                                                                </span>
                                                            </select>

                                                            <input type="hidden" name="inventory_site[]" :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.site_id)">
                                                        </td>
                                                        <td>
                                                            <input type="number" :name="'inventory_quantity['+index+']'" oninput = "autowidths(event)" v-validate="''" data-vv-as="@lang('layout.Quantity')" v-model.number="(item.item==null)?null:item.item.quantity" class="form-control input-style input-number chan_length" @input="change_oil_qty(index), setNewRate('inventory',index)" placeholder="@lang('layout.Quantity')">
                                                        </td>
                                                        <td v-show="showWhat('other_measure')=='yes'">
                                                            <div class="input-group">
                                                                <input type="number" name="other_measure_amount[]" class="form-control input-style input-number chan_length" oninput = "autowidths(event)" placeholder="@lang('layout.OMeasureValue1')" @input="change_per_qty(index)" v-model.number="(item.item==null)?null:item.item.other_measure">
                                                                <input type="hidden" name="per_qty[]" :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.per_qty)">
                                                                @if(getSaleByOtherMeasure() == "true")
                                                                <span class="input-group-addon" v-if="(item.item==null)?null:((item.item.site==null)?null:item.item.site.per_qty) > 0">
                                                                    @{{myRound((item.item==null)?null:((item.item.site==null)?null:(item.item.site.OnHand / item.item.site.per_qty)))}}
                                                                </span>
                                                                @else
                                                                <span class="input-group-addon">
                                                                    @{{(item.item==null)?null:item.item.o_measure_v}}
                                                                </span>
                                                                @endif
                                                            </div>
                                                        </td>
                                                        <td v-show="showWhat('other_measure2')=='yes'">
                                                            <div class="input-group">
                                                                <input type="number" name="other_measure_amount2[]" class="form-control input-style input-number chan_length" oninput = "autowidths(event)" placeholder="@lang('layout.OMeasureValue2')" v-model.number="(item.item==null)?null:item.item.other_measure2">
                                                                <input type="hidden" name="per_qty2[]" :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.per_qty2)">
                                                                @if(getSaleByOtherMeasure() == "true")
                                                                <span class="input-group-addon" v-if="(item.item==null)?null:((item.item.site==null)?null:item.item.site.per_qty2) > 0">
                                                                    @{{myRound((item.item==null)?null:((item.item.site==null)?null:(item.item.site.OnHand / item.item.site.per_qty2)))}}
                                                                </span>
                                                                @else
                                                                <span class="input-group-addon">
                                                                    @{{(item.item==null)?null:item.item.o_measure_v1}}
                                                                </span>
                                                                @endif
                                                            </div>
                                                        </td>
                                                        <td class="highlight">
                                                            <select v-model="(item.item == null)?null:item.item.measure" class="form-control" @change="measureChange(index)" >
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(item.item ==null)?false:true">
                                                                    <option v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure">
                                                                        @{{measure.measure_name}}
                                                                    </option>
                                                                </span>

                                                            </select>

                                                            <input type="hidden" name="inventory_measure[]" :value="(item.item==null)?null:item.item.measure.measure_id">
                                                        </td>

                                                        @if(getShwoPriceLevel()=="per_item")
                                                        <td>
                                                            <select v-model="(item.item == null)?null:item.price_level" class="form-control" @change="change_sale_rate_by_price_level(index)">
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(item.item ==null)?false:true">
                                                                    <option v-for="price_level in (item.item==null)?null:item.item.item_price_level" :value="price_level">
                                                                        @{{price_level.name}}
                                                                    </option>
                                                                </span>
                                                            </select>

                                                            <input type="hidden" name="item_price_level_id[]" :value="(item.price_level == null)?null:item.price_level.id">
                                                        </td>
                                                        @endif

                                                        @if(getShwoPriceLevel()=="general_percent_per_item")
                                                        <td>
                                                            <select v-model="(item.item == null)?null:item.price_level" class="form-control" @change="change_sale_rate_by_price_level_general_per_item(index)">
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(item.item ==null)?false:true">
                                                                    <option v-for="price_level in (item.item==null)?null:priceLevelGeneral" :value="price_level">
                                                                        @{{price_level.name}}
                                                                    </option>
                                                                </span>
                                                            </select>

                                                            <input type="hidden" name="item_price_level_id[]" :value="(item.price_level == null)?null:item.price_level.id">
                                                        </td>
                                                        @endif

                                                        <td v-show="seePrice==true">
                                                            <div class="input-group">
                                                                <input type="number" name="inventory_price[]" placeholder="@lang('layout.Price')" v-bind:value="(item.item==null)?null:saleNewRate(item.item,selected_currency.rate)" ref="in" @input="setNewRate('inventory',index)" oninput = "autowidths(event)" class="form-control chan_length">
                                                                <span class="input-group-addon">
                                                                    @{{selected_currency.symbol}}
                                                                </span>
                                                            </div>
                                                            <span v-show="((item.item==null)?null:checkCheap(item.item,selected_currency.rate))==true" class="required">@lang('layout.SalesToTheDetriment')</span>
                                                        </td>

                                                        @if(getM2()!="" && getSaleSubMeasure()!="true")
                                                        <td>
                                                            <div class="input-group">
                                                                <select name="measure1[]" class="form-control" v-model="(item.item==null)?null:item.item.measure1.measure_id">
                                                                    <option value="null">@lang('layout.Select')</option>
                                                                    <span v-if="(item.item ==null)?false:true">
                                                                        <option v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure.measure_id">
                                                                            @{{measure.measure_name}}
                                                                        </option>
                                                                    </span>
                                                                </select>
                                                                @if(getSaleAmountSecondMeasure()=="true")
                                                                <span class="input-group-addon">
                                                                    @{{myRound((item.item==null)?null:secoundMeasurQuantity(item.item,item.item.quantity))}}
                                                                </span>
                                                                @endif
                                                            </div>
                                                        </td>
                                                        @endif
                                                        @if(getM3()!="")
                                                        <td>
                                                            <select name="measure2[]" class="form-control" @change="measure2Change(index)" v-model="(item.item==null)?null:item.item.measure2.measure_id">
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(item.item ==null)?false:true">
                                                                    <option v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure.measure_id">
                                                                        @{{measure.measure_name}}
                                                                    </option>
                                                                </span>
                                                            </select>
                                                        </td>
                                                        @endif
                                                        @if(getSaleSubMeasure() =="true")
                                                        <td>
                                                            @{{myRound((item.item==null)?null:subMQuantity(item.item,item.item.quantity))}}
                                                        </td>
                                                        <td v-show="seePrice==true && sub_price==true">
                                                            <div class="input-group">
                                                                <input type="number" placeholder="@lang('layout.SubPrice')" v-model="(item.item==null)?null:item.sub_price" @input="setNewRateTotal(index)" oninput = "autowidths(event)" class="form-control chan_length">
                                                                <span class="input-group-addon">
                                                                    @{{selected_currency.symbol}}
                                                                </span>
                                                            </div>
                                                        </td>
                                                        @endif
                                                        @if(getM4()!="")
                                                        <td v-if="oil_sale == false">
                                                            <select name="measure3[]" class="form-control" v-model="(item.item==null)?null:item.item.measure3.measure_id">
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(item.item ==null)?false:true">
                                                                    <option v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure.measure_id">
                                                                        @{{measure.measure_name}}
                                                                    </option>
                                                                </span>
                                                            </select>
                                                        </td>
                                                        @endif
                                                        @if(getTaxation()=="true")
                                                        <td>
                                                            <span v-show="!item.tax">
                                                                <v-select v-model="item.selected_taxation" label="name" :options="taxation" @input="getDrivers">
                                                                </v-select>
                                                                <input type="hidden" :name="'row_taxation_id['+index+']'" :value="!item.selected_taxation?null:item.selected_taxation.id" />
                                                                <input type="hidden" :name="'row_taxation_vendor_id['+index+']'" :value="!item.selected_taxation?null:item.selected_taxation.member_id" />
                                                                <input type="hidden" :name="'row_tax_amount['+index+']'" :value="!item.selected_taxation?null:item.row_tax_amount" />
                                                            </span>
                                                        </td>
                                                        <td>
                                                            <span v-show="!item.tax">
                                                                <input type="number" class="form-control chan_length" :name="'row_percent_tax['+index+']'" oninput = "autowidths(event)" v-model="!item.selected_taxation?null:item.selected_taxation.percent" />
                                                            </span>
                                                        </td>
                                                        @endif
                                                        <td v-show="showWhat('sale_discount')=='yes'">
                                                            <div class="input-group">
                                                                <input type="number" name="inventory_discount[]" placeholder="@lang('layout.Discount')" v-model.number="(item.item==null)?null:item.item.discount" oninput = "autowidths(event)" class="form-control chan_length">
                                                                <span class="input-group-addon" v-if="discountIsAmount">
                                                                    @{{selected_currency.symbol}}
                                                                </span>
                                                                <span class="input-group-addon" v-if="!discountIsAmount">
                                                                    %
                                                                </span>

                                                            </div>

                                                        </td>
                                                        <td v-if="oil_sale == false" v-show="seePrice==true">
                                                            @{{(item.item==null)? 0:getItemTotal(item.item,selected_currency.rate,discountIsAmount,item.item.discount,selected_currency.hq_rate,per_qty_check).result}}
                                                            @{{selected_currency.symbol}}
                                                        </td>
                                                        <td v-if="oil_sale == true" v-show="seePrice==true">
                                                            @{{(item.item==null)? 0:getItemTotalOil(item.item,selected_currency.rate,discountIsAmount,item.item.discount,selected_currency.hq_rate).result}}
                                                            @{{selected_currency.symbol}}
                                                        </td>
                                                        @if(getSubTotal() =="true")
                                                        <td>
                                                            <div class="mt-checkbox" style="padding-left: 0px;">
                                                                <label class="mt-checkbox mt-checkbox-outline">
                                                                    <input type="checkbox" :name="'row_sub_total_stat['+index+']'" v-model="item.sub_total" />
                                                                    <span></span>
                                                                </label>
                                                            </div>
                                                        </td>
                                                        @endif

                                                    </tr>
                                                </tbody>
                                            </table>

                                            <hr>
                                            <!-- begin service -->
                                            <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                                                <thead>
                                                    <tr>
                                                        <th class="text-center" style="min-width: 8px;"> #</th>
                                                        <th class="text-center" style="min-width: 160px;">@lang('layout.ServiceName')</th>
                                                        <th v-show="showWhat('sale_description')=='yes'">@lang('layout.Description') </th>
                                                        <th v-show="showWhat('sale_description2')=='yes'">@lang('layout.Description') :2 </th>
                                                        <th class="text-center" style="min-width: 160px;">@lang('layout.Quantity')</th>
                                                        <th class="text-center" style="min-width: 160px;">@lang('layout.Measure')</th>
                                                        <th class="text-center" style="min-width: 160px;">@lang('layout.Price')</th>
                                                        <th class="text-center" style="min-width: 120px;">@lang('layout.Total')</th>
                                                       
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr v-for="(service,index) in services">
                                                        <td>@{{index+1}}</td>
                                                        <td class="highlight">
                                                            <v-select label="name" v-model="service.item" :options="(service.items)">

                                                            </v-select>
                                                            <input type="hidden" name="service_id[]" :value="(service.item==null)?null:service.item.id">
                                                            <input type="hidden" name="ser_online_order_detail_id[]" :value="(service.item==null)?null:service.item.order_detail_id">
                                                        </td>
                                                        <td v-show="showWhat('sale_description')=='yes'">
                                                            <input type="text" placeholder="@lang('layout.Description')" name="service_description[]" v-model="(service.item==null)?null:service.item.description" class="form-control">
                                                        </td>
                                                        <td v-show="showWhat('sale_description2')=='yes'">
                                                            <input type="text" placeholder="@lang('layout.Description')" name="service_description2[]" v-model="(service.item==null)?null:service.item.description2" class="form-control">
                                                        </td>
                                                        <td>
                                                            <input class="form-control" name="service_quantity[]" v-model.number="(!service.item)?null:service.item.quantity" placeholder="@lang('layout.Quantity')">
                                                        </td>
                                                        <td class="highlight">
                                                            <select v-model="(service.item == null)?null:service.item.measure" class="form-control" @change="measureChangeservice(index)">
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(service.item ==null)?false:true">
                                                                    <option v-for="measure in (service.item==null)?null:service.item.measure_list" :value="measure">
                                                                        @{{measure.measure_name}}
                                                                    </option>
                                                                </span>

                                                            </select>

                                                            <input type="hidden" name="service_measure[]" :value="(service.item==null)?null:service.item.measure.measure_id">
                                                        </td>
                                                        <td>
                                                            <div class="input-group">
                                                                <input type="number" name="service_price[]" placeholder="@lang('layout.Price')" :value="(service.item==null)?null:saleNewRate(service.item,selected_currency.rate)" ref="ser" @input="setNewRate('service',index)" class="form-control">

                                                                <span class="input-group-addon">
                                                                    @{{selected_currency.symbol}}
                                                                </span>
                                                            </div>

                                                        </td>
                                                        <td>
                                                            @{{ getItemTotalService(service.item,selected_currency.rate,selected_currency.hq_rate).result }}
                                                            @{{selected_currency.symbol}}
                                                        </td>
                                                    </tr>

                                                </tbody>
                                            </table>
                                            <!-- end service -->
                                            <hr>
                                            <!-- begin Receive -->
                                            <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                                                <thead>
                                                    <tr>
                                                        <th class="text-center" style="min-width: 8px;"> #</th>
                                                        <th class="text-center" style="min-width: 70px;">@lang('layout.Number')</th>
                                                        <th class="text-center" style="min-width: 160px;">@lang('layout.SelectBank')</th>
                                                        <th class="text-center" style="min-width: 100px;"> @lang('layout.Amount')</th>
                                                        <th class="text-center" style="min-width: 120px;"> @lang('layout.Rate')</th>
                                                        <th class="text-center" style="min-width: 80px;">@lang('layout.Currency')</th>
                                                        <th class="text-center" style="min-width: 80px;"> @lang('layout.Amount')</th>
                                                        <th class="text-center" style="min-width: 120px;">@lang('layout.Total')</th>

                                                        <th class="text-center" style="min-width: 120px;">@lang('layout.Description')</th>

                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr v-for="(payment,index) in payments">
                                                        <td>@{{index+1}}</td>

                                                        <td>
                                                            <span>@{{(payment.item==null)?null:(payment.item.r_number)+index}}</span>

                                                            <input type="hidden" name="receive_number[]" :value="(payment.item==null)?null:(payment.item.r_number)+index" />
                                                        </td>

                                                        <td class="highlight">
                                                            <v-select label="name" v-model="payment.item" :options="(payment.items)" >

                                                            </v-select>
                                                            <input type="hidden" v-if="payment.item !=null" name="payment_id[]" :value="(payment.item==null)?null:payment.item.id">
                                                        </td>

                                                        <td>

                                                            <span v-if="payment.item !=null">
                                                                @{{myRound(Number((payment.item==null)?null:payment.item.balance)+Number((payment.item==null)?null:payment.item.amount))}}
                                                            </span>
                                                        </td>
                                                        <td>
                                                            <input v-bind:disabled="(payment.item==null)?false:(payment.item.code =='{{getHomeCurrency()["code"]}}')" type="number" v-model.number="(payment.item==null)?null:payment.item.rate " class="form-control" placeholder="@lang('layout.Rate')" />
                                                            <input v-if="payment.item !=null" type="hidden" name="payment_rate[]" v-bind:value="payment.item.rate">
                                                        </td>
                                                        <td>
                                                            <input type="text" name="payment_currency[]" class="form-control" v-model="(payment.item==null)?null:payment.item.code" placeholder="@lang('layout.Currency')" disabled reqiured />

                                                            <input v-if="payment.item !==null" type="hidden" name="payment_currency[]" v-bind:value="payment.item.code" />
                                                        </td>

                                                        <td>
                                                            <div class="input-group">
                                                                <input type="number" class="form-control" v-model.number="(payment.item==null)?null:payment.item.amount " placeholder="@lang('layout.PayAmount')" />

                                                                <input v-if="payment.item !=null" type="hidden" name="payment_amount[]" v-bind:value="payment.item.amount">

                                                                <span class="input-group-addon">@{{(payment.item==null)?null:payment.item.code}}</span>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            @{{ (payment.item==null)?null:totalPayment(payment.item,selected_currency.rate,selected_currency.hq_rate).result }}
                                                            @{{selected_currency.symbol}}
                                                        </td>

                                                        <td>
                                                            <textarea class="form-control" name="receive_description[]" rows="2" placeholder="@lang('layout.Description')">@{{(payment.item==null)?null:payment.item.description}}</textarea>
                                                        </td>

                                                    </tr>
                                                </tbody>

                                            </table>
                                            <!-- end Receive -->

                                            <hr>
                                        </div>

                                        <!--Begin Draiver-->

                                        @if(getDriverInfo()=="true")
                                        <br>
                                        <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                                            <thead>
                                                <tr>
                                                    <th class="text-center" style="min-width: 8px;"> @lang('layout.DriverInfo') </th>

                                                </tr>
                                            </thead>
                                        </table>

                                        <div class="row">
                                            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                                <!-- begin inputs -->
                                                <div class="row">
                                                    <div class="col-md-3">
                                                        <div class="col-md-12">
                                                            <label class="control-label ">@lang('layout.TransferCode')</label>
                                                            <input type="text" name="transfer_code" v-model="driver_data.other_measure" class="form-control">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div class="col-md-12">
                                                            <label class="control-label">@lang('layout.Transporter_name')</label>
                                                            <input type="text" name="transporter_name" v-model="driver_data.driver_name" class="form-control">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div class="col-md-12">
                                                            <label class="control-label">@lang('layout.Transporter_phone')</label>
                                                            <input type="test" name="transporter_phone" class="form-control">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div class="col-md-12">
                                                            <label class="control-label ">@lang('layout.PlaceOfWeight')</label>
                                                            {{Form::text('palce_of_weight',null,['class' => 'form-control','placeholder' => __('layout.PlaceOfWeight')])}}
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-3">
                                                        <div class="col-md-12">
                                                            <label class="control-label ">@lang('layout.SourcePlace')</label>
                                                            {{Form::text('source_place',null,['class' => 'form-control','placeholder' => __('layout.SourcePlace')])}}
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div class="col-md-12">
                                                            <label class="control-label ">@lang('layout.PlateNumber')</label>
                                                            <input type="text" name="plate_number" v-model="driver_data.vehicle_name" placeholder="@lang('layout.PlateNumber')" class="form-control">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div class="col-md-12">
                                                            <label class="control-label ">@lang('layout.WayBillNumber')</label>
                                                            <input type="text" name="way_bill_number" v-model="driver_data.wagon_number" placeholder="@lang('layout.WayBillNumber')" class="form-control">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div class="col-md-12">
                                                            <label class="control-label ">@lang('layout.TotalWeight')</label>
                                                            <input type="text" name="total_weight" v-model="driver_data.other_measure2" placeholder="@lang('layout.TotalWeight')" class="form-control">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-3">
                                                        <div class="col-md-12">
                                                            <label class="control-label ">@lang('layout.EmptyCarWeight')</label>
                                                            <input type="text" name="empty_car_weight" placeholder="@lang('layout.EmptyCarWeight')" class="form-control">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div class="col-md-12">
                                                            <label class="control-label ">@lang('layout.TotalBori')</label>
                                                            <input type="text" name="total_bori" v-model="driver_data.description2" placeholder="@lang('layout.TotalBori')" class="form-control">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div class="col-md-12">
                                                            <label class="control-label ">@lang('layout.Rent')</label>
                                                            <input type="number" name="rent" v-model="driver_data.cost" placeholder="@lang('layout.Rent')" class="form-control">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div class="col-md-12">
                                                            <label class="control-label ">@lang('layout.Description')</label>
                                                            <textarea name="transfer_description" class="form-control" v-text="(driver_data)?driver_data.description:null" ></textarea>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>
                                        @endif
                                        <!--End Draiver-->

                                    </div>
                                    <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                                        <a href="{{route('invoice.index')}}" @click="clearTemp" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                                    </div>
                                    <cmodal :show='showModal' @close="showModal=false">

                                    </cmodal>
                                </div>


                            </div>


                            {!! Form::close() !!}

                        </div>

                    </div>


                </div>
                <p> &nbsp; </p>
                <p> &nbsp; </p>
            </div>
        </div>
        <!-- END TAB PORTLET-->
    </div>
</div>

@endsection
@push('scripts')


<script type="text/javascript">
    @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
    Vue.use(VeeValidate, {
        locale: 'en',
    });
    @endif

    Vue.use(VueInputAutowidth);

    Vue.component('v-select', VueSelect.VueSelect);

    Vue.component("modal", {
        template: "#modal-template",
        props: ['show'],

    });

    function callSaveTemp() {
        setTimeout((function () {
            v.getTempData();
            // console.log(14);
        }), 2e3)
    }

    // end new member 
    var seePrice ={!! $seePrice !!};
    var seeCost ={!! $seeCost !!};

    var currency ={!! $currency !!};
    var banks = {!! $banks !!};
    var all_services = {!! $all_services !!};
    var inventory_category = {!! $inventory_category !!};
    var memberClass = {!! $memberClass !!};
    var transportCompany = {!! $transportCompany !!};
    var allDrivers = {!! $allDrivers !!};
    var saleArea = {!! $saleArea !!};
    var taxation = {!! $taxation !!};
    var discountDate = {!! $discountDate !!};

    let homeCurrency = {!! $homeCurrency !!};
    let ratesFetched = {!! $rates !!};

    var inventory_sites = {!!$inventory_sites!!};
    var priceLevel = {!!$priceLevel!!};
    var priceLevelGeneral = {!!$priceLevelGeneral!!};
    var receive_number = {!!json_encode($receive_number)!!}; 
    
    var order_id = {!!$order_id!!}; 
    var online_order = {!!$online_order!!}; 
    var measureList = {!!$measureList!!}; 

    var member_cloth_id_session = {!!json_encode(session('member_cloth_id'))!!};
    var member_cloth_member_id_session = {!!json_encode(session('member_cloth_member_id'))!!};

    var memberClothAll =  {!!json_encode($memberClothAll)!!}; 

    var inventoryBrand =  {!!$inventoryBrand!!}; 
    
    var v = new Vue({
        el: '#appInvoice',
        data: {
            number: "{{$number}}",
            old_number: "{{$number}}",
            frarmerNumber: "{{$frarmerNumber}}",
            number_msg: '',
            number_Error: false,
            disabled: false,
            showModalSaleOrder: false,
            showModal: false,
            showInfoModal: false,
            oil_sale: false,
            sub_price: true,
            invoiceDescription: null,
            saleOrderList: [],
            selected_sale_order: null,
            purchase_orders: false,
            cheap: false,
            setDatas: [],
            customer: [],
            seePrice: seePrice,
            seeCost: seeCost,
            taxation: taxation,
            selected_taxation: null,
            discount_date: discountDate,
            selected_discount_date: null,
            selected_customer: null,
            member_id: null,
            brand: null,
            location: null,
            cost: null,
            SNumber: null,
            on_hand: null,
            measure_name: null,
            AdvancePrice: null,
            date: null,
            overdue_date: null,
            other_member_name: null,
            brandItem: inventoryBrand,
            selected_iventory_brand: null,
            driver_data: [{
                cost: null,
                description: null,
                description2: null,
                driver_name: null,
                other_measure: null,
                other_measure2: null,
                vehicle_name: null,
                wagon_number: null
                }
            ],
            print_description: null,
            banks: [],
            all_services: all_services,
            selected_banks: null,
            currency: currency,
            selected_currency: homeCurrency,
            selected_payment_currency: homeCurrency,
            rate: 0,
            discountFiled: 0,
            discountFiledRow: 0,
            subDiscountFiledRow: 0,
            newSubDiscountFiledRow: 0,
            sale_taxation: 0,
            saleTaxation: 0,
            totalTax: 0,
            subTotalTax: 0,
            newSubTotal: 0,
            total_qty_amount: 0,
            per_qty_check: false,
            discountIsAmount: false,
            temp_items: [],
            totalAmountes: [],
            types: null,
            inventory_category: inventory_category,
            selected_iventory_category: null,
            inventory_sites: inventory_sites,
            selected_iventory_site: null,
            selected_inventory: null,
            selected_inventory1: null,
            selected_index: 0,
            newCost: [],
            inventories: [],
            services: [],
            payments: [],
            payment_invoices: [],
            CusTypes: null,
            memberClass: memberClass,
            selected_class: null,

            saleArea: saleArea,
            selected_area: null,
            ref_no: '',
            msg: '',
            isError1: false,
            item_not_found: false,

            transportCompany: transportCompany,
            allDrivers: allDrivers,
            selected_transportCompany: null,
            selected_transportDriver: null,
            t_drivers: allDrivers,
            summary: [],
            priceLevel: priceLevel,
            selected_priceLevel: null,
            priceLevelGeneral: priceLevelGeneral,
            selected_priceLevelGeneral: null,
            receive_number: receive_number,
            order_id: order_id,
            online_order: online_order,
            measureList: measureList,
            far_measure: null,
            far_seed_amount: 0,
            counter_check: 0,
            counter_check1: 1,
            counter_check2: -1,
            member_cloth_list:[],
            selectedMemberCloth:null,
            memberClothAll:memberClothAll,
            member_cloth_id_session:member_cloth_id_session,
            member_cloth_member_id_session:member_cloth_member_id_session,
            last_item_sale:null

        },
        computed: {
            setRates() {

                let rates = [];
                this.currency.forEach((b) => {
                    ratesFetched.forEach((a) => {

                        if (a.currency_id == b.id) {
                            rates.push({
                                name: a.name,
                                code: a.code,
                                symbol: a.symbol,
                                rate: a.rate != null ? Number.parseFloat(a.rate) : 1,
                                exchange_rate: a.rate != null ? Number.parseFloat(a.rate) : 1,
                                hq_rate: a.hq_rate != null ? Number.parseFloat(a.hq_rate) : 1,
                                currency: b.id,
                                id: b.id
                            });
                        }
                    })
                });

                this.currency.forEach((a) => {
                    let found = false;
                    rates.forEach((b) => {
                        if (a.id == b.id) {
                            found = true;
                            return;
                        }
                    });

                    if (!found) {
                        rates.push({
                            name: a.name,
                            code: a.code,
                            symbol: a.symbol,
                            rate: 1,
                            exchange_rate: 1,
                            hq_rate: 1,
                            currency: a.id,
                            id: a.id
                        })
                    }
                });
                this.banks = [];

                banks.forEach((a) => {
                    rates.forEach((r) => {
                        if (a.code == r.code) {
                            this.banks.push({
                                amount: a.amount,
                                balance: a.balance,
                                code: a.code,
                                id: a.id,
                                name: a.name,
                                rate: r.rate,
                                hq_rate: r.hq_rate,
                                r_number: receive_number
                            })
                        }
                    });
                });

                return rates;

            },
            selectedRate() {
                var newrate = (this.selected_currency) ? this.selected_currency.rate : 0;
                if (this.discountIsAmount && this.discountFiled && this.rate > 0 && newrate > 0) {
                    this.discountFiled = ((this.discountFiled / this.rate) * newrate);
                }
                this.rate = (this.selected_currency) ? this.selected_currency.rate : 0;
            },
            discount() {
                if ("{{getSubTotal()}}" == "true" && this.sub_Subtotal > 0) {
                    this.newSubTotal = this.sub_Subtotal;
                    this.newSubDiscountFiledRow = this.subDiscountFiledRow;
                } else {
                    this.newSubTotal = this.subtotal;
                    this.newSubDiscountFiledRow = this.discountFiledRow;
                }
                if (this.discountIsAmount) {

                    if (this.newSubTotal > 0 && this.discountFiled) {
                        return (parseFloat(this.discountFiled) * 100) / (this.newSubTotal - this.discountFiledRow);
                    } else {
                        return 0;
                    }
                } else {

                    return this.discountFiled
                }
            },
            sub_discount() {
                if (this.discountIsAmount) {
                    if (this.sub_Subtotal > 0 && this.discountFiled) {
                        return (parseFloat(this.discountFiled) * 100) / (this.sub_Subtotal - this.subDiscountFiledRow);
                    } else {
                        return 0;
                    }
                } else {
                    return this.discountFiled
                }
            },

            // calculate subtotal
            checkedSubtotal: function() {
                var sum = 0;
                var sumTax = 0;
                for (var i = 0; i < this.inventories.length; i++) {
                    if (this.inventories[i].item && this.inventories[i].item != null) {
                        if (this.inventories[i].tax) {

                            if (this.oil_sale == true) {
                                var quantity = this.inventories[i]['item']['oil_qty'];
                            } else {
                                var quantity = this.inventories[i]['item']['quantity'];
                            }
                            if (this.inventories[i]['item']['other_measure'] > 0 && this.per_qty_check) {
                                var quantity = this.inventories[i]['item']['other_measure'];
                            }
                            var rate = this.inventories[i]['item']['rate'];
                            var new_rate = this.inventories[i]['item']['new_rate'];
                            var smeasure_unit = this.inventories[i]['item']['measure']['measure_unit'];
                            var measure_unit = this.inventories[i]['item']['measure_unit'];
                            if (new_rate != rate && quantity > 0) {
                                sum += new_rate * quantity * this.selected_currency.rate;
                            } else {
                                sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
                            }

                        } else {

                            if (this.oil_sale == true) {
                                var quantity = this.inventories[i]['item']['oil_qty'];
                            } else {
                                var quantity = this.inventories[i]['item']['quantity'];
                            }
                            var rate = this.inventories[i]['item']['rate'];
                            var new_rate = this.inventories[i]['item']['new_rate'];
                            var smeasure_unit = this.inventories[i]['item']['measure']['measure_unit'];
                            var measure_unit = this.inventories[i]['item']['measure_unit'];
                            if (this.inventories[i]['selected_taxation'] != null) {
                                var selected_taxation = this.inventories[i]['selected_taxation']['percent'];

                                if (new_rate != rate && quantity > 0) {
                                    sumTax += ((new_rate * quantity * this.selected_currency.rate) * selected_taxation) / 100;
                                    this.inventories[i]['row_tax_amount'] = ((new_rate * quantity * this.selected_currency.rate) * selected_taxation) / 100;
                                } else {
                                    sumTax += ((quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate)) * selected_taxation) / 100;
                                    this.inventories[i]['row_tax_amount'] = ((quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate)) * selected_taxation) / 100;
                                }
                            }

                        }
                    }
                }

                if (this.selected_taxation) {
                    var percent = this.selected_taxation.percent;
                    this.totalTax = ((sum * percent) / 100) + sumTax;
                    this.subTotalTax = ((sum * percent) / 100);
                }

                return sum;
            },

            // calculate subtotal
            sub_Subtotal: function() {
                
                var sum = 0;
                var sum_discount = 0;
                for (var i = 0; i < this.inventories.length; i++) {
                    if (this.inventories[i].item && this.inventories[i].item != null) {
                        if (this.inventories[i].sub_total) {

                            if (this.oil_sale == true) {
                                var quantity = this.inventories[i]['item']['oil_qty'];
                            } else {
                                var quantity = this.inventories[i]['item']['quantity'];
                            }
                            if (this.inventories[i]['item']['other_measure'] > 0 && this.per_qty_check) {
                                var quantity = this.inventories[i]['item']['other_measure'];
                            }
                            var rate = this.inventories[i]['item']['rate'];
                            var new_rate = this.inventories[i]['item']['new_rate'];
                            var smeasure_unit = this.inventories[i]['item']['measure']['measure_unit'];
                            var measure_unit = this.inventories[i]['item']['measure_unit'];

                            var discount = this.inventories[i]['item']['discount'];

                            if (new_rate != rate && quantity > 0) {
                                sum += new_rate * quantity * this.selected_currency.rate;
                                if (this.discountIsAmount) {
                                    if (discount > 0) {
                                        sum_discount += (discount * quantity);
                                    }
                                } else {

                                    if (discount > 0) {
                                        sum_discount += (parseFloat(discount) * (new_rate * quantity * this.selected_currency.rate)) / 100;
                                    }
                                }
                            } else {
                                sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
                                if (this.discountIsAmount) {
                                    if (discount > 0) {
                                        sum_discount += (discount * quantity);
                                    }
                                } else {

                                    if (discount > 0) {
                                        sum_discount += (parseFloat(discount) * (quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate))) / 100;
                                    }
                                }
                            }

                        }
                    }
                }
                this.subDiscountFiledRow = sum_discount;
                if ("{{getSubTotal()}}" == "true" && sum > 0) {
                    this.newSubTotal = sum;
                    this.newSubDiscountFiledRow = sum_discount;
                } else {
                    this.newSubTotal = this.subtotal;
                    this.newSubDiscountFiledRow = this.discountFiledRow;
                }
                return sum;
            },

            // calculate subtotal
            subtotal: function() {
                var sum = 0;
                var sum_discount = 0;
                var total_qty = 0;
                for (var i = 0; i < this.inventories.length; i++) {
                    if (this.inventories[i].item && this.inventories[i].item != null) {


                        //Total Qty all Invoic 
                        var row_amount = this.subMQuantity(this.inventories[i]['item'], this.inventories[i]['item']['quantity'])
                        // var row_amount = null;
                        total_qty += row_amount;

                        if (this.oil_sale == true) {
                            var quantity = this.inventories[i]['item']['oil_qty'];
                        } else {
                            var quantity = this.inventories[i]['item']['quantity'];
                        }
                        if (this.inventories[i]['item']['other_measure'] > 0 && this.per_qty_check) {
                            var quantity = this.inventories[i]['item']['other_measure'];
                        }
                        var rate = this.inventories[i]['item']['rate'];
                        var new_rate = this.inventories[i]['item']['new_rate'];
                        var smeasure_unit = this.inventories[i]['item']['measure']['measure_unit'];
                        var measure_unit = this.inventories[i]['item']['measure_unit'];

                        var discount = this.inventories[i]['item']['discount'];

                        // console.log('row_discount',row_discount);
                        if (new_rate != rate && quantity > 0) {
                            sum += new_rate * quantity * this.selected_currency.rate;
                            if (this.discountIsAmount) {
                                if (discount > 0) {
                                    sum_discount += (discount * quantity);
                                }
                            } else {

                                if (discount > 0) {
                                    sum_discount += (parseFloat(discount) * (new_rate * quantity * this.selected_currency.rate)) / 100;
                                }
                            }
                        } else {
                            sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
                            if (this.discountIsAmount) {
                                if (discount > 0) {
                                    sum_discount += (discount * quantity);
                                }
                            } else {

                                if (discount > 0) {
                                    sum_discount += (parseFloat(discount) * (quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate))) / 100;
                                }
                            }
                        }

                    }

                }
                this.discountFiledRow = sum_discount;

                @if(getSaleTaxation() == 'true')
                this.saleTaxation = (this.sale_taxation * sum / 100);
                // sum = sum - (this.sale_taxation*sum/100);
                @endif

                for (var i = 0; i < this.services.length; i++) {
                    if (this.services[i].item && this.services[i].item != null) {

                        var rate = this.services[i]['item']['rate'];
                        var new_rate = this.services[i]['item']['new_rate'];
                        var smeasure_unit = this.services[i]['item']['measure']['measure_unit'];
                        var measure_unit = this.services[i]['item']['measure_unit'];
                        var quantity = this.services[i]['item']['quantity'];
                        if (new_rate != rate && quantity > 0) {
                            sum += new_rate * quantity * this.selected_currency.rate;
                        } else {
                            sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
                        }

                    }
                }

                if (this.selected_taxation) {
                    // var percent = this.selected_taxation.percent;
                    var tax1 = this.checkedSubtotal;
                    var tax = this.totalTax;
                    sum = tax + sum;
                    // var tax = this.checkedSubtotal;
                    // sum = ((tax * percent)/100)+sum;
                }

                this.total_qty_amount = total_qty;

                return sum;
            },

            // check payed amount
            payeds: function() {
                var sum = 0;
                for (var i = 0; i < this.payments.length; i++) {

                    if (this.payments[i].item != null && this.payments[i].item) {
                        if (this.payments[i].item != null && this.payments[i]['item']['rate'] > 0) {
                            //
                            sum += (this.payments[i]['item']['amount'] * this.selected_currency.rate / this.payments[i]['item']['rate']);
                        }
                    }
                }
                return sum;
            },

            // check data validation
            isError: function() {
                var isError = false;
                //var flag=false;
                // for (var i = 0; i < this.inventories.length; i++)
                // {

                //    if (this.inventories[i].item)
                //    {
                //      flag=true;
                //      if(((this.inventories[i]['item']['rate'] <=0) ))
                //      {
                //        rate=this.inventories[i]['item']['rate'];
                //        new_rate=this.inventories[i]['item']['new_rate'];
                //        if(rate <=0 && new_rate <=0)
                //        {
                //             isError = true;
                //        }

                //      }
                //    }
                // }
                if (this.selected_customer == null) {
                    isError = true;
                }
                return isError;


            },
        },
        mounted: function() {
            // console.log('DDDDD', this.banks)

            

            if(this.member_cloth_id_session && this.member_cloth_member_id_session)
            {
                v.selectMemeber(this.member_cloth_member_id_session);
                // this.selected_customer = _.find(this.customer, (m) => m.id == this.member_cloth_member_id_session);
                if(this.selected_customer)
                {

                this.selectedMemberCloth = _.find(this.memberClothAll, (c) => c.id == this.member_cloth_id_session);

                }

            }
            var selected_site = null;
            if (showWhat('item_by_site_in_sale') == 'yes') {
                selected_site = _.find(this.inventory_sites, (v) => v.id == {!!getDropdown('invoice', 'site') !!});
                this.selected_iventory_site = selected_site;
            }

            
                this.getTempData();
            
        },
        methods: {

            getTempData() {
                axios.get("{{route('temp.getData')}}", {
                    params: {
                        type: 'invoice'
                    }
                })
                .then(function(response) {
                        // console.log('myrespo1', response);
                    if (response.data) {
                    if (response.data.form) {
                        
                        // v.purchase_orders = true;

                        v.invoiceDescription = response.data.form.description;
                        v.number = response.data.form.number;
                        v.ref_no = response.data.form.ref_no;
                        v.date = response.data.form.date;
                        v.overdue_date = response.data.form.overdue_date;
                        v.other_member_name = response.data.form.other_member_name;
                        v.sale_taxation = response.data.form.sale_taxation;
                        v.print_description = response.data.form.print_description;
                        if (response.data.form.member_id) {
                            v.selectMemeber(response.data.form.member_id);
                        }
                        if (response.data.form.class_id) {
                            v.selected_class = _.find(v.memberClass, (c) => c.id == response.data.form.class_id);
                        }
                        if (response.data.form.sale_area_id) {
                            v.selected_area = _.find(this.saleArea, (s) => s.id == response.data.form.sale_area_id);
                        }

                        v.discountFiled = response.data.form.discount;
                        if (response.data.form.discount_type) {
                            if (response.data.form.discount_type == 'percent') {
                                v.discountIsAmount = false;
                            }
                            else {
                                v.discountIsAmount = true;
                            }
                        }
					
                        // if (this.invoice.taxation_id && this.taxation) {
                        //     this.selected_taxation = _.find(this.taxation, (s) => s.id == this.invoice.taxation_id);
                        //     this.selected_taxation.percent = this.invoice.tax_percent;
                        // }
                        // if (this.invoice.sale_discount_id && this.discount_date) {
                        //     this.selected_discount_date = _.find(this.discount_date, (s) => s.id == this.invoice.sale_discount_id);
                        // }
                        
                        for (var a = 0; a < v.currency.length; a++) {
                            if (v.currency[a].code == response.data.form.currency) {
                                v.selected_currency = v.currency[a];
                                v.selected_currency.rate = response.data.form.rate;
                            }
                        }

                    }
                    if (response.data.items) {
                    if (response.data.items.length > 0) {
                        v.inventories = [];
                        for (var r = 0; r < response.data.items.length; r++) {
                            v.inventories.push({
                                inventory: response.data.items[r],
                                item: response.data.items[r],
                                item_category: null,
                                item_brand: null,
                                tax: 'on',
                                selected_taxation: null,
                                sub_total: ''
                            });
                        }
                    }
                    }
                    if (response.data.service) {
                        if (response.data.service.length > 0) {
                            v.services = [];
                            for (var r = 0; r < response.data.service.length; r++) {
                                var flag = false;
                                var tempService;
                                for (var h = 0; h < v.all_services.length; h++) {
                                    if (v.all_services[h].id == response.data.service[r].id) {
                                        flag = true;
                                        tempService = v.all_services[h];
                                        tempService.quantity = response.data.service[r].quantity;
                                        tempService.rate = response.data.service[r].new_rate;
                                        tempService.new_rate = response.data.service[r].new_rate;
                                        tempService.order_detail_id = response.data.service[r].order_detail_id;
                                    }
                                }
                                if (flag) {
                                    v.services.push({item: tempService, items: v.all_services})
                                }
                            }

                        }
                    }
                    if (response.data.payment) {
                        if (response.data.payment.length > 0) {
                            v.payments = [];
                            for (var t = 0; t < response.data.payment.length; t++) {
                                var foundFlag = false;
                                var tempBank = null;
                                for (var y = 0; y < v.banks.length; y++) {
                                    if (response.data.payment[t].recevie_payment_id == v.banks[y].id) {
                                        foundFlag = true;
                                        tempBank = v.banks[y];
                                        tempBank.amount = response.data.payment[t].amount;
                                        tempBank.rate = response.data.payment[t].rate; 
                                        tempBank.description = response.data.payment[t].description;
                                        tempBank.number = response.data.payment[t].number;
                                    }
                                }
                                if (foundFlag) {
                                    v.payments.push({item: tempBank, items: v.banks});
                                }
                            }
                        }
                    }
                    if (response.data.driver) {
                        v.driver_data = response.data.driver
                        // console.log(233,v.driver_data);
                    }
                    }
                    callSaveTemp();
                })
                .catch(function(error) {
                    callSaveTemp();
                    console.log(error);
                })
            },
            getSummary() {
                if (this.selected_customer) {
                    if(this.selected_customer.id != this.member_cloth_member_id_session)
                    {
                        this.member_cloth_list = [];
                        this.selectedMemberCloth = null;
                        this.take_member_cloth_data(this);
                    }

                   
                    this.getSummaryRecor(this.selected_customer.id, this);

                }

            },
            getSummaryRecor(id, v) {
                axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'memberStatment',
                            member_id: id,
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            v.summary = response.data;
                        } else {
                            v.summary = [];
                        }
                    })
                    .catch(function(error) {
                        console.log(error);
                    });
            },

            take_member_cloth_data(v) {

                axios.get("{{route('member.memberCloth')}}", {
                    params: {
                        member_id: this.selected_customer.id
                    },
                }).then(function (response) {
                    v.member_cloth_list = response.data;
                })
                .catch(function (error) {
                    console.log(error);
                });
                }, 

            checkRefNo() {
                var chack = 'false';
                var ref_no = v.ref_no;
                if (ref_no != null) {


                    axios.get("{{route('callMethod.search')}}", {

                            params: {
                                ref_no: v.ref_no,
                                method_name: 'Search_ref_no',
                                table_name: 'sales'
                            },
                        })
                        .then(function(response) {
                            // console.log(response.data.result);
                            if (response.data.result != null) {
                                console.log(response.data.result);
                                // v.temp_items=response.data;
                                v.msg = "@lang('layout.DuplicateData')";
                                v.isError1 = true;
                            } else {
                                v.msg = 'no';
                                v.isError1 = false;

                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        });

                }
            },
            checkNo() {
                var chack = 'false';
                var number = v.number;
                if (number != null) {
                    axios.get("{{route('callMethod.search')}}", {

                            params: {
                                number: v.number,
                                method_name: 'Search_number',
                                table_name: 'sales'
                            },
                        })
                        .then(function(response) {
                            // console.log(response.data.result);
                            if (response.data.result != null) {
                                // console.log(response.data.result);
                                // v.temp_items=response.data;
                                v.number_msg = "@lang('layout.DuplicateData')";
                                v.number_Error = true;
                            } else {
                                v.number_msg = 'no';
                                v.number_Error = false;

                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        });

                }
            },
            ChangeOil() {
                if (v.oil_sale == false) {
                    v.oil_sale = true;
                } else {
                    v.oil_sale = false;
                }
                // console.log(v.oil_sale);
            },
            subPrice() {
                if (v.sub_price == false) {
                    v.sub_price = true;
                } else {
                    v.sub_price = false;
                }
                // console.log(v.sub_price);
            },
            change_oil_qty(index) {
                if (this.inventories[index]['item'] && this.inventories[index]['item'] != null) {

                    var quantity = this.inventories[index]['item']['quantity'];
                    var density = this.inventories[index]['item']['density'];
                    if (quantity > 0 && density > 0) {
                        this.inventories[index]['item']['oil_qty'] = myRound(quantity / density);
                    }
                    var oil_qty = this.inventories[index]['item']['oil_qty'];
                }
            },
            change_per_qty(index) {
                if (this.inventories[index]['item'] && this.inventories[index]['item'] != null) {
                    var other_measure = this.inventories[index]['item']['other_measure'];
                    var per_qty = this.inventories[index]['item']['site']['per_qty'];
                    if (other_measure > 0 && per_qty > 0 && this.per_qty_check) {
                        @if(getSaleByOtherMeasure() == "true")
                        this.inventories[index]['item']['quantity'] = myRound(other_measure * per_qty);
                        @endif
                    }
                }
            },
            selectSaleNumber(index) {
                if (v.inventories[0]['item'] != null || v.inventories[0]['inventory_site'] != null) {
                    @if(getInvoicNoBySite() == "true")
                    var site = null;
                    if (v.inventories[0]['inventory_site'] != null) {
                        site = v.inventories[0]['inventory_site'];
                    }
                    if (site == null) {
                        site = v.inventories[0]['item']['site'];
                    }
                    if (site != null && site.number != null && site.site_id != null) {
                        axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    method_name: 'SaleNumberBySite',
                                    type: 'Invoice',
                                    site_id: site.site_id
                                }
                            })
                            .then(function(response) {
                                // console.log('myrespo1', response.data);
                                if (Number(response.data) > 0) {
                                    v.number = Number(response.data) + 1;
                                    v.old_number = Number(response.data) + 1;
                                } else if (Number(site.number) > 0) {
                                    v.number = Number(site.number);
                                    v.old_number = Number(site.number);
                                }
                            })
                            .catch(function(error) {
                                console.log(error);
                            })

                    }
                    @endif
                }
            },
            handleSubmit(e) {
                this.$validator.validate().then(valid => {
                    if (valid) {
                        if (v.member_chack() == 'true') {
                            var r = confirm("@lang('layout.member_payable_levels')");
                            if (r == true) {
                                v.disabled = true;
                                v.submitForm(e.target);
                            }
                        } else {
                            v.disabled = true;
                            v.submitForm(e.target);
                        }
                    }
                });
            },

            selectMemeber(id = null) {
                if (id) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SearchMember',
                            id: id,
                            type: 'Customer'
                        }
                    })
                    .then(function(response) {
                        if (response.data) {
                            // console.log(response.data);
                            v.selected_customer = null;
                            v.selected_customer = response.data;
                        }
                    })
                    .catch(function(error) {
                        console.log(error);
                    })
                }
            },

            subMQuantity(item = null, quantity = null) {
                if (item != null) {
                    var result = 0;
                    if (item.site) {
                        // console.log(38383,item.measureListAll.length);
                        if (item.measureListAll) {
                            for (var i = 0; i < item.measureListAll.length; i++) {
                                // console.log(3838,item.measureListAll[i],item.measure_unit,item.measure.measure_unit);
                                if (item.measureListAll[i].measure_id == item.measure2.measure_id) {
                                    result = (quantity * item.measure.measure_unit) / (item.measure_unit);
                                    result = (result * item.measure_unit) / (item.measureListAll[i].measure_unit);
                                }
                            }
                        }



                    }
                    return result;
                }
            },
            secoundMeasurQuantity(item = null, quantity = null) {
                if (item != null) {
                    var result = 0;
                    if (item.site) {
                        // console.log(38383,item.measureListAll.length);
                        if (item.measureListAll) {
                            for (var i = 0; i < item.measureListAll.length; i++) {
                                // console.log(3838,item.measureListAll[i],item.measure_unit,item.measure.measure_unit);
                                if (item.measureListAll[i].measure_id == item.measure1.measure_id) {
                                    result = (quantity * item.measure.measure_unit) / (item.measure_unit);
                                    result = (result * item.measure_unit) / (item.measureListAll[i].measure_unit);
                                }
                            }
                        }



                    }
                    return result;
                }
            },

            // chack_member_payable_levels
            member_chack() {
                var chack = 'false';
                var member_id = v.member_id;
                if (member_id != null) {

                    var totals = Number.parseFloat((v.subtotal - (v.discount * v.subtotal / 100)) - v.payeds);
                    var currency = $("input[name=currency]").val();


                    $.ajax({
                        url: "{{route('callMethod.search')}}",
                        async: false,
                        data: {
                            member_id: v.member_id,
                            method_name: 'Search_member_payable_levels',
                            currency: currency,
                        },
                        success: function(data) {
                            var r_amount = Number.parseFloat(data.amount);
                            var r_m_amount = Number.parseFloat(data.m_amount);
                            var totalss = Number.parseFloat(((isNaN(r_m_amount) ? 0 : r_m_amount) + totals));
                            //console.log(r_m_amount);
                            //console.log('--');
                            //console.log(totals);
                            if (r_amount != 0 && r_amount < totalss) {
                                chack = 'true';
                            } else {
                                chack = 'false';
                            }


                        }.bind(this),

                        error: function(error) {
                            console.log(error)
                        }
                    });
                    /*
                            axios.get("{{route('callMethod.search')}}",
				   {

					params:{
					  member_id:v.member_id,
					  method_name:'Search_member_payable_levels',
					  currency:currency,
					  
					},
				   })
				   .then(function (response)
				   {
					 
						var r_amount = response.data.amount;
						var r_m_amount = response.data.m_amount;
						if(r_amount < (r_m_amount + totals)){
							chack = 'true';
						}
				   })
				   .catch(function (error)
				   {
					  console.log(error);
				   });
			  */
                }
                return chack;
            },

            // calculate item price based on measure change
            measureChange(index) {

                if (this.inventories[index].item != null) {
                    var item = this.inventories[index].item;

                    var temp = ((item.rate * item.measure.measure_unit / item.measure_unit));
                    result = Number.parseFloat(temp).toFixed(precision());

                    this.inventories[index].item.new_rate = result;

                    // if(this.inventories[index].item.price_level){

                    //  this.inventories[index].item.price_level.id = null;
                    // }

                    if (this.inventories[index].item.quantity > 0 && this.inventories[index].sub_price > 0) {
                        if (this.inventories[index].item.measure2) {
                            var item = this.inventories[index].item;
                            var sub_quantity = v.subMQuantity(item, item.quantity);
                            var sub_price = this.inventories[index].sub_price;
                            var total_price = (sub_quantity * sub_price);
                            var quantity = item.quantity;
                            if (quantity > 0) {
                                if (this.selected_currency.rate > 0) {
                                    item.new_rate = myRound((total_price / quantity) / this.selected_currency.rate);
                                } else {
                                    item.new_rate = myRound(total_price / quantity);
                                }
                            }
                        }
                    }

                    // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;

                    // var temp1 = ((item.LasCost * item.measure.measure_unit / item.measure_unit));
                    // var LasCost = Number.parseFloat(temp1).toFixed(precision());
                    // this.inventories[index].item.LasCost = LasCost;

                }
            },

            // Change Item Sale Rate According Item Price Level
            change_sale_rate_by_price_level(index) {

                if (this.inventories[index].item != null) {

                    var item = this.inventories[index].item;
                    var item_price_level = this.inventories[index].item.item_price_level;


                    var temp = ((item.rate * item.measure.measure_unit / item.measure_unit));
                    result = Number.parseFloat(temp).toFixed(precision());
                    this.inventories[index].item.new_rate = result;
                    // console.log("SAEED", this.inventories[index].item.new_rate, temp)

                    var myDataArray = this.inventories[index].item.item_price_level;
                    if (this.inventories[index].price_level != undefined) {
                        var item = this.inventories[index].item;
                        for (var i = 0; i < myDataArray.length; i++) {
                            if (myDataArray[i]['id'] == this.inventories[index].price_level.id) {
                                var temp = ((myDataArray[i]['rate'] * item.measure.measure_unit / item.measure_unit));
                                result = Number.parseFloat(temp).toFixed(precision());

                                if (this.selected_currency.rate > 0) {
                                    item.new_rate = myRound((result) / this.selected_currency.rate);
                                } else {
                                    item.new_rate = myRound(result);
                                }
                            }

                        }
                    }
                }
            },

            // Change Item Sale Rate According Item Price Level
            change_sale_rate_by_price_level_general() {
                
                if (this.inventories != null && this.selected_priceLevelGeneral) {
                    var price_type = this.selected_priceLevelGeneral.price_type;
                    var percent = Number.parseFloat(this.selected_priceLevelGeneral.percent);

                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].item && this.inventories[i].item != null) {
                                var rate = this.inventories[i]['item']['rate'];
                                var smeasure_unit = this.inventories[i]['item']['measure']['measure_unit'];
                                var measure_unit = this.inventories[i]['item']['measure_unit'];
                                var rate1 = (rate * smeasure_unit / measure_unit);
                                rate1 = Number.parseFloat(rate1);

                                if(price_type == 'up' && percent > 0 && rate1 > 0){
                                    var result = Number.parseFloat((rate1 * percent) / 100);
                                    this.inventories[i]['item']['new_rate'] = Number.parseFloat(rate1 + result);
                                } else if(price_type == 'down' && percent > 0 && rate1 > 0){
                                    var result = Number.parseFloat((rate1 * percent) / 100);
                                    this.inventories[i]['item']['new_rate'] = Number.parseFloat(rate1 - result);
                                }  
                        }
                    }
                }
            },

            // Change Item Sale Rate According Item Price Level
            change_sale_rate_by_price_level_general_per_item(index) {
                
                if (this.inventories != null) {
                    if (this.inventories[index].item != null) {
                        var item = this.inventories[index].item;
                        var item_price_level = this.inventories[index].price_level;
                        var price_type = item_price_level.price_type;
                        var percent = Number.parseFloat(item_price_level.percent);
                        
                        var rate = this.inventories[index]['item']['rate'];
                        var smeasure_unit = this.inventories[index]['item']['measure']['measure_unit'];
                        var measure_unit = this.inventories[index]['item']['measure_unit'];
                        var rate1 = (rate * smeasure_unit / measure_unit);
                        rate1 = Number.parseFloat(rate1);

                        if(price_type == 'up' && percent > 0 && rate1 > 0){
                            var result = Number.parseFloat((rate1 * percent) / 100);
                            this.inventories[index]['item']['new_rate'] = Number.parseFloat(rate1 + result);
                        } else if(price_type == 'down' && percent > 0 && rate1 > 0){
                            var result = Number.parseFloat((rate1 * percent) / 100);
                            this.inventories[index]['item']['new_rate'] = Number.parseFloat(rate1 - result);
                        } 
                    }
                }
            },
            // calculate item price based on measure change
            measure2Change(index) {
                if (this.inventories[index].item != null) {
                    if (this.inventories[index].item.quantity > 0 && this.inventories[index].sub_price > 0) {
                        if (this.inventories[index].item.measure2) {
                            var item = this.inventories[index].item;
                            var sub_quantity = v.subMQuantity(item, item.quantity);
                            var sub_price = this.inventories[index].sub_price;
                            var total_price = (sub_quantity * sub_price);
                            var quantity = item.quantity;
                            if (quantity > 0) {
                                if (this.selected_currency.rate > 0) {
                                    item.new_rate = myRound((total_price / quantity) / this.selected_currency.rate);
                                } else {
                                    item.new_rate = myRound(total_price / quantity);
                                }
                            }
                        }
                    }
                }
            },
            memberClassChange() {
                
            },

            changePriceLevel() {

                this.inventories = [];

                this.inventories.push({
                    inventory: null,
                    item: null,
                    item_category: this.selected_iventory_category,
                    item_brand: null,
                    tax: 'on',
                    selected_taxation: null,
                    sub_total: '',
                    inventory_site: this.selected_iventory_site,
                    price_level: null
                });

            },
            //Get Transport Company Drivers 
            getDrivers() {
                if (this.selected_transportCompany) {
                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                transport_id: this.selected_transportCompany.id,
                                method_name: 'Search_transport_company_drivers'
                            },
                        })
                        .then(function(response) {
                            if (response.data.result != null) {
                                console.log('all Drivers', response.data.result);
                                v.t_drivers = response.data.result;
                                v.selected_transportDriver = null;
                            } else {

                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        });
                }
            },

            //Get Just Drivers  without Transport Company Select
            getAllDrivers() {
                if (!v.selected_transportCompany) {
                    v.t_drivers = v.allDrivers;
                }
            },

            // calculate item price based on measure change
            measureChangeservice(index) {

                if (this.services[index].item != null) {
                    var item = this.services[index].item;

                    var temp = ((item.rate * item.measure.measure_unit / item.measure_unit) * this.selected_currency.rate);
                    result = Number.parseFloat(temp).toFixed(precision());

                    this.services[index].item.new_rate = result;

                    // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;

                }
            },
            // detect member change and searh
            memberChange() {
                if (this.selected_customer) {
                    v.member_id = this.selected_customer.id;
                    // get member contract
                    this.saleOrderSearch(this.selected_customer.id, this);

                    @if(getShwoPriceLevel()=="general_percent")
                    var price_level_id = this.selected_customer.price_level_id;
                    if(price_level_id){
                        this.selected_priceLevelGeneral = _.find(this.priceLevelGeneral, (s) => s.id == price_level_id);
                    }else{
                        this.selected_priceLevelGeneral = null;
                    }
                    @endif
                }
            },

            // sale order change
            saleOrderChang() {
                console.log('test 33');
            },
            // end sale order change
            // set new price
            setNewRate(type = null, index = null) {
                if (type == 'inventory') {
                    if (this.inventories[index].item) {
                        this.inventories[index].item.new_rate = this.$refs.in[index].value / this.selected_currency.rate;
                        if (this.inventories[index].item.quantity > 0 && this.inventories[index].sub_price) {
                            if (this.inventories[index].item.measure2) {
                                var item = this.inventories[index].item;
                                var sub_quantity = v.subMQuantity(item, item.quantity);
                                var total_price = (item.new_rate * item.quantity);
                                if (sub_quantity > 0) {
                                    this.inventories[index].sub_price = myRound(total_price / sub_quantity);
                                }
                            }
                        }

                        if (((this.inventories[index].item.LasCost * this.inventories[index].item.measure.measure_unit / this.inventories[index].item.measure_unit) * this.selected_currency.rate) > (this.inventories[index].item.new_rate * this.selected_currency.rate)) {
                            this.cheap = true;
                        } else {
                            this.cheap = false;
                        }
                    }
                }
                if (type == 'service') {
                    if (this.services[index].item) {
                        console.log('service changed');
                        this.services[index].item.new_rate = this.$refs.ser[index].value / this.selected_currency.rate;
                    }
                }
                var far_seed_amount = 0;
                for (var i = 0; i < this.inventories.length; i++) {
                    if (this.inventories[i].item && this.inventories[i].item != null) {
                        var quantity = this.inventories[i]['item']['quantity'];
                        far_seed_amount += quantity;
                    }
                }
                if (this.inventories[0].item) {
                    v.far_measure = this.inventories[0]['item']['measure']['measure_id'];
                    // console.log(333,v.far_measure);
                }
                this.far_seed_amount = far_seed_amount;
            },
            setNewRateTotal(index = null) {
                if (this.inventories[index].item && this.inventories[index].sub_price > 0) {
                    if (this.inventories[index].item.measure2) {
                        var item = this.inventories[index].item;
                        var sub_quantity = v.subMQuantity(item, item.quantity);
                        var sub_price = this.inventories[index].sub_price;
                        var total_price = (sub_quantity * sub_price);
                        var quantity = item.quantity;
                        if (quantity > 0) {
                            if (this.selected_currency.rate > 0) {
                                item.new_rate = myRound((total_price / quantity) / this.selected_currency.rate);
                            } else {
                                item.new_rate = myRound(total_price / quantity);
                            }
                        }
                        // console.log('asda changed111', sub_quantity,item.quantity,sub_price,item);
                    }
                }
            },
            // quantitySubRate(index = null) {
            // if (this.inventories[index].item) {
            // var quantity = this.inventories[index].item.quantity
            // var sub_quantity = v.subMQuantity(this.inventories[index].item,this.inventories[index].item.quantity);
            // if(quantity > 0 && sub_quantity > 0){
            // var total_price =  (this.inventories[index].item.new_rate * quantity);
            // this.inventories[index].sub_price = myRound(total_price/sub_quantity);
            // }
            // }
            // },

            onItemSearch: _.debounce((search, loading) => {

                loading(true);
                let inventory_category_id = 0;
                let inventory_site_id = 0;
                let inventory_brand_id = 0;

                if (v.inventories[v.selected_index]) {
                    inventory_category_id = (v.inventories[v.selected_index]['item_category'] != undefined) ? v.inventories[v.selected_index]['item_category'].id : '';
                    inventory_site_id = (v.inventories[v.selected_index]['inventory_site'] != undefined) ? v.inventories[v.selected_index]['inventory_site'].id : '';
                    inventory_brand_id = (v.inventories[v.selected_index]['item_brand'] != undefined) ? v.inventories[v.selected_index]['item_brand'].id : '';
                }

                @if(TabIndexInItemName() =="true")
                    inventory_category_id = (v.selected_iventory_category != undefined)?v.selected_iventory_category.id:inventory_category_id;
                    // inventory_site_id = (v.selected_iventory_site != undefined)?v.selected_iventory_site.id:inventory_site_id;
                @endif

                // console.log(21,inventory_category_id,inventory_site_id,search);

                axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'itemesSearchSale', 
                            keyword: search,
                            inventory_category_id: inventory_category_id,
                            inventory_brand_id: inventory_brand_id,
                            inventory_site_id: inventory_site_id,
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            v.temp_items = [];
                            v.temp_items = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        console.log(error);
                    })
            }, getDebounceTime()),


            onItemSearchGeneral(){

                let inventory_category_id = 0;
                let inventory_site_id = 0;
                let inventory_brand_id = 0;
                let keyword = v.selected_inventory1;
                    
                // console.log(32,keyword);
                
                if (keyword && keyword != null && keyword != ' ' && keyword != 1) {
                    inventory_category_id = (v.selected_iventory_category != undefined)?v.selected_iventory_category.id:inventory_category_id;
                    // inventory_site_id = (v.selected_iventory_site != undefined)?v.selected_iventory_site.id:inventory_site_id;
                    
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'itemesSearchByCode', 
                            keyword: keyword,
                            inventory_category_id: inventory_category_id,
                            inventory_brand_id: inventory_brand_id,
                            inventory_site_id: inventory_site_id,
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            v.item_not_found = false;
                            v.temp_items = [];
                            v.temp_items = response.data;
                            v.onItemloadGeneral(v.temp_items[0].id);
                        }else{
                            v.item_not_found = true;
                            setTimeout((function () {
                                v.item_not_found = false;
                                v.selected_inventory = null;
                                v.selected_inventory1 = null;
                                v.$refs.barcode_search1.focus();
                                // console.log(12);
                            }), 3e3)
                        }
                    })
                    .catch(function(error) {
                        console.log(error);
                    })
                }

            },


            onItemload(index) {
                v.selected_index = index;
                if (v.inventories[index].inventory != null) {
                    // console.log('klk',v.inventories[index].inventory,v.inventories);
                    var inventory_id = v.inventories[index].inventory.id;
                    let inventory_category_id = (v.inventories[index]['item_category'] != undefined) ? v.inventories[index]['item_category'].id : '';
                    let inventory_brand_id = (v.inventories[index]['item_brand'] != undefined) ? v.inventories[index]['item_brand'].id : '';
                    let inventory_site_id = (v.inventories[v.selected_index]['inventory_site'] != undefined) ? v.inventories[v.selected_index]['inventory_site'].id : '';
                    let price_level_id = (this.selected_priceLevel) ? this.selected_priceLevel.id : '';
                    // console.log('rrrrr', inventory_brand_id);
                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                member_id: v.member_id,
                                method_name: 'itemSearchSale',
                                inventory_id: inventory_id,
                                inventory_category_id: inventory_category_id,
                                inventory_brand_id: inventory_brand_id,
                                inventory_site_id: inventory_site_id,
                                price_level_id: price_level_id,
                            }
                        })
                        .then(function(response) {
                            v.inventories[index].item = null;
                            if (response.data.length > 0) {
                                // console.log('Price Level Lala', response.data,  v.inventories);
                                var checkD = true;
                                
                                @if(NotDuplicateItem() =="true")
                                if (v.inventories != null && response.data[0].id) {
                                    for (var i = 0; i < v.inventories.length; i++) {
                                        if (v.inventories[i].item && v.inventories[i].item != null) {
                                            if (v.inventories[i].item.id == response.data[0].id) {
                                                checkD = false;
                                            }
                                        }
                                    }
                                }
                                @endif
                                
                                if (checkD) {
                                    v.inventories[index].item = response.data[0];
                                    if (showWhat('item_by_site_in_sale') != 'yes') {
                                        @if(getDefaultSite() > 0)
                                        var sites_id = {{getDefaultSite()}}
                                        for (var i = 0; i < v.inventories[index].item.site_list.length; i++) {
                                            if (v.inventories[index].item.site_list[i].site_id == sites_id) {
                                                v.inventories[index].item.site = v.inventories[index].item.site_list[i];
                                            }
                                        }
                                        @else
                                        var sites_id = {{getDropdown('invoice', 'site')}}
                                        for (var i = 0; i < v.inventories[index].item.site_list.length; i++) {
                                            if (v.inventories[index].item.site_list[i].site_id == sites_id) {
                                                v.inventories[index].item.site = v.inventories[index].item.site_list[i];
                                            }
                                        }
                                        @endif
                                    }
                                    v.selectSaleNumber(0);

                                    v.temp_items = [];
                                    @if(getShwoPriceLevel()=="general_percent")
                                    setTimeout((function () {
                                        v.change_sale_rate_by_price_level_general();
                                    }), 400);
                                    @endif
                                } else {
                                    v.inventories[index].item = null;
                                    v.inventories[index].inventory = null;
                                }
                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        })

                }
            },

            callOnItemloadGeneral() {
                if (v.counter_check == 0) {
                    v.counter_check = 1;
                    setTimeout((function () {
                        v.counter_check1 = v.selected_inventory1;
                        v.call2();
                        // console.log(12);
                    }), 2e2)
                }
            },
            call2() {
                setTimeout((function () {
                    v.counter_check2 = v.selected_inventory1;
                    v.onItemloadGeneral();
                    // console.log(13);
                }), 2e2)
            },
            onItemloadGeneral(id = null) {
                if (v.counter_check1 != v.counter_check2) {
                    v.counter_check1 = v.selected_inventory1;
                    v.call2();
                }else{
                    if (v.selected_inventory != undefined || id || v.selected_inventory1) {
                        
                        var inventory_id = id;
                        if (v.selected_inventory != undefined) {
                            inventory_id = v.selected_inventory.id;
                        }

                        let number = v.selected_inventory1;

                        // console.log(888, number);
                        let inventory_category_id = (v.selected_iventory_category != undefined)?v.selected_iventory_category.id:'';
                        let inventory_site_id = (v.selected_iventory_site != undefined)?v.selected_iventory_site.id:'';

                        axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    member_id: v.member_id,
                                    method_name: 'itemSearchSale',
                                    inventory_id: inventory_id,
                                    inventory_category_id: inventory_category_id,
                                    // inventory_brand_id: inventory_brand_id,
                                    inventory_site_id: inventory_site_id,
                                    number: number,
                                }
                            })
                            .then(function(response) {
                                if (response.data.length > 0) {
                                    var che = null;
                                    for (var i = 0; i < v.inventories.length; i++) {
                                        if (v.inventories[i].item && v.inventories[i].item != null) {
                                            che = 'ok';
                                        } else {
                                            v.inventories.splice(i, 1);
                                        }
                                    }
                                    if(!che){
                                        v.inventories = [];
                                    }
                                    // console.log(response.data[0]);
                                    if (inventory_site_id) {
                                        for (var i = 0; i < response.data[0].site_list.length; i++) {
                                            if (response.data[0].site_list[i].site_id == inventory_site_id) {
                                                response.data[0].site = response.data[0].site_list[i];
                                            }
                                        }
                                    }
                                    response.data[0].quantity = 1;

                                    v.inventories.push({
                                        inventory: response.data[0],
                                        item: response.data[0],
                                        selected_taxation: null,
                                        tax: response.data[0].row_tax_stat,
                                        sub_total: response.data[0].sub_total_stat,
                                        item_category: response.data[0].item_category,
                                        item_brand: response.data[0].inventory_brand,
                                        price_level:null
                                    });

                                    v.selected_inventory = null;
                                    v.selected_inventory1 = null;
                                    v.counter_check = 0;
                                    v.temp_items = [];
                                    v.selectSaleNumber(0);
                                    @if(getShwoPriceLevel()=="general_percent")
                                    setTimeout((function () {
                                        v.change_sale_rate_by_price_level_general();
                                    }), 400);
                                    @endif

                                    // const inp = v.$refs.barcode_search.$refs.search;
                                    // console.log(v.$refs.barcode_search.$refs.search.value);
                                    // v.$refs.barcode_search.$refs.search.focus();
                                    // v.$refs.barcode_search.$refs.search = null;
                                    v.$refs.barcode_search1.focus();
                                    
                                }else{
                                    // $('#success-sound')[0].play();
                                    // $('#error-sound')[0].play();
                                    v.item_not_found = true;
                                    setTimeout((function () {
                                        v.item_not_found = false;
                                        v.selected_inventory = null;
                                        v.selected_inventory1 = null;
                                        v.counter_check = 0;
                                        v.$refs.barcode_search1.focus();
                                        // console.log(12);
                                    }), 2e3)
                                }
                            })
                            .catch(function(error) {
                                console.log(error);
                            })

                    }
                }
            },

            // changeLength() {
            //     if(this.$refs.in){
            //         this.$refs.in.forEach((data) => {
            //             if (data) {
            //                 var newdata = data.style.width=((data.value.length+10)*8)+'px';
            //                 return newdata;
            //             }
            //         })
            //     }
            // },

            // end item search
            setIndex(e) {
                this.selected_index = e;
            },
            inventorySiteChange(index) {
                v.setIndex(index);

                v.selected_iventory_site = this.inventories[index]['inventory_site'];
                if (this.inventories[index]['inventory_site'] != null) {
                    let inventory_site_id = this.inventories[index]['inventory_site'].id;
                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                member_id: v.member_id,
                                method_name: 'itemesSearchSale',
                                inventory_site_id: inventory_site_id
                            }
                        })
                        .then(function(response) {
                            if (v.purchase_orders) {} else {
                                v.inventories[index]['item'] = null;
                                v.inventories[index]['inventory'] = null;
                            }
                            v.temp_items = [];
                            if (response.data.length > 0) {
                                v.temp_items = response.data;
                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        });
                }

            },

            itemCategoryChange(index) {
                v.setIndex(index);

                v.selected_iventory_category = this.inventories[index]['item_category'];
                if (this.inventories[index]['item_category'] != null) {

                    let inventory_brand_id = (v.inventories[index]['item_brand'] != undefined) ? v.inventories[index]['item_brand'].id : '';
                    
                    let inventory_category_id = this.inventories[index]['item_category'].id;
                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                member_id: v.member_id,
                                method_name: 'itemesSearchSale',
                                inventory_category_id: inventory_category_id,
                                inventory_brand_id: inventory_brand_id
                            }
                        })
                        .then(function(response) {
                            if (v.purchase_orders) {} else {
                                v.inventories[index]['item'] = null;
                                v.inventories[index]['inventory'] = null;
                            }
                            v.temp_items = [];
                            if (response.data.length > 0) {
                                v.temp_items = response.data;
                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        });
                }

            },

            itemBrandChange(index) {
                v.setIndex(index);

                v.selected_iventory_brand = this.inventories[index]['item_brand'];
                if (this.inventories[index]['item_brand'] != null) {
                    let inventory_category_id = (v.inventories[index]['item_category'] != undefined) ? v.inventories[index]['item_category'].id : '';
                    let inventory_brand_id = this.inventories[index]['item_brand'].id;
                    
                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                member_id: v.member_id,
                                method_name: 'itemesSearchSale',
                                inventory_category_id: inventory_category_id,
                                inventory_brand_id: inventory_brand_id
                            }
                        })
                        .then(function(response) {
                            if (v.purchase_orders) {} else {
                                v.inventories[index]['item'] = null;
                                v.inventories[index]['inventory'] = null;
                            }
                            v.temp_items = [];
                            if (response.data.length > 0) {
                                v.temp_items = response.data;
                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        });
                }

            },
            // contract search


            saleOrderSearch(id, vm) {
                vm.saleOrderList = [];
                axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'memberSaleOrder',
                            member_id: id,
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            vm.showModalSaleOrder = true;
                            vm.saleOrderList = response.data;
                        }
                        // loading(false);
                    })
                    .catch(function(error) {
                        console.log(error);
                    })
            },
            getsalesOrders() {
                this.showModalSaleOrder = false;
                this.selected_class = _.find(this.memberClass, (c) => c.id == this.selected_sale_order.class_id);
                axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SaleOrderItems',
                            sale_order_id: this.selected_sale_order.id,
                            type: 'saleOrder'
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            console.log('myrespo', response.data);
                            v.inventories = [];
                            for (var r = 0; r < response.data.length; r++) {
                                v.inventories.push({
                                    inventory: response.data[r],
                                    item: response.data[r],
                                    item_category: response.data[r].item_category,
                                    item_brand: null,
                                    tax: 'on',
                                    selected_taxation: null,
                                    sub_total: ''
                                });
                            }
                            v.inventories.push({
                                inventory: null,
                                item: null,
                                item_category: null,
                                item_brand: null,
                                tax: 'on',
                                selected_taxation: null,
                                sub_total: ''
                            });
                            console.log('test check', v.selected_sale_order);

                            v.purchase_orders = true;

                            v.invoiceDescription = v.selected_sale_order.description;
                            v.selected_area = v.selected_sale_order
                            v.selected_area = _.find(v.saleArea, (c) => c.id == v.selected_sale_order.sale_area_id);


                            for (var a = 0; a < this.currency.length; a++) {
                                if (v.currency[a].code == v.selected_sale_order.currency) {
                                    v.selected_currency = v.currency[a];
                                    v.selected_currency.rate = v.selected_sale_order.rate;
                                }
                            }
                        }
                    })
                    .catch(function(error) {
                        console.log(error);
                    })
            },
            // end contract search

            // generic function for adding item to list
            addNew(type = null, index) {
                if (v.inventories[index] != undefined) {
                    v.selected_iventory_category = this.inventories[index]['item_category'];
                    v.selected_iventory_brand = this.inventories[index]['item_brand'];
                    v.selected_iventory_site = this.inventories[index]['inventory_site'];
                    @if(getShwoPriceLevel()=="general_percent")
                    this.change_sale_rate_by_price_level_general();
                    @endif
                }
                // this.temp_items = [];
                if (type != null) {
                    if (type == 'inventory') {
                        if (this.inventories[index + 1] == undefined) {
                            this.temp_items = [];
                            this.inventories.push({
                                inventory: null,
                                item: null,
                                item_category: this.selected_iventory_category,
                                item_brand: this.selected_iventory_brand,
                                tax: 'on',
                                selected_taxation: null,
                                sub_total: '',
                                inventory_site: this.selected_iventory_site,
                                price_level: null
                            });
                        }


                    }
                    if (type == 'service') {
                        if (this.services[index + 1] == undefined) {
                            this.checkExistingService(index, '');
                            this.services.push({
                                items: this.all_services,
                                item: null,
                            });
                        }
                    }
                    if (type == 'payment') {
                        if (this.payments[index + 1] == undefined) {
                            this.checkExistingPayment(index, '');
                            this.payments.push({
                                items: this.banks,
                                item: null,
                            });
                        }
                    }
                    if (type == 'payment_invoice') {
                        if (this.payment_invoices[index + 1] == undefined) {
                            this.payment_invoices.push({
                                items: null,
                                item: null,
                                selected_payment_currency: null
                            });
                        }
                    }
                }

            },

            // in here you can check and decide to allow duplicate bank for payment or not
            checkExistingPayment(index = null, name = '') {
                var bank_temp = this.banks.slice();
                var bank_temp1 = [];
                for (var i = 0; i < this.payments.length; i++) {
                    if (this.payments[i].item != null) {
                        var fined = bank_temp.findIndex((item) => item.name == this.payments[i].item.name);
                        if (fined != -1) {
                            var o = bank_temp.splice(bank_temp.findIndex((item) => item.name == this.payments[i].item.name), 1);
                        }
                    }
                }
                this.payments[index].items = bank_temp.filter((item) => {
                    return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                });
                //this.payments[index].items =bank_temp;


            },

            // in here you can check and decide to allow duplicate service or not
            checkExistingService(index = null, name = '') {
                var service_temp = this.all_services.slice();
                var service_temp1 = [];
                for (var i = 0; i < this.services.length; i++) {
                    if (this.services[i].item != null) {
                        var fined = service_temp.findIndex((item) => item.name == this.services[i].item.name);
                        if (fined != -1) {
                            var o = service_temp.splice(service_temp.findIndex((item) => item.name == this.services[i].item.name), 1);
                        }
                    }
                }
                this.services[index].items = service_temp.filter((item) => {
                    return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                });
                //this.payments[index].items =bank_temp;


            },
            // delete item from list
            deleteItem(type = null, index) {
                if (type != null) {

                    if (type == 'inventory') {
                        this.inventories.splice(index, 1);
                    }
                    if (type == 'service') {
                        this.services.splice(index, 1);
                    }
                    if (type == 'payment') {
                        this.payments.splice(index, 1);
                    }
                    if (type == 'payment_invoice') {
                        this.payment_invoices.splice(index, 1);
                    }
                }

            },
            // submit the form
            submitForm() {

                if (this.isError == true) {
                    alert('there is no item');
                    return false;
                }
                v.disabled = true;
                swal({
                    title: "@lang('layout.AreYouSure?')",
                    buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                    text: "",
                    icon: "info",
                    dangerMode: true,
                }).then((willDelete) => {
                    if (willDelete) {
                        document.getElementById("sales-form").submit()
                    } else {
                        v.disabled = false;
                    }
                });

            },
            // submit the form
            showInfo(index) {
                if (v.inventories[index].item != null) {
                    v.showInfoModal = true;
                    v.brand = v.inventories[index]['item']['brand'];
                    v.location = v.inventories[index]['item']['location'];
                    v.SNumber = v.inventories[index]['item']['number'];
                    v.AdvancePrice = v.inventories[index]['item']['advance_price'];
                    v.on_hand = v.inventories[index]['item']['on_hand'];
                    v.measure_name = v.inventories[index]['item']['measure']['measure_name'];
                    v.last_item_sale = v.inventories[index]['item']['last_item_sale'];
                    // console.log('ffff',v.last_item_sale);
                    // if(v.seeCost==true){
                    v.cost = (v.inventories[index]['item']['LasCost'] * v.selected_currency.rate);
                    // }
                }

            },
            defaultValue() {
                this.selected_customer = null;
                this.selected_index = 0;

                this.inventories = [{
                    inventory: null,
                    item: null,
                    item_category: this.selected_iventory_category,
                    tax: 'on',
                    selected_taxation: null,
                    sub_total: ''
                }, ];
                this.services = [{
                        items: all_services,
                        item: null,
                    },
                    {
                        items: all_services,
                        item: null,
                    },
                ];
                this.payments = [{
                    items: all_services,
                    item: null,
                }];

                this.invoiceDescription = null;
                this.saleOrderList = [];
                this.selected_sale_order = null;
                this.member_id = null;
                this.discountFiled = 0;
                this.temp_items = [];
            },
            saveAndNew() {
                this.$validator.validate()
                    .then(valid => {
                        if (valid) {
                            v.disabled = true;
                            var url = "{{route('invoice.store')}}";
                            form_id = 'sales-form';
                            var data = $('#' + form_id).serialize();
                            toggleBlock(true);
                            axios.post(url, data)
                                .then(function(response) {
                                    toggleBlock(0);
                                    // console.log('sss11', response.data);
                                    if (response.data.result == 1) {
                                        $('#' + form_id).trigger('reset');
                                        //$('#success-sound')[0].play();
                                        toastr.success('', response.data.message);
                                        v.number = Number(v.old_number) + 1;
                                        v.old_number = Number(v.old_number) + 1;
                                        v.ref_no = null;

                                        // v.defaultValue();
                                        location.reload();
                                    } else {
                                        v.disabled = false;
                                        var message = "{{__('message.Warning')}}";
                                        //$('#error-sound')[0].play();
                                        // toastr.warning('', message);
                                        toastr.warning('', response.data[1]);
                                    }
                                })
                                .catch(function(error) {
                                    toggleBlock(0);
                                    v.disabled = false;
                                    // console.log(error,v.disabled);
                                    var message = "{{__('message.Warning')}}";
                                    //$('#error-sound')[0].play();
                                    toastr.warning('', message);
                                });

                        }
                    })
            },

            clearTemp() {
                axios.get("{{route('temp.clear')}}", {
                    params: {
                        type: 'invoice'
                    }
                })
                .then(function(response) {
                    console.log('sss11', response);
                })
                .catch(function(error) {
                    console.log(error);
                });
            },
        },
    });
</script>



@endpush