@extends('layouts.app')
@section('style')
    <link href="{{URL::asset('assets/global/plugins/bootstrap-timepicker/css/bootstrap-timepicker.min.css')}}" rel="stylesheet" type="text/css" />
    <style>
        .paid_stamp{
            width: 160px;
            height: 80px;
            /* background-color: gray; */
            font-size: 60px;
            font-weight: bold;
            -ms-transform: rotate(-20deg);
            transform: rotate(-20deg);
            padding: 5px;
            text-shadow: 3px 3px;
            @if(session()->get("system_direction") == "rtl")
            margin-right:60%;
            @else 
            margin-left:60%;
            @endif
        }    
    </style>
@stop

@section('content')
<div id="print-modal">
    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute"
        v-if="is_show" 
        :value-type="'Inoice_Details'"
        @closed="closeModal">
        <div slot="body">
             <input type="hidden" name="id" value="{{$invoice->invoice_id}}"/>
                <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->
                <div class="row" v-cloak>
                         <div class="tabbable tabbable-tabdrop">

                            <ul class="nav nav-tabs">
                                
                                <li class="active">
                                    <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                                </li>
                                @if(systemConfig()[2] != 0 )
                                        @permission(['customreport-list'])
                                <li class="">
                                    <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                                </li>
                                @endpermission
                                @endif
                            </ul>
                            <div class="tab-content">
                                 <div class="tab-pane active" id="tab1"> 
                                        <div class="portlet light bordered">
                                           
                                        </div>
                                </div> 

                                <div class="tab-pane" id="tab2"> 
                                   <div class="portlet light bordered">
                                        <div class="portlet-body">

                                            <form  id="saveCustomeReport" role="form" action="{{route('customeReport.storeCustomeReport')}}" method="post" >
                                                @csrf
                                                <input type="hidden" name="part_name" value="invoice_show">


                                                <div class="col-md-12 col-sm-12 col-xs-12">

                                                    <div class="mt-checkbox-inline col-md-2" style="padding: 0px;" v-for="(row,itemIndex) in customReportData">

                                                        <div class="form-group">

                                                        <table class="table table-striped table-bordered table-advance table-hover">
                                                                    <tr>
                                                                        <td style="text-align: center;">@{{ row.Name }}</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td style="text-align: center;">
                                                                            <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                                            <label class="switch">
                                                                                <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                                :checked="row.checkedColumn" >
                                                                                <span class="slider round"></span>
                                                                            </label>

                                                                            <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="2">2 %</option>
                                                                                <option value="6">6 %</option>
                                                                                <option value="10">10 %</option>
                                                                                <option value="15">15 %</option>
                                                                                <option value="20">20 %</option>
                                                                                <option value="25">25 %</option>
                                                                                <option value="30">30 %</option>
                                                                                <option value="40">40 %</option>
                                                                                <option value="50">50 %</option>
                                                                                <option value="60">60 %</option>
                                                                            </select>

                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                          

                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="margiv-top-10">
                                                    <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->

                                                    <button type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i class="fa fa-save"></i> </button>
                                                </div>
                                        </form>
                                        </div>
                                </div>
                        </div>
                        </div>
                    </div>
                </div>
                <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->

        </div>
    </report-modal>
</div> 
<div id="laboratory-modal">
    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute"
        v-if="is_show" 
        :value-type="'laboratory_Tests'"
        @closed="closeModal">

        <div slot="body">
             <input type="hidden" name="id" value="{{$invoice->invoice_id}}"/>

             <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label class="control-label">@lang('layout.SelectType')</label>

                        <select class="form-control" name="report_type">
                            <option value="">@lang('layout.SelectType')</option>
                            <option value="general">@lang('layout.Details')</option>

                        </select>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="form-group">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="control-label"> @lang('layout.Date')</label>
                            <div class="input-group">
                                <input class="form-control date" id="range-from-example" name="from_date"
                                       autocomplete="off">
                                <span class="input-group-addon"> @lang('layout.To') </span>
                                <input class="form-control date" id="range-to-example" name="to_date"
                                       autocomplete="off">

                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </report-modal>
</div>

<div id="weighbridge-modal">
    <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute"
        v-if="is_show" 
        :value-type="'weighbridge'"
        @closed="closeModal">

        <div slot="body">
             <input type="hidden" name="id" value="{{$invoice->invoice_id}}"/>

             <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label class="control-label">@lang('layout.SelectType')</label>

                        <select class="form-control" name="report_type">
                            <option value="">@lang('layout.SelectType')</option>
                            <option value="details">@lang('layout.Details')</option>

                        </select>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="form-group">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="control-label"> @lang('layout.Date')</label>
                            <div class="input-group">
                                <input class="form-control date" id="range-from-example" name="from_date"
                                       autocomplete="off">

                                <span class="input-group-addon"> @lang('layout.To') </span>
                                <input class="form-control date" id="range-to-example" name="to_date"
                                       autocomplete="off">

                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </report-modal>
</div>
    <div class="portlet">
        <div class="portlet-title" id="backbtn">
            <div class="caption">
                <i class=""></i>@lang('layout.InvoiceInformation')
            </div>
            <div class="tools">
            </div>
            @if($paid_stamp!='')
                        <div  class="paid_stamp">{{$paid_stamp}}
                        <span style="font-size: 25px; text-shadow: 0px 0px;">{{$paid_date}}</span>
                        </div>
                    @endif
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                        <tr>
                            <th width="20px;">
                                <i class="fa  fa-bars"></i> @lang('layout.SalesNumber')
                            </th>
                            <th width="20px;">
                                <i class="fa  fa-bars"></i> @lang('layout.ReferenceNumber')
                            </th>

                            <th class="">
                                <i class="fa fa-user"></i> @lang('layout.Customer')
                            </th>
                            <th class="">
                                <i class=""></i> @lang('layout.Forgivness')
                            </th>
                            <th class="">
                                <i class="fa fa-user"></i> @lang('layout.User')
                            </th>
                            <th>
                                <i class="fa fa-file-excel-o"></i> @lang('layout.Account')
                            </th>
                            @if(showVendorInFactor() == 'true')
                            <th>
                                <i class="fa fa-user"></i> @lang('layout.Vendor')
                            </th>
                            @endif
                            <th>
                                <i class="fa fa-clock-o"></i> @lang('layout.Date')
                            </th>
                            <th>
                                <i class="fa fa-clock-o"></i> @lang('layout.OverdueDate')
                            </th>
                            <th>
                                <i class="fa fa-clock-o"></i> @lang('layout.Hour')
                            </th> 
                            <th width="20px;">
                                <i class="fa  "></i> @lang('layout.Rate')
                            </th>
                            <th>
                                <i class="fa "></i> @lang('layout.Amount')
                            </th>
                            <th>
                                <i class="fa "></i> @lang('layout.DiscountType')
                            </th>
                            <th>
                                <i class="fa "></i> @lang('layout.Discount')
                            </th>
                            @if(getSaleTaxation() == 'true')
                            <th>
                                <i class="fa "></i> @lang('layout.Tax')
                            </th>
                            @endif
                            <th>
                                <i class="fa  "></i> @lang('layout.Currency')
                            </th>
                            <th>
                                <i class="fa  "></i> @lang('layout.PaymentType')
                            </th>
                            @if(getSaleDiscountDate()=="true")
                            <th>
                                <i class="fa  "></i> @lang('menu.DiscountDate')
                            </th>
                            @endif
                        
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td class=" "> {{ $invoice->number}}  </td>
                            <td class=" "> {{ $invoice->ref_Number}}  </td>
                            <td class=""> {{ $invoice->member_name }}  </td>
                            <td> 
                                @if($invoice->forgivness) {{ __('layout.'.ucfirst($invoice->forgivness)) }} @endif
                            </td>
                            <td class=""> {{ $invoice->username }}  </td>
                            <td class=""> {{ $invoice->account_name}}  </td>
                            @if(showVendorInFactor() == 'true')
                            <td class=""> {{ $invoice->vendor}}  </td>
                            @endif
                            <td class=""> {{ convertDate($invoice->date)}}  </td>
                            <td class=""> {{ convertDate($invoice->overdue_date)}}  </td>
                            <td class=""> {{ $invoice->hour}} </td>
                            <td class=""> {{ $invoice->rate }}  </td>
                            <td class=""> {{ myRound($invoice->amount) }}  </td>
                            <td class=""> {{ $invoice->discount_type }}  </td>
                            <td class=""> {{ myRound($invoice->discount) }}  </td>
                            @if(getSaleTaxation() == 'true')
                            <td class=""> {{ $invoice->sale_taxation }} % </td>
                            @endif
                            <td class=""> {{ $invoice->currency }}  </td> 
                            @if($invoice->payment_type == 'On')
                            <td class="hidden-xs"> @lang('layout.Paid')  </td>
                            @else
                            <td class="hidden-xs"> @lang('layout.NoPaid')  </td>
                            @endif
                            @if(getSaleDiscountDate()=="true")
                            <td class=""> {{ $invoice->discount_date_name }}  </td>
                            @endif
                        </tr>
                    </tbody>
                </table>
                <table class="table table-striped table-bordered table-advance table-hover">
                    <thead>
                        <tr>
                            <th width="">
                                <i class=" fa fa-text-width"></i> @lang('layout.OldCounter')
                            </th>
                            <th width="">
                                <i class=" fa fa-text-width"></i> @lang('layout.NewCounter')
                            </th>
                            <th width="">
                                <i class=" fa fa-text-width"></i> @lang('layout.Description')
                            </th>
                            <th width=" ">
                                <i class=" fa fa-text-width"></i> @lang('layout.Memo')
                            </th>
                            @if(showVendorInFactor() == 'true') 
                            <th width=" ">
                                <i class=" fa fa-text-width"></i> @lang('layout.VendorName')
                            </th>
                            @endif
                            @if($seeCost==true)
                            <th>
                                <i class="fa  fa-money"></i> @lang('layout.GrossProfit')
                            </th>
                            @endif
                            @if(getSaleCommission()=="true" && $commission)
                            <th><i class="fa "></i> @lang('layout.Commission') </th>
                            <th><i class="fa "></i> @lang('layout.Value') </th>
                            @endif
                            <th>
                                <i class="fa  "></i> @lang('layout.CustomerCheck')
                            </th>
                            @if(getSaleCommission()=="true")
                            <th>
                                <i class="fa  "></i> @lang('layout.Commission') @lang('layout.Percentage')%
                            </th>
                            @endif
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td class=" "> {{ $invoice->old_oil_counter}}  </td>
                            <td class=" "> {{ $invoice->new_oil_counter}}  </td>
                            <td class=" "> {{ $invoice->description}}  </td>
                            <td class=" "> {{ $invoice->memo}}  </td>
                            @if(showVendorInFactor() == 'true') 
                            <td class=" "> {{ $invoice->vendor_name}}  </td>
                            @endif
                            @if($seeCost==true)
                            @if(systemConfig()[30] == 1)
                            <td class=""> {{myRound($grossProfit*$invoice->static_rate / $invoice->rate)}} </td>
                            @else 
                            <td class=""> {{myRound($grossProfit*$invoice->rate)}} </td>
                            @endif

                            @endif
                            @if(getSaleCommission()==true && $commission)
                            <td class=""> {{myRound($commission->name)}} </td>
                            <td class=""> {{myRound($commission->tax_amount)}} </td>
                            @endif
                            @if($invoice->customer_status)
                            <td class=""> @lang('layout.checked') </td>
                            @else 
                            <td class=""> </td>
                            @endif
                            @if(getSaleCommission()=="true")
                            <td class=""> {{$invoice->commission_percent}}  </td>
                            @endif
                        </tr>
                    </tbody>
                </table>
            </div>
            @if(getDriverInfo() == "true")
                <div class="table-scrollable">
                    <h4>@lang('layout.DriverInfo')</h4>
                    <table class="table table-striped table-bordered table-advance table-hover">
                        <thead>
                            <tr>
                                <th class="">
                                    <i class="fa fa-bars"></i> @lang('layout.TransferCode')
                                </th>
                                <th class="">
                                    <i class="fa fa-user"></i> @lang('layout.Transporter_name')
                                </th>
                                <th>
                                    <i class="fa fa-file-excel-o"></i> @lang('layout.Transporter_phone')
                                </th>
                                <th>
                                    <i class="fa fa-text-width"></i> @lang('layout.PlaceOfWeight')
                                </th>
                                <th>
                                    <i class="fa "></i> @lang('layout.SourcePlace')
                                </th>
                                <th>
                                    <i class="fa "></i> @lang('layout.PlateNumber')
                                </th>
                                <th>
                                    <i class="fa  "></i> @lang('layout.WayBillNumber')
                                </th>
                                <th>
                                    <i class="fa  "></i> @lang('layout.TotalWeight')
                                </th>
                                <th>
                                    <i class="fa  "></i> @lang('layout.EmptyCarWeight')
                                </th>
                                <th>
                                    <i class="fa  "></i> @lang('layout.TotalBori')
                                </th>
                                <th>
                                    <i class="fa  "></i> @lang('layout.Description')
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            <td class=""> {{$invoice->transferCode }}  </td>
                            <td class=""> {{$invoice->driver}}  </td>
                            <td class=""> {{$invoice->driverPhone}}  </td>
                            <td class=""> {{$invoice->PlaceOfWeight}}  </td>
                            <td class=""> {{$invoice->sourcePlace }}  </td>
                            <td class=""> {{$invoice->plateNumber }}  </td>
                            <td class=""> {{$invoice->wayBillNumber }}  </td>
                            <td class=""> {{$invoice->totalWeight }}  </td>
                            <td class=""> {{$invoice->emptyCarWeight }}  </td>
                            <td class=""> {{$invoice->bori }}  </td>
                            <td class=""> {{$invoice->trDesription }}  </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            @endif        
            @if(getTransferRent()=="true" && $transferRent && $transferRent!=null)
                <div class="table-scrollable">
                    <h4>@lang('layout.TransferRent')</h4>
                    <table class="table table-striped table-bordered table-advance table-hover">
                        <thead>
                            <tr>
                                <th >@lang('layout.Number')</th>
                                <th >@lang('layout.Type')</th>
                                <th >@lang('layout.Transmitter')</th>
                                <th >@lang('layout.Account')</th>
                                <th >@lang('layout.Amount')</th>
                                <th >@lang('layout.Currency')</th>
                                <th >@lang('layout.Rate')</th>
                                <th >@lang('layout.Description')</th>
                            </tr>
                        </thead>
                        <tbody>
                            <td class=""> {{$transferRent->id }}  </td>
                            <td class=""> {{__('type.'.$transferRent->type)}}</td>
                            <td class=""> {{$transferRent->vendor_name}}  </td>
                            @if($transferRent->type=="cash")
                            <td class=""> {{$transferRent->b_account_name }}  </td>
                            @endif
                            @if($transferRent->type=="credit")
                            <td class=""> {{$transferRent->p_account_name }}  </td>
                            @endif
                            <td class="">{{myRound($transferRent->receivable_amount)}}</td>
                            <td class=""> {{$transferRent->currency }}  </td>
                            <td class=""> {{$transferRent->rate }}  </td>
                            <td class=""> {{$transferRent->description }}  </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            @endif            

        </div>
    </div>

        <div class="tabbable tabbable-tabdrop"> 
            <ul class="nav nav-tabs">
                <li class="active">
                    <a href="#tab1" data-toggle="tab" id="tab_sale">@lang('layout.InvoiceDetails')</a>
                </li>
                <li class="">
                    <a href="#tab2" data-toggle="tab" id="tab_payment">@lang('layout.Attachments')</a>
                </li>
                @if(getInvoicePayment()== "true")
                <li class="">
                    <a href="#tab3" data-toggle="tab" id="tab_invoice_payment">@lang('layout.InvoicePayment')</a>
                </li>
                @endif 
                @if(getTaxation()== "true")
                <li class="">
                    <a href="#tab4" data-toggle="tab" id="tab_taxation">@lang('menu.Taxation')</a>
                </li>
                @endif
                <li class="">
                    <a href="#tab5" data-toggle="tab" id="tab_grn">@lang('layout.GRN')</a>
                </li>
                @if(systemConfig()[16] != 0)
                <li class="">
                    <a href="#tab6" data-toggle="tab" id="farmer_c">@lang('layout.FarmerContract')</a>
                </li>
                @endif
                @if(getFlour()=="true")
                <li class="">
                    <a href="#tab7" data-toggle="tab" id="laboratory_id">@lang('menu.LaboratoryTest')</a>
                </li>
                <li class="">
                    <a href="#tab8" data-toggle="tab" id="weighbridge_id">@lang('layout.Weighbridge')</a>
                </li>
                @endif
                @if(voucherOfferingType() == '1')
                <li class="">
                    <a href="#tab9" data-toggle="tab" id="saleExpenseInfos">@lang('layout.TransferDetails')</a>
                </li>
                @endif

            </ul>
            <div class="tab-content">
                <div class="tab-pane active" id="tab1">
                    <div class="row">

                        <div class="col-md-12">
                            <!-- BEGIN EXAMPLE TABLE PORTLET-->
                            <div class="portlet light bordered">
                                <div class="portlet-title">
                                    <div class="caption font-dark">
                                        <i class="icon-settings font-dark"></i>
                                        <span class="caption-subject bold uppercase">@lang('layout.InvoiceDetails') </span>
                                    </div>
                                    <div class="tools"></div>
                                    <div class="actions">

                                        <span id="anchore-modal">
                                         <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                                            <i class="fa fa-print"></i>
                                         </a>
                                        </span>

                                    </div>
                                </div>
                                <div class="portlet-body">
                                    <table class="table table-striped table-bordered table-hover" id="invoices">
                                        <thead>
                                        <tr>
                                            @if(getSerailNumber() =="true")
                                                <th>@lang('layout.SerialNum')</th>
                                            @endif
                                            <th>@lang('layout.ItemName')</th>
                                            <th>@lang('layout.Site')</th>
                                            @if(searchByCodeLocation()=="true")
                                            <th>@lang('layout.Location')</th>
                                            @endif
                                            @if(getSaleDescription()=="true") 
                                            <th>@lang('layout.Model')</th>
                                            <th>@lang('layout.Color')</th>
                                            @endif
                                            <th>@lang('layout.PurchaseDate')</th>
                                            <th>@lang('layout.SleepStaff')</th>
											@if(oilSale() == 'true')
                                            <th>@lang('layout.Unit/M')</th>
											<th>@lang('layout.Density')</th>
											<th>@lang('layout.OilQuantity')</th>
											<th>@lang('layout.Price')</th>
                                            <th>@lang('layout.CostViaLitter')</th>
                                            @endif
											@if(getOtherMeasure()=="true")
                                            <th>@lang('layout.OMeasureValue1')</th>
                                            @endif
                                            @if(getOtherMeasure2()=="true")
                                            <th>@lang('layout.OMeasureValue2')</th>
                                            @endif
                                            <th>@lang('layout.Unit/M')</th>
                                            <th>@lang('layout.Quantity')</th>
                                            <th>@lang('layout.Price')</th>
                                            <th>@lang('layout.Discount')</th>

                                            @if(getSaleCommission()=="true")
                                            <th>@lang('layout.Commission') @lang('layout.Percentage')%</th>
                                            <th>@lang('layout.Commission') @lang('layout.Amount')</th>
                                            @endif 

                                            @if($seeCost==true)
                                            <th>@lang('layout.Cost')</th>
                                            <th>@lang('layout.GrossProfit')</th>
                                            @if(oilSale() == 'true')
                                            @endif
                                            @endif
											<th>@lang('layout.Total')</th>
											<th>@lang('layout.GRN')</th>
                                        </tr>
                                        </thead>
                                    </table>
                                </div>
                            </div>
                            <!-- END EXAMPLE TABLE PORTLET-->
                        </div>
                    </div>
                </div>
                <div class="tab-pane" id="tab2">
                    <div class="portlet light bordered">
                        <div class="portlet-title">
                            <div class="caption font-dark">
                                <i class="icon-settings font-dark"></i>
                                <span class="caption-subject bold uppercase">@lang('layout.Attachments')</span>
                            </div>
                        </div>
                        <div class="portlet-body">
                            <div class="portlet light bordered">
                                <div class="portlet-body"> 
                                    <form role="form" action="{{route('attachment.store')}}" method="post"
                                          enctype="multipart/form-data"> 
                                        @csrf
                                        <input type="hidden" name="redirect_route" value="invoice.show">
                                        <input type="hidden" name="foreign_data_id" value="{{$invoice->invoice_id}}">
                                        <input type="hidden" name="path" value="uploads/Invoice">
                                        <input type="hidden" name="table_name" value="sales">

                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.AttachmentTitle')</label>
                                                    <input type="text" name="title" class="form-control">
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.Description')</label>
                                                    <textarea name="description" class="form-control"></textarea>
                                                </div>
                                            </div>
                                            <div class="col-md-7">
                                                <div class="form-group">
                                                    <div class="fileinput fileinput-new" data-provides="fileinput">
                                                        <div class="fileinput-new thumbnail"
                                                             style="width: 200px; height: 150px;">
                                                            <img src="" alt=""></div>
                                                        <div class="fileinput-preview fileinput-exists thumbnail"
                                                             style="max-width: 200px; max-height: 150px; line-height: 10px;"></div>
                                                        <div>
                                                                    <span class="btn default btn-file">
                                                                        <span class="fileinput-new">@lang('layout.SelectFile')</span>
                                                                        <span class="fileinput-exists">@lang('layout.Change')</span>
                                                                        <input type="hidden" value="" name=""><input
                                                                                type="file" name="photo"> </span>

                                                            <a href="javascript:;" class="btn default fileinput-exists"
                                                               data-dismiss="fileinput"> @lang('layout.Remove') </a>
                                                        </div>

                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="margiv-top-10">
                                            <button type="button" onclick="regForm(this)"
                                                    class="btn green"> @lang('layout.Submit') </button>
                                            <a href="{{route('dailyExpense.index')}}"
                                               class="btn default">@lang('layout.Cancel')</a>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <table class="table table-striped table-bordered table-hover" id="attachment">
                                <thead>
                                <tr>
                                    <th>@lang('layout.AttachmentTitle')</th>
                                    <th>@lang('layout.Description')</th>
                                    <th>@lang('layout.Action')</th>
                                </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>                 
                
                <div class="tab-pane" id="tab5">
                    <div class="portlet light bordered">
                        <div class="portlet-title">
                            <div class="caption font-dark">
                                <i class="icon-settings font-dark"></i>
                                <span class="caption-subject bold uppercase">@lang('layout.GRN')</span>
                            </div>
                        </div>
                        <div class="portlet-body">
                            <!-- <div class="portlet light bordered">
                                <div class="portlet-body">

                                    <form role="form" action="{{route('attachment.store')}}" method="post"
                                          enctype="multipart/form-data">

                                        @csrf
                                        <input type="hidden" name="redirect_route" value="invoice.show">
                                        <input type="hidden" name="foreign_data_id" value="{{$invoice->invoice_id}}">
                                        <input type="hidden" name="path" value="uploads/Invoice">
                                        <input type="hidden" name="table_name" value="sales">

                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.AttachmentTitle')</label>
                                                    <input type="text" name="title" class="form-control">
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.Description')</label>
                                                    <textarea name="description" class="form-control"></textarea>
                                                </div>
                                            </div>
                                            <div class="col-md-7">
                                                <div class="form-group">
                                                    <div class="fileinput fileinput-new" data-provides="fileinput">
                                                        <div class="fileinput-new thumbnail"
                                                             style="width: 200px; height: 150px;">
                                                            <img src="" alt=""></div>
                                                        <div class="fileinput-preview fileinput-exists thumbnail"
                                                             style="max-width: 200px; max-height: 150px; line-height: 10px;"></div>
                                                        <div>
                                                                    <span class="btn default btn-file">
                                                                        <span class="fileinput-new">@lang('layout.SelectFile')</span>
                                                                        <span class="fileinput-exists">@lang('layout.Change')</span>
                                                                        <input type="hidden" value="" name=""><input
                                                                                type="file" name="photo"> </span>

                                                            <a href="javascript:;" class="btn default fileinput-exists"
                                                               data-dismiss="fileinput"> @lang('layout.Remove') </a>
                                                        </div>

                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="margiv-top-10">
                                            <button type="button" onclick="regForm(this)"
                                                    class="btn green"> @lang('layout.Submit') </button>
                                            <a href="{{route('dailyExpense.index')}}"
                                               class="btn default">@lang('layout.Cancel')</a>
                                        </div>
                                    </form>
                                </div>
                            </div> -->
                            <table class="table table-striped table-bordered table-hover" id="grn">
                                <thead>
                                <tr>
                                    <th>@lang('layout.Name')</th>
                                    <th>@lang('layout.Number')</th>
                                    <th>@lang('layout.Action')</th>
                                </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>                

                <div class="tab-pane" id="tab3">
                    <div class="portlet light bordered">
                        <div class="portlet-title">
                            <div class="caption font-dark">
                                <i class="icon-settings font-dark"></i>
                                <span class="caption-subject bold uppercase">@lang('layout.InvoicePayment')</span>
                            </div>
                        </div>
                        <div class="portlet-body">  
                            <table class="table table-striped table-bordered table-hover" id="invoice_payment">
                                <thead>
                                <tr>
                                    <th>@lang('layout.Description')</th>
                                    <th>@lang('layout.Amount')</th>
                                    <th>@lang('layout.Currency')</th>
                                    <th>@lang('layout.Rate')</th>
                                </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>


                <div class="tab-pane" id="tab9">
                    <div class="portlet light bordered">
                        <div class="portlet-title">
                            <div class="caption font-dark">
                                <i class="icon-settings font-dark"></i>
                                <span class="caption-subject bold uppercase">@lang('layout.InvoicePayment')</span>
                            </div>
                        </div>
                        <div class="portlet-body">  
                            <table class="table table-striped table-bordered table-hover" id="saleExpenseInfo">
                                <thead>
                                <tr>
                                    <th>@lang('layout.Name')</th>
                                    <th>@lang('layout.Amount')</th>
                                    <th>@lang('layout.Date')</th>
                                    <th>@lang('layout.AccountRegister')</th>
                                    <th>@lang('layout.Description')</th>
                                </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
                
				
                <div class="tab-pane" id="tab4">
                    <div class="portlet light bordered">
                        <div class="portlet-title">
                            <div class="caption font-dark">
                                <i class="icon-settings font-dark"></i>
                                <span class="caption-subject bold uppercase">@lang('menu.Taxation')</span>
                            </div>
                        </div>
                        <div class="portlet-body">

                            <table class="table table-striped table-bordered table-hover" id="invoice_taxation">
                                <thead>
                                <tr>
								   <td><div class="center"> @lang('layout.Name') </div></td>
								   <td><div class="center"> @lang('layout.Percent') </div></td>
								   <td><div class="center"> @lang('layout.Vendor') </div></td>
								   <td><div class="center"> @lang('layout.Amount') </div></td>
                                </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>

                <div class="tab-pane" id="tab6">
                    <div class="portlet light bordered">
                        <div class="portlet-title">
                            <div class="caption font-dark">
                                <i class="icon-settings font-dark"></i>
                                <span class="caption-subject bold uppercase">@lang('layout.FarmerContract')</span>
                            </div>
                        </div>
                        <div class="portlet-body">

                            <table class="table table-striped table-bordered table-hover" id="farmer_contract">
                                <thead>
                                <tr>
								   <td><div class="center" style="color: white;"> @lang('layout.Number') </div></td>
								   <td><div class="center" style="color: white;"> @lang('layout.ReferenceNumber') </div></td>
								   <td><div class="center" style="color: white;"> @lang('layout.LandSize') </div></td>
								   <td><div class="center" style="color: white;"> @lang('layout.DrawingAmount') </div></td>
								   <td><div class="center" style="color: white;"> @lang('layout.Measure') </div></td>
								   <td><div class="center" style="color: white;"> @lang('layout.SeedAmount') </div></td>
								   <td><div class="center" style="color: white;"> @lang('layout.Measure') </div></td>
								   <td><div class="center" style="color: white;"> @lang('layout.OverdueDate') </div></td>
								   <td><div class="center" style="color: white;"> @lang('layout.Description') </div></td>
                                </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
                <div class="tab-pane" id="tab7">
                    <div class="portlet light bordered">
                        <div class="portlet-title">
                            <div class="caption font-dark">
                                <i class="icon-settings font-dark"></i>
                                <span class="caption-subject bold uppercase">@lang('layout.LaboratoryTestCreate')</span>
                            </div>
                        </div>
                        <div class="portlet-body">
                            <div class="portlet green-meadow box">
                                <div class="portlet-title">
                                    
                                </div> 
                                <div class="portlet-body" id="laboratory">

                                    <form role="form" action="{{route('laboratory.store')}}" method="post">
                                        @csrf
                                        <input type="hidden" name="foreign_data_id" value="{{$invoice->invoice_id}}">
                                        <input type="hidden" name="type_number" value="{{$invoice->number}}">
                                        <input type="hidden" name="type" value="sales">
                                        <input type="hidden" name="redirect_route" value="invoice.show">

                                        <div class="row">
                                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.Number')</label>
                                                    <input type="text" name="number" class="form-control">
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.Date')</label>
                                                    <input type="text" name="date" class="form-control date" autocomplete="off">
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.CarNumber')</label>
                                                    <input type="text" name="vehicle_number" class="form-control" autocomplete="off">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    <label class="control-label ">@lang('layout.SelectItem') </label>
                                                    <v-select class="vue-select2" v-model="selected_item" label="name"  :options="laboratory_item" @input="labSelectedMeasure()">
                                                    </v-select>
                                                    <input type="hidden" name="item_id" :value="!selected_item?null:selected_item.item_id" >
                                                </div>
                                    
                                              </div>
                                              <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    <label class="control-label ">@lang('layout.Unit') </label>
                                                    <v-select class="vue-select2" v-model="selected_measure_laboratory" label="measure_name"  :options="laboratory_measure" >
                                                    </v-select>
                                                    <input type="hidden" name="um_id" :value="!selected_measure_laboratory?null:selected_measure_laboratory.measure_id" >
                                                </div>
                                    
                                              </div>

                                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.Description')</label>
                                                    <textarea name="description" class="form-control"></textarea>
                                                </div>
                                            </div>
                                        </div>

                                        @if(count($laboratoryTest)>0)
                                        <table id="table_content" class="table table-bordered">
                                            <thead style="background-color: #36c6d3; color:white"> 
                                            <tr>
                                                @foreach ($laboratoryTest as $key=>$value)
                                                <th >{{$value->name}}</th>
                                                @endforeach
                                            </tr>
                                            </thead>
                                            <tbody>
                                            <tr>
                                                @foreach ($laboratoryTest as $key=>$value)
                                                <td class="highlight">
                                                    <input type="text" name="laboratory_test[{{$value->id}}]" class="form-control" autocomplete="off">
                                                </td> 
                                                @endforeach
                    
                                            </tr> 
                                            </tbody>
                                        </table>
                                        @else
                                        <a href="{{route('laboratoryTest.create')}}"
                                            class="btn red">@lang('menu.LaboratoryTest')</a>

                                        @endif

                                        <div class="margiv-top-10" style="text-align: center">
                                            <button type="button" onclick="regForm(this)"
                                                    class="btn green"> @lang('layout.Submit') </button>
                                            <a href="{{route('invoice.index')}}"
                                               class="btn default">@lang('layout.Cancel')</a>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <div class="row">

                                <div class="col-md-12">
                                    <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                    <div class="portlet light bordered">
                                        <div class="portlet-title">
                                            <div class="caption font-dark">
                                                <i class="icon-settings font-dark"></i>
                                                <span class="caption-subject bold uppercase">@lang('layout.LaboratoryTestList') </span>
                                            </div>
                                            <div class="tools"></div>
                                            <div class="actions">
                                                <span id="lab-modal">
                                                 <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                                                    <i class="fa fa-print"></i>
                                                 </a>
                                                </span>
        
                                            </div>
                                        </div>
                                        <div class="portlet-body">
                                            <table class="table table-striped table-bordered table-hover" id="laboratory_table">
                                                <thead>
                                                <tr>
                                                    <th>@lang('layout.Number')</th>
                                                    <th>@lang('layout.CarNumber')</th>
                                                    <th>@lang('layout.Item')</th>
                                                    <th>@lang('layout.Unit')</th>
                                                    <th>@lang('layout.Description')</th>
                                                    <th>@lang('layout.Date')</th>
                                                    <th>@lang('layout.Action')</th>
                
                
                
                                                </tr>
                                                </thead>
                                            </table>
                                        </div>
                                    </div>
                                    <!-- END EXAMPLE TABLE PORTLET-->
                                </div>
                            </div>
                            
                        </div>
                    </div>
                </div>  
                <div class="tab-pane" id="tab8">
                    <div class="portlet light bordered">
                        <div class="portlet-title">
                            <div class="caption font-dark">
                                <i class="icon-settings font-dark"></i>
                                <span class="caption-subject bold uppercase">@lang('layout.WeighbridgeCreate')</span>
                            </div>
                        </div>
                        <div class="portlet-body">
                            <div class="portlet green-meadow box">
                                <div class="portlet-title">
                                    
                                </div> 
                                <div class="portlet-body" id="weighbridge">

                                    <form role="form" action="{{route('weighbridge.store')}}" method="post">
                                        @csrf
                                        <input type="hidden" name="foreign_data_id" value="{{$invoice->invoice_id}}">
                                        <input type="hidden" name="type_number" value="{{$invoice->number}}">
                                        <input type="hidden" name="type" value="sales">
                                        <input type="hidden" name="redirect_route" value="invoice.show">

                                        <div class="row">
                                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.Number')</label>
                                                    <input type="text" name="number" class="form-control">
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.CarNumber')</label>
                                                    <input type="text" name="vehicle_number" class="form-control" autocomplete="off">
                                                </div>
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.DriverName')</label>
                                                    <input type="text" name="driver_name" class="form-control" autocomplete="off">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                              <div class="form-group">
                                                  <label class="control-label">@lang('layout.FullWeight')</label>
                                                  <input type="number" name="full_weight" class="form-control" autocomplete="off">
                                              </div>
                                  
                                            </div>
                                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.EmptyWeight')</label>
                                                    <input type="number" name="empty_weight" class="form-control" autocomplete="off">
                                                </div>
                                    
                                              </div>
                                              <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.NetWeight')</label>
                                                    <input type="number" name="net_weight" class="form-control" autocomplete="off">
                                                </div>
                                    
                                              </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    <label class="control-label ">@lang('layout.SelectItem') </label>
                                                    <v-select class="vue-select2" v-model="selected_item_weighbridge" label="name"  :options="weighbridge_item" @input="selectedMeasure()">
                                                    </v-select>
                                                    <input type="hidden" name="item_id" :value="!selected_item_weighbridge?null:selected_item_weighbridge.item_id" >
                                                </div>
                                    
                                              </div>
                                              <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    <label class="control-label ">@lang('layout.Unit') </label>
                                                    <v-select class="vue-select2" v-model="selected_measure_weighbridge" label="measure_name"  :options="weighbridge_measure" >
                                                    </v-select>
                                                    <input type="hidden" name="um_id" :value="!selected_measure_weighbridge?null:selected_measure_weighbridge.measure_id" >
                                                </div>
                                    
                                              </div>


                                              <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.Date')</label>
                                                    <input type="text" name="date" class="form-control date" autocomplete="off">
                                                </div>
                                            </div>
                                            <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.Hour')</label>
                                                    <div class="input-group"> 
                                                        @if(getHourType() == 24)
                                                        <input type="text" class="form-control timepicker timepicker-24" name="hour">
                                                        @else
                                                        <input type="text" class="form-control timepicker timepicker-no-seconds" name="hour">
                                                        @endif
                                                        <span class="input-group-btn">
                                                            <button class="btn default" type="button">
                                                                <i class="fa fa-clock-o"></i>
                                                            </button>
                                                        </span>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    <label class="control-label">@lang('layout.Description')</label>
                                                    <textarea name="description" class="form-control"></textarea>
                                                </div>
                                            </div>

                                            @if(count($weighbridgeCategori)>0)
                                            <table id="table_content" class="table table-bordered" style="overflow-x: scroll;">
                                                <thead style="background-color: #36c6d3; color:white"> 
                                                <tr>
                                                    @foreach ($weighbridgeCategori as $key=>$value)
                                                    <th>{{$value->name}}</th>
                                                    @endforeach
                                                </tr>
                                                </thead>
                                                <tbody>
                                                <tr>
                                                    @foreach ($weighbridgeCategori as $key=>$value)
                                                    <td class="highlight">
                                                        <input type="text" name="weight_category[{{$value->id}}]" class="form-control" autocomplete="off">
                                                    </td> 
                                                    @endforeach
                        
                                                </tr> 
                                                </tbody>
                                            </table>
                                            @endif

                                        </div>
                                        <div class="margiv-top-10" style="text-align: center">
                                            <button type="button" onclick="regForm(this)"
                                                    class="btn green"> @lang('layout.Submit') </button>
                                            <a href="{{route('invoice.index')}}"
                                               class="btn default">@lang('layout.Cancel')</a>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <div class="row">

                                <div class="col-md-12">
                                    <!-- BEGIN EXAMPLE TABLE PORTLET-->
                                    <div class="portlet light bordered">
                                        <div class="portlet-title">
                                            <div class="caption font-dark">
                                                <i class="icon-settings font-dark"></i>
                                                <span class="caption-subject bold uppercase">@lang('layout.WeighbridgeList') </span>
                                            </div>
                                            <div class="tools"></div>
                                            <div class="actions">
                                                <span id="weigh-modal">
                                                 <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                                                    <i class="fa fa-print"></i>
                                                 </a>
                                                </span>
        
                                            </div>
                                        </div>
                                        <div class="portlet-body">
                                            <table class="table table-striped table-bordered table-hover" id="weighbridge_table">
                                                <thead>
                                                <tr>
                                                    <th>@lang('layout.Number')</th>
                                                    <th>@lang('layout.CarNumber')</th>
                                                    <th>@lang('layout.DriverName')</th>
                                                    <th>@lang('layout.Item')</th>
                                                    <th>@lang('layout.Unit')</th>
                                                    <th>@lang('layout.FullWeight')</th>
                                                    <th>@lang('layout.EmptyWeight')</th>
                                                    <th>@lang('layout.NetWeight')</th>
                                                    <th>@lang('layout.Date')</th>
                                                    <th>@lang('layout.Hour')</th>
                                                    <th>@lang('layout.Description')</th>
                                                    <th>@lang('layout.Action')</th>
                                                </tr>
                                                </thead>
                                            </table>
                                        </div>
                                    </div>
                                    <!-- END EXAMPLE TABLE PORTLET-->
                                </div>
                            </div>
                            
                        </div>
                    </div>
                </div>   

            </div>
        </div>



<!--Transport Company And Drivers-->
@if(getTransportCompany()=="true")
    @if($transportCompany)
    @if($transportCompany->driver_name || $transportCompany->trasnport_name!=null )
 <div class="portlet">
        <div class="portlet-title">
            <div class="caption">
                <i class=""></i>@lang('layout.TransportCompanyAndDriver')
            </div>
          
        </div>
        <div class="portlet-body">
            <div class="table-scrollable">
                 <div class="col-md-12">
                    <div class="col-md-6 col-sm-12">
                            <table class="table table-striped table-bordered table-advance table-hover" style="width: 100%;">
                                <thead>
                                <tr>
                                    <th width="20px;">
                                        <i class="fa  fa-bars"></i> @lang('layout.Number')
                                    </th>   
                                    <th width="20px;">
                                        <i class="fa  fa-bars"></i> @lang('layout.LicenseNumber')
                                    </th>  
                                    <th width="20px;">
                                        <i class="fa  fa-user"></i> @lang('layout.Name')
                                    </th>
                                    <th width="20px;">
                                        <i class="fa  fa-phone"></i> @lang('layout.Phone')
                                    </th>
                                    <th width="20px;">
                                        <i class="fa  fa-bars"></i> @lang('layout.Email')
                                    </th> 
                                    <th width="20px;">
                                        <i class="fa  fa-bars"></i> @lang('layout.City')
                                    </th> 
                                    <th width="20px;">
                                        <i class="fa  fa-bars"></i> @lang('layout.Address')
                                    </th>
                                </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td align="right"><b>{{$transportCompany->trasnport_number}}</b></td>
                                        <td align="right"><b>{{$transportCompany->trasnport_license_number}}</b></td>
                                        <td align="right"><b>{{$transportCompany->trasnport_name}}</b></td>
                                        <td align="right"><b>{{$transportCompany->trasnport_phone}}</b></td>
                                        <td align="right"><b>{{$transportCompany->trasnport_email}}</b></td>
                                        <td align="right"><b>{{$transportCompany->trasnport_city}}</b></td>
                                        <td align="right"><b>{{$transportCompany->trasnport_address}}</b></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>                         

                      <div class="col-md-6 col-sm-12">
                            <table class="table table-striped table-bordered table-advance table-hover" style="width: 100%;">
                                <thead>
                                <tr>
                                    <th width="20px;">
                                        <i class="fa  fa-bars"></i> @lang('layout.Number')
                                    </th>   
                                    <th width="20px;">
                                        <i class="fa  fa-bars"></i> @lang('layout.SSID')
                                    </th>  
                                    <th width="20px;">
                                        <i class="fa  fa-user"></i> @lang('layout.Name')
                                    </th>
                                    <th width="20px;">
                                        <i class="fa  fa-bars"></i> @lang('layout.LastName')
                                    </th>
                                    <th width="20px;">
                                        <i class="fa  fa-phone"></i> @lang('layout.Phone')
                                    </th> 
                                    <th width="20px;">
                                        <i class="fa  fa-bars"></i> @lang('layout.City')
                                    </th> 
                                    <th width="20px;">
                                        <i class="fa  fa-bars"></i> @lang('layout.Address')
                                    </th>
                                </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td align="right"><b>{{$transportCompany->driver_code}}</b></td>
                                        <td align="right"><b>{{$transportCompany->driver_ss_idr}}</b></td>
                                        <td align="right"><b>{{$transportCompany->driver_name}}</b></td>
                                        <td align="right"><b>{{$transportCompany->driver_last_name}}</b></td>
                                        <td align="right"><b>{{$transportCompany->driver_phone}}</b></td>
                                        <td align="right"><b>{{$transportCompany->driver_city}}</b></td>
                                        <td align="right"><b>{{$transportCompany->driver_address}}</b></td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                </div>
            </div>
        </div>
    </div>
     @endif
  @endif
@endif
<!--End Transport Company And Driver-->

@endsection
@include('print.modal')
@push('scripts')

<script src="{{URL::asset('assets/global/plugins/bootstrap-timepicker/js/bootstrap-timepicker.min.js')}}" type="text/javascript"></script>
<script src="{{URL::asset('assets/pages/scripts/components-date-time-pickers.min.js')}}" type="text/javascript"></script>
 
    <script>
        Vue.component('v-select', VueSelect.VueSelect); 
        function grnPrintAll(id, item_id = null) { 
        var invoice_id = {{$invoice->invoice_id}};
        var a = document.createElement('a');
        a.href = "{{url('grnPrintAll')}}/" + id+"/"+invoice_id+"/"+item_id;
        a.target = "_blank";
        document.body.appendChild(a);
        a.click();
        document.body.removeChild(a); 
        }   
          
        function grnMultiPrint(number = 0, site_id) { 
            var a = document.createElement('a');
            a.href = "{{url('invoiceMultipleCurrencyGrn')}}/" + number + "/" + site_id;
            a.target = "_blank";
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
        } 


       

        var cust_rep = {!!customeReportNewData('invoice_show')!!};
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#invoices').DataTable({
                ajax: {
                    url: '{{route("invoice.show",$invoice->invoice_id)}}',
                    data: {type: 'invoice'}
                },
                pageLength:'{{getPageRows()}}',
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',

                scrollCollapse: true,
                serverSide: true,
                paging: true,
                columns: [
                        @if(getSerailNumber() =="true"){data: 'number', name: 'number', orderable: false}, @endif
                    {
                        data: 'name', name: 'name', orderable: false
                    },
                    {data: 'siteName', name: 'siteName', orderable: false, searchable: false},
                    @if(searchByCodeLocation()=="true")
                    {data: 'location', name: 'location', orderable: false, searchable: false},
                    @endif
                    @if(getSaleDescription()=="true") 
                    { data: 'model',      name: 'model',searchable:false },
                    { data: 'color',      name: 'color',searchable:false },
                    @endif
                    {data: 'stocks_date', name: 'stocks_date', orderable: false, searchable: false},
                    {data: 'sleepDate', name: 'sleepDate', orderable: false, searchable: false},
                    @if(oilSale() == 'true')
                    {data: 'oilSymbol', name: 'oilSymbol', orderable: false, searchable: false},
                    {data: 'density', name: 'density', orderable: false, searchable: false},
                    {data: 'oil_qty', name: 'oil_qty', orderable: false, searchable: false},
                    {data: 'oilPrice', name: 'oilPrice', orderable: false, searchable: false},
                    {data: 'priceAsLiter', name: 'priceAsLiter', orderable: false, searchable: false},
					@endif
                    @if(getOtherMeasure()=="true")
                    { data: 'other_measure', name: 'other_measure', orderable: false, searchable: false },
                    @endif
                    @if(getOtherMeasure2()=="true")
                    { data: 'other_measure2', name: 'other_measure2', orderable: false, searchable: false},
                    @endif
                    {data: 'symbol', name: 'symbol', orderable: false, searchable: false},
					{data: 'qty', name: 'qty', orderable: false, searchable: false},
                    {data: 'price', name: 'price', orderable: false, searchable: false},
                    {data: 'discount', name: 'discount', orderable: false, searchable: false}, 

                    @if(getSaleCommission()=="true")
                    { data: 'row_commission_percent', name: 'row_commission_percent', orderable:false,searchable:false },
                    { data: 'total_commission', name: 'total_commission', orderable:false,searchable:false },
                    @endif  

                    @if($seeCost == true)
                    {data: 'avgCost', name: 'avgCost', orderable: false, searchable: false},
                    {data: 'income', name: 'income', orderable: false, searchable: false},
                    @endif 
					{data: 'total', name: 'total', orderable: false, searchable: false},
					{data: 'actions', name: 'actions', orderable: false, searchable: false},
                ]
            });

            $('#attachment').DataTable({
                ajax: {
                    url: '{{route("invoice.show",$invoice->invoice_id)}}',
                    data: {type: 'attachment'}
                },
                pageLength:'{{getPageRows()}}',
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',

                scrollCollapse: true,
                serverSide: true,
                paging: true,
                columns: [

                    {data: 'title', name: 'attachments.title'},
                    {data: 'description', name: 'attachments.description'},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false},
                ]
            });              
            
            
            $('#grn').DataTable({
                ajax: {
                    url: '{{route("invoice.show",$invoice->invoice_id)}}',
                    data: {type: 'grn'}
                },
                pageLength:'{{getPageRows()}}',
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',

                scrollCollapse: true,
                serverSide: true,
                paging: true,
                columns: [
                    {data: 'site_name', name: 'site_name'},
                    {data: 'site_number', name: 'site_number'},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false},
                ]
            });           

             $('#invoice_payment').DataTable({
                ajax: {
                    url: '{{route("invoice.show",$invoice->invoice_id)}}',
                    data: {type: 'invoice_payment'}
                },
                pageLength:'{{getPageRows()}}',
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',

                scrollCollapse: true,
                serverSide: true,
                paging: true,
                columns: [ 
                    {data: 'description', name: 'sale_payments.description'},
                    {data: 'amount', name: 'sale_payments.amount'},
                    {data: 'currency', name: 'sale_payments.currency'},
                    {data: 'rate', name: 'sale_payments.rate'},
                ]
            }); 

             $('#saleExpenseInfo').DataTable({
                ajax: {
                    url: '{{route("invoice.show",$invoice->invoice_id)}}',
                    data: {type: 'saleExpenseInfo'}
                },
                pageLength:'{{getPageRows()}}',
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                serverSide: true,
                paging: true,
                columns: [ 
                    {data: 'name', name: 'name'},
                    {data: 'amount', name: 'amount'},
                    {data: 'date', name: 'date'},
                    {data: 'register_account', name: 'register_account'},
                    {data: 'description', name: 'description'}
                ]
            });
             $('#invoice_taxation').DataTable({
                ajax: {
                    url: '{{route("invoice.show",$invoice->invoice_id)}}',
                    data: {type: 'invoice_taxation'}
                },
                pageLength:'{{getPageRows()}}',
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}', 
                scrollCollapse: true,
                serverSide: true,
                paging: true,
                columns: [
                    {data: 'name', name: 'taxations.name'},
                    {data: 'percent', name: 'percent', orderable: false, searchable: false},
                    {data: 'vendor_name', name: 'vendor.name'},
                    {data: 'tax_amount', name: 'transactions.amount'},
                ]
            }); 
            $('#farmer_contract').DataTable({
                ajax: {
                    url: '{{route("invoice.show",$invoice->invoice_id)}}',
                    data: {type: 'farmer_contract'}
                },
                pageLength:'{{getPageRows()}}',
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',

                scrollCollapse: true,
                serverSide: true,
                paging: true,
                columns: [
                    {data: 'number', name: 'contract_farmer.number'},
                    {data: 'ref_no', name: 'contract_farmer.ref_no'},
                    {data: 'land_size', name: 'contract_farmer.land_size'},
                    {data: 'land_drawing_amount', name: 'contract_farmer.land_drawing_amount'},
                    {data: 'land_measure', name: 'land_measure', orderable: false, searchable: false},
                    {data: 'seed_amount', name: 'contract_farmer.seed_amount'},
                    {data: 'measure', name: 'measure', orderable: false, searchable: false},
                    {data: 'overdueDate', name: 'overdueDate', orderable: false, searchable: false},
                    {data: 'sale_description', name: 'contract_farmer.sale_description'},
                ]
            });

            // 
            $('#laboratory_id').on('shown.bs.tab', function(event){
            $('#laboratory_table').DataTable({
                ajax: {
                    url: '{{route("invoice.show",$invoice->invoice_id)}}',
                    data: {type: 'laboratory'}
                },
                pageLength:'{{getPageRows()}}',
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',

                scrollCollapse: true,
                serverSide: true,
                paging: true,
                destroy: true,
                columns: [

                    {data: 'number', name: 'laboratories.number'},
                    {data: 'vehicle_number', name: 'laboratories.vehicle_number'},
                    {data: 'item_name', name: 'item_name', orderable: false, searchable: false},
                    {data: 'measure_name', name: 'measure_name', orderable: false, searchable: false},
                    {data: 'description', name: 'laboratories.description'},
                    {data: 'date', name: 'date', orderable: false, searchable: false},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false}
                ]
            }); 
            });             
            
            $('#weighbridge_id').on('shown.bs.tab', function(event){
            $('#weighbridge_table').DataTable({
                ajax: {
                    url: '{{route("invoice.show",$invoice->invoice_id)}}',
                    data: {type: 'weighbridge'}
                },
                pageLength:'{{getPageRows()}}',
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',

                scrollCollapse: true,
                serverSide: true,
                paging: true,
                destroy: true,
                columns: [

                    {data: 'number', name: 'weighbridges.number'},
                    {data: 'vehicle_number', name: 'weighbridges.vehicle_number'},
                    {data: 'driver_name', name: 'weighbridges.driver_name'},
                    {data: 'item_name', name: 'item_name', orderable: false, searchable: false},
                    {data: 'measure_name', name: 'measure_name', orderable: false, searchable: false},
                    {data: 'full_weight', name: 'weighbridges.full_weight'},
                    {data: 'empty_weight', name: 'weighbridges.empty_weight'},
                    {data: 'net_weight', name: 'weighbridges.net_weight'},
                    {data: 'date', name: 'date', orderable: false, searchable: false},
                    {data: 'hour', name: 'hour', orderable: false, searchable: false},
                    {data: 'description', name: 'weighbridges.description'},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false}
                ]
            }); 
            }); 

        });



          var vm =new Vue({

            el: '#print-modal',
            data:{
                is_show: false,
                pdfRoute: '{!!route('export.PDFAny') !!}',
                excelRoute: '{!! route('export.exportCsv') !!}',
                customReportData:
                [
                 
                 {Name: '@lang("layout.ItemName")', column_name: 'item_name',checkedColumn:(cust_rep.item_name)?'checked':'',column_percentage:(cust_rep.item_name___percent)?cust_rep.item_name___percent:''},
                 {Name: '@lang("layout.Forgivness")', column_name: 'forgivness',checkedColumn:(cust_rep.forgivness)?'checked':'',column_percentage:(cust_rep.forgivness___percent)?cust_rep.forgivness___percent:''},
                 {Name: '@lang("layout.PurchaseDate")', column_name: 'purchase_date',checkedColumn:(cust_rep.purchase_date)?'checked':'',column_percentage:(cust_rep.purchase_date___percent)?cust_rep.purchase_date___percent:''},
                 {Name: '@lang("layout.SleepStaff")', column_name: 'sleep_day',checkedColumn:(cust_rep.sleep_day)?'checked':'',column_percentage:(cust_rep.sleep_day___percent)?cust_rep.sleep_day___percent:''},
                 {Name: '@lang("layout.Symbol")', column_name: 'symbol',checkedColumn:(cust_rep.symbol)?'checked':'',column_percentage:(cust_rep.symbol___percent)?cust_rep.symbol___percent:''},
                 {Name: '@lang("layout.Quantity")', column_name: 'quantity',checkedColumn:(cust_rep.quantity)?'checked':'',column_percentage:(cust_rep.quantity___percent)?cust_rep.quantity___percent:''},
                 {Name: '@lang("layout.Price")', column_name: 'price',checkedColumn:(cust_rep.price)?'checked':'',column_percentage:(cust_rep.price___percent)?cust_rep.price___percent:''},
                 {Name: '@lang("layout.Cost")', column_name: 'purchase_rate',checkedColumn:(cust_rep.purchase_rate)?'checked':'',column_percentage:(cust_rep.purchase_rate___percent)?cust_rep.purchase_rate___percent:''},
                 {Name: '@lang("layout.GrossProfit")', column_name: 'income',checkedColumn:(cust_rep.income)?'checked':'',column_percentage:(cust_rep.income___percent)?cust_rep.income___percent:''},
                 {Name: '@lang("layout.Total")', column_name: 'total',checkedColumn:(cust_rep.total)?'checked':'',column_percentage:(cust_rep.total___percent)?cust_rep.total___percent:''},
                 {Name: '@lang("layout.TotalGrossProfit")', column_name: 'Total_gross_profit',checkedColumn:(cust_rep.Total_gross_profit)?'checked':'',column_percentage:(cust_rep.Total_gross_profit___percent)?cust_rep.Total_gross_profit___percent:''},
                 @if(showLocation()=="true")
                 {Name: '@lang("layout.Location")', column_name: 'location',checkedColumn:(cust_rep.location)?'checked':'',column_percentage:(cust_rep.location___percent)?cust_rep.location___percent:''},
                 @endif
                 @if(getSaleDescription()=="true")
                 {Name: '@lang("layout.Model")', column_name: 'model',checkedColumn:(cust_rep.model)?'checked':'',column_percentage:(cust_rep.model___percent)?cust_rep.model___percent:''},
                 {Name: '@lang("layout.Color")', column_name: 'color',checkedColumn:(cust_rep.color)?'checked':'',column_percentage:(cust_rep.color___percent)?cust_rep.color___percent:''},
                 @endif
                 
                 @if(getSaleCommission()=="true")   
                 {Name: '@lang("layout.Commission")  @lang("layout.Percentage")', column_name: 'commission_percentage',checkedColumn:(cust_rep.commission_percentage)?'checked':'',column_percentage:(cust_rep.commission_percentage___percent)?cust_rep.commission_percentage___percent:''},
                 {Name: '@lang("layout.Commission")  @lang("layout.Amount")', column_name: 'commission_amount',checkedColumn:(cust_rep.commission_amount)?'checked':'',column_percentage:(cust_rep.commission_amount___percent)?cust_rep.commission_amount___percent:''},
                 @endif



                  ],


                  cust_rep:cust_rep
            },
    
            methods:{
                closeModal: function(){
                    this.is_show = !this.is_show;
                }
            }
        });

    new Vue({
        el:'#anchore-modal',
        methods:{
            showModal:function(){
                console.log('trr')
                vm.$data.is_show = true;
            }
        }
    });


var vm_lab =new Vue({
    el: '#laboratory-modal',
    data:{
        is_show: false,
        pdfRoute: '{!!route('export.PDFAny') !!}',
        excelRoute: '{!! route('export.exportCsv') !!}'
    },

    methods:{
        closeModal: function(){
            this.is_show = !this.is_show;
        }
    }
});

var modal_lab= new Vue({
    el: '#lab-modal',
    methods: {
        showModal: function () {
            vm_lab.$data.is_show = true;
        }    
    }
});

var vm_weigh =new Vue({
    el: '#weighbridge-modal',
    data:{
        is_show: false,
        pdfRoute: '{!!route('export.PDFAny') !!}',
        excelRoute: '{!! route('export.exportCsv') !!}'
    },

    methods:{
        closeModal: function(){
            this.is_show = !this.is_show;
        }
    }
});

var modal_weigh= new Vue({
    el: '#weigh-modal',
    methods: {
        showModal: function () {
            vm_weigh.$data.is_show = true;

        }
        
    }
});
    
var laboratory_item = {!! $laboratory_item!!}
var laboratory_measure = {!! $measureUnitList!!}

   var laboratory =  new Vue({
        el:'#laboratory',
        data:{
            laboratory_item:laboratory_item,
            selected_item:null,
            laboratory_measure:laboratory_measure,
            selected_measure_laboratory:null
        },
        methods:{
            labSelectedMeasure(){
                if(this.selected_item!=null){
                    var measure_id = this.selected_item.measure_id;
                    if(measure_id){
                        this.selected_measure_laboratory = _.find(this.laboratory_measure, (m) => m.measure_id == measure_id);
                    }
                }

            }
        }
    });
    
    var weighbridge_item = {!! $laboratory_item!!}
    var weighbridge_measure = {!! $measureUnitList!!}
    

   var weighbridge =  new Vue({
        el:'#weighbridge',
        data:{
            weighbridge_item:weighbridge_item,
            selected_item_weighbridge:null,
            weighbridge_measure:weighbridge_measure,
            selected_measure_weighbridge:null
        },
        methods:{
            selectedMeasure(){
                if(this.selected_item_weighbridge!=null){
                    var measure_id = this.selected_item_weighbridge.measure_id;
                    if(measure_id){
                        this.selected_measure_weighbridge = _.find(this.weighbridge_measure, (m) => m.measure_id == measure_id);
                    }
                }

            }
        }
    });

    </script>


@endpush
