@extends('layouts.app')
@section('style')

    <style>
     .hide_btn{
        display: none; 
    }

    </style>

@endsection

@section('content')

    <!-- BEGIN CONTENT -->
    <div id="print-modal">

        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute"
                      v-if="is_show"
                      :value-type="'invoicelist'" 
                      @closed="closeModal">

            <div slot="body">
                <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->
                <div class="row" v-cloak>
                         <div class="tabbable tabbable-tabdrop">

                            <ul class="nav nav-tabs">
                                
                                <li class="active">
                                    <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                                </li>
                               @if(systemConfig()[2] != 0 )
                                        @permission(['customreport-list'])
                                <li class="">
                                    <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                                </li>
                                @endpermission
                                @endif
                            </ul>
                            <div class="tab-content">
                                 <div class="tab-pane active" id="tab1"> 
                                        <div class="portlet light bordered">
                                    
                                            <div class="row">
                                                <div class="form-group">

                                                    <div class="col-md-6">
                                                        <label class="control-label ">@lang('layout.SelectMember') </label>
                                                        <v-select class="vue-select2" v-model="selectedMember" label="name" @search="onMemberSearch"
                                                                  :options="memberlist">
                                                        </v-select>
                                                        <input type="hidden" name="member_id"
                                                               v-model.number="(!selectedMember)?null:selectedMember.id">
                                                    </div>
                                                    <div class="col-md-6">
                                                        <label class="control-label ">@lang('layout.MemberClass') </label>
                                                        <v-select class="vue-select2" v-model="selectedClass" label="name" @search="onClassSearch"
                                                                  :options="classlist">
                                                        </v-select>
                                                        <input type="hidden" name="class_id"
                                                               v-model.number="(!selectedClass)?null:selectedClass.id">
                                                    </div>
                                                    <div class="col-md-6">
                                                        <label class="control-label ">@lang('layout.SaleArea') </label>
                                                        <v-select class="vue-select2" v-model="selectedArea" label="name" @search="onSaleAreaSearch"
                                                                  :options="saleArealist">
                                                        </v-select>
                                                        <input type="hidden" name="sale_area_id"
                                                               v-model.number="(!selectedArea)?null:selectedArea.id">
                                                    </div>
                                                    @if(getFactorPending() == 'true')
                                                    <div class="col-md-2">
                                                        <div class="form-group">
                                                            <div class="col-md-12">
                                                                <label class="control-label" >@lang('layout.Factor') @lang('layout.Pending')</label>
                                                                <input type="checkbox" name="pending" value="on" checked class="form-control">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    @endif

                                                </div>
                                            </div>

                                            <div class="row">
                                                <div class="form-group">
                                                    <div class="col-md-12">
                                                        <div class="form-group">
                                                            <label class="control-label"> @lang('layout.Date')</label>
                                                            <div class="input-group">
                                                                <input class="form-control date" id="range-from-example" name="from_date"
                                                                       autocomplete="off">

                                                                <span class="input-group-addon"> @lang('layout.To') </span>
                                                                <input class="form-control date" id="range-to-example" name="to_date"
                                                                       autocomplete="off">

                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                </div> 

                                <div class="tab-pane" id="tab2"> 
                                   <div class="portlet light bordered">
                                        <div class="portlet-body">

                                            <form  id="saveCustomeReport" role="form" action="{{route('customeReport.storeCustomeReport')}}" method="post" >
                                                @csrf
                                                <input type="hidden" name="part_name" value="invoice_index">


                                                <div class="col-md-12 col-sm-12 col-xs-12">

                                                    <div class="mt-checkbox-inline col-md-2" style="padding: 0px;" v-for="(row,itemIndex) in customReportData">

                                                        <div class="form-group">
                                                        <table class="table table-striped table-bordered table-advance table-hover">
                                                                    <tr>
                                                                        <td style="text-align: center;">@{{ row.Name }}</td>
                                                                    </tr>
                                                                    <tr>
                                                                        <td style="text-align: center;">
                                                                            <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                                            <label class="switch">
                                                                                <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                                :checked="row.checkedColumn" >
                                                                                <span class="slider round"></span>
                                                                            </label>

                                                                            <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                                <option value="">@lang('layout.Select')</option>
                                                                                <option value="2">2 %</option>
                                                                                <option value="6">6 %</option>
                                                                                <option value="10">10 %</option>
                                                                                <option value="15">15 %</option>
                                                                                <option value="20">20 %</option>
                                                                                <option value="25">25 %</option>
                                                                                <option value="30">30 %</option>
                                                                                <option value="40">40 %</option>
                                                                                <option value="50">50 %</option>
                                                                                <option value="60">60 %</option>
                                                                            </select>
                                                                        </td>
                                                                    </tr>
                                                                </table>
                                                             <!-- <label> @{{ row.Name }}</label>

                                                              <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                             <label class="switch">
                                                                    <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                    :checked="row.checkedColumn" >
                                                                  <span class="slider round"></span>
                                                            </label> -->

                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="margiv-top-10">
                                                    <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->

                                                    <button type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i class="fa fa-save"></i> </button>
                                                </div>
                                        </form>
                                        </div>
                                </div>
                        </div>
                        </div>
                    </div>
                </div>
                <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->

            </div>
        </report-modal>
    </div>

    <div class="row">

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="col-md-2 col-sm-2">
                <span class="caption-subject bold uppercase" style="font-size: 20px;">@lang('layout.InvoiceList')</span>
            </div>
            <div class="col-md-5 col-sm-6" id="date_part">
                <div class="form-group">
                    <div class="input-group">
                        <input name="from_date" class="form-control date" ref="from_date" placeholder="@lang('layout.FromDate')" autocomplete="off" />
                        <span class="input-group-addon"> @lang('layout.To') </span>
                        <input name="to_date" class="form-control date" ref="to_date" placeholder="@lang('layout.ToDate')" autocomplete="off" />
                        <span class="input-group-addon btn"  @Click="getData()" > @lang('layout.Search') </span>
                    </div>
                </div>
            </div>


            <div class="portlet-title">
                <div class="caption font-dark">
                    
                </div>
                <div class="tools">
                </div>
                <div class="pull-right">
                    <a href="{{route('invoice.index')}}">
						<button class="btn btn-success">
                            <i class="fa"></i> @lang('layout.Invoice')
                        </button>
                    </a>
                    @permission('invoice-export')
                    <span id="anchore-modal">
                     <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                        <i class="fa fa-print"></i>
                     </a>
                 </span>
                    @endpermission
                    @permission('invoice-create')
                    <a href="{{route('invoice.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @if(ShowCreateToCustomer() == 'true')
                    <a href="{{route('invoice.show_create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-search"></i> @lang('layout.ShowCreate')
                        </button>
                    </a>
					@endif
                    <!-- <button class="btn btn-success" id="addNewRefundd">
                            <i class="icon-action-redo"></i> @lang('menu.Refund')
                        </button> -->
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">
                <template v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered table-hover" cellspacing="0" id="invoice">
                    <thead>
                    
                    <tr>
                        <th>@lang('layout.InvoiceNumber')</th>
                        <th>@lang('layout.ReferenceNumber')</th>
                        <th>@lang('layout.CustomerName')</th>
                        <th>@lang('layout.Account')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.Currency')</th>
                        <th>@lang('layout.Amount')</th>
                        <th>@lang('layout.Discount')</th>
                        @if(getFactorPending() == 'true')
                        <th>@lang('layout.Status')</th>
                        @endif
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>

                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>



    <!-- END TAB PORTLET-->

    <!-- END CONTENT BODY -->


    <!-- for factor begin -->

    <div id="factor-obj">

    </div>
    <iframe id="saleFrames" style="display: none;"></iframe>

    <!-- end for factor -->


@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')

    <script>
        var cust_rep = {!!customeReportNewData('invoice_index')!!};

        var settingAll = {!! getUserSetting() !!};
        @if(Session('sale_id') && getFactorPrint()== "automatic")
        factorPrint("{{Session('sale_id')}}", "{{Session('whatsapp')}}")

        //GRN Print
        // grnPrint("{{Session('sale_id')}}")

        @endif


        function factorPrint(id,sendWhatsapp = null,type = null) {
            if (sendWhatsapp == null || sendWhatsapp == '') {
                sendWhatsapp = 'not';
            }
            var a = document.createElement('a');
            a.href = "{{url('invoiceFactorPrint')}}/" + id + "/" + sendWhatsapp + "/" + type;
            a.target = "_blank";
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);

                    // $.ajax({
                    //         // This PHP file will generate the PDF and save it to your server
                    //         // $pdf->Output('path/to/pdf/file.pdf', 'F');
                    //         url: "{{url('/')}}/invoiceFactorPrint/"+id,
                    //         type: 'get',
                    //         cache: false,

                    //     }).done(function () {

                    //         var s = ' <object  data="' + '{{url('factor22.pdf')}}' + '" type="application/pdf" width="0" height="0"> </object>'

                    //         $('#factor-obj').html(s);
                       

                    //         // $('#someDiv').html('<iframe src="path/to/pdf/file.pdf"></iframe>');
                    //     })
                    //         .fail(function () {
                    //             console.log("error");
                    //         });
        } 

        function washingFormPrint(id) {
            var a = document.createElement('a');
            a.href = "{{url('washingFormPrint')}}/" + id;
            a.target = "_blank";
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
        }  

        //To Hide Extra Actions In Index Page 
        // function showHideElements() {
        //      var x = document.getElementsByClassName('hide_btn');

        //       for (var i = 0; i < x.length; i++) {
        //          if (x[i].style.display == "none") {
        //                 x[i].style.display = "block";
        //          }
        //          else if(x[i].style.display == "block")
        //          {
        //             x[i].style.display = "none"
        //          }  
        //          else
        //          {
        //             x[i].style.display = "block"
        //          }     
        //     }
             
        // }     

         function grnPrint(id,type = null) {

            var a = document.createElement('a');

            console.log('sssLala',a,id,type)
            a.href = "{{url('grnFactorPrint')}}/" + id + "/" + type;
            a.target = "_blank";
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);

                    // $.ajax({
                    //         // This PHP file will generate the PDF and save it to your server
                    //         // $pdf->Output('path/to/pdf/file.pdf', 'F');
                    //         url: "{{url('/')}}/invoiceFactorPrint/"+id,
                    //         type: 'get',
                    //         cache: false,

                    //     }).done(function () {

                    //         var s = ' <object  data="' + '{{url('factor22.pdf')}}' + '" type="application/pdf" width="0" height="0"> </object>'

                    //         $('#factor-obj').html(s);
                       

                    //         // $('#someDiv').html('<iframe src="path/to/pdf/file.pdf"></iframe>');
                    //     })
                    //         .fail(function () {
                    //             console.log("error");
                    //         });
        }
		
		function factorPrintGift(id) {
            var a = document.createElement('a');
            a.href = "{{url('giftFactorPrint')}}/" + id;
            a.target = "_blank";
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
        }

        let data_table;

        function getRecord() {
            // console.log(234, vtr.from_date, vtr.to_date);
            data_table = $('#invoice').DataTable({
                ajax: {
                    ajax: '{{route("invoice.index_pending")}}',
                    data: {
                        from_date: vtr.from_date,
                        to_date: vtr.to_date
                    }
                },
                pageLength: '{{getPageRows()}}',
                scrollCollapse: true,
                order: [["{{orderByColumn()=='number'?0:4}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                destroy: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
                    {data: 'number', name: 'sales.number'},
                    {data: 'ref_no', name: 'sales.ref_no'},
                    {data: 'member_name', name: 'members.name'},
                    {data: 'account_name', name: 'account_name', orderable: false, searchable: false},
                    {data: 'date', name: 'sales.date'},
                    {data: 'currency', name: 'currency', orderable: false, searchable: false},
                    {data: 'amount', name: 'amount', orderable: false, searchable: false},
                    {data: 'discount', name: 'discount', orderable: false, searchable: false},
                    @if(getFactorPending() == 'true')
                    {data: 'status', name: 'status', orderable: false, searchable: false},
                    @endif
                    {data: 'username', name: 'username', orderable: false, searchable: false},
                    {data: 'description', name: 'sales.description'},
                    {data: 'actions', name: 'account', orderable: false, searchable: false},
                    //              { data: 'measure_unit_id', name: 'quantity' },
                    //              { data: 'measure_unit', name: 'rate' },

                ]
            });
        }
        $(document).ready(function() {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            getRecord();

        });

        Vue.component('v-select', VueSelect.VueSelect);
        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    if (typeof data_table == 'object') {
                        data_table.clear();
                        data_table.ajax.reload();
                    }
                }
            }
        });


        var vm = new Vue({

            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',
                selectedMember: null,
                memberlist: [],
                classlist: [],
                selectedClass: null,
                saleArealist: [],
                selectedArea: null,
                 customReportData:
                [
                 
                 {Name: '@lang("layout.ReferenceNumber")', column_name: 'reference_number',checkedColumn:(cust_rep.reference_number)?'checked':'' ,column_percentage:(cust_rep.reference_number___percent)?cust_rep.reference_number___percent:''},
                 {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_rep.description)?'checked':'' ,column_percentage:(cust_rep.description___percent)?cust_rep.description___percent:''},
                 {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_rep.date)?'checked':'' ,column_percentage:(cust_rep.date___percent)?cust_rep.date___percent:''},
                 {Name: '@lang("layout.InvoiceNumber")', column_name: 'invoice_number',checkedColumn:(cust_rep.invoice_number)?'checked':'' ,column_percentage:(cust_rep.invoice_number___percent)?cust_rep.invoice_number___percent:''},
                 {Name: '@lang("layout.Customer")', column_name: 'customer',checkedColumn:(cust_rep.customer)?'checked':'' ,column_percentage:(cust_rep.customer___percent)?cust_rep.customer___percent:''},
                 {Name: '@lang("layout.AccountName")', column_name: 'account_name',checkedColumn:(cust_rep.account_name)?'checked':'' ,column_percentage:(cust_rep.account_name___percent)?cust_rep.account_name___percent:''},
                 {Name: '@lang("layout.Amount")', column_name: 'amount',checkedColumn:(cust_rep.amount)?'checked':'' ,column_percentage:(cust_rep.amount___percent)?cust_rep.amount___percent:''},
                 {Name: '@lang("layout.Unit")', column_name: 'unit',checkedColumn:(cust_rep.unit)?'checked':'' ,column_percentage:(cust_rep.unit___percent)?cust_rep.unit___percent:''},
                 {Name: '@lang("layout.Rate")', column_name: 'rate',checkedColumn:(cust_rep.rate)?'checked':'' ,column_percentage:(cust_rep.rate___percent)?cust_rep.rate___percent:''},
                 {Name: '@lang("layout.DiscountType")', column_name: 'discount_type',checkedColumn:(cust_rep.discount_type)?'checked':'' ,column_percentage:(cust_rep.discount_type___percent)?cust_rep.discount_type___percent:''},
                 {Name: '@lang("layout.Discount")', column_name: 'discount',checkedColumn:(cust_rep.discount)?'checked':'' ,column_percentage:(cust_rep.discount___percent)?cust_rep.discount___percent:''},
                 {Name: '@lang("layout.Total")', column_name: 'total',checkedColumn:(cust_rep.total)?'checked':'' ,column_percentage:(cust_rep.total___percent)?cust_rep.total___percent:''},

                  ],
                  cust_rep:cust_rep
            },

            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show;
                },
                onClassSearch(search, loading) {
                    loading(true);
                    this.searchClass(search, loading, this);
                },
                onSaleAreaSearch(search, loading) {
                    loading(true);
                    this.searchSaleArea(search, loading, this);
                },
                //ajax call to get class
                searchClass(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            keyword: search,
                            table_name: 'member_classes',

                        }
                    })
                        .then(function (response) {
                            this.classlist = [];
                            if (response.data.length > 0) {
                                vm.classlist = response.data;
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        })
                },
                searchSaleArea(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            keyword: search,
                            table_name: 'sale_areas',

                        }
                    })
                        .then(function (response) {
                            this.classlist = [];
                            if (response.data.length > 0) {
                                vm.saleArealist = response.data;
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        })
                },
                //ajax call to get items
                onMemberSearch: _.debounce((search, loading) => {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'member',
                            type: 'Customer',
                            search: search,
                        }
                    })
                        .then(function (response) {
                            this.memberlist = [];
                            if (response.data.length > 0) {
                                vm.memberlist = response.data;
                                console.log('data', vm.memberlist);
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        })

                }, getDebounceTime()),

            }
        });

        var anchor = new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;
                }
            }
        });

        var vtr = new Vue({
            el: '#date_part',
            data: {
                from_date: null,
                to_date: null,
            },
            methods: {
                getData() {
                    this.from_date = this.$refs.from_date.value;
                    this.to_date = this.$refs.to_date.value;
                    // console.log(234, this.from_date, this.to_date,this.$refs.from_date.value);
                    getRecord();
                }
            }
        });
        
    </script>


@endpush
