@extends('layouts.app')

@section('content')
    <!-- BEGIN CONTENT -->
    <div id="print-modal">

        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute"
                      v-if="is_show"
                      :value-type="'invoicelist'"
                      @closed="closeModal">

            <div slot="body">
                <div class="row">
                    <div class="form-group">
					
					<input type="hidden" name="active_sale" value="on">

                        <div class="col-md-6">
                            <label class="control-label ">@lang('layout.SelectMember') </label>
                            <v-select class="vue-select2" v-model="selectedMember" label="name" @search="onMemberSearch"
                                      :options="memberlist">
                            </v-select>
                            <input type="hidden" name="member_id"
                                   v-model.number="(!selectedMember)?null:selectedMember.id">
                        </div>
                        <div class="col-md-6">
                            <label class="control-label ">@lang('layout.MemberClass') </label>
                            <v-select class="vue-select2" v-model="selectedClass" label="name" @search="onClassSearch"
                                      :options="classlist">
                            </v-select>
                            <input type="hidden" name="class_id"
                                   v-model.number="(!selectedClass)?null:selectedClass.id">
                        </div>
                        <div class="col-md-6">
                            <label class="control-label ">@lang('layout.SaleArea') </label>
                            <v-select class="vue-select2" v-model="selectedArea" label="name" @search="onSaleAreaSearch"
                                      :options="saleArealist">
                            </v-select>
                            <input type="hidden" name="sale_area_id"
                                   v-model.number="(!selectedArea)?null:selectedArea.id">
                        </div>
                        <div class="col-md-2">
                            <div class="form-group">
                                <div class="col-md-12">
                                    <label class="control-label" >@lang('layout.Percentage')</label>
                                    <input type="checkbox" name="percent" value="on"  class="form-control">
                                </div>
                            </div>
                        </div>


                    </div>
                </div>

                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" name="from_date"
                                           autocomplete="off">

                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" name="to_date"
                                           autocomplete="off">

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </report-modal>
    </div>

    <div class="row">

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>&nbsp;
                    <span class="caption-subject bold uppercase">@lang('layout.NegativeSaleInvoiceList')</span>
                </div>
                <div class="tools"></div>
                <div class="pull-right">
					<a href="{{route('invoice.index')}}">
						<button class="btn btn-success">
							<i class="fa"></i> @lang('layout.Invoice')
						</button>
					</a>
                    @permission('invoice-export')
                    <span id="anchore-modal">
                        <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                            <i class="fa fa-print"></i>
                        </a>
                    </span>
                    @endpermission
                    @permission('invoice-create')
                    <a href="{{route('invoice.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
					
                <!-- <button class="btn btn-success" id="addNewRefundd">
                            <i class="icon-action-redo"></i> @lang('menu.Refund')
                        </button> -->
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">
                <template v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered table-hover" cellspacing="0" id="invoice">
                    <thead>
                    <tr>
                        <th>@lang('layout.InvoiceNumber')</th>
                        <th>@lang('layout.ReferenceNumber')</th>
                        <th>@lang('layout.CustomerName')</th>
                        <th>@lang('layout.Account')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.Currency')</th>
                        <th>@lang('layout.Amount')</th>
                        <th>@lang('layout.Discount')</th>
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>

                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>



    <!-- END TAB PORTLET-->

    <!-- END CONTENT BODY -->


    <!-- for factor begin -->

    <div id="factor-obj">

    </div>
    <iframe id="saleFrames" style="display: none;"></iframe>

    <!-- end for factor -->


@stop
@include('print.modal')
@include('groupCompanyFilter.select')
@push('scripts')

    <script>

        var settingAll = {!! getUserSetting() !!};
        @if(Session('sale_id') && getFactorPrint()== "automatic")
        factorPrint("{{Session('sale_id')}}")

        //GRN Print
        grnPrint("{{Session('sale_id')}}")

        @endif


        function factorPrint(id) {


            var a = document.createElement('a');
            a.href = "{{url('invoiceFactorPrint')}}/" + id;
            a.target = "_blank";
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);

                    // $.ajax({
                    //         // This PHP file will generate the PDF and save it to your server
                    //         // $pdf->Output('path/to/pdf/file.pdf', 'F');
                    //         url: "{{url('/')}}/invoiceFactorPrint/"+id,
                    //         type: 'get',
                    //         cache: false,

                    //     }).done(function () {

                    //         var s = ' <object  data="' + '{{url('factor22.pdf')}}' + '" type="application/pdf" width="0" height="0"> </object>'

                    //         $('#factor-obj').html(s);
                       

                    //         // $('#someDiv').html('<iframe src="path/to/pdf/file.pdf"></iframe>');
                    //     })
                    //         .fail(function () {
                    //             console.log("error");
                    //         });
        }       

         function grnPrint(id) {


            var a = document.createElement('a');
            a.href = "{{url('grnFactorPrint')}}/" + id;
            a.target = "_blank";
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);

                    // $.ajax({
                    //         // This PHP file will generate the PDF and save it to your server
                    //         // $pdf->Output('path/to/pdf/file.pdf', 'F');
                    //         url: "{{url('/')}}/invoiceFactorPrint/"+id,
                    //         type: 'get',
                    //         cache: false,

                    //     }).done(function () {

                    //         var s = ' <object  data="' + '{{url('factor22.pdf')}}' + '" type="application/pdf" width="0" height="0"> </object>'

                    //         $('#factor-obj').html(s);
                       

                    //         // $('#someDiv').html('<iframe src="path/to/pdf/file.pdf"></iframe>');
                    //     })
                    //         .fail(function () {
                    //             console.log("error");
                    //         });
        }

        let data_table;

        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';

            data_table = $('#invoice').DataTable({
                ajax: '{{route("invoice.index_active")}}',
                pageLength: '{{getPageRows()}}',
                scrollCollapse: true,
                order: [[4, "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
                    {data: 'number', name: 'sales.number'},
                    {data: 'ref_no', name: 'sales.ref_no'},
                    {data: 'member_name', name: 'members.name'},
                    {data: 'account_name', name: 'account_name', orderable: false, searchable: false},
                    {data: 'date', name: 'sales.date'},
                    {data: 'currency', name: 'currency', orderable: false, searchable: false},
                    {data: 'amount', name: 'amount', orderable: false, searchable: false},
                    {data: 'discount', name: 'discount', orderable: false, searchable: false},
                    {data: 'username', name: 'username', orderable: false, searchable: false},
                    {data: 'description', name: 'sales.description'},
                    {data: 'actions', name: 'account', orderable: false, searchable: false},
//              { data: 'measure_unit_id', name: 'quantity' },
//              { data: 'measure_unit', name: 'rate' },

                ]
            });
        });

        Vue.component('v-select', VueSelect.VueSelect);
        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    if (typeof data_table == 'object') {
                        data_table.clear();
                        data_table.ajax.reload();
                    }
                }
            }
        });


        var vm = new Vue({

            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',
                selectedMember: null,
                memberlist: [],
                classlist: [],
                selectedClass: null,
                saleArealist: [],
                selectedArea: null,
            },

            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show;
                },
                onClassSearch(search, loading) {
                    loading(true);
                    this.searchClass(search, loading, this);
                },
                onSaleAreaSearch(search, loading) {
                    loading(true);
                    this.searchSaleArea(search, loading, this);
                },
                //ajax call to get class
                searchClass(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            keyword: search,
                            table_name: 'member_classes',

                        }
                    })
                        .then(function (response) {
                            this.classlist = [];
                            if (response.data.length > 0) {
                                vm.classlist = response.data;
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        })
                },
                searchSaleArea(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            keyword: search,
                            table_name: 'sale_areas',

                        }
                    })
                        .then(function (response) {
                            this.classlist = [];
                            if (response.data.length > 0) {
                                vm.saleArealist = response.data;
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        })
                },
                //ajax call to get items
                onMemberSearch: _.debounce((search, loading) => {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'member',
                            type: 'Customer',
                            search: search,
                        }
                    })
                        .then(function (response) {
                            this.memberlist = [];
                            if (response.data.length > 0) {
                                vm.memberlist = response.data;
                                console.log('data', vm.memberlist);
                            }
                            loading(false);
                        })
                        .catch(function (error) {
                            console.log(error);
                        })

                }, getDebounceTime()),

            }
        });

        var anchor = new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;
                }
            }
        });
    </script>


@endpush
