@extends('layouts.app')
@section('style')
    <style>
        .hide_btn{
            display: none; 
        }
        .v-select .selected-tag{
            height: 26px !important;
            margin: 4px 1px 0 3px !important;
        }
        .v-select .selected-tag > button >span{
            display: none !important;
        }
    </style>
@endsection
@section('content')
    <!-- BEGIN CONTENT -->
    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="selectedType" @closed="closeModal"> 
            <div slot="body">
                <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->
                <div class="row" v-cloak>
                        <div class="tabbable tabbable-tabdrop">
                            <ul class="nav nav-tabs">  
                                <li class="active">
                                    <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                                </li>
                               @if(systemConfig()[2] != 0 )
                                        @permission(['customreport-list'])
                                <li class="">
                                    <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                                </li>
                                @endpermission
                                @endif
                            </ul>
                            <div class="tab-content">
                                <div class="tab-pane active" id="tab1"> 
                                    <div class="portlet light bordered">
                                        <div class="row">
                                            <div class="form-group">
                                                <div class="col-md-6">
                                                    <label class="control-label ">@lang('layout.SelectMember') </label>
                                                    <v-select class="vue-select2" v-model="selectedMember" label="name" @search="onMemberSearch"
                                                                :options="memberlist">
                                                    </v-select>
                                                    <input type="hidden" name="member_id"
                                                            v-model.number="(!selectedMember)?null:selectedMember.id">
                                                </div>
                                                <div class="col-md-6">
                                                    <label class="control-label ">@lang('layout.MemberClass') </label>
                                                    <v-select class="vue-select2" v-model="selectedClass" label="name" @search="onClassSearch"
                                                                :options="classlist">
                                                    </v-select>
                                                    <input type="hidden" name="class_id"
                                                            v-model.number="(!selectedClass)?null:selectedClass.id">
                                                </div>
                                                <div class="col-md-3">
                                                    <label class="control-label ">@lang('layout.SaleArea') </label>
                                                    <v-select class="vue-select2" v-model="selectedArea" label="name" @search="onSaleAreaSearch"
                                                                :options="saleArealist">
                                                    </v-select>
                                                    <input type="hidden" name="sale_area_id"
                                                            v-model.number="(!selectedArea)?null:selectedArea.id">
                                                </div>
                                                <div class="col-md-3">
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <div class="col-md-12">
                                                                <label class="control-label" >@lang('layout.Percentage')</label>
                                                                <input type="checkbox" name="percent" value="on"  class="form-control">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    @if(getFactorPending() == 'true')
                                                    <div class="col-md-6">
                                                        <div class="form-group">
                                                            <div class="col-md-12">
                                                                <label class="control-label" >@lang('layout.Factor') @lang('layout.Pending')</label>
                                                                <input type="checkbox" name="pending" value="on"  class="form-control">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    @endif
                                                </div>
                                                <div class="col-md-3">
                                                    <label class="control-label ">@lang('layout.SelectType') </label>
                                                    <select v-model="selectedType" class="form-control">
                                                        <option value="invoicelist">@lang('layout.Simple')</option>
                                                        <option value="GeneralSaleReportCustomer">@lang('layout.Details')</option>
                                                    </select>
                                                </div>
                                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                    <div class="form-group">
                                                        <div class="">
                                                            <label class="control-label">@lang('layout.Forgivness')</label>
                                                            <select name="forgivness" id="" class="form-control form-select" v-model="forgivness">
                                                                <option selected value="">@lang('layout.Select')</option>
                                                                <option value="forgivness">@lang('layout.Forgivness')</option>
                                                                <option value="withoutForgivness">@lang('layout.WithoutForgivness')</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-4">
                                                <label class="control-label ">@lang('layout.SelectSite') </label>
                                                <v-select class="vue-select2" v-model="selectedInventorySite" label="name" :options="InventorySite">
                                                </v-select>
                                                <input type="hidden" name="inventory_id" v-model.number="(!selectedInventorySite)?null:selectedInventorySite.id">
                                            </div>
                                        </div>

                                        <div class="row">
                                        <div class="form-group">
                                            <div class="col-md-4">
                                                <label class="control-label ">@lang('layout.Date')</label>
                                                    <select name="period" v-model="period" @input="getDates()" class="form-control">
                                                    <option value="CustomDates">@lang('type.CustomDates')</option>
                                                    <option value="Today">@lang('type.Today')</option>
                                                    <option value="Yesterday">@lang('type.Yesterday')</option>
                                                    <option value="ThisWeek">@lang('type.ThisWeek')</option>
                                                    <option value="LastWeek">@lang('type.LastWeek')</option>
                                                    <option value="WeekToDate">@lang('type.WeekToDate')</option>
                                                    <option value="ThisMonth">@lang('type.ThisMonth')</option>
                                                    <option value="MonthToDate">@lang('type.MonthToDate')</option>
                                                    <option value="ThisQuarter">@lang('type.ThisQuarter')</option>
                                                    <option value="QuarterToDate">@lang('type.QuarterToDate')</option>
                                                    <option value="ThisYear">@lang('type.ThisYear')</option>
                                                    <option value="YearToDate">@lang('type.YearToDate')</option>
                                                </select>
                                            </div>
                                            <div class="col-md-8" v-show="period == 'CustomDates'">
                                                <div class="form-group">
                                                    <label class="control-label"> @lang('layout.Date')</label>
                                                    <div class="input-group">
                                                        <input class="form-control date" id="range-from-example" v-model="from_date" name="from_date" autocomplete="off">
                                                        <span class="input-group-addon"> @lang('layout.To') </span>
                                                        <input class="form-control date" id="range-to-example" v-model="to_date" name="to_date" autocomplete="off">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        </div>
                                    </div>
                                </div> 

                                <div class="tab-pane" id="tab2"> 
                                    <div class="portlet light bordered">
                                        <div class="portlet-body"> 
                                            <form  id="saveCustomeReport" role="form" action="{{route('customeReport.storeCustomeReport')}}" method="post" >
                                                @csrf
                                                <input type="hidden" name="part_name" value="invoice_index"> 
                                                <div class="col-md-12 col-sm-12 col-xs-12">
                                                    <div class="mt-checkbox-inline col-md-2" style="padding: 0px;" v-for="(row,itemIndex) in customReportData">
                                                        <div class="form-group">
                                                            <table class="table table-striped table-bordered table-advance table-hover">
                                                                <tr>
                                                                    <td style="text-align: center;">@{{ row.Name }}</td>
                                                                </tr>
                                                                <tr>
                                                                    <td style="text-align: center;">
                                                                        <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
                                                                        <label class="switch">
                                                                            <input type="checkbox" :name="'column_status['+itemIndex+']'" :checked="row.checkedColumn" >
                                                                            <span class="slider round"></span>
                                                                        </label>
                                                                        <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                            <option value="">@lang('layout.Select')</option>
                                                                            <option value="2">2 %</option>
                                                                            <option value="6">6 %</option>
                                                                            <option value="10">10 %</option>
                                                                            <option value="15">15 %</option>
                                                                            <option value="20">20 %</option>
                                                                            <option value="25">25 %</option>
                                                                            <option value="30">30 %</option>
                                                                            <option value="40">40 %</option>
                                                                            <option value="50">50 %</option>
                                                                            <option value="60">60 %</option>
                                                                        </select>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                            <!-- <label> @{{ row.Name }}</label>
                                                            <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
                                                            <label class="switch">
                                                                <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                :checked="row.checkedColumn" >
                                                                <span class="slider round"></span>
                                                            </label> -->
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="margiv-top-10">
                                                    <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->
                                                    <button type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i class="fa fa-save"></i> </button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                        </div>
                    </div>
                </div>
                <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->
            </div>
        </report-modal>
    </div>
    <div id="multi_invoice_modal" v-cloak>
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'multi_factor'" @closed="closeModal"> 
            <div slot="body">
                 <input type="hidden" name="id" value=""/>
                 <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="control-label ">@lang('layout.Currency') </label>
                            <v-select class="vue-select2" v-model="selected_currency" label="code"  :options="currency_list" >
                            </v-select>
                            <input type="hidden" name="currency" :value="!selected_currency?null:selected_currency.code" >
                        </div>
                    </div>
                    <div class="col-md-6">
                        <label class="control-label ">@lang('layout.SelectMember') </label>
                        <v-select class="vue-select2" v-model="selected_member" label="name" @search="onMemberSearchInvoice" @input="selectInvoices()"
                                  :options="member_list">
                        </v-select>
                        <input type="hidden" name="member_id"
                               v-model.number="(!selected_member)?null:selected_member.id">
                    </div>
                </div>                 
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="control-label ">@lang('layout.Invoice') </label>
                            <v-select class="vue-select2" v-model="selected_invoice" label="invoice_number"  :options="invoice_list" :multiple="true">
                            </v-select>
                            <input type="hidden" name="invoice_id" :value="invoice_id.length > 0 ? invoice_id:null">
                        </div>
                    </div>
                </div>
                <span class="badge badge-default" style="color: #ffffff; background-color: #f90000; font-size: 15px !important;height:25px">@lang('message.MultipleInvoicePrint')</span>

                {{-- <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" name="from_date"
                                           autocomplete="off">
    
                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" name="to_date"
                                           autocomplete="off">
    
                                </div>
                            </div>
                        </div>
                    </div>
                </div> --}}
    
            </div>
        </report-modal>
    </div>    
    <div id="multi_washing_modal" v-cloak>
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'multi_washing_form'" @closed="closeModal">
    
            <div slot="body">
                 <input type="hidden" name="id" value=""/>
    
                 <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="control-label ">@lang('layout.Currency') </label>
                            <v-select class="vue-select2" v-model="selected_currency" label="code"  :options="currency_list" >
                            </v-select>
                            <input type="hidden" name="currency" :value="!selected_currency?null:selected_currency.code" >
                        </div>
                    </div>
                    <div class="col-md-6">
                        <label class="control-label ">@lang('layout.SelectMember') </label>
                        <v-select class="vue-select2" v-model="selected_member" label="name" @search="onMemberSearchInvoice" @input="selectInvoices()"
                                  :options="member_list">
                        </v-select>
                        <input type="hidden" name="member_id"
                               v-model.number="(!selected_member)?null:selected_member.id">
                    </div>
                </div>                 
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label class="control-label ">@lang('layout.Invoice') </label>
                            <v-select class="vue-select2" v-model="selected_invoice" label="invoice_number"  :options="invoice_list" :multiple="true">
                            </v-select>
                            <input type="hidden" name="invoice_id" :value="invoice_id.length > 0 ? invoice_id:null">
                        </div>
                    </div>
                </div>
                <span class="badge badge-default" style="color: #ffffff; background-color: #f90000; font-size: 15px !important;height:25px">@lang('message.MultipleInvoicePrint')</span>

                {{-- <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" name="from_date"
                                           autocomplete="off">
    
                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" name="to_date"
                                           autocomplete="off">
    
                                </div>
                            </div>
                        </div>
                    </div>
                </div> --}}
    
            </div>
        </report-modal>
    </div>
    <div id="multi_driver_modal" v-cloak>
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show" :value-type="'multi_driver'" @closed="closeModal">
    
            <div slot="body">

                  <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->
                <div class="row" v-cloak>
                    <div class="tabbable tabbable-tabdrop">

                       <ul class="nav nav-tabs">
                           
                           <li class="active">
                               <a href="#tab1" data-toggle="tab" id="tab_main">@lang('menu.Report')</a>
                           </li>
                          @if(systemConfig()[2] != 0 )
                                   @permission(['customreport-list'])
                           <li class="">
                               <a href="#tab2" data-toggle="tab" id="tab_custome">@lang('layout.CustomReportM')</a>
                           </li>
                           @endpermission
                           @endif
                       </ul>
                       <div class="tab-content">
                            <div class="tab-pane active" id="tab1"> 
                                   <div class="portlet light bordered">
                                    <input type="hidden" name="id" value=""/>
    
                                    <div class="row">
                                       <div class="col-md-6">
                                           <label class="control-label ">@lang('layout.SelectMember')</label>
                                           <v-select class="vue-select2" v-model="selected_member" label="name" :options="member_list" @search="onMemberSearchInvoice">
                                           </v-select>
                                           <input type="hidden" name="member_id"
                                                  v-model.number="(!selected_member)?null:selected_member.id">
                                       </div>
                                   </div>         
                   
                                   <div class="row">
                                       <div class="form-group">
                                           <div class="col-md-12">
                                               <div class="form-group">
                                                   <label class="control-label"> @lang('layout.Date')</label>
                                                   <div class="input-group">
                                                       <input class="form-control date" id="range-from-example" name="from_date"
                                                              autocomplete="off">
                       
                                                       <span class="input-group-addon"> @lang('layout.To') </span>
                                                       <input class="form-control date" id="range-to-example" name="to_date"
                                                              autocomplete="off">
                       
                                                   </div>
                                               </div>
                                           </div>
                                       </div>
                                   </div>
                                   </div>
                           </div> 

                           <div class="tab-pane" id="tab2"> 
                              <div class="portlet light bordered">
                                   <div class="portlet-body">

                                       <form  id="saveCustomeReport" role="form" action="{{route('customeReport.storeCustomeReport')}}" method="post" >
                                           @csrf
                                           <input type="hidden" name="part_name" value="driver_or_transfer">


                                           <div class="col-md-12 col-sm-12 col-xs-12">

                                               <div class="mt-checkbox-inline col-md-2" style="padding: 0px;" v-for="(row,itemIndex) in customReportData">

                                                   <div class="form-group">
                                                   <table class="table table-striped table-bordered table-advance table-hover">
                                                               <tr>
                                                                   <td style="text-align: center;">@{{ row.Name }}</td>
                                                               </tr>
                                                               <tr>
                                                                   <td style="text-align: center;">
                                                                       <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">


                                                                       <label class="switch">
                                                                           <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                                           :checked="row.checkedColumn" >
                                                                           <span class="slider round"></span>
                                                                       </label>
                                                                       <select :name="'column_percentage['+itemIndex+']'" v-model="row.column_percentage" class="form-control" style="width: 90%;">
                                                                        <option value="">@lang('layout.Select')</option>
                                                                        <option value="2">2 %</option>
                                                                        <option value="6">6 %</option>
                                                                        <option value="10">10 %</option>
                                                                        <option value="15">15 %</option>
                                                                        <option value="20">20 %</option>
                                                                        <option value="25">25 %</option>
                                                                        <option value="30">30 %</option>
                                                                        <option value="40">40 %</option>
                                                                        <option value="50">50 %</option>
                                                                        <option value="60">60 %</option>
                                                                    </select>
                                                                   </td>
                                                               </tr>
                                                           </table>
                                                   </div>
                                               </div>
                                           </div>
                                           <div class="margiv-top-10">
                                               <!-- <button type="button" onclick="regForm(this)" class="btn green"> <i class="fa fa-save"></i> </button> -->

                                               <button type="button" onclick="saveCustomeReport(this)" class="btn blue"> <i class="fa fa-save"></i> </button>
                                           </div>
                                   </form>
                                   </div>
                           </div>
                   </div>
                   </div>
               </div>
           </div>
           <!----------------------------------------------
           ----Begin Report Body And Custome Report-------
           ----------------------------------------------->
            </div>
        </report-modal>
    </div> 
    {{-- custom part start  --}}
    <div id="settingModal" v-cloak>
        <setting-modal :pdf-route="route" v-if="is_show" :value-type="'invoice'" @closed="closeModal">
            <div slot="header" class="text-center">
                <h4 style="font-weight: bold;">@lang('layout.CustomForms')</h4>
            </div>
            <div slot="body">
                <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->
                <div class="row" v-cloak>
                    <div class="col-md-12 col-sm-12 col-xs-12">
                        <div class="mt-checkbox-inline col-md-2" style="padding: 0px;margin-bottom: 10px;" v-for="(row,itemIndex) in customReportData">
                            <div class="form-group">
                                <table class="table table-striped table-bordered table-advance">
                                    <tr style="background-color: rgba(227, 227, 227, 0.757)">
                                        <th style="text-align: center;">@{{ row.Name }}</th>
                                    </tr>
                                    <tr>
                                        <td style="text-align: center;">
                                            <input type="hidden" :name="'column_name['+itemIndex+']'" class="form-control" v-model="row.column_name">
                                            <label class="switch">
                                                <input type="checkbox" :name="'column_status['+itemIndex+']'" 
                                                :checked="row.checkedColumn" >
                                                <span class="slider round"></span>
                                            </label>
                                        </td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <!----------------------------------------------
                ----Begin Report Body And Custome Report-------
                ----------------------------------------------->
            </div>
        </setting-modal>
    </div>
    {{-- custom part end  --}}
    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="col-md-2 col-sm-2">
                <span class="caption-subject bold uppercase" style="font-size: 20px;">@lang('layout.InvoiceList')</span>
            </div>
            <div class="col-md-4 col-sm-6" id="date_part">
                <div class="form-group">
                    <div class="input-group">
                        <input name="from_date" class="form-control date" ref="from_date" placeholder="@lang('layout.FromDate')" autocomplete="off" />
                        <span class="input-group-addon"> @lang('layout.To') </span>
                        <input name="to_date" class="form-control date" ref="to_date" placeholder="@lang('layout.ToDate')" autocomplete="off" />
                        <span class="input-group-addon btn"  @Click="getData()" > @lang('layout.Search') </span>
                    </div>
                </div>
            </div>
            <div class="col-md-2 col-sm-4" id="date_parttwo">
                <div class="form-group">
                {{Form::open(['route' => 'invoice.changeFactor','method' => 'POST','class' => 'form-horizontal', 'id'=>'invoice-form'])}}
                {{ csrf_field() }}
                    <div class="form-group  hidden-print">
                        <div class="input-group"> 
                            <input name="part_number" class="form-control" ref="part_number" placeholder="@lang('layout.DeActiveOldsFactor')"  type="number" />
                            <span class="input-group-addon btn" style="padding: 0px;" > <button type="button" @click="submitFormDatePart($event)" style="padding: 0px 8px; color:red;" > @lang('layout.Disable') </button> </span>
                        </div>
                    </div>  
                {!! Form::close() !!}
                </div>
            </div>   
            <div class="portlet-title">
                <div class="caption font-dark">
                </div>
                <div class="tools">
                </div>
                <div class="page-toolbar">
                <div class="pull-right">
                    <span id="setting-modal">
                        <button type="submit" @click.prevent="showModal" class="btn" style="background-color: rgb(80, 129, 141);color: white;">
                            <i class="fa fa-wrench"></i>
                        </button>
                    </span>
                    @if(getFactorPending() == 'true')
                    <a href="{{route('invoice.index_pending')}}">
						<button class="btn btn-success">
                            <i class="fa"></i> @lang('layout.Factor') @lang('layout.Pending')
                        </button>
                    </a>
                    @endif
					@if(getNegativeSale() == 'true')
					<a href="{{route('invoice.index_na')}}">
						<button class="btn btn-success">
                            <i class="fa"></i> @lang('layout.ShowNegativeSale')
                            @if ($nagativeInvoice > 0)
                            <span class="badge badge-default" style="color: #ffffff; background-color: #f90000; font-size: 15px !important;"> {{$nagativeInvoice}} </span>
                            @endif
                        </button>
                    </a>
					@endif
                    @permission('invoice-export')
                    <span id="anchore-modal">
                     <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                        <i class="fa fa-print"></i>
                     </a>
                    </span>
                    @endpermission
                   

                    @permission('invoice-create')
                    <a href="{{route('invoice.create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    <a href="{{route('invoice.createMultiple')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.createMultiple')
                        </button>
                    </a>
                    @if(ShowCreateToCustomer() == 'true')
                    <a href="{{route('invoice.show_create')}}">
                        <button class="btn btn-success">
                            <i class="fa fa-search"></i> @lang('layout.ShowCreate')
                        </button>
                    </a>
					@endif
                    <!-- <button class="btn btn-success" id="addNewRefundd">
                            <i class="icon-action-redo"></i> @lang('menu.Refund')
                        </button> -->
                    @endpermission
                </div>

                <div class="btn-group pull-right">
                    <button type="button" class="btn green  dropdown-toggle" data-toggle="dropdown"> @lang('layout.More')
                        <i class="fa fa-angle-down"></i>
                    </button>
                    <ul class="dropdown-menu pull-right" role="menu">
                        <li>
                            @if(getActiveSale()=="true")
                            <span>
                                <a href="{{route('invoice.index_active')}}" class="btn  btn-success btn-block" >
                                    @lang('layout.ActiveSale')
                                </a>
                            </span>
                            @endif
                        </li>
                        <li>
                            @if(systemConfig()[21] == 1)
                            <span id="multi_wash_modal">
                                <a href="#" @click.prevent="showModal" id="" class="btn  btn-success btn-block">
                                    <i class="fa fa-print"></i> @lang('layout.WashingForm')
                                </a>
                            </span>
                            @endif
                        </li>
                        <li>
                            @permission('invoice-export')
                            <span id="multi_in_modal">
                                <a href="#" @click.prevent="showModal" id="" class="btn  btn-success btn-block">
                                    <i class="fa fa-print"></i> @lang('layout.PrintMultipleInvoice')
                                </a>
                            </span>
                            <span id="multi_driv_modal">
                                <a href="#" @click.prevent="showModal" id="" class="btn  btn-success btn-block">
                                    <i class="fa fa-print"></i> @lang('layout.DriverAndLoadReport')
                                </a>
                            </span>
                            @endpermission
                        </li>
                    </ul>
                </div>

                </div>
            </div>
            @if(getNegativeSale() == 'true')
            @if ($nagativeInvoice > 0)
            <span class="caption-subject bold uppercase " style="color: red;">@lang('message.NegativeSaleMessage')</span>
            @endif
            @endif
            <div class="portlet-body">
                <template v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered table-hover" cellspacing="0" id="invoice">
                    <thead>
                        <tr>
                            <th>@lang('layout.InvoiceNumber')</th>
                            @if(getCustomeForm('invoice','referenceNumber'))
                            <th>@lang('layout.ReferenceNumber')</th>
                            @endif
                            <th>@lang('layout.CustomerName')</th>
                            <th >@lang('layout.Account')</th>
                            @if(showVendorInFactor() == 'true')
                            <th >@lang('layout.Vendor')</th>
                            @endif
                            @if(getCustomeForm('invoice','date'))
                            <th>@lang('layout.Date')</th>
                            @endif
                            @if(getCustomeForm('invoice','hour'))
                            <th>@lang('layout.Hour')</th>
                            @endif
                            <th>@lang('layout.Currency')</th>
                            <th>@lang('layout.Amount')</th>
                            <th>@lang('layout.Discount')</th>
                            @if(getCustomeForm('invoice','status'))
                            @if(getFactorPending() == 'true')
                            <th>@lang('layout.Status')</th>
                            @endif
                            @endif
                            @if(getCustomeForm('invoice','pumpNumber'))
                            @if(systemConfig()[27] == 1)
                            <th>@lang('layout.PumpNumber')</th>
                            @endif
                            @endif
                            @if(getCustomeForm('invoice','user'))
                            <th>@lang('layout.User')</th>
                            @endif
                            @if(getCustomeForm('invoice','description'))
                            <th>@lang('layout.Description')</th>
                            @endif
                            <th>@lang('layout.Actions')</th>
                        </tr>
                    </thead>
                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>
    <!-- END TAB PORTLET-->
    <!-- END CONTENT BODY -->
    <!-- for factor begin -->
    <div id="factor-obj">
    </div>
    <iframe id="saleFrames" style="display: none;"></iframe>
    <!-- end for factor -->
@stop
@include('print.modal')
@include('layouts.setting_model')
@include('groupCompanyFilter.select')
@push('scripts')
    <script>
        function voucherOffering(id) {
           // console.log(234, type);
           var a = document.createElement('a');
           a.href = "{{url('invoiceVoucherOffering')}}/" + id;
           a.target = "_blank";
           document.body.appendChild(a);
           a.click();
           document.body.removeChild(a);
        }
        var cust_rep = {!!customeReportNewData('invoice_index')!!};
        var cust_rep_driver = {!!customeReportNewData('driver_or_transfer')!!};
        var settingAll = {!! getUserSetting() !!};
        var currency_list = {!! $currency_list !!};
        @if(Session('sale_id') && getFactorPrint()== "automatic")
        factorPrint("{{Session('sale_id')}}", "{{Session('whatsapp')}}")
        //GRN Print
        // grnPrint("{{Session('sale_id')}}")
        @endif
        function factorPrint(id,sendWhatsapp = null,type = null) {
            if (sendWhatsapp == null || sendWhatsapp == '') {
                sendWhatsapp = 'not';
            }
            var a = document.createElement('a');
            a.href = "{{url('invoiceFactorPrint')}}/" + id + "/" + sendWhatsapp + "/" + type;
            a.target = "_self";
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
            // $.ajax({
            //         // This PHP file will generate the PDF and save it to your server
            //         // $pdf->Output('path/to/pdf/file.pdf', 'F');
            //         url: "{{url('/')}}/invoiceFactorPrint/"+id,
            //         type: 'get',
            //         cache: false,
            //     }).done(function () {
            //         var s = ' <object  data="' + '{{url('factor22.pdf')}}' + '" type="application/pdf" width="0" height="0"> </object>'
            //         $('#factor-obj').html(s);
            //         // $('#someDiv').html('<iframe src="path/to/pdf/file.pdf"></iframe>');
            //     })
            //         .fail(function () {
            //             console.log("error");
            //     });
        } 
        function factorMultiPrint(number = 0) {
            var a = document.createElement('a');
            a.href = "{{url('invoiceMultipleCurrencyFactor')}}/" + number;
            a.target = "_blank";
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
        } 
        function grnMultiPrintAll(number = 0) { 
            var a = document.createElement('a');
            a.href = "{{url('invoiceMultipleCurrencyGrnAll')}}/" + number;
            a.target = "_blank";
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
        } 
        function sendVoucherToWhatsapp(id,sendWhatsapp) {
            if (id && sendWhatsapp) {
                axios.get("{{url('invoiceFactorPrint')}}/" + id + "/1", {
                    // params: {
                        // method_name: 'SearchMember',
                        // class_id: class_id
                    // }
                })
                .then(function(response) {
                    // console.log(response);
                    if (response.data) {
                        if (sendWhatsapp == 1) {
                            var a = document.createElement('a');
                            a.href = "https://wa.me/?text=" + response.data;
                            a.target = "_blank";
                            document.body.appendChild(a);
                            a.click();
                            document.body.removeChild(a);
                        }
                        if (sendWhatsapp == 2) {
                            var a = document.createElement('a');
                            a.href = "https://telegram.me/share/url?url=Hi&text=" + response.data;
                            a.target = "_blank";
                            document.body.appendChild(a);
                            a.click();
                            document.body.removeChild(a);
                        }
                    }
                })
                .catch(function(error) {
                    console.log(error);
                })
            }
        }
        function washingFormPrint(id) {
            var a = document.createElement('a');
            a.href = "{{url('washingFormPrint')}}/" + id;
            a.target = "_blank";
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
        }  
        //To Hide Extra Actions In Index Page 
        // function showHideElements() {
        //      var x = document.getElementsByClassName('hide_btn');
        //       for (var i = 0; i < x.length; i++) {
        //          if (x[i].style.display == "none") {
        //                 x[i].style.display = "block";
        //          }
        //          else if(x[i].style.display == "block")
        //          {
        //             x[i].style.display = "none"
        //          }  
        //          else
        //          {
        //             x[i].style.display = "block"
        //          }     
        //     }
        // }     
        function grnPrint(id,type = null) {
            var a = document.createElement('a');
            console.log('sssLala',a,id,type)
            a.href = "{{url('grnFactorPrint')}}/" + id + "/" + type;
            a.target = "_blank";
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
            // $.ajax({
            //         // This PHP file will generate the PDF and save it to your server
            //         // $pdf->Output('path/to/pdf/file.pdf', 'F');
            //         url: "{{url('/')}}/invoiceFactorPrint/"+id,
            //         type: 'get',
            //         cache: false,
            //     }).done(function () {
            //         var s = ' <object  data="' + '{{url('factor22.pdf')}}' + '" type="application/pdf" width="0" height="0"> </object>'
            //         $('#factor-obj').html(s);
            //         // $('#someDiv').html('<iframe src="path/to/pdf/file.pdf"></iframe>');
            //     })
            //         .fail(function () {
            //             console.log("error");
            //         });
        }
		function factorPrintGift(id) {
            var a = document.createElement('a');
            a.href = "{{url('giftFactorPrint')}}/" + id;
            a.target = "_blank";
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
        }
        let data_table;
        function getRecord() {
            // console.log(234, vtr.from_date, vtr.to_date);
            data_table = $('#invoice').DataTable({
                ajax: {
                    ajax: '{{route("invoice.index")}}',
                    data: {
                        from_date: vtr.from_date,
                        to_date: vtr.to_date
                    }
                },
                pageLength: '{{getPageRows()}}',
                scrollCollapse: true,
                order: [["{{orderByColumn()=='number'?0:4}}", "{{getRowOrder()}}"]],
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                serverSide: true,
                paging: true,
                destroy: true,
                buttons: [{
                    extend: 'excel',
                    text: '',
                    key: {
                        key: 'x',
                        altkey: true
                    }
                }],
                columns: [
                    {data: 'number', name: 'sales.number'},
                    @if(getCustomeForm('invoice','referenceNumber'))
                    {data: 'ref_no', name: 'sales.ref_no'},
                    @endif
                    {data: 'member_name', name: 'member_name'},
                    {data: 'account_name', name: 'accounts.name'},
                    @if(showVendorInFactor() == 'true')
                    {data: 'vendor', name: 'sales.vendor'},
                    @endif
                    @if(getCustomeForm('invoice','date'))
                    {data: 'date', name: 'sales.date', searchable: false},
                    @endif
                    @if(getCustomeForm('invoice','hour'))
                    {data: 'hour', name: 'invoice.hour', searchable: false},
                    @endif
                    {data: 'currency', name: 'transactions.unit'},
                    {data: 'amount', name: 'transactions.amount'},
                    {data: 'discount', name: 'discount'},
                    @if(getCustomeForm('invoice','status'))
                    @if(getFactorPending() == 'true')
                    {data: 'status', name: 'status', orderable: false, searchable: false},
                    @endif
                    @endif
                    @if(getCustomeForm('invoice','pumpNumber'))
                    @if(systemConfig()[27] == 1)
                    {data: 'pump_number', name: 'oil_parts.number'},
                    @endif
                    @endif
                    @if(getCustomeForm('invoice','user'))
                    {data: 'username', name: 'username', orderable: false, searchable: false},
                    @endif
                    @if(getCustomeForm('invoice','description'))
                    {data: 'description', name: 'sales.description'  @if(getGeneralSearch()) , searchable: false @endif},
                    @endif
                    {data: 'actions', name: 'account', orderable: false, searchable: false},
                    //              { data: 'measure_unit_id', name: 'quantity' },
                    //              { data: 'measure_unit', name: 'rate' },
                ]
            });
        }
        $(document).ready(function() {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            getRecord();

        });
        Vue.component('v-select', VueSelect.VueSelect);
        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    if (typeof data_table == 'object') {
                        data_table.clear();
                        data_table.ajax.reload();
                    }
                }
            }
        });
        var inventorySite = {!! $inventorySite !!};
        var vm = new Vue({
            el: '#print-modal',
            data: {
                forgivness: '',
                period: 'CustomDates',
                from_date: null,
                to_date: null,
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',
                selectedMember: null,
                memberlist: [],
                classlist: [],
                selectedClass: null,
                saleArealist: [],
                selectedInventorySite: null,
                InventorySite: inventorySite,
                selectedArea: null,
                selectedType: 'invoicelist',
                customReportData:
                [
                 {Name: '@lang("layout.Record")', column_name: 'record',checkedColumn:(cust_rep.record)?'checked':'',column_percentage:(cust_rep.record___percent)?cust_rep.record___percent:''},
                 {Name: '@lang("layout.ReferenceNumber")', column_name: 'reference_number',checkedColumn:(cust_rep.reference_number)?'checked':'',column_percentage:(cust_rep.reference_number___percent)?cust_rep.reference_number___percent:''},
                 {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_rep.description)?'checked':'',column_percentage:(cust_rep.description___percent)?cust_rep.description___percent:''},
                 {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_rep.date)?'checked':'',column_percentage:(cust_rep.date___percent)?cust_rep.date___percent:''},
                 {Name: '@lang("layout.Hour")', column_name: 'hour',checkedColumn:(cust_rep.hour)?'checked':'',column_percentage:(cust_rep.hour___percent)?cust_rep.hour___percent:''},
                 {Name: '@lang("layout.InvoiceNumber")', column_name: 'invoice_number',checkedColumn:(cust_rep.invoice_number)?'checked':'',column_percentage:(cust_rep.invoice_number___percent)?cust_rep.invoice_number___percent:''},
                 {Name: '@lang("layout.Customer")', column_name: 'customer',checkedColumn:(cust_rep.customer)?'checked':'',column_percentage:(cust_rep.customer___percent)?cust_rep.customer___percent:''},
                 {Name: '@lang("layout.Code")', column_name: 'code',checkedColumn:(cust_rep.code)?'checked':'',column_percentage:(cust_rep.code___percent)?cust_rep.code___percent:''},
                 {Name: '@lang("layout.Forgivness")', column_name: 'forgivness',checkedColumn:(cust_rep.forgivness)?'checked':'',column_percentage:(cust_rep.forgivness___percent)?cust_rep.forgivness___percent:''},
                 {Name: '@lang("layout.AccountName")', column_name: 'account_name',checkedColumn:(cust_rep.account_name)?'checked':'',column_percentage:(cust_rep.account_name___percent)?cust_rep.account_name___percent:''},
                 {Name: '@lang("layout.Amount")', column_name: 'amount',checkedColumn:(cust_rep.amount)?'checked':'',column_percentage:(cust_rep.amount___percent)?cust_rep.amount___percent:''},
                 {Name: '@lang("layout.Unit")', column_name: 'unit',checkedColumn:(cust_rep.unit)?'checked':'',column_percentage:(cust_rep.unit___percent)?cust_rep.unit___percent:''},
                 {Name: '@lang("layout.Rate")', column_name: 'rate',checkedColumn:(cust_rep.rate)?'checked':'',column_percentage:(cust_rep.rate___percent)?cust_rep.rate___percent:''},
                 {Name: '@lang("layout.DiscountType")', column_name: 'discount_type',checkedColumn:(cust_rep.discount_type)?'checked':'',column_percentage:(cust_rep.discount_type___percent)?cust_rep.discount_type___percent:''},
                 {Name: '@lang("layout.Discount")', column_name: 'discount',checkedColumn:(cust_rep.discount)?'checked':'',column_percentage:(cust_rep.discount___percent)?cust_rep.discount___percent:''},
                 {Name: '@lang("layout.Total")', column_name: 'total',checkedColumn:(cust_rep.total)?'checked':'',column_percentage:(cust_rep.total___percent)?cust_rep.total___percent:''},
                 {Name: '@lang("layout.TotalCostOfSale")', column_name: 'totalCostOfSale',checkedColumn:(cust_rep.totalCostOfSale)?'checked':'',column_percentage:(cust_rep.totalCostOfSale___percent)?cust_rep.totalCostOfSale___percent:''},
                 {Name: '@lang("layout.Expense")', column_name: 'expense',checkedColumn:(cust_rep.expense)?'checked':'',column_percentage:(cust_rep.expense___percent)?cust_rep.expense___percent:''},
                 {Name: '@lang("layout.GrossProfitORLost")', column_name: 'grossProfitORLost',checkedColumn:(cust_rep.grossProfitORLost)?'checked':'',column_percentage:(cust_rep.grossProfitORLost___percent)?cust_rep.grossProfitORLost___percent:''},
                 @if(systemConfig()[27] == 1)
                 {Name: '@lang("layout.OldCounter")', column_name: 'old_counter',checkedColumn:(cust_rep.old_counter)?'checked':'',column_percentage:(cust_rep.old_counter___percent)?cust_rep.old_counter___percent:''},
                 {Name: '@lang("layout.NewCounter")', column_name: 'new_counter',checkedColumn:(cust_rep.new_counter)?'checked':'',column_percentage:(cust_rep.new_counter___percent)?cust_rep.new_counter___percent:''},
                 @endif
                 {Name: '@lang("layout.User")', column_name: 'user',checkedColumn:(cust_rep.user)?'checked':'',column_percentage:(cust_rep.user___percent)?cust_rep.user___percent:''},
                 {Name: '@lang("menu.TransportCompany")', column_name: 'transportCompany',checkedColumn:(cust_rep.transportCompany)?'checked':'',column_percentage:(cust_rep.transportCompany___percent)?cust_rep.transportCompany___percent:''},
                 {Name: '@lang("layout.Driver")', column_name: 'driver',checkedColumn:(cust_rep.driver)?'checked':'',column_percentage:(cust_rep.driver___percent)?cust_rep.driver___percent:''},
                ],
                cust_rep:cust_rep
            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show;
                },
                onClassSearch(search, loading) {
                    loading(true);
                    this.searchClass(search, loading, this);
                },
                onSaleAreaSearch(search, loading) {
                    loading(true);
                    this.searchSaleArea(search, loading, this);
                },
                //ajax call to get class
                searchClass(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            keyword: search,
                            table_name: 'member_classes',

                        }
                    })
                    .then(function (response) {
                        this.classlist = [];
                        if (response.data.length > 0) {
                            vm.classlist = response.data;
                        }
                        loading(false);
                    })
                    .catch(function (error) {
                        console.log(error);
                    })
                },
                searchSaleArea(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'anyTable',
                            keyword: search,
                            table_name: 'sale_areas',
                        }
                    })
                    .then(function (response) {
                        this.classlist = [];
                        if (response.data.length > 0) {
                            vm.saleArealist = response.data;
                        }
                        loading(false);
                    })
                    .catch(function (error) {
                        console.log(error);
                    })
                },
                //ajax call to get items
                onMemberSearch: _.debounce((search, loading) => {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'member',
                            type: 'Customer',
                            search: search,
                        }
                    })
                    .then(function (response) {
                        this.memberlist = [];
                        if (response.data.length > 0) {
                            vm.memberlist = response.data;
                            console.log('data', vm.memberlist);
                        }
                        loading(false);
                    })
                    .catch(function (error) {
                        console.log(error);
                    })
                }, getDebounceTime()),
                //ajax call to get dates
                getDates() {
                    setTimeout((function () {
                    vm.getDate(vm.period);
                        // console.log(12);
                    }), 2e2);
                },
                getDate(period) {
                    if (period) {
                    // console.log(3232, period);
                    if (period != 'CustomDates') {
                        axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'getDatesByPeriod',
                            period: period,
                        }
                        })
                        .then(function(response) {
                        vm.from_date = null;
                        vm.to_date = null;
                        if (response.data) {
                            vm.from_date = response.data.start;
                            vm.to_date = response.data.end;
                            // console.log('data', response.data);
                        }
                        })
                        .catch(function(error) {
                        vm.period = 'CustomDates';
                        vm.from_date = null;
                        vm.to_date = null;
                        })
                    } else {
                        vm.from_date = null;
                        vm.to_date = null;
                    }
                    }
                },
            }
        });
        var anchor = new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;
                }
            }
        });
        var vtr = new Vue({
            el: '#date_part',
            data: {
                from_date: null,
                to_date: null,
            },
            methods: {
                getData() {
                    this.from_date = this.$refs.from_date.value;
                    this.to_date = this.$refs.to_date.value;
                    // console.log(234, this.from_date, this.to_date,this.$refs.from_date.value);
                    getRecord();
                }
            }
        });
        var vmp =new Vue({
            el: '#multi_invoice_modal',
            data:{
                is_show: false,
                pdfRoute: '{!!route('multiFactor.multiPrint') !!}',
                excelRoute: '',
                member_list: [],
                selected_member :null,
                currency_list:currency_list,
                selected_currency:null,
                invoice_list:[],
                selected_invoice:null,
                selected_invoice_to:null,
                invoice_id: []
            },
            watch: {
                selected_invoice: function(newVal, oldVal) {
                let x = [];
                newVal.forEach(function(e) {
                x.push(e.id);
                });
                this.invoice_id = x;
                console.log('x value');
                console.log(x);
            }
            },
            methods:{
                closeModal: function(){
                    this.is_show = !this.is_show;
                },
                //ajax call to get items
                onMemberSearchInvoice: _.debounce((search, loading) => {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'member',
                            type: 'Customer',
                            search: search,
                        }
                    })
                    .then(function (response) {
                        this.memberlist = [];
                        if (response.data.length > 0) {
                            vmp.member_list = response.data;
                            console.log('data', vmp.member_list);
                        }
                        loading(false);
                    })
                    .catch(function (error) {
                        console.log(error);
                    })
                }, getDebounceTime()),
                selectInvoices() {
                    if (this.selected_member != null && this.selected_currency !=null) {
                        // v.selected_cloth_category = this.member_cloth[index]['clothCategory'];
                        let member_id = this.selected_member.id;
                        let currency = this.selected_currency.code;
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'memberInvoiceSearch',
                                member_id: member_id,
                                currency: currency
                            }
                        })
                        .then(function(response) {
                            vmp.invoice_list = [];
                            if (response.data.length > 0) {
                                vmp.invoice_list = response.data;
                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        });
                    }
                }
            }
        });
        var modal_p= new Vue({
            el: '#multi_in_modal',
            methods: {
                showModal: function () {
                    vmp.$data.is_show = true;
                }
            }
        });
        //Washing Form 
        var vmw =new Vue({
            el: '#multi_washing_modal',
            data:{
                is_show: false,
                pdfRoute: '{!!route('washingFormMultiple.multiPrintForm') !!}',
                excelRoute: '',
                member_list: [],
                selected_member :null,
                currency_list:currency_list,
                selected_currency:null,
                invoice_list:[],
                selected_invoice:null,
                selected_invoice_to:null,
                invoice_id: []
            },
            watch: {
                selected_invoice: function(newVal, oldVal) {
                let x = [];
                newVal.forEach(function(e) {
                x.push(e.id);
                });
                this.invoice_id = x;
                console.log('x value');
                console.log(x);
            }
            },
            methods:{
                closeModal: function(){
                    this.is_show = !this.is_show;
                },
                //ajax call to get items
                onMemberSearchInvoice: _.debounce((search, loading) => {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'member',
                            type: 'Customer',
                            search: search,
                        }
                    })
                    .then(function (response) {
                        this.memberlist = [];
                        if (response.data.length > 0) {
                            vmw.member_list = response.data;
                            console.log('data', vmw.member_list);
                        }
                        loading(false);
                    })
                    .catch(function (error) {
                        console.log(error);
                    })
                }, getDebounceTime()),
                selectInvoices() {
                    if (this.selected_member != null && this.selected_currency !=null) {
                        // v.selected_cloth_category = this.member_cloth[index]['clothCategory'];
                        let member_id = this.selected_member.id;
                        let currency = this.selected_currency.code;
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'memberInvoiceSearch',
                                member_id: member_id,
                                currency: currency
                            }
                        })
                        .then(function(response) {
                            vmw.invoice_list = [];
                            if (response.data.length > 0) {
                                vmw.invoice_list = response.data;
                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        });
                    }
                }
            }
        });
        var modal_w= new Vue({
            el: '#multi_wash_modal',
            methods: {
                showModal: function () {
                    vmw.$data.is_show = true;
                }
            }
        });
        var v = new Vue({
            el: '#date_parttwo',
            methods: {
                // submit the form
                submitFormDatePart(e) {
                    swal({
                        title: "@lang('layout.AreYouSure?')",
                        buttons: ["@lang('layout.Cancel')", "@lang('layout.yes')"],
                        text: "",
                        icon: "info",
                        InfoMode: true,
                    }).then((willDelete) => {
                        if (willDelete) {
                            document.getElementById("invoice-form").submit()
                        } else {
                        }
                    });
                },
                // submit the form
            }
        });
        var vmd =new Vue({
            el: '#multi_driver_modal',
            data:{
                is_show: false,
                pdfRoute: '{!!route('driverFormReport.driversReport') !!}',
                excelRoute: '{!! route('driverFormReport.driversReport') !!}',
                member_list: [],
                selected_member :null,
                customReportData:
                [      
                 {Name: '@lang("layout.SaleNumber")', column_name: 'sale_number',checkedColumn:(cust_rep_driver.sale_number)?'checked':'',column_percentage:(cust_rep_driver.sale_number___percent)?cust_rep_driver.sale_number___percent:''},
                 {Name: '@lang("layout.TransferCode")', column_name: 'transfer_code',checkedColumn:(cust_rep_driver.transfer_code)?'checked':'',column_percentage:(cust_rep_driver.transfer_code___percent)?cust_rep_driver.transfer_code___percent:''},
                 {Name: '@lang("layout.Transporter_name")', column_name: 'transporter_name',checkedColumn:(cust_rep_driver.transporter_name)?'checked':'',column_percentage:(cust_rep_driver.transporter_name___percent)?cust_rep_driver.transporter_name___percent:''},
                 {Name: '@lang("layout.PlateNumber")', column_name: 'plate_number',checkedColumn:(cust_rep_driver.plate_number)?'checked':'',column_percentage:(cust_rep_driver.plate_number___percent)?cust_rep_driver.plate_number___percent:''},
                 {Name: '@lang("layout.Quantity")', column_name: 'quantity',checkedColumn:(cust_rep_driver.quantity)?'checked':'',column_percentage:(cust_rep_driver.quantity___percent)?cust_rep_driver.quantity___percent:''},
                 {Name: '@lang("layout.Phone")', column_name: 'phone',checkedColumn:(cust_rep_driver.phone)?'checked':'',column_percentage:(cust_rep_driver.phone___percent)?cust_rep_driver.phone___percent:''},
                 {Name: '@lang("layout.PlaceOfWeight")', column_name: 'place_of_weight',checkedColumn:(cust_rep_driver.place_of_weight)?'checked':'',column_percentage:(cust_rep_driver.place_of_weight___percent)?cust_rep_driver.place_of_weight___percent:''},
                 {Name: '@lang("layout.SourcePlace")', column_name: 'source_place',checkedColumn:(cust_rep_driver.source_place)?'checked':'',column_percentage:(cust_rep_driver.source_place___percent)?cust_rep_driver.source_place___percent:''},
                 {Name: '@lang("layout.WayBillNumber1")', column_name: 'way_bill_number',checkedColumn:(cust_rep_driver.way_bill_number)?'checked':'',column_percentage:(cust_rep_driver.way_bill_number___percent)?cust_rep_driver.way_bill_number___percent:''},
                 {Name: '@lang("layout.TotalWeight")', column_name: 'total_weight',checkedColumn:(cust_rep_driver.total_weight)?'checked':'',column_percentage:(cust_rep_driver.total_weight___percent)?cust_rep_driver.total_weight___percent:''},
                 {Name: '@lang("layout.EmptyCarWeight")', column_name: 'empty_car_weight',checkedColumn:(cust_rep_driver.empty_car_weight)?'checked':'',column_percentage:(cust_rep_driver.empty_car_weight___percent)?cust_rep_driver.empty_car_weight___percent:''},
                 {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_rep_driver.description)?'checked':'',column_percentage:(cust_rep_driver.description___percent)?cust_rep_driver.description___percent:''},
                 {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_rep_driver.date)?'checked':'',column_percentage:(cust_rep_driver.date___percent)?cust_rep_driver.date___percent:''}
                ],
                cust_rep_driver:cust_rep_driver 
            },
            methods:{
                closeModal: function(){
                    this.is_show = !this.is_show;
                },
                //ajax call to get items
                onMemberSearchInvoice: _.debounce((search, loading) => {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'member',
                            type: 'Customer',
                            search: search,
                        }
                    })
                    .then(function (response) {
                        this.memberlist = [];
                        if (response.data.length > 0) {
                            vmd.member_list = response.data;
                        }
                        loading(false);
                    })
                    .catch(function (error) {
                        console.log(error);
                    })
                }, getDebounceTime())
            }
        });
        var modal_d= new Vue({
            el: '#multi_driv_modal',
            methods: {
                showModal: function () {
                    vmd.$data.is_show = true;
                }
            }
        });
        // custom part start
        var cust_form = {!!customeForm('invoice')!!};
        var sm = new Vue({
            el: '#settingModal',
            data: {
                is_show: false,
                route: '{!!route("customForm.store") !!}',
                customReportData:
                [    @if(getShwoPriceLevel()=="general")
                    {Name: '@lang("layout.PriceLevel")', column_name: 'priceLevel',checkedColumn:(cust_form.priceLevel)?'checked':''},
                    @endif
                    @if(systemConfig()[13] != 0 )
                    {Name: '@lang("menu.Membercloth")', column_name: 'membercloth',checkedColumn:(cust_form.membercloth)?'checked':''},
                    @endif
                    @if(systemConfig()[27] == 1)
                    {Name: '@lang("menu.GasStation")', column_name: 'gasStation',checkedColumn:(cust_form.gasStation)?'checked':''},
                    @endif
                    {Name: '@lang("layout.ReferenceNumber")', column_name: 'referenceNumber',checkedColumn:(cust_form.referenceNumber)?'checked':''},   
                    {Name: '@lang("layout.Date")', column_name: 'date',checkedColumn:(cust_form.date)?'checked':''},   
                    {Name: '@lang("layout.Hour")', column_name: 'hour',checkedColumn:(cust_form.hour)?'checked':''},   
                    {Name: '@lang("layout.Description")', column_name: 'description',checkedColumn:(cust_form.description)?'checked':''}, 
                    @if(getTelegramBot()=="true") 
                    {Name: '@lang("layout.Telegram")', column_name: 'telegram',checkedColumn:(cust_form.telegram)?'checked':''}, 
                    @endif
                    @if(getWhatsApp() =='true' && getWhatsAppType() == 'direct') 
                    {Name: '@lang("layout.Whatsapp")', column_name: 'whatsapp',checkedColumn:(cust_form.whatsapp)?'checked':''}, 
                    @endif
                    @if(checkGift() =='true') 
                    {Name: '@lang("layout.CheckGift")', column_name: 'checkGift',checkedColumn:(cust_form.checkGift)?'checked':''},   
                    @endif
                    @if(systemConfig()[27] == 1)
                    {Name: '@lang("layout.PumpNumber")', column_name: 'pumpNumber',checkedColumn:(cust_form.pumpNumber)?'checked':''},
                    @endif
                    {Name: '@lang("layout.Status")', column_name: 'status',checkedColumn:(cust_form.status)?'checked':''},
                    {Name: '@lang("layout.User")', column_name: 'user',checkedColumn:(cust_form.user)?'checked':''},
                    {Name: '@lang("layout.ItemSearch")', column_name: 'itemSearch',checkedColumn:(cust_form.itemSearch)?'checked':''},
                ],
                cust_form:cust_form
            },
            watch: {
            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },
            }
        });
        new Vue({
            el: '#setting-modal',
            methods: {
                showModal: function () {
                    // console.log('trr')
                    sm.$data.is_show = true
                }
            }
        }); 
        // custom part end 
    </script>


@endpush
