@extends('layouts.factor-master-print')
@section('style')

    <style>
        .small-table td, .main-table td, .main-table tr,
        .small-table th, .main-table th {

        }

        .t1 {
            font-size: 14px;
            font-weight: bold;
            background-color: {{company()['color']}};
        }
    </style>
@stop
@section('content')

    <div>
        <div style=" font-size: 12px !important">

            <!--Table 1 For Invoice Information-->
            <table style="width: 100%">
                <tr>
                    <td class="t1">@lang('layout.InvoiceNumber')</td>
                    <td class="t1">@lang('layout.Date')</td>
                    <td class="t1">@lang('layout.Hour')</td>
                </tr>
                <?php
                $str_date = convertdate($sales->date);

                $date_string = substr($str_date, 0, 10);
                ?>
                <tr>
                    <td class="t1">
                        {{$sales->number}}
                    </td>
                    <td class="t1">
                        {{$date_string}}
                        &nbsp;/&nbsp;
                        {{substr($sales->date,0,10)}}
                    </td>
                    <td class="t1">{{$date->hour.':'.$date->minute}}</td>
                </tr>
            </table>
            <!--End Table 1 For Invoice Information-->


            <!--Table 2 For Customer Information-->
            <table style="width: 100%; margin-top: 25px;">
                <tr>
                    <td class="mt">@lang('layout.BillTo')</td>
                </tr>
                <tr class="mt">
                    <td>@lang('layout.Name'): &nbsp;&nbsp;{{$member->name}}</td>
                    <td>@lang('layout.Address'):&nbsp;&nbsp;{{$address.' '.$city}}</td>
                    <td>@lang('layout.Phone'):&nbsp;&nbsp;{{$phone}}</td>
                </tr>
            </table>
            <!--End Table 2 For Invoice Information-->


            <!--Table 3 For Data  Information-->
            <table class="main-table" style="margin-top: 20px;" cellpadding="5px">
                <tr style="font-weight: bold; font-size: 17px">
                    <td class="mt">
                        <div class="center">@lang('layout.Number')</div>
                    </td>
                <!--<td class="mt"><div class="center">@lang('layout.ItemCode')</div></td>-->
                    <td class="mt">
                        <div class="center">@lang('layout.Item')</div>
                    </td>
                    <td class="mt">
                        <div class="center">@lang('layout.Site')</div>
                    </td>
                    <td class="mt">
                        <div class="center">@lang('layout.Quantity')</div>
                    </td>
                    <td class="mt">
                        <div class="center">@lang('layout.Unit/M')</div>
                    </td>
                    <td class="mt">
                        <div class="center">@lang('layout.Description')</div>
                    </td>
                <!-- <td class="mt"><div class="center">@lang('layout.Description')2</div></td> -->
                    <td class="mt">
                        <div class="center">@lang('layout.Rate')</div>
                    </td>
                    <td class="mt">
                        <div class="center">@lang('layout.Total')</div>
                    </td>

                </tr>
                <?php
                
                $count = 0;
                $empty = 0;
                $fullCount = count($data);
                if ($fullCount < 15) {
                    $empty = 15 - $fullCount;
                }
                ?>
                @foreach($data AS $key1=>$record)
                    <?php

                    ?>
                    <tr>

                        <td class="center">{{++$count}}</td>
                    <!--<td class="center">{{$record['number']}}</td>-->
                        <td class="center">{{$record['name']}}</td>
                        <td class="center">{{$record['siteName']}}</td>
                        <td class="center">{{$record['qty']}}</td>
                        <td class="center">{{$record['symbol']}}</td>
                        <td class="center">{{$record['itemDescription']}}</td>
                    <!-- <td class="center">{{$record['description2']}}</td> -->
                        <td class="center">{{Currency()->format($record['price'], $sales->currency)}}</td>
                        <td class="center">{{ Currency()->format($record['price']*$record['qty'],$sales->currency)}}</td>
                    </tr>

                @endforeach
                @for($i=0;$i<$empty;$i++)

                    <?php
                    ?>
                    @if(getPaperSize() =='A4' && getPaperStyle() =='portrait')
                        @if(getWhiteRows() =="true")
                            <tr>

                                <td class="center" style="height: 30px"></td>
                                <td class="center"></td>
                                <td class="center"></td>
                                <td class="center"></td>
                                <td class="center"></td>
                                <td class="center"></td>
                                <td class="center"></td>
                                <td class="center"></td>
                            </tr>
                            @endif
                            @endif
                            @endfor

                            <?php
                            if ($sales->discount_type == "currency") {
                                echo Currency()->format($discountToShow, $sales->currency);
                            } else {
                                echo round($discountToShow, 2) . '%';
                            }

                            ?>

                            </tbody>
            </table>
            <!--End Table 3 For Data Information-->


            <!--Table 4 For Total  Information-->
            <table class="main-table" style="margin-top: 4px;">
                <tr>
                    <td colspan="4">
                        <div class="center" style="font-size: bold;"><b>@lang('layout.TotalInLeters')
                                :&nbsp; {{notowo(abs($total),'fa')}}</b></div>
                    </td>
                <!--<td colspan="2"><div class="center" style="font-size: bold;"><b>@lang('layout.Total'):&nbsp;{{round($total)}}  @lang('currency.'.($sales->currency)) <br>

    @if($sales->currency != getReportCurrency())
                    مجموع  دالر: {{round($total)/$sales->rate}}
                @endif
                        </b></div></td>-->

                    <td colspan="2">
                        <div class="center">@lang('layout.Recipt'):&nbsp;
                            @if($sales->type == "Invoice")
                                {{round($paid)}} @lang('currency.'.($sales->currency))
                            @endif
                        </div>
                    </td>
                    <td colspan="4">
                        <div class="center" style="font-size: bold;"><b>@lang('layout.Total')
                                :&nbsp;{{round($total)}}  @lang('currency.'.($sales->currency)) <br>

                                @if($sales->currency != getReportCurrency())
                                    مجموع  دالر: {{round($total)/$sales->rate}}
                                @endif
                            </b></div>
                    </td>


                </tr>


                <tr>

                    <td colspan="2">
                        <div class="center">@lang('layout.Discount'):&nbsp;
                            <span>
      @if($sales->discount_type=="currency")
                                    {{round(($discountToShow))}} @lang('currency.'.($sales->currency))
                                @else
                                    {{round($discountToShow)}}
                                    <span>%</span>
                                @endif
    </span>

                        </div>
                    </td>


                    <td colspan="2">
                        <div class="center">@lang('layout.Remined'):&nbsp;
                            @if($sales->type == "Invoice")
                                {{round(($total - (($discount * $total) / 100)-$paid))}} @lang('currency.'.($sales->currency))
                            @endif</div>
                    </td>

                    <td colspan="3">
                        @if(getHesabSabeqa() =='true')
                            <div class="center">@lang('layout.HesabSabiqa'): &nbsp;
                                @if($sales->type == "Invoice")
                                    {{round(($balance-$total+$discountToShow)+$paid)}} @lang('currency.'.($sales->currency))
                                @endif
                            </div>
                        @endif
                    </td>

                    <td colspan="3">
                        <div class="center"><b>@lang('layout.AmountPayable'):&nbsp;
                                @if($sales->type =="Invoice")
                                    {{round((($balance-$total+$discountToShow)+$paid)+($total - (($discount * $total) / 100)-$paid))}} @lang('currency.'.($sales->currency))
                                @endif
                            </b></div>
                    </td>
                </tr>

            </table>
            @if($invoice_des)
                <table width="60%" border="1" style="border-collapse: collapse; margin-top: 7px;">
                    <tr>
                        <td style="font-size: 14px;">{{$invoice_des}}</td>
                    </tr>
                </table>
        @endif
        <!--End Table 4 For Total  Information-->

        </div>

    </div>

    </div>

    <script type="text/javascript">
        window.print();
    </script>
@endsection


