@extends('layouts.factor-master-print-thermal')
@section('style')

    <style>
        .small-table td, .main-table td, .main-table tr,
        .small-table th, .main-table th {

        }

        .t1 {
            font-size: 14px;
            font-weight: bold;
        }  
        .t2 {
            font-size: 14px;
        }  
        .bc {
            /* font-weight: bold; */
        }.bcb {
            font-weight: bold;
            font-size: 25px;
        }
            .mt2{
            height: 28px;
            font-size: 17px;
        }
    </style>
@stop
@section('content')

@if(autoPrintPreview()=="true")
    @if(getFactorLayout()=="rtl")
    <div style="direction: rtl">
    @else
    <div>
    @endif

@else
<div>
@endif
        <div style=" font-size: 12px !important">

     
            
      <div style="text-align: center;" class="bcb">@lang('layout.SaleInvoice1')</div>

            
            <table style="width: 100%;  border:1px solid ">
                <tr>
                    <td class="t1 bc">@lang('layout.Number'):&nbsp;&nbsp;{{$sales->number}}</td>
                    <?php
                    $str_date = convertdate($sales->date);

                    $date_string = substr($str_date, 0, 10);
                    ?>
                    <td class="t2 bc">
                     @if(getInvoiceDateFormat() == "shamsi")
                                <?php
                                $str_date = convertdate($sales->date, 0, 'jalali');

                                $date_string = substr($str_date, 0, 10)
                                ?>
                                {{$date_string}}

                            @elseif(getInvoiceDateFormat() =='both')

                                <?php
                                $str_date = convertdate($sales->date, 0, 'jalali');  
                                $date_string = substr($str_date, 0, 10);
                                echo $date_string;
                                ?>
                                &nbsp;/&nbsp;
                                {{substr($sales->date,0,10)}} 
                            @elseif(getInvoiceDateFormat() =="meladi")
                                {{substr($sales->date,0,10)}} 
                            @else 
                                {{$str_date}}

                            @endif
                    </td>
                </tr>
                <tr>
                    <td class="t2  bc">@lang('layout.User'): &nbsp;&nbsp;{{auth()->user()->name}}</td>
                    <td class="t2  bc"><?php echo Date('h:i A' , strtotime($sales->date)); ?></td>
                </tr>
                @if(getInvoiceReferenceNo()=="true")
                <tr>
                    <td class="t2  bc" colspan="2" >@lang('layout.ReferenceNumber'): &nbsp;&nbsp; <span style="font-size:20px;">{{$sales->ref_no}}</span></td>
                </tr>
                @endif
                <tr>
                   <td class="t2 bc" colspan="2">@lang('layout.Person'): &nbsp;&nbsp;&nbsp;{{$member->name}}</td>
                </tr>
                @if(getActiveSale() == "true")
                <tr>
                   <td class="t2 bc" colspan="2">@lang('layout.FreeCardTimes'): &nbsp;{{$member->free_card_times}}  &nbsp;&nbsp;&nbsp; @lang('layout.Provided'): &nbsp;{{$provided_card}}</td>
                </tr>
                @endif
            </table>

            
            <table class="main-table"  cellpadding="0">
                <tr style="font-weight: bold;">
                    <td class="mt2 center bc" style="width:4%; font-size:12px;">#
                    </td>
          
                    <td class="mt2 center bc" style="width:30%;" >@lang('layout.Item')
                    </td>

                    <td  class="mt2 center bc" style="width:14%;">@lang('layout.Quantity')
                    </td>

                    <td class="mt2 center bc" style="width:15%;">@lang('layout.Unit/M')
                    </td>
                  
				
                    <td  class="mt2 center bc"  style="width:17%;">@lang('layout.Amount')
                    </td>
               
                    <td  class="mt2 center bc"  style="width:20%;">@lang('layout.Total')
                    </td>
                    @if(showBallonQuantity() == 'true')
                    <td  class="mt2 center bc"  style="width:20%;">@lang('layout.BallonQuantity')
                    </td> 
                    <td  class="mt2 center bc"  style="width:20%;">@lang('layout.BallonCapacity')
                    </td>
                    @endif

                </tr>
                <?php

                $count = 0;
                $empty = 0;
                $fullCount = count($data);
                $total_discount = 0;
                $total_discount_per_item=0;

                if ($transportCompany->driver_name || $transportCompany->trasnport_name!=null ) {
                    
                    if ($fullCount < 12) {
                        $empty = 12 - $fullCount;
                    }
                }
                else{
                      if ($fullCount < 15) {
                        $empty = 15 - $fullCount;
                    }
                }
                ?>
 
                @foreach($data AS $key1=>$record)
                    <?php

                    if ($sales->discount_type == "currency") {
                        $total_discount += $record['discount'] * $record['qty'];
                    } else {
                        $t = ($record['price'] * $record['qty']);
                        $total_discount += ($record['discount']) * $t / 100;
                    }

                    $total_discount_per_item+=$record['discount'];

                    ?>
                    <tr>

                        <td class="center bc mt2" style=" font-size:12px;">{{++$count}}</td>
                
                        <td class="center bc mt2" style="white-space: normal;">{{$record['name']}}</td>
               
                       
                        <td class="center bc mt2">{{$record['qty']}}</td>
                        <td class="center bc mt2">{{$record['symbol']}}</td>
						
					
                        <td class="center bc mt2">{{myRound($record['price'])}}</td>
                        
                        @if($sales->discount_type=="currency")
                        <td class="center bc mt2">{{ myRound(($record['price']*$record['qty'])-$record['discount']*$record['qty'])}}</td>
                        @else
                        <td class="center bc mt2">{{ myRound(($record['price']*$record['qty'])-($record['discount']*$record['price']/100)*$record['qty'])}}</td>
                        @endif

                        @if(showBallonQuantity() == 'true')
                        <td class="center bc mt2">{{$record['qty1_amount']}}</td> 
                        <td class="center bc mt2">{{$record['qty'] / $record['qty1_amount']}}</td>
                        @endif
                    </tr>

                @endforeach

                            <?php
                            if ($sales->discount_type == "currency") {
                                echo myRound($discountToShow);
                            } else {
                                echo round($discountToShow) . '%';
                            }

                            $discountTotal = 0;
                            foreach ($data as $key => $value) {
                                $discountTotal = ($value['discount'] * $value['qty']) + $discountTotal;
                            }

                            ?>

                           <tr>
                                <td colspan="4" class="center  mt2">
                                    @if(App::isLocale('fa') || App::isLocale('pa'))
                                        @lang('layout.TotalInLeters') :&nbsp; {{notowo(abs($total-$total_discount),'fa')}}
                                    @else
                                        @lang('layout.TotalInLeters') :&nbsp; {{notowo(abs($total-$total_discount),'en')}}
                                    @endif
                                </td>
                           
                                @if(showBallonQuantity() == 'true')
                                <td colspan="4" class="center  mt2">
                                    @lang('layout.Total'):&nbsp;{{round($total-$total_discount,2)}}  @lang('currency.'.($sales->currency))
                                </td>
                                @else 
                                <td colspan="2" class="center  mt2">
                                    @lang('layout.Total'):&nbsp;{{round($total-$total_discount,2)}}  @lang('currency.'.($sales->currency))
                                </td>
                                @endif

                            </tr> 

                            <tr>
                                <td colspan="4">
                                  
                                </td>
                                @if($sales->type !="SalesReceipt")
                                @if(showBallonQuantity() == 'true')
                                <td colspan="4" class="center  mt2"> @lang('layout.Recipt'):&nbsp; {{myRound($paid)}} @lang('currency.'.($sales->currency))
                                </td>
                                @else 
                                <td colspan="2" class="center  mt2"> @lang('layout.Recipt'):&nbsp; {{myRound($paid)}} @lang('currency.'.($sales->currency))
                                </td>
                                @endif
                                @endif
                            </tr>   

                            <tr>
                                <td colspan="4">
                                  
                                </td>
                           
                                @if(showBallonQuantity() == 'true')
                                <td colspan="4" class="center  mt2">
                                    @lang('layout.Discount'):&nbsp;   @if($sales->discount_type=="currency")
                                        {{myRound(($discountToShow))}} @lang('currency.'.($sales->currency))
                                        @else
                                            {{myRound($discountToShow)}} @lang('currency.'.($sales->currency))
                                            <!-- span>%</span -->
                                        @endif
                                </td>
                                @else 
                                <td colspan="2" class="center  mt2">
                                    @lang('layout.Discount'):&nbsp;   @if($sales->discount_type=="currency")
                                        {{myRound(($discountToShow))}} @lang('currency.'.($sales->currency))
                                        @else
                                            {{myRound($discountToShow)}} @lang('currency.'.($sales->currency))
                                            <!-- span>%</span -->
                                        @endif
                                </td>
                                @endif

                            </tr>  
                            <tr>
                                <td colspan="4">
                                  
                                </td>
                                @if(showBallonQuantity() == 'true')
                                @if($sales->type =="SalesReceipt")
                                <td colspan="4" class="center  mt2">
                                    @lang('layout.AmountPayable'):&nbsp; {{myRound(($total-$total_discount) - (($discount * $total) / 100))}} @lang('currency.'.($sales->currency))
                                </td>
                                @else
                                <td colspan="4" class="center  mt2">
                                    @lang('layout.Remined'):&nbsp; {{myRound((($total-$total_discount) - (($discount * $total) / 100)-$paid))}} @lang('currency.'.($sales->currency))
                                </td>
                                @endif
                                @else 
                                @if($sales->type =="SalesReceipt")
                                <td colspan="2" class="center  mt2">
                                    @lang('layout.AmountPayable'):&nbsp; {{myRound(($total-$total_discount) - (($discount * $total) / 100))}} @lang('currency.'.($sales->currency))
                                </td>
                                @else
                                <td colspan="2" class="center  mt2">
                                    @lang('layout.Remined'):&nbsp; {{myRound((($total-$total_discount) - (($discount * $total) / 100)-$paid))}} @lang('currency.'.($sales->currency))
                                </td>
                                @endif
                                @endif

                            </tr>
                            <tr>
                                @if(showBallonQuantity() == 'true')
                                <td style="font-size: 16px;" class="center  mt2" colspan="8" >{!!company()['phone']!!}</td>
                                @else 
                                <td style="font-size: 16px;" class="center  mt2" colspan="6" >{!!company()['phone']!!}</td>
                                @endif

                            </tr>
                            @if(company()['invoice_message'])
                            <tr>
                                @if(showBallonQuantity() == 'true')
                                <td style="font-size: 16px;" class="center  mt2" colspan="8">
                                    {!! company()['invoice_message'] !!} 
                                </td>
                                @else 
                                <td style="font-size: 16px;" class="center  mt2" colspan="6">
                                    {!! company()['invoice_message'] !!} 
                                </td>
                                @endif
                            </tr>
                            @endif
                            </tbody>
            </table>

           
            
            <table class="main-table">
            @if($sales->type == "Invoice" || $sales->type == "saleByType" || $sales->type == "ProjectInvoice")
            @if($sales->hesab_sabeqa =="ok" || $sales->type == "saleByType" || $sales->type == "ProjectInvoice")
            @if(getHesabSabeqahType()=="base_currency" || getHesabSabeqahType()==null) 
            @if(getHesabSabeqa() =='true')

            <tr>
                <td colspan="2" class="center">
                    @lang('layout.HesabSabiqa')
                </td>
            </tr>

            <tr style="border: 1px solid black;">
                <td class="center"> @lang('layout.Bilance') </td>
                <td class="center"> 
                    @if($sales->type == "Invoice" || $sales->type == "saleByType" || $sales->type == "ProjectInvoice")
                    @if(systemConfig()[30] == 1)
                    {{myRound($balance - (($total) )/$currencySR * $sales->rate)}} {{getHomeCurrency()["code"]}}
                    @else 
                    {{myRound($balance - (($total) )/$sales->rate)}} {{getHomeCurrency()["code"]}}
                    @endif

                    @endif
                    {{-- {{getHomeCurrency()["code"]}} --}}
                </td>
            </tr>
            <tr style="border: 1px solid black;">
                <td class="center"> @lang('layout.CurrentBilance') </td> 
                <td class="center"> 
                    @if($sales->type =="Invoice" || $sales->type == "saleByType" || $sales->type == "ProjectInvoice")
                    @if(systemConfig()[30] == 1)
                    {{myRound(((($balance * $currencySR / $sales->rate)-($total)))+($total + $taxationAmount+$commissionAmount+$transfer_rent_amount - $discountToShow - $paid))}} @lang('currency.'.($sales->currency))
                    @else 
                    {{myRound(((($balance * $sales->rate)-($total)))+($total + $taxationAmount+$commissionAmount+$transfer_rent_amount - $discountToShow - $paid))}} @lang('currency.'.($sales->currency))
                    @endif
                    @endif  
                </td>
            </tr>
            @endif
            @endif
            @endif
            @endif




            @if($sales->type == "Invoice" || $sales->type == "saleByType" || $sales->type == "ProjectInvoice")
            @if($sales->hesab_sabeqa =="ok" || $sales->type == "saleByType" || $sales->type == "ProjectInvoice")
            @if(getHesabSabeqahType()=="currency")
            @if(getHesabSabeqa() =='true')

            <tr>
                <td colspan="2" class="center">
                    @lang('layout.HesabSabiqa')
                </td>
            </tr>

          
            <tr style="border: 1px solid black;">
                <td class="center"> @lang('layout.Bilance') </td>
                <td  class="center"> 
                    @if($sales->type == "Invoice" || $sales->type == "saleByType" || $sales->type == "ProjectInvoice")
            {{myRound(($balance-$total-$taxationAmount-$commissionAmount-$transfer_rent_amount+$discountToShow)+$paid)}} @lang('currency.'.($sales->currency))
            @endif
                    {{-- {{getHomeCurrency()["code"]}} --}}
                </td>
            </tr>
            <tr style="border: 1px solid black;">
                <td class="center"> @lang('layout.CurrentBilance') </td> 
                <td  class="center"> 
                    @if($sales->type =="Invoice" || $sales->type == "saleByType" || $sales->type == "ProjectInvoice")
                    {{myRound((($balance-$total-$taxationAmount-$commissionAmount-$transfer_rent_amount+$discountToShow)+$paid)+($total+$taxationAmount+$commissionAmount+$transfer_rent_amount - $discountToShow -$paid))}} @lang('currency.'.($sales->currency))
                    @endif 
                </td>
            </tr>
            @endif
            @endif
            @endif
            @endif



            <tr>
            @if($sales->type == "SalesReceipt")
            @if(getHesabSabeqaSale()=="true")
            <td colspan="3">
                <div class="center">@lang('layout.HesabSabiqa'): &nbsp;
                    @if(getHesabSabeqahType()=="currency")
                        {{myRound(($balance))}} @lang('currency.'.($sales->currency))
                    @else
                        {{myRound(($balance))}} {{getHomeCurrency()["code"]}}
                    @endif
                </div>

            </td>
            @endif
            @endif
 
        
            @if($sales->type == "SalesReceipt")
            @if(getHesabSabeqaSale()=="true")
            <td colspan="3">
                <div class="center">@lang('layout.HesabSabiqa'): &nbsp;
                    @if(getHesabSabeqahType()=="currency")
                        {{myRound(($balance))}} @lang('currency.'.($sales->currency))
                    @else
                        {{myRound(($balance))}} {{getHomeCurrency()["code"]}}
                    @endif
                </div>

            </td>
            @endif
            @endif


        </tr>

         </table>


         

        @if(getHesabSabeqahType()=="all_currency" || getHesabSabeqahType()==null)
        <table  class="main-table">
            @if(getHesabSabeqa() =='true')
            @if($sales->type == "Invoice" || $sales->type == "saleByType" || $sales->type == "ProjectInvoice")
            <tr class="center">
                <td class="center" colspan="2">    
                    @lang('layout.HesabSabiqa'): &nbsp;
                </td>
            </tr>
            <tr>
                <td class="center" colspan="1">    
                    @lang('layout.Currency') &nbsp;
                </td>
                <td class="center" colspan="1">    
                    @lang('layout.Amount') &nbsp;
                </td>
            </tr>
            @foreach($allCurrency as $currency)
            <tr>
                <td class="center" colspan="1">    
                    {{$currency['currency']}} 
                </td>
                <td class="center" colspan="1">    
                {{myRound($currency['invoice'])}} 
                </td>
            </tr>
            @endforeach
            @endif
            @endif
        </table>
        @endif



        </div>

    </div>






    <script type="text/javascript">
        window.print();
    </script>
@endsection


