@extends('layouts.factor-master-print')
@section('style')

    <style>
        .small-table td,
        .main-table td,
        .main-table tr,
        .small-table th,
        .main-table th {}

        .t1 {
            font-size: 14px;
            font-weight: bold;
        }

        .t2 {
            font-size: 14px;
        }

        .bc {}

        .bcb {
            font-weight: bold;
            font-size: 20px;
        }

        .mt2 {
            height: 30px;

        }

        .pm {
            text-align: right !important;
            height: 15px;
        }

        .pd {
            text-align: left !important;
            height: 15px;
        }

    </style>
@stop
@section('content')

    <div>
        <div style=" font-size: 12px !important"> 
            <table style="width: 100%;  border:1px solid ">
                <tr>
                    @if ($info)
                        <?php
                        $str_date = convertdate($info->Date);
                        $date_string = substr($str_date, 0, 10);
                        ?>
                    @endif
                    <td class="t2 bc">
                        @if ($info)
                            @lang('layout.Date')
                            @if (getInvoiceDateFormat() == 'shamsi')
                                <?php
                                $str_date = convertdate($info->Date, 0, 'jalali');
                                
                                $date_string = substr($str_date, 0, 10);
                                ?>
                                {{ $date_string }}

                            @elseif(getInvoiceDateFormat() == 'both')

                                <?php
                                $str_date = convertdate($info->Date, 0, 'jalali');
                                
                                $date_string = substr($str_date, 0, 10);
                                echo $date_string;
                                ?>
                                &nbsp;/&nbsp;
                                {{ substr($info->Date, 0, 10) }}

                            @elseif(getInvoiceDateFormat() == 'meladi')
                                {{ substr($info->Date, 0, 10) }}

                            @else

                                {{ $str_date }}

                            @endif
                        @endif
                    </td>
                    <td class="t1 bc">{!! company()['name'] !!}</td>
                </tr>

                <tr>
                    @if ($info)
                        <?php
                        $str_date = convertdate($info->overdue_date);
                        
                        $date_string = substr($str_date, 0, 10);
                        ?>
                    @endif
                    <td class="t2 bc">
                        @if ($info)
                            @lang('layout.DateBack')
                            @if (getInvoiceDateFormat() == 'shamsi')
                                <?php
                                $str_date = convertdate($info->overdue_date, 0, 'jalali');
                                
                                $date_string = substr($str_date, 0, 10);
                                ?>
                                {{ $date_string }}

                            @elseif(getInvoiceDateFormat() == 'both')

                                <?php
                                $str_date = convertdate($info->overdue_date, 0, 'jalali');
                                
                                $date_string = substr($str_date, 0, 10);
                                echo $date_string;
                                ?>
                                &nbsp;/&nbsp;
                                {{ substr($info->overdue_date, 0, 10) }}

                            @elseif(getInvoiceDateFormat() == 'meladi')
                                {{ substr($info->overdue_date, 0, 10) }}

                            @else

                                {{ $str_date }}

                            @endif
                        @endif
                    </td>
                </tr>

            </table>

            <table width="100%" style=" border:1px solid black">
                <tr>
                    <td class="center bc mt2" style="font-size: 12px;white-space: normal; border:1px solid black">
                        @lang('layout.No')</td>
                    <td class="center bc mt2" colspan="3"
                        style="font-size: 14px;white-space: normal ; border:1px solid black;">{{ $info ? $info->number : '' }}
                    </td>
                </tr>
                <tr>
                    <td class="center bc mt2" style="font-size: 12px;white-space: normal;  border:1px solid black">
                        @lang('layout.Name')</td>
                    <td class="center bc mt2" colspan="3"
                        style="font-size: 14px;white-space: normal;  border:1px solid black">
                        {{ $info ? $info->member_name : '' }}</td>
                </tr>
                <tr>
                    <td class="center bc mt2" style="font-size: 12px;white-space: normal; border:1px solid black">
                        @lang('layout.Item')</td>
                    <td class="center bc mt2" colspan="3"
                        style="font-size: 14px;white-space: normal; border:1px solid black">{{ $cloth ? $cloth->name : '' }}
                    </td>
                </tr>

                <tr>
                    <td class="center bc mt2" style="font-size: 14px;white-space: normal;">رخت</td>
                    <td class="center bc mt2" style="font-size: 12px;white-space: normal;">@lang('layout.Quantity')</td>
                    <td class="center bc mt2" style="font-size: 14px;white-space: normal;">@lang('layout.Price')</td>
                    <td class="center bc mt2" style="font-size: 14px;white-space: normal;">@lang('layout.Total')</td>
                </tr>
                @foreach ($data as $key1 => $record)
                    <tr>
                        <td class="center bc mt2" style="font-size: 14px;white-space: normal;">{{ $record['name'] }}</td>
                        <td class="center bc mt2" style="font-size: 14px;white-space: normal;">{{ $record['qty'] }}</td>
                        <td class="center bc mt2" style="font-size: 14px;white-space: normal;">{{ $record['price'] }}</td>
                        <td class="center bc mt2" style="font-size: 14px;white-space: normal;">
                            {{ $record['price'] * $record['qty'] }}</td>
                    </tr>
                @endforeach
                <tr>
                    <td></td>
                    <td></td>
                    <td class="center bc mt2" style="font-size: 14px;white-space: normal;">پیشکی</td>
                    <td class="center bc mt2" style="font-size: 14px;white-space: normal;">{{ $paid }}</td>
                </tr>
                <tr>
                    <td></td>
                    <td></td>
                    <td class="center bc mt2" style="font-size: 14px;white-space: normal;"><b>باقی مانده </b></td>
                    <td class="center bc mt2" style="font-size: 14px;white-space: normal;">
                        <b>{{ $total + $taxationAmount - $discountToShow - $paid }} </b>
                    </td>
                </tr>
            </table>

            <table style="width: 100%;  border:1px solid">
                <tr>
                    <td class="center bc mt2" colspan="4" style="font-size: 14px;white-space: normal;">
                        @lang('layout.Address') :{!! company()['streetAddress'] !!}</td>
                </tr>
                <tr>
                    <td class="center bc mt2" colspan="2" style="font-size: 14px;white-space: normal;">
                        {!! company()['phone'] !!}</td>
                    <td class="center bc mt2" colspan="2" style="font-size: 14px;white-space: normal;">
                        {!! company()['email'] !!}</td>
                </tr>

            </table>

            <table style="width: 100%; margin-top: 5px; border:1px solid">
                <tr>
                    <td class="center bc mt2" style="font-size: 12px;white-space: normal;">@lang('layout.No')</td>
                    <td class="center bc mt2" style="font-size: 14px;white-space: normal;">
                        <b>{{ $info ? $info->number : '' }}</b></td>
                    <td class="center bc mt2" style="font-size: 12px;white-space: normal;">{{ $data[0]['name'] }}</td>
                    <td class="center bc mt2" style="font-size: 14px;white-space: normal; border:1px solid black">
                        <b>{{ $cloth ? $cloth->name : '' }}</b></td>
                </tr>
                <tr>
                    <td class="center bc mt2" style="font-size: 12px;white-space: normal;">@lang('layout.Name')</td>
                    <td class="center bc mt2" style="font-size: 14px;white-space: normal;">
                        <b>{{ $info ? $info->member_name : '' }}</b></td>
                </tr>
                <tr>
                    <td class="center bc mt2" style="font-size: 12px;white-space: normal;">@lang('layout.Quantity')</td>
                    <td class="center bc mt2" style="font-size: 14px;white-space: normal;">{{ $data[0]['qty'] }}</td>
                    <td class="center bc mt2" style="font-size: 12px;white-space: normal;">@lang('layout.DateBack')</td>
                    <td class="center bc mt2" style="font-size: 12px;white-space: normal;">

                        @if ($info)
                            @if (getInvoiceDateFormat() == 'shamsi')
                                <?php
                                $str_date = convertdate($info->overdue_date, 0, 'jalali');
                                
                                $date_string = substr($str_date, 0, 10);
                                ?>
                                {{ $date_string }}

                            @elseif(getInvoiceDateFormat() == 'both')

                                <?php
                                $str_date = convertdate($info->overdue_date, 0, 'jalali');
                                
                                $date_string = substr($str_date, 0, 10);
                                echo $date_string;
                                ?>
                                &nbsp;/&nbsp;
                                {{ substr($info->overdue_date, 0, 10) }}

                            @elseif(getInvoiceDateFormat() == 'meladi')
                                {{ substr($info->overdue_date, 0, 10) }}

                            @else

                                {{ $str_date }}

                            @endif
                        @endif
                    </td>
                </tr>
            </table>

            <table style="width: 100%;  border:1px solid">



                <tr>
                    <td style=" width:30%">
                        @if (count($dataSize) > 0)
                            <table cellpadding="4px">
                                @foreach ($dataSize as $key1 => $record)
                                    <tr>
                                        <td class="pm" style="font-size: 13px;white-space: normal; ">
                                            {{ $record['property_name'] }}</td>
                                        <td class="pd"
                                            style="font-size: 13px;white-space: normal; border-left:1px solid black">
                                            {{ $record['size'] }}</td>
                                    </tr>

                                @endforeach
                            </table>
                        @endif
                    </td>

                    <td width="5%">
                        <?php  for($i=0;$i<=count($dataSize); $i++){?>
                        <!-- |<br> -->
                        <?php }?>
                    </td>
                    <td style=" width:60%">
                        @if (count($memberClothStyle) > 0)
                            <table cellpadding="4px">
                                @foreach ($memberClothStyle as $key1 => $record)
                                    <?php
                                    
                                    ?>
                                    <tr>
                                        <td class="pm" style="font-size: 13px;white-space: normal;">
                                            {{ $record['styleName'] }}</td>
                                        <td></td>
                                        <td class="pm" style="font-size: 13px;white-space: normal;">
                                            {{ $record['name'] }}</td>
                                    </tr>

                                @endforeach
                            </table>
                        @endif
                    </td>
                </tr>
            </table>




            <div>
                <span style="font-size: 14px;" class="bc">{{ $info ? $info->description : '' }}</span>

            </div>
            <!--End Table 3 For Data Information-->
        </div>

    </div>

    </div>





    <script type="text/javascript">
        window.print();
    </script>
@endsection
