@extends('layouts.factor-master-print')
@section('style')

    <style>
        .small-table td, .main-table td, .main-table tr,
        .small-table th, .main-table th {

        }

        .t1 {
            font-size: 14px;
            font-weight: bold;
            background-color: {{company()['color']}};
        }
    </style>
@stop
@section('content')

    <div>
        <div style=" font-size: 12px !important">
        {!!Company()['description']!!}


        <!--Table 2 For Customer Information-->
            <h3 class="table-caption" style="text-align: center;"><b>@lang('layout.SaleInvoice')</b></h3>
            <table style="width: 100%;  margin-top: 10px; border:1px solid">

                <tr>
                    <td class="t1">@lang('layout.CustomerCode'): &nbsp;&nbsp;{{$member->code}}</td>
                    <td class="t1">@lang('layout.InvoiceNumber'):&nbsp;&nbsp;{{$sales->number}}</td>
                </tr>
                <tr>
                    <td class="t1">@lang('layout.CustomerName'): &nbsp;&nbsp;{{$member->name}}</td>
                    <?php
                    $str_date = convertdate($sales->date);

                    $date_string = substr($str_date, 0, 10);
                    ?>
                    <td class="t1">@lang('layout.Date'):&nbsp;&nbsp;
                        @if(getInvoiceDateFormat() == "shamsi")
                            {{$date_string}}
                        @endif
                        @if(getInvoiceDateFormat() =='both')
                            {{$date_string}}
                            &nbsp;/&nbsp;
                            {{substr($sales->date,0,10)}}
                        @endif
                        @if(getInvoiceDateFormat() =="meladi")
                            {{substr($sales->date,0,10)}}
                        @endif
                    </td>
                </tr>
                <tr>
                    <td class="t1">@lang('layout.Address'): &nbsp;&nbsp;{{$address.' '.$city}}</td>
                    <td class="t1">@lang('layout.Hour'):&nbsp;&nbsp;{{$date->hour.':'.$date->minute}}</td>
                </tr>
                <tr>
                    <td class="t1">@lang('layout.Phone'): &nbsp;&nbsp;{{$member->phone}}</td>
                </tr>

            </table>
            <!--End Table 2 For Invoice Information-->


            <!--Table 3 For Data  Information-->
            <table class="main-table" style="margin-top: 20px;" cellpadding="5px">
                <tr style="font-weight: bold; font-size: 17px">
                    <td class="mt">
                        <div class="center"><b>@lang('layout.Number')</b></div>
                    </td>
                <!--<td class="mt"><div class="center">@lang('layout.ItemCode')</div></td>-->
                    <td class="mt">
                        <div class="center"><b>شرح جنس</b></div>
                    </td>
                    <td class="mt">
                        <div class="center"><b>نام انبار</b></div>
                    </td>
                    <td class="mt">
                        <div class="center"><b>تعداد</b></div>
                    </td>
                    <td class="mt">
                        <div class="center"><b>@lang('layout.Unit/M')</b></div>
                    </td>
                    <td class="mt">
                        <div class="center"><b>@lang('layout.Description')</b></div>
                    </td>
                    <td class="mt">
                        <div class="center"><b>مبلغ جزء</b></div>
                    </td>
                    <td class="mt">
                        <div class="center"><b>قیمت کل</b></div>
                    </td>

                </tr>
                <?php
                
                $count = 0;
                $empty = 0;
                $fullCount = count($data);
                if ($fullCount < 15) {
                    $empty = 15 - $fullCount;
                }
                ?>
                @foreach($data AS $key1=>$record)
                    <?php

                    ?>
                    <tr>

                        <td class="center">{{++$count}}</td>
                    <!--<td class="center">{{$record['number']}}</td>-->
                        <td>{{$record['name']}}</td>
                        <td class="center">{{$record['siteName']}}</td>
                        <td class="center">{{$record['qty']}}</td>
                        <td class="center">{{$record['symbol']}}</td>
                        <td class="center">{{$record['itemDescription']}}</td>
                        <td class="center">{{Currency()->format($record['price'], $sales->currency)}}</td>
                        <td class="center">{{ Currency()->format($record['price']*$record['qty'],$sales->currency)}}</td>
                    </tr>

                @endforeach
                @for($i=0;$i<$empty;$i++)

                    <?php
                    ?>
                    @if(getPaperSize() =='A4' && getPaperStyle() =='portrait')
                        @if(getWhiteRows() =="true")
                            <tr>

                                <td class="center" style="height: 30px"></td>
                                <td class="center"></td>
                                <td class="center"></td>
                                <td class="center"></td>
                                <td class="center"></td>
                                <td class="center"></td>
                                <td class="center"></td>
                                <td class="center"></td>
                            </tr>
                        @endif
                    @endif
                @endfor
                <tr>
                    <td colspan="6" style="border: none"></td>
                    <td style="border: none"><b>جمع بل</b></td>
                    <td>{{round($total)}}  @lang('currency.'.($sales->currency))</td>
                </tr>
                <tr>
                    <td colspan="6" style="border: none"></td>
                    <td style="border: none"><b>کل تخفیف</b></td>
                    <td>
          <span>
          @if($sales->discount_type=="currency")
                  {{round(($discountToShow))}} @lang('currency.'.($sales->currency))
              @else
                  {{round($discountToShow)}}
                  <span>%</span>
              @endif
        </span>
                    </td>
                </tr>
                <!--<tr>
                  <td colspan="6" style="border: none"></td>
                  <td style="border: none"><b>هزینه</b></td>
                  <td ></td>
                </tr>
                <tr>
                  <td colspan="6" style="border: none"></td>
                  <td style="border: none"><b>خالص بل</b></td>
                  <td ></td>
                </tr>-->
                <tr>
                    <td colspan="6" style="border: none"></td>
                    <td style="border: none"><b>دریافت نقدی</b></td>
                    <td>
                        @if($sales->type == "Invoice")
                            {{round($paid)}} @lang('currency.'.($sales->currency))
                        @endif
                    </td>
                </tr>

                <!--<tr>
                  <td colspan="2" style="border: none">حساب شما قبل از بل فوق مبلغ</td>
                  <td colspan="2" style="border: none">ذمت</td>
                  <td colspan="2" style="border: none">ذمت</td>
                  <td  style="border: none"><b>دریافت چک</b></td>
                  <td ></td>
                </tr>-->
                <!-- <tr>
                   <td colspan="2" style="border: none">حساب شما قبل از بل فوق مبلغ</td>
                   <td colspan="2" style="border: none">ذمت</td>
                   <td colspan="2" style="border: none">ذمت</td>
                   <td  style="border: none"><b>دریافت حواله</b></td>
                   <td ></td>
                 </tr>-->
                <tr>
                    <td colspan="2" style="border: none"></td>
                    <td colspan="2" style="border: none"></td>
                    <td colspan="2" style="border: none"></td>
                    <td style="border: none"><b>مانده از بل</b></td>
                    <td>
                        @if($sales->type == "Invoice")
                            {{round(($total - (($discount * $total) / 100)-$paid))}} @lang('currency.'.($sales->currency))
                        @endif
                    </td>
                </tr>
            <!-- <tr style="font-weight: bold; font-size: 16px">
  <td colspan="2" class="center mt">@lang('layout.TotalAmount')</td>
  <td colspan="2" class="center mt">{{Currency()->format($total,$sales->currency)}}</td>
  <td colspan="2" class="center mt">@lang('layout.Discount')</td>
  <td  colspan="" class="center mt">

    <?php
            if ($sales->discount_type == "currency") {
                echo Currency()->format($discountToShow, $sales->currency);
            } else {
                echo round($discountToShow, 2) . '%';
            }

            ?>
                    </td>
                  </tr> -->

                </tbody>
            </table>
            <table class="main-table">
                <tr>
                    <td>
      <span>
		میوند بانک دالری:1008201386774&nbsp;میوند بانک افغانی: 1008202386774
    </span>
                        <br>
                        <span>
        عزیزی بانک دالری: 000501200947524&nbsp;عزیزی بانک افغانی: 00050110015383
    </span>
                        <br>
                        <br>
                        <span><b>
					&nbsp;&nbsp;&nbsp;&nbsp;
					&nbsp;&nbsp;&nbsp;&nbsp;
					&nbsp;&nbsp;&nbsp;&nbsp;
		امضاء فروشنده &nbsp;&nbsp;&nbsp;&nbsp;
					&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
					&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
					&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
					&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
		امضاء خریدار
     </b></span>

                        <br>
                        <br>
                        <br>
                        <br>
                        <br>
                    </td>
                </tr>

            </table>
        </div>

    </div>

    </div>

    <script type="text/javascript">
        window.print();
    </script>
@endsection


