@extends('layouts.factor-master-print')

@section('content')

@section('style')

<style>
  .tot {
    background-color: #f3eaea;
  }
</style>
@stop



<div>
  <div style=" font-size: 12px !important">


    <table class="main-table" style="border:none;">
      <caption><b>فاکتور فروش</b></caption>
      <tr>
        <td><b>@lang('layout.InvoiceNumber'): {{$sales->number}}</b></td>
        <?php
        $str_date = convertdate($sales->date);

        $date_string = substr($str_date,0,10);
      ?>
        <td><b>
            @lang('layout.Date'):&nbsp;&nbsp;
            @if(getInvoiceDateFormat() == "shamsi")
            {{$date_string}}
            @endif
            @if(getInvoiceDateFormat() =='both')
            {{$date_string}}
            &nbsp;/&nbsp;
            {{substr($sales->date,0,10)}}
            @endif
            @if(getInvoiceDateFormat() =="meladi")
            {{substr($sales->date,0,10)}}
            @endif
          </b></td>

        <td><b>@lang('layout.Hour'): {{Date('h:i A',strtotime($sales->date))}}</b></td>
      </tr>
    </table>


    <table class="main-table">
      <tr>
        <td><b>@lang('layout.CustomerName'): </b><b>{{$member->name}} ({{$sales->description}})</b></td>
        <td><b>@lang('layout.CustomerCode'): </b><b>{{$member->code}}</b></td>
        <td><b>@lang('layout.Phone'): {{$phone}}</b></td>
      </tr>
    </table>




    <table class="main-table" style="margin-top: 10px;" cellpadding="5px">
      <tr style="font-weight: bold; font-size: 20px">
        <td class="mt">
          <div class="center" style="font-size:18px;"><b>@lang('layout.Number')</b></div>
        </td>
        <!--<td class="mt"><div class="center">@lang('layout.ItemCode')</div></td>-->
        <td class="mt">
          <div class="center" style="font-size:18px;"><b>@lang('layout.Item')</b></div>
        </td>
        @if(getInventorySite()=="true")
        <td class="mt">
          <div class="center" style="font-size:18px;"><b>@lang('layout.Site')</b></div>
        </td>
        @endif
        <td class="mt">
          <div class="center" style="font-size:18px;"><b>@lang('layout.Quantity')</b></div>
        </td>
        <td class="mt">
          <div class="center" style="font-size:18px;"><b>@lang('layout.Unit/M')</b></div>
        </td>
        <td class="mt">
          <div class="center" style="font-size:18px;"><b>@lang('layout.Rate')</b></div>
        </td>
        <td class="mt">
          <div class="center" style="font-size:18px;"><b>@lang('layout.Total')</b></div>
        </td>
        @if(getSaleDescription()=="true")
        <td class="mt">
          <div class="center" style="font-size:18px;"><b> @lang('layout.Description') </b></div>
        </td>
        @endif
        @if(getSaleDescription2()=="true")
        <td class="mt">
          <div class="center" style="font-size:18px;"><b>
              @lang('layout.Description') 2 </b></div>
        </td>
        @endif

      </tr>
      <?php
 
 $count=0;
 $empty=0;
 $fullCount=count($data);
//  dd($data);
 if($fullCount<20 && $setting->paper_style=='portrait')
 {
    $empty=20-$fullCount;
 }

  $totalQty = 0;
  $measure_total = [];

  $totalQty1 = 0;
  $measure_total1 = [];

  $totalOMeasureQty = 0;
  $OMeasure_total = [];

 ?>
      @foreach($data AS $record)
      <?php
        //Total Items
        if (array_key_exists($record['symbol'], $measure_total)) {
            $measure_total[$record['symbol']] = $measure_total[$record['symbol']] + $record['qty'];
        } else {
            $measure_total[$record['symbol']] = $record['qty'];
        }
        $totalQty += $record['qty'];

        //Total measure1
        if ($record['qty1_amount'] > 0) {
            if (array_key_exists($record['sale_measure1']['symbol'], $measure_total1)) {
                $measure_total1[$record['sale_measure1']['symbol']] = $measure_total1[$record['sale_measure1']['symbol']] + $record['qty1_amount'];
            } else {
                $measure_total1[$record['sale_measure1']['symbol']] = $record['qty1_amount'];
            }
            $totalQty1 += $record['qty1_amount'];
        }

        //Total measure1
        if ((double)$record['other_measure'] > 0 && getOtherMeasure()=="true") {
            if (array_key_exists($record['o_measure_name'], $OMeasure_total)) {
                $OMeasure_total[$record['o_measure_name']] = $OMeasure_total[$record['o_measure_name']] + $record['other_measure'];
            } else {
                $OMeasure_total[$record['o_measure_name']] = $record['other_measure'];
            }
            $totalOMeasureQty += $record['other_measure'];
        }
      ?>
      @if($record['type']=='inventoryPart' || $record['type']=="inventoryAssembly" || $record['type']=="workingProgress" || $record['type']=="procurement")
      <tr>

        <td class="center" style="font-size:16px;"><b>{{++$count}}</b></td>
        <!--<td class="center">{{$record['number']}}</td>-->
        <td class="center" style="font-size:16px;"><b>{{$record['name']}}</b></td>
        @if(getInventorySite()=="true")
        <td class="center">
          <div style="font-size:16px;"><b>{{$record['siteName']}}</b></div>
        </td>
        @endif
        <td class="center">
          <div style="font-size:16px;"><b>{{$record['qty']}}</b>
        </td>
        <td class="center">
          <div style="font-size:16px;"><b>{{$record['symbol']}}</b>
        </td>
        <td class="center">
          <div style="font-size:16px;"><b>{{myRound($record['price'])}} @lang('currency.'.($sales->currency))</b>
        </td>
        <td class="center">
          <div style="font-size:16px;"><b>{{ myRound($record['price']*$record['qty'])}}
              @lang('currency.'.($sales->currency))</b>
        </td>
        @if(getSaleDescription()=="true")
        <td class="center">{{$record['description']}}</td>
        @endif
        @if(getSaleDescription2()=="true")
        <td class="center">{{$record['description2']}}</td>
        @endif
      </tr>
      @endif
      @if($record['type']=='service')
      <tr>

        <!--<td class="center">{{$record['number']}}</td>-->
        <td class="center" style="font-size:16px;" colspan="6"><b>{{$record['name']}}</b></td>
        <td class="center">
          <div style="font-size:16px;"><b>{{ myRound($record['price']*$record['qty'])}}
              @lang('currency.'.($sales->currency))</b>
        </td>
      </tr>
      @endif

      @endforeach
      @for($i=0;$i<$empty;$i++) <?php ?>

        @if(getPaperSize() =='A4' && getPaperStyle() =='portrait')
        @if(getWhiteRows()=="true" ) 
        <tr>
          <td class="center">{{++$count}}</td>
          <td class="center"></td>
          @if(getInventorySite()=="true")
          <td class="center"></td>
          @endif
          <td class="center"></td>
          <td class="center"></td>
          <td class="center"></td>
          <td class="center"></td>
          @if(getSaleDescription()=="true")
          <td class="center"></td>
          @endif
          @if(getSaleDescription2()=="true")
          <td class="center"></td>
          @endif
        </tr>
        @endif
        @endif
        @endfor

        </tbody>
    </table>
    <br>
    <!--Begin Total Item Quantity-->

    @if(getTotalItemQuantity()!='' ||getTotalItemQuantity()!="defualt")
    @if(getTotalItemQuantity() == "per_unit")

    <table class="main-table">
      <tr>
        <td colspan="2"><b>@lang('layout.TotalQuantity')</b></td>
      </tr>
      @foreach($measure_total AS $key=>$measure)
      <tr>
        <td><b>{{$measure}}</b></td>
        <td><b>{{$key}}</b></td>
      </tr>
      @endforeach

      @if($measure_total1 && getM2()!="" && getFactorMeasure2()=="true")
      <tr>
        <td colspan="2"><b>@lang('layout.TotalMeasure2')</b></td>
      </tr>
      @foreach($measure_total1 AS $key=>$measure)
      <tr>
        <td><b>{{$measure}}</b></td>
        <td><b>{{$key}}</b></td>
      </tr>
      @endforeach
      @endif

      @if($OMeasure_total && getOtherMeasure()=="true")
      <tr>
        <td colspan="2"><b>@lang('layout.OtherMeasure')</b></td>
      </tr>
      @foreach($OMeasure_total AS $key=>$measure)
      <tr>
        <td><b>{{$measure}}</b></td>
        <td><b>{{$key}}</b></td>
      </tr>
      @endforeach
      @endif

    </table>
    @endif
    @if(getTotalItemQuantity() == "all_unit")

    <table class="main-table">
      <tr>
        <td><b>@lang('layout.TotalQuantity')</b></td>
        <td><b>{{$totalQty}}</b></td>
      </tr>
      @if($totalQty1 > 0 && getM2()!="" && getFactorMeasure2()=="true")
      <tr>
        <td><b>@lang('layout.TotalQuantity') @lang('layout.Measure2')</b></td>
        <td><b>{{$totalQty1}}</b></td>
      </tr>
      @endif
      @if($totalOMeasureQty > 0 && getOtherMeasure()=="true")
      <tr>
        <td><b>@lang('layout.TotalQuantity') @lang('layout.OtherMeasure')</b></td>
        <td><b>{{$totalOMeasureQty}}</b></td>
      </tr>
      @endif
    </table>
    @endif

    @endif

    <!--End Total Item Quantity-->
    <br>

    <table class="main-table" style="margin-top: 2px;">
      <tr>
        <td colspan="4" class="tot">
          <div class="center" style="font-size: bold;">جمع کل به حروف : {{notowo(round(abs($total)),'fa')}} </div>
        </td>

        <td colspan="2" class="tot">
          <div class="center" style="font-size: bold;">جمع کل</div>
        </td>
        <td colspan="3" class="tot">
          <div class="center" style="font-size: bold;">{{myRound($total)}} @lang('currency.'.($sales->currency))</div>
        </td>

      </tr>
      <tr>

        <td colspan="1" class="tot">
          <div class="center" style="font-size: bold;">@lang('layout.Recipt')
          </div>
        </td>
        <td colspan="3" class="tot">
          <div class="center" style="font-size: bold;">
            {{myRound($paid)}} @lang('currency.'.($sales->currency))
          </div>
        </td>


        <td colspan="2" class="tot">
          <div class="center" style="font-size: bold;">@lang('layout.HesabSabiqa')

          </div>
        </td>
        <td colspan="3" class="tot">
          @if($sales->type == "Invoice")
          {{round(($balance-$total+$discountToShow)+$paid)}} @lang('currency.'.($sales->currency))
          @endif
        </td>

      </tr>
      <tr>
        <td colspan="6" class="tot">
          <div class="center" style="font-size: bold;">@lang('layout.Discount')

          </div>
        </td>

        <td colspan="3" class="tot">
          <div class="center" style="font-size: bold;">
            @if($sales->discount_type=="currency")
            {{myRound(($discountToShow))}} @lang('currency.'.($sales->currency))
            @else
            {{myRound($discountToShow)}} @lang('currency.'.($sales->currency))
            <!-- span>%</span -->
            @endif
          </div>
        </td>

      </tr>
      <tr>
        <td colspan="6" class="tot">جمع بعد از کل حسابات:
          {{notowo(abs(round((($balance-$total+$discountToShow)+$paid)+($total - (($discount * $total) /
          100)-$paid))),'fa')}} @lang('currency.'.($sales->currency))</td>

        <td colspan="3" class="tot">
          <div class="center">
            @if($sales->type =="Invoice")
            {{round((($balance-$total+$discountToShow)+$paid)+($total - (($discount * $total) / 100)-$paid))}}
            @lang('currency.'.($sales->currency))
            @endif
          </div>
        </td>

        @if(getHesabSabeqa() =='false')
        <td colspan="3" class="tot">
          <div class="center">@lang('layout.AmountPayable'):&nbsp;
            @if($sales->type =="Invoice")
            {{round(($total - (($discount * $total) / 100)-$paid))}} @lang('currency.'.($sales->currency))
            @endif
          </div>
        </td>
        @endif
      </tr>



    </table>



    @if(company()['invoice_message'])
    <table width="100%">
      <tr>
        <td style="font-size: 14px;">{!!company()['invoice_message']!!}</td>
      </tr>
    </table>
    @endif


    <br>
    <p style="font-size:18px;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
      &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
      &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
      &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;

      @lang('مهر و امضاء')</p>



  </div>

</div>

</div>

<script type="text/javascript">
  window.print();
</script>
@endsection