@extends('layouts.factor-master-print')
@section('style')

<style>
    .t1 {
        font-size: 14px;
        font-weight: bold;
        /* background-color: {{company()['color']}}; */
    }

    .mt1 {
        background-color: rgb(15, 127, 231);
        color: white;
        font-weight: bold;
        text-align: center;
        height: 25px;
        font-size: 22px;
    }

    .center1 {
        height: 37px;
    }




    .new-table {
        width: 100%;
        border-collapse: collapse;
        font-size: 14px;
    }

    .new-table th {
        border: solid 1px black;

        white-space: nowrap;
        text-overflow: ellipsis;
    }

    .new-table td {
        border: solid 1px black;

        white-space: nowrap;
        text-overflow: ellipsis;
    }
</style>
@stop
@section('content')



<?php
$str_date = convertdate($sales->date);

$date_string = substr($str_date, 0, 10);

$notEmpty = false;

foreach ($data as $item) {
    if(!empty($item['description']))
    {
        $notEmpty = true;
        break;
    }
}

?>

<div style="border: 2px solid black;border-radius: 13px;">

    <table style="width: 100% ;">

        <tr> 
            <td class="t1" style="width: 40%;height: 35px">
                <span style="font-size: 14px;">@lang('layout.Customer')</span>:
                @if(getDescriptionASMemberName()=="true" && $other_member_name!="")
                {{$member->name}}-{{$other_member_name}}
                @else
                {{$member->name}}
                @endif
            </td>
            <td class="t1" style="width: 50%;height: 20px"><span style="font-size: 18px;">@lang('layout.Date')</span>:
                @if(getInvoiceDateFormat() == "shamsi")
                <?php
                $str_date = convertdate($sales->date, 0, 'jalali');

                $date_string = substr($str_date, 0, 10)
                ?>
                {{$date_string}}

                @elseif(getInvoiceDateFormat() =='both')

                <?php
                $str_date = convertdate($sales->date, 0, 'jalali');

                $date_string = substr($str_date, 0, 10);
                echo $date_string;
                ?>
                &nbsp;/&nbsp;
                {{substr($sales->date,0,10)}}

                @elseif(getInvoiceDateFormat() =="meladi")
                {{substr($sales->date,0,10)}}

                @else

                {{$str_date}}

                @endif
            </td>
            <td class="t1" style="width: 17%;height: 35px"><span style="font-size: 18px;">@lang('layout.Number')</span>: {{$sales->number}}</td>
        </tr>
    </table>
</div>


{{-- <div style="border: 2px solid black;border-radius: 13px; margin-top:2px"> --}}
<!--Table 3 For Data  Information-->
<table class="new-table" cellpadding="5px" style="margin-top:2px;">
    <tr style="font-weight: bold; font-size: 17px">
        <td class="mt1" style="width: 4%; ">
            <span style="font-size: 12px;">شماره</span>
        </td>
        <!--<td class="mt"><div class="center">@lang('layout.ItemCode')</div></td>-->
        @if(getSerailNumber() =="true")
        <td class="mt1">
            <div class="center">@lang('layout.SerialNum')</div>
        </td>
        @endif
        <td class="mt1" style="width: 55%;">
            <div class="center" style="font-size: 16px">شرح کالا</div>
        </td>

        @if(getItemImage()=="true")
        <td class="mt1">
            <div class="center">@lang('layout.ItemImage')</div>
        </td>
        @endif
        @if(getItemOtherName()=="true")
        <td class="mt1">
            <div class="center">@lang('layout.ItemOtherName')</div>
        </td>
        @endif
        @if(getInventorySite()=="true")
        <td class="mt1">
            <div class="center">@lang('layout.Site')</div>
        </td>
        @endif
        <td class="mt1" style="width: 12%;">
            <span style="font-size: 14px;">تعداد</span>
        </td>
        {{-- <td class="mt1">
                        <div class="center">@lang('layout.Unit/M')</div>
                    </td> --}}
        @if(getM2()!="")
        <td class="mt1">
            <div class="center">@lang('layout.Measure2')</div>
        </td>
        @endif
        @if(getM3()!="")
        <td class="mt1">
            <div class="center">@lang('layout.Measure3')</div>
        </td>
        @endif
        @if(getM4()!="")
        <td class="mt1">
            <div class="center">@lang('layout.Measure4')</div>
        </td>
        @endif
        @if(getSaleDescription()=="true" && $notEmpty!=false)
        <td class="mt1">
            <div class="center">@lang('layout.Description')</div>
        </td>
        @endif
        <td class="mt1" style="width: 10%;">
            <span style="font-size: 16px;">قیمت واحد</span>
        </td>
        @if(getSaleDiscount()=="true")
        <td class="mt1">
            <div class="center">@lang('layout.Sub-Total')</div>
        </td>
        <td class="mt1">
            <div class="center">@lang('layout.Discount')</div>
        </td>
        @endif
        <td class="mt1" style="width: 17%;">
            <span style="font-size: 16px;">جمع کل</span>
        </td>

    </tr>
    <?php

    $count = 0;
    $empty = 0;
    $fullCount = count($data);
    $total_discount = 0;
    $total_discount_per_item = 0;
    $totalQty = 0;
    $totalQty1 = 0;
    $measure_total1 = [];

    if (getPaperSize() == 'A4') {
        if ($fullCount < 12) {
            $empty = 12 - $fullCount;
        }
    }
    if (getPaperSize() == 'A5') {
        if ($fullCount < 7) {
            $empty = 7 - $fullCount;
        }
    }


    $measure_total = [];
    ?>
    @foreach($data AS $key1=>$record)
    <?php

    if (array_key_exists($record['symbol'], $measure_total)) {
        $measure_total[$record['symbol']] = $measure_total[$record['symbol']] + $record['qty'];
    } else {
        $measure_total[$record['symbol']] =  $record['qty'];
    }
    $totalQty += $record['qty'];

    if ($sales->discount_type == "currency") {
        $total_discount += $record['discount'] * $record['qty'];
    } else {
        $t = ($record['price'] * $record['qty']);
        $total_discount += ($record['discount']) * $t / 100;
    }

    $total_discount_per_item += $record['discount'];

    //Total measure1
    if ($record['qty1_amount'] > 0) {
        if (array_key_exists($record['sale_measure1']['symbol'], $measure_total1)) {
            $measure_total1[$record['sale_measure1']['symbol']] = $measure_total1[$record['sale_measure1']['symbol']] + $record['qty1_amount'];
        } else {
            $measure_total1[$record['sale_measure1']['symbol']] = $record['qty1_amount'];
        }
        $totalQty1 += $record['qty1_amount'];
    }
    
    ?>
    <tr>

        <td class="center">{{++$count}}</td>
        <!--<td class="center1">{{$record['number']}}</td>-->
        @if(getSerailNumber() =="true")
        <td class="center1">{{$record['number']}}</td>
        @endif
        <td class="center1">{{$record['name']}}</td>
        @if(getItemImage()=="true")
        <td class="center1" style="margin: 0px;padding: 0px;">
            @if($record['image'])
            <img alt="" style="height: 80px;width: 80px;" class="img-circle" src="{{asset('uploads/items/'.$record['image'])}}" />
            @endif
        </td>
        @endif
        @if(getItemOtherName()=="true")
        <td class="center1">{{$record['item_other_name']}}</td>
        @endif
        @if(getInventorySite()=="true")
        <td class="center1">{{$record['siteName']}}</td>
        @endif
        <td class="center">{{$record['qty']}}</td>
        {{-- <td class="center1">{{$record['symbol']}}</td> --}}
        @if(getM2()!="")
        <td class="center1">{{$record['qty1']}}</td>
        @endif
        @if(getM3()!="")
        <td class="center1">{{$record['qty2']}}</td>
        @endif
        @if(getM4()!="")
        <td class="center1">{{$record['qty3']}}</td>
        @endif
        @if(getSaleDescription()=="true"  && $notEmpty!=false)
        {{-- && $record['itemDescription'] --}}
        <td class="center1"> {{$record['description']}}</td>
        @endif
        <td class="center">{{Currency()->format($record['price'], $sales->currency)}}</td>
        @if(getSaleDiscount()=="true")
        <td class="center">{{ Currency()->format($record['price']*$record['qty'],$sales->currency)}}</td>
        <td class="center">{{$record['discount']}} {{($sales->discount_type=="percent")? '%' : $sales->currency}}</td>
        @endif
        <!-- <td class="center1">{{ Currency()->format($record['price']*$record['qty'],$sales->currency)}}</td> -->

        @if($sales->discount_type=="currency")
        <td class="center">{{ Currency()->format(($record['price']*$record['qty'])-$record['discount']*$record['qty'],$sales->currency)}}</td>
        @else
        <td class="center">{{ Currency()->format(($record['price']*$record['qty'])-($record['discount']*$record['price']/100)*$record['qty'],$sales->currency)}}</td>
        @endif
    </tr>

    @endforeach
    @for($i=0;$i<$empty;$i++) <?php
                                ?> {{-- @if(getPaperSize() =='A4' && getPaperStyle() =='portrait') --}} @if(getWhiteRows()=="true" ) <tr>

        <td class="center">{{++$count}}</td>
        @if(getSerailNumber() =="true")
        <td class="center1"></td>
        @endif
        <td class="center1"></td>
        @if(getItemImage()=="true")
        <td class="center1"></td>
        @endif
        @if(getItemOtherName()=="true")
        <td class="center1"></td>
        @endif
        <td class="center1"></td>
        @if(getInventorySite()=="true")
        <td class="center1"></td>
        @endif
        {{-- <td class="center1"></td> --}}

        @if(getM2()!="")
        <td class="center1"></td>
        @endif

        @if(getM3()!="")
        <td class="center1"></td>
        @endif
        @if(getM4()!="")
        <td class="center1"></td>
        @endif
        @if(getSaleDescription()=="true" && $notEmpty!=false)
        <td class="center1"></td>
        @endif
        <td class="center1"></td>
        @if(getSaleDiscount()=="true")
        <td class="center1"></td>
        <td class="center1"></td>
        @endif
        @if(getFactorOtherMeasure() =="true")
        <td class="center1"></td>
        <td class="center1"></td>
        @endif
        <td class="center1"></td>
        </tr>
        @endif
        {{-- @endif --}}
        @endfor

        <?php
        if ($sales->discount_type == "currency") {
            echo Currency()->format($discountToShow, $sales->currency);
        } else {
            echo round($discountToShow, 2) . '%';
        }

        $discountTotal = 0;
        foreach ($data as $key => $value) {
            $discountTotal = ($value['discount'] * $value['qty']) + $discountTotal;
        }

        ?>
</table>
<!--Begin Total Item Quantity-->

@if(getTotalItemQuantity()!='' ||getTotalItemQuantity()!="defualt")
@if(getTotalItemQuantity() == "per_unit")
<table class="main-table">
    <tr>
        <td colspan="2"><b>@lang('layout.TotalQuantity')</b></td>
    </tr>
    @foreach($measure_total AS $key=>$measure)
    <tr>
        <td><b>{{$measure}}</b></td>
        <td><b>{{$key}}</b></td>
    </tr>
    @endforeach

    @if($measure_total1 && getM2()!="" && getFactorMeasure2()=="true")
    <tr>
        <td colspan="2"><b>@lang('layout.TotalMeasure2')</b></td>
    </tr>
    @foreach($measure_total1 AS $key=>$measure)
    <tr>
        <td><b>{{$measure}}</b></td>
        <td><b>{{$key}}</b></td>
    </tr>
    @endforeach
    @endif

</table>
@endif
@if(getTotalItemQuantity() == "all_unit")

<table class="main-table">
    <tr>
        <td><b>@lang('layout.TotalQuantity')</b></td>
        <td><b>{{$totalQty}}</b></td>
    </tr>
    @if($totalQty1 > 0 && getM2()!="" && getFactorMeasure2()=="true")
    <tr>
        <td><b>@lang('layout.TotalQuantity') @lang('layout.Measure2')</b></td>
        <td><b>{{$totalQty1}}</b></td>
    </tr>
    @endif
</table>
@endif

@endif

<!--End Total Item Quantity-->
<table class="new-table" cellpadding="5px" style="margin-top:0px;">
    <tr>
        <td colspan="3" style="width: 60%; height: 30px">
            @if(App::isLocale('fa') || App::isLocale('pa'))
            <b style="font-size: 14px">مجموع بحروف
                :&nbsp;{{notowo(abs(round($total-$total_discount)),'fa')}} @lang('currency.'.($sales->currency)) </b>
            @else
            <b>مجموع بحروف
                :&nbsp;{{notowo(abs(round($total-$total_discount)),'en')}} @lang('currency.'.($sales->currency)) </b>
            @endif
        </td>

        <td class="mt1" style="width: 20%; font-size: 14px">مبلغ کل</td>
        <td class="center" style="width: 20%;">{{simpleRound($total-$total_discount)}} @lang('currency.'.($sales->currency)) </td>
    </tr>
    <tr>
        <td colspan="3" rowspan="5" style="height: 30px;" class="center">


        </td>
        <td class="mt1" style="font-size: 14px"> مبلغ تخفیف</td>
        <td class="center">
            <span>
                @if($sales->discount_type=="currency")
                {{simpleRound(($discountToShow))}} @lang('currency.'.($sales->currency))
                @else
                {{simpleRound($discountToShow)}} @lang('currency.'.($sales->currency))
                @endif
            </span>
        </td>
    </tr>

    <tr>
        <td class="mt1" style="font-size: 14px"> رسید</td>
        <td class="center">{{simpleRound($paid)}} @lang('currency.'.($sales->currency))</td>
    </tr>


    <tr>
        <td class="mt1" style="font-size: 14px"> باقی مانده فاکتور</td>
        <td class="center">{{simpleRound((($total+$taxationAmount-$discountToShow) -$paid))}} @lang('currency.'.($sales->currency))</td>
    </tr>

    <!-------------------- ----------------------------------------------------------------------------------
                                ---------------Begin Hesab Sabeqah-----------------------------------------------------------------------
                                --------------------------------------------------------------------------------------------------------->
    <?php
    ?>
    @if($sales->type == "Invoice")
    @if($sales->hesab_sabeqa =="ok")
    @if(getHesabSabeqahType()=="base_currency" || getHesabSabeqahType()==null)

    <tr>
        <td class="mt1" style="font-size: 14px">قرض گذشته</td>
        <td class="center">
            @if(getHesabSabeqa() =='true')
            @if($sales->type == "Invoice")
            @if(systemConfig()[30] == 1)
            {{simpleRound($balance - (($total+$taxationAmount-$discountToShow) -$paid)/ $currencySR * $sales->rate)}} {{getHomeCurrency()["code"]}}
            @else 
            {{simpleRound($balance - (($total+$taxationAmount-$discountToShow) -$paid)/$sales->rate)}} {{getHomeCurrency()["code"]}}
            @endif
            @endif
        </td>
    </tr>

    <tr>
        <td class="mt1" style="font-size: 14px">الباقی حساب</td>
        <td class="center">
            @if($sales->type =="Invoice")
            @if(systemConfig()[30] == 1)
            {{simpleRound(((($balance * $currencySR / $sales->rate)-($total+$taxationAmount)+$discountToShow)+$paid)+($total + $taxationAmount - $discountToShow - $paid))}} @lang('currency.'.($sales->currency))
            @else 
            {{simpleRound(((($balance * $sales->rate)-($total+$taxationAmount)+$discountToShow)+$paid)+($total + $taxationAmount - $discountToShow - $paid))}} @lang('currency.'.($sales->currency))
           @endif
            @endif
        </td>
    </tr>


    @endif
    @endif
    @endif
    @endif

    @if($sales->type == "Invoice")
    @if($sales->hesab_sabeqa =="ok")
    @if(getHesabSabeqahType()=="currency")
    <tr>
        <td class="mt1" style="font-size: 14px">قرض گذشته</td>
        <td class="center">
            @if(getHesabSabeqa() =='true')
            @if($sales->type == "Invoice")
            {{simpleRound(($balance-$total-$taxationAmount+$discountToShow)+$paid)}} @lang('currency.'.($sales->currency))
            @endif

        </td>
    </tr>
    <tr>
        <td class="mt1" style="font-size: 14px">الباقی حساب</td>
        <td class="center">
            @if($sales->type =="Invoice")
            {{simpleRound((($balance-$total-$taxationAmount+$discountToShow)+$paid)+($total+$taxationAmount - $discountToShow -$paid))}} @lang('currency.'.($sales->currency))
            @endif
        </td>
    </tr>
    @endif
    @endif
    @endif
    @endif
    <!-------------------- ----------------------------------------------------------------------------------
                                ---------------End  Hesab Sabeqah- ----------------------------------------------------------------------
                                --------------------------------------------------------------------------------------------------------->


</table>
<!--End Table 3 For Data Information-->

{{-- </div> --}}



@if(company()['invoice_message'])
<table width="100%">
    <tr>
        <td style="font-size: 14px;">{!!company()['invoice_message']!!}</td>
    </tr>

    <tr>
        <td></td>
        <td></td>
    </tr>


</table>
@endif






<!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','invoice') AS $info)
        <td style="text-align: left; width:40%">
            <table>

                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>

            </table>
        </td>
        @endforeach
    </tr>
</table>
<!-- End signature -->

<script type="text/javascript">
    window.print();
</script>
@endsection