@extends('layouts.factor-master-print')
@section('style')

    <style>
        .small-table td, .main-table td, .main-table tr,
        .small-table th, .main-table th {

        }

        .t1 {
            font-size: 14px;
            font-weight: bold;
            background-color: {{company()['color']}};
        }
    </style>
@stop
@section('content')

    <div>
        <div style=" font-size: 12px !important">


            <!--Table 2 For Customer Information-->
            <table style="width: 100%;">
                <tr>
                    <td style="text-align: left; width:20%">
                        <table class="main-table">
                            <tr>
                                <td align="center" colspan="2">
                                    <b style="font-size: 20px;">@lang('layout.Invoice')</b>
                                </td>

                            </tr>

                            <tr>
                                <td align="right"><b>@lang('layout.InvoiceNumber')</b></td>
                                <td align="right"><b>@lang('layout.Date')</b></td>
                            </tr>
                            <?php
                            $str_date = convertdate($sales->date);

                            $date_string = substr($str_date, 0, 10);
                            ?>
                            <tr>
                                <td align="right"><b>{{$sales->number}}</b></td>
                                <td align="right"><b>
                                        @if(getInvoiceDateFormat() == "shamsi")
                                            <?php
                                            $str_date = convertdate($sales->date, 0, 'jalali');

                                            $date_string = substr($str_date, 0, 10)
                                            ?>
                                            {{$date_string}}

                                        @elseif(getInvoiceDateFormat() =='both')

                                            <?php
                                            $str_date = convertdate($sales->date, 0, 'jalali');

                                            $date_string = substr($str_date, 0, 10);
                                            echo $date_string;
                                            ?>
                                            &nbsp;/&nbsp;
                                            {{substr($sales->date,0,10)}}

                                        @elseif(getInvoiceDateFormat() =="meladi")
                                            {{substr($sales->date,0,10)}}

                                        @else

                                            {{$str_date}}

                                        @endif
                                    </b></td>
                            </tr>
                        </table>
                    </td>

                    <td width="20%"></td>
                    <td style="text-align: right; width:60%">

                    </td>
                </tr>
            </table>
            <!--End Table 2 For Invoice Information-->

            <table style="width: 100%; margin-top: 10px;">
                <tr>
                    <td style="text-align: left; width:40%">
                        <table class="main-table">
                            <tr>
                                <td align="center" colspan="2">
                                    <b>@lang('layout.BillTo')</b>
                                </td>

                            </tr>
                            <tr>
                                <td align="right"><b>@lang('layout.Name')</b></td>
                                <td align="right"><b>
                                    @if(getDescriptionASMemberName() && $sales->type=='SalesReceipt')
                                    {{$sales->description}}
                                    @else
                                    {{$member->name}}
                                    @endif
                                </b></td>
                            </tr>
                            <tr>
                                <td align="right"><b>@lang('layout.Code')</b></td>
                                <td align="right"><b>{{$member->code}}</b></td>
                            </tr>
                        </table>
                    </td>

                    <td width="20%"></td>
                    <td style="text-align: right; width:30%">
                        <table class="main-table">
                            <tr>
                                <td align="center" colspan="2"><b>@lang('layout.ShipTo')</b></td>
                            </tr>
                            <tr>
                                <td width="25%" align="right"><b>@lang('layout.Address')</b></td>
                                <td align="right"><b>{{$address.' '.$city}}</b></td>
                            </tr>
                            <tr>
                                <td align="right"><b>@lang('layout.Phone')</b></td>
                                <td align="right"><b>{{$phone}}</b></td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>


            <!--Table 3 For Data  Information-->
            <table class="main-table" style="margin-top: 20px;" cellpadding="5px">
                <tr style="font-weight: bold; font-size: 17px">
                    <td class="mt">
                        <div class="center">@lang('layout.Number')</div>
                    </td>
                <!--<td class="mt"><div class="center">@lang('layout.ItemCode')</div></td>-->
                    @if(getSerailNumber() =="true")
                        <td class="mt">
                            <div class="center">@lang('layout.SerialNum')</div>
                        </td>
                    @endif
                    <td class="mt">
                        <div class="center">@lang('layout.Item')</div>
                    </td>

                    @if(getItemImage()=="true")
                        <td class="mt">
                            <div class="center">@lang('layout.ItemImage')</div>
                        </td>
                    @endif
                    @if(getItemOtherName()=="true")
                        <td class="mt">
                            <div class="center">@lang('layout.ItemOtherName')</div>
                        </td>
                    @endif
                    @if(getInventorySite()=="true")
                        <td class="mt">
                            <div class="center">@lang('layout.Site')</div>
                        </td>
                    @endif
                    <td class="mt">
                        <div class="center">@lang('layout.Quantity1')</div>
                    </td>
                    
					@if(getM2()!="")
                        <td class="mt">
                            <div class="center">@lang('layout.Measure2')</div>
                        </td>
                    @endif
					@if(getM3()!="")	
                        <td class="mt">
                            <div class="center">@lang('layout.Measure3')</div>
                        </td>
                    @endif
					@if(getM4()!="")	
                        <td class="mt">
                            <div class="center">@lang('layout.Measure4')</div>
                        </td>
                    @endif
                    @if(getSaleDescription()=="true")
                        <td class="mt">
                            <div class="center">@lang('layout.Description')</div>
                        </td>
                    @endif
                    <td class="mt">
                        <div class="center">@lang('layout.Rate')</div>
                    </td>
                    @if(getSaleDiscount()=="true")
                        <td class="mt">
                            <div class="center">@lang('layout.Sub-Total')</div>
                        </td>
                        <td class="mt">
                            <div class="center">@lang('layout.Discount')</div>
                        </td>
                    @endif
                    <td class="mt">
                        <div class="center">@lang('layout.Total')</div>
                    </td>

                </tr>
                <?php


                $count = 0;
                $empty = 0;
				$totalPrice=0;
                $fullCount = count($data);
                $total_discount = 0;
                if ($fullCount < 15) {
                    $empty = 15 - $fullCount;
                }
                ?>
                @foreach($data AS $key1=>$record)
                    <?php

                    if ($sales->discount_type == "currency") {
                        $total_discount += $record['discount'] * $record['qty'];
                    } else {
                        $t = ($record['price'] * $record['qty']);
                        $total_discount += ($record['discount']) * $t / 100;
                    }

                    ?>
                    <tr>

                        <td class="center">{{++$count}}</td>
                    <!--<td class="center">{{$record['number']}}</td>-->
                        @if(getSerailNumber() =="true")
                            <td class="center">{{$record['number']}}</td>
                        @endif
                        <td class="center">{{$record['name']}}</td>
                        @if(getItemImage()=="true")
                            <td class="center" style="margin: 0px;padding: 0px;"><img alt=""
                                                                                      style="height: 80px;width: 80px;"
                                                                                      class="img-circle"
                                                                                      src="{{storage_path().'/uploads/items/'.$record['image']}}"/>
                            </td>
                        @endif
                        @if(getItemOtherName()=="true")
                            <td class="center">{{$record['item_other_name']}}</td>
                        @endif
                        @if(getInventorySite()=="true")
                            <td class="center">{{$record['siteName']}}</td>
                        @endif
                        <td class="center">{{$record['qty']}}</td>
						@if(getM2()!="")	
                            <td class="center">{{$record['qty1']}}</td>						
						@endif
						@if(getM3()!="")	
                            <td class="center">{{$record['qty2']}}</td>
						@endif
						@if(getM4()!="")	
                            <td class="center">{{$record['qty3']}}</td>
                        @endif
                        @if(getSaleDescription()=="true")
                            <td class="center">{{$record['itemDescription']}}</td>
                        @endif
                        <td class="center">{{Currency()->format($record['price'], $sales->currency)}}</td>
                        @if(getSaleDiscount()=="true")
                            <td class="center">{{ Currency()->format($record['price']*$record['qty'],$sales->currency)}}</td>
                            <td class="center">{{$record['discount']}} {{($sales->discount_type=="percent")? '%' : $sales->currency}}</td>
                        @endif
                    <!-- <td class="center">{{ Currency()->format($record['price']*$record['qty'],$sales->currency)}}</td> -->

                        @if($sales->discount_type=="currency")
                            <td class="center">{{ Currency()->format(($record['price']*$record['qty'])-$record['discount']*$record['qty'],$sales->currency)}}</td>
                        @else
                            <td class="center">{{ Currency()->format(($record['price']*$record['qty'])-($record['discount']*$record['price']/100)*$record['qty'],$sales->currency)}}</td>
                        @endif
                    </tr>

                @endforeach
                @for($i=0;$i<$empty;$i++)

                    <?php
                    ?>
                    @if(getPaperSize() =='A4' && getPaperStyle() =='portrait')
                        @if(getWhiteRows() =="true")
                            <tr>

                                <td class="center" style="height: 30px"></td>
                                @if(getSerailNumber() =="true")
                                    <td class="center"></td>
                                @endif
                                <td class="center"></td>
                                @if(getItemImage()=="true")
                                    <td class="center"></td>
                                @endif
                                @if(getItemOtherName()=="true")
                                    <td class="center"></td>
                                @endif
                                @if(getInventorySite()=="true")
                                    <td class="center"></td>
                                @endif
                                <td class="center"></td>

                                @if(getM2()!="")
                                    <td class="center"></td>
                                @endif 

                                @if(getM3()!="")
                                    <td class="center"></td>
                                @endif 
                                @if(getM4()!="")
                                    <td class="center"></td>
                                @endif
                                @if(getSaleDescription()=="true")
                                    <td class="center"></td>
                                @endif
                                <td class="center"></td>
                                @if(getSaleDiscount()=="true")
                                    <td class="center"></td>
                                    <td class="center"></td>
                                @endif
                                @if(getFactorOtherMeasure() =="true")
                                    <td class="center"></td>
                                    <td class="center"></td>
                                @endif
                                <td class="center"></td>
                            </tr>
                            @endif
                            @endif
                            @endfor

                            <?php
                            if ($sales->discount_type == "currency") {
                                echo Currency()->format($discountToShow, $sales->currency);
                            } else {
                                echo round($discountToShow, 2) . '%';
                            }

                            $discountTotal = 0;
                            foreach ($data as $key => $value) {
                                $discountTotal = ($value['discount'] * $value['qty']) + $discountTotal;
                            }

                            ?>

                            </tbody>
            </table>

            
        <!--Table 3 For Payment  Information-->
        @if(getInvoicePayment()== "true")
        @if(count($invoice_payment)>0)
        <table class="main-table" style="margin-top: 5px;" cellpadding="5px">

            <tr style="font-weight: bold;">
                <td class="mt" colspan="5">
                    <div class="center" style="font-size: 20px;font-weight: bold;">@lang('layout.Payment')</div>
                </td>
            </tr>

            <tr style="font-weight: bold; font-size: 17px">
                <td class="mt">
                    <div class="center">@lang('layout.Number')</div>
                </td>
                <td class="mt">
                    <div class="center">@lang('layout.Description')</div>
                </td>
                <td class="mt">
                    <div class="center">@lang('layout.Amount')</div>
                </td>
                <td class="mt">
                    <div class="center">@lang('layout.Currency')</div>
                </td>
                <td class="mt">
                    <div class="center">@lang('layout.Rate')</div>
                </td>


            </tr>

            <?php

            $count = 0;
            $total_payments = 0;

            ?>
            @foreach($invoice_payment AS $key2=>$payment)
            <?php
                if(systemConfig()[30] == 1){
                    $total_payments += (($payment['amount'] / $currencySR * $payment['rate']) * $currencySR)  / $sales->rate ; 
                }else{
                    $total_payments += $payment['amount'] * $sales->rate / $payment['rate']; 
                }
            
            ?>

            <tr>

                <td class="center">{{++$count}}</td>

                <td class="center">{{$payment['description']}}</td>
                <td class="center">{{myRound($payment['amount'])}}</td>
                <td class="center">{{$payment['currency']}}</td>
                <td class="center">{{$payment['rate']}}</td>

            </tr>

            @endforeach
        </table>
        @endif
        @endif
        <!--End Table 3 For Payment Information-->

        <?php

        if (getInvoicePayment() == "true" && count($invoice_payment) > 0) {
            $total = $total_payments + $total;
        }
        ?>

            <!--Table 4 For Total  Information--> 
            <table class="main-table" style="margin-top: 8px;">
                <tr>
                    <td >
                        <div class="center" style="font-size: bold;"><b>@lang('layout.TotalInLeters')
                                :&nbsp;
                                @if(App::isLocale('fa') || App::isLocale('pa'))
                                {{notowo(abs($total-$total_discount),'fa')}} @lang('currency.'.($sales->currency))
                                @else
                                {{notowo(abs($total-$total_discount),'en')}} @lang('currency.'.($sales->currency))
                                @endif
                            </b></div>
                    </td>

                    

                    
                    <td >
                        <div class="center" style="font-size: bold;"><b>@lang('layout.Total')
                                :&nbsp;{{round($total-$total_discount,2)}}  @lang('currency.'.($sales->currency)) <br>

                                @if(systemConfig()[30] == 1)
                                @if($sales->currency != getReportCurrency())
                                    مجموع  دالر: {{round($total-$total_discount,2)/ $currencySR * $sales->rate}}
                                @endif
                                @else 
                                @if($sales->currency != getReportCurrency())
                                    مجموع  دالر: {{round($total-$total_discount,2)/$sales->rate}}
                                @endif
                                @endif
                            </b></div>
                    </td>


                </tr>


                <tr>
                @if($sales->type == "Invoice")
                @if($sales->hesab_sabeqa =="ok")
                @if(getHesabSabeqahType()=="base_currency" || getHesabSabeqahType()==null)

                <td >
                    @if(getHesabSabeqa() =='true')
                    <div class="center"><b>@lang('layout.HesabSabiqa'): &nbsp;
                        @if($sales->type == "Invoice")
                        @if(systemConfig()[30] == 1)
                        {{myRound($balance - (($total+$taxationAmount-$discountToShow) -$paid)/ $currencySR * $sales->rate)}}  @lang('currency.'.(getHomeCurrency()["code"]))
                        @else 
                        {{myRound($balance - (($total+$taxationAmount-$discountToShow) -$paid)/$sales->rate)}}  @lang('currency.'.(getHomeCurrency()["code"]))
                        @endif
                        @endif
                        </b>
                    </div>

                </td>

                <td >
                    <div class="center"><b>@lang('layout.AmountPayable'):&nbsp;
                            @if($sales->type =="Invoice")
                            @if(systemConfig()[30] == 1)
                            {{myRound(((($balance * $currencySR / $sales->rate)-($total+$taxationAmount)+$discountToShow)+$paid)+($total + $taxationAmount - $discountToShow - $paid))}} @lang('currency.'.($sales->currency))
                            @else 
                            {{myRound(((($balance * $sales->rate)-($total+$taxationAmount)+$discountToShow)+$paid)+($total + $taxationAmount - $discountToShow - $paid))}} @lang('currency.'.($sales->currency))
                            @endif
                            @endif
                        </b></div>
                </td>


                @endif
                @endif
                @endif
                @endif

                @if($sales->type == "Invoice")
                @if($sales->hesab_sabeqa =="ok")
                @if(getHesabSabeqahType()=="currency")
                <td >
                    @if(getHesabSabeqa() =='true')
                    <div class="center"><b>@lang('layout.HesabSabiqa'): &nbsp;
                        @if($sales->type == "Invoice")
                        {{myRound(($balance-$total-$taxationAmount+$discountToShow)+$paid)}} @lang('currency.'.($sales->currency))
                        @endif
                        </b>
                    </div>

                </td>

                <td >
                    <div class="center"><b>@lang('layout.AmountPayable'):&nbsp;
                            @if($sales->type =="Invoice")
                            {{myRound((($balance-$total-$taxationAmount+$discountToShow)+$paid)+($total+$taxationAmount - $discountToShow -$paid))}} @lang('currency.'.($sales->currency))
                            @endif
                        </b></div>
                </td>
                @endif
                @endif
                @endif
                @endif

                </tr>

            </table>
            @if($invoice_des)
                <table width="60%" border="1" style="border-collapse: collapse; margin-top: 7px;">
                    <tr>
                        <td style="font-size: 14px;">{{$invoice_des}}</td>
                    </tr>
                </table>
            @endif

            @if(company()['invoice_message'])
                <table width="100%">
                    <tr>
                        <td style="font-size: 14px;">{!!company()['invoice_message']!!}</td>
                    </tr>

                    <tr>
                        <td></td>
                        <td></td>
                    </tr>


                </table>
        @endif
        <!--End Table 4 For Total  Information-->

          


        </div>

    </div>

    </div>

    @if(getDriverInfo()=="true")
        @if($d_info)
            <!--Driver Info-->

            <table style="width: 100%; margin-top: 10px;">
                <tr>
                    <td style="text-align: left; width:40%">
                        <table class="main-table">

                            <tr style="font-weight: bold; font-size: 17px">
                                <td align="right"><b>@lang('layout.TransferCode')</b></td>
                                <td align="right"><b>{{$d_info->transferCode}}</b></td>
                            </tr>
                            <tr>
                                <td align="right"><b>@lang('layout.Transporter_name')</b></td>
                                <td align="right"><b>{{$d_info->driver}}</b></td>
                            </tr>
                            <tr>
                                <td align="right"><b>@lang('layout.Transporter_phone')</b></td>
                                <td align="right"><b>{{$d_info->driverPhone}}</b></td>
                            </tr>
                            <tr>
                                <td align="right"><b>@lang('layout.PlaceOfWeight')</b></td>
                                <td align="right"><b>{{$d_info->PlaceOfWeight}}</b></td>
                            </tr>
                            <tr>
                                <td align="right"><b>@lang('layout.SourcePlace')</b></td>
                                <td align="right"><b>{{$d_info->sourcePlace}}</b></td>
                            </tr>
                            <tr>
                                <td align="right"><b>@lang('layout.PlateNumber')</b></td>
                                <td align="right"><b>{{$d_info->plateNumber}}</b></td>

                            </tr>


                        </table>
                    </td>

                    <td style="text-align: right; width:40%">
                        <table class="main-table">

                            <tr style="font-weight: bold; font-size: 17px">
                                <td align="right"><b>@lang('layout.WayBillNumber')</b></td>
                                <td align="right"><b>{{$d_info->wayBillNumber}}</b></td>
                            </tr>
                            <tr>
                                <td align="right"><b>@lang('layout.TotalWeight')</b></td>
                                <td align="right"><b>{{$d_info->totalWeight}}</b></td>
                            </tr>
                            <tr>
                                <td align="right"><b>@lang('layout.EmptyCarWeight')</b></td>
                                <td align="right"><b>{{$d_info->emptyCarWeight}}</b></td>
                            </tr>
                            <tr>
                                <td align="right"><b>@lang('layout.TotalBori')</b></td>
                                <td align="right"><b>{{$d_info->bori}}</b></td>
                            </tr>
                            <tr>
                                <td align="right"><b>@lang('layout.Description')</b></td>
                                <td align="right"><b>{{$d_info->trDesription}}</b></td>
                            </tr>

                        </table>
                    </td>
                </tr>
            </table>
          

            <!--End Driver Info-->
        @endif
    @endif


  <!--  signature -->
            <table style="width: 100%" class="signtable">
                <tr>
                    @foreach(getCompanyInfo('sign','invoice') AS $info)
                    <td style="text-align: left; width:40%">
                        <table >
                           
                            <tr>
                                <td align="right" class="signsize">{{$info['name']}}</td>
                            </tr>
                            
                        </table>
                    </td>
                     @endforeach
                </tr>
            </table>
             <!-- End signature -->

    <script type="text/javascript">
        window.print();
    </script>
@endsection


