@extends('layouts.factor-master-print')
@section('style')
<style>
    .small-table td,
    .main-table td,
    .main-table tr,
    .small-table th,
    .main-table th {}
    .t1 {
        font-size: 14px;
        font-weight: bold;
        background-color: { {company()['color']}};
    }
</style>
@stop
@section('content')
<?php
    $b = 1;
    $data_all = getCopyNumberFactor();
?>
@foreach($data_all AS $d_all)
    @if(autoPrintPreview()=="true")
        @if(getFactorLayout()=="rtl")
            <div style="direction: rtl">
        @else
            <div>
        @endif
    @else
<div>
    @endif
    <div style=" font-size: 12px !important">
        <!--Table 2 For Customer Information-->
        <table style="width: 100%;">
            <tr>
                @if(getInvoiceReferenceNo()=="true")
                <td style="text-align: center; width:30%">
                    @else
                <td style="text-align: center; width:20%">
                    @endif
                    <table class="main-table">
                        <tr>
                            @if(getInvoiceReferenceNo()=="true" && $sale_order_info)
                            <td align="center" colspan="5">
                                <b style="font-size: 20px;">@lang('layout.Invoice')</b>
                            </td>
                            @elseif(getInvoiceReferenceNo()=="true" || $sale_order_info)
                            <td align="center" colspan="4">
                                <b style="font-size: 20px;">@lang('layout.Invoice')</b>
                            </td>
                            @else
                            <td align="center" colspan="3">
                                <b style="font-size: 20px;">@lang('layout.Invoice')</b>
                            </td>
                            @endif 
                        </tr>

                        <tr>
                            <td align="center"><b>@lang('layout.InvoiceNumber')</b></td>
                            @if(getInvoiceReferenceNo()=="true")
                            <td align="center"><b>@lang('layout.ReferenceNumber')</b></td>
                            @endif
                            @if($sale_order_info)
                            <td align="center"><b>@lang('layout.SONumber')</b></td>
                            @endif
                            <td align="center"><b>@lang('layout.Date')</b></td>
                            <td align="center"><b>@lang('layout.Hour')</b></td>
                        </tr>
                        <?php
                        $str_date = convertdate($sales->date);



                        $date_string = substr($str_date, 0, 10);
                        ?>
                        <tr>
                            <td align="center"><b>{{$sales->number}} </b></td>
                            @if(getInvoiceReferenceNo()=="true")
                            <td align="center"><b>{{$sales->ref_no}}</b></td>
                            @endif
                            @if($sale_order_info)
                            <td align="center"><b>{{$sale_order_info->number}}</b></td>
                            @endif
                            <td align="center"><b>
                                    @if(getInvoiceDateFormat() == "shamsi")
                                    <?php
                                    $str_date = convertdate($sales->date, 0, 'jalali');

                                    $date_string = substr($str_date, 0, 10)
                                    ?>
                                    {{$date_string}}

                                    @elseif(getInvoiceDateFormat() =='both')

                                    <?php
                                    $str_date = convertdate($sales->date, 0, 'jalali');

                                    $date_string = substr($str_date, 0, 10);
                                    echo $date_string;
                                    ?>
                                    &nbsp;/&nbsp;
                                    {{substr($sales->date,0,10)}}

                                    @elseif(getInvoiceDateFormat() =="meladi")
                                    {{substr($sales->date,0,10)}}

                                    @else

                                    {{$str_date}}

                                    @endif
                                </b></td>
                            <td align="center"><b><?php echo Date('h:i A', strtotime($sales->date)); ?></b></td>
                        </tr>
                    </table>
                </td>
                @if(getInvoiceReferenceNo()=="true")
                <td width="30%"></td>
                @else
                <td width="40%"></td>
                @endif
                <td style="text-align: center; width:40%">
                    @if(getBankNumberInvoice()=="true")
                    <table>
                        <tr>
                            <td colspan="3" align="center">
                                <b style="font-size: 20px;">{!!company()['bank']!!}</b>
                            </td>

                        </tr>
                    </table>
                    @endif

                </td>
            </tr>
        </table>
        <!--End Table 2 For Invoice Information-->

        <table style="width: 100%; margin-top: 10px;">
            <tr>
                <td style=" width:40%">
                    <table class="main-table">
                        <tr>
                            <td align="center" colspan="2">
                                <b>@lang('layout.BillTo')</b>
                            </td>

                        </tr>
                        <tr>
                            <td ><b>@lang('layout.Name')</b></td>
                            <td ><b>
                                    @if(getDescriptionASMemberName()=="true" && $other_member_name!="")
                                    {{$other_member_name}}
                                    @else
                                    {{$member->name}}
                                    @endif
                                </b></td>
                        </tr>
                        <tr>
                            <td ><b>@lang('layout.Code')</b></td>
                            <td ><b>{{$member->code}}</b></td>
                        </tr>
                    </table>
                </td>

                <td width="20%"></td>
                <td style=" width:30%">
                    <table class="main-table">
                        <tr>
                            <td align="center" colspan="2"><b>@lang('layout.ShipTo')</b></td>
                        </tr>
                        <tr>
                            <td width="25%" ><b>@lang('layout.Address')</b></td>
                            <td ><b>{{$address.' '.$city}}</b></td>
                        </tr>
                        <tr>
                            <td ><b>@lang('layout.Phone')</b></td>
                            <td ><b>{{$phone}}</b></td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>


        <!--Table 3 For Data  Information-->
        <table class="main-table" style="margin-top: 20px;" cellpadding="5px">


            <tr style="font-weight: bold; font-size: 17px">
                <td class="mt">
                    <div class="center">@lang('layout.Number')</div>
                </td>
                <!--<td class="mt"><div class="center">@lang('layout.ItemCode')</div></td>-->
                @if(getSerailNumber() =="true")
                <td class="mt">
                    <div class="center">@lang('layout.SerialNum')</div>
                </td>
                @endif
                <td class="mt">
                    <div class="center">@lang('layout.Item')</div>
                </td>
                @if(getGauge() =="true")
                <td class="mt">
                    <div class="center">@lang('layout.Gauge')</div>
                </td>
                @endif
                @if(getItemImage()=="true")
                <td class="mt">
                    <div class="center">@lang('layout.ItemImage')</div>
                </td>
                @endif
                @if(getItemOtherName()=="true")
                <td class="mt">
                    <div class="center">@lang('layout.ItemOtherName')</div>
                </td>
                @endif
                @if(getInventoryBrand()=="true")
                <td class="mt">
                    <div class="center">@lang('layout.Brand')</div>
                </td>
                @endif
                @if(getInventorySite()=="true")
                <td class="mt">
                    <div class="center">@lang('layout.Site')</div>
                </td>
                @endif
                <td class="mt">
                    <div class="center">@lang('layout.Quantity')</div>
                </td>
                <td class="mt">
                    <div class="center">@lang('layout.Unit/M')</div>
                </td>
                @if(getOtherMeasure()=="true")
                <td class="mt">
                    <div class="center">@lang('layout.OtherMeasure')</div>
                </td>
                @endif
                @if(getOtherMeasure2()=="true")
                <td class="mt">
                    <div class="center">@lang('layout.OtherMeasure2')</div>
                </td>
                @endif
                @if(systemConfig()[7] != 0)
                @if(getShowLoadingDetail() == "true")
                <td class="mt">
                    <div class="center">@lang('layout.TransitNumber')</div>
                </td>
                <td class="mt">
                    <div class="center">@lang('layout.WayBillNumber')</div>
                </td>
                <td class="mt">
                    <div class="center">@lang('layout.SourcePlace')</div>
                </td>
                <td class="mt">
                    <div class="center">@lang('layout.Destination')</div>
                </td>
                @endif
                <td class="mt">
                    <div class="center">@lang('layout.Driver')</div>
                </td>
                <td class="mt">
                    <div class="center">@lang('menu.Vehicle')</div>
                </td>
                @endif
                @if(getM2()!="")
                @if(getFactorMeasure2()=="true")
                <td class="mt">
                    <div class="center">@lang('layout.Measure2')</div>
                </td>
                @endif
                @endif
                @if(getM3()!="")
                @if(getFactorMeasure3()=="true")
                <td class="mt">
                    <div class="center">@lang('layout.Measure3')</div>
                </td>
                @endif
                @endif
                @if(getM4()!="")
                @if(getFactorMeasure4()=="true")
                <td class="mt">
                    <div class="center">@lang('layout.Measure4')</div>
                </td>
                @endif
                @endif
                @if(getmine() == 'true')
                <td class="mt">
                    <div class="center">@lang('layout.LaboratoryPercentage')</div>
                </td>
                <td class="mt">
                    <div class="center">@lang('layout.PerPercentPrice')</div>
                </td>
                @endif
                <td class="mt">
                    <div class="center">@lang('layout.Rate')</div>
                </td>

                @if(oilSale() == 'true')
                <th class="mt">
                    <div class="center">@lang('layout.Density')</div>
                </th>
                <th class="mt">
                    <div class="center">@lang('layout.OilQuantity')</div>
                </th>
                <th class="mt">
                    <div class="center">@lang('layout.Price')</div>
                </th>
                @endif

                @if(getSaleDiscount()=="true" && $sales->show_discount !="ok")
                <td class="mt">
                    <div class="center">@lang('layout.Sub-Total')</div>
                </td>
                <td class="mt">
                    <div class="center">@lang('layout.Discount')</div>
                </td>
                @endif
                <td class="mt">
                    <div class="center">@lang('layout.Total')</div>
                </td>
                @if(getSaleDescription()=="true")
                <td class="mt">
                    <div class="center">@lang('layout.Description')</div>
                </td>
                @endif
                @if(getSaleDescription2()=="true")
                <td class="mt">
                    <div class="center">@lang('layout.Description') 2 </div>
                </td>
                @endif

            </tr>
            <?php
                // dd($data);
                $count = 0;
                $empty = 0;
                $fullCount = count($data);
                $total_discount = 0;
                $total_discount_per_item = 0;
                $totalQty = 0;
                $measure_total = [];
                $totalQty1 = 0;
                $measure_total1 = [];
                $totalOMeasureQty = 0;
                $OMeasure_total = [];
                if ($transportCompany->driver_name || $transportCompany->trasnport_name != null) {
                    if ($fullCount < 10) {
                        $empty = 10 - $fullCount;
                    }
                } else {
                    if ($fullCount < 12) {
                        $empty = 12 - $fullCount;
                    }
                }
            ?>
            @foreach($data AS $key1=>$record)
                <?php
                    // dd($record['sale_measure1']['symbol'] , $record['qty1_amount']);
                    if ($sales->discount_type == "currency") {
                        $total_discount += $record['discount'] * $record['qty'];
                    } else {
                        $t = ($record['price'] * $record['qty']);
                        $total_discount += ($record['discount']) * $t / 100;
                    }
                    //Total Items
                    if (array_key_exists($record['symbol'], $measure_total)) {
                        $measure_total[$record['symbol']] = $measure_total[$record['symbol']] + $record['qty'];
                    } else {
                        $measure_total[$record['symbol']] = $record['qty'];
                    }
                    $totalQty += $record['qty'];
                    //Total measure1
                    if ($record['qty1_amount'] > 0) {
                        if (array_key_exists($record['sale_measure1']['symbol'], $measure_total1)) {
                            $measure_total1[$record['sale_measure1']['symbol']] = $measure_total1[$record['sale_measure1']['symbol']] + $record['qty1_amount'];
                        } else {
                            $measure_total1[$record['sale_measure1']['symbol']] = $record['qty1_amount'];
                        }
                        $totalQty1 += $record['qty1_amount'];
                    }
                    // simpleRound($record['other_measure'])}} {{$record['o_measure_name']}}
                    //Total measure1
                    if ((double)$record['other_measure'] > 0 && getOtherMeasure()=="true") {
                        if (array_key_exists($record['o_measure_name'], $OMeasure_total)) {
                            $OMeasure_total[$record['o_measure_name']] = $OMeasure_total[$record['o_measure_name']] + $record['other_measure'];
                        } else {
                            $OMeasure_total[$record['o_measure_name']] = $record['other_measure'];
                        }
                        $totalOMeasureQty += $record['other_measure'];
                    }

                ?>
            <tr>
                <td class="center">{{++$count}}</td>
                <!--<td class="center">{{$record['number']}}</td>-->
                @if(getSerailNumber() =="true")
                <td class="center">{{$record['number']}}</td>
                @endif
                <td class="center">{{$record['name']}}</td>
                @if(getGauge() =="true")
                <td class="center">{{$record['gauge']}}</td>
                @endif
                @if(getItemImage()=="true")
                <td class="center" style="margin: 0px;padding: 0px;">
                    @if($record['sImage'])
                    {{-- <img alt="" style="height: 80px;width: 80px;" class="img-circle" src="{{asset('uploads/items/'.$record['image'])}}" /> --}}
                    <img alt="" style="height: 80px;width: 80px;" class="img-circle" src="{{asset('uploads/invoices/'.$record['sImage'])}}" />
                    @else 
                    @if($record['image'])
                    <img alt="" style="height: 80px;width: 80px;" class="img-circle" src="{{asset('uploads/items/'.$record['image'])}}" />
                    @endif
                    @endif
                </td>
                @endif
                @if(getItemOtherName()=="true")
                <td class="center">{{$record['item_other_name']}}</td>
                @endif
                @if(getInventoryBrand()=="true")
                <td class="center">{{$record['inventoryBrand']}}</td>
                @endif
                @if(getInventorySite()=="true")
                <td class="center">{{$record['siteName']}}</td>
                @endif
                <td class="center">{{$record['qty']}}</td>
                <td class="center">{{$record['symbol']}}</td>
                @if(getOtherMeasure()=="true")
                <td class="center">{{simpleRound($record['other_measure'])}} {{$record['o_measure_name']}}</td>
                @endif
                @if(getOtherMeasure2()=="true")
                <td class="center">{{simpleRound($record['other_measure2'])}} {{$record['o_measure_name2']}}</td>
                @endif
                @if(systemConfig()[7] != 0)
                @if(getShowLoadingDetail() == "true")
                <td class="center">{{$record['transit_number']}}</td>
                <td class="center">{{$record['cmr_number']}}</td>
                <td class="center">{{$record['source']}}</td>
                <td class="center">{{$record['destination']}}</td>
                @endif
                <td class="center">{{$record['driver_name']}}</td>
                <td class="center">{{$record['vehicle_name']}}</td>
                @endif
                @if(getM2()!="")
                @if(getFactorMeasure2()=="true")
                <td class="center">{{$record['qty1']}}</td>
                @endif
                @endif
                @if(getM3()!="")
                @if(getFactorMeasure3()=="true")
                <td class="center">{{$record['qty2']}}</td>
                @endif
                @endif
                @if(getM4()!="")
                @if(getFactorMeasure4()=="true")
                <td class="center">{{$record['qty3']}}</td>
                @endif
                @endif
                @if(getmine() == 'true')
                <td class="center">{{simpleRound($record['laboratory_percentage'])}}</td>
                <td class="center">{{simpleRound($record['per_percent_price'])}}</td>
                @endif
                <td class="center">{{simpleRound($record['price'])}} {{$sales->currency}}</td>
                @if(oilSale() == 'true')
                <td class="center">{{simpleRound($record['density'])}}</td>
                <td class="center">{{simpleRound($record['oil_qty'])}} @if($record['sale_measure3']) {{$record['sale_measure3']['symbol']}} @endif</td>
                <td class="center">{{simpleRound($record['oilPrice'])}}</td>
                @endif

                @if(getSaleDiscount()=="true" && $sales->show_discount !="ok")
                <td class="center">{{ simpleRound($record['price']*$record['qty'])}} {{$sales->currency}}</td>
                <td class="center">{{$record['discount']}} {{($sales->discount_type=="percent")? '%' : $sales->currency}}</td>
                @endif
                <!-- <td class="center">{{ Currency()->format($record['price']*$record['qty'],$sales->currency)}}</td> -->

                @if($sales->discount_type=="currency")
                <td class="center">{{ simpleRound(($record['price']*$record['qty'])-$record['discount']*$record['qty'])}} {{$sales->currency}}</td>
                @else
                <td class="center">{{ simpleRound(($record['price']*$record['qty'])-($record['discount']*$record['price']/100)*$record['qty'])}} {{$sales->currency}}</td>
                @endif
                @if(getSaleDescription()=="true")
                <td class="center">{{$record['description']}}</td>
                @endif
                @if(getSaleDescription2()=="true")
                <td class="center">{{$record['description2']}}</td>
                @endif
            </tr>



            @endforeach

            @for($i=0;$i<$empty;$i++) <?php ?> 
            @if(getPaperSize()=='A4' && getPaperStyle()=='portrait' ) 
            @if(getWhiteRows()=="true" ) 
            <tr>
                <td class="center" style="height: 30px"></td>
                @if(getSerailNumber() =="true")
                <td class="center"></td>
                @endif
                <td class="center"></td>
                @if(getGauge() =="true")
                <td class="center"></td>
                @endif
                @if(getItemImage()=="true")
                <td class="center"></td>
                @endif
                @if(getItemOtherName()=="true")
                <td class="center"></td>
                @endif
                <td class="center"></td>
                @if(getInventoryBrand()=="true")
                <td class="center"></td>
                @endif
                @if(getInventorySite()=="true")
                <td class="center"></td>
                @endif
                <td class="center"></td>
                @if(getOtherMeasure()=="true")
                <td class="center"></td>
                @endif
                @if(getOtherMeasure2()=="true")
                <td class="center"></td>
                @endif
                @if(systemConfig()[7] != 0)
                @if(getShowLoadingDetail() == "true")
                <td class="center"></td>
                <td class="center"></td>
                <td class="center"></td>
                <td class="center"></td>
                @endif
                <td class="center"></td>
                <td class="center"></td>
                @endif

                @if(getM2()!="")
                @if(getFactorMeasure2()=="true")
                <td class="center"></td>
                @endif
                @endif
                @if(getM3()!="")
                @if(getFactorMeasure3()=="true")
                <td class="center"></td>
                @endif
                @endif
                @if(getM4()!="")
                @if(getFactorMeasure4()=="true")
                <td class="center"></td>
                @endif
                @endif
                @if(getSaleDescription()=="true")
                <td class="center"></td>
                @endif
                @if(getSaleDescription2()=="true")
                <td class="center"></td>
                @endif
                @if(getmine() == 'true')
                <td class="center"></td>
                <td class="center"></td>
                @endif
                @if(oilSale() == 'true')
                <td class="center"></td>
                <td class="center"></td>
                <td class="center"></td>
                @endif
                <td class="center"></td>
                @if(getSaleDiscount()=="true" && $sales->show_discount !="ok")
                <td class="center"></td>
                <td class="center"></td>
                @endif
                @if(getFactorOtherMeasure() =="true")
                <td class="center"></td>
                <td class="center"></td>
                @endif
                <td class="center"></td>
            </tr>
            @endif
            @endif
            @endfor
            <?php
            if ($sales->discount_type == "currency") {
                echo simpleRound($discountToShow);
            } else {
                echo simpleRound($discountToShow) . '%';
            }
            $discountTotal = 0;
            foreach ($data as $key => $value) {
                $discountTotal = ($value['discount'] * $value['qty']) + $discountTotal;
            }

            ?>
        </table>

 

        <!--Begin Total Item Quantity--> 
        @if(getTotalItemQuantity()!='' ||getTotalItemQuantity()!="defualt")
        @if(getTotalItemQuantity() == "per_unit")
        
        <table class="main-table">
            <tr>
                <td  colspan="2"><b>@lang('layout.TotalQuantity')</b></td>
            </tr>
            @foreach($measure_total AS $key=>$measure)
            <tr>  
                <td ><b>{{$measure}}</b></td>
                <td ><b>{{$key}}</b></td>
            </tr>
            @endforeach
            
            @if($measure_total1 && getM2()!="" && getFactorMeasure2()=="true")
            <tr>
            <td  colspan="2"><b>@lang('layout.TotalMeasure2')</b></td>
            </tr>
            @foreach($measure_total1 AS $key=>$measure)
            <tr>
                <td ><b>{{$measure}}</b></td>
                <td ><b>{{$key}}</b></td>
            </tr>
            @endforeach
            @endif

            @if($OMeasure_total && getOtherMeasure()=="true")
            <tr>
            <td  colspan="2"><b>@lang('layout.OtherMeasure')</b></td>
            </tr>
            @foreach($OMeasure_total AS $key=>$measure)
            <tr>
                <td ><b>{{$measure}}</b></td>
                <td ><b>{{$key}}</b></td>
            </tr>
            @endforeach
            @endif

        </table>
        @endif
        @if(getTotalItemQuantity() == "all_unit") 
        <table class="main-table">
            <tr>
                <td ><b>@lang('layout.TotalQuantity')</b></td>
                <td ><b>{{$totalQty}}</b></td>
            </tr>
            @if($totalQty1 > 0 && getM2()!="" && getFactorMeasure2()=="true")
            <tr>
                <td ><b>@lang('layout.TotalQuantity') @lang('layout.Measure2')</b></td>
                <td ><b>{{$totalQty1}}</b></td>
            </tr>
            @endif   
            @if($totalOMeasureQty > 0 && getOtherMeasure()=="true")
            <tr>
                <td ><b>@lang('layout.TotalQuantity') @lang('layout.OtherMeasure')</b></td>
                <td ><b>{{$totalOMeasureQty}}</b></td>
            </tr>
            @endif    
        </table>
        @endif 
        @endif








        <!--End Total Item Quantity-->
        @if(getSubTotal() == 'true' && $sub_total_amount > 0 && $sales->show_discount !="ok")
        <table width="100%" class="main-table" style="margin-top: 0px;" cellpadding="5px">
            <tr>
                <td class="mt center">
                    <div>@lang('layout.Sub-Total')</div>
                </td>
                <td class="mt center">
                    <div>@lang('layout.Discount')</div>
                </td>
                <td class="mt center">
                    <div>@lang('layout.Total')</div>
                </td>
            </tr>
            <tr>
                <td class="center" colspan="1">{{simpleRound($sub_total_amount)}}</td>
                <td class="center" colspan="1">{{simpleRound((($discount * ($sub_total_amount - $sub_inventory_discount_total)) / 100) + $sub_inventory_discount_total)}}</td>
                <td class="center" colspan="1">{{simpleRound($sub_total_amount - $sub_inventory_discount_total - (($discount * ($sub_total_amount - $sub_inventory_discount_total)) / 100))}}</td>
            </tr>
        </table>
        @endif

        <!--End Table 3 For Data Information--> 

        <!--Table 3 For Payment  Information-->

        @if(getInvoicePayment()== "true")
        @if(count($invoice_payment)>0)
        <table width="100%" class="main-table" style="margin-top: 20px;" cellpadding="5px">

            <tr style="font-weight: bold;">
                <td class="mt" colspan="5">
                    <div class="center" style="font-size: 20px;font-weight: bold;">@lang('layout.Payment')</div>
                </td>
            </tr>

            <tr style="font-weight: bold; font-size: 17px">
                <td class="mt">
                    <div class="center">@lang('layout.Number')</div>
                </td>
                <td class="mt">
                    <div class="center">@lang('layout.Description')</div>
                </td>
                <td class="mt">
                    <div class="center">@lang('layout.Amount')</div>
                </td>
                <td class="mt">
                    <div class="center">@lang('layout.Currency')</div>
                </td>
                <td class="mt">
                    <div class="center">@lang('layout.Rate')</div>
                </td>
            </tr> 
            <?php 
            $count = 0;
            $total_payments = 0; 
            ?>
            @foreach($invoice_payment AS $key2=>$payment)
            
            <?php   
                if(systemConfig()[30] == 1){
                    $total_payments += (($payment['amount'] / $currencySR * $payment['rate']) * $currencySR)  / $sales->rate ; 
                }else{
                    $total_payments += $payment['amount'] * $sales->rate / $payment['rate']; 
                }
            ?> 

            <tr>
                <td class="center">{{++$count}}</td>
                <td class="center">{{$payment['description']}}</td>
                <td class="center">{{simpleRound($payment['amount'])}}</td>
                <td class="center">{{$payment['currency']}}</td>
                <td class="center">{{$payment['rate']}}</td>
            </tr>

            @endforeach
            <?php $total = $total_payments + $total; ?>
        </table>
        @endif
        @endif
        <!--End Table 3 For Payment Information-->

        
        <!--Table 4 For receive  Information-->
        @if($sale_receives)
        @if(count($sale_receives)>0)
        <table width="100%" class="main-table" style="margin-top: 20px;" cellpadding="5px">

            <tr style="font-weight: bold;">
                <td class="mt" colspan="5">
                    <div class="center" style="font-size: 20px;font-weight: bold;">@lang('layout.Receive')</div>
                </td>
            </tr>

            <tr style="font-weight: bold; font-size: 17px">
                <td class="mt">
                    <div class="center">@lang('layout.Number')</div>
                </td>
                <td class="mt">
                    <div class="center">@lang('layout.Description')</div>
                </td>
                <td class="mt">
                    <div class="center">@lang('layout.Amount')</div>
                </td>
                <td class="mt">
                    <div class="center">@lang('layout.Currency')</div>
                </td>
                <td class="mt">
                    <div class="center">@lang('layout.Rate')</div>
                </td>
            </tr>

            @foreach($sale_receives AS $key2=>$payment)
            <tr>
                <td class="center">{{$payment['number']}}</td>
                <td class="center">{{$payment['description']}}</td>
                <td class="center">{{simpleRound($payment['balance'])}}</td>
                <td class="center">{{$payment['unit']}}</td>
                <td class="center">{{$payment['rate']}}</td>

            </tr>
            @endforeach
        </table>
        @endif
        @endif
        <!--End Table 3 For receive Information-->

        <!-------------------------------------------------------------------------------------------------------
              - --- Table 4 For Total  Information        ---------------------------------------------------------
            --------------------------------------------------------------------------------------------------------->
        @if(getFactorTotal()==null || getFactorTotal()=="default")
        <table class="main-table" style="margin-top: 4px;">
            
            @if(getSaleDiscount()=="true")

            <!-- <tr>
                        <td colspan="6">
                            @if(App::isLocale('fa') || App::isLocale('pa'))
                                <div class="center" style="font-size: bold;"><b>@lang('layout.SubTotalInLeters')
                                    :&nbsp; {{notowo(abs(round($total)),'fa')}}</b></div>

                            @else
                                    <div class="center" style="font-size: bold;"><b>@lang('layout.SubTotalInLeters')
                                    :&nbsp; {{notowo(abs(round($total)),'en')}}</b></div>
                            @endif

                        </td>

                        <td colspan="6">
                            <div class="center" style="font-size: bold;"><b>@lang('layout.Sub-Total')
                                    :&nbsp;{{simpleRound($total)}}  @lang('currency.'.($sales->currency)) <br>

                                    @if($sales->currency != getReportCurrency())
                                        مجموع  دالر: {{simpleRound(($total)/$sales->rate)}}
                                    @endif
                                </b></div>
                        </td>


                    </tr> -->
            @endif


            <tr>
                <td colspan="4">
                    @if(getFactorLang()=='fa')
                    <div class="center" style="font-size: bold;"><b>@lang('layout.TotalInLeters')
                            :&nbsp; {{notowo(abs(round($total+$taxationAmount+$commissionAmount)),'fa')}}</b></div>
                    @elseif(getFactorLang()=='pa')
                    <div class="center" style="font-size: bold;"><b>@lang('layout.TotalInLeters')
                            :&nbsp; {{notowo(abs(round($total+$taxationAmount+$commissionAmount)),'pa')}}</b></div>
                    @else
                    <div class="center" style="font-size: bold;"><b>@lang('layout.TotalInLeters')
                            :&nbsp; {{notowo(abs(round($total+$taxationAmount+$commissionAmount)),'en')}}</b></div>
                    @endif
                </td>

                <td colspan="2">
                    @if($sales->type == "Invoice" || $sales->type == "saleByType" || $sales->type == "ProjectInvoice")
                    <div class="center">@lang('layout.Recipt'):&nbsp;
                        {{simpleRound($paid)}} @lang('currency.'.($sales->currency))
                    </div>
                    @endif
                </td>
                @if(getTaxation()=="true")
                <td colspan="2">
                    <div class="center">@lang('menu.Taxation'):&nbsp;
                        {{simpleRound($taxationAmount)}} @lang('currency.'.($sales->currency))
                    </div>
                </td>
                @endif
                @if(getSaleCommission()=="true")
                <td colspan="2">
                    <div class="center">@lang('layout.Commission'):&nbsp;
                        {{simpleRound($commissionAmount)}} @lang('currency.'.($sales->currency))
                    </div>
                </td>
                @endif
                <td colspan="4">
                    <div class="center" style="font-size: bold;"><b>@lang('layout.Total')
                        @if(systemConfig()[30] == 1)
                            :&nbsp;{{simpleRound($total+$taxationAmount+$commissionAmount)}} @lang('currency.'.($sales->currency)) <br>
                        @else 
                            :&nbsp;{{simpleRound($total+$taxationAmount+$commissionAmount)}} @lang('currency.'.($sales->currency)) <br>
                        @endif
                            
                            @if(equivalentToBaseUnit()!='false' && $sales->currency != getReportCurrency())
                            @if(systemConfig()[30] == 1)
                            @lang('layout.EquivalentTo')  @lang('currency.'.(getHomeCurrency()["code"])): {{simpleRound(($total)/$currencySR * $sales->rate)}}
                            @else 
                            @lang('layout.EquivalentTo')  @lang('currency.'.(getHomeCurrency()["code"])): {{simpleRound(($total)/$sales->rate)}}
                            @endif
                            @endif
                        </b>
                    </div>
                </td>


            </tr>
        </table>
        <table class="main-table" style="margin-top: 0px;">
            <tr> 
                @if($sales->show_discount !="ok")
                <td colspan="3">
                    <div class="center">@lang('layout.Discount'):&nbsp;
                        <span>
                            @if($sales->discount_type=="currency")
                            {{simpleRound(($discountToShow))}} @lang('currency.'.($sales->currency))
                            @else
                            {{simpleRound($discountToShow)}} @lang('currency.'.($sales->currency))
                            @endif
                        </span>

                    </div>
                </td>
                @endif
                @if(getTransferRent()=="true" && $transfer_rent_amount && $transfer_rent_amount>0)
                <td colspan="3">
                    <div class="center">@lang('layout.TransferRent'):&nbsp;
                        <span>
                            {{simpleRound($transfer_rent_amount)}} @lang('currency.'.($sales->currency))
                        </span>

                    </div>
                </td>
                @endif

                <td colspan="3">
                    @if($sales->type == "Invoice" || $sales->type == "saleByType" || $sales->type == "ProjectInvoice")
                    <div class="center">@lang('layout.Remined'):&nbsp;
                        {{simpleRound((($total+$taxationAmount+$commissionAmount+$transfer_rent_amount-$discountToShow) -$paid))}} @lang('currency.'.($sales->currency))
                    </div>
                    @endif
                </td>
                <!-------------------- ----------------------------------------------------------------------------------
                ---------------Begin Hesab Sabeqah-----------------------------------------------------------------------
                --------------------------------------------------------------------------------------------------------->
                <?php 
                ?>
                @if($sales->type == "Invoice" || $sales->type == "saleByType" || $sales->type == "ProjectInvoice")
                @if($sales->hesab_sabeqa =="ok" || $sales->type == "saleByType" || $sales->type == "ProjectInvoice")
                @if(getHesabSabeqahType()=="base_currency" || getHesabSabeqahType()==null) 
                <td colspan="3">
                    @if(getHesabSabeqa() =='true')
                    <div class="center">@lang('layout.HesabSabiqa'): &nbsp;
                        @if($sales->type == "Invoice" || $sales->type == "saleByType" || $sales->type == "ProjectInvoice")
                        @if(systemConfig()[30] == 1)
                        {{simpleRound($balance - (($total+$taxationAmount+$commissionAmount+$transfer_rent_amount-$discountToShow) -$paid)/ $currencySR * $sales->rate)}} {{getHomeCurrency()["code"]}}
                        @else 
                        {{simpleRound($balance - (($total+$taxationAmount+$commissionAmount+$transfer_rent_amount-$discountToShow) -$paid)/$sales->rate)}} {{getHomeCurrency()["code"]}}
                        @endif 
                        @endif
                    </div> 
                </td>  

                <td colspan="1">
                    <div class="center"><b>@lang('layout.AmountPayable'):&nbsp;
                            @if($sales->type =="Invoice" || $sales->type == "saleByType" || $sales->type == "ProjectInvoice")
                            @if(systemConfig()[30] == 1)
                            {{simpleRound(((($balance * $currencySR / $sales->rate)-($total+$taxationAmount+$commissionAmount+$transfer_rent_amount)+$discountToShow)+$paid)+($total + $taxationAmount+$commissionAmount+$transfer_rent_amount - $discountToShow - $paid))}} @lang('currency.'.($sales->currency))
                            @else 
                            {{simpleRound(((($balance * $sales->rate)-($total+$taxationAmount+$commissionAmount+$transfer_rent_amount)+$discountToShow)+$paid)+($total + $taxationAmount+$commissionAmount+$transfer_rent_amount - $discountToShow - $paid))}} @lang('currency.'.($sales->currency))
                            @endif
                            @endif
                        </b>
                    </div>
                </td> 
                @endif
                @endif
                @endif
                @endif

                @if($sales->type == "Invoice" || $sales->type == "saleByType" || $sales->type == "ProjectInvoice")
                @if($sales->hesab_sabeqa =="ok" || $sales->type == "saleByType" || $sales->type == "ProjectInvoice")
                @if(getHesabSabeqahType()=="currency")
                <td colspan="3">
                    @if(getHesabSabeqa() =='true')
                    <div class="center">@lang('layout.HesabSabiqa'): &nbsp;
                        @if($sales->type == "Invoice" || $sales->type == "saleByType" || $sales->type == "ProjectInvoice")
                        {{simpleRound(($balance-$total-$taxationAmount-$commissionAmount-$transfer_rent_amount+$discountToShow)+$paid)}} @lang('currency.'.($sales->currency))
                        @endif
                    </div>

                </td>

                <td colspan="1">
                    <div class="center"><b>@lang('layout.AmountPayable'):&nbsp;
                            @if($sales->type =="Invoice" || $sales->type == "saleByType" || $sales->type == "ProjectInvoice")
                            {{simpleRound((($balance-$total-$taxationAmount-$commissionAmount-$transfer_rent_amount+$discountToShow)+$paid)+($total+$taxationAmount+$commissionAmount+$transfer_rent_amount - $discountToShow -$paid))}} @lang('currency.'.($sales->currency))
                            @endif
                        </b></div>
                </td>
                @endif  
                @endif
                @endif
                @endif
                <!-------------------- ----------------------------------------------------------------------------------
                ---------------End  Hesab Sabeqah- ----------------------------------------------------------------------
                --------------------------------------------------------------------------------------------------------->

                @if($sales->type == "SalesReceipt")
                @if(getHesabSabeqaSale()=="true")
                <td colspan="3">
                    <div class="center">@lang('layout.HesabSabiqa'): &nbsp;
                        @if(getHesabSabeqahType()=="currency")
                            {{simpleRound(($balance))}} @lang('currency.'.($sales->currency))
                        @else
                            {{simpleRound(($balance))}} {{getHomeCurrency()["code"]}}
                        @endif
                    </div>

                </td>
                @endif
                @endif


                @if($sales->type == "SalesReceipt")
                <td colspan="3">
                    <div class="center"><b>@lang('layout.AmountPayable'):&nbsp;
                            @if($sales->type =="Invoice" || $sales->type == "saleByType" || $sales->type == "ProjectInvoice")
                            {{simpleRound(($total+$taxationAmount+$commissionAmount - $discountToShow -$paid))}} @lang('currency.'.($sales->currency))
                            @endif
                            
                            @if($sales->type =="SalesReceipt")
                            {{simpleRound(($total - $discountToShow))}} @lang('currency.'.($sales->currency))
                            @endif
                        </b></div>
                </td>
                @endif

            </tr>
            @if(getSaleToBase()=="true")
            @if($sales->hesab_sabeqa =="ok" || $sales->type == "saleByType" || $sales->type == "ProjectInvoice")
            @if(getHesabSabeqa() =='true')
            @if(getHesabSabeqahType()=="base_currency" || getHesabSabeqahType()==null)
            <tr>
                @if(systemConfig()[30] == 1)
                <td colspan="6"><b>@lang('layout.HesabSabiqa') @lang('currency.'.(getHomeCurrency()["code"])): &nbsp;{{simpleRound($balance - (($total+$taxationAmount+$commissionAmount-$discountToShow) -$paid)/$currencySR * $sales->rate)}} {{getHomeCurrency()["code"]}}</b></td>
                @else 
                <td colspan="6"><b>@lang('layout.HesabSabiqa') @lang('currency.'.(getHomeCurrency()["code"])): &nbsp;{{simpleRound($balance - (($total+$taxationAmount+$commissionAmount-$discountToShow) -$paid)/$sales->rate)}} {{getHomeCurrency()["code"]}}  /b></td>
                @endif 
                <td colspan="6"><b>@lang('layout.AmountPayable') @lang('currency.'.(getHomeCurrency()["code"])):&nbsp;{{simpleRound(((($balance)-($total+$taxationAmount+$commissionAmount)+$discountToShow)+$paid)+($total + $taxationAmount+$commissionAmount - $discountToShow - $paid))}} {{getHomeCurrency()["code"]}}</b></td>
           
            </tr>
            @endif 
            @if(getHesabSabeqahType()=="currency")
            <tr>
                @if(systemConfig()[30] == 1)
                <td colspan="6"><b>@lang('layout.HesabSabiqa') @lang('currency.'.(getHomeCurrency()["code"])): &nbsp;{{simpleRound($balance /$currencySR * $sales->rate - (($total+$taxationAmount+$commissionAmount-$discountToShow) -$paid)/$currencySR * $sales->rate)}} {{getHomeCurrency()["code"]}}</b></td>
                @else 
                <td colspan="6"><b>@lang('layout.HesabSabiqa') @lang('currency.'.(getHomeCurrency()["code"])): &nbsp;{{simpleRound($balance / $sales->rate - (($total+$taxationAmount+$commissionAmount-$discountToShow) -$paid)/$sales->rate)}} {{getHomeCurrency()["code"]}}</b></td>
                @endif 

                @if(systemConfig()[30] == 1)
                <td colspan="6"><b>@lang('layout.AmountPayable') @lang('currency.'.(getHomeCurrency()["code"])):&nbsp;{{simpleRound(((($balance / $currencySR * $sales->rate)-($total+$taxationAmount+$commissionAmount)+$discountToShow)+$paid)+($total + $taxationAmount+$commissionAmount - $discountToShow - $paid))}} {{getHomeCurrency()["code"]}}</b></td>
                @else 
                <td colspan="6"><b>@lang('layout.AmountPayable') @lang('currency.'.(getHomeCurrency()["code"])):&nbsp;{{simpleRound(((($balance / $sales->rate)-($total+$taxationAmount+$commissionAmount)+$discountToShow)+$paid)+($total + $taxationAmount+$commissionAmount - $discountToShow - $paid))}} {{getHomeCurrency()["code"]}}</b></td>
                @endif
            </tr>
            @endif
            @endif
            @endif
            @endif

        </table>

        @endif


        @if(getFactorTotal()==1)
        <table style="width: 100%; ">
            <tr>
                <td style="text-align: left; width:50%">

                </td>

                <td style="text-align: right; width:50%">
                    <table class="main-table">

                        <tr>
                            <td width="25%" align="right"><b>@lang('layout.Total')</b></td>
                            <td align="right">
                                <div class="center" style="font-size: bold;">
                                    <b>
                                        {{simpleRound($total+$taxationAmount+$commissionAmount)}} @lang('currency.'.($sales->currency))
                                        ( @if(getFactorLang()=='fa')
                                        <span>
                                            {{notowo(abs(round($total+$taxationAmount+$commissionAmount)),'fa')}}
                                        </span>
                                        @elseif(getFactorLang()=='pa')
                                        <span>
                                            {{notowo(abs(round($total+$taxationAmount+$commissionAmount)),'pa')}}
                                        </span>
                                        @else
                                        <span>
                                            {{notowo(abs(round($total+$taxationAmount+$commissionAmount)),'en')}}</span>
                                        @endif)

                                    </b>
                                </div>

                            </td>

                        </tr>
                        <tr>
                            <td align="right"><b>@lang('layout.Recipt')</b></td>
                            <td align="right">
                                <b>
                                    @if($sales->type == "Invoice" || $sales->type == "saleByType" || $sales->type == "ProjectInvoice")
                                    <div class="center">
                                        {{simpleRound($paid)}} @lang('currency.'.($sales->currency))
                                    </div>
                                    @endif
                                </b>
                            </td>
                        </tr>
                        <tr>
                            <td align="right"><b>@lang('layout.Discount')</b></td>
                            <td align="right">
                                <b>
                                    <div class="center">
                                        <span>
                                            {{simpleRound($discountToShow)}} @lang('currency.'.($sales->currency))
                                        </span>

                                    </div>
                                </b>
                            </td>
                        </tr>
                        <tr>
                            <td align="right"><b>@lang('layout.Remined')</b></td>
                            <td align="right">
                                <b>
                                    @if($sales->type == "Invoice" || $sales->type == "saleByType" || $sales->type == "ProjectInvoice")
                                    <div class="center">
                                        {{simpleRound(($total+$taxationAmount+$commissionAmount-$discountToShow-$paid))}} @lang('currency.'.($sales->currency))
                                    </div>
                                    @endif
                                </b>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
        @endif
        <!-------------------------------------------------------------------------------------------------------
              - ---End  Table 4 For Total  Information        -------------------------------------------------------
            --------------------------------------------------------------------------------------------------------->


        @if($invoice_des)
        <table width="60%" border="1" style="border-collapse: collapse; margin-top: 7px;">
            <tr>
                <td style="font-size: 14px;">{{$invoice_des}}</td>
            </tr>
        </table>
        @endif

        @if(company()['invoice_message'])
        <table width="100%">
            <tr>
                <td style="font-size: 14px;">{!!company()['invoice_message']!!}</td>
            </tr>

            <tr>
                <td></td>
                <td></td>
            </tr>


        </table>
        @endif
        <!--End Table 4 For Total  Information-->


        <?php

        ?>

    </div>

</div>
@if(getDriverInfo()=="true")
@if(transportCompanyFactor()=="true")
@if($d_info)
@if($d_info->driver!=null || $d_info->plateNumber!=null )
<!--Driver Info-->
<table style="width: 100%; margin-top: 10px;">
    <tr>
        <td style="text-align: left; width:40%">
            <table class="main-table">

                @if($d_info->transferCode!=null)
                <tr style="font-weight: bold; font-size: 17px">
                    <td align="right"><b>@lang('layout.TransferCode')</b></td>
                    <td align="right"><b>{{$d_info->transferCode}}</b></td>
                </tr>
                @endif
                @if($d_info->driver!=null)
                <tr>
                    <td align="right"><b>@lang('layout.Transporter_name')</b></td>
                    <td align="right"><b>{{$d_info->driver}}</b></td>
                </tr>
                @endif
                @if($d_info->driverPhone!=null)
                <tr>
                    <td align="right"><b>@lang('layout.Transporter_phone')</b></td>
                    <td align="right"><b>{{$d_info->driverPhone}}</b></td>
                </tr>
                @endif
                @if($d_info->PlaceOfWeight!=null)
                <tr>
                    <td align="right"><b>@lang('layout.PlaceOfWeight')</b></td>
                    <td align="right"><b>{{$d_info->PlaceOfWeight}}</b></td>
                </tr>
                @endif
                @if($d_info->sourcePlace!=null)
                <tr>
                    <td align="right"><b>@lang('layout.SourcePlace')</b></td>
                    <td align="right"><b>{{$d_info->sourcePlace}}</b></td>
                </tr>
                @endif
                @if($d_info->plateNumber!=null)
                <tr>
                    <td align="right"><b>@lang('layout.PlateNumber')</b></td>
                    <td align="right"><b>{{$d_info->plateNumber}}</b></td>

                </tr>
                @endif


            </table>
        </td>

        <td style="text-align: right; width:40%">
            <table class="main-table">
                @if($d_info->wayBillNumber!=null)
                <tr style="font-weight: bold; font-size: 17px">
                    <td align="right"><b>@lang('layout.WayBillNumber')</b></td>
                    <td align="right"><b>{{$d_info->wayBillNumber}}</b></td>
                </tr>
                @endif
                @if($d_info->totalWeight!=null)
                <tr>
                    <td align="right"><b>@lang('layout.TotalWeight')</b></td>
                    <td align="right"><b>{{$d_info->totalWeight}}</b></td>
                </tr>
                @endif
                @if($d_info->emptyCarWeight!=null)
                <tr>
                    <td align="right"><b>@lang('layout.EmptyCarWeight')</b></td>
                    <td align="right"><b>{{$d_info->emptyCarWeight}}</b></td>
                </tr>
                @endif
                @if($d_info->bori!=null)
                <tr>
                    <td align="right"><b>@lang('layout.TotalBori')</b></td>
                    <td align="right"><b>{{$d_info->bori}}</b></td>
                </tr>
                @endif
                @if($d_info->rent!=null)
                <tr>
                    <td align="right"><b>@lang('layout.Rent')</b></td>
                    <td align="right"><b>{{$d_info->rent}}</b></td>
                </tr>
                @endif
                @if($d_info->trDesription!=null)
                <tr>
                    <td align="right"><b>@lang('layout.Description')</b></td>
                    <td align="right"><b>{{$d_info->trDesription}}</b></td>
                </tr>
                @endif

            </table>
        </td>
    </tr>
</table>
<!--End Driver Info-->
@endif
@endif
@endif
@endif
<!--Transport Company And Driver-->
@if(getTransportCompany()=="true")
@if(transportCompanyFactor()=="true")
@if($transportCompany)
@if($transportCompany->driver_name || $transportCompany->trasnport_name!=null )
<!--Driver Info-->
<table style="width: 100%; margin-top: 10px;">
    <tr>
        <td style="text-align: left; width:50%">
            <table class="main-table">
                <tr>
                    <td align="center" colspan="2">
                        <b style="font-size: 20px;">@lang('menu.TransportCompany')</b>
                    </td>

                </tr>

                <tr style="font-weight: bold; font-size: 17px">
                    <td align="right"><b>@lang('layout.Number')</b></td>
                    <td align="right"><b>{{$transportCompany->trasnport_number}}</b></td>
                </tr>
                <tr>
                    <td align="right"><b>@lang('layout.LicenseNumber')</b></td>
                    <td align="right"><b>{{$transportCompany->trasnport_license_number}}</b></td>
                </tr>
                <tr>
                    <td align="right"><b>@lang('layout.Name')</b></td>
                    <td align="right"><b>{{$transportCompany->trasnport_name}}</b></td>
                </tr>
                <tr>
                    <td align="right"><b>@lang('layout.Phone')</b></td>
                    <td align="right"><b>{{$transportCompany->trasnport_phone}}</b></td>
                </tr>
                <tr>
                    <td align="right"><b>@lang('layout.Email')</b></td>
                    <td align="right"><b>{{$transportCompany->trasnport_email}}</b></td>
                </tr>
                <tr>
                    <td align="right"><b>@lang('layout.City')</b></td>
                    <td align="right"><b>{{$transportCompany->trasnport_city}}</b></td>
                </tr>
                <tr>
                    <td align="right"><b>@lang('layout.Address')</b></td>
                    <td align="right"><b>{{$transportCompany->trasnport_address}}</b></td>
                </tr>

            </table>
        </td>

        <td style="text-align: right; width:50%">
            <table class="main-table">
                <tr>
                    <td align="center" colspan="2">
                        <b style="font-size: 20px;">@lang('layout.Driver')</b>
                    </td>

                </tr>
                <tr style="font-weight: bold; font-size: 17px">
                    <td align="right"><b>@lang('layout.Number')</b></td>
                    <td align="right"><b>{{$transportCompany->driver_code}}</b></td>
                </tr>
                <tr>
                    <td align="right"><b>@lang('layout.SSID')</b></td>
                    <td align="right"><b>{{$transportCompany->driver_ss_id}}</b></td>
                </tr>
                <tr>
                    <td align="right"><b>@lang('layout.Name')</b></td>
                    <td align="right"><b>{{$transportCompany->driver_name}}</b></td>
                </tr>
                <tr>
                    <td align="right"><b>@lang('layout.LastName')</b></td>
                    <td align="right"><b>{{$transportCompany->driver_last_name}}</b></td>
                </tr>
                <tr>
                    <td align="right"><b>@lang('layout.Phone')</b></td>
                    <td align="right"><b>{{$transportCompany->driver_phone}}</b></td>
                </tr>
                <tr>
                    <td align="right"><b>@lang('layout.City')</b></td>
                    <td align="right"><b>{{$transportCompany->driver_city}}</b></td>
                </tr>
                <tr>
                    <td align="right"><b>@lang('layout.Address')</b></td>
                    <td align="right"><b>{{$transportCompany->driver_address}}</b></td>
                </tr>
                @if($transportCompany->rent!=null)
                <tr>
                    <td align="right"><b>@lang('layout.Rent')</b></td>
                    <td align="right"><b>{{$transportCompany->rent}}</b></td>
                </tr>
                @endif

            </table>
        </td>
    </tr>
</table>
<table class="main-table">
    <tr>
        <td align="right"><b>@lang('layout.Commitment')</b></td>
    </tr>
    <tr>
        <td align="right" style="white-space: normal; font-size:15px;"><b>{{$transportCompany->commitment}}</b></td>
    </tr> 
</table> 
<!--End Driver Info-->
@endif
@endif
@endif
@endif
<!--End Transport Company And Driver..................................................................-->
{{-- Start of All Currency for the settings .............................................   --}} 
@if(getHesabSabeqahType()=="all_currency" || getHesabSabeqahType()==null)
<table  class="main-table">
    @if(getHesabSabeqa() =='true')
    @if($sales->type == "Invoice" || $sales->type == "saleByType" || $sales->type == "ProjectInvoice")
    <tr class="center">
        <td class="center" colspan="2">    
            @lang('layout.HesabSabiqa'): &nbsp;
        </td>
    </tr>
    <tr>
        <td class="center" colspan="1">    
            @lang('layout.Currency') &nbsp;
        </td>
        <td class="center" colspan="1">    
            @lang('layout.Amount') &nbsp;
        </td>
    </tr>
    @foreach($allCurrency as $currency)
    <tr>
        <td class="center" colspan="1">    
            {{$currency['currency']}}
        </td>
        <td class="center" colspan="1">    
           {{$currency['invoice']}}
        </td>
    </tr>
    @endforeach
    @endif
    @endif
</table>
@endif
{{-- End of All Currency for the settings ................................................  --}}
@if(getUserSignatureBelowFactor() == "true")
<table class="main=-table" style="margin-top: 20px;">
        <tr>
            <td style="width: 65%"></td>
            <td style="width:15%; text-align:left;"><span>  {{Auth()->user()->name}}  </span></td>
            <td style="width:20%; text-align:right;"><span> 
            <img src="{{asset('uploads/' . auth()->user()->signature)}}" alt="" style="height: 80px;">    
            </span></td>
        </tr>
    </table>
    @endif 
<!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','invoice') AS $info)
        <td style="text-align: left; width:40%">
            <table>
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
            </table>
        </td>
        @endforeach
    </tr>
</table>
<!-- End signature -->
<script type="text/javascript">
    window.print();
</script>
<?php
// echo '<script>window.print()</script>';
if ($b < count($data_all)) {
    echo "<pagebreak/>";
}
$b++;
?>
@endforeach
@endsection