@extends('layouts.factor-master-print')
@section('style')
<style>
</style>
@stop
@section('content')
    {{-- <h1>CASERP <br/> {!!company()['name']!!}</h1>     --}}
    <h1>@lang('layout.Invoice') : {{$sales->number}}</h1>
    <h3>
        <?php
            $str_date = convertdate($sales->date);
            $date_string = substr($str_date, 0, 10);
        ?>
        <b> @if(getInvoiceDateFormat() == "shamsi")
            <?php
            $str_date = convertdate($sales->date, 0, 'jalali');

            $date_string = substr($str_date, 0, 10)
            ?>
            {{$date_string}}
            @elseif(getInvoiceDateFormat() =='both')
            <?php
                $str_date = convertdate($sales->date, 0, 'jalali');
                $date_string = substr($str_date, 0, 10);
                echo $date_string;
            ?>
            &nbsp;/&nbsp;
            {{substr($sales->date,0,10)}}
            @elseif(getInvoiceDateFormat() =="meladi")
            {{substr($sales->date,0,10)}}
            @else
            {{$str_date}}
            @endif 
        </b> --- &#13;&#10;&#13;&#10;
        <b> @lang('layout.Hour') ( <?php echo Date('h:i A', strtotime($sales->date)); ?> ) </b>
    </h3>
    <h3>
        <b>     
            @lang('layout.Customer') 
            ( @if(getDescriptionASMemberName()=="true" && $other_member_name!="")
                {{$other_member_name}}
            @else
                {{$member->name}}
            @endif ) -
            {{-- @lang('layout.Code') 
            ( {{$member->code}} )  --}}
            @lang('layout.Telephone') 
            ( {{$phone}} ) 
        </b>
    </h3> 
    <h3>@lang('layout.Items')</h3>
    <?php
    $discountTotal = 0;
    $count = 0;
    $empty = 0;
    $total_discount = 0;
    $total_discount_per_item = 0;
    $totalQty = 0;
    $measure_total = [];
    ?>
    @foreach($data AS $key1=>$record)
    <?php
        $discountTotal = ($record['discount'] * $record['qty']) + $discountTotal;
        if ($sales->discount_type == "currency") {
            $total_discount += $record['discount'] * $record['qty'];
        } else {
            $t = ($record['price'] * $record['qty']);
            $total_discount += ($record['discount']) * $t / 100;
        }
        //Total Items
        if (array_key_exists($record['symbol'], $measure_total)) {
            $measure_total[$record['symbol']] = $measure_total[$record['symbol']] + $record['qty'];
        } else {
            $measure_total[$record['symbol']] = $record['qty'];
        }
        $totalQty += $record['qty'];
    ?>
    <h4> 
        <b>  {{++$count}} -   </b>
        @if(getSerailNumber() =="true")
            <b> @lang('layout.SerialNum') - {{$record['number']}}  </b>
        @endif
        <b>{{$record['name']}}</b> -- 
        @if(getInventorySite()=="true")
            <b>  @lang('layout.Site') = {{$record['siteName']}}  </b> -- 
        @endif
        <b> @lang('layout.Quantity') - {{$record['qty']}}  {{$record['symbol']}} </b> -- 
        @if(getOtherMeasure()=="true" && $record['other_measure'] > 0)
            <b>  {{$record['o_measure_name']}} - {{$record['other_measure']}}  </b> -- 
        @endif
        <b> @lang('layout.Rate') - {{myRound($record['price'])}} {{$sales->currency}}</b>
        @if(getSaleDiscount()=="true")
        <b> @lang('layout.Sub-Total') - {{ myRound($record['price']*$record['qty'])}} {{$sales->currency}}  </b> -- 
        <b> @lang('layout.Discount') - {{$record['discount']}} {{($sales->discount_type=="percent")? '%' : $sales->currency}}  </b> -- 
        @endif
        <b> {  
            @if($sales->discount_type=="currency")
            {{ myRound(($record['price']*$record['qty'])-$record['discount']*$record['qty'])}} {{$sales->currency}}
            @else
            {{ myRound(($record['price']*$record['qty'])-($record['discount']*$record['price']/100)*$record['qty'])}} {{$sales->currency}}
            @endif
            }
        </b>
    </h4> 
    @endforeach
    <!--Begin Total Item Quantity-->
    @if(getTotalItemQuantity()!='' ||getTotalItemQuantity()!="defualt")
    <h3>@lang('layout.TotalQuantity')</h3>
    @if(getTotalItemQuantity() == "per_unit")
    @foreach($measure_total AS $key=>$measure)
    <h4> 
        <b>{{$measure}} = {{$key}}</b>
    </h4>
    @endforeach  
    @endif
    @if(getTotalItemQuantity() == "all_unit")
    <h4> 
        <b>@lang('layout.TotalQuantity') = {{$totalQty}}</b>
    </h4>
    @endif
    @endif
    <!--End Total Item Quantity-->
    @if(getSubTotal() == 'true' && $sub_total_amount > 0)
    <h3>@lang('layout.Sub-Total')</h3>
    <h4> 
        <b>@lang('layout.Sub-Total') - {{myRound($sub_total_amount)}}</b> -- 
        <b>@lang('layout.Discount') - {{myRound((($discount * ($sub_total_amount - $sub_inventory_discount_total)) / 100) + $sub_inventory_discount_total)}}</b> -- 
        <b>@lang('layout.Total') - {{myRound($sub_total_amount - $sub_inventory_discount_total - (($discount * ($sub_total_amount - $sub_inventory_discount_total)) / 100))}}  </b>
    </h4> 
    @endif
    <!--Table 3 For Payment  Information-->
    @if(getInvoicePayment()== "true")
    @if(count($invoice_payment)>0)
    <h3>@lang('layout.Payment')</h3>
    <?php
    $count = 0;
    $total_payments = 0;
    ?>
    @foreach($invoice_payment AS $key2=>$payment)
    <?php
        $total_payments += $payment['amount'] * $sales->rate / $payment['rate'];
    ?>
    <h4> 
        <b>@lang('layout.Number') - {{++$count}}</b> -- 
        <b>@lang('layout.Description') - {{$payment['description']}}</b> -- 
        <b>@lang('layout.Amount') - {{myRound($payment['amount'])}}</b> -- 
        <b>@lang('layout.Currency') - {{$payment['currency']}}</b> -- 
        <b>@lang('layout.Rate') - {{$payment['rate']}}</b>
    </h4>
    @endforeach 
    <?php
        if (getInvoicePayment() == "true" && count($invoice_payment) > 0) {
            $total = $total_payments + $total;
        }
    ?>
    @endif
    @endif
    <!-------------------------------------------------------------------------------------------------------
        - --- Table 4 For Total  Information        ---------------------------------------------------------
    --------------------------------------------------------------------------------------------------------->
    <h3>@lang('layout.Total')</h3>
    <h4>   
        @if(App::isLocale('fa') || App::isLocale('pa'))
        <b>@lang('layout.TotalInLeters') - {{notowo(abs(round($total+$taxationAmount)),'fa')}}</b> -- 
        @else
        <b>@lang('layout.TotalInLeters') - {{notowo(abs(round($total+$taxationAmount)),'en')}}</b> -- 
        @endif
        @if($sales->type == "Invoice")
        <b>@lang('layout.Recipt') - {{myRound($paid)}} @lang('currency.'.($sales->currency))</b> -- 
        @endif
        <b>@lang('menu.Taxation') - {{myRound($taxationAmount)}} @lang('currency.'.($sales->currency))</b> -- 
        <b> ( @lang('layout.Total') - {{myRound($total+$taxationAmount)}} @lang('currency.'.($sales->currency))  @if($sales->currency != getReportCurrency()) &nbsp; --- مجموع دالر : {{myRound(($total)/$sales->rate)}}  @endif ) </b> -- 
    </h4>
    <h4>   
        <b>@lang('layout.Discount') - 
        @if($sales->discount_type=="currency")
        {{myRound(($discountToShow))}} @lang('currency.'.($sales->currency))
        @else
        {{myRound($discountToShow)}} @lang('currency.'.($sales->currency))
        @endif    
        </b> -- 
        @if($sales->type == "Invoice")
        <b>@lang('layout.Remined') - {{myRound((($total+$taxationAmount-$discountToShow) -$paid))}} @lang('currency.'.($sales->currency))</b> -- 
        @endif
        <!-------------------- ----------------------------------------------------------------------------------
        ---------------Begin Hesab Sabeqah-----------------------------------------------------------------------
        --------------------------------------------------------------------------------------------------------->
        @if($sales->type == "Invoice")
        @if($sales->hesab_sabeqa =="ok")
        @if(getHesabSabeqahType()=="base_currency" || getHesabSabeqahType()==null)
        @if(getHesabSabeqa() =='true')
        <b>@lang('layout.HesabSabiqa') - 
        @if($sales->type == "Invoice")
            {{myRound($balance - (($total+$taxationAmount-$discountToShow) -$paid)/$sales->rate)}} {{getHomeCurrency()["code"]}}
        @endif
        </b> -- 
        <b> @lang('layout.AmountPayable') -
        @if($sales->type == "Invoice")
            {{myRound(((($balance * $sales->rate)-($total+$taxationAmount)+$discountToShow)+$paid)+($total + $taxationAmount - $discountToShow - $paid))}} @lang('currency.'.($sales->currency))
        @endif 
        </b> -- 
        @endif
        @endif
        @endif
        @endif
        @if($sales->type == "Invoice")
        @if($sales->hesab_sabeqa =="ok")
        @if(getHesabSabeqahType()=="currency")
        @if(getHesabSabeqa() =='true')
        <b>@lang('layout.HesabSabiqa') - 
        @if($sales->type == "Invoice")
            {{myRound(($balance-$total-$taxationAmount+$discountToShow)+$paid)}} @lang('currency.'.($sales->currency))
        @endif
        </b> -- 
        <b> @lang('layout.AmountPayable') - 
        @if($sales->type == "Invoice")
            {{myRound((($balance-$total-$taxationAmount+$discountToShow)+$paid)+($total+$taxationAmount - $discountToShow -$paid))}} @lang('currency.'.($sales->currency))
        @endif 
        </b> -- 
        @endif
        @endif
        @endif
        @endif
        <!-------------------- ----------------------------------------------------------------------------------
        ---------------End  Hesab Sabeqah-----------------------------------------------------------------------
        --------------------------------------------------------------------------------------------------------->
        @if($sales->type == "SalesReceipt")
        @if(getHesabSabeqaSale()=="true")
        <b>@lang('layout.HesabSabiqa') -  {{myRound(($balance))}} {{getHomeCurrency()["code"]}}</b> -- 
        @endif
        @endif
        @if(getHesabSabeqa() =='false')
        <b> @lang('layout.AmountPayable') -  
        @if($sales->type =="Invoice")
        {{myRound(($total+$taxationAmount - $discountToShow -$paid))}} @lang('currency.'.($sales->currency))
        @endif 
        </b>
        @endif
    </h4>
    <!-------------------------------------------------------------------------------------------------------
        - ---End  Table 4 For Total  Information        -------------------------------------------------------
    --------------------------------------------------------------------------------------------------------->
    @if($invoice_des)
    <h4>
        <b> @lang('layout.Description') - {{$invoice_des}}</b>
    </h4>
    @endif
@endsection