@extends('layouts.factor-master-print')
@section('style')

    <style>
        .small-table td, .main-table td, .main-table tr,
        .small-table th, .main-table th {

        }

        .t1 {
            font-size: 14px;
            font-weight: bold;
            background-color: {{company()['color']}};
        }
    </style>
@stop
@section('content')

    <div>
        <div style=" font-size: 12px !important">


            <!--Table 2 For Customer Information-->
            <table style="width: 100%;">
                <tr>
                    <td style="text-align: left; width:20%">
                        <table class="main-table">
                            <tr>
                                <td align="center" colspan="2">
                                    <b style="font-size: 20px;">@lang('layout.SaleGift')</b>
                                </td>

                            </tr>

                            <tr>
                                <td align="right"><b>@lang('layout.InvoiceNumber')</b></td>
                                <td align="right"><b>@lang('layout.Date')</b></td>
                            </tr>
                            <?php
                            $str_date = convertdate($sales->date);

                            $date_string = substr($str_date, 0, 10);
                            ?>
                            <tr>
                                <td align="right"><b>{{$sales->number}}</b></td>
                                <td align="right"><b>
                                        @if(getInvoiceDateFormat() == "shamsi")
                                            <?php
                                            $str_date = convertdate($sales->date, 0, 'jalali');

                                            $date_string = substr($str_date, 0, 10)
                                            ?>
                                            {{$date_string}}

                                        @elseif(getInvoiceDateFormat() =='both')

                                            <?php
                                            $str_date = convertdate($sales->date, 0, 'jalali');

                                            $date_string = substr($str_date, 0, 10);
                                            echo $date_string;
                                            ?>
                                            &nbsp;/&nbsp;
                                            {{substr($sales->date,0,10)}}

                                        @elseif(getInvoiceDateFormat() =="meladi")
                                            {{substr($sales->date,0,10)}}

                                        @else

                                            {{$str_date}}

                                        @endif
                                    </b></td>
                            </tr>
                        </table>
                    </td>

                    <td width="20%"></td>
                    <td style="text-align: right; width:60%">

                    </td>
                </tr>
            </table>
            <!--End Table 2 For Invoice Information-->

            <table style="width: 100%; margin-top: 10px;">
                <tr>
                    <td style="text-align: left; width:40%">
                        <table class="main-table">
                            <tr>
                                <td align="center" colspan="2">
                                    <b>@lang('layout.BillTo')</b>
                                </td>

                            </tr>
                            <tr>
                                <td align="right"><b>@lang('layout.Name')</b></td>
                                <td align="right"><b>{{$member->name}}</b></td>
                            </tr>
                            <tr>
                                <td align="right"><b>@lang('layout.Code')</b></td>
                                <td align="right"><b>{{$member->code}}</b></td>
                            </tr>
                        </table>
                    </td>

                    <td width="20%"></td>
                    <td style="text-align: right; width:30%">
                        <table class="main-table">
                            <tr>
                                <td align="center" colspan="2"><b>@lang('layout.ShipTo')</b></td>
                            </tr>
                            <tr>
                                <td width="25%" align="right"><b>@lang('layout.Address')</b></td>
                                <td align="right"><b>{{$address.' '.$city}}</b></td>
                            </tr>
                            <tr>
                                <td align="right"><b>@lang('layout.Phone')</b></td>
                                <td align="right"><b>{{$phone}}</b></td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>


            <!--Table 3 For Data  Information-->
            <table class="main-table" style="margin-top: 20px;" cellpadding="5px">
                <tr style="font-weight: bold; font-size: 17px">
                    <td class="mt">
                        <div class="center">@lang('layout.Number')</div>
                    </td>
                <!--<td class="mt"><div class="center">@lang('layout.ItemCode')</div></td>-->
                    @if(getSerailNumber() =="true")
                        <td class="mt">
                            <div class="center">@lang('layout.SerialNum')</div>
                        </td>
                    @endif
                    <td class="mt">
                        <div class="center">@lang('layout.Item')</div>
                    </td>

                    @if(getItemImage()=="true")
                        <td class="mt">
                            <div class="center">@lang('layout.ItemImage')</div>
                        </td>
                    @endif
                    @if(getItemOtherName()=="true")
                        <td class="mt">
                            <div class="center">@lang('layout.ItemOtherName')</div>
                        </td>
                    @endif
                    @if(getInventorySite()=="true")
                        <td class="mt">
                            <div class="center">@lang('layout.Site')</div>
                        </td>
                    @endif
                    <td class="mt">
                        <div class="center">@lang('layout.Quantity')</div>
                    </td>
                    <td class="mt">
                        <div class="center">@lang('layout.Unit/M')</div>
                    </td>
                    @if(getFactorOtherMeasure() =="true")
                        <td class="mt">
                            <div class="center">@lang('layout.Measure1')</div>
                        </td>
                        <td class="mt">
                            <div class="center">@lang('layout.Measure2')</div>
                        </td>
                @endif
                @if(getSaleDescription()=="true")
                    <td class="mt"><div class="center">@lang('layout.Description')</div></td>
                @endif

                </tr>
                <?php

                $count = 0;
                $empty = 0;
                $fullCount = count($data);
                $total_discount = 0;
                if ($fullCount < 15) {
                    $empty = 15 - $fullCount;
                }
                ?>
                @foreach($data AS $key1=>$record)
                    <?php

                    if ($sales->discount_type == "currency") {
                        $total_discount += $record['discount'] * $record['qty'];
                    } else {
                        $t = ($record['price'] * $record['qty']);
                        $total_discount += ($record['discount']) * $t / 100;
                    }

                    ?>
                    <tr>

                        <td class="center">{{++$count}}</td>
                    <!--<td class="center">{{$record['number']}}</td>-->
                        @if(getSerailNumber() =="true")
                            <td class="center">{{$record['number']}}</td>
                        @endif
                        <td class="center">{{$record['name']}}</td>
                        @if(getItemImage()=="true")
                        <td class="center" style="margin: 0px;padding: 0px;">
                            @if($record['image'])
                            <img alt="" style="height: 80px;width: 80px;" class="img-circle" src="{{asset('uploads/items/'.$record['image'])}}" />
                            @endif
                        </td>
                        @endif
                        @if(getItemOtherName()=="true")
                            <td class="center">{{$record['item_other_name']}}</td>
                        @endif
                        @if(getInventorySite()=="true")
                            <td class="center">{{$record['siteName']}}</td>
                        @endif
                        <td class="center">{{$record['qty']}}</td>
                        <td class="center">{{$record['symbol']}}</td>
                        @if(getFactorOtherMeasure() =="true")
                            <td class="center">{{$record['qty1']}}</td>
                            <td class="center">{{$record['qty2']}}</td>
                        @endif
                        @if(getSaleDescription()=="true")
                            <td class="center">{{$record['itemDescription']}}</td>
                    @endif
                    </tr>

                @endforeach
                @for($i=0;$i<$empty;$i++)

                    <?php
                    ?>
                    @if(getPaperSize() =='A4' && getPaperStyle() =='portrait')
                        @if(getWhiteRows() =="true")
                            <tr>

                                <td class="center" style="height: 30px"></td>
                                @if(getSerailNumber() =="true")
                                    <td class="center"></td>
                                @endif
                                <td class="center"></td>
                                @if(getItemImage()=="true")
                                    <td class="center"></td>
                                @endif
                                @if(getItemOtherName()=="true")
                                    <td class="center"></td>
                                @endif
                                <td class="center"></td>
                                @if(getInventorySite()=="true")
                                    <td class="center"></td>
                                @endif
                                <td class="center"></td>
                                @if(getSaleDescription()=="true")
                                    <td class="center"></td>
                            @endif
                            <!--td class="center"></td>
                            @if(getSaleDiscount()=="true")
                                <td class="center"></td>
                                <td class="center"></td>
                            @endif
                            @if(getFactorOtherMeasure() =="true")
                                <td class="center"></td>
                                <td class="center"></td>
                            @endif
                                    <td class="center"></td -->
                            </tr>
                        @endif
                    @endif
                @endfor

                <?php
                if ($sales->discount_type == "currency") {
                    echo Currency()->format($discountToShow, $sales->currency);
                } else {
                    echo round($discountToShow, 2) . '%';
                }

                $discountTotal = 0;
                foreach ($data as $key => $value) {
                    $discountTotal = ($value['discount'] * $value['qty']) + $discountTotal;
                }

                ?>

            </table>
            <!--End Table 3 For Data Information-->


            <!--Table 4 For Total  Information-->

            @if($invoice_des)
                <table width="60%" border="1" style="border-collapse: collapse; margin-top: 7px;">
                    <tr>
                        <td style="font-size: 14px;">{{$invoice_des}}</td>
                    </tr>
                </table>
            @endif

            @if(company()['invoice_message'])
                <table width="100%">
                    <tr>
                        <td style="font-size: 14px;">@lang('layout.Note'): {!!company()['invoice_message']!!}</td>
                    </tr>

                    <tr>
                        <td></td>
                        <td></td>
                    </tr>


                </table>
        @endif
        <!--End Table 4 For Total  Information-->

            <table style="border-collapse: collapse; margin-top: 7px;">
                <tr>
                    <td style="font-size: 14px;">@lang('layout.MohrAndSignature'):</td>
                </tr>
            </table>
        </div>

    </div>

    </div>



    <script type="text/javascript">
        window.print();
    </script>
@endsection


