@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
<link href="{{URL::asset('assets/global/plugins/bootstrap-timepicker/css/bootstrap-timepicker.min.css')}}" rel="stylesheet" type="text/css" />
<style>
    .paid_stamp {
        width: 160px;
        height: 80px;
        /* background-color: gray; */
        font-size: 60px;
        font-weight: bold;
        -ms-transform: rotate(-20deg);
        transform: rotate(-20deg);
        padding: 5px;
        text-shadow: 3px 3px;
        @if(session()->get("system_direction")=="rtl") margin-right: 60%;
        @else margin-left: 60%;
        @endif
    }
    .t_head {
        background-color: #eceef1 !important;
        /* padding: 7px !important; */
    }
    .t_body {
        background-color: #eceef1 !important;
        /* padding: 7px !important; */
    }
</style>
@section('content')
@include("layouts.Cmodal")
@include("invoices.modal")
<div class="row">
    <div class="portlet light bordered ">
        <!-- BEGIN TAB PORTLET-->
        <div class="portlet light bordered sale">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-anchor font-green-sharp"></i>&nbsp;
                    @if($duplicate)
                    <span class="caption-subject font-green-sharp bold uppercase">@lang('layout.CreateNewInvoice') </span>
                    @else
                    <span class="caption-subject font-green-sharp bold uppercase">@lang('layout.EditInvoice') </span>
                    @endif
                </div>
                <div class="actions">
                </div>
                @if($paid_stamp!='')
                <div class="paid_stamp">{{$paid_stamp}}
                    <span style="font-size: 25px; text-shadow: 0px 0px;">{{$paid_date}}</span>
                </div>
                @endif
            </div>
            <div id="appInvoice" class="portlet-body">
                <div class="tabbable tabbable-tabdrop">
                    <div>
                        @if($duplicate)
                        {{Form::model($invoice,['route' => ['invoice.store',$invoice->id],'method' => 'post','class' => 'form-horizontal','id'=>'sales-form','files'=> true])}}
                        @else 
                        {{Form::model($invoice,['route' => ['invoice.update',$invoice->id],'method' => 'PATCH','class' => 'form-horizontal','id'=>'sales-form','files'=> true])}}
                        @endif
                        {{ csrf_field() }}
                        <div class="tab-content">
                            <div class="tab-pane active" id="tab1">
                                <div id="appInvoice" v-cloak class="portlet-body form" style="margin-bottom:50%;">
                                    <!-- begin sale order modal -->
                                    <!-- end sale order modal -->
                                    <!-- BEGIN FORM-->
                                    <div class="row">
                                        <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12">
                                            {{-- <div class="tabbable-custom nav-justified"> --}}
                                                <ul class="nav nav-tabs">
                                                    <li class="active">
                                                        <a href="#general" data-toggle="tab" aria-expanded="true">@lang('layout.Invoice')</a>
                                                    </li>
                                                    @if(getTaxation()=="true" ||getSaleTaxation() == 'true'|| getSaleCommission()=="true")
                                                    <li class="">
                                                        <a href="#tab2" data-toggle="tab" aria-expanded="false">@lang('layout.Tax')/ @lang('layout.Commission')</a>
                                                    </li>
                                                    @endif
                                                    @if(getTransportCompany()=="true")
                                                    <li class="">
                                                        <a href="#tab3" data-toggle="tab" aria-expanded="false">@lang('menu.TransportCompany')</a>
                                                    </li>
                                                    @endif
                                                    <li class="">
                                                        <a href="#tab4" data-toggle="tab" aria-expanded="false">@lang('layout.OtherInformations')</a>
                                                    </li>
                                                    @if(ShowLastSale()=="true")
                                                    <li class="">
                                                        <a href="#tab5" data-toggle="tab" aria-expanded="false">@lang('layout.ShowLastSales')</a>
                                                    </li>
                                                    @endif
                                                </ul>
                                                <div class="tab-content">
                                                    <div class="tab-pane active" id="general" style="padding: 0 10px 0 10px">
                                                        <div class="row">
                                                            <div class="col-lg-12 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px; padding: 20px !important;">
                                                                <div class="row">
                                                                    <div v-show="showWhat('sale_area')=='yes'" class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                                        <div class="form-group">
                                                                            <div class="col-md-12">
                                                                                <label class="control-label">@lang('layout.SaleArea')</label>
                                                                                <v-select label="name" :options="saleArea" v-model="selected_area"></v-select>
                                                                                <input type="hidden" name="sale_area_id" :value="!selected_area?null:selected_area.id">
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12" v-show="showWhat('member_class')=='yes'">
                                                                        <div class="form-group">
                                                                            <div class="">
                                                                                <label class="control-label">@lang('layout.MemberClass')</label>
                                                                                <v-select label="name" :options="memberClass" v-model="selected_class" @input="memberClassChange()"></v-select>
                                                                                <input type="hidden" name="class_id" :value="!selected_class?null:selected_class.id">
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    @if(getShwoPriceLevel()=="general")
                                                                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                                            <div class="form-group">
                                                                                <div class="col-md-12">
                                                                                    <label class="control-label">@lang('layout.PriceLevel') </label>
                                                                                    <v-select label="name" :options="priceLevel" v-model="selected_priceLevel">
                                                                                    </v-select>
                                                                                    <input type="hidden" name="price_level_id" :value="!selected_priceLevel?null:selected_priceLevel.id">
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    @endif
                                                                    @if(getShwoPriceLevel()=="general_percent")
                                                                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                                            <div class="form-group">
                                                                                <div class="col-md-12">
                                                                                    <label class="control-label">@lang('layout.PriceLevel') </label>
                                                                                    <v-select label="name" :options="priceLevelGeneral" v-model="selected_priceLevelGeneral">
                                                                                    </v-select>
                                                                                    <input type="hidden" name="price_level_id" :value="!selected_priceLevelGeneral?null:selected_priceLevelGeneral.id">
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    @endif
                                                                    @if(systemConfig()[13] != 0 )
                                                                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                                            <div class="form-group">
                                                                                <div class="col-md-12">
                                                                                    <label class="control-label">@lang('menu.Membercloth')</label>
                                                                                    <v-select class="vue-select2" label="name" :options="member_cloth_list" v-model="selectedMemberCloth">
                                                                                    </v-select>
                                                                                    <input type="hidden" name="member_cloth_id" v-model.number="(!selectedMemberCloth)?null:selectedMemberCloth.id">
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    @endif
                                                                    <div class="col-lg-5 col-md-5 col-sm-12 col-xs-12">
                                                                        <div class="form-group">
                                                                            <div class="col-md-12">
                                                                                <label class="control-label">@lang('layout.Customer')</label>
                                                                                <div class="input-group">
                                                                                    <v-select label="name" @input="memberChange(),getSummary()" @search="MemberSearch" :options="customer" v-model="selected_customer"></v-select>
                                                                                    <input type="hidden" name="customer" :value="!selected_customer?null:selected_customer.id" required>
                                                                                    <span class="btn btn-success input-group-addon " title="@lang('button.AddNewCustomer')" @click="showModal = true" style="background-color:  rgb(84, 199, 211)">
                                                                                        <i class="fa fa-plus" style="color: white"></i>
                                                                                    </span>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    </div>
                                                                    <div class="row">
                                                                    @if(systemConfig()[27] == 1)
                                                                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                                            <div class="form-group">
                                                                                <div class="col-md-12">
                                                                                    <label class="control-label">@lang('menu.GasStation')</label>
                                                                                    <v-select class="vue-select2" label="name" :options="oilPart" v-model="selectedOilPart" @keyup.native="setSaleNumber()" @click.native="editKey = true" @input="(editKey)?setSaleNumber():''">
                                                                                    </v-select>
                                                                                    <input type="hidden" name="oil_part_id" v-model.number="(!selectedOilPart)?null:selectedOilPart.id">
                                                                                </div>
                                                                            </div>
                                                                        </div>

                                                                        <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                                            <div class="form-group">
                                                                                <div class="col-md-12">
                                                                                    <label class="control-label">@lang('layout.OldCounter')</label>
                                                                                    <input type="number" v-model="old_oil_counter" name="old_oil_counter" class="form-control"  readonly>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                                            <div class="form-group">
                                                                                <div class="col-md-12">
                                                                                    <label class="control-label">@lang('layout.NewCounter')</label>
                                                                                    <input type="number" name="new_counter" class="form-control" v-model="NewCounter" @input="NewCounters()"> 
                                                                                </div>
                                                                            </div>
                                                                        </div>

                                                                    @endif
                                                                    
                                                                    <div v-show="showWhat('descriptionASMemberName')=='yes'" class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                                        <div class="form-group">
                                                                            <div class="col-md-12">
                                                                                <label class=" control-label">@lang('layout.OtherMemberName')</label>
                                                                                <div>
                                                                                    <input type="text" name="other_member_name" value="{{$invoice->other_member_name}}" class="form-control">
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                                        <div class="form-group">
                                                                            @if($duplicate)
                                                                            <div class="col-md-12"> 
                                                                                <label class="control-label">@lang('layout.InvoiceNumber')</label>
                                                                                <input type="number" name="number" value="{{$numberDuplicate}}"  class="form-control">
                                                                            </div>
                                                                            @else 
                                                                            <div class="col-md-12"> 
                                                                                <label class="control-label">@lang('layout.InvoiceNumber')</label>
                                                                                <input type="number" name="number" v-model="number" class="form-control">
                                                                            </div>
                                                                            @endif
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="row">
                                                                    <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                                        <div class="form-group">
                                                                            <div class="col-md-12">
                                                                                <label class="control-label">@lang('layout.ReferenceNumber')</label>
                                                                                <input type="text" name="ref_no" v-model="ref_no" class="form-control" @input="checkRefNo()">
                                                                                <span v-if="isError1 ==true" class="input-has-error" style="color: red">@{{msg}}</span>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                                        <div class="form-group">
                                                                            <div class="col-md-12">
                                                                                <label class="control-label">@lang('layout.Currency')</label>
                                                                                <v-select label="code" @input="selectedRate" @keyup.native="changeStaticRate()" @Click.native="changeStaticRate()" :options="currency" v-model="selected_currency"></v-select>
                                                                                <input type="hidden" name="currency" :value="selected_currency.code">
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                                        <div class="form-group">
                                                                            <div class="col-md-12">
                                                                                <label class="control-label">@lang('layout.Rate')</label> 
                                                                                <input type="number" name="currency_rate" name="rate" v-model="!selected_currency?0:selected_currency.rate" class="form-control" :class="{'has-error':rate<=0}">
                                                                                <input type="hidden" name="currency_rate_hq" v-model="!selected_currency?0:selected_currency.hq_rate" class="form-control">
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                                        <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                                                            <div class="form-group">
                                                                                <div class="">
                                                                                    <label class="control-label">@lang('layout.Date')</label>
                                                                                    <input type="text" name="date" class="form-control date" value="{{$invoice->date}}" autocomplete="off"
                                                                                    @if(getDateRequired() == 'true') v-validate='"required"' data-vv-as="@lang('layout.Date')" @endif>
                                                                                    <span class="required">@{{ errors.first('date') }}</span>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                                                            <div class="form-group">
                                                                                <div class="">
                                                                                    <label class="control-label">@lang('layout.Hour')</label>
                                                                                    <div class="input-group">
                                                                                        @if(getHourType() == 24)
                                                                                        <input type="text" class="form-control timepicker timepicker-24" name="hour" value="{{$invoice->hour}}">
                                                                                        @else
                                                                                        <input type="text" class="form-control timepicker timepicker-no-seconds" name="hour" value="{{$invoice->hour}}" >
                                                                                        @endif
                                                                                        <span class="input-group-btn">
                                                                                            <button class="btn default" type="button">
                                                                                                <i class="fa fa-clock-o"></i>
                                                                                            </button>
                                                                                        </span>
                                                                                    </div>
                                                                                    {{-- <input type="text" name="date" class="form-control date" value="{{$invoice->date}}" autocomplete="off"> --}}
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                                                        @if(showVendorInFactor() == 'true')
                                                                        <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                                                            <div class="form-group">
                                                                                <div class="col-md-12">
                                                                                    <label class="control-label">@lang('layout.VendorName')</label>
                                                                                    <input type="text" name="vendor_name" class="form-control" value="{{$invoice->vendor_name}}">
                                                                                </div>
                                                                            </div>
                                                                        </div> 
                                                                        <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                                                            <div class="form-group">
                                                                                <div class="col-md-12">
                                                                                    <label class="control-label">@lang('layout.Description')</label>
                                                                                    <textarea name="description" class="form-control" rows="1">{{$invoice->description}}</textarea>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                        @else  
                                                                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                                                            <div class="form-group">
                                                                                <div class="col-md-12">
                                                                                    <label class="control-label">@lang('layout.Description')</label>
                                                                                    <textarea name="description" class="form-control" rows="1">{{$invoice->description}}</textarea>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                        @endif
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!--BEGIN TAX / COMMISSION-->
                                                    <div class="tab-pane" id="tab2">
                                                        <div class="row">
                                                            @if(getTaxation()=="true" || getSaleTaxation() == 'true')
                                                            <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                                                <div class="panel panel-default">
                                                                    <div class="panel-heading">
                                                                        <h3 class="panel-title">@lang('layout.Tax')</h3>
                                                                    </div>
                                                                    <div class="panel-body">
                                                                        <div class="row">
                                                                        <!--Begin Taxation -->
                                                                                @if(getTaxation()=="true")
                                                                                    <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                                                                        <div class="form-group">

                                                                                            <div class="col-md-12">
                                                                                                <label class="control-label">@lang('layout.Tax')</label>
                                                                                                <v-select v-model="selected_taxation" label="name" :options="taxation">
                                                                                                </v-select>
                                                                                                <input type="hidden" name="taxation_id" :value="!selected_taxation?null:selected_taxation.id" />
                                                                                                <input type="hidden" name="taxation_vendor_id" :value="!selected_taxation?null:selected_taxation.member_id" />
                                                                                                <input type="hidden" name="taxation_value" :value="subTotalTax" readonly />
                                                                                            </div>
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                                                                        <div class="form-group">

                                                                                            <div class="col-md-12">
                                                                                                <label class="control-label">@lang('layout.Percentage') %</label>
                                                                                                <input type="number" name="percent_tax" class="form-control" v-model="!selected_taxation?null:selected_taxation.percent">
                                                                                            </div>
                                                                                        </div>
                                                                                    </div>
                                                                                @endif
                                                                                <!--End Taxation -->

                                                                        </div>
                                                                        <div class="row">
                                                                            @if(getSaleTaxation() == 'true')
                                                                            <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                                                                <div class="form-group">
                                                                                    <div class="col-md-12">
                                                                                        <label class="control-label">@lang('layout.Tax')</label>

                                                                                        <div class="input-group">

                                                                                            <input v-model="sale_taxation" class="form-control" type="number" min="0" max="100" />
                                                                                            <span class="input-group-addon">%</span>
                                                                                            <input type="hidden" name="sale_taxation" :value="sale_taxation" />
                                                                                            <input type="hidden" name="sale_taxation_value" :value="saleTaxation" />
                                                                                        </div>

                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                            @endif
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            @endif
                                                            @if(getSaleCommission()=="true")
                                                            <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                                                <div class="panel panel-default">
                                                                    <div class="panel-heading">
                                                                        <h3 class="panel-title">@lang('layout.Commission')</h3>
                                                                    </div>
                                                                    <div class="panel-body">
                                                                        <!--Begin commission -->
                                                                        @if(getSaleCommission()=="true")
                                                                        <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                                                            <div class="form-group">

                                                                                <div class="col-md-12">
                                                                                    <label class="control-label">@lang('layout.Commission')</label>
                                                                                    <v-select v-model="selected_commission" label="name" :options="commission">
                                                                                    </v-select>
                                                                                    <input type="hidden" name="commission_id" :value="!selected_commission?null:selected_commission.id" />
                                                                                    <input type="hidden" name="commission_vendor_id" :value="!selected_commission?null:selected_commission.member_id" />
                                                                                    <input type="hidden" name="commission_expense_id" :value="!selected_commission?null:selected_commission.expense_id" />
                                                                                    <input type="hidden" name="commission_value" :value="subTotalCommi" readonly />
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                                                            <div class="form-group">

                                                                                <div class="col-md-12">
                                                                                    <label class="control-label">@lang('layout.Percentage') %</label>
                                                                                    <input type="number" name="commission_percent" class="form-control" v-model="!selected_commission?null:selected_commission.percent">
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                        @endif
                                                                        <!--End commission -->
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            @endif
                                                        </div>
                                                    </div>
                                                    <!--END TAX / COMMISSION-->
                                                    <!--BEGIN TransportCompany-->
                                                    <div class="tab-pane" id="tab3">
                                                        <div class="row">
                                                            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                                                <div class="panel panel-default">
                                                                    <div class="panel-heading" style="background: transparent;">
                                                                        <h3 class="panel-title text-center">@lang('menu.TransportCompany')</h3>
                                                                    </div>
                                                                    <div class="panel-body">
                                                                        <div class="row">
                                                                            <!--Begin Transport Company-->
                                                                            @if(getTransportCompany()=="true")
                                                                            <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                                                                <div class="form-group">
                                                                                    <div class="col-md-12">
                                                                                        <label class="control-label">@lang('menu.TransportCompany')</label>
                                                                                        <v-select v-model="selected_transportCompany" label="name" :options="transportCompany" @input="getDrivers" @click.native="getAllDrivers">
                                                                                        </v-select>
                                                                                        <input type="hidden" name="transportCompany_id" :value="!selected_transportCompany?null:selected_transportCompany.id">
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                            <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                                                                <div class="form-group">
                                                                                    <div class="col-md-12">
                                                                                        <label class="control-label">@lang('layout.Driver')</label>
                                                                                        <v-select label="name" :options="t_drivers" v-model="selected_transportDriver">
                                                                                        </v-select>
                                                                                        <input type="hidden" name="trasnsport_driver_id" :value="!selected_transportDriver?null:selected_transportDriver.id">
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                            @endif
                                                                            <!--End Transport Company-->
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!--END TransportCompany-->
                                                    <div class="tab-pane" id="tab4" style="padding: 0 10px 0 10px">
                                                        <div class="row">
                                                            <div class="col-lg-12 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px; padding: 20px !important;">
                                                                <div class="row">
                                                                    <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                                        <div class="form-group">
                                                                            <div class="col-md-12">
                                                                                <label class="control-label">@lang('layout.Discount')</label>
                                                                                <div class="input-group">
                                                                                    <input v-model="discountFiled" class="form-control" type="number" min="0" max="100">
                                                                                    <span v-if="discountIsAmount" @click="discountIsAmount = !discountIsAmount" class="input-group-addon">@{{selected_currency.symbol}}
                                                                                        <input type="hidden" class="input-group-addon" name="discount_type" value="currency">
                                                                                    </span>
                                                                                    <span v-else @click="discountIsAmount = !discountIsAmount" class="input-group-addon">%
                                                                                        <input type="hidden" name="discount_type" value="percent">
                                                                                    </span>
                                                                                    <input type="hidden" name="discountTotal" :value="discount">
                                                                                    <input type="hidden" name="discount" :value="discountFiled">
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <!--Begin Sale Discount Date -->
                                                                    @if(getSaleDiscountDate()=="true")
                                                                        <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                                            <div class="form-group">
                                                                                <div class="col-md-12">
                                                                                    <label class="control-label">@lang('menu.DiscountDate')</label>
                                                                                    <v-select v-model="selected_discount_date" label="name" :options="discount_date">
                                                                                    </v-select>
                                                                                    <input type="hidden" name="discount_date_id" :value="!selected_discount_date?null:selected_discount_date.id" />
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    @endif
                                                                    <!--End Sale Discount Date -->
                                                                    <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                                        <div class="form-group">
                                                                            <div class="col-md-12">
                                                                                <label class="control-label">@lang('layout.OverdueDate')</label>
                                                                                <input type="text" name="overdue_date" class="form-control date" value="{{$invoice->overdue_date}}" autocomplete="off">
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    @if(getChangeItem()=="true")
                                                                        <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                                            <div class="form-group">
                                                                                <div class="col-md-12">
                                                                                    <label class="control-label">@lang('layout.ExDate')</label>
                                                                                    <input type="text" name="alert_date" value="{{$invoice->alertDate}}" class="form-control date" autocomplete="off">
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                                            <div class="form-group">
                                                                                <div class="col-md-12">
                                                                                    <label class="control-label">@lang('layout.ExDescription')</label>
                                                                                    <textarea name="alert_description" class="form-control" rows="1">{{$invoice->alert_description}}</textarea>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    @endif
                                                                    <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                                        <div class="form-group">
                                                                            <div class="col-md-12">
                                                                                <label class="control-label">@lang('layout.Forgivness')</label>
                                                                                <select name="forgivness" id="" class="form-control form-select" v-model="forgivness">
                                                                                    <option selected value="">@lang('layout.Select')</option>
                                                                                    <option value="forgivness">@lang('layout.Forgivness')</option>
                                                                                    <option value="withoutForgivness">@lang('layout.WithoutForgivness')</option>
                                                                                </select>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="row" style="margin-top: 5px;">
                                                                    @if(getFactorPending()=="true")
                                                                        <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12" style="margin-bottom: 10px !important;">
                                                                            <table class="table table-striped table-bordered table-advance ">
                                                                                <tr>
                                                                                    <td class="t_body">
                                                                                        <div style="display: flex; justify-content: center;">
                                                                                            <label class="mt-checkbox mt-checkbox-outline">@lang('layout.Factor') @lang('layout.Pending')
                                                                                                <input type="checkbox" name="pending" value="on" <?php if ($invoice->pending == 'on') { echo "checked";} ?> >
                                                                                                <span></span>
                                                                                            </label>
                                                                                        </div>
                                                                                    </td>
                                                                                </tr>
                                                                            </table>
                                                                        </div>
                                                                    @endif
                                                                    @if(getNegativeSale() == 'true')
                                                                        <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12" style="margin-bottom: 10px !important;">
                                                                            <table class="table table-striped table-bordered table-advance ">
                                                                                <tr>
                                                                                    <td class="t_body">
                                                                                        <div style="display: flex; justify-content: center;">
                                                                                            <label class="mt-checkbox mt-checkbox-outline">@lang('layout.NegativeSale')
                                                                                                <input type="checkbox" name="negative_sale" <?php if ($invoice->sale_type == 'ok') {echo 'checked';} ?> value="ok">
                                                                                                <span></span>
                                                                                            </label>
                                                                                        </div>
                                                                                    </td>
                                                                                </tr>
                                                                            </table>
                                                                        </div>
                                                                    @endif
                                                                    @if(getActiveSale()=="true")
                                                                        <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12" style="margin-bottom: 10px !important;">
                                                                            <table class="table table-striped table-bordered table-advance ">
                                                                                <tr>
                                                                                    <td class="t_body">
                                                                                        <div style="display: flex; justify-content: center;">
                                                                                            <label class="mt-checkbox mt-checkbox-outline">@lang('layout.NotAprover')
                                                                                                <input type="checkbox" name="sale_status" <?php if ($invoice->sale_status == 'on') {echo 'checked';} ?> value="on">
                                                                                                <span></span>
                                                                                            </label>
                                                                                        </div>
                                                                                    </td>
                                                                                </tr>
                                                                            </table>
                                                                        </div>
                                                                    @endif
                                                                    @if(getSaleToBase() == 'true')
                                                                        <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12" style="margin-bottom: 10px !important;">
                                                                            <table class="table table-striped table-bordered table-advance ">
                                                                                <tr>
                                                                                    <td class="t_body">
                                                                                        <div style="display: flex; justify-content: center;">
                                                                                            <label class="mt-checkbox mt-checkbox-outline">@lang('layout.SaleBaseCurrency')
                                                                                                <input type="checkbox" name="sale_base_currency" <?php if ($invoice->sale_base_currency == 'ok') {echo 'checked';} ?> value="ok">
                                                                                                <span></span>
                                                                                            </label>
                                                                                        </div>
                                                                                    </td>
                                                                                </tr>
                                                                            </table>
                                                                        </div>
                                                                    @endif
                                                                    @if(oilSale() == 'true')
                                                                        <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12" style="margin-bottom: 10px !important;">
                                                                            <table class="table table-striped table-bordered table-advance ">
                                                                                <tr>
                                                                                    <td class="t_body">
                                                                                        <div style="display: flex; justify-content: center;">
                                                                                            <label class="mt-checkbox mt-checkbox-outline">@lang('layout.Oil')
                                                                                                <input type="checkbox" @click="ChangeOil" <?php if ($invoice->oil == 1) {echo 'checked';} ?> name="oil_sale" value="ok">
                                                                                                <span></span>
                                                                                            </label>
                                                                                        </div>
                                                                                    </td>
                                                                                </tr>
                                                                            </table>
                                                                        </div>
                                                                    @endif
                                                                    @if(getSaleByOtherMeasure() == "true")
                                                                        <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12" style="margin-bottom: 10px !important;">
                                                                            <table class="table table-striped table-bordered table-advance ">
                                                                                <tr>
                                                                                    <td class="t_body">
                                                                                        <div style="display: flex; justify-content: center;">
                                                                                            <label class="mt-checkbox mt-checkbox-outline">@lang('layout.PerQty')
                                                                                                <input type="checkbox" name="per_qty_check" v-model="per_qty_check" <?php if ($invoice->per_qty == 'on') { echo 'checked';} ?>>
                                                                                                <span></span>
                                                                                            </label>
                                                                                        </div>
                                                                                    </td>
                                                                                </tr>
                                                                            </table>
                                                                        </div>
                                                                    @endif
                                                                    @if(getSaleByOtherMeasureRate() == "true")
                                                                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12" style="margin-bottom: 10px !important;">
                                                                            <table class="table table-striped table-bordered table-advance ">
                                                                                <tr>
                                                                                    <td class="t_body">
                                                                                        <div style="display: flex; justify-content: center;">
                                                                                            <label class="mt-checkbox mt-checkbox-outline">@lang('layout.SaleByOtherMeasureRate')
                                                                                                <input type="checkbox" name="per_qty_check" v-model="per_qty_check" <?php if ($invoice->per_qty == 'on') {echo 'checked'; } ?>>
                                                                                                <span></span>
                                                                                            </label>
                                                                                        </div>
                                                                                    </td>
                                                                                </tr>
                                                                            </table>
                                                                        </div>
                                                                    @endif
                                                                    @if(ShowSaveTempItemToCustomer() == "true")
                                                                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12" style="margin-bottom: 10px !important;">
                                                                            <table class="table table-striped table-bordered table-advance ">
                                                                                <tr>
                                                                                    <td class="t_body">
                                                                                        <div style="display: flex; justify-content: center;">
                                                                                            <label class="mt-checkbox mt-checkbox-outline">@lang('layout.SaveTempItemToCustomer')
                                                                                                <input type="checkbox" name="save_temp_item" value="yes" <?php if ($invoice->save_temp_item == 'yes') {echo 'checked';} ?>>
                                                                                                <span></span>
                                                                                            </label>
                                                                                        </div>
                                                                                    </td>
                                                                                </tr>
                                                                            </table>
                                                                        </div>
                                                                    @endif
                                                                    {{-- @if(salePriceCalculate() == "static_item_price")
                                                                    <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12" style="margin-bottom: 10px !important;">
                                                                        <table class="table table-striped table-bordered table-advance ">
                                                                            <tr>
                                                                                <td class="t_body">
                                                                                    <div style="display: flex; justify-content: center;">
                                                                                        <label class="mt-checkbox mt-checkbox-outline">@lang('menu.StaticItemPrice')
                                                                                            <input type="checkbox" name="static_item_price"  v-model="static_item_price">
                                                                                            <span></span>
                                                                                        </label>
                                                                                    </div>
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </div>
                                                                @endif --}}
                                                                {{-- AAA --}}
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="tab-pane" id="tab5" style="padding: 0 10px 0 10px">
                                                        @if(ShowLastSale()=="true")
                                                        <div class="row">
                                                            <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                                                <div class="well" v-if="last_item_sale != null && last_item_sale != ''" style="overflow-x: scroll; height:130px; padding: 5px 1px 1px 1px; margin-bottom: 5px;background: transparent;">
                                                                    <table class="dashboard-tabel table-bordered" width="100%">
                                                                                <tr>
                                                                                    <td style="text-align: center">@lang('layout.Customer')</td>
                                                                                    <td style="text-align: center">@lang('layout.Unit')</td>
                                                                                    <td style="text-align: center">@lang('layout.SalePrice')</td>
                                                                                </tr>
                                                                                <tr v-for="(last_it,index) in last_item_sale">
                                                                                    <td style="text-align: center">@{{last_it.member}}</td>
                                                                                    <td style="text-align: center">@{{last_it.Measure}}</td>
                                                                                    <td style="text-align: center">@{{myRound(last_it.price)}} @{{last_it.currency}}</td>
                                                                                </tr>
                                                                    </table>
                                                                </div>
                                                            </div>
                                                            <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                                                <div class="well" v-if="last_item_purchase != null && last_item_purchase != ''" style="overflow-x: scroll; height:110px; padding: 5px 1px 1px 1px; margin-bottom: 5px;background: transparent;">
                                                                    <table class="dashboard-tabel table-bordered" width="100%">
                                                                                <tr>
                                                                                    <td style="text-align: center">@lang('layout.Vendor')</td>
                                                                                    <td style="text-align: center">@lang('layout.Unit')</td>
                                                                                    <td style="text-align: center">@lang('layout.Cost')</td>
                                                                                </tr>
                                                                                <tr v-for="(last_it,index) in last_item_purchase">
                                                                                    <td style="text-align: center">@{{last_it.member}}</td>
                                                                                    <td style="text-align: center">@{{last_it.Measure}}</td>
                                                                                    <td style="text-align: center">@{{myRound(last_it.cost)}} @{{last_it.currency}}</td>
                                                                                </tr>
                                                                    </table>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        @endif
                                                    </div>
                                                </div>
                                            {{-- </div> --}}
                                            @if(systemConfig()[23] == 1)
                                                <!--Begin search Item-->
                                                <div class="col-lg-12 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px; padding: 10px 15px !important;">
                                                    <div class="row" style="padding: 0px 10px;">
                                                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                            <div class="form-group">
                                                                <!-- <div class="col-md-12"> -->
                                                                <!-- <label class="control-label">@lang('layout.ItemName')</label> -->
                                                                <v-select label="name" ref="barcode_search" @input="loadItemGeneral(), editKey = false" v-model="selected_inventory" :options="temp_items" @search="onItemSearch" placeholder="@lang('layout.ItemName')"></v-select>
                                                                <!-- </div> -->
                                                            </div>
                                                            <p v-if="selected_itemes" style="background-color: rgb(216 222 239)">
                                                                @lang('layout.OnHand'):@{{(selected_itemes)?(Number.parseFloat(selected_itemes.on_hand * selected_itemes.measure_unit / selected_itemes.measure.measure_unit).toFixed(2)):''}} @{{(selected_itemes)?selected_itemes.measure.measure_name:''}}
                                                            </p>
                                                        </div>
                                                        <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                            <div class="form-group">
                                                                <!-- <label class="control-label">@lang('layout.Site')</label> -->
                                                                <v-select label="name" v-model="selected_iventory_site" :options="inventory_sites" placeholder="@lang('layout.Site')"></v-select>
                                                            </div>
                                                            <p v-if="selected_itemes && selected_iventory_site">
                                                                @{{(selected_itemes && selected_iventory_site)?(Number.parseFloat(selected_iventory_site.OnHand * selected_itemes.measure_unit / selected_itemes.measure.measure_unit).toFixed(2)):''}}
                                                            </p>
                                                        </div>
                                                        <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                            <div class="form-group">
                                                                <!-- <div class="col-md-12"> -->
                                                                <!-- <label class="control-label">@lang('layout.Quantity')</label> -->
                                                                <input type="number" v-model.number="selected_quantity" ref="selected_quantity" class="form-control input-style input-number" placeholder="@lang('layout.Quantity')">
                                                                <span class="required" v-if="selected_quantity_error">@lang('layout.Quantity')</span>
                                                                <!-- </div> -->
                                                            </div>
                                                            <p v-if="AdvancePrice">
                                                                @lang('layout.ByAdvancePricing') : @{{ AdvancePrice }}
                                                            </p>
                                                        </div>
                                                        <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                            <div class="form-group">
                                                                <!-- <div class="col-md-12"> -->
                                                                <!-- <label class="control-label">@lang('layout.Quantity')</label> -->
                                                                <select v-model="(selected_itemes == null)?null:selected_itemes.measure" class="form-control">
                                                                    <option value="null">@lang('layout.Select')</option>
                                                                    <span v-if="(selected_itemes ==null)?false:true">
                                                                        <option v-for="measure in (selected_itemes==null)?null:selected_itemes.measure_list" :value="measure">
                                                                            @{{measure.measure_name}}
                                                                        </option>
                                                                    </span>
                                                                </select>
                                                                <!-- </div> -->
                                                            </div>
                                                            @if(systemConfig()[30] == 1)
                                                            <p v-if="AdvancePrice_cost && AdvancePrice">
                                                                @lang('layout.Price') : @{{(selected_itemes==null)?null:Number.parseFloat((AdvancePrice_cost * selected_itemes.measure.measure_unit / selected_itemes.measure_unit) * selected_currency.static_rate / selected_currency.rate).toFixed(precision())}} @{{selected_currency.symbol}}
                                                            </p>
                                                            @else 
                                                            <p v-if="AdvancePrice_cost && AdvancePrice">
                                                                @lang('layout.Price') : @{{(selected_itemes==null)?null:Number.parseFloat((AdvancePrice_cost * selected_itemes.measure.measure_unit / selected_itemes.measure_unit) * selected_currency.rate).toFixed(precision())}} @{{selected_currency.symbol}}
                                                            </p>
                                                            @endif

                                                        </div>
                                                        <div class="col-lg-1 col-md-1 col-sm-12 col-xs-12" v-show="seePrice==true">
                                                            <div class="form-group">
                                                                <!-- <div class="col-md-12"> -->
                                                                <!-- <label class="control-label">@lang('layout.Price')</label> -->
                                                                <input type="number" v-model.number="selected_price" class="form-control input-style input-number" placeholder="@lang('layout.Price')">
                                                                <!-- </div> -->
                                                            </div>
                                                            @if(systemConfig()[30] == 1)
                                                            <p v-if="selected_itemes && seeCost==true" style="background-color: rgb(216 222 239)">
                                                                @lang('layout.CostInInventory'): @{{(selected_itemes==null)?null:Number.parseFloat((selected_itemes.LasCost * selected_itemes.measure.measure_unit / selected_itemes.measure_unit) * selected_currency.static_rate / selected_currency.rate).toFixed(precision())}} @{{selected_currency.symbol}}
                                                            </p>
                                                            @else 
                                                            <p v-if="selected_itemes && seeCost==true" style="background-color: rgb(216 222 239)">
                                                                @lang('layout.CostInInventory'): @{{(selected_itemes==null)?null:Number.parseFloat((selected_itemes.LasCost * selected_itemes.measure.measure_unit / selected_itemes.measure_unit) * selected_currency.rate).toFixed(precision())}} @{{selected_currency.symbol}}
                                                            </p>
                                                            @endif
                                                        </div>
                                                        <div class="col-lg-1 col-md-1 col-sm-12 col-xs-12" style="padding: 0px !important;">
                                                            @lang('layout.Total'): @{{(selected_itemes==null)?null:Number.parseFloat(selected_quantity * selected_price).toFixed(precision())}} @{{selected_currency.symbol}}
                                                        </div>
                                                        <div class="col-lg-1 col-md-1 col-sm-12 col-xs-12" style="padding: 0px !important;display: flex; justify-content: center; gap: 5px;">
                                                            <button type="button" @click="addData()" class="btn btn-success"><i class="fa fa-plus"></i></button>
                                                            <button type="button" @click="resetData()" class="btn btn-danger"><i class="fa fa-times"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            @endif
                                        </div>
                                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                            <div class="col-lg-12 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px;margin-bottom: 1em;">
                                                <div class="row" style="padding: 10px 20px;">
                                                    <div class="well " style="padding: 5px 1px 1px 1px; margin-bottom: 5px;background: transparent;">
                                                        <table class="dashboard-tabel" width="100%">
                                                            <tr>
                                                                <td colspan="2">
                                                                    <small style="font-weight: bolder;font-size:20px">@lang('layout.Total') :</small>
                                                                </td>
                                                                <td class="text-right" colspan="2">
                                                                    <span data-counter="counterup" data-value="7800" style="font-weight: bolder;font-size:20px">
                                                                        @{{ format_number(Number.parseFloat(((subtotal - (discount*(newSubTotal - newSubDiscountFiledRow)/100) - discountFiledRow) - saleTaxation)-payeds - total_return))}}
                                                                    </span>
                                                                    <small class="font-green-sharp">
                                                                        @{{selected_currency.symbol}}
                                                                    </small>
                                                                </td>
                                                            </tr>       
                                                            <tr>
                                                                <td>
                                                                    <small>@lang('layout.Discount'): (@{{
                                                                            Number.parseFloat(discount).toFixed(precision())
                                                                            }}%)
                                                                    </small>
                                                                </td>
                                                                <td class="text-right">
                                                                    <span class="text-right" data-counter="counterup" data-value="7800">
                                                                        @{{ format_number(Number.parseFloat(discount*(newSubTotal - newSubDiscountFiledRow)/100)+Number.parseFloat(discountFiledRow)) }}
                                                                    </span>
                                                                    <small class="font-green-sharp">
                                                                        @{{selected_currency.symbol}}
                                                                    </small>
                                                                </td>
                                                                <td>
                                                                    <small>@lang('layout.Payment'):</small>
                                                                </td>
                                                                <td class="text-right">
                                                                    <span class="text-right" data-counter="counterup" data-value="7800">@{{ payeds.toFixed(precision())}}</span>
                                                                    <small class="font-green-sharp">
                                                                        @{{selected_currency.symbol}}
                                                                    </small>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                @if(getSaleTaxation() == 'true')
                                                                <td>
                                                                    <small>@lang('menu.Taxation'): (@{{
                                                                            format_number(Number.parseFloat(sale_taxation))
                                                                            }}%)
                                                                    </small>
                                                                </td>
                                                                <td class="text-right">
                                                                    <span class="text-right" data-counter="counterup" data-value="7800">
                                                                        @{{ format_number(Number.parseFloat(saleTaxation)) }}
                                                                    </span>
                                                                    <small class="font-green-sharp">
                                                                        @{{selected_currency.symbol}}
                                                                    </small>
                                                                </td>
                                                                @endif
                                                                <td>
                                                                    <small>@lang('layout.Leakage'):</small>
                                                                </td>
                                                                <td class="text-right">
                                                                    <span class="text-right" data-counter="counterup" data-value="7800">@{{ format_number(Number(total_return))}}</span>
                                                                    <small class="font-green-sharp">
                                                                        @{{selected_currency.symbol}}
                                                                    </small>
                                                                </td>
                                                            </tr>                                                      
                                                            <tr>
                                                                <td colspan="2">
                                                                    <small>@lang('layout.GrandTotal'):</small>
                                                                </td>
                                                                <td class="text-right" colspan="2">
                                                                    <span class="text-right" data-counter="counterup" data-value="7800">@{{ subtotal.toFixed(precision())}}</span>
                                                                    <small class="font-green-sharp">
                                                                        @{{selected_currency.symbol}}
                                                                    </small>
                                                                </td>
                                                            </tr>        
                                                        </table>
                                                    </div>
                                                    @if(getTaxation() =="true")
                                                        <!-- begin total tax -->
                                                        <div class="well " v-show="seePrice== true" style="padding: 5px 1px 1px 1px; margin-bottom: 5px;background: transparent;">
                                                            <table class="dashboard-tabel" width="100%">
                                                                <tr>
                                                                    <td>
                                                                        <small>@lang('layout.Total') @lang('layout.Tax') :</small>
                                                                    </td>
                                                                    <td class="text-right">
                                                                        <span data-counter="counterup" data-value="7800">
                                                                            @{{ myRound(totalTax)}}
                                                                        </span>
                                                                        <small class="font-green-sharp">
                                                                            @{{selected_currency.symbol}}
                                                                        </small>
                                                                    </td>
                                                                    <td>
                                                                        <small>@lang('layout.Sub-Total'):</small>
                                                                    </td>
                                                                    <td class="text-right">
                                                                        <span class="text-right" data-counter="counterup" data-value="7800">
                                                                            @{{ format_number(Number(checkedSubtotal))}}
                                                                        </span>
                                                                        <small class="font-green-sharp">
                                                                            @{{selected_currency.symbol}}
                                                                        </small>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                        </div>
                                                        <!-- end total -->
                                                    @endif
                                                    @if(getSaleCommission() =="true")
                                                        <!-- begin total commission -->
                                                        <div class="well " v-show="seePrice== true" style="padding: 5px 1px 1px 1px; margin-bottom: 5px;background: transparent;">
                                                            <table class="dashboard-tabel" width="100%">
                                                                <tr>
                                                                    <td>
                                                                        <small>@lang('layout.Total') @lang('layout.Commission') :</small>
                                                                    </td>
                                                                    <td class="text-right">
                                                                        <span data-counter="counterup" data-value="7800">
                                                                            @{{ myRound(totalCommi)}}
                                                                        </span>
                                                                        <small class="font-green-sharp">
                                                                            @{{selected_currency.symbol}}
                                                                        </small>
                                                                    </td>
                                                                    <td>
                                                                        <small>@lang('layout.Sub-Total'):</small>
                                                                    </td>
                                                                    <td class="text-right">
                                                                        <span class="text-right" data-counter="counterup" data-value="7800">
                                                                            @{{ format_number(Number(checkedSubtotal))}}
                                                                        </span>
                                                                        <small class="font-green-sharp">
                                                                            @{{selected_currency.symbol}}
                                                                        </small>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                        </div>
                                                        <!-- end total -->
                                                    @endif
                                                    @if(getSubTotal() == 'true')
                                                        <div class="well" style="padding: 5px 1px 1px 1px; margin-bottom: 5px;background: transparent;">
                                                            <table class="dashboard-tabel table-bordered" width="100%">
                                                                    <tr>
                                                                        <td>
                                                                            <center>@lang('layout.Sub-Total')</center>
                                                                        </td>
                                                                        <td class="highlight">
                                                                            <center>
                                                                                <span class="text-right" data-counter="counterup" data-value="7800">
                                                                                    @{{ format_number(Number(sub_Subtotal))}}
                                                                                </span>
                                                                                <small class="font-green-sharp">
                                                                                    @{{selected_currency.symbol}}
                                                                                </small>
                                                                            </center>
                                                                        </td>
                                                                        <td>
                                                                            <center>@lang('layout.Discount'): (@{{
                                                                                format_number(Number.parseFloat(discount))
                                                                                }}%)
                                                                            </center>
                                                                        </td>
                                                                        <td class="hidden-xs">
                                                                            <center>
                                                                                <span class="text-right" data-counter="counterup" data-value="7800">
                                                                                    @{{ format_number(Number.parseFloat(sub_discount*(sub_Subtotal - subDiscountFiledRow)/100)+Number.parseFloat(subDiscountFiledRow)) }}
                                                                                </span>
                                                                                <small class="font-green-sharp">
                                                                                    @{{selected_currency.symbol}}
                                                                                </small>
                                                                            </center>
                                                                        </td>
                                                                        <td>
                                                                            <center>@lang('layout.Total')</center>
                                                                        </td>
                                                                        <td>
                                                                            <center>
                                                                                <span data-counter="counterup" data-value="7800">
                                                                                    @{{ format_number(Number.parseFloat((sub_Subtotal - (sub_discount*(sub_Subtotal - subDiscountFiledRow)/100) - subDiscountFiledRow) - saleTaxation))}}
                                                                                </span>
                                                                                <small class="font-green-sharp">
                                                                                    @{{selected_currency.symbol}}
                                                                                </small>
                                                                            </center>
                                                                        </td>
                                                                    </tr>
                                                            </table>
                                                        </div>
                                                    @endif
                                                    <div class="well" v-if="selected_customer" style="padding: 5px 1px 1px 1px;background: transparent;">
                                                        <table class="dashboard-tabel table-bordered" width="100%">
                                                            <tr>
                                                                <td style="text-align: center">@lang('layout.Currency') </td>
                                                                <td style="text-align: center">@lang('layout.Payable')</td>
                                                                <td style="text-align: center">@lang('layout.Receivable')</td>
                                                            </tr>
                                                            <tr v-for="summ in summary">
                                                                <td style="text-align: center">
                                                                    @{{ summ.currency }}
                                                                </td>
                                                                <td style="text-align: center"> @{{ format_number(Number(summ.payment)) }}</td>
                                                                <td style="text-align: center">
                                                                    @{{format_number(Number(summ.invoice)) }}
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-body">
                                        <div class="row" v-if="inventories.length>0" style="overflow-x: scroll;">
                                            @if(systemConfig()[23] == 1)
                                            <table id="table_content" class="table table-bordered table-advance table-hover">
                                                <thead>
                                                    <tr>
                                                        <th>#</th>
                                                        <th>@lang('layout.Edit')</th>
                                                        @if(getTaxation() =="true")
                                                        <th>@lang('layout.Tax')</th>
                                                        @endif

                                                        @if(getSaleCommission()=="true")
                                                        <th>@lang('layout.Commission')</th>
                                                        @endif 

                                                        <th v-show="showWhat('sale_category')=='yes'" style="min-width: 130px">@lang('layout.Category') </th>
                                                        <th v-show="showWhat('inventory_brand')=='yes'" style="min-width: 130px">@lang('layout.Brand') </th>
                                                        <th style="min-width: {{itemFieldWidth()}}px">@lang('layout.ItemName') </th>
                                                        @if(searchByCodeLocation()=="true")
                                                        <th style="min-width: 110px;">@lang('layout.Location')</th>
                                                        @endif
                                                        @if(getSerailNumber() =="true")
                                                        <th style="min-width: 100px">@lang('layout.SerialNum') </th>
                                                        @endif
                                                        <th style="min-width: 100px">@lang('layout.SiteName') </th>
                                                        <th v-show="showWhat('sale_description')=='yes'" style="min-width: 100px">@lang('layout.Description') </th>
                                                        <th v-show="showWhat('sale_description2')=='yes'" style="min-width: 100px">@lang('layout.Description')
                                                            :2
                                                        </th>
                                                        <th style="min-width: 100px">@lang('layout.Quantity') </th>
                                                        <th style="min-width: 100px">@lang('layout.OnHand') </th>
                                                        <th v-show="showWhat('other_measure')=='yes'" style="min-width: 100px">@lang('layout.OMeasureValue1')
                                                        </th>
                                                        <th v-show="showWhat('other_measure2')=='yes'" style="min-width: 100px">@lang('layout.OMeasureValue2')
                                                        </th>
                                                        <th style="min-width: 100px">@lang('layout.Measure') </th>
                                                        @if(itemPicture()=="true")
                                                        <th style="min-width: 100px">@lang('layout.Photo') </th>
                                                        @endif
                                                        <th v-show="seeCost==true" style="min-width: 80px">@lang('layout.CostInInventory') </th>
                                                        <th v-if="oil_sale == true && seeCost==true" style="min-width: 100px">@lang('layout.OilCostInInventory')</th>
                                                        <th v-if="oil_sale == true" style="min-width: 100px">@lang('layout.Density') </th>
                                                        <th v-if="oil_sale == true" style="min-width: 100px">@lang('layout.OilQuantity') </th>
                                                        <th v-if="oil_sale == true" style="min-width: 100px">@lang('layout.Measure') </th>
                                                        @if(getShwoPriceLevel()=="per_item")
                                                        <th style="min-width: 100px">@lang('layout.PriceLevel') </th>
                                                        @endif
                                                        @if(getShwoPriceLevel()=="general_percent_per_item")
                                                        <th style="min-width: 100px">@lang('layout.PriceLevel') </th>
                                                        @endif
                                                        <th v-show="seePrice==true" style="min-width: 100px">@lang('layout.NewPrice') </th>
                                                        @if(getM2()!="")
                                                        @if(getFactorMeasure2()=="true")
                                                        <th style="min-width: 100px">@lang('layout.Measure2') </th>
                                                        @endif
                                                        @endif
                                                        @if(getSaleSubMeasure()=="true")
                                                        <th style="min-width: 100px">@lang('layout.EquivalentTo') </th>
                                                        <th v-show="seePrice==true" style="min-width: 100px">@lang('layout.SubPrice') </th>
                                                        @endif
                                                        @if(getM3()!="" && getSaleSubMeasure()!="true")
                                                        @if(getFactorMeasure3()=="true")
                                                        <th style="min-width: 100px">@lang('layout.Measure3') </th>
                                                        @endif
                                                        @endif
                                                        @if(getM4()!="")
                                                        @if(getFactorMeasure4()=="true")
                                                        <th v-if="oil_sale == false" style="min-width: 100px">@lang('layout.Measure4') </th>
                                                        @endif
                                                        @endif

                                                        @if(getSaleCommission()=="true")
                                                        <th style="min-width: 100px">@lang('layout.Commission') @lang('layout.Percentage')%</th>
                                                        @endif

                                                        @if(getTaxation()=="true")
                                                        <th style="min-width: 100px">@lang('layout.Tax') </th>
                                                        <th style="min-width: 100px">@lang('layout.Percentage')%</th>
                                                        @endif
                                                        <th v-show="showWhat('sale_discount')=='yes'" style="min-width: 100px">@lang('layout.Discount') </th>
                                                        <th v-show="seePrice==true" style="min-width: 150px">@lang('layout.Total')
                                                        </th>
                                                        @if(getSubTotal() =="true")
                                                        <th v-show="seePrice==true">@lang('layout.Subtotal')</th>
                                                        @endif
                                                        <th></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr v-for="(item,index) in inventories">

                                                        <input type="hidden" name="sale_order_detail_id[]" :value="(item.item==null)?null:item.item.sale_order_detail_id">
                                                        <input type="hidden" :value="(!item.item)?null:item.item.online_order_detail_id" name="online_order_detail_id[]">
                                                        <td>@{{index+1}}</td>
                                                        <td>
                                                            <div class="mt-checkbox" style="padding-left: 0px;">
                                                                <label class="mt-checkbox mt-checkbox-outline">
                                                                    <input type="checkbox" v-model="item.edit" />
                                                                    <span></span>
                                                                </label>
                                                            </div>
                                                        </td>
                                                        @if(getTaxation() =="true")
                                                        <td>
                                                            <div class="mt-checkbox" style="padding-left: 0px;">
                                                                <label class="mt-checkbox mt-checkbox-outline">
                                                                    <input type="checkbox" :name="'row_tax_stat['+index+']'" v-model="item.tax" checked />
                                                                    <span></span>
                                                                </label>
                                                            </div>
                                                        </td>
                                                        @endif

                                                        @if(getTaxation() =="true")
                                                        <td>
                                                            <div class="mt-checkbox" style="padding-left: 0px;">
                                                                <label class="mt-checkbox mt-checkbox-outline">
                                                                    <input type="checkbox" :name="'row_tax_stat['+index+']'" v-model="item.tax" checked />
                                                                    <span></span>
                                                                </label>
                                                            </div>
                                                        </td>
                                                        @endif  

                                                        <td v-show="showWhat('sale_category')=='yes'">
                                                            <v-select label="name" v-model="item.item_category" :options="inventory_category" @keyup.native="itemCategoryChange(index)" @Click.native="itemCategoryChange(index)"></v-select>
                                                            <input type="hidden" name="inventory_category_id[]" :value="(!item.item_category)?null:item.item_category.id">
                                                        </td>
                                                        <td v-show="showWhat('inventory_brand')=='yes'">
                                                            <v-select label="name" v-model="item.item_brand" :options="brandItem" @Click.native="itemBrandChange(index)" @keyup.native="itemBrandChange(index)"></v-select>
                                                            <input type="hidden" name="inventory_brand_id[]" :value="(!item.item_brand)?null:item.item_brand.id">
                                                        </td>
                                                        <td class="highlight">
                                                            <v-select label="name" :disabled="!item.edit" @input="(item.edit)?onItemload(index):''" v-model="item.inventory" :options="temp_items" @search="onItemSearch" @Click.native="setIndex(index)" ></v-select>
                                                            <input type="hidden" name="inventory_id[]" :value="(!item.item)?null:item.item.id">
                                                        </td>
                                                        @if(searchByCodeLocation()=="true")
                                                        <td class="highlight">
                                                            <v-select label="name" :disabled="!item.edit" @Click.native="setIndex(index)" @input="(item.edit)?locationItemload(index):''" v-model="item.location" :options="(item.item==null)?[]:item.item.locationList" @search="locationSearch" ></v-select>
                                                            <input type="hidden" :name="'location['+index+']'" v-validate="''" data-vv-as="@lang('layout.Location')" :value="(!item.location)?null:item.location.name">
                                                        </td>
                                                        @endif
                                                        @if(getSerailNumber() =="true")
                                                        <td>
                                                            @{{(!item.item)?null:item.item.number}}
                                                        </td>
                                                        @endif
                                                        <td class="highlight">
                                                            <select v-model="(item.item==null)?null:item.item.site" @click="changeDensity(index)" class="form-control">
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(item.item != null)">
                                                                    <option v-for="site in (item.item==null)?null:item.item.site_list" :value="site">
                                                                        @{{site.site_name}}
                                                                    </option>
                                                                </span>
                                                            </select>
                                                            <input type="hidden" name="inventory_site[]" :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.site_id)">
                                                        </td>
                                                        <td v-show="showWhat('sale_description')=='yes'">
                                                            <input type="text" placeholder="@lang('layout.Description')" v-model="(item.item==null)?null:item.item.description" oninput = "autowidths(event)" name="inventory_description[]" class="form-control chan_length">
                                                        </td>
                                                        <td v-show="showWhat('sale_description2')=='yes'">
                                                            <input type="text" placeholder="@lang('layout.Description')" v-model="(item.item==null)?null:item.item.description2" oninput = "autowidths(event)" name="description2[]" class="form-control chan_length">
                                                        </td>

                                                        <td>
                                                            <input type="number" name="inventory_quantity[]" oninput = "autowidths(event)" v-model.number="(item.item==null)?null:item.item.quantity" class="form-control input-style input-number chan_length" @input="change_oil_qty(index)" placeholder="@lang('layout.Quantity')">
                                                        </td>

                                                        <td>
                                                            @{{myRound((item.item==null)?null:saleItemQuantity(item.item,item.item.quantity,0))}}
                                                        </td>
                                                        <td v-show="showWhat('other_measure')=='yes'">
                                                            <div class="input-group">
                                                                <input type="number" name="other_measure_amount[]" v-model.number="(item.item==null)?null:item.item.other_measure" oninput = "autowidths(event)" class="form-control input-style input-number chan_length" @input="change_per_qty(index)" placeholder="@lang('layout.OMeasureValue1')">
                                                                <input type="hidden" name="per_qty[]" :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.per_qty)">
                                                                @if(getCalQuantityOfOtherMeasure() == 'avgMethod')
                                                                <span class="input-group-addon" v-if="(item.item==null)?null:((item.item.site==null)?null:item.item.site.per_qty) > 0">
                                                                    @{{myRound((item.item==null)?null:((item.item.site==null)?null:(item.item.site.OnHand / item.item.site.per_qty)))}}
                                                                </span>
                                                                @elseif(getCalQuantityOfOtherMeasure() == 'simpleMethod')
                                                                <span class="input-group-addon" v-if="(item.item==null)?null:((item.item.site==null)?null:true)">
                                                                    @{{myRound((item.item==null)?null:((item.item.site==null)?null:item.item.site.other_measure))}}
                                                                </span>
                                                                @else
                                                                <span class="input-group-addon">
                                                                    @{{(item.item==null)?null:item.item.o_measure_v}}
                                                                </span>
                                                                @endif
                                                            </div>
                                                        </td>
                                                        <td v-show="showWhat('other_measure2')=='yes'">
                                                            <div class="input-group">
                                                                <input type="number" name="other_measure_amount2[]" v-model.number="(item.item==null)?null:item.item.other_measure2" oninput = "autowidths(event)" class="form-control input-style input-number chan_length" placeholder="@lang('layout.OMeasureValue2')">
                                                                <input type="hidden" name="per_qty2[]" :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.per_qty2)">
                                                                @if(getCalQuantityOfOtherMeasure() == 'avgMethod')
                                                                <span class="input-group-addon" v-if="(item.item==null)?null:((item.item.site==null)?null:item.item.site.per_qty2) > 0">
                                                                    @{{myRound((item.item==null)?null:((item.item.site==null)?null:(item.item.site.OnHand / item.item.site.per_qty2)))}}
                                                                </span>
                                                                @elseif(getCalQuantityOfOtherMeasure() == 'simpleMethod')
                                                                <span class="input-group-addon" v-if="(item.item==null)?null:((item.item.site==null)?null:true)">
                                                                    @{{myRound((item.item==null)?null:((item.item.site==null)?null:item.item.site.other_measure2))}}
                                                                </span>
                                                                @else
                                                                <span class="input-group-addon">
                                                                    @{{(item.item==null)?null:item.item.o_measure_v1}}
                                                                </span>
                                                                @endif
                                                            </div>
                                                        </td>
                                                        <td class="highlight">
                                                            <select v-model="(item.item == null)?null:item.item.measure" class="form-control" @change="measureChange(index)">
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(item.item ==null)?false:true">
                                                                    <option v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure">
                                                                        @{{measure.measure_name}}
                                                                    </option>
                                                                </span>


                                                            </select>

                                                            <input type="hidden" name="inventory_measure[]" :value="(item.item==null)?null:item.item.measure.measure_id">
                                                        </td>
                                                        @if(itemPicture()=="true")
                                                        <td>  
                                                            <input :name="'photo['+index+']'" type="file" class ="form-control" placeholder="@lang('layout.Photo')">
                                                            <input type="hidden" :name="'last_image['+index+']'" v-model="(item.item==null)?null:item.item.image">
                                                        </td>
                                                        @endif
                                                        @if(systemConfig()[30] == 1)
                                                        <td v-show="seeCost==true">
                                                            @{{(item.item==null)? 0:myRound((item.item.LasCost * item.item.measure.measure_unit / item.item.measure_unit) *selected_currency.static_rate / selected_currency.rate)}}
                                                            @{{selected_currency.symbol}}
                                                        </td>
                                                        @else 
                                                        <td v-show="seeCost==true">
                                                            @{{(item.item==null)? 0:myRound((item.item.LasCost * item.item.measure.measure_unit / item.item.measure_unit) *selected_currency.rate)}}
                                                            @{{selected_currency.symbol}}
                                                        </td>
                                                        @endif
                                                        @if(systemConfig()[30] == 1)
                                                        <td v-if="oil_sale == true && seeCost==true" >
                                                            @{{(item.item==null)?null:((item.item.density)?myRound(((item.item.LasCost * item.item.measure.measure_unit / item.item.measure_unit) * item.item.density) * selected_currency.static_rate / selected_currency.rate):null)}}
                                                        </td>
                                                        @else 
                                                        <td v-if="oil_sale == true && seeCost==true" >
                                                            @{{(item.item==null)?null:((item.item.density)?myRound(((item.item.LasCost * item.item.measure.measure_unit / item.item.measure_unit) * item.item.density) * selected_currency.rate):null)}}
                                                        </td>
                                                        @endif
                                                        <td v-if="oil_sale == true">
                                                            <input type="number" name="density[]" class="form-control input-style input-number chan_length" placeholder="@lang('layout.Density')" @input="change_oil_qty(index)" oninput = "autowidths(event)" v-model.number="(item.item==null)?null:item.item.density">
                                                        </td>
                                                        <td v-if="oil_sale == true">
                                                            <input type="number" name="oil_qty[]" oninput = "autowidths(event)" class="form-control input-style input-number chan_length" @input="change_qty_by_oil(index)" placeholder="@lang('layout.OilQuantity')" v-model.number="(item.item==null)?null:item.item.oil_qty">
                                                        </td>
                                                        <td v-if="oil_sale == true">
                                                            <select name="measure3[]" class="form-control" v-model="(item.item==null)?null:item.item.measure3.measure_id">
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(item.item ==null)?false:true">
                                                                    <option v-for="measure in (item.item==null)?null:item.item.measureListAll" :value="measure.measure_id">
                                                                        @{{measure.measure_name}}
                                                                    </option>
                                                                </span>
                                                            </select>
                                                        </td>
                                                        @if(getShwoPriceLevel()=="per_item")
                                                        <td>
                                                            <select v-model="(item.item == null)?null:item.price_level" class="form-control" @change="change_sale_rate_by_price_level(index)">
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(item.item ==null)?false:true">
                                                                    <option v-for="price_level in (item.item==null)?null:item.item.item_price_level" :value="price_level">
                                                                        @{{price_level.name}}
                                                                    </option>
                                                                </span>
                                                            </select>

                                                            <input type="hidden" name="item_price_level_id[]" :value="(item.price_level == null)?null:item.price_level.id">
                                                        </td>
                                                        @endif

                                                        @if(getShwoPriceLevel()=="general_percent_per_item")
                                                        <td>
                                                            <select v-model="(item.item == null)?null:item.price_level" class="form-control" @change="change_sale_rate_by_price_level_general_per_item(index)">
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(item.item ==null)?false:true">
                                                                    <option v-for="price_level in (item.item==null)?null:priceLevelGeneral" :value="price_level">
                                                                        @{{price_level.name}}
                                                                    </option>
                                                                </span>
                                                            </select>

                                                            <input type="hidden" name="item_price_level_id[]" :value="(item.price_level == null)?null:item.price_level.id">
                                                        </td>
                                                        @endif

                                                        <td v-show="seePrice==true">
                                                            <vue-numeric v-if="item.item"
                                                                class="form-control chan_length"
                                                                oninput = "autowidths(event)"
                                                                v-model="item.item.cost"
                                                                :max="99999999999999"
                                                                currency=""
                                                                :precision="precis"
                                                                @input="setNewRate('inventory',index)"
                                                                >
                                                            </vue-numeric> 
                                                            <input type="hidden" name="inventory_price[]" placeholder="@lang('layout.Price')" v-bind:value="(item.item==null)?null:saleNewRate(item.item,selected_currency.rate,precis,selected_currency.static_rate)" >
                                                        </td>
                                                        @if(getM2()!="" && getSaleSubMeasure()!="true")
                                                        @if(getFactorMeasure2()=="true")
                                                        <td>
                                                            <div class="input-group">
                                                                <select name="measure1[]" class="form-control" v-model="(item.item==null)?null:item.item.measure1.measure_id">
                                                                    <option value="null">@lang('layout.Select')</option>
                                                                    <span v-if="(item.item ==null)?false:true">
                                                                        <option v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure.measure_id">
                                                                            @{{measure.measure_name}}
                                                                        </option>
                                                                    </span>
                                                                </select>
                                                                @if(getSaleAmountSecondMeasure()=="true")
                                                                <span class="input-group-addon">
                                                                    @{{myRound((item.item==null)?null:secoundMeasurQuantity(item.item,item.item.quantity))}}
                                                                </span>
                                                                @endif
                                                            </div>
                                                        </td>
                                                        @endif
                                                        @endif
                                                        @if(getM3()!="")
                                                        @if(getFactorMeasure3()=="true")
                                                        <td>
                                                            <select name="measure2[]" class="form-control" v-model="(item.item==null)?null:item.item.measure2.measure_id">
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(item.item ==null)?false:true">
                                                                    <option v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure.measure_id">
                                                                        @{{measure.measure_name}}
                                                                    </option>
                                                                </span>
                                                            </select>
                                                        </td>
                                                        @endif
                                                        @endif

                                                        @if(getSaleSubMeasure() =="true")
                                                        <td>
                                                            @{{myRound((item.item==null)?null:subMQuantity(item.item,item.item.quantity))}}
                                                        </td>
                                                        <td v-show="seePrice==true">
                                                            <div class="input-group">
                                                                <input type="number" placeholder="@lang('layout.SubPrice')" v-model="(item.item==null)?null:item.sub_price" @input="setNewRateTotal(index)" oninput = "autowidths(event)" class="form-control chan_length">
                                                                <span class="input-group-addon">
                                                                    @{{selected_currency.symbol}}
                                                                </span>
                                                            </div>
                                                        </td>
                                                        @endif

                                                        @if(getM4()!="")
                                                        @if(getFactorMeasure4()=="true")
                                                        <td v-show="seePrice==false">
                                                            <select name="measure3[]" class="form-control" v-model="(item.item==null)?null:item.item.measure3.measure_id">
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(item.item ==null)?false:true">
                                                                    <option v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure.measure_id">
                                                                        @{{measure.measure_name}}
                                                                    </option>
                                                                </span>
                                                            </select>
                                                        </td>
                                                        @endif
                                                        @endif


                                                        @if(getSaleCommission()=="true")
                                                        <td>
                                                            <span v-show="!item.commission">
                                                                <input type="number" class="form-control chan_length" :name="'row_percent_commission['+index+']'" oninput = "autowidths(event)" v-model="item.row_commission_percent" />
                                                                <input type="hidden" :name="'row_commission_amount['+index+']'" :value="item.row_commission_amount" />
                                                            </span>
                                                        </td>
                                                        @endif  


                                                        @if(getTaxation()=="true")
                                                        <td>
                                                            <span v-show="!item.tax">
                                                                <v-select v-model="item.selected_taxation" label="name" :options="taxation" @input="getDrivers">
                                                                </v-select>
                                                                <input type="hidden" :name="'row_taxation_id['+index+']'" :value="!item.selected_taxation?null:item.selected_taxation.id" />
                                                                <input type="hidden" :name="'row_taxation_vendor_id['+index+']'" :value="!item.selected_taxation?null:item.selected_taxation.member_id" />
                                                                <input type="hidden" :name="'row_tax_amount['+index+']'" :value="!item.selected_taxation?null:item.row_tax_amount" />
                                                            </span>
                                                        </td>
                                                        <td>
                                                            <span v-show="!item.tax">
                                                                <input type="number" class="form-control chan_length" :name="'row_percent_tax['+index+']'" oninput = "autowidths(event)" v-model="!item.selected_taxation?null:item.selected_taxation.percent" />
                                                            </span>
                                                        </td>
                                                        @endif



                                                        <td v-show="showWhat('sale_discount')=='yes'">
                                                            <div class="input-group">
                                                                <input type="number" name="inventory_discount[]" placeholder="@lang('layout.Discount')" v-model.number="(item.item==null)?null:item.item.discount" oninput = "autowidths(event)" class="form-control chan_length">
                                                                <span v-if="discountIsAmount" class="input-group-addon">
                                                                    @{{selected_currency.symbol}}
                                                                </span>
                                                                <span v-if="!discountIsAmount" class="input-group-addon">
                                                                    %
                                                                </span>
                                                            </div>

                                                        </td>
                                                        <td v-if="oil_sale==false" v-show="seePrice==true">
                                                            <input type="number" :value="(item.item==null)? 0:getItemTotal(item.item,selected_currency.rate,discountIsAmount,item.item.discount,1,per_qty_check,null, selected_currency.static_rate).result" ref="total" @input="setQuantityByTotal(index)"  class="form-control">
                                                            {{-- @{{(item.item==null)? 0:getItemTotal(item.item,selected_currency.rate,discountIsAmount,item.item.discount,1,per_qty_check).result}}
                                                            @{{selected_currency.symbol}} --}}
                                                        </td>

                                                        <td v-if="oil_sale==true" v-show="seePrice==true">
                                                            <input type="number" :value="(item.item==null)? 0:getItemTotalOil(item.item,selected_currency.rate,discountIsAmount,item.item.discount, null, null, selected_currency.static_rate).result" ref="total" @input="setQuantityByTotal(index)"  class="form-control">
                                                            {{-- @{{(item.item==null)? 0:getItemTotalOil(item.item,selected_currency.rate,discountIsAmount,item.item.discount).result}}
                                                            @{{selected_currency.symbol}} --}}
                                                        </td>

                                                        @if(getSubTotal() =="true")
                                                        <td>
                                                            <div class="mt-checkbox" style="padding-left: 0px;">
                                                                <label class="mt-checkbox mt-checkbox-outline">
                                                                    <input type="checkbox" :name="'row_sub_total_stat['+index+']'" v-model="item.sub_total" />
                                                                    <span></span>
                                                                </label>
                                                            </div>
                                                        </td>
                                                        @endif

                                                        <td>
                                                            <span v-on:click="deleteItem('inventory',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>

                                                        </td>
                                                    </tr>
                                                    <tr style="background-color: #ffffff;">
                                                        <td></td>
                                                        <td>
                                                            <center>
                                                                <button type="button" @click="addNew('inventory',1000)" class="btn btn-success"><i class="fa fa-plus"></i></button>
                                                            </center>
                                                        </td>
                                                        <td></td>
                                                        <td></td>
                                                        <td></td>
                                                        <td></td>
                                                        <td></td>
                                                        <td></td>
                                                        <td></td>
                                                    </tr>
                                                </tbody>
                                            </table>

                                            <hr>

                                            @if(getShowRefundToSale()=="true")
                                            <!-- begin return -->
                                            <table id="table_content" class="table table-bordered table-advance table-hover">
                                                <thead>
                                                    <tr>
                                                        <th colspan="20" style="min-width: 100px;">@lang('layout.Leakage')</th>
                                                    </tr>
                                                    <tr>
                                                        <th>#</th>
                                                        <th style="min-width: {{itemFieldWidth()}}px">@lang('layout.ItemName') </th>
                                                        <th style="min-width: 100px">@lang('layout.SiteName') </th>
                                                        <th style="min-width: 100px">@lang('layout.Quantity') </th>
                                                        <th v-show="showWhat('other_measure')=='yes'" style="min-width: 100px">@lang('layout.OMeasureValue1')
                                                        </th>
                                                        <th v-show="showWhat('other_measure2')=='yes'" style="min-width: 100px">@lang('layout.OMeasureValue2')
                                                        </th>
                                                        <th style="min-width: 100px">@lang('layout.Measure') </th>
                                                        <!-- <th v-show="seeCost==true" style="min-width: 80px">@lang('layout.CostInInventory')</th> -->
                                                        <th v-show="seePrice==true" style="min-width: 100px">@lang('layout.NewPrice') </th>
                                                        <!-- <th v-show="showWhat('sale_discount')=='yes'" style="min-width: 100px">@lang('layout.Discount') </th> -->
                                                        <th v-show="seePrice==true" style="min-width: 80px">@lang('layout.Total')</th>
                                                        <th></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr v-for="(item,index) in inventory_return">
                                                        <td>@{{index+1}}</td>
                                                        <td class="highlight">
                                                            <v-select label="name" @keyup.native="onItemloadReturn(index),  addNew('return',index)" @Click.native="onItemloadReturn(index),  addNew('return',index)" v-model="item.inventory" :options="temp_return_items" @search="onItemSearch"></v-select>
                                                            <input type="hidden" :name="'return_inventory_id['+index+']'" :value="(!item.item)?null:item.item.id">
                                                        </td>
                                                        <td class="highlight">
                                                            <select v-model="(item.item==null)?null:item.item.site" class="form-control">
                                                                <option value="null">@lang('layout.Select')</option>

                                                                <span v-if="(item.item != null)">
                                                                    <option v-for="site in (item.item==null)?null:item.item.site_list" :value="site">
                                                                        @{{site.site_name}}
                                                                    </option>
                                                                </span>
                                                            </select>

                                                            <input type="hidden" name="return_inventory_site[]" :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.site_id)">
                                                        </td>
                                                        <td>
                                                            <input type="number" :name="'return_inventory_quantity['+index+']'" oninput = "autowidths(event)" v-model.number="(item.item==null)?null:item.item.quantity" class="form-control input-style input-number chan_length" placeholder="@lang('layout.Quantity')">
                                                        </td>
                                                        <td v-show="showWhat('other_measure')=='yes'">
                                                            <input type="number" name="return_other_measure_amount[]" class="form-control input-style input-number chan_length" oninput = "autowidths(event)" placeholder="@lang('layout.OMeasureValue1')" v-model.number="(item.item==null)?null:item.item.other_measure">
                                                        </td>
                                                        <td v-show="showWhat('other_measure2')=='yes'">
                                                            <input type="number" name="return_other_measure_amount2[]" class="form-control input-style input-number chan_length" oninput = "autowidths(event)" placeholder="@lang('layout.OMeasureValue2')" v-model.number="(item.item==null)?null:item.item.other_measure2">
                                                        </td>
                                                        <td class="highlight">
                                                            <select v-model="(item.item == null)?null:item.item.measure" class="form-control" @change="measureChangeReturn(index)">
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(item.item ==null)?false:true">
                                                                    <option v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure">
                                                                        @{{measure.measure_name}}
                                                                    </option>
                                                                </span>

                                                            </select>

                                                            <input type="hidden" name="return_inventory_measure[]" :value="(item.item==null)?null:item.item.measure.measure_id">
                                                        </td>

                                                        <!-- <td v-show="seeCost==true">
                                                                @{{(item.item==null)? 0:myRound((item.item.LasCost * item.item.measure.measure_unit / item.item.measure_unit) *selected_currency.rate)}}
                                                                @{{selected_currency.symbol}}
                                                            </td> -->

                                                        <td v-show="seePrice==true">
                                                            <div class="input-group">
                                                                <input type="number" :name="'return_inventory_price['+index+']'" placeholder="@lang('layout.Price')" v-bind:value="(item.item==null)?null:saleNewRate(item.item,selected_currency.rate, null, selected_currency.static_rate)" ref="return_in" @input="setNewRate('return',index)" oninput = "autowidths(event)" class="form-control chan_length">
                                                                <span class="input-group-addon">
                                                                    @{{selected_currency.symbol}}
                                                                </span>
                                                            </div>
                                                        </td>
                                                        <!-- <td v-show="showWhat('sale_discount')=='yes'">
                                                                <div class="input-group">
                                                                    <input type="number" name="return_inventory_discount[]" placeholder="@lang('layout.Discount')" v-model.number="(item.item==null)?null:item.item.discount" oninput = "autowidths(event)" class="form-control chan_length">
                                                                    <span class="input-group-addon" v-if="discountIsAmount">
                                                                        @{{selected_currency.symbol}}
                                                                    </span>
                                                                    <span class="input-group-addon" v-if="!discountIsAmount">
                                                                        %
                                                                    </span>
                                                                </div>
                                                            </td> -->
                                                        <td v-show="seePrice==true">
                                                            @{{(item.item==null)? 0:getItemTotal(item.item,selected_currency.rate,discountIsAmount,item.item.discount,selected_currency.hq_rate,per_qty_check, null, selected_currency.static_rate).result}}
                                                            @{{selected_currency.symbol}}
                                                        </td>
                                                        <td>
                                                            <span v-on:click="deleteItem('return',index)">
                                                                <i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                            <hr>
                                            <!-- begin return -->
                                            @endif
                                            @endif

                                            @if(systemConfig()[26] == 1)
                                            <!-- begin service -->
                                            <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                                                <thead>
                                                    <tr>
                                                        <th class="text-center" style="min-width: 8px;"> #</th>
                                                        <th class="text-center" style="min-width: 160px;">@lang('layout.ServiceName')</th>
                                                        <th v-show="showWhat('sale_description')=='yes'">@lang('layout.Description') </th>
                                                        <th v-show="showWhat('sale_description2')=='yes'">@lang('layout.Description') :2 </th>
                                                        <th class="text-center" style="min-width: 160px;">@lang('layout.Quantity')</th>
                                                        <th class="text-center" style="min-width: 160px;">@lang('layout.Measure')</th>
                                                        <th class="text-center" style="min-width: 160px;">@lang('layout.Price')</th>
                                                        <th class="text-center" style="min-width: 120px;">@lang('layout.Total')</th>
                                                        <th></th>

                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr v-for="(service,index) in services">
                                                        <td>@{{index+1}}</td>
                                                        <td class="highlight">
                                                            <v-select label="name" v-model="service.item" :options="(service.items)" @click.native="addNew('service',index)" @input="checkExistingService(index)">

                                                            </v-select>
                                                            <input type="hidden" name="service_id[]" :value="(service.item==null)?null:service.item.id">
                                                            <input type="hidden" name="ser_online_order_detail_id[]" :value="(service.item==null)?null:service.item.online_order_detail_id">
                                                            <input type="hidden" name="sale_order_service_id[]" :value="(service.item==null)?null:service.item.order_detail_id">
                                                        </td>
                                                        <td v-show="showWhat('sale_description')=='yes'">
                                                            <input type="text" placeholder="@lang('layout.Description')" name="service_description[]" v-model="(service.item==null)?null:service.item.description" class="form-control">
                                                        </td>
                                                        <td v-show="showWhat('sale_description2')=='yes'">
                                                            <input type="text" placeholder="@lang('layout.Description')" name="service_description2[]" v-model="(service.item==null)?null:service.item.description2" class="form-control">
                                                        </td>
                                                        <td>
                                                            <input class="form-control" name="service_quantity[]" v-model.number="(!service.item)?null:service.item.quantity" placeholder="@lang('layout.Quantity')">
                                                        </td>
                                                        <td class="highlight">
                                                            <select v-model="(service.item == null)?null:service.item.measure" class="form-control" @change="measureChangeservice(index)">
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(service.item ==null)?false:true">
                                                                    <option v-for="measure in (service.item==null)?null:service.item.measure_list" :value="measure">
                                                                        @{{measure.measure_name}}
                                                                    </option>
                                                                </span>

                                                            </select>

                                                            <input type="hidden" name="service_measure[]" :value="(service.item==null)?null:service.item.measure.measure_id">
                                                        </td>
                                                        <td>
                                                            <div class="input-group">
                                                                <input type="number" name="service_price[]" placeholder="@lang('layout.Price')" :value="(service.item==null)?null:saleNewRate(service.item,selected_currency.rate, null, selected_currency.static_rate)" ref="ser" @input="setNewRate('service',index)" class="form-control">


                                                                <span class="input-group-addon">
                                                                    @{{selected_currency.symbol}}
                                                                </span>
                                                            </div>

                                                        </td>
                                                        <td>
                                                            <div class="input-group">
                                                                <input type="number" class="form-control inner_input" :value="(service.item==null)?null:getItemTotalService(service.item,selected_currency.rate,selected_currency.hq_rate, selected_currency.static_rate).result" placeholder="@lang('layout.Total')" disabled>
                                                                <span class="input-group-addon">
                                                                    <b>@{{selected_currency.symbol}}</b>
                                                                </span>
                                                            </div>


                                                        </td>
                                                        <td>
                                                            <span v-on:click="deleteItem('service',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                            <!-- end service -->
                                            @endif
                                            <hr>

  



                                            @if(voucherOfferingType() == '1')
                                            <!-- begin service -->
                                            <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                                                <thead>
                                                    <tr>
                                                        <th class="text-center" style="min-width: 8px;"> #</th>
                                                        <th class="text-center" style="min-width: 160px;">@lang('layout.Name')</th>
                                                        <th class="center">@lang('layout.Amount') </th>
                                                        <th class="center">@lang('layout.Date') </th>
                                                        <th class="text-center" style="min-width: 160px;">@lang('layout.AccountRegister')</th> 
                                                        <th class="text-center" style="min-width: 160px;">@lang('layout.Description')</th> 
                                                        <th></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr v-for="(sale_info_expens,index) in sale_info_expense">
                                                        <td>@{{index+1}}</td>
                                                       
                                                        <td>
                                                            <input type="text" class="form-control" name="name_info_expense[]" @click="addNew('sale_info_expens',index)" v-model.number="sale_info_expens.name_expense" placeholder="@lang('layout.Name')">
                                                        </td>
                                                        <td>
                                                            <input type="number" step="any" class="form-control" name="amount_info_expense[]" v-model.number="sale_info_expens.amount_expense" placeholder="@lang('layout.Amount')">
                                                        </td>
                                                        <td>
                                                            {{-- <input class="form-control date" autocomplete="off" name="date_info_expense[]" v-model.number="sale_info_expens.date_expense" placeholder="@lang('layout.Date')"> --}}
                                                            <date_picker :name="'date_info_expense['+index+']'" v-model="sale_info_expens.date_expense" placeholder="@lang('layout.Date')" ></date_picker>
                                                        </td>
                                                        <td>
                                                            <input class="form-control" type="text" name="account_register_info_expense[]" v-model.number="sale_info_expens.account_register_expense" placeholder="@lang('layout.AccountRegister')">
                                                        </td>
                                                        <td>
                                                            <input class="form-control" type="text" name="description_expense[]" v-model.number="sale_info_expens.description_expense" placeholder="@lang('layout.Description')">
                                                        </td> 
                                                        <td>
                                                            <span v-on:click="deleteItem('sale_info_expens',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                                        </td>
                                                    </tr>

                                                </tbody>
                                            </table>
                                            <!-- end sale_info_expens -->
                                            @endif
                                            <hr>


                                            <!-- begin payments -->
                                            @permission('receive-create')
                                            <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                                                <thead>
                                                    <tr>
                                                        <th class="text-center" style="min-width: 8px;"> #</th>
                                                        <th class="text-center" style="min-width: 70px;">@lang('layout.Number')</th>
                                                        <th class="text-center" style="min-width: 160px;">@lang('layout.SelectBank')</th>
                                                        <th class="text-center" style="min-width: 100px;"> @lang('layout.Amount')</th>
                                                        <th class="text-center" style="min-width: 120px;"> @lang('layout.Rate')</th>
                                                        <th class="text-center" style="min-width: 80px;">@lang('layout.Currency')</th>
                                                        <th class="text-center" style="min-width: 80px;"> @lang('layout.Amount')</th>
                                                        <th class="text-center" style="min-width: 120px;">@lang('layout.Total')</th>
                                                        <th class="text-center" style="min-width: 80px;"> @lang('layout.Date')</th>
                                                        <th class="text-center" style="min-width: 120px;">@lang('layout.Description')</th>
                                                        <th></th>

                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr v-for="(payment,index) in payments">
                                                        <td>@{{index+1}}</td>
                                                        <td>
                                                            <span>@{{(payment.item==null)?null:(payment.item.number)}}</span>
                                                            <input type="hidden" name="receive_number[]" :value="(payment.item==null)?null:(payment.item.number)" />
                                                        </td>

                                                        <td class="highlight">
                                                            <v-select label="name" v-model="payment.item" :options="(payment.items)" @click.native="addNew('payment',index)" @input="checkExistingPayment(index)">

                                                            </v-select>
                                                            <input type="hidden" v-if="payment.item !=null" name="payment_id[]" :value="(payment.item==null)?null:payment.item.id">
                                                        </td>

                                                        <td>

                                                            <span v-if="payment.item !=null">
                                                                @{{myRound(Number((payment.item==null)?null:payment.item.balance)-Number((payment.item==null)?null:payment.item.amount))}}
                                                            </span>
                                                        </td>
                                                        <td>
                                                            <input v-bind:disabled="(payment.item==null)?false:(payment.item.code =='{{getHomeCurrency()["code"]}}')" type="number" v-model.number="(payment.item==null)?null:payment.item.rate " class="form-control" placeholder="@lang('layout.Rate')" />
                                                            <input v-if="payment.item !=null" type="hidden" name="payment_rate[]" v-bind:value="payment.item.rate">
                                                        </td>
                                                        <td>
                                                            <input type="text" name="payment_currency[]" class="form-control" v-model="(payment.item==null)?null:payment.item.code" placeholder="@lang('layout.Currency')" disabled reqiured />

                                                            <input v-if="payment.item !==null" type="hidden" name="payment_currency[]" v-bind:value="payment.item.code" />
                                                        </td>
                                                        <td>
                                                            <vue-numeric v-if="payment.item"
                                                                class="form-control"
                                                                v-model="payment.item.amount"
                                                                :max="99999999999999"
                                                                :currency="payment.item.code"
                                                                :precision="precision()"
                                                                >
                                                            </vue-numeric>
                                                            <input v-if="payment.item !=null" type="hidden" name="payment_amount[]" v-bind:value="payment.item.amount">
                                                        </td>
                                                        <td>
                                                            <div class="input-group">
                                                                <input type="number" class="form-control" :value="(payment.item==null)?null:totalPayment(payment.item,selected_currency.rate,selected_currency.hq_rate,selected_currency.static_rate).result" placeholder="@lang('layout.Total')" style="min-width: 100px" />
                                                                <span class="input-group-addon">@{{selected_currency.symbol}}</span>
                                                            </div>
                                                        </td>
                                                              
                                                        <td>
                                                            <date_picker :name="'date_receive['+index+']'" v-model="(payment.item==null)?null:payment.item.date" placeholder="@lang('layout.Date')" ></date_picker>

                                                            <td>
                                                            <textarea class="form-control" name="receive_description[]" v-model="(payment.item==null)?null:payment.item.description" rows="2" placeholder="@lang('layout.Description')">

                                                            </textarea>
                                                        </td>
                                                        <td>
                                                            <span v-on:click="deleteItem('payment',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                                        </td>
                                                    </tr>
                                                </tbody>

                                            </table>
                                            @endpermission
                                            <!-- end payments -->

                                            @if(getTransferRent()=="true")
                                            <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                                                <thead>
                                                    <tr>
                                                        <th colspan="10" style="min-width: 100px;">@lang('layout.TransferRent')</th>
                                                    </tr>
                                                    <tr>
                                                        <th class="text-center" style="min-width: 160px;">@lang('layout.Type')</th>
                                                        <th class="text-center" style="min-width: 160px;">@lang('layout.Transmitter')</th>
                                                        <th class="text-center" style="min-width: 160px;" v-show="transfer_rent_type=='cash'">@lang('layout.SelectBank')</th>
                                                        <th class="text-center" style="min-width: 80px;" >@lang('layout.Currency')</th>
                                                        <th class="text-center" style="min-width: 120px;" > @lang('layout.Rate')</th>
                                                        <th class="text-center" style="min-width: 80px;"> @lang('layout.Amount')</th>
                                                        <th class="text-center" style="min-width: 120px;">@lang('layout.Description')</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr>
                                                        <td>
                                                            <select class="form-control" name="transfer_rent_type" v-model="transfer_rent_type">
                                                                <option value="cash">@lang('type.cash')</option>
                                                                <option value="credit">@lang('type.credit')</option>
                                                            </select>
                                                        </td>
                                                        <td>
                                                            <v-select label="name" @search="VendorSearch" :options="transfer_rent_vendor" v-model="transfer_rent_vendor_selected"></v-select>
                                                            <input type="hidden" name="transfer_rent_vendor" :value="!transfer_rent_vendor_selected?null:transfer_rent_vendor_selected.id">
                                                        </td>

                                                        <td class="highlight" v-show="transfer_rent_type=='cash'">
                                                            <v-select label="name" v-model="transfer_rent_bank_selected" :options="banks">

                                                            </v-select>
                                                            <input type="hidden" v-if="transfer_rent_bank_selected !=null" name="transfer_rent_bank" :value="(transfer_rent_bank_selected==null)?null:transfer_rent_bank_selected.id">
                                                        </td>
                                                        <td v-if="transfer_rent_type=='cash'">
                                                            <input type="text" name="" class="form-control" v-model="(transfer_rent_bank_selected==null)?null:transfer_rent_bank_selected.code" placeholder="@lang('layout.Currency')" disabled reqiured />

                                                            <input v-if="transfer_rent_bank_selected !==null" type="hidden" name="transfer_rent_currency" v-bind:value="transfer_rent_bank_selected.code" />
                                                        </td>
                                                        <td v-if="transfer_rent_type=='cash'">
                                                            <input v-bind:disabled="(transfer_rent_bank_selected==null)?false:(transfer_rent_bank_selected.code =='{{getHomeCurrency()["code"]}}')" type="number" v-model.number="(transfer_rent_bank_selected==null)?null:transfer_rent_bank_selected.rate " class="form-control" placeholder="@lang('layout.Rate')" />
                                                            <input v-if="transfer_rent_bank_selected !=null" type="hidden" name="transfer_rent_rate" v-bind:value="transfer_rent_bank_selected.rate">
                                                        </td>
                                                        <td v-if="transfer_rent_type=='credit'">
                                                            <v-select label="code" :options="currency" v-model="selected_transfer_currency" auto></v-select>
                                                            <input type="hidden" name="transfer_rent_currency" v-validate="''" data-vv-as="@lang('layout.Currency')" :value="!selected_transfer_currency?'':selected_transfer_currency.code">
                                                        </td>
                                                        <td v-if="transfer_rent_type=='credit'">
                                                            <input type="number" name="transfer_rent_rate" v-validate="''" data-vv-as="@lang('layout.Rate')" v-model="!selected_transfer_currency?0:selected_transfer_currency.rate" class="form-control" >
                                                        </td>

                                                        <td>
                                                            <div class="input-group">
                                                                <input type="number" name="transfer_rent_amount" v-model="transfer_rent_amount" class="form-control" placeholder="@lang('layout.PayAmount')">

                                                                <span v-show="transfer_rent_type=='cash'" class="input-group-addon">@{{(transfer_rent_bank_selected==null)?null:transfer_rent_bank_selected.code}}</span>
                                                                <span v-show="transfer_rent_type=='credit'" class="input-group-addon">@{{selected_currency.symbol}}</span>

                                                            </div>
                                                        </td>

                                                        <td>
                                                            <textarea class="form-control" name="transfer_rent_description" v-model="transfer_rent_description" rows="2" placeholder="@lang('layout.Description')"></textarea>
                                                        </td>
                                                    </tr>
                                                </tbody>

                                            </table>
                                            <hr>
                                            @endif
                                            <!--End Transfer Rent-->



                                            <!--------------------------------------------------------------------------->

                                            <hr>
                                            @if(getInvoicePayment()== "true")
                                            <!-- begin Invoic  payments -->
                                            <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                                                <thead>
                                                    <tr>
                                                        <th colspan="6" style="min-width: 100px;">
                                                            <i class="fa fa-money" style="color: green"></i>&nbsp; @lang('layout.InvoicePayment') : (@lang('message.InvoicePaymetNote'))

                                                        </th>


                                                    </tr>

                                                    <tr>
                                                        <th class="text-center" style="min-width: 8px;"> #</th>
                                                        <th class="text-center" style="min-width: 80px;">@lang('layout.Currency')<span class="required"> * </span></th>
                                                        <th class="text-center" style="min-width: 120px;"> @lang('layout.Rate')<span class="required"> * </span></th>
                                                        <th class="text-center" style="min-width: 80px;"> @lang('layout.Amount')<span class="required"> * </span></th>
                                                        <th class="text-center" style="min-width: 100px;"> @lang('layout.Description')<span class="required"> * </span></th>


                                                        <th></th>

                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr v-for="(payment_invoice,index) in payment_invoices">
                                                        <td>@{{index+1}}</td>

                                                        <td>
                                                            <v-select label="code" :options="currency" v-model="payment_invoice.selected_payment_currency"></v-select>

                                                            <input type="hidden" :name="'currency_payment['+index+']'" :value="(payment_invoice.selected_payment_currency==null)?null:payment_invoice.selected_payment_currency.code">

                                                        </td>
                                                        <td>

                                                            <input type="number" :name="'currency_payment_rate['+index+']'" class="form-control" v-model="(payment_invoice.selected_payment_currency==null)?payment_invoice.rate:payment_invoice.selected_payment_currency.rate" :class="{'has-error':rate<=0}">
                                                        </td>
                                                        <td>
                                                            <input type="number" name="amount_payment[]" class="form-control" v-model="payment_invoice.amount">
                                                        </td>

                                                        <td>
                                                            <textarea class="form-control" name="payment_description[]" v-model="payment_invoice.description"></textarea>
                                                        </td>

                                                        <td>
                                                            <span v-on:click="deleteItem('payment_invoice',index)">
                                                                <i class="paddint-both glyphicon glyphicon-trash" style="color: red"></i>
                                                            </span>
                                                        </td>
                                                    </tr>

                                                    <tr style="background-color: #ffffff;">
                                                        <td></td>
                                                        <td>
                                                            <center>
                                                                <button type="button" @click="addNew('payment_invoice',1000)" class="btn btn-success">
                                                                    <i class="fa fa-plus"></i>
                                                                </button>
                                                            </center>
                                                        </td>
                                                        <td></td>
                                                        <td></td>
                                                        <td></td>
                                                        <td></td>
                                                    </tr>
                                                </tbody>

                                            </table>
                                            <!-- end Invoice payments -->
                                            @endif
                                            <!--------------------------------------------------------------------------->
                                        </div>

                                        <!--Begin Draiver-->

                                        @if(getDriverInfo()=="true")
                                        <br>
                                        <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                                            <thead>
                                                <tr>
                                                    <th class="text-center" style="min-width: 8px;"> @lang('layout.DriverInfo') </th>

                                                </tr>
                                            </thead>
                                        </table>

                                        <div class="row">
                                            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                                <!-- begin inputs -->
                                                <div class="row">
                                                    <div class="col-md-3">
                                                        <div class="col-md-12">
                                                            <label class="control-label ">@lang('layout.TransferCode')</label>
                                                            {{Form::text('transfer_code',$invoice->transferCode,['class' => 'form-control'])}}

                                                        </div>
                                                    </div>

                                                    <div class="col-md-3">

                                                        <div class="col-md-12">
                                                            <label class="control-label">@lang('layout.Transporter_name')</label>
                                                            <input type="test" name="transporter_name" value="{{$invoice->driver}}" class="form-control">

                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">

                                                        <div class="col-md-12">
                                                            <label class="control-label">@lang('layout.Transporter_phone')</label>
                                                            <input type="test" name="transporter_phone" value="{{$invoice->driverPhone}}" class="form-control">

                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div class="col-md-12">
                                                            <label class="control-label ">@lang('layout.PlaceOfWeight')</label>
                                                            {{Form::text('palce_of_weight',$invoice->PlaceOfWeight,['class' => 'form-control'])}}
                                                        </div>
                                                    </div>


                                                </div>
                                                <div class="row">

                                                    <div class="col-md-3">
                                                        <div class="col-md-12">
                                                            <label class="control-label ">@lang('layout.SourcePlace')</label>
                                                            {{Form::text('source_place',$invoice->sourcePlace,['class' => 'form-control'])}}
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div class="col-md-12">
                                                            <label class="control-label ">@lang('layout.PlateNumber')</label>
                                                            <input type="text" name="plate_number" value="{{$invoice->plateNumber}}"  class="form-control">

                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div class="col-md-12">
                                                            <label class="control-label ">@lang('layout.WayBillNumber')</label>
                                                            <input type="text" name="way_bill_number" value="{{$invoice->wayBillNumber}}"  class="form-control">

                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div class="col-md-12">
                                                            <label class="control-label ">@lang('layout.TotalWeight')</label>
                                                            <input type="text" name="total_weight" value="{{$invoice->totalWeight}}"  class="form-control">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-3">
                                                        <div class="col-md-12">
                                                            <label class="control-label ">@lang('layout.EmptyCarWeight')</label>
                                                            <input type="text" name="empty_car_weight" value="{{$invoice->emptyCarWeight}}"  class="form-control">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div class="col-md-12">
                                                            <label class="control-label ">@lang('layout.TotalBori')</label>
                                                            <input type="text" name="total_bori"  value="{{$invoice->bori}}" class="form-control">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div class="col-md-12">
                                                            <label class="control-label ">@lang('layout.Rent')</label>
                                                            <input type="number" name="rent"  class="form-control" value="{{$invoice->rent}}">
                                                        </div>
                                                    </div>

                                                    <div class="col-md-3">
                                                        <div class="col-md-12">
                                                            <label class="control-label ">@lang('layout.Description')</label>
                                                            {{Form::textarea('transfer_description',$invoice->trDesription,['class' => 'form-control','rows' => '3'])}}
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>
                                        @endif
                                        <!--End Draiver-->

                                        <!--Begin Farmer Contract-->

                                        @if(systemConfig()[16] != 0)
                                        <br>
                                        <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                                            <thead>
                                                <tr>
                                                    <th class="text-center" style="min-width: 8px;"> @lang('layout.FarmerContract') </th>

                                                </tr>
                                            </thead>
                                        </table>
                                        <div class="row">
                                            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                                <!-- begin inputs -->
                                                <div class="row">
                                                    <div class="col-md-4">
                                                        <div class="col-md-12">
                                                            <label class="control-label ">@lang('layout.Number')</label>
                                                            <input type="text" name="far_number" value="{{($frarmerData)?$frarmerData->number:''}}" class="form-control">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="col-md-12">
                                                            <label class="control-label">@lang('layout.ReferenceNumber')</label>
                                                            <input type="text" name="far_ref_no" value="{{($frarmerData)?$frarmerData->ref_no:''}}" class="form-control">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="col-md-12">
                                                            <label class="control-label">@lang('layout.OverdueDate')</label>
                                                            <input type="test" name="far_overdue_date" value="{{($frarmerData)?$frarmerData->overdue_date:''}}" class="form-control date">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-4">
                                                        <div class="col-md-12">
                                                            <label class="control-label ">@lang('layout.LandSize')</label>
                                                            <input type="text" name="far_land_size" value="{{($frarmerData)?$frarmerData->land_size:''}}" class="form-control">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="col-md-12">
                                                            <label class="control-label">@lang('layout.DrawingAmount')</label>
                                                            <input type="number" name="far_land_drawing_amount" value="{{($frarmerData)?$frarmerData->land_drawing_amount:''}}" class="form-control">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="col-md-12">
                                                            <label class="control-label">@lang('layout.Measure')</label>
                                                            <select name="far_land_drawing_measure" class="form-control" v-model="far_drawing_measure">
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <option v-for="measure in measureList" :value="measure.measure_id">
                                                                    @{{measure.measure_name}}
                                                                </option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-4">
                                                        <div class="col-md-12">
                                                            <label class="control-label ">@lang('layout.SeedAmount')</label>
                                                            <input type="number" name="far_seed_amount" v-model="far_seed_amount" class="form-control">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="col-md-12">
                                                            <label class="control-label">@lang('layout.Measure')</label>
                                                            <select name="far_measure_id" class="form-control" v-model="far_measure">
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <option v-for="measure in measureList" :value="measure.measure_id">
                                                                    @{{measure.measure_name}}
                                                                </option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        @endif
                                        <!--End Farmer Contract-->

                                        <!--Begin Carpet Contract-->
                                        @if(systemConfig()[21] == 1)
                                        <br />
                                        <div class="row">
                                            <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                <table class="table table-striped table-bordered table-advance ">
                                                    <tr>
                                                        <td class="t_body">
                                                            <div>
                                                                <label class="mt-checkbox mt-checkbox-outline">@lang('layout.WashingForm')
                                                                    <input type="checkbox" name="washing_form" v-model="washing_form">
                                                                    <span></span>
                                                                </label>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </div>
                                        </div>

                                        <div class="row" v-show="washing_form">
                                            <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                                                <thead>
                                                    <tr>
                                                        <th class="text-center" style="min-width: 8px;"> @lang('layout.WashingForm') </th>
                                                    </tr>
                                                </thead>
                                            </table>
                                            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                                <!-- begin inputs -->
                                                <div class="row">
                                                    <div class="col-md-3">
                                                        <label class="control-label">@lang('layout.DateIn')</label>
                                                        <input type="text" name="wash_date_in" class="form-control date" value="{{($washingData)?$washingData->date_in:''}}" autocomplete="off">
                                                    </div>
                                                    <div class="col-md-3">
                                                        <label class="control-label ">@lang('layout.Numbers')</label>
                                                        <input type="text" name="wash_number" value="{{($washingData)?$washingData->company_number:''}}" class="form-control">
                                                    </div>
                                                    <div class="col-md-3">
                                                        <label class="control-label ">@lang('layout.WashingCompanyNumber')</label>
                                                        <input type="text" name="wash_washing_company_number" value="{{($washingData)?$washingData->washing_company_number:''}}" class="form-control">
                                                    </div>
                                                    <div class="col-md-3">
                                                        <label class="control-label">@lang('layout.DeliveryDate')</label>
                                                        <input type="text" name="wash_delivery_date" value="{{($washingData)?$washingData->delivery_date:''}}" class="form-control date" autocomplete="off">
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-3">
                                                        <label class="control-label">@lang('layout.Type') @lang('layout.Carpet')</label>
                                                        <input type="text" name="wash_carpet_type" value="{{($washingData)?$washingData->carpet_type:''}}" class="form-control" autocomplete="off">
                                                    </div>
                                                    <div class="col-md-3">
                                                        <label class="control-label ">@lang('layout.Length')</label>
                                                        <input type="number" name="wash_length" v-model="wash_length" class="form-control">
                                                    </div>
                                                    <div class="col-md-3">
                                                        <label class="control-label ">@lang('layout.Width')</label>
                                                        <input type="number" name="wash_width" v-model="wash_width" class="form-control">
                                                    </div>
                                                    <div class="col-md-3">
                                                        <label class="control-label ">@lang('layout.Area') @lang('layout.Total')</label>
                                                        <input type="number" :value="myRound(wash_length * wash_width)" class="form-control">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <br />
                                        @endif
                                        <!--End Carpet Contract-->

                                        @if(getInvoiceTotal() == 'true')
                                        <!-- begin total -->
                                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                            <div class="dashboard-stat2 " v-show="seePrice== true">
                                                <table class="dashboard-tabel" width="100%">
                                                    <tr>
                                                        <td>
                                                            <small>@lang('layout.GrandTotal'):</small>
                                                        </td>
                                                        <td class="text-right">
                                                            <span class="text-right" data-counter="counterup" data-value="7800">@{{ subtotal.toFixed(precision())}}</span>
                                                            <small class="font-green-sharp">
                                                                @{{selected_currency.symbol}}
                                                            </small>
                                                        </td>
                                                        <td>
                                                            <small>@lang('layout.Payment'):</small>
                                                        </td>
                                                        <td class="text-right">
                                                            <small class="font-green-sharp">
                                                                <span class="text-right" data-counter="counterup" data-value="7800">@{{ payeds.toFixed(precision())}}</span>
                                                                <small class="font-green-sharp">
                                                                    @{{selected_currency.symbol}}
                                                                </small>
                                                            </small>
                                                        </td>
                                                        <td>
                                                            <small>@lang('layout.Discount'): (@{{
                                                                        Number.parseFloat(discount).toFixed(precision())
                                                                        }}%)
                                                            </small>
                                                        </td>
                                                        <td class="text-right">
                                                            <span class="text-right" data-counter="counterup" data-value="7800">
                                                                @{{ format_number(Number.parseFloat(discount*(newSubTotal - newSubDiscountFiledRow)/100)+Number.parseFloat(discountFiledRow)) }}
                                                            </span>
                                                            <small class="font-green-sharp">
                                                                @{{selected_currency.symbol}}
                                                            </small>
                                                        </td>
                                                        <td>
                                                            <small>@lang('layout.Total') :</small>
                                                        </td>
                                                        <td class="text-right"><span data-counter="counterup" data-value="7800">
                                                                @{{ format_number(Number.parseFloat(((subtotal - (discount*(newSubTotal - newSubDiscountFiledRow)/100) - discountFiledRow) - saleTaxation)-payeds))}}
                                                            </span>
                                                            <small class="font-green-sharp">
                                                                @{{selected_currency.symbol}}
                                                            </small>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </div>
                                        </div>
                                        <!-- end total -->
                                        @endif
                                        <div class="row">
                                            @if(getHesabSabeqa() =='true')
                                            <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                <table class="table table-striped table-bordered table-advance ">
                                                    <tr>
                                                        <td class="t_body">
                                                            <div>
                                                                <label class="mt-checkbox mt-checkbox-outline">@lang('layout.HesabSabiqa')
                                                                    <input type="checkbox" name="hesab_sabeqa" value="ok" v-model="hesab_sabeqah_checked">
                                                                    <span></span>
                                                                </label>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </div>
                                            @endif
                                            <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                <table class="table table-striped table-bordered table-advance ">
                                                    <tr>
                                                        <td class="t_body">
                                                            <div>
                                                                <label class="mt-checkbox mt-checkbox-outline">@lang('layout.NotShowingDiscount')
                                                                    <input type="checkbox" name="show_discount" value="ok" v-model="show_discount_checked">
                                                                    <span></span>
                                                                </label>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </div>

                                            <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                <table class="table table-striped table-bordered table-advance ">
                                                    <tr>
                                                        <td class="t_body">
                                                            <div>
                                                                <label class="mt-checkbox mt-checkbox-outline">@lang('layout.ShowReceivables')
                                                                    <input type="checkbox" name="show_receive" value="ok" v-model="show_receive_checked">
                                                                    <span></span>
                                                                </label>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </div>

                                            @if(searchByCodeLocation()=="true")
                                            <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                <table class="table table-striped table-bordered table-advance ">
                                                    <tr>
                                                        <td class="t_body">
                                                            <div>
                                                                <label class="mt-checkbox mt-checkbox-outline">@lang('layout.PersianDescription')
                                                                    <input type="checkbox" name="show_persian_desc" value="ok" v-model="show_persian_desc" >
                                                                    <span></span>
                                                                </label>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </div>
                                            @endif

                                            
                                            
                                            <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                <table class="table table-striped table-bordered table-advance ">
                                                    <tr>
                                                        <td class="t_body">
                                                            <div>
                                                                <label class="">@lang('layout.PrintFactor') </label>
                                                                    <select name="print_factor_type" v-model="print_factor_type" id="" class="form-control">
                                                                        <option value=""> @lang('layout.Select') </option>
                                                                        <option value="A4">A4</option>
                                                                        <option value="A5">A5</option>
                                                                    </select>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </div>

                                        </div>
                                        <div class="row">
                                            @if(voucherOfferingType() == '1')
                                            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    <div class="col-md-12">
                                                        <label class="control-label">@lang('layout.OtherCurrency')</label>
                                                        <v-select label="code" @input="selectedRateOther" @keyup.native="changeStaticRate()" @Click.native="changeStaticRate()" :options="currency" v-model="selected_currency_other" auto></v-select>
                                                        <input type="hidden" name="currency_other" v-validate="'required'" data-vv-as="@lang('layout.Currency')" :value="selected_currency_other.code">
                                                        <span class="required">@{{ errors.first('currency') }}</span>
                                                    </div>
                                                </div>
                                            </div> 
                                            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    <div class="col-md-12">
                                                        <label class="control-label">@lang('layout.Rate')</label>
                                                        <input type="number" name="currency_rate_other" v-validate="'required'" data-vv-as="@lang('layout.Rate')" v-model="!selected_currency_other?0:selected_currency_other.rate" class="form-control" >
                                                        <span class="required">@{{ errors.first('currency_rate') }}</span>
                                                    </div>
                                                </div>
                                            </div>
                                            @endif

                                            @if(getPrintDescription()=="true")
                                            <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    <div class="col-md-12">
                                                        <label class="control-label">@lang('layout.PrintDescription')</label>
                                                        <textarea name="print_description" class="form-control" rows="2">{{$invoice->print_description}}</textarea>
                                                    </div>
                                                </div>
                                            </div>
                                            @endif
                                            <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    <div class="col-md-12">
                                                        <label class="control-label">@lang('layout.Memo')</label>
                                                        <textarea name="memo" class="form-control" rows="2">{{$invoice->memo}}</textarea>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                                        @if($duplicate)
                                        <button type="button" v-if="isError1 ==false" v-if="!isError" @click="submitForm" :disabled="disabled" class="btn green">@lang('layout.Submit')</button>
                                        @else 
                                        <button type="button" v-if="isError1 ==false" v-if="!isError" @click="submitForm" :disabled="disabled" class="btn green">@lang('layout.Update')</button>
                                        <button type="button" v-if="((!isError) && (isError1 == false))" :disabled="disabled" class="btn blue" @click="saveAndNew($event)">@lang('layout.Check') / @lang('layout.Update')</button>
                                        @endif
                                        <a href="{{route('invoice.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>

                                    </div>
                                    <cmodal :show='showModal' @close="showModal=false">

                                    </cmodal>
                                </div>


                            </div>


                            {!! Form::close() !!}

                        </div>

                    </div>


                </div>
                <p> &nbsp; </p>
                <p> &nbsp; </p>
            </div>
        </div>
        <!-- END TAB PORTLET-->
    </div>
</div>

@endsection
@push('scripts')
    <script src="{{URL::asset('assets/global/plugins/bootstrap-timepicker/js/bootstrap-timepicker.min.js')}}" type="text/javascript"></script>
    <script src="{{URL::asset('assets/pages/scripts/components-date-time-pickers.min.js')}}" type="text/javascript"></script>

<script type="text/javascript">

        @if(App::getLocale())
        Vue.use(VeeValidate, {
            locale: '{{App::getLocale()}}',
        });
        @else
        Vue.use(VeeValidate, {
            locale: 'en',
        });
        @endif
 

    Vue.component('v-select', VueSelect.VueSelect); 
    Vue.use(VueInputAutowidth);
    Vue.use(VueNumeric.default); 
    Vue.component("modal", {
        template: "#modal-template",
        props: ['show'],

    }); 
    //begin new member
    Vue.component("cmodal", {
        template: '#cmodal-template',
        props: ['show'],
        data() {
            return {
                types: [],
                classes: [],
                receivables: [],
                payables: [],
                code: null,
                selectType: null,
                selectPay: null,
                selectedClass: null,
                selectReceive: null,
            }
        },
        mounted() {
            setTimeout(() => {
                this.getMemberCode();
            }, 500);
        },
        methods: {
            onSubmit() {
                v.showModal = false;
                var datas = $("#modalForm").serializeArray();
                let vmc = this;
                $.ajax({
                    headers: {
                        'X-CSRF-TOKEN': "{{csrf_token()}}"
                    },
                    url: '{{route("customer.store")}}',
                    method: 'post',
                    data: {
                        "name": datas[0]['value'],
                        "code": datas[1]['value'],
                        'email': datas[2]['value'],
                        'phone': datas[3]['value'],
                        'address1': datas[4]['value'],
                        'type': this.selectType.id,
                        'receivable': this.selectReceive.id,
                        'payable': this.selectPay.id,
                        'class': (this.selectedClass) ? this.selectedClass.id : null
                    },
                    dataType: 'json',

                }).done(function(response) {
                    if (response) {
                        v.selected_customer = response.customer;
                        vmc.getMemberCode();
                    }

                }).fail(function(error) {
                    console.log('error', error);
                });
            },
            getMemberCode() {
                let vmc = this;
                axios.get('{{route("customer.create")}}').then(
                response => {
                    vmc.types = response.data.types;
                    if (vmc.types) {
                        for (var i = 0; i < vmc.types.length; i++) {
                            if (vmc.types[i].type == "Customer") {
                                vmc.selectType = vmc.types[i];
                            }
                        }
                    }
                    vmc.receivables = response.data.receivable;
                    vmc.payables = response.data.payable;
                    vmc.code = response.data.code;
                    vmc.classes = response.data.member_class;
                    if(vmc.receivables.length>0)
                    {
                        vmc.selectReceive=vmc.receivables[0];
                    }
                    if(vmc.payables.length>0)
                    {
                        vmc.selectPay=vmc.payables[0];
                    }

                }).catch(error => console.log(error));
            }
        }
    });

    // end new member

    var seePrice ={!! $seePrice !!};
    var seeCost ={!! $seeCost !!};
    var currency ={!! $currency !!};
    var currency1 ={!! $currency !!};
    var selectedCurrency = {!! $selectedCurrency !!};
    var selectedCurrencyOthers = {!! json_encode($selectedCurrencyOthers) !!};
    var banks = {!! $banks !!};
    var selectedBanks = {!! $selectedBanks !!};
    var all_services = {!! $all_services !!};
    var selectedService = {!! $selectedService !!};
    var invoice = {!! $invoice !!};
    var inventory_category = {!! $inventory_category !!};
    var memberClass = {!! $memberClass !!};
    var saleArea = {!! $saleArea !!};
    var transportCompany         = {!! $transportCompany !!};
    var allDrivers               = {!! $allDrivers !!};
    var selectedTransportCompany = {!! $selectedTransportCompany !!};
    var selectedDriver           = {!! $selectedDriver !!};
    var selected_invoice_payment = {!! $selected_invoice_payment !!};
    var taxation = {!! $taxation !!};
    var commission = {!! $commission !!};
    var discountDate = {!! $discountDate !!};
    var priceLevel = {!!$priceLevel!!};
    var priceLevelGeneral = {!!$priceLevelGeneral!!};
    var selected_priceLevel = {!!$selected_priceLevel!!};
    var receive_number = {!!json_encode($receive_number)!!}; 
    var frarmerData = {!! json_encode($frarmerData) !!}; 
    var measureList = {!! $measureList !!}; 
    var member_cloth_id = {!!json_encode($invoice->member_cloth_id)!!};
    var inventoryBrand = {!!$inventoryBrand!!};
    var inventory_sites = {!!$inventory_sites!!};
    var transferRent = {!!$transferRent!!};
    var transfer_rent_vendor_selected = {!!$transfer_rent_vendor_selected!!};
    var selectedRefundItem = {!!$selectedRefundItem!!};
    var oilPart = {!!$oilPart!!};
    var salesExpenseInfo = {!!$salesExpenseInfo!!};

    var v = new Vue({
        el: '#appInvoice',
        data: {
            print_factor_type: 'A4',
            forgivness: '',
            showModal: false,
            editKey: false,
            oil_sale: {{($invoice->oil == 1) ? 'true' : 'false'}},
            invoice: invoice,
            per_qty_check: {{($invoice->per_qty == 'on') ? 'true' : 'false'}},
            customer: [],
            all_customer: [],
            seePrice: seePrice,
            seeCost: seeCost,
            selected_customer: {!!$selectedCustomer!!},
            selected_item: [],
            selected_salesExpenseInfo: salesExpenseInfo,
            banks: banks,
            selected_banks: selectedBanks,
            all_services: all_services,
            selected_service: selectedService,
            currency: currency,
            selected_currency: selectedCurrency,
            selected_currency_other: selectedCurrencyOthers,
            selected_payment_currency: null,
            rate: 0, 
            sale_info_expense: [], 
            selected_transfer_currency: {!! $selected_transfer_currency !!},
            discountFiled: 0,
            discountFiledRow: 0,
            sale_taxation: invoice.sale_taxation,
            saleTaxation: 0,
            discountIsAmount: false,
            disabled: false,
            taxation: taxation,
            selected_taxation: null,
            commission: commission,
            selected_commission: null,
            subTotalCommi: 0,
            totalCommi: 0,
            discount_date: discountDate,
            selected_discount_date: null,
            totalTax: 0,
            subTotalTax: 0,
            brandItem: inventoryBrand,
            selected_iventory_brand: null,
            subDiscountFiledRow: 0,
            newSubDiscountFiledRow: 0,
            newSubTotal: 0,
            washing_form: false,
            wash_width: 0,
            wash_length: 0,
            inventory_category: inventory_category,
            selectedOilPart: null,
            oilPart: oilPart,
            inventory_sites: inventory_sites,
            sum_commission:0,
            selected_iventory_site: null,
            selected_inventory: null,
            selected_itemes: null,
            selected_quantity: null,
            selected_quantity_error: false,
            selected_price: null,
            AdvancePrice: null,
            AdvancePrice_cost: null,
            last_item_sale: null,
            last_item_purchase: null,
            precis: 7,
            total_return: 0,
            temp_return_items: [],
            inventory_return: [],
            selected_index: 0,
            temp_items: [],
            totalAmountes: [],
            newCost: [
                null,
                null,
                null,
                null
            ],
            inventories: [],
            services: [],
            payments: [],
            payment_invoices: [],
            CusTypes: null,
            memberClass: memberClass,
            selected_class: null,
            saleArea: saleArea,
            selected_area: null,
            ref_no: "@if($duplicate) {{$saleRef}} @else {{$invoice->ref_Number}} @endif",
            number: {{$invoice->number}},
            msg: '',
            isError1: false,

            p_total: false,
            counter_check: 0,
            counter_check1: 1,
            counter_check2: -1,

            transportCompany: transportCompany,
            allDrivers: allDrivers,
            selected_transportCompany: selectedTransportCompany,
            selected_transportDriver: selectedDriver,
            t_drivers: allDrivers,
            selected_invoice_payment: selected_invoice_payment,
            summary: [],
            hesab_sabeqah_checked: "{{$invoice->hesab_sabeqa}}",
            show_discount_checked: "{{$invoice->show_discount}}",
            show_receive_checked: "{{$invoice->show_receive}}",
            show_persian_desc: "{{$invoice->show_persian_desc}}",
            priceLevel: priceLevel,
            selected_priceLevel: null,
            priceLevelGeneral: priceLevelGeneral,
            selected_priceLevelGeneral: null,
            receive_number: receive_number,
            frarmerData: frarmerData,
            measureList: measureList,
            far_measure: null,
            far_drawing_measure: null,
            far_seed_amount: 0,
            member_cloth_list: [],
            selectedMemberCloth: null,
            member_cloth_id: member_cloth_id,
            transferRent: transferRent,
            transfer_rent_vendor: [],
            transfer_rent_vendor_selected: transfer_rent_vendor_selected,
            transfer_rent_bank_selected: null,
            transfer_rent_type: null,
            transfer_rent_description: null,
            transfer_rent_amount: null,
            old_oil_counter: 0,
            NewCounter: 0
            // static_item_price:false   
        },
        computed: {

            selectedRate() {
                if (this.selected_currency) {
                    this.rate = (this.selected_currency) ? this.selected_currency.rate : 0;

                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].item && this.inventories[i].item != null) {
                            if (this.inventories[i].item.new_rate) {
                                @if(salePriceCalculate() == "static_item_price")
                                if(this.inventories[i].item.static_item_prices && this.inventories[i].item.static_item_prices.length>0){
                                    this.changeStaticRate();
                                }else {
                                    @if(systemConfig()[30] == 1)
                                    this.inventories[i].item.cost = this.inventories[i].item.new_rate * this.selected_currency.static_rate / this.selected_currency.rate;
                                    @else 
                                    this.inventories[i].item.cost = this.inventories[i].item.new_rate * this.selected_currency.rate;
                                    @endif
                                }
                                @else
                                    @if(systemConfig()[30] == 1)
                                    this.inventories[i].item.cost = this.inventories[i].item.new_rate * this.selected_currency.static_rate / this.selected_currency.rate;
                                    @else 
                                    this.inventories[i].item.cost = this.inventories[i].item.new_rate * this.selected_currency.rate;
                                    @endif
                                @endif
                            }
                        }
                    }
                }
            },
            selectedRateOther(){
                if (this.selected_currency_other) {
                    this.selected_currency_other ? this.selected_currency_other.rate : 0;
                }
            },
            discount() {
                if ("{{getSubTotal()}}" == "true" && this.sub_Subtotal > 0) {
                    this.newSubTotal = this.sub_Subtotal;
                    this.newSubDiscountFiledRow = this.subDiscountFiledRow;
                } else {
                    this.newSubTotal = this.subtotal;
                    this.newSubDiscountFiledRow = this.discountFiledRow;
                }
                if (this.discountIsAmount) {
                    if (this.newSubTotal > 0 && this.discountFiled) {
                        return (parseFloat(this.discountFiled) * 100) / (this.newSubTotal - this.discountFiledRow);
                    } else {
                        return 0;
                    }
                } else {

                    return this.discountFiled
                }
            },

            sub_discount() {
                if (this.discountIsAmount) {
                    if (this.sub_Subtotal > 0 && this.discountFiled) {
                        return (parseFloat(this.discountFiled) * 100) / (this.sub_Subtotal - this.subDiscountFiledRow);
                    } else {
                        return 0;
                    }
                } else {
                    return this.discountFiled
                }
            },

            // calculate subtotal
            checkedSubtotal: function() {
                var sum = 0;
                var sumTax = 0;
                var sum_commission = 0;
 
                for (var i = 0; i < this.inventories.length; i++) {
                    if (this.inventories[i].item && this.inventories[i].item != null) {
                        if (this.inventories[i].tax) {

                            if (this.oil_sale == true) {
                                var quantity = this.inventories[i]['item']['oil_qty'];
                            } else {
                                var quantity = this.inventories[i]['item']['quantity'];
                            }
                            if (this.inventories[i]['item']['other_measure'] > 0 && this.per_qty_check) {
                                var quantity = this.inventories[i]['item']['other_measure'];
                            }
                            var rate = this.inventories[i]['item']['rate'];
                            var new_rate = this.inventories[i]['item']['new_rate'];
                            var smeasure_unit = this.inventories[i]['item']['measure']['measure_unit'];
                            var measure_unit = this.inventories[i]['item']['measure_unit'];
                            var selected_row_commission = this.inventories[i]['row_commission_percent'];

                            if (new_rate != rate && quantity > 0) {
                                @if(systemConfig()[30] == 1)
                                sum += new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate;
                                @else 
                                sum += new_rate * quantity * this.selected_currency.rate;
                                @endif
                            } else {
                                @if(systemConfig()[30] == 1)
                                sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate);
                                @else 
                                sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
                                @endif
                            }

                            if (this.selected_commission && !this.inventories[i].commission && selected_row_commission > 0) {
                                @if(systemConfig()[30] == 1)
                                sum_commission += ((new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate) * selected_row_commission) / 100;
                                this.inventories[i]['row_commission_amount'] = ((new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate) * selected_row_commission) / 100;
                                @else 
                                sum_commission += ((new_rate * quantity * this.selected_currency.rate) * selected_row_commission) / 100;
                                this.inventories[i]['row_commission_amount'] = ((new_rate * quantity * this.selected_currency.rate) * selected_row_commission) / 100;
                                @endif
                            }

                        } else {

                            if (this.oil_sale == true) {
                                var quantity = this.inventories[i]['item']['oil_qty'];
                            } else {
                                var quantity = this.inventories[i]['item']['quantity'];
                            }
                            if (this.inventories[i]['item']['other_measure'] > 0 && this.per_qty_check) {
                                var quantity = this.inventories[i]['item']['other_measure'];
                            }
                            var rate = this.inventories[i]['item']['rate'];
                            var new_rate = this.inventories[i]['item']['new_rate'];
                            var smeasure_unit = this.inventories[i]['item']['measure']['measure_unit'];
                            var measure_unit = this.inventories[i]['item']['measure_unit'];
                            var selected_row_commission = this.inventories[i]['row_commission_percent'];

                            

                            if (this.inventories[i]['selected_taxation'] != null) {
                                var selected_taxation = this.inventories[i]['selected_taxation']['percent'];

                                if (new_rate != rate && quantity > 0) {
                                    @if(systemConfig()[30] == 1)
                                    sumTax += ((new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate) * selected_taxation) / 100;
                                    @else 
                                    sumTax += ((new_rate * quantity * this.selected_currency.rate) * selected_taxation) / 100;
                                    @endif 

                                    @if(systemConfig()[30] == 1)
                                    this.inventories[i]['row_tax_amount'] = ((new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate) * selected_taxation) / 100;
                                    @else 
                                    this.inventories[i]['row_tax_amount'] = ((new_rate * quantity * this.selected_currency.rate) * selected_taxation) / 100;
                                    @endif 

                                    if (this.selected_commission && !this.inventories[i].commission && selected_row_commission > 0) {
                                    @if(systemConfig()[30] == 1)
                                    sum_commission += ((new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate) * selected_row_commission) / 100;
                                    this.inventories[i]['row_commission_amount'] = ((new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate) * selected_row_commission) / 100;
                                    @else 
                                    sum_commission += ((new_rate * quantity * this.selected_currency.rate) * selected_row_commission) / 100;
                                    this.inventories[i]['row_commission_amount'] = ((new_rate * quantity * this.selected_currency.rate) * selected_row_commission) / 100;
                                    @endif
                                }


                                } else {
                                    @if(systemConfig()[30] == 1)
                                    sumTax += ((quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate)) * selected_taxation) / 100;
                                    @else 
                                    sumTax += ((quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate)) * selected_taxation) / 100;
                                    @endif
                                    @if(systemConfig()[30] == 1)
                                    this.inventories[i]['row_tax_amount'] = ((quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate)) * selected_taxation) / 100;
                                    @else 
                                    this.inventories[i]['row_tax_amount'] = ((quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate)) * selected_taxation) / 100;
                                    @endif



                                    if (this.selected_commission && !this.inventories[i].commission && selected_row_commission > 0) {
                                    @if(systemConfig()[30] == 1)
                                    sum_commission += ((quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate)) * selected_row_commission) / 100;
                                    this.inventories[i]['row_commission_amount'] = ((quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate)) * selected_row_commission) / 100;
                                    @else 
                                    sum_commission += ((quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate)) * selected_row_commission) / 100;
                                    this.inventories[i]['row_commission_amount'] = ((quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate)) * selected_row_commission) / 100;
                                    @endif
                                }



                                }
                            }

                        }
                    }
                }

                if (this.selected_taxation) {
                    var percent = this.selected_taxation.percent;
                    this.totalTax = ((sum * percent) / 100) + sumTax;
                    this.subTotalTax = ((sum * percent) / 100);
                }


                if (this.selected_commission) {
                    var percent = this.selected_commission.percent;
                    this.totalCommi = ((sum * percent) / 100);
                    this.subTotalCommi = ((sum * percent) / 100);
                }else{
                    this.totalCommi = 0;
                    this.subTotalCommi = 0;
                } 
                
                this.sum_commission = sum_commission; 
                this.totalCommi += this.sum_commission;  



                return sum;
            },

            // calculate subtotal
            sub_Subtotal: function() {
                var sum = 0;
                var sum_discount = 0;
                for (var i = 0; i < this.inventories.length; i++) {
                    if (this.inventories[i].item && this.inventories[i].item != null) {
                        if (this.inventories[i].sub_total) {

                            if (this.oil_sale == true) {
                                var quantity = this.inventories[i]['item']['oil_qty'];
                            } else {
                                var quantity = this.inventories[i]['item']['quantity'];
                            }
                            if (this.inventories[i]['item']['other_measure'] > 0 && this.per_qty_check) {
                                var quantity = this.inventories[i]['item']['other_measure'];
                            }
                            var rate = this.inventories[i]['item']['rate'];
                            var new_rate = this.inventories[i]['item']['new_rate'];
                            var smeasure_unit = this.inventories[i]['item']['measure']['measure_unit'];
                            var measure_unit = this.inventories[i]['item']['measure_unit'];

                            var discount = this.inventories[i]['item']['discount'];

                            if (new_rate && quantity > 0) {
                                @if(systemConfig()[30] == 1)
                                sum += new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate;
                                @else 
                                sum += new_rate * quantity * this.selected_currency.rate;
                                @endif
                                if (this.discountIsAmount) {
                                    if (discount > 0) {
                                        sum_discount += (discount * quantity);
                                    }
                                } else {

                                    if (discount > 0) {
                                        @if(systemConfig()[30] == 1)
                                        sum_discount += (parseFloat(discount) * (new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate)) / 100;
                                        @else 
                                        sum_discount += (parseFloat(discount) * (new_rate * quantity * this.selected_currency.rate)) / 100;
                                        @endif
                                    }
                                }
                            } else {
                                @if(systemConfig()[30] == 1)
                                sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate);
                                @else 
                                sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
                                @endif

                                if (this.discountIsAmount) {
                                    if (discount > 0) {
                                        sum_discount += (discount * quantity);
                                    }
                                } else {

                                    if (discount > 0) {
                                        @if(systemConfig()[30] == 1)
                                        sum_discount += (parseFloat(discount) * (quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate))) / 100;
                                        @else 
                                        sum_discount += (parseFloat(discount) * (quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate))) / 100;
                                        @endif
                                    }
                                }
                            }

                        }
                    }
                }
                this.subDiscountFiledRow = sum_discount;
                if ("{{getSubTotal()}}" == "true" && sum > 0) {
                    this.newSubTotal = sum;
                    this.newSubDiscountFiledRow = sum_discount;
                } else {
                    this.newSubTotal = this.subtotal;
                    this.newSubDiscountFiledRow = this.discountFiledRow;
                }
                return sum;
            },

            // calculate subtotal
            subtotal: function() {
                var sum = 0;
                var sum1 = 0;
                var sum_discount = 0;
                var total_return = 0;
                for (var i = 0; i < this.inventories.length; i++) {
                    if (this.inventories[i].item && this.inventories[i].item != null) {

                        if (this.oil_sale == true) {
                            var quantity = this.inventories[i]['item']['oil_qty'];
                        } else {
                            var quantity = this.inventories[i]['item']['quantity'];
                        }
                        if (this.inventories[i]['item']['other_measure'] > 0 && this.per_qty_check) {
                            var quantity = this.inventories[i]['item']['other_measure'];
                        }
                        var rate = this.inventories[i]['item']['rate'];
                        var new_rate = this.inventories[i]['item']['new_rate'];
                        var smeasure_unit = this.inventories[i]['item']['measure']['measure_unit'];
                        var measure_unit = this.inventories[i]['item']['measure_unit'];
                        var discount = this.inventories[i]['item']['discount'];
                        if (new_rate && quantity > 0) {
                            @if(systemConfig()[30] == 1)
                            sum += new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate;
                            @else 
                            sum += new_rate * quantity * this.selected_currency.rate;
                            @endif
                            @if(systemConfig()[30] == 1)
                            sum1 += new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate;
                            @else 
                            sum1 += new_rate * quantity * this.selected_currency.rate;
                            @endif
                            if (this.discountIsAmount) {
                                if (discount > 0) {
                                    sum_discount += (discount * quantity);
                                }
                            } else {

                                if (discount > 0) {
                                    @if(systemConfig()[30] == 1)
                                    sum_discount += (parseFloat(discount) * (new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate)) / 100;
                                    @else 
                                    sum_discount += (parseFloat(discount) * (new_rate * quantity * this.selected_currency.rate)) / 100;
                                    @endif
                                }
                            }
                        } else {
                            @if(systemConfig()[30] == 1)
                            sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate);
                            @else 
                            sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
                            @endif

                            @if(systemConfig()[30] == 1)
                            sum1 += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate);
                            @else 
                            sum1 += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
                            @endif
                            if (this.discountIsAmount) {
                                if (discount > 0) {
                                    sum_discount += (discount * quantity);
                                }
                            } else {

                                if (discount > 0) {
                                    @if(systemConfig()[30] == 1)
                                    sum_discount += (parseFloat(discount) * (quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate))) / 100;
                                    @else 
                                    sum_discount += (parseFloat(discount) * (quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate))) / 100;
                                    @endif
                                }
                            }
                        }

                    }
                }

                this.discountFiledRow = sum_discount;
                @if(getSaleTaxation() == 'true')
                this.saleTaxation = (this.sale_taxation * sum / 100);
                @endif
                for (var i = 0; i < this.services.length; i++) {
                    if (this.services[i].item && this.services[i].item != null) {

                        var rate = this.services[i]['item']['rate'];
                        var new_rate = this.services[i]['item']['new_rate'];
                        var smeasure_unit = this.services[i]['item']['measure']['measure_unit'];
                        var measure_unit = this.services[i]['item']['measure_unit'];
                        var quantity = this.services[i]['item']['quantity'];
                        if (new_rate != rate && quantity > 0) {
                            @if(systemConfig()[30] == 1)
                            sum += new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate;
                            @else 
                            sum += new_rate * quantity * this.selected_currency.rate;
                            @endif

                            @if(systemConfig()[30] == 1)
                            sum1 += new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate;
                            @else 
                            sum1 += new_rate * quantity * this.selected_currency.rate;
                            @endif

                        } else {
                            @if(systemConfig()[30] == 1)
                            sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate);
                            @else 
                            sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
                            @endif
                            @if(systemConfig()[30] == 1)
                            sum1 += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate);
                            @else 
                            sum1 += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
                            @endif
                        
                        }

                    }
                }

                @if(getShowRefundToSale()=="true")
                for (var i = 0; i < this.inventory_return.length; i++) {
                    if (this.inventory_return[i].item && this.inventory_return[i].item != null) {
                        var new_rate = this.inventory_return[i]['item']['new_rate'];
                        var quantity = this.inventory_return[i]['item']['quantity'];
                        if (new_rate && quantity > 0) {
                            @if(systemConfig()[30] == 1)
                            total_return += new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate;
                            @else 
                            total_return += new_rate * quantity * this.selected_currency.rate;
                            @endif
                        }
                    }
                }
                @endif

                this.total_return = total_return;
                // console.log(21, total_return);

                if (this.selected_taxation) {
                    var tax1 = this.checkedSubtotal;
                    var tax = this.totalTax;
                    sum = tax + sum;
                }

                if (this.selected_commission) {
                    var commi = this.totalCommi;
                    @if(getSaleCommissionMarketer() != "true")
                    sum = commi + sum;
                    @endif
                }

                if (this.selected_commission) {
                    var percent = this.selected_commission.percent;
                    this.totalCommi = ((sum1 * percent) / 100);
                    this.subTotalCommi = ((sum1 * percent) / 100);
                } else {
                    this.totalCommi = 0;
                    this.subTotalCommi = 0;
                }

                return sum;
            },

            // check payed amount
            payeds: function() {
                var sum = 0;
                for (var i = 0; i < this.payments.length; i++) {

                    if (this.payments[i].item != null && this.payments[i].item) {
                        if (this.payments[i].item != null && this.payments[i]['item']['rate'] > 0) {
                            //
                            @if(systemConfig()[30] == 1)
                            sum += ((this.payments[i]['item']['amount'] / this.payments[i]['item']['static_rate'] * this.payments[i]['item']['rate']) * this.selected_currency.static_rate / this.selected_currency.rate);
                            @else 
                            sum += (this.payments[i]['item']['amount'] * this.selected_currency.rate / this.payments[i]['item']['rate']);
                            @endif                        
                        }
                    }
                }
                return sum;
            },

            // check data validation
            isError: function() {
                var isError = false;
                //var flag=false;
                // for (var i = 0; i < this.inventories.length; i++)
                // {

                //    if (this.inventories[i].item)
                //    {
                //      flag=true;
                //      if(((this.inventories[i]['item']['rate'] <=0) ))
                //      {
                //        rate=this.inventories[i]['item']['rate'];
                //        new_rate=this.inventories[i]['item']['new_rate'];
                //        if(rate <=0 && new_rate <=0)
                //        {
                //             isError = true;
                //        }

                //      }
                //    }
                // }
                if (this.selected_customer == undefined || this.selected_customer == null) {
                    isError = true;
                }
                return isError;


            },
        },
        mounted: function() {
 
            if(this.selected_currency_other){
                this.selected_currency_other.rate = invoice.second_rate; 
            }

            if (invoice.forgivness) {
                this.forgivness = invoice.forgivness;
            }

            if (invoice.print_factor_type) { 
                this.print_factor_type = invoice.print_factor_type;
            }
 
            @if(getSaleSubMeasure() =="true")
            this.precis = 7;
            @else
            this.precis = precision();
            @endif

            this.getSummary();

            @if(getShwoPriceLevel() == "general")
            this.selected_priceLevel = selected_priceLevel;
            @endif

            @if(getShwoPriceLevel() == "general_percent")
            this.selected_priceLevelGeneral = selected_priceLevel;
            @endif

            // initialize the selected item
            
            if (this.invoice) {
                if (this.invoice.id) {
                    var vmc = this;
                    axios.get("{{url('invoice')}}/" + vmc.invoice.id + "/edit")
                    .then(function(response) {
                        if (response.data) {
                            if (response.data.selectedItem) {
                                vmc.selected_item = response.data.selectedItem;

                                for (var i = 0; i < vmc.selected_item.length; i++) {
                                    // console.log('llllp',vmc.selected_item[i]);
                                    if (vmc.oil_sale == true) {
                                        vmc.selected_item[i]['new_rate'] = vmc.selected_item[i]['new_rate'] * vmc.selected_item[i]['density'];
                                        vmc.selected_item[i]['rate'] = vmc.selected_item[i]['rate'] * vmc.selected_item[i]['density'];
                                        vmc.selected_item[i]['cost'] = vmc.selected_item[i]['cost'] * vmc.selected_item[i]['density'];
                                    } 
                                    var selected_taxations = null;
                                    if (vmc.selected_item[i].row_taxation_id && vmc.taxation) {
                                        selected_taxations = _.find(vmc.taxation, (s) => s.id == vmc.selected_item[i].row_taxation_id);
                                        if (selected_taxations) {
                                            selected_taxations.percent = vmc.selected_item[i].row_tax_percent;
                                        }
                                    } 
                                    var price_level = vmc.selected_item[i].price_level;
                                    @if(getShwoPriceLevel() == "general_percent_per_item")
                                    if (vmc.selected_item[i].price_level_id) {
                                        price_level = _.find(vmc.priceLevelGeneral, (s) => s.id == vmc.selected_item[i].price_level_id);

                                    }
                                    @endif

                                    var sub_price = 0;
                                    @if(getSaleSubMeasure() =="true")
                                    if (vmc.selected_item[i].quantity > 0) {
                                        if (vmc.selected_item[i].measure2) {
                                            var item = vmc.selected_item[i];
                                            var sub_quantity = vmc.subMQuantity(item, item.quantity);
                                            var total_price = (item.new_rate * item.quantity);
                                            if (sub_quantity > 0) {
                                                @if(systemConfig()[30] == 1)
                                                sub_price = myRound((total_price / sub_quantity) * vmc.selected_currency.static_rate / vmc.selected_currency.rate);
                                                @else 
                                                sub_price = myRound((total_price / sub_quantity) * vmc.selected_currency.rate);
                                                @endif
                                            }
                                        }
                                    }
                                    @endif
                                    vmc.inventories.push({
                                        inventory: vmc.selected_item[i],
                                        item: vmc.selected_item[i],
                                        location: vmc.selected_item[i].selectedLocationList,
                                        selected_taxation: selected_taxations,
                                        tax: vmc.selected_item[i].row_tax_stat,
                                        sub_total: vmc.selected_item[i].sub_total_stat, 
                                        // row_commission_percent: vmc.selected_item[i].row_commission_percent,
                                        // commission: vmc.selected_item[i].row_commission_state,
                                        row_commission_percent: vmc.selected_item[i].row_commission_percent, 
                                        sub_price: sub_price,
                                        item_category: vmc.selected_item[i].item_category,
                                        item_brand: vmc.selected_item[i].inventory_brand,
                                        price_level: price_level
                                    });
                                }

                                vmc.addNew('inventory',1000);
                                // console.log(123, vmc.selected_item);
                            }
                        }
                    })
                    .catch(function(error) {
                        vmc.addNew('inventory',1000);
                        console.log(error);
                    })
                } 
            } 
            
            for(var j = 0; j < this.selected_salesExpenseInfo.length; j++){
                this.sale_info_expense.push({
                    name_expense: this.selected_salesExpenseInfo[j].name,
                    amount_expense: this.selected_salesExpenseInfo[j].amount, 
                    date_expense: this.selected_salesExpenseInfo[j].date,
                    account_register_expense: this.selected_salesExpenseInfo[j].register_account, 
                    description_expense: this.selected_salesExpenseInfo[j].description
                });

            } 

            // for (var i = 0; i < this.selected_item.length; i++) {
            //     // console.log('llllp',this.selected_item[i]);
            //     if (this.oil_sale == true) {
            //         this.selected_item[i]['new_rate'] = this.selected_item[i]['new_rate'] * this.selected_item[i]['density'];
            //         this.selected_item[i]['rate'] = this.selected_item[i]['rate'] * this.selected_item[i]['density'];
            //         this.selected_item[i]['cost'] = this.selected_item[i]['cost'] * this.selected_item[i]['density'];
            //     }

            //     var selected_taxations = null;
            //     if (this.selected_item[i].row_taxation_id && this.taxation) {
            //         selected_taxations = _.find(this.taxation, (s) => s.id == this.selected_item[i].row_taxation_id);
            //         if (selected_taxations) {
            //             selected_taxations.percent = this.selected_item[i].row_tax_percent;
            //         }
            //     }

            //     var price_level = this.selected_item[i].price_level;
            //     @if(getShwoPriceLevel() == "general_percent_per_item")
            //     if (this.selected_item[i].price_level_id) {
            //         price_level = _.find(this.priceLevelGeneral, (s) => s.id == this.selected_item[i].price_level_id);

            //     }
            //     @endif

            //     var sub_price = 0;
            //     @if(getSaleSubMeasure() =="true")
            //     if (this.selected_item[i].quantity > 0) {
            //         if (this.selected_item[i].measure2) {
            //             var item = this.selected_item[i];
            //             var sub_quantity = this.subMQuantity(item, item.quantity);
            //             var total_price = (item.new_rate * item.quantity);
            //             if (sub_quantity > 0) {
            //                 @if(systemConfig()[30] == 1)
            //                 sub_price = myRound((total_price / sub_quantity) * this.selected_currency.static_rate / this.selected_currency.rate);
            //                 @else 
            //                 sub_price = myRound((total_price / sub_quantity) * this.selected_currency.rate);
            //                 @endif
            //             }
            //         }
            //     }
            //     @endif
            //     this.inventories.push({
            //         inventory: this.selected_item[i],
            //         item: this.selected_item[i],
            //         location: this.selected_item[i].selectedLocationList,
            //         selected_taxation: selected_taxations,
            //         tax: this.selected_item[i].row_tax_stat,
            //         sub_total: this.selected_item[i].sub_total_stat,
            //         sub_price: sub_price,
            //         item_category: this.selected_item[i].item_category,
            //         item_brand: this.selected_item[i].inventory_brand,
            //         price_level: price_level
            //     });
            // }
            // for (var m = 4; m > this.selected_item.length; m--) {
            // this.inventories.push({
            //     inventory: null,
            //     item: null,
            //     location: null,
            //     item_category: null,
            //     item_brand: null,
            //     tax: 'on',
            //     edit: true,
            //     selected_taxation: null,
            //     sub_total: '',
            //     sub_price: 0,
            //     price_level: null
            // });
            // }
            // end item

            for (var i = 0; i < selectedRefundItem.length; i++) {
                this.inventory_return.push({
                    inventory: selectedRefundItem[i],
                    item: selectedRefundItem[i],
                    item_category: null,
                    item_brand: null,
                    tax: 'on',
                    selected_taxation: null,
                    sub_total: '',
                    price_level: null
                });
            }
            this.inventory_return.push({
                inventory: null,
                item: null,
                item_category: null,
                item_brand: null,
                tax: 'on',
                commission: 'on',
                selected_taxation: null,
                sub_total: '',
                price_level: null
            });

            ////////////////////////////////////////////////////////////////////////////////
            for (var p = 0; p < this.selected_invoice_payment.length; p++) {
                var selected_payment_currency = _.find(currency1, (v) => v.code == this.selected_invoice_payment[p].currency);
                if (selected_payment_currency) {
                    selected_payment_currency.rate = this.selected_invoice_payment[p].rate;
                }
                this.payment_invoices.push({
                    amount: this.selected_invoice_payment[p].amount,
                    description: this.selected_invoice_payment[p].description,
                    rate: this.selected_invoice_payment[p].rate,
                    selected_payment_currency: selected_payment_currency
                });
            }
            for (var q = 2; q > this.selected_invoice_payment.length; q--) {
                this.payment_invoices.push({
                    amount: null,
                    description: null,
                    rate: null,
                    selected_payment_currency: null
                });
            }
            // console.log('llllllll',this.payment_invoices)

            @if(getTransferRent() == "true")
            if (this.transferRent) {
                this.transfer_rent_type = this.transferRent.type
                this.transfer_rent_description = this.transferRent.description,
                    this.transfer_rent_amount = this.transferRent.receivable_amount

                // for (var tr = 0; tr < this.banks.length; tr++) {
                    if (this.transferRent.b_account_id != null && this.transferRent.b_account_id != "") {
                        this.transfer_rent_bank_selected = _.find(banks, (b) => b.id == this.transferRent.b_account_id);
                        // console.log(23, this.transfer_rent_bank_selected, this.transferRent.b_account_id, banks);
                    }
                    // }
                    
                }
                @endif
         

            ////////////////////////////////////////////////////////////////////////////////
            // begin payment initialization

            for (var t = 0; t < this.selected_banks.length; t++) {
                var foundFlag = false;
                var tempBank = null;
                for (var y = 0; y < this.banks.length; y++) {
                    if (this.selected_banks[t].id == this.banks[y].id) {
                        foundFlag = true;
                        tempBank = this.banks[y];
                        tempBank.amount = this.selected_banks[t].balance;

                        if (this.selected_currency.code == tempBank.code) { 
                            tempBank.rate = this.selected_currency.rate;
                        } else {
                            tempBank.rate = this.selected_banks[t].rate;
                        }
                        
                        tempBank.description = this.selected_banks[t].description;
                        tempBank.date = this.selected_banks[t].date;
                        tempBank.number = this.selected_banks[t].number;
                    }
                }
                if (foundFlag) {
                    this.payments.push({
                        item: tempBank,
                        items: this.banks
                    });
                }
            }
            for (var w = 1; w > this.selected_banks.length; w--) {
                this.payments.push({
                    item: null,
                    items: banks
                });
            }
            // end payment initialization

            // begin service

            for (var r = 0; r < this.selected_service.length; r++) {
                var flag = false;
                var tempService;
                for (var h = 0; h < this.all_services.length; h++) {
                    if (this.all_services[h].id == this.selected_service[r].item_id) {
                        flag = true;
                        tempService = this.all_services[h];
                        tempService.quantity = this.selected_service[r].qty;
                        tempService.rate = this.selected_service[r].sales_price;
                        tempService.new_rate = this.selected_service[r].sales_price;
                        tempService.online_order_detail_id = this.selected_service[r].online_order_detail_id;
                        tempService.order_detail_id = this.selected_service[r].order_detail_id;
                        tempService.description = this.selected_service[r].description;
                        tempService.description2 = this.selected_service[r].description2;
                    }
                }
                if (flag) {
                    this.services.push({
                        item: tempService,
                        items: this.all_services
                    })
                }
            }
            for (var w = 1; w > this.selected_service.length; w--) {
                this.services.push({
                    item: null,
                    items: all_services
                });
            }
            // end service

            if (this.invoice) {
                // this.selected_customer=_.find(this.all_customer,(v)=>v.id==this.invoice.member_id);
                this.selected_class = _.find(this.memberClass, (c) => c.id == this.invoice.class_id);
                this.selected_area = _.find(this.saleArea, (s) => s.id == this.invoice.sale_area_id);
 
                this.discountFiled = this.invoice.discount;
                if (this.invoice.discount_type) {
                    if (this.invoice.discount_type == 'percent') {
                        this.discountIsAmount = false;
                    } else {
                        this.discountIsAmount = true;
                    }
                }

                if (this.invoice.taxation_id && this.taxation) {
                    this.selected_taxation = _.find(this.taxation, (s) => s.id == this.invoice.taxation_id);
                    this.selected_taxation.percent = this.invoice.tax_percent;
                }

                if (this.invoice.commission_id && this.commission) {
                    this.selected_commission = _.find(this.commission, (s) => s.id == this.invoice.commission_id);
                    this.selected_commission.percent = this.invoice.commission_percent;
                }
                if (this.invoice.sale_discount_id && this.discount_date) {
                    this.selected_discount_date = _.find(this.discount_date, (s) => s.id == this.invoice.sale_discount_id);
                }

                if (this.invoice.oil_part_id) {
                    this.selectedOilPart = _.find(this.oilPart, (b) => b.id == this.invoice.oil_part_id);

                    this.gasCalculate();
                   
                }
                 
                if (this.invoice.new_oil_counter) {
                    this.NewCounter = this.invoice.new_oil_counter;
                }
                if (this.invoice.old_oil_counter) {
                    this.old_oil_counter = this.invoice.old_oil_counter;
                }
            }

            @if(systemConfig()[16] != 0 && $frarmerData)
            this.far_seed_amount = {{$frarmerData->seed_amount}};
            this.far_drawing_measure = {{$frarmerData->land_drawing_measure}};
            this.far_measure = {{$frarmerData->measure_id}};
            @endif

            @if(systemConfig()[21] != 0 && $washingData)
            this.washing_form = true;
            this.wash_width = {{$washingData->width}};
            this.wash_length = {{$washingData->length}};
            @endif

 
 
            var count = this.old_oil_counter;
            var newCounter = this.NewCounter;
            if(count && newCounter){
                this.selected_quantity = newCounter - count;
            }
        },
        methods: {

            changeStaticRate(){
                if (this.selected_currency) {
                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].item && this.inventories[i].item != null) {
                            if (this.inventories[i].item.new_rate) {
                                //Begin static_item_prices
                                @if(salePriceCalculate() == "static_item_price")
                                @if(systemConfig()[30] == 1)
                                    var changed_rate_by_static_item_price = this.inventories[i].item.new_rate * this.selected_currency.static_rate / this.selected_currency.rate;
                                @else 
                                    var changed_rate_by_static_item_price = this.inventories[i].item.new_rate * this.selected_currency.rate;
                                @endif

                                    if(this.inventories[i].item.static_item_prices && this.inventories[i].item.static_item_prices.length>0){
                                        for (var j = 0; j < this.inventories[i].item.static_item_prices.length; j++) {
                                            if (this.inventories[i].item.static_item_prices[j].currency == this.selected_currency.code) {
                                                changed_rate_by_static_item_price = this.inventories[i].item.static_item_prices[j].amount;
                                            }
                                        }
                                        this.inventories[i].item.cost = changed_rate_by_static_item_price;
                                        @if(systemConfig()[30] == 1)
                                        this.inventories[i].item.new_rate = changed_rate_by_static_item_price / this.selected_currency.static_rate * this.selected_currency.rate;
                                        @else 
                                        this.inventories[i].item.new_rate = changed_rate_by_static_item_price / this.selected_currency.rate;
                                        @endif
                                    }
                                @endif
                            }
                        }
                    }
                }
            },

            getSummary() {
                if (this.selected_customer) {
                    this.member_cloth_list = [];
                    this.selectedMemberCloth = null;
                    this.getSummaryRecor(this.selected_customer.id, this);
                    this.take_member_cloth_data(this);

                }

            },
            getSummaryRecor(id, v) {
                axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'memberStatment',
                            member_id: id,
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            v.summary = response.data;
                        } else {
                            v.summary = [];
                        }
                    })
                    .catch(function(error) {
                        console.log(error);
                    });
            },

            take_member_cloth_data(v) {

                axios.get("{{route('member.memberCloth')}}", {
                        params: {
                            member_id: this.selected_customer.id
                        },
                    }).then(function(response) {
                        v.member_cloth_list = response.data;

                        for (var j = 0; j < v.member_cloth_list.length; j++) {
                            if (this.member_cloth_id != null && v.member_cloth_list[j].id == this.member_cloth_id) {
                                v.selectedMemberCloth = v.member_cloth_list[j];
                                // console.log('ppppsss',v.selectedProject);
                            }
                        }

                    })
                    .catch(function(error) {
                        console.log(error);
                    });
            },


            checkRefNo() {

                //console.log(vm.ref_no)

                var chack = 'false';
                var ref_no = v.ref_no;
                if (ref_no != null) {


                    axios.get("{{route('callMethod.search')}}", {

                            params: {
                                ref_no: v.ref_no,
                                method_name: 'Search_ref_no',
                                table_name: 'sales'
                            },
                        })
                        .then(function(response) {
                            @if(getDuplicatedRefNo() != "true")
                            if (response.data.result != null) {
                                console.log(response.data.result);
                                v.msg = "@lang('layout.DuplicateData')";
                                v.isError1 = true;
                            } else {
                                v.msg = 'no';
                                v.isError1 = false;

                            }
                            @endif
                        })
                        .catch(function(error) {
                            console.log(error);
                        });

                }
            },

            ChangeOil() {
                if (v.oil_sale == false) {
                    v.oil_sale = true;
                } else {
                    v.oil_sale = false;
                }
                // console.log(v.oil_sale);
            },
            change_oil_qty(index) {
                if (this.inventories[index]['item'] && this.inventories[index]['item'] != null) {

                    var quantity = this.inventories[index]['item']['quantity'];
                    var density = this.inventories[index]['item']['density'];
                    if (quantity > 0 && density > 0) {
                        this.inventories[index]['item']['oil_qty'] = Number.parseFloat(quantity / density).toFixed(7);
                    }
                }

                var far_seed_amount = 0;
                for (var i = 0; i < this.inventories.length; i++) {
                    if (this.inventories[i].item && this.inventories[i].item != null) {
                        var quantity = this.inventories[i]['item']['quantity'];
                        far_seed_amount += quantity;
                    }
                }
                // if (this.inventories[0].item) {
                //     v.far_measure = this.inventories[0]['item']['measure']['measure_id'];
                // }
                this.far_seed_amount = far_seed_amount;
            },

            change_qty_by_oil(index) {
                if (this.inventories[index]['item'] && this.inventories[index]['item'] != null) {
                    var oil_qty = this.inventories[index]['item']['oil_qty'];
                    var density = this.inventories[index]['item']['density'];
                    if (oil_qty > 0 && density > 0) {
                        this.inventories[index]['item']['quantity'] = Number.parseFloat(oil_qty * density).toFixed(7);
                    }
                }
            },

            change_per_qty(index) {
                if (this.inventories[index]['item'] && this.inventories[index]['item'] != null) {
                    var other_measure = this.inventories[index]['item']['other_measure'];
                    var per_qty = this.inventories[index]['item']['site']['per_qty'];
                    // console.log(222, other_measure , per_qty , this.per_qty_check );
                    if (other_measure > 0 && per_qty > 0 && this.per_qty_check) {
                        this.inventories[index]['item']['quantity'] = myRound(other_measure * per_qty);
                    }

                    if (other_measure > 0 && per_qty > 0) {
                        @if(getSelectQuantityByOtherMeasure() == "true")
                        this.inventories[index]['item']['quantity'] = myRound(other_measure * per_qty);
                        @endif
                    }

                }
            },

            subMQuantity(item = null, quantity = null) {
                if (item != null) {
                    var result = 0;
                    if (item.site) {
                        // console.log(38383,item.measureListAll.length);

                        for (var i = 0; i < item.measureListAll.length; i++) {
                            // console.log(3838,item.measureListAll[i]);
                            if (item.measureListAll[i].measure_id == item.measure2.measure_id) {
                                result = (quantity * item.measure.measure_unit) / (item.measure_unit);
                                result = (result * item.measure_unit) / (item.measureListAll[i].measure_unit);
                            }
                        }


                    }
                    return result;
                }
            },
            secoundMeasurQuantity(item = null, quantity = null) {
                if (item != null) {
                    var result = 0;
                    if (item.site) {
                        // console.log(38383,item.measureListAll.length);
                        if (item.measureListAll) {
                            for (var i = 0; i < item.measureListAll.length; i++) {
                                // console.log(3838,item.measureListAll[i],item.measure_unit,item.measure.measure_unit);
                                if (item.measureListAll[i].measure_id == item.measure1.measure_id) {
                                    result = (quantity * item.measure.measure_unit) / (item.measure_unit);
                                    result = (result * item.measure_unit) / (item.measureListAll[i].measure_unit);
                                }
                            }
                        }



                    }
                    return result;
                }
            },

            memberClassChange() {
                if (v.selected_class) {
                    v.customer = [];
                    // v.selected_customer = null;
                    let class_id = v.selected_class.id;

                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'SearchMember',
                                class_id: class_id,
                                type: 'Customer'
                            }
                        })
                        .then(function(response) {
                            if (response.data.length > 0) {
                                // console.log(response.data);
                                v.customer = [];
                                v.customer = response.data;
                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        })
                }
            },
            MemberSearch: _.debounce((search, loading) => {
                loading(true);
                let class_id = (v.selected_class != undefined) ? v.selected_class.id : null;

                axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SearchMember',
                            keyword: search,
                            class_id: class_id,
                            type: 'Customer'
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            // console.log(response.data);
                            v.customer = [];
                            v.customer = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        loading(false);
                        console.log(error);
                    })
            }, getDebounceTime()),

            //Vendor Search for Transfer Rent
            VendorSearch: _.debounce((search, loading) => {
                loading(true);
                axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SearchMember',
                            keyword: search,
                            type: 'Vendor'
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            // console.log(response.data);
                            v.transfer_rent_vendor = [];
                            v.transfer_rent_vendor = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        loading(false);
                        console.log(error);
                    })
            }, getDebounceTime()),


            // calculate item price based on measure change
            measureChange(index) {

                if (this.inventories[index].item != null) {
                    var item = this.inventories[index].item;

                    var temp = ((item.rate * item.measure.measure_unit / item.measure_unit));
                    result = Number.parseFloat(temp).toFixed(precision());

                    // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;

                    //Begin static_item_prices
                    @if(salePriceCalculate() == "static_item_price")
                        // "AAAA"
                        var changed_rate_by_static_item_price = 0;
                        if(this.inventories[index].item.static_item_prices && this.inventories[index].item.static_item_prices.length>0){
                            for (var j = 0; j < this.inventories[index].item.static_item_prices.length; j++) {
                                if (this.inventories[index].item.static_item_prices[j].currency == this.selected_currency.code && this.inventories[index].item.static_item_prices[j].amount1) {
                                    changed_rate_by_static_item_price = this.inventories[index].item.static_item_prices[j].amount1;
                                    var temp = ((changed_rate_by_static_item_price * item.measure.measure_unit / item.measure_unit));
                                    result = Number.parseFloat(temp).toFixed(precision());

                                    this.inventories[index].item.static_item_prices[j].amount = result

                                    this.inventories[index].item.cost = result;
                                    @if(systemConfig()[30] == 1)
                                    result = result / this.selected_currency.static_rate * this.selected_currency.rate;
                                    @else 
                                    result = result / this.selected_currency.rate;
                                    @endif
                                }
                            }
                        }
                    @endif

                    this.inventories[index].item.new_rate = result;

                }
            },

            // calculate item price based on measure change
            measureChangeReturn(index) {
                if (this.inventory_return[index].item != null) {
                    var item = this.inventory_return[index].item;
                    var temp = ((item.rate * item.measure.measure_unit / item.measure_unit));
                    result = Number.parseFloat(temp).toFixed(precision());

                    this.inventory_return[index].item.new_rate = result;
                }
            },

            // Change Item Sale Rate According Item Price Level
            change_sale_rate_by_price_level(index) {

                if (this.inventories[index].item != null) {

                    var item = this.inventories[index].item;
                    var item_price_level = this.inventories[index].item.item_price_level;


                    var temp = ((item.rate * item.measure.measure_unit / item.measure_unit));
                    result = Number.parseFloat(temp).toFixed(precision());
                    this.inventories[index].item.new_rate = result;

                    var myDataArray = this.inventories[index].item.item_price_level;
                    if (this.inventories[index].price_level != undefined) {
                        var item = this.inventories[index].item;
                        for (var i = 0; i < myDataArray.length; i++) {
                            if (myDataArray[i]['id'] == this.inventories[index].price_level.id) {
                                var temp = ((myDataArray[i]['rate'] * item.measure.measure_unit / item.measure_unit));
                                result = Number.parseFloat(temp).toFixed(precision());

                                // if(this.selected_currency.rate > 0){
                                //     item.new_rate = myRound((result)/this.selected_currency.rate);
                                // }else{
                                item.new_rate = myRound(result);
                                // }
                            }

                        }
                    }
                }
            },

            // Change Item Sale Rate According Item Price Level
            change_sale_rate_by_price_level_general_per_item(index) {

                if (this.inventories != null) {
                    if (this.inventories[index].item != null) {
                        var item = this.inventories[index].item;
                        var item_price_level = this.inventories[index].price_level;
                        var price_type = item_price_level.price_type;
                        var percent = Number.parseFloat(item_price_level.percent);

                        var rate = this.inventories[index]['item']['rate'];
                        var smeasure_unit = this.inventories[index]['item']['measure']['measure_unit'];
                        var measure_unit = this.inventories[index]['item']['measure_unit'];
                        var rate1 = (rate * smeasure_unit / measure_unit);
                        rate1 = Number.parseFloat(rate1);

                        if (price_type == 'up' && percent > 0 && rate1 > 0) {
                            var result = Number.parseFloat((rate1 * percent) / 100);
                            this.inventories[index]['item']['new_rate'] = Number.parseFloat(rate1 + result);
                        } else if (price_type == 'down' && percent > 0 && rate1 > 0) {
                            var result = Number.parseFloat((rate1 * percent) / 100);
                            this.inventories[index]['item']['new_rate'] = Number.parseFloat(rate1 - result);
                        }
                    }
                }
            },

            // calculate item price based on measure change
            measureChangeservice(index) {

                if (this.services[index].item != null) {
                    var item = this.services[index].item;
                    @if(systemConfig()[30] == 1)
                    var temp = ((item.rate * item.measure.measure_unit / item.measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate);
                    @else 
                    var temp = ((item.rate * item.measure.measure_unit / item.measure_unit) * this.selected_currency.rate);
                    @endif

                    result = Number.parseFloat(temp).toFixed(precision());

                    this.services[index].item.new_rate = result;

                    // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;

                }
            },
            // detect member change and searh
            memberChange() {
                if (this.selected_customer) {
                    // get member contract
                }
            },
            // end sale order change

            // detect setSaleNumber and searh
            setSaleNumber() {
                var v = this;
                if (this.selectedOilPart) {
                    if (this.selectedOilPart.sale_number) {
                        this.number = this.selectedOilPart.sale_number;
                    }

                    v.inventories = [];
                    v.inventories.push({
                        inventory: null,
                        item: null,
                        item_category: null,
                        item_brand: null,
                        tax: 'on',
                        commission: 'on',
                        selected_taxation: null,
                        sub_total: ''
                    });
                    this.gasCalculate();
                }
            },

            // detect setSaleNumber and searh
            gasCalculate() {
                var v = this;
                if (this.selectedOilPart) {
 
                    axios.get("{{route('callMethod.search')}}", { 
                        params: {
                            method_name: 'itemesSearchCounter',
                            oilPartId: v.selectedOilPart.id,
                            SaleId: v.invoice.id
                        }
                    })
                    .then(function(response) {
                        if (response.data > 0) {
                            v.old_oil_counter = response.data;
                            v.NewCounters();
                        }else{
                            v.old_oil_counter = v.selectedOilPart.counter;
                            v.NewCounters();
                        }
                    });

                }
            },


            NewCounters(){ 
                var count = this.old_oil_counter;
                var newCounter = this.NewCounter;
                if(count && newCounter){
                    this.selected_quantity = newCounter - count;
                }
                // console.log(total);
            },


            //Get Transport Company Drivers 
            getDrivers() {
                if (this.selected_transportCompany) {
                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                transport_id: this.selected_transportCompany.id,
                                method_name: 'Search_transport_company_drivers'
                            },
                        })
                        .then(function(response) {
                            if (response.data.result != null) {
                                console.log('all Drivers', response.data.result);
                                v.t_drivers = response.data.result;
                                // v.selected_transportDriver=null;
                            } else {

                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        });
                }
            },

            //Get Just Drivers  without Transport Company Select
            getAllDrivers() {
                if (!v.selected_transportCompany) {
                    v.t_drivers = v.allDrivers;
                }
            },



            // set new price
            setNewRate(type = null, index = null) {
                if (type == 'inventory') {
                    if (this.inventories[index].item) {
                        @if(systemConfig()[30] == 1)
                        this.inventories[index].item.new_rate = this.inventories[index].item.cost / this.selected_currency.static_rate * this.selected_currency.rate;
                        @else 
                        this.inventories[index].item.new_rate = this.inventories[index].item.cost / this.selected_currency.rate;
                        @endif
                        // this.inventories[index].item.new_rate = this.$refs.in[index].value / this.selected_currency.rate;

                        @if(getSaleSubMeasure() =="true")
                        if (this.inventories[index].item.quantity > 0) {
                            if (this.inventories[index].item.measure2) {
                                var item = this.inventories[index].item;
                                var sub_quantity = v.subMQuantity(item, item.quantity);
                                var total_price = (item.new_rate * item.quantity);
                                if (sub_quantity > 0) {
                                    @if(systemConfig()[30] == 1)
                                    this.inventories[index].sub_price = Number.parseFloat((total_price / sub_quantity) * this.selected_currency.static_rate / this.selected_currency.rate).toFixed(precision());
                                    @else 
                                    this.inventories[index].sub_price = Number.parseFloat((total_price / sub_quantity) * this.selected_currency.rate).toFixed(precision());
                                    @endif
                                }
                            }
                        }
                        @endif

                    }
                }
                if (type == 'service') {
                    if (this.services[index].item) {
                        console.log('service changed');
                        @if(systemConfig()[30] == 1)
                        this.services[index].item.new_rate = this.$refs.ser[index].value / this.selected_currency.static_rate * this.selected_currency.rate;
                        @else 
                        this.services[index].item.new_rate = this.$refs.ser[index].value / this.selected_currency.rate;
                        @endif
                    }
                }


                if (type == 'sale_info_expens') {
                        if (this.sale_info_expense[index + 1] == undefined) {
                        this.sale_info_expense.push({
                        name_expense: null,
                        amount_expense: null, 
                        date_expense: null,
                        account_register_expense: null,
                        description_expense: null 
                        }); 
                    }
                    }


                if (type == 'return') {
                    if (this.inventory_return[index].item) {
                        @if(systemConfig()[30] == 1)
                        this.inventory_return[index].item.new_rate = this.$refs.return_in[index].value / this.selected_currency.static_rate * this.selected_currency.rate;
                        @else 
                        this.inventory_return[index].item.new_rate = this.$refs.return_in[index].value / this.selected_currency.rate;
                        @endif
                    }
                }
            },

            setQuantityByTotal(index) {
                if (v.counter_check == 0) {
                    v.counter_check = 1;
                    setTimeout((function () {
                        v.counter_check1 = v.$refs.total[index].value;
                        v.setQuantityByT(index);
                    }), 2e2)
                }  
            },
            setQuantityByT(index) {
                setTimeout((function () {
                    v.counter_check2 = v.$refs.total[index].value;
                    v.setQuantityByTotals(index);
                }), 2e3)
            },
            setQuantityByTotals(index) {
                if (v.counter_check1 != v.counter_check2) {
                    v.counter_check1 = v.$refs.total[index].value;
                    v.setQuantityByT(index);
                }else{
                    v.p_total = true;
                    if (v.$refs.total[index].value) {
                        if (v.inventories[index].item) {
                            if (v.oil_sale == true) {
                                if (v.inventories[index]['item']['cost']) {
                                    var cost = v.inventories[index]['item']['cost'];
                                    v.inventories[index].item.oil_qty = Number.parseFloat(v.$refs.total[index].value / cost).toFixed(7);
                                    v.change_qty_by_oil(index);
                                }
                            } else {
                                if (v.inventories[index]['item']['cost']) {
                                    var cost = v.inventories[index]['item']['cost'];
                                    v.inventories[index].item.quantity =  Number.parseFloat(v.$refs.total[index].value / cost).toFixed(7);
                                }
                            }
                        }
                    }
                    v.counter_check = 0; 
                }
            },

            setNewRateTotal(index = null) {
                if (this.inventories[index].item && this.inventories[index].sub_price > 0) {
                    if (this.inventories[index].item.measure2) {
                        var item = this.inventories[index].item;
                        var sub_quantity = v.subMQuantity(item, item.quantity);
                        var sub_price = this.inventories[index].sub_price;
                        var total_price = (sub_quantity * sub_price);
                        var quantity = item.quantity;
                        if (quantity > 0) {
                            if (this.selected_currency.rate > 0) {
                                @if(systemConfig()[30] == 1)
                                item.new_rate = Number.parseFloat((total_price / quantity) / this.selected_currency.static_rate * this.selected_currency.rate).toFixed(9);
                                @else 
                                item.new_rate = Number.parseFloat((total_price / quantity) / this.selected_currency.rate).toFixed(9);
                                @endif
                            } else {
                                item.new_rate = Number.parseFloat(total_price / quantity).toFixed(9);
                            }
                        }
                        // console.log('asda changed111', total_price, sub_quantity,item.quantity,sub_price,item);
                    }
                }
            },


            //ajax call to get items

            onItemSearch: _.debounce((search, loading) => {

                loading(true);

                let inventory_category_id = 0;
                let inventory_brand_id = 0;
                if (v.inventories[v.selected_index]) {
                    inventory_category_id = (v.inventories[v.selected_index]['item_category'] != undefined) ? v.inventories[v.selected_index]['item_category'].id : '';
                    inventory_brand_id = (v.inventories[v.selected_index]['item_brand'] != undefined) ? v.inventories[v.selected_index]['item_brand'].id : '';
                }
                axios.get("{{route('callMethod.search')}}", {
                        params: {
                            member_id: v.member_id,
                            method_name: 'itemesSearchSale',
                            keyword: search,
                            inventory_category_id: inventory_category_id,
                            inventory_brand_id: inventory_brand_id,
                        }
                    })
                    .then(function(response) { 
                        v.temp_items = [];
                        v.temp_return_items = [];
                        if (response.data.length > 0) {
                            v.temp_return_items = response.data;
                            v.temp_items = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        console.log(error);
                    })
            }, getDebounceTime()),

            onItemload(index) {
                v.selected_index = index;
                if (v.inventories[index].inventory != null) {
                    // console.log('klk',v.inventories[index].inventory,v.inventories);
                    var inventory_id = v.inventories[index].inventory.id;
                    let inventory_category_id = (v.inventories[index]['item_category'] != undefined) ? v.inventories[index]['item_category'].id : '';
                    let inventory_brand_id = (v.inventories[index]['item_brand'] != undefined) ? v.inventories[index]['item_brand'].id : '';
                    let price_level_id = (this.selected_priceLevel) ? this.selected_priceLevel.id : '';

                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                member_id: v.member_id,
                                method_name: 'itemSearchSale',
                                inventory_id: inventory_id,
                                inventory_category_id: inventory_category_id,
                                inventory_brand_id: inventory_brand_id,
                                price_level_id: price_level_id
                            }
                        })
                        .then(function(response) {
                            v.inventories[index].item = null;
                            v.inventories[index].location = null;
                            if (response.data.length > 0) {
                                v.inventories[index].item = response.data[0];
                                v.temp_items = [];

                                var site_id = null;
                                if (v.selectedOilPart) {
                                    if (v.selectedOilPart.site_id) {
                                        site_id = v.selectedOilPart.site_id;
                                    }
                                }
                                if (!site_id) {
                                    @if(getDefaultSite() > 0)
                                        site_id = {{getDefaultSite()}};
                                    @else
                                        site_id = {{getDropdown('invoice', 'site')}};
                                    @endif
                                }

                                if (site_id) {
                                    for (var i = 0; i < v.inventories[index].item.site_list.length; i++) {
                                        if (v.inventories[index].item.site_list[i].site_id == site_id) {
                                            v.inventories[index].item.site = v.inventories[index].item.site_list[i];
                                            v.changeDensity(index);
                                        }
                                    }
                                }

                                @if(salePriceCalculate() == "static_item_price")
                                    for (var i = 0; i < v.inventories[index].item.static_item_prices.length; i++) {
                                        if (v.inventories[index].item.static_item_prices[i].currency == v.selected_currency.code && v.inventories[index].item.static_item_prices[i].amount) {
                                            @if(systemConfig()[30] == 1)
                                            v.inventories[index].item.new_rate = v.inventories[index].item.static_item_prices[i].amount / v.selected_currency.static_rate * v.selected_currency.rate;
                                            @else 
                                            v.inventories[index].item.new_rate = v.inventories[index].item.static_item_prices[i].amount / v.selected_currency.rate;
                                            @endif
                                        }
                                    }
                                @endif


                                @if(getShwoPriceLevel() == "general_percent")
                                setTimeout((function() {
                                    v.change_sale_rate_by_price_level_general(index);
                                }), 400);
                                @endif
                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        })
                }
            },

            onItemloadReturn(index) {
                if (v.inventory_return[index].inventory != null) {
                    // console.log('klk',v.inventory_return[index].inventory,v.inventory_return);
                    var inventory_id = v.inventory_return[index].inventory.id;
                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                member_id: v.member_id,
                                method_name: 'itemSearchSale',
                                inventory_id: inventory_id,
                            }
                        })
                        .then(function(response) {
                            v.inventory_return[index].item = null;
                            if (response.data.length > 0) {
                                v.inventory_return[index].item = response.data[0];
                                v.temp_return_items = [];
                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        })
                }
            },

            loadItemGeneral() {
                v.editKey = false;
                if (v.selected_inventory != undefined) {
                    var inventory_id = v.selected_inventory.id;

                    // console.log(888, number);
                    let inventory_category_id = (v.selected_iventory_category != undefined) ? v.selected_iventory_category.id : '';
                    let inventory_site_id = (v.selected_iventory_site != undefined) ? v.selected_iventory_site.site_id : '';

                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                member_id: v.member_id,
                                method_name: 'itemSearchSale',
                                inventory_id: inventory_id,
                                inventory_category_id: inventory_category_id,
                                // inventory_brand_id: inventory_brand_id,
                                inventory_site_id: inventory_site_id,
                                // number: number,
                            }
                        })
                        .then(function(response) {
                            if (response.data.length > 0) {

                                var checkD = true;
                                @if(NotDuplicateItem() == "true")
                                if (v.inventories != null && response.data[0].id) {
                                    for (var i = 0; i < v.inventories.length; i++) {
                                        if (v.inventories[i].item && v.inventories[i].item != null) {
                                            if (v.inventories[i].item.id == response.data[0].id) {
                                                checkD = false;
                                            }
                                        }
                                    }
                                }
                                @endif

                                var rate = 0;
                                var static_rate = 0;
                                if (v.selected_currency.rate > 0) {
                                    rate = v.selected_currency.rate;
                                    static_rate = v.selected_currency.static_rate;
                                }

                                if (checkD) {
                                    v.selected_iventory_site = null;
                                    v.selected_itemes = response.data[0];
                                    @if(systemConfig()[30] == 1)
                                    v.selected_price = (Number.parseFloat(response.data[0].rate) * static_rate / Number.parseFloat(rate)).toFixed(precision());
                                    @else 
                                    v.selected_price = (Number.parseFloat(response.data[0].rate) * Number.parseFloat(rate)).toFixed(precision());
                                    @endif
                                    v.inventory_sites = response.data[0].site_list;
                                    v.last_item_sale = response.data[0].last_item_sale;
                                    v.last_item_purchase = response.data[0].last_item_purchase;
                                    v.AdvancePrice = response.data[0].advance_price;
                                    v.AdvancePrice_cost = response.data[0].advance_price_cost;
                                    // console.log(123, response.data[0]);
                                } else {
                                    v.selected_inventory = null;
                                    v.selected_inventory1 = null;
                                    v.counter_check = 0;
                                    v.temp_items = [];
                                    v.selected_itemes = null;
                                    v.selected_price = 0;
                                    v.selected_quantity = 0;
                                    v.$refs.barcode_search.$refs.search.focus();
                                }
                            } else {
                                // $('#success-sound')[0].play();
                                // $('#error-sound')[0].play();
                                v.item_not_found = true;
                                setTimeout((function() {
                                    v.item_not_found = false;
                                    v.$refs.barcode_search.focus();
                                }), 2e3)
                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        })

                }
            },
            
            locationSearch: _.debounce((search, loading) => {
                loading(true);
                let inventory_id = (v.inventories[v.selected_index]['item'] != undefined) ? v.inventories[v.selected_index]['item'].id : '';
                // console.log(3333, v.inventories, v.selected_index, inventory_id, search);
                if (inventory_id) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            member_id: v.member_id,
                            method_name: 'itemesSearchLocation',
                            keyword: search,
                            inventory_id: inventory_id
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            v.inventories[v.selected_index]['item']['locationList'] = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        console.log(error);
                    })
                } else {
                    loading(false);
                }
            }, getDebounceTime()),

            locationItemload(index) {
                v.selected_index = index;
                if (v.inventories[index].item != null && v.inventories[index].location != null) {
                    var inventory_id = v.inventories[index].item.id;
                    var location = v.inventories[index].location.name;

                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'itemSiteByLocation',
                                inventory_id: inventory_id,
                                location: location
                            }
                        })
                        .then(function(response) {
                            // console.log(4444, response.data);
                            if (response.data.item.length > 0) {
                                v.inventories[index].item.site_list = response.data.item;
                                v.inventories[index].item.site = response.data.selectItem;
                                
                                @if(costByLocation()=="true")
                                if (response.data.selectItem) {
                                    v.inventories[index].item.LasCost = response.data.selectItem.cost;
                                    v.inventories[index].item.description = response.data.selectItem.description;
                                }
                                @endif
                            } else {
                                v.inventories[index].item.site_list = [];
                                v.inventories[index].item.site = null;
                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        })
                }
            },

            changeDensity(index) {
                if (v.inventories[0]['item'] != null || v.inventories[0]['inventory_site'] != null) {
                    @if(systemConfig()[27] == 1)
                    if (v.inventories[index]['item']['site'] && v.oil_sale) {
                        if (v.inventories[index].item.site.per_qty) {
                            v.inventories[index].item.density = v.inventories[index].item.site.per_qty;
                            v.change_qty_by_oil(index);
                        }
                    }
                    @endif
                }
            },

            addData() {
                v.editKey = false;
                if (v.selected_itemes && v.selected_quantity > 0) {
                    v.selected_quantity_error = false;
                    v.AdvancePrice = null;
                    v.AdvancePrice_cost = null;
                    var che = null;
                    for (var i = 0; i < v.inventories.length; i++) {
                        if (!v.inventories[i].item) {
                            v.inventories.splice(i, 1);
                        }
                    }

                    let inventory_site_id = (v.selected_iventory_site != undefined) ? v.selected_iventory_site.site_id : '';
                    if (inventory_site_id) {
                        for (var i = 0; i < v.selected_itemes.site_list.length; i++) {
                            if (v.selected_itemes.site_list[i].site_id == inventory_site_id) {
                                v.selected_itemes.site = v.selected_itemes.site_list[i];
                            }
                        }
                    }

                    var rate = 0;
                    var static_rate = 0;
                    if (v.selected_currency.rate > 0) {
                        rate = v.selected_currency.rate;
                        static_rate = v.selected_currency.static_rate;
                    }

                    v.selected_itemes.quantity = (v.selected_quantity > 0) ? v.selected_quantity : 1;
                    @if(systemConfig()[30] == 1)
                    v.selected_itemes.new_rate = (v.selected_price > 0) ? (Number.parseFloat(v.selected_price) / static_rate * Number.parseFloat(rate)) : 1;
                    @else 
                    v.selected_itemes.new_rate = (v.selected_price > 0) ? (Number.parseFloat(v.selected_price) / Number.parseFloat(rate)) : 1;
                    @endif

                    v.inventories.unshift({
                        inventory: v.selected_itemes,
                        item: v.selected_itemes,
                        location: null,
                        selected_taxation: null,
                        tax: v.selected_itemes.row_tax_stat,
                        sub_total: v.selected_itemes.sub_total_stat,
                        item_category: v.selected_itemes.item_category,
                        item_brand: v.selected_itemes.inventory_brand,
                        price_level: null
                    });

                    v.selected_inventory = null;
                    v.selected_inventory1 = null;
                    v.counter_check = 0;
                    // v.temp_items = [];
                    @if(getShwoPriceLevel() == "general_percent")
                    setTimeout((function() {
                        v.change_sale_rate_by_price_level_general();
                    }), 400);
                    @endif 
                    // const inp = v.$refs.barcode_search.$refs.search;
                    // console.log(v.$refs.barcode_search.$refs.search.value);
                    v.$refs.barcode_search.$refs.search.focus();
                    // v.$refs.barcode_search.$refs.search = null;
                    // v.$refs.barcode_search.focus(); 
                    v.selected_itemes = null;
                    v.selected_price = 0;
                    v.selected_quantity = 0; 
                } else {
                    v.$refs.selected_quantity.focus();
                    v.selected_quantity_error = true;
                }

                this.NewCounters();
            },

            resetData() {
                v.AdvancePrice = null;
                v.AdvancePrice_cost = null;
                v.selected_inventory = null;
                v.selected_itemes = null;
                v.temp_items = [];
                v.selected_iventory_site = null;
                v.selected_price = 0;
                v.selected_quantity = 0;
                v.$refs.barcode_search.$refs.search.focus();
            },

            // end item search
            setIndex(e) {
                this.selected_index = e;
            },
            itemCategoryChange(index) {
                v.temp_items = [];
                v.selected_index = index;
                let inventory_category_id = (v.inventories[v.selected_index]['item_category'] != undefined) ? v.inventories[v.selected_index]['item_category'].id : '';
                let inventory_brand_id = (v.inventories[v.selected_index]['item_brand'] != undefined) ? v.inventories[v.selected_index]['item_brand'].id : '';
                axios.get("{{route('callMethod.search')}}", {
                        params: {
                            member_id: v.member_id,
                            method_name: 'itemesSearchSale',
                            inventory_category_id: inventory_category_id,
                            inventory_brand_id: inventory_brand_id
                        }
                    })
                    .then(function(response) {
                        v.temp_items = [];
                        if (response.data.length > 0) {
                            v.temp_items = response.data;
                        }
                    })
                    .catch(function(error) {
                        console.log(error);
                    });

            },

            itemBrandChange(index) {
                v.temp_items = [];
                v.selected_index = index;

                v.selected_iventory_brand = this.inventories[index]['item_brand'];
                if (this.inventories[index]['item_brand'] != null) {
                    let inventory_category_id = (v.inventories[index]['item_category'] != undefined) ? v.inventories[index]['item_category'].id : '';
                    let inventory_brand_id = this.inventories[index]['item_brand'].id; 
                    
                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                member_id: v.member_id,
                                method_name: 'itemesSearchSale',
                                inventory_category_id: inventory_category_id,
                                inventory_brand_id: inventory_brand_id
                            }
                        })
                        .then(function(response) {
                            v.temp_items = [];
                            if (response.data.length > 0) {
                                v.temp_items = response.data;
                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        });
                }

            },

            // end item search

            // Change Item Sale Rate According Item Price Level
            change_sale_rate_by_price_level_general(i) {

                if (this.inventories != null && this.selected_priceLevelGeneral) {
                    var price_type = this.selected_priceLevelGeneral.price_type;
                    var percent = Number.parseFloat(this.selected_priceLevelGeneral.percent);

                    if (this.inventories[i].item && this.inventories[i].item != null) {
                        var rate = this.inventories[i]['item']['rate'];
                        var smeasure_unit = this.inventories[i]['item']['measure']['measure_unit'];
                        var measure_unit = this.inventories[i]['item']['measure_unit'];
                        var rate1 = (rate * smeasure_unit / measure_unit);
                        rate1 = Number.parseFloat(rate1);

                        if (price_type == 'up' && percent > 0 && rate1 > 0) {
                            var result = Number.parseFloat((rate1 * percent) / 100);
                            this.inventories[i]['item']['new_rate'] = Number.parseFloat(rate1 + result);
                        } else if (price_type == 'down' && percent > 0 && rate1 > 0) {
                            var result = Number.parseFloat((rate1 * percent) / 100);
                            this.inventories[i]['item']['new_rate'] = Number.parseFloat(rate1 - result);
                        }
                    }
                }
            },


            // generic function for adding item to list
            addNew(type = null, index) {
                // this.temp_items = [];
                if (type != null) {
                    if (type == 'inventory') {
                        if (this.inventories[index + 1] == undefined) {
                            this.temp_items = [];
                            this.inventories.push({
                                inventory: null,
                                item: null,
                                location: null,
                                item_category: null,
                                item_brand: null,
                                commission: 'on',
                                tax: 'on',
                                edit: true,
                                selected_taxation: null,
                                sub_total: '',
                                price_level: null
                            });
                        }
                    }
                    if (type == 'service') {
                        if (this.services[index + 1] == undefined) {
                            this.checkExistingService(index, '');
                            this.services.push({
                                items: this.all_services,
                                item: null,
                            });
                        }
                    }
                    if (type == 'return') {
                        if (this.inventory_return[index + 1] == undefined) {
                            this.temp_items = [];
                            this.inventory_return.push({
                                inventory: null,
                                item: null,
                                item_category: null,
                                item_brand: null,
                                tax: 'on',
                                edit: true,
                                selected_taxation: null,
                                sub_total: '',
                                price_level: null
                            });
                        }
                    }
                    if (type == 'payment') {
                        if (this.payments[index + 1] == undefined) {
                            var banks = this.banks;
                            this.banks = [];
                            banks.forEach((a) => {
                                this.banks.push({
                                    amount: a.amount,
                                    balance: a.balance,
                                    code: a.code,
                                    id: a.id,
                                    name: a.name,
                                    rate: a.rate,
                                    number: receive_number + (index - (this.selected_banks.length))
                                })
                            });


                            this.checkExistingPayment(index, '');
                            this.payments.push({
                                items: this.banks,
                                item: null,
                            });
                        }
                    }
                    if (type == 'payment_invoice') {
                        if (this.payment_invoices[index + 1] == undefined) {
                            this.payment_invoices.push({
                                amount: null,
                                description: null,
                                rate: null,
                                selected_payment_currency: null
                            });
                        }
                    }

                    if (type == 'sale_info_expens') {
                        if (this.sale_info_expense[index + 1] == undefined) {
                        this.sale_info_expense.push({
                        name_expense: null,
                        amount_expense: null, 
                        date_expense: null,
                        account_register_expense: null,
                        description_expense: null 
                        }); 
                    }
                    }



                }

            },

            // in here you can check and decide to allow duplicate bank for payment or not
            checkExistingPayment(index = null, name = '') {
                var bank_temp = this.banks.slice();
                var bank_temp1 = [];
                for (var i = 0; i < this.payments.length; i++) {
                    if (this.payments[i].item != null) {
                        var fined = bank_temp.findIndex((item) => item.name == this.payments[i].item.name);
                        if (fined != -1) {
                            var o = bank_temp.splice(bank_temp.findIndex((item) => item.name == this.payments[i].item.name), 1);
                        }
                    }
                }
                this.payments[index].items = bank_temp.filter((item) => {
                    return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                });
                //this.payments[index].items =bank_temp;


            },

            // in here you can check and decide to allow duplicate service or not
            checkExistingService(index = null, name = '') {
                var service_temp = this.all_services.slice();
                var service_temp1 = [];
                for (var i = 0; i < this.services.length; i++) {
                    if (this.services[i].item != null) {
                        var fined = service_temp.findIndex((item) => item.name == this.services[i].item.name);
                        if (fined != -1) {
                            var o = service_temp.splice(service_temp.findIndex((item) => item.name == this.services[i].item.name), 1);
                        }
                    }
                }
                this.services[index].items = service_temp.filter((item) => {
                    return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                });
                //this.payments[index].items =bank_temp;


            },
            // delete item from list
            deleteItem(type = null, index) {
                if (type != null) {
                    console.log(type);
                    if (type == 'inventory') {
                        swal({
                            title: "@lang('layout.AreYouSure?')",
                            buttons: ["@lang('layout.Cancel')", "@lang('layout.yes')"],
                            text: "",
                            icon: "info",
                            dangerMode: true,
                        }).then((willDelete) => {
                            if (willDelete) {
                                this.inventories.splice(index, 1);
                            } else {

                            }
                        });
                    }
                    if (type == 'return') {
                        this.inventory_return.splice(index, 1);
                    }
                    if (type == 'service') {
                        if (type == 'service') {
                            swal({
                                title: "@lang('layout.AreYouSure?')",
                                buttons: ["@lang('layout.Cancel')", "@lang('layout.yes')"],
                                text: "",
                                icon: "info",
                                dangerMode: true,
                            }).then((willDelete) => {
                                if (willDelete) {
                                    this.services.splice(index, 1);
                                } else {

                                }
                            });
                        }
                    }
                    if (type == 'payment') {
                        this.payments.splice(index, 1);
                    }
                    if (type == 'payment_invoice') {
                        this.payment_invoices.splice(index, 1);
                    }
                    if (type == 'sale_info_expens') {
                        this.sale_info_expense.splice(index, 1);
                    }
                }

            },

            // submit the form
            submitForm() {
                this.$validator.validate().then(valid => {
                if (valid) {  
                if (this.isError == true) {
                    alert('there is no item');
                    return false;
                }
                v.disabled = true;
                swal({
                    title: "@lang('layout.AreYouSure?')",
                    buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                    text: "",
                    icon: "info",
                    dangerMode: true,
                }).then((willDelete) => {
                    if (willDelete) {
                        document.getElementById("sales-form").submit()
                    } else {
                        v.disabled = false;
                    }
                });
            } 
        });

            },



            saveAndNew() {
                this.$validator.validate().then(valid => {
                    if (valid) {
                if (!this.isError) {
                    v.disabled = true;
                    var url = "{{route('invoice.update',$invoice->id)}}";
                    form_id = 'sales-form';
                    var data = $('#' + form_id).serialize();
                    toggleBlock(true);
                    axios.post(url, data)
                        .then(function(response) {
                            toggleBlock(0);
                            // console.log('sss11', response.data);
                            if (response.data.result == 1) {

                                var a = document.createElement('a');
                                a.href = "{{route('invoice.index')}}";
                                document.body.appendChild(a);
                                a.click();
                                document.body.removeChild(a);

                                // location.reload("{{route('invoice.index')}}");
                            } else {
                                v.disabled = false;
                                var message = "{{__('message.Warning')}}";
                                //$('#error-sound')[0].play();
                                toastr.warning('', message);
                                // toastr.warning('', response.data[1]);
                            }
                        })
                        .catch(function(error) {
                            toggleBlock(0);
                            v.disabled = false;
                            // console.log(error,v.disabled);
                            var message = "{{__('message.Warning')}}";
                            //$('#error-sound')[0].play();
                            toastr.warning('', message);
                        });

                } else {
                    alert('there is no item');
                    return false;
                }
            } 
        });
            },

        },


    });
</script>



@endpush