@extends('layouts.factor-master')

@section('content')
<?php
$report = customeReportNew('driver_or_transfer');

$_sale_number = !in_array('sale_number', $report);
$_transfer_code = !in_array('transfer_code', $report);
$_transporter_name = !in_array('transporter_name', $report);
$_plate_number = !in_array('plate_number', $report);
$_quantity = !in_array('quantity', $report);
$_phone = !in_array('phone', $report);
$_place_of_weight = !in_array('place_of_weight', $report);
$_source_place = !in_array('source_place', $report);
$_way_bill_number = !in_array('way_bill_number', $report);
$_total_weight = !in_array('total_weight', $report);
$_empty_car_weight = !in_array('empty_car_weight', $report);
$_date = !in_array('date', $report);
$_description = !in_array('description', $report);



$report_percent = customeReportNewPercent('driver_or_transfer');
    $_sale_number_percent= (array_key_exists('sale_number___percent', $report_percent))?$report_percent['sale_number___percent']:null;
    $_transfer_code_percent= (array_key_exists('transfer_code___percent', $report_percent))?$report_percent['transfer_code___percent']:null;
    $_transporter_name_percent= (array_key_exists('transporter_name___percent', $report_percent))?$report_percent['transporter_name___percent']:null;
    $_plate_number_percent= (array_key_exists('plate_number___percent', $report_percent))?$report_percent['plate_number___percent']:null;
    $_quantity_percent= (array_key_exists('quantity___percent', $report_percent))?$report_percent['quantity___percent']:null;
    $_phone_percent= (array_key_exists('phone___percent', $report_percent))?$report_percent['phone___percent']:null;
    $_place_of_weight_percent= (array_key_exists('place_of_weight___percent', $report_percent))?$report_percent['place_of_weight___percent']:null;
    $_source_place_percent= (array_key_exists('source_place___percent', $report_percent))?$report_percent['source_place___percent']:null;
    $_way_bill_number_percent= (array_key_exists('way_bill_number___percent', $report_percent))?$report_percent['way_bill_number___percent']:null;
    $_total_weight_percent= (array_key_exists('total_weight___percent', $report_percent))?$report_percent['total_weight___percent']:null;
    $_empty_car_weight_percent= (array_key_exists('empty_car_weight___percent', $report_percent))?$report_percent['empty_car_weight___percent']:null;
    $_date_percent= (array_key_exists('date___percent', $report_percent))?$report_percent['date___percent']:null;
    $_description_percent= (array_key_exists('description___percent', $report_percent))?$report_percent['description___percent']:null;


?>
<table class="main-table">
    <tr>
        @if($from_date)
        <td>
            <span>@lang('layout.FromDate')</span>:
            <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
        </td>
        @endif
        @if($to_date)
        <td>
            <span>@lang('layout.ToDate')</span>:
            <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
        </td>
        @endif
    </tr>
</table>
<br>

<table class="main-table" cellpadding="5px">
    <tr style="background-color: #81cef1">
        <td  class="center" style="font-size: 20px"> @lang('layout.TruckTransportationAndDeliveryReport')
            @if($member)
            <br>
            (@lang('layout.CustomerName'): {{$member->name}})
            @endif
        </td>
    </tr>
</table>
<table class="main-table" cellpadding="5px">
    <thead>
        <tr class="bg">
            <td class="center">@lang('layout.Record') </td>
           @if($_sale_number)<td @if($_sale_number_percent) width="{{$_sale_number_percent}}%" @endif  class="center">@lang('layout.SaleNumber')</td>@endif
           @if($_date) <td @if($_date_percent) width="{{$_date_percent}}%" @endif  class="center">@lang('layout.Date')</td>@endif
           @if($_description) <td  @if($_description_percent) width="{{$_description_percent}}%" @endif style="text-align: justify">@lang('layout.Description')</td>@endif
       
           @if($_transfer_code)<td @if($_transfer_code_percent) width="{{$_transfer_code_percent}}%" @endif  class="center">@lang('layout.TransferCode')</td>@endif
           @if($_transporter_name) <td @if($_transporter_name_percent) width="{{$_transporter_name_percent}}%" @endif  class="center">@lang('layout.Transporter_name')</td>@endif
           @if($_plate_number) <td @if($_plate_number_percent) width="{{$_plate_number_percent}}%" @endif  class="center">@lang('layout.PlateNumber')</td>@endif
           @if($_quantity) <td @if($_quantity_percent) width="{{$_quantity_percent}}%" @endif  class="center">@lang('layout.Quantity')</td>@endif
           @if($_phone) <td @if($_phone_percent) width="{{$_phone_percent}}%" @endif  class="center">@lang('layout.Phone')</td>@endif
           @if($_place_of_weight) <td @if($_place_of_weight_percent) width="{{$_place_of_weight_percent}}%" @endif  class="center">@lang('layout.PlaceOfWeight')</td>@endif
           @if($_source_place) <td @if($_source_place_percent) width="{{$_source_place_percent}}%" @endif  class="center">@lang('layout.SourcePlace')</td>@endif
           @if($_way_bill_number) <td @if($_way_bill_number_percent) width="{{$_way_bill_number_percent}}%" @endif  class="center">@lang('layout.WayBillNumber1')</td>@endif
           @if($_total_weight) <td @if($_total_weight_percent) width="{{$_total_weight_percent}}%" @endif  class="center">@lang('layout.TotalWeight')</td>@endif
           @if($_empty_car_weight) <td @if($_empty_car_weight_percent) width="{{$_empty_car_weight_percent}}%" @endif  class="center">@lang('layout.EmptyCarWeight')</td>@endif
          
        </tr>
    </thead>
    <?php
    $count = 0;
    ?>
    @foreach($data AS $record)
    <tr>
        <td class="center">{{++$count}}</td>
        @if($_sale_number)<td class="center">{{$record->Number}}</td>@endif
        @if($_date)<td class="center">{{convertDate($record->Date)}}</td>@endif
        @if($_description)<td style="@if($_description_percent) text-align: justify @endif">

            {{$record->transfer_description}}

            {{-- @if(isset($report_format))
                {{$record->transfer_description}}
            @else
                {!! wordwrap($record->transfer_description,40,"<br/>\n",false) !!}
            @endif --}}


        </td>@endif
        @if($_transfer_code)<td class="center">{{$record->transfer_code}}</td>@endif
        @if($_transporter_name)<td style="text-align: justify">{{$record->transporter_name}}</td>@endif
        @if($_plate_number)<td class="center">{{$record->plate_number}}</td>@endif
        @if($_quantity)<td class="center">{{$record->total_bori}}</td>@endif
        @if($_phone)<td class="center">{{$record->transporter_phone}}</td>@endif
        @if($_place_of_weight)<td class="center">{{$record->palce_of_weight}}</td>@endif
        @if($_source_place)<td style="text-align: justify">{{$record->source_place}}</td>@endif
        @if($_way_bill_number)<td class="center">{{$record->way_bill_number}}</td>@endif
        @if($_total_weight)<td class="center">{{$record->total_weight}}</td>@endif
        @if($_empty_car_weight)<td class="center">{{$record->empty_car_weight}}</td>@endif
       

    </tr>
    @endforeach
</table>
@endsection