@extends('layouts.factor-master')
@section('style')

<style>
    .small-table td,
    .main-table td,
    .main-table tr,
    .small-table th,
    .main-table th {}

    .t1 {
        font-size: 14px;
        font-weight: bold;
        border-bottom: 1px solid black;
    }

    .t11 {
        font-size: 14px;
        font-weight: bold;
    }

    .mt1 {
        background-color: #9e9c9c;
        font-weight: bold;
        text-align: center;
        height: 50px;
        font-size: 22px;
    }

    .center1 {
        height: 41px;
    }

    .small-table td,
    .main-table td,
    .small-table th,
    .main-table th {
        border: solid 1px black;

        white-space: nowrap;
        text-overflow: ellipsis;
    }

    .small-table th,
    .main-table th {
        text-align: center;
        max-width: 35px;
        padding: 5px;
    }

    .col_b {
        padding: 8px;
        text-align: left;
        border-bottom: 1px solid #ccc;
        text-align: center;
        font-size: 14px;
    }
</style>
@stop
@section('content')

<?php
    $str_date = convertdate($sales->date);

    $date_string = substr($str_date, 0, 10);
?>


@if($inventoryReceive)
<table class="main-table">
    <tr>
        <th colspan="2" style="text-align: center"> @lang('layout.DriverInfo') </th>
    </tr>

    <tr>
        <td class="t11" style="width: 50%;height: 35px"><span>@lang('layout.Number')</span>: {{$inventoryReceive->id}}
        </td>
        <td class="t11" style="width: 30%;height: 35px"><span>@lang('layout.Date')</span>:
            @if(getInvoiceDateFormat() == "shamsi")
            <?php
                $str_date = convertdate($sales->date, 0, 'jalali');
                $date_string = substr($str_date, 0, 10);
            ?>
            {{$date_string}}
            @elseif(getInvoiceDateFormat() =='both')
            <?php
                $str_date = convertdate($sales->date, 0, 'jalali');
                $date_string = substr($str_date, 0, 10);
                echo $date_string;
            ?>
            &nbsp;/&nbsp;
            {{substr($sales->date,0,10)}}

            @elseif(getInvoiceDateFormat() =="meladi")
            {{substr($sales->date,0,10)}}

            @else

            {{$str_date}}

            @endif
        </td>
    </tr> 
    
    @if($contractPurchaseInfo && $contractPurchaseInfo !=[])   
    <tr>
        <td class="t11" style="width: 50%;height: 35px"><span>@lang('layout.ContractName')</span>: {{$contractPurchaseInfo->contract_name}}
        </td>
        <td class="t11" style="width: 30%;height: 35px"><span>@lang('layout.ContractNumber')</span>: {{$contractPurchaseInfo->contract_number}}

        </td>
    </tr>
    @endif
</table>
<table class="main-table" style="margin-top:5px ">
    @if($inventoryReceive->transfer_code)
    <tr>
        <th class="col_b">@lang('layout.TransferCode')</th>
        <td class="col_b">{{$inventoryReceive->transfer_code}}</td>
    </tr>
    @endif
    @if($inventoryReceive->transporter_name)
    <tr>
        <th class="col_b">@lang('layout.Transporter_name')</th>
        <td class="col_b">{{$inventoryReceive->transporter_name}}</td>
    </tr>
    @endif
    @if($inventoryReceive->transporter_phone)
    <tr>
        <th class="col_b">@lang('layout.Phone')</th>
        <td class="col_b">{{$inventoryReceive->transporter_phone}}</td>
    </tr>
    @endif
    @if($inventoryReceive->palce_of_weight)
    <tr>
        <th class="col_b">@lang('layout.PlaceOfWeight')</th>
        <td class="col_b">{{$inventoryReceive->palce_of_weight}}</td>
    </tr>
    @endif
    @if($inventoryReceive->source_place)
    <tr>
        <th class="col_b">@lang('layout.SourcePlace')</th>
        <td class="col_b">{{$inventoryReceive->source_place}}</td>
    </tr>
    @endif
    @if($inventoryReceive->plate_number)
    <tr>
        <th class="col_b">@lang('layout.PlateNumber')</th>
        <td class="col_b">{{$inventoryReceive->plate_number}}</td>
    </tr>
    @endif
    @if($inventoryReceive->way_bill_number)
    <tr>
        <th class="col_b">@lang('layout.WayBillNumber1')</th>
        <td class="col_b">{{$inventoryReceive->way_bill_number}}</td>
    </tr>
    @endif
    @if($inventoryReceive->total_weight)
    <tr>
        <th class="col_b">@lang('layout.TotalWeight')</th>
        <td class="col_b">{{$inventoryReceive->total_weight}}</td>
    </tr>
    @endif
    @if($inventoryReceive->total_weight)
    <tr>
        <th class="col_b">@lang('layout.EmptyCarWeight')</th>
        <td class="col_b">{{$inventoryReceive->total_weight}}</td>
    </tr>
    @endif
    @if($inventoryReceive->total_bori)
    <tr>
        <th class="col_b">@lang('layout.TotalBori')</th>
        <td class="col_b">{{$inventoryReceive->total_bori}}</td>
    </tr>
    @endif
    @if($inventoryReceive->transfer_description)
    <tr>
        <th class="col_b">@lang('layout.Description')</th>
        <td class="col_b">
        <?php 
            $des = wordwrap($inventoryReceive->transfer_description,70,"<br>");
            echo $des;
        ?>
        </td>
    </tr>
    @endif
</table>
@endif
<script type="text/javascript">
    window.print();
</script>
@endsection