@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">
<link href="{{URL::asset('assets/global/plugins/bootstrap-timepicker/css/bootstrap-timepicker.min.css')}}" rel="stylesheet" type="text/css" />
<style>
    .t_head {
        background-color: #eceef1 !important;
        /* padding: 7px !important; */
    }
    .t_body {
        background-color: #eceef1 !important;
        /* padding: 7px !important; */
    }
</style>
@section('content')
@include("layouts.Cmodal")
@include("invoices.modal")
<div class="row">
    <div class="portlet light bordered sale" >
        <!-- BEGIN TAB PORTLET-->
        <div class="portlet light bordered" >
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-anchor font-green-sharp"></i>&nbsp;
                    <span class="caption-subject font-green-sharp bold uppercase">@lang('layout.CreateNewInvoice')      
                    </span>
                </div>
                <div class="actions">
                </div>
                <div class="tools">
                    <a onclick="showHeader('invoice_create_header')"   class="btn" style="font-size: 25px"><span id="invoice_create_header_fa" class="fa fa-angle-up"> </span></a>
                </div>
            </div>
            <div id="appInvoice" class="portlet-body" v-cloak>
                <div id="measure">
                    <modal v-if="showInfoModal" @close="showInfoModal = false">
                        <div slot="body">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="row col-md-12">
                                        <h4 class=" col-md-4">
                                            @lang('menu.InventoryBrand') :</h4>
                                        <h4 class="col-md-7">
                                            @{{ brand }}
                                        </h4>
                                    </div>
                                    <div class="row col-md-12">
                                        <h4 class=" col-md-4">
                                            @lang('layout.Location') :</h4>
                                        <h4 class="col-md-7">
                                            @{{ location }}
                                        </h4>
                                    </div>
                                    <div class="row col-md-12">
                                        <h4 class=" col-md-4">
                                            @lang('layout.ByAdvancePricing') :</h4>
                                        <h4 class="col-md-7">
                                            @{{ AdvancePrice }}
                                        </h4>
                                    </div>
                                    @if(getShowMakeCartan()=="true")
                                    <div class="row col-md-12">
                                        <h4 class=" col-md-4">
                                            @lang('layout.Width') :</h4>
                                        <h4 class="col-md-7">
                                            @{{ width }}
                                        </h4>
                                    </div>
                                    <div class="row col-md-12">
                                        <h4 class=" col-md-4">
                                            @lang('layout.Height') :</h4>
                                        <h4 class="col-md-7">
                                            @{{ height }}
                                        </h4>
                                    </div>
                                    @endif
                                </div>
                                <div class="col-md-6">
                                    <div class="row col-md-12">
                                        <h4 class=" col-md-4">
                                            @lang('layout.Cost') :</h4>
                                        <h4 class="col-md-7">
                                            @{{ cost }}
                                        </h4>
                                    </div>
                                    <div class="row col-md-12">
                                        <h4 class=" col-md-4">
                                            @lang('layout.SerialNum') :</h4>
                                        <h4 class="col-md-7">
                                            @{{ SNumber }}
                                        </h4>
                                    </div>
                                    <div class="row col-md-12">
                                        <h4 class=" col-md-4">
                                            @lang('layout.OnHand') :</h4>
                                        <h4 class="col-md-7">
                                            @{{ on_hand }} @{{ measure_name }}
                                        </h4>
                                    </div>
                                    @if(getShowMakeCartan()=="true")
                                    <div class="row col-md-12">
                                        <h4 class=" col-md-4">
                                            @lang('layout.Length') :</h4>
                                        <h4 class="col-md-7">
                                            @{{ length }}
                                        </h4>
                                    </div>
                                    @endif
                                </div>
                            </div>
                            @if(ShowLastSale()=="true")
                            <div class="row" v-if="last_item_sale != null && last_item_sale != ''">
                                <div class="col-md-12">
                                    <h3> @lang('layout.ShowLastSales') </h3>
                                    <table class="table table-striped table-bordered table-hover">
                                        <thead>
                                            <tr>
                                                <th style="text-align: center">@lang('layout.CustomerName')</th>
                                                <th style="text-align: center">@lang('layout.Number')</th>
                                                <th style="text-align: center">@lang('layout.Price')</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr v-for="(last_it,index) in last_item_sale">
                                                <td style="text-align: center">@{{last_it.member}}</td>
                                                <td style="text-align: center">@{{last_it.number}}</td>
                                                <td style="text-align: center">@{{myRound(last_it.price)}} @{{last_it.currency}}</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            @endif
                        </div>
                        <h3 slot="header">
                            <div class="col-md-4">
                                <h3>
                                    @lang('layout.OtherInformations') @lang('layout.Item')
                                </h3>
                            </div>
                        </h3>
                        <div slot="footer">
                            <button type=button class="modal-default-button" v-on:click="showInfoModal = false ,measure = null , type=null">
                                @lang('layout.Cancel')
                            </button>
                        </div>
                    </modal>
                </div>
                <div class="tabbable tabbable-tabdrop">
                    <div>
                        {{Form::open(['route' => 'invoice.storeMultiple','method' => 'POST','class' => 'form-horizontal','id'=>'sales-form'])}}
                        {{ csrf_field() }}
                        <div class="tab-content">
                            <div class="tab-pane active" id="tab1">
                                <div v-cloak class="portlet-body form" style="margin-bottom:50%;">
                                    <!-- begin sale order modal -->
                                    <div id="salOrderApp" v-cloak>
                                        <!-- {{Form::open(['route' => 'export.PDFAll','method' => 'DELETE','class' => 'inline'])}} -->
                                        <input type="hidden" name="type" value="invoicelist" />
                                        <!-- use the modal component, pass in the prop -->
                                        <modal v-if="showModalSaleOrder" @close="showModalSaleOrder = false">
                                            <div slot="body">
                                                <div class="row">
                                                    <div class="form-group">
                                                        <div class="col-md-12">
                                                            <label class="control-label ">@lang('layout.Select')</label>
                                                            <select class="form-control" style="border: 1px solid black !important" v-model="selected_sale_order" @input="saleOrderChang()">
                                                                <option v-for="order in saleOrderList" :value="order">
                                                                    <span>
                                                                        @{{order.type+':'+order.number+' '+order.description}}
                                                                    </span>
                                                                </option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>

                                                <div class="row">
                                                    <div class="form-group">

                                                        <div class="col-md-6">
                                                            <label class="control-label ">@lang('layout.Currency')</label>
                                                            <input type="text" name="" :value="(!selected_sale_order)?null:selected_sale_order.currency" class="form-control" disabled="disabled">
                                                        </div>
                                                        <div class="col-md-6">
                                                            <label class="control-label ">@lang('layout.Rate') </label>
                                                            <input type="text" name="" :value="(!selected_sale_order)?null:selected_sale_order.rate" class="form-control" disabled="disabled">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="form-group">
                                                        <div class="col-md-6">
                                                            <label class="control-label ">@lang('layout.Date') </label>
                                                            <input type="text" name="" :value="(!selected_sale_order)?null:selected_sale_order.date" class="form-control" disabled="disabled">
                                                        </div>
                                                        <div class="col-md-6">
                                                            <label class="control-label ">@lang('layout.DeliveryDate') </label>
                                                            <input type="text" name="" :value="(!selected_sale_order)?null:selected_sale_order.delivery_date" class="form-control" disabled="disabled">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="form-group">

                                                        <div class="col-md-6">
                                                            <label class="control-label ">@lang('layout.SaleArea')</label>
                                                            <input type="text" name="" :value="(!selected_sale_order)?null:selected_sale_order.sale_area_name" class="form-control" disabled="disabled">
                                                        </div>
                                                        <div class="col-md-6">
                                                            <label class="control-label ">@lang('layout.Category')</label>
                                                            <input type="text" name="" :value="(!selected_sale_order)?null:selected_sale_order.category" class="form-control" disabled="disabled">
                                                        </div>

                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="form-group">

                                                        <div class="col-md-12">
                                                            <label class="control-label ">@lang('layout.Description') </label>
                                                            <input type="text" name="" :value="(!selected_sale_order)?null:selected_sale_order.description" class="form-control" disabled="disabled">
                                                        </div>

                                                    </div>
                                                </div>
                                                <br>
                                                <p style="color: red">@lang('layout.SOmsg')

                                            </div>

                                            <div slot="footer">
                                                <button type="button" v-if="selected_sale_order" @click="getsalesOrders" class="btn btn-success">
                                                    @lang('layout.Submit')
                                                </button>
                                                <button type="button" class="btn btn-danger" v-on:click="showModalSaleOrder=false">
                                                    @lang('layout.Cancel')
                                                </button>
                                            </div>
                                        </modal>
                                        <!-- {{Form::close()}} -->
                                    </div>
                                    <!-- end sale order modal -->

                                    <!-- BEGIN FORM-->
                                    <!--BEGIN INVOICE TABS-->
                                    <div class="row" id="invoice_create_header">
                                        <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12">
                                            {{-- <div class="tabbable-custom nav-justified"> --}}
                                                <ul class="nav nav-tabs">
                                                    <li class="active">
                                                        <a href="#general" data-toggle="tab" aria-expanded="true">@lang('layout.Invoice')</a>
                                                    </li>
                                                    @if(getTaxation()=="true" || getSaleCommission()=="true")
                                                    <li class="">
                                                        <a href="#tab2" data-toggle="tab" aria-expanded="false">@lang('layout.Tax')/ @lang('layout.Commission')</a>
                                                    </li>
                                                    @endif
                                                    @if(getTransportCompany()=="true")
                                                    <li class="">
                                                        <a href="#tab3" data-toggle="tab" aria-expanded="false">@lang('menu.TransportCompany')</a>
                                                    </li>
                                                    @endif
                                                    <li class="">
                                                        <a href="#tab4" data-toggle="tab" aria-expanded="false">@lang('layout.OtherInformations')</a>
                                                    </li>
                                                    @if(ShowLastSale()=="true")
                                                    <li class="">
                                                        <a href="#tab5" data-toggle="tab" aria-expanded="false">@lang('layout.ShowLastSales')</a>
                                                    </li>
                                                    @endif
                                                    
                                                </ul>
                                                <div class="tab-content">
                                                    <div class="tab-pane active" id="general" style="padding: 0 10px 0 10px;">

                                                            {{-- <table class="table" id="form_header_table">
                                                                    <tr>
                                                                        <td> 1 </td>
                                                                        <td> Mark </td>
                                                                        <td> Otto </td>
                                                                        <td> makr124 </td>
                                                                    </tr><tr>
                                                                        <td> 1 </td>
                                                                        <td> Mark </td>
                                                                        <td> Otto </td>
                                                                        <td> makr124 </td>
                                                                    </tr>
                                                            </table> --}}
                                                        <input type="hidden" name="temp_type" value="invoice">
                                                        <div class="row">
                                                            <div class="col-lg-12 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px; padding: 20px !important;">
                                                                <div class="row">
                                                                    <div v-show="showWhat('sale_area')=='yes'" class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                                        <div class="form-group">
                                                                            <div class="col-md-12">
                                                                                <label class="control-label">@lang('layout.SaleArea')</label>
                                                                                <v-select label="name" :options="saleArea" v-model="selected_area"></v-select>
                                                                                <input type="hidden" name="sale_area_id" :value="!selected_area?null:selected_area.id">
                                                                            
                                                                            </div>
                                                                        </div>
                                                                    </div>
        
                                                                    <div v-show="showWhat('member_class')=='yes'" class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                                        <div class="form-group">
                                                                            <div class="col-md-12">
                                                                                <label class="control-label">@lang('layout.MemberClass') </label>
                                                                                <v-select label="name" :options="memberClass" v-model="selected_class" @input="memberClassChange()"></v-select>
                                                                                <input type="hidden" name="class_id" :value="!selected_class?null:selected_class.id">
                                                                            
                                                                            </div>
                                                                        </div>
                                                                    </div>

                                                                    @if(getShwoPriceLevel()=="general")
                                                                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                                            <div class="form-group">
                                                                                <div class="col-md-12">
                                                                                    <label class="control-label">@lang('layout.PriceLevel') </label>
                                                                                    <v-select label="name" :options="priceLevel" v-model="selected_priceLevel" @input="changePriceLevel()">
                                                                                    </v-select>
                                                                                    <input type="hidden" name="price_level_id" :value="!selected_priceLevel?null:selected_priceLevel.id">
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    @endif

                                                                    @if(getShwoPriceLevel()=="general_percent")
                                                                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                                            <div class="form-group">
                                                                                <div class="col-md-12">
                                                                                    <label class="control-label">@lang('layout.PriceLevel') </label>
                                                                                    <v-select label="name" :options="priceLevelGeneral" v-model="selected_priceLevelGeneral" @input="change_sale_rate_by_price_level_general()">
                                                                                    </v-select>
                                                                                    <input type="hidden" name="price_level_id" :value="!selected_priceLevelGeneral?null:selected_priceLevelGeneral.id">
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    @endif

                                                                    @if(systemConfig()[13] != 0 )
                                                                        <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                                            <div class="form-group">
                                                                                <div class="col-md-12">
                                                                                    <label class="control-label">@lang('menu.Membercloth')</label>
                                                                                    <v-select class="vue-select2" label="name"
                                                                                            :options="member_cloth_list" v-model="selectedMemberCloth">
                                                                                    </v-select>
                                                                                    <input type="hidden" name="member_cloth_id"
                                                                                        v-model.number="(!selectedMemberCloth)?null:selectedMemberCloth.id">
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    @endif 

                                                                    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                                        <div class="form-group">
                                                                            <div class="">
                                                                                <label class="control-label">@lang('layout.Customer') </label>
                                                                                <div class="input-group">
                                                                                    <v-select label="name" @input="memberChange(),getSummary()" @search="MemberSearch" :options="customer" v-model="selected_customer">
                                                                                    </v-select>
                                                                                    <input type="hidden" name="customer" v-validate="'required'" data-vv-as="@lang('layout.Customer')" :value="!selected_customer?null:selected_customer.id" required>
                                                                                    <span class="btn btn-success input-group-addon " title="@lang('button.AddNewCustomer')" @click="showModal = true" style="background-color:  rgb(84, 199, 211)">
                                                                                        <i class="fa fa-plus" style="color: white"></i>
                                                                                    </span> 
                                                                                </div>
                                                                                <span class="required">@{{ errors.first('customer') }}</span>
                                                                            </div>
                                                                        </div>
                                                                    </div>

                                                                    <div v-show="showWhat('descriptionASMemberName')=='yes'" class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                                        <div class="form-group">
                                                                            <div class="col-md-12">
                                                                                <label class=" control-label">@lang('layout.OtherMemberName')</label>
                                                                                <div>
                                                                                    <input type="text" name="other_member_name" v-model="other_member_name" class="form-control">
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>

                                                                    @if(systemConfig()[27] == 1)
                                                                        <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                                            <div class="form-group">
                                                                                <div class="col-md-12">
                                                                                    <label class="control-label">@lang('menu.GasStation')</label>
                                                                                    <v-select class="vue-select2" label="name" :options="oilPart" v-model="selectedOilPart" @input="setSaleNumber()">
                                                                                    </v-select>
                                                                                    <input type="hidden" name="oil_part_id" v-model.number="(!selectedOilPart)?null:selectedOilPart.id">
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    @endif

                                                                    <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                                        <div class="form-group">
                                                                            <div class="col-md-12">
                                                                                <label class="control-label">@lang('layout.InvoiceNumber')</label>
                                                                                <input type="number" name="number" v-validate="'required|numeric'" data-vv-as="@lang('layout.InvoiceNumber')" @input="checkNo()" v-model="number" class="form-control">
                                                                                <span class="required">@{{ errors.first('number') }}</span>
                                                                                <span v-if="number_Error ==true" class="input-has-error" style="color: red">@{{number_msg}}</span>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="row">
                                                                    <div :class="(selected_sale_order && selected_customer && selected_sale_order.member_id == selected_customer.id) ? 'col-lg-3 col-md-3 col-sm-12 col-xs-12': 'col-lg-3 col-md-3 col-sm-12 col-xs-12'">
                                                                        <div class="form-group">
                                                                            <div class="col-md-12">
                                                                                <label class="control-label">@lang('layout.ReferenceNumber')</label>
                                                                                <input type="text" name="ref_no" v-model="ref_no" class="form-control" @input="checkRefNo()">
                                                                                <span v-if="isError1 ==true" class="input-has-error" style="color: red">@{{msg}}</span>
                                                                            </div>
                                                                        </div>
                                                                    </div>

                                                                    <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12" v-if="selected_sale_order && selected_customer && selected_sale_order.member_id == selected_customer.id">
                                                                        <div class="form-group">
                                                                            <div class="col-md-12">
                                                                                <label class="control-label">@lang('layout.SONumber')</label>
                                                                                <input type="text" class="form-control" :value="(!selected_sale_order)?null:selected_sale_order.number" readonly>
                                                                            </div>
                                                                        </div>
                                                                    </div>

                                                                    <div v-show="online_order" class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                                        <div class="form-group">
                                                                            <div class="col-md-12">
                                                                                <label class="control-label">@lang('layout.Customer') </label>
                                                                                <input type="text" readonly class="form-control" :value="!online_order?null:online_order.name">
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    
                                                                    <div v-show="online_order" class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                                        <div class="form-group">
                                                                            <div class="col-md-12">
                                                                                <label class="control-label">@lang('layout.Phone') </label>
                                                                                <input type="text" readonly class="form-control" :value="!online_order?null:online_order.phone">
                                                                            </div>
                                                                        </div>
                                                                    </div>

                                                                    

                                                                    <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12" style="padding: 0px !important;">
                                                                        <div class="col-lg-6 col-md-3 col-sm-12 col-xs-12">
                                                                            <div class="form-group">
                                                                                <div class="">
                                                                                    <label class="control-label">@lang('layout.Date')</label>
                                                                                    <date_picker name="date" v-model="date"></date_picker>
                                                                                </div>
                                                                            </div>
                                                                        </div>
    
                                                                        <div class="col-lg-6 col-md-3 col-sm-12 col-xs-12">
                                                                            <div class="form-group">
                                                                                <div class="">
                                                                                    <label class="control-label">@lang('layout.Hour')</label>
                                                                                    <div class="input-group" @click="stopDynamicTime" @mousemove="changeTime"> 
                                                                                        @if(getHourType() == 24)
                                                                                        <input type="text" class="form-control timepicker timepicker-24" v-model="dynamic_time" ref="time_input" name="hour" @keyup="changeTime">
                                                                                        @else
                                                                                        <input type="text" class="form-control timepicker timepicker-no-seconds" v-model="dynamic_time" ref="time_input" name="hour" @keyup="changeTime">
                                                                                        @endif
                                                                                        <span class="input-group-btn">
                                                                                            <button class="btn default" type="button">
                                                                                                <i class="fa fa-clock-o"></i>
                                                                                            </button>
                                                                                        </span>
                                                                                    </div>
                                                                                    {{-- <date_picker name="date" v-model="date"></date_picker> --}}
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    
                                                                    @if(getSaleToBase() == 'true')
                                                                        <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                                            <table class="table table-striped table-bordered table-advance ">
                                                                                <tr>
                                                                                    <td class="t_body">
                                                                                        <div style="display: flex; justify-content: center;">
                                                                                            <label class="mt-checkbox mt-checkbox-outline">@lang('layout.SaleBaseCurrency')
                                                                                                <input type="checkbox" name="sale_base_currency" value="ok">
                                                                                                <span></span>
                                                                                            </label>
                                                                                        </div>
                                                                                    </td>
                                                                                </tr>
                                                                            </table>
                                                                        </div>
                                                                    @endif

                                                                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                                                        <div class="form-group">
                                                                            <div class="col-md-12">
                                                                                <label class="control-label">@lang('layout.Description')</label>
                                                                                <textarea name="description" class="form-control" rows="1" v-text="invoiceDescription"></textarea>
                                                                            </div>
                                                                        </div>
                                                                    </div>

                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!--BEGIN TAX / COMMISSION-->
                                                    <div class="tab-pane" id="tab2">
                                                        <div class="row">
                                                            @if(getTaxation()=="true")
                                                            <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                                                <div class="panel panel-default">
                                                                    <div class="panel-heading">
                                                                        <h3 class="panel-title">@lang('layout.Tax')</h3>
                                                                    </div>
                                                                    <div class="panel-body">
                                                                        <div class="row">
                                                                        <!--Begin Taxation -->
                                                                            @if(getTaxation()=="true")
                                                                            <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                                                                <div class="form-group">

                                                                                    <div class="col-md-12">
                                                                                        <label class="control-label">@lang('layout.Tax')</label>
                                                                                        <v-select v-model="selected_taxation" label="name" :options="taxation">
                                                                                        </v-select>
                                                                                        <input type="hidden" name="taxation_id" :value="!selected_taxation?null:selected_taxation.id" />
                                                                                        <input type="hidden" name="taxation_vendor_id" :value="!selected_taxation?null:selected_taxation.member_id" />
                                                                                        <input type="hidden" name="taxation_value" :value="subTotalTax" readonly />
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                            <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                                                                <div class="form-group">

                                                                                    <div class="col-md-12">
                                                                                        <label class="control-label">@lang('layout.Percentage') %</label>
                                                                                        <input type="number" name="percent_tax" class="form-control" v-model="!selected_taxation?null:selected_taxation.percent">
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                            @endif
                                                                        <!--End Taxation -->
                                                                        </div>
                                                                        <div class="row">
                                                                            @if(getSaleTaxation() == 'true')
                                                                            <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                                                                <div class="form-group">
                                                                                    <div class="col-md-12">
                                                                                        <label class="control-label">@lang('layout.Tax')</label>

                                                                                        <div class="input-group"> 
                                                                                            <input v-model="sale_taxation" class="form-control" type="number" min="0" max="100" />
                                                                                            <span class="input-group-addon">%</span>
                                                                                            <input type="hidden" name="sale_taxation" :value="sale_taxation" />
                                                                                            <input type="hidden" name="sale_taxation_value" :value="saleTaxation" />
                                                                                        </div>

                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                            @endif
                                                                        </div>

                                                                    </div>
                                                                </div>
                                                            </div>
                                                            @endif
                                                            @if(getSaleCommission()=="true")
                                                            <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                                                <div class="panel panel-default">
                                                                    <div class="panel-heading">
                                                                        <h3 class="panel-title">@lang('layout.Commission')</h3>
                                                                    </div>
                                                                    <div class="panel-body">
                                                                        <!--Begin commission -->
                                                                        @if(getSaleCommission()=="true")
                                                                        <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                                                            <div class="form-group">

                                                                                <div class="col-md-12">
                                                                                    <label class="control-label">@lang('layout.Commission')</label>
                                                                                    <v-select v-model="selected_commission" label="name" :options="commission">
                                                                                    </v-select>
                                                                                    <input type="hidden" name="commission_id" :value="!selected_commission?null:selected_commission.id" />
                                                                                    <input type="hidden" name="commission_vendor_id" :value="!selected_commission?null:selected_commission.member_id" />
                                                                                    <input type="hidden" name="commission_expense_id" :value="!selected_commission?null:selected_commission.expense_id" />
                                                                                    <input type="hidden" name="commission_value" :value="subTotalCommi" readonly />
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                                                            <div class="form-group">

                                                                                <div class="col-md-12">
                                                                                    <label class="control-label">@lang('layout.Percentage') %</label>
                                                                                    <input type="number" name="commission_percent" class="form-control" v-model="!selected_commission?null:selected_commission.percent">
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                        @endif
                                                                        <!--End commission -->
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            @endif
                                                        </div>
                                                    </div>
                                                    <!--END TAX / COMMISSION-->
                                                    <!--BEGIN TransportCompany-->
                                                    <div class="tab-pane" id="tab3">
                                                        <div class="row">
                                                            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                                                <div class="panel panel-default">
                                                                    <div class="panel-heading" style="background: transparent;">
                                                                        <h3 class="panel-title text-center">@lang('menu.TransportCompany')</h3>
                                                                    </div>
                                                                    <div class="panel-body">
                                                                        <div class="row">
                                                                            <!--Begin Transport Company-->
                                                                            @if(getTransportCompany()=="true")
                                                                            <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                                                                <div class="form-group">

                                                                                    <div class="col-md-12">
                                                                                        <label class="control-label">@lang('menu.TransportCompany')</label>
                                                                                        <v-select v-model="selected_transportCompany" label="name" :options="transportCompany" @input="getDrivers" @click.native="getAllDrivers">

                                                                                        </v-select>

                                                                                        <input type="hidden" name="transportCompany_id" :value="!selected_transportCompany?null:selected_transportCompany.id">
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                            <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                                                                <div class="form-group">

                                                                                    <div class="col-md-12">
                                                                                        <label class="control-label">@lang('layout.Driver')</label>

                                                                                        <v-select label="name" :options="t_drivers" v-model="selected_transportDriver">

                                                                                        </v-select>
                                                                                        <input type="hidden" name="trasnsport_driver_id" :value="!selected_transportDriver?null:selected_transportDriver.id">
                                                                                    </div>
                                                                                </div>
                                                                            </div>

                                                                            @endif
                                                                            <!--End Transport Company-->
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <div class="row">
                                                            <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12 t_head">
                                                                    
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!--END TransportCompany-->
                                                    <div class="tab-pane" id="tab4" style="padding: 0 10px 0 10px">
                                                        <div class="row">
                                                            <div class="col-lg-12 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px; padding: 20px !important;">
                                                                <div class="row">
                                                                    <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                                        <div class="form-group">
                                                                            <div class="col-md-12">
                                                                                <label class="control-label">@lang('layout.Discount')</label>
                                                                                <div class="input-group">
                                                                                    <input v-model="discountFiled" class="form-control" type="number" min="0" max="100">
                                                                                    <span v-if="discountIsAmount" @click="discountIsAmount = !discountIsAmount" class="input-group-addon">@{{selected_currency.symbol}}
                                                                                        <input type="hidden" class="input-group-addon" name="discount_type" value="currency">
                                                                                    </span>
                                                                                    <span v-else @click="discountIsAmount = !discountIsAmount" class="input-group-addon">%
                                                                                        <input type="hidden" name="discount_type" value="percent">
                                                                                    </span>
                                                                                    <input type="hidden" name="discountTotal" :value="discount">
                                                                                    <input type="hidden" name="discount" :value="discountFiled">
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>

                                                                    <!--Begin Sale Discount Date -->
                                                                    @if(getSaleDiscountDate()=="true")
                                                                        <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                                            <div class="form-group">
                                                                                <div class="col-md-12">
                                                                                    <label class="control-label">@lang('menu.DiscountDate')</label>
                                                                                    <v-select v-model="selected_discount_date" label="name" :options="discount_date">
                                                                                    </v-select>
                                                                                    <input type="hidden" name="discount_date_id" :value="!selected_discount_date?null:selected_discount_date.id" />
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    @endif
                                                                    <!--End Sale Discount Date -->

                                                                    <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                                        <div class="form-group">
                                                                            <div class="col-md-12">
                                                                                <label class="control-label">@lang('layout.OverdueDate')</label>
                                                                                <date_picker name="overdue_date" v-model="overdue_date"></date_picker>
                                                                            </div>
                                                                        </div>
                                                                    </div>

                                                                    @if(getChangeItem()=="true")
                                                                        <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                                            <div class="form-group">
                                                                                <div class="col-md-12">
                                                                                    <label class="control-label">@lang('layout.ExDate')</label>
                                                                                    <input type="text" name="alert_date" class="form-control date" autocomplete="off">
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                        <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                                            <div class="form-group">
                                                                                <div class="col-md-12">
                                                                                    <label class="control-label">@lang('layout.ExDescription')</label>
                                                                                    <textarea name="alert_description" class="form-control" rows="1"></textarea>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    @endif
                                                                    <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                                        <div class="form-group">
                                                                            <div class="col-md-12">
                                                                                <label class="control-label">@lang('layout.Forgivness')</label>
                                                                                <select name="forgivness" id="" class="form-control form-select" v-model="forgivness">
                                                                                    <option selected value="">@lang('layout.Select')</option>
                                                                                    <option value="forgivness">@lang('layout.Forgivness')</option>
                                                                                    <option value="withoutForgivness">@lang('layout.WithoutForgivness')</option>
                                                                                </select>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="row" style="margin-top: 5px;">
                                                                    {{-- <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                                        <table class="table table-striped table-bordered table-advance ">
                                                                            <tr>
                                                                                <td class="t_body">
                                                                                    <div style="display: flex; justify-content: center;">
                                                                                        <label class="mt-checkbox mt-checkbox-outline">@lang('layout.Gift')
                                                                                            <input type="checkbox" name="gift" value="ok">
                                                                                            <span></span>
                                                                                        </label>
                                                                                    </div>
                                                                                </td>
                                                                            </tr>
                                                                        </table>
                                                                    </div> --}}
                                                                    @if(getFactorPending()=="true")
                                                                        <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12" >
                                                                            <table class="table table-striped table-bordered table-advance ">
                                                                                <tr>
                                                                                    <td class="t_body">
                                                                                        <div style="display: flex; justify-content: center;">
                                                                                            <label class="mt-checkbox mt-checkbox-outline">@lang('layout.Factor') @lang('layout.Pending')
                                                                                                <input type="checkbox" name="pending" value="on">
                                                                                                <span></span>
                                                                                            </label>
                                                                                        </div>
                                                                                    </td>
                                                                                </tr>
                                                                            </table>
                                                                        </div>
                                                                    @endif
                                                                    @if(getNegativeSale() == 'true')
                                                                        <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                                            <table class="table table-striped table-bordered table-advance ">
                                                                                <tr>
                                                                                    <td class="t_body">
                                                                                        <div style="display: flex; justify-content: center;">
                                                                                            <label class="mt-checkbox mt-checkbox-outline">@lang('layout.NegativeSale')
                                                                                                <input type="checkbox" name="negative_sale" value="ok">
                                                                                                <span></span>
                                                                                            </label>
                                                                                        </div>
                                                                                    </td>
                                                                                </tr>
                                                                            </table>
                                                                        </div>
                                                                    @endif
                                                                    @if(getActiveSale()=="true")
                                                                        <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12" >
                                                                            <table class="table table-striped table-bordered table-advance ">
                                                                                <tr>
                                                                                    <td class="t_body">
                                                                                        <div style="display: flex; justify-content: center;">
                                                                                            <label class="mt-checkbox mt-checkbox-outline">@lang('layout.NotAprover')
                                                                                                <input type="checkbox" name="sale_status" value="on">
                                                                                                <span></span>
                                                                                            </label>
                                                                                        </div>
                                                                                    </td>
                                                                                </tr>
                                                                            </table>
                                                                        </div>
                                                                    @endif
                                                                    @if(oilSale() == 'true')
                                                                        <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                                            <table class="table table-striped table-bordered table-advance ">
                                                                                <tr>
                                                                                    <td class="t_body">
                                                                                        <div style="display: flex; justify-content: center;">
                                                                                            <label class="mt-checkbox mt-checkbox-outline">@lang('layout.Oil')
                                                                                                <input type="checkbox" @click="ChangeOil" name="oil_sale" @if(systemConfig()[27] == 1 && oilSale() == 'true') checked @endif value="ok">
                                                                                                <span></span>
                                                                                            </label>
                                                                                        </div>
                                                                                    </td>
                                                                                </tr>
                                                                            </table>
                                                                        </div>
                                                                    @endif
                                                                    @if(getSaleSubMeasure()=="true")
                                                                        <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                                            <table class="table table-striped table-bordered table-advance ">
                                                                                <tr>
                                                                                    <td class="t_body">
                                                                                        <div style="display: flex; justify-content: center;">
                                                                                            <label class="mt-checkbox mt-checkbox-outline">@lang('layout.SubPrice')
                                                                                                <input type="checkbox" @click="subPrice" name="sub_price" checked value="ok">
                                                                                                <span></span>
                                                                                            </label>
                                                                                        </div>
                                                                                    </td>
                                                                                </tr>
                                                                            </table>
                                                                        </div>
                                                                    @endif
                                                                    @if(getSaleByOtherMeasure() == "true")
                                                                        <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                                            <table class="table table-striped table-bordered table-advance ">
                                                                                <tr>
                                                                                    <td class="t_body">
                                                                                        <div style="display: flex; justify-content: center;">
                                                                                            <label class="mt-checkbox mt-checkbox-outline">@lang('layout.PerQty')
                                                                                                <input type="checkbox" name="per_qty_check" v-model="per_qty_check">
                                                                                                <span></span>
                                                                                            </label>
                                                                                        </div>
                                                                                    </td>
                                                                                </tr>
                                                                            </table>
                                                                        </div>
                                                                    @endif
                                                                    @if(getSaleByOtherMeasureRate() == "true")
                                                                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                                            <table class="table table-striped table-bordered table-advance ">
                                                                                <tr>
                                                                                    <td class="t_body">
                                                                                        <div style="display: flex; justify-content: center;">
                                                                                            <label class="mt-checkbox mt-checkbox-outline">@lang('layout.SaleByOtherMeasureRate')
                                                                                                <input type="checkbox" name="per_qty_check" v-model="per_qty_check">
                                                                                                <span></span>
                                                                                            </label>
                                                                                        </div>
                                                                                    </td>
                                                                                </tr>
                                                                            </table>
                                                                        </div>
                                                                    @endif
                                                                    @if(ShowSaveTempItemToCustomer() == "true")
                                                                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                                            <table class="table table-striped table-bordered table-advance ">
                                                                                <tr>
                                                                                    <td class="t_body">
                                                                                        <div style="display: flex; justify-content: center;">
                                                                                            <label class="mt-checkbox mt-checkbox-outline">@lang('layout.SaveTempItemToCustomer')
                                                                                                <input type="checkbox" name="save_temp_item" value="yes">
                                                                                                <span></span>
                                                                                            </label>
                                                                                        </div>
                                                                                    </td>
                                                                                </tr>
                                                                            </table>
                                                                        </div>
                                                                    @endif
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="tab-pane" id="tab5" style="padding: 0 10px 0 10px">
                                                        @if(ShowLastSale()=="true")
                                                        <div class="row">
                                                            <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                                                <div class="well" v-if="last_item_sale != null && last_item_sale != ''" style="overflow-x: scroll; height:130px; padding: 5px 1px 1px 1px; margin-bottom: 5px;">
                                                                    <table class="dashboard-tabel table-bordered" width="100%">
                                                                                <tr>
                                                                                    <td style="text-align: center">@lang('layout.Customer')</td>
                                                                                    <td style="text-align: center">@lang('layout.Unit')</td>
                                                                                    <td style="text-align: center">@lang('layout.SalePrice')</td>
                                                                                </tr>
                                                                                <tr v-for="(last_it,index) in last_item_sale">
                                                                                    <td style="text-align: center">@{{last_it.member}}</td>
                                                                                    <td style="text-align: center">@{{last_it.Measure}}</td>
                                                                                    <td style="text-align: center">@{{myRound(last_it.price)}} @{{last_it.currency}}</td>
                                                                                </tr>
                                                                    </table>
                                                                </div>
                                                            </div>
                                                            <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                                                <div class="well" v-if="last_item_purchase != null && last_item_purchase != ''" style="overflow-x: scroll; height:110px; padding: 5px 1px 1px 1px; margin-bottom: 5px;">
                                                                    <table class="dashboard-tabel table-bordered" width="100%">
                                                                                <tr>
                                                                                    <td style="text-align: center">@lang('layout.Vendor')</td>
                                                                                    <td style="text-align: center">@lang('layout.Unit')</td>
                                                                                    <td style="text-align: center">@lang('layout.Cost')</td>
                                                                                </tr>
                                                                                <tr v-for="(last_it,index) in last_item_purchase">
                                                                                    <td style="text-align: center">@{{last_it.member}}</td>
                                                                                    <td style="text-align: center">@{{last_it.Measure}}</td>
                                                                                    <td style="text-align: center">@{{myRound(last_it.cost)}} @{{last_it.currency}}</td>
                                                                                </tr>
                                                                    </table>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        @endif
                                                    </div>
                                                </div>
                                            {{-- </div> --}}

                                            @if(TabIndexInItemName() =="true" && 1==2)
                                            <!--Begin barcode search Item-->
                                            <div class="row col-lg-12 col-md-12 col-sm-12 col-xs-12"  style="background-color: #eceef1;padding-top:10px; margin:0 2px 5px 2px">
                                                <div class="col-lg-8 col-md-8 col-sm-12 col-xs-12" style="padding: 0px !important;">
                                                    <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                                        
                                                        <label class="control-label">@lang('layout.SerialNum')</label>
                                                        <div class="input-group">
                                                            <input type="text" v-model="selected_inventory1"  ref="barcode_search1" class="form-control" @input="(!check_with_key)?callOnItemloadGeneral():''" >
                                                            {{-- <input type="number" v-model="exchange_amount" @input="set_rate(), getTranslateToWordExchange()" class="form-control" min="0" step="any"> --}}
                                                            <span class="input-group-addon">
                                                                <input type="checkbox" v-model="check_with_key" title="{{ __('layout.SearchItemsWithSpecificKey') }}">
                                                                <span></span>
                                                            </span>
                                                        </div>
                                                    </div> 
                                                    <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12" v-show="showWhat('sale_category')=='yes'">
                                                        <div class="form-group">
                                                            <label class="control-label">@lang('layout.Category')</label>
                                                            <v-select label="name" v-model="selected_iventory_category" :options="inventory_category"></v-select>
                                                        </div>
                                                    </div>
                                                
                                                    <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12" >
                                                        <div class="form-group">
                                                            <label class="control-label">@lang('layout.Site')</label>
                                                            <v-select label="name" v-model="selected_iventory_site" :options="inventory_sites"></v-select>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12"  >
                                                    <div class="form-group">
                                                        <label class="control-label">@lang('layout.Quantity')</label>
                                                        <input type="number" v-model.number="selected_quantity" class="form-control input-style input-number" placeholder="@lang('layout.Quantity')">
                                                    </div>
                                                </div>
                                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12"  >
                                                    <div class="form-group">
                                                        <label class="control-label col-md-12" style="color: white;">.</label>
                                                        <button type="button" v-if="((!isError) && (number_Error == false) && (isError1 == false))" @click="handleSubmit($event)" :disabled="disabled" class="btn green">@lang('layout.Submit')</button>
                                                    </div>
                                                </div>
                                            </div>
                                            <!--END barcode search Item-->
                                            @endif

                                            @if(systemConfig()[23] == 1 && 1==2)
                                            <!--Begin search Item-->
                                            <div class="col-lg-12 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px; margin-bottom: 10px; padding: 20px !important;">
                                                <div class="row" style="padding: 0px 10px;">
                                                    <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                        <div class="form-group">
                                                            <!-- <div class="col-md-12"> -->
                                                                <!-- <label class="control-label">@lang('layout.ItemName')</label> -->
                                                                <v-select label="name" ref="barcode_search" @input="loadItemGeneral(), editKey = false"  v-model="selected_inventory" :options="temp_items" @search="onItemSearch" placeholder="@lang('layout.ItemName')" ></v-select>
                                                            <!-- </div> -->
                                                        </div>
                                                        <p v-if="selected_item" style="background-color: rgb(216 222 239)">
                                                            @lang('layout.OnHand'): @{{(selected_item)?(Number.parseFloat(selected_item.on_hand * selected_item.measure_unit / selected_item.measure.measure_unit).toFixed(2)):''}} @{{(selected_item)?selected_item.measure.measure_name:''}}
                                                        </p>
                                                    </div>
                                                    <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12"  >
                                                        <div class="form-group">
                                                            <!-- <label class="control-label">@lang('layout.Site')</label> -->
                                                            <v-select label="name" v-model="selected_iventory_site" :options="inventory_sites1" placeholder="@lang('layout.Site')"></v-select>
                                                        </div>
                                                        <p v-if="selected_item && selected_iventory_site" >
                                                            @{{(selected_item && selected_iventory_site)?(Number.parseFloat(selected_iventory_site.OnHand * selected_item.measure_unit / selected_item.measure.measure_unit).toFixed(2)):''}}
                                                        </p>
                                                    </div>
                                                    <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12"  >
                                                        <div class="form-group">
                                                            <!-- <div class="col-md-12"> -->
                                                                <!-- <label class="control-label">@lang('layout.Quantity')</label> -->
                                                                <input type="number" v-model.number="selected_quantity" ref="selected_quantity" class="form-control input-style input-number" placeholder="@lang('layout.Quantity')">
                                                                <span class="required" v-if="selected_quantity_error" >@lang('layout.Quantity')</span>
                                                            <!-- </div> -->
                                                        </div>
                                                        <p v-if="AdvancePrice" >
                                                        @lang('layout.ByAdvancePricing') : @{{ AdvancePrice }}
                                                        </p>
                                                    </div>
                                                    <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12"  >
                                                        <div class="form-group">
                                                            <!-- <div class="col-md-12"> -->
                                                                <!-- <label class="control-label">@lang('layout.Quantity')</label> -->
                                                                <select v-model="(selected_item == null)?null:selected_item.measure" @input="changeMesurss()" class="form-control" >
                                                                    <option value="null">@lang('layout.Select')</option>
                                                                    <span v-if="(selected_item ==null)?false:true">
                                                                        <option v-for="measure in (selected_item==null)?null:selected_item.measure_list" :value="measure">
                                                                            @{{measure.measure_name}} 
                                                                        </option>
                                                                    </span>
                                                                </select>
                                                            <!-- </div> -->
                                                        </div>
                                                        @if(systemConfig()[30] == 1)
                                                        <p v-if="AdvancePrice_cost && AdvancePrice" >
                                                        @lang('layout.Price') : @{{(selected_item==null)?null:Number.parseFloat((AdvancePrice_cost * selected_item.measure.measure_unit / selected_item.measure_unit) * selected_currency.static_rate / selected_currency.rate).toFixed(precision())}} @{{selected_currency.symbol}}
                                                        </p>
                                                        @else 
                                                        <p v-if="AdvancePrice_cost && AdvancePrice" >
                                                        @lang('layout.Price') : @{{(selected_item==null)?null:Number.parseFloat((AdvancePrice_cost * selected_item.measure.measure_unit / selected_item.measure_unit) * selected_currency.rate).toFixed(precision())}} @{{selected_currency.symbol}}
                                                        </p>
                                                        @endif

                                                    </div>
                                                    <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12" v-show="seePrice==true" >
                                                        <div class="form-group">
                                                            <!-- <div class="col-md-12"> -->
                                                                <!-- <label class="control-label">@lang('layout.Price')</label> -->
                                                                <input type="number" v-model.number="selected_price" class="form-control input-style input-number" placeholder="@lang('layout.Price')">
                                                            <!-- </div> -->
                                                        </div>
                                                        @if(systemConfig()[30] == 1)
                                                        <p v-if="selected_item && seeCost==true" style="background-color: rgb(216 222 239)">
                                                        @lang('layout.CostInInventory'): @{{(selected_item==null)?null:Number.parseFloat((selected_item.LasCost * selected_item.measure.measure_unit / selected_item.measure_unit) * selected_currency.static_rate / selected_currency.rate).toFixed(precision())}} @{{selected_currency.symbol}}
                                                        </p>
                                                        @else 
                                                        <p v-if="selected_item && seeCost==true" style="background-color: rgb(216 222 239)">
                                                        @lang('layout.CostInInventory'): @{{(selected_item==null)?null:Number.parseFloat((selected_item.LasCost * selected_item.measure.measure_unit / selected_item.measure_unit) * selected_currency.rate).toFixed(precision())}} @{{selected_currency.symbol}}
                                                        </p>
                                                        @endif
                                                    </div>
                                                    <div class="col-lg-1 col-md-1 col-sm-12 col-xs-12" style="padding: 0px !important;" >
                                                        @lang('layout.Total'): @{{(selected_item==null)?null:Number.parseFloat(selected_quantity * selected_price).toFixed(precision())}} @{{selected_currency.symbol}}
                                                    </div>
                                                    <div class="col-lg-1 col-md-1 col-sm-12 col-xs-12" style="padding: 0px !important; display: flex; justify-content: center; gap: 5px;"  >
                                                        <button type="button" @click="addData()" class="btn btn-success"><i class="fa fa-plus"></i></button>
                                                        <button type="button" @click="resetData()" class="btn btn-danger"><i class="fa fa-times"></i></button>
                                                    </div>
                                                </div>
                                            </div>
                                            <!--END search Item-->
                                            @endif
                                        </div>
                                        <div class="col-lg-3 col-md-3 col-sm-12">
                                            <div class="col-lg-12 col-md-12 col-sm-12" style="box-shadow: 0px 0px 3px rgba(172, 171, 171, 0.877);border-radius: 8px;margin-bottom: 1em;">
                                                <div class="row" style="padding: 10px 20px;">
                                                    <!-- begin total -->
                                                    <div class="well" v-if="multi_currency" style="padding: 5px 1px 1px 1px;">
                                                        <table class="dashboard-tabel">
                                                            <tr>
                                                                <td style="text-align: center">@lang('layout.Currency')</td>
                                                                <td style="text-align: center">@lang('layout.GrandTotal')</td>
                                                                <td style="text-align: center">@lang('layout.Discount')</td>
                                                                <td style="text-align: center">@lang('layout.Payment')</td>
                                                                <td style="text-align: center">@lang('layout.Total')</td>
                                                            </tr>
                                                            <tr v-for="(row, index) in multi_currency">
                                                                <td style="text-align: center">
                                                                    @{{ (row.currency)?row.currency.code:null }}
                                                                </td>
                                                                <td style="text-align: center">
                                                                    @{{ (row.currency)?format_number(Number.parseFloat(row.sum)):0 }}
                                                                </td>
                                                                <td style="text-align: center">
                                                                    @{{ (row.currency)?format_number(Number.parseFloat(row.all_discount)+Number.parseFloat(row.sum_discount)):0 }}
                                                                </td>
                                                                <td style="text-align: center">
                                                                    @{{ (row.currency)?format_number(Number.parseFloat(row.payment)):0 }}
                                                                </td>
                                                                <td style="text-align: center">
                                                                    @{{ (row.currency)?format_number(Number.parseFloat((row.sum - (row.all_discount) - row.sum_discount)-row.payment)):0}}
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </div>

                                                    {{-- <div class="well" v-show="seePrice== true" style="padding:0px; margin-bottom: 5px;">
                                                        <table class="dashboard-tabel">
                                                            <tr>
                                                                <td colspan="2">
                                                                    <small style="font-weight: bolder;font-size:20px">@lang('layout.Total') :</small>
                                                                </td>
                                                                <td class="text-right" colspan="2">
                                                                    <span data-counter="counterup" data-value="7800" style="font-weight: bolder;font-size:20px">
                                                                        @{{ format_number(Number.parseFloat(((subtotal - (discount*(newSubTotal - newSubDiscountFiledRow)/100) - discountFiledRow) - saleTaxation)-payeds - total_return))}}
                                                                    </span>
                                                                    <small class="font-green-sharp" style="font-weight: bolder;font-size:20px">
                                                                        @{{selected_currency.symbol}}
                                                                    </small>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td>
                                                                    <small>@lang('layout.Discount'): (@{{ format_number(Number.parseFloat(discount)) }}%) </small>
                                                                </td>
                                                                <td class="text-right">
                                                                    <span class="text-right" data-counter="counterup" data-value="7800">
                                                                        @{{ format_number(Number.parseFloat(discount*(newSubTotal - newSubDiscountFiledRow)/100)+Number.parseFloat(discountFiledRow)) }}
                                                                    </span>
                                                                    <small class="font-green-sharp">
                                                                        @{{selected_currency.symbol}}
                                                                    </small>
                                                                </td>
                                                                <td>
                                                                    <small>@lang('layout.Payment'):</small>
                                                                </td>
                                                                <td class="text-right">
                                                                    <span class="text-right" data-counter="counterup" data-value="7800">@{{ format_number(Number(payeds))}}</span>
                                                                    <small class="font-green-sharp">@{{selected_currency.symbol}}</small>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                @if(getSaleTaxation() == 'true')
                                                                <td>
                                                                    <small>
                                                                        @lang('menu.Taxation'): (@{{format_number(Number.parseFloat(sale_taxation))}}%)
                                                                    </small>
                                                                </td>
                                                                <td class="text-right">
                                                                    <span class="text-right" data-counter="counterup" data-value="7800">
                                                                        @{{ format_number(Number.parseFloat(saleTaxation)) }}
                                                                    </span>
                                                                    <small class="font-green-sharp">
                                                                        @{{selected_currency.symbol}}
                                                                    </small>
                                                                </td>
                                                                @endif
                                                                <td>
                                                                    <small>@lang('layout.Leakage'):</small>
                                                                </td>
                                                                <td class="text-right">
                                                                    <span class="text-right" data-counter="counterup" data-value="7800">@{{ format_number(Number(total_return))}}</span>
                                                                    <small class="font-green-sharp"> @{{selected_currency.symbol}}</small>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td colspan="2">
                                                                    <small>@lang('layout.GrandTotal'):</small>
                                                                </td>
                                                                <td class="text-right" colspan="2">
                                                                    <span class="text-right" data-counter="counterup" data-value="7800">
                                                                        @{{ format_number(Number(subtotal))}}
                                                                    </span>
                                                                    <small class="font-green-sharp">
                                                                        @{{selected_currency.symbol}}
                                                                    </small>
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </div> --}}
                                                    {{-- <!-- end total -->
                                                    @if(getTaxation() =="true")
                                                        <!-- begin total tax -->
                                                        <div class="well " v-show="seePrice== true" style="padding: 5px 1px 1px 1px; margin-bottom: 5px;">
                                                            <table class="dashboard-tabel">
                                                                <tr>
                                                                    <td>
                                                                        <small>@lang('layout.Total') @lang('layout.Tax') :</small>
                                                                    </td>
                                                                    <td class="text-right">
                                                                        <span data-counter="counterup" data-value="7800">
                                                                            @{{ myRound(totalTax)}}
                                                                        </span>
                                                                        <small class="font-green-sharp">
                                                                            @{{selected_currency.symbol}}
                                                                        </small>
                                                                    </td>
                                                                    <td>
                                                                        <small>@lang('layout.Sub-Total'):</small>
                                                                    </td>
                                                                    <td class="text-right">
                                                                        <span class="text-right" data-counter="counterup" data-value="7800">
                                                                            @{{ format_number(Number(checkedSubtotal))}}
                                                                        </span>
                                                                        <small class="font-green-sharp">
                                                                            @{{selected_currency.symbol}}
                                                                        </small>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                        </div>
                                                        <!-- end total -->
                                                    @endif
                                                    @if(getSaleCommission() =="true")
                                                        <!-- begin total commission -->
                                                        <div class="well " v-show="seePrice== true" style="padding: 5px 1px 1px 1px; margin-bottom: 5px;">
                                                            <table class="dashboard-tabel">
                                                                <tr>
                                                                    <td>
                                                                        <small>@lang('layout.Total') @lang('layout.Commission') :</small>
                                                                    </td>
                                                                    <td class="text-right">
                                                                        <span data-counter="counterup" data-value="7800">
                                                                            @{{ myRound(totalCommi)}}
                                                                        </span>
                                                                        <small class="font-green-sharp">
                                                                            @{{selected_currency.symbol}}
                                                                        </small>
                                                                    </td>
                                                                    <td>
                                                                        <small>@lang('layout.Sub-Total'):</small>
                                                                    </td>
                                                                    <td class="text-right">
                                                                        <span class="text-right" data-counter="counterup" data-value="7800">
                                                                            @{{ format_number(Number(checkedSubtotal))}}
                                                                        </span>
                                                                        <small class="font-green-sharp">
                                                                            @{{selected_currency.symbol}}
                                                                        </small>
                                                                    </td>
                                                                </tr> 
                                                            </table>
                                                        </div>
                                                        <!-- end total -->
                                                    @endif
                                                    @if(getSubTotal() == 'true')
                                                        <div class="well" style="padding: 5px 1px 1px 1px; margin-bottom: 5px;">
                                                            <table class="dashboard-tabel table-bordered" width="100%">
                                                                <tr>
                                                                    <td>
                                                                        <center>@lang('layout.Sub-Total')</center>
                                                                    </td>
                                                                    <td class="highlight">
                                                                        <center>
                                                                            <span class="text-right" data-counter="counterup" data-value="7800">
                                                                                @{{ format_number(Number(sub_Subtotal))}}
                                                                            </span>
                                                                            <small class="font-green-sharp">
                                                                                @{{selected_currency.symbol}}
                                                                            </small>
                                                                        </center>
                                                                    </td>
                                                                    <td>
                                                                        <center>@lang('layout.Discount'): (@{{
                                                                            format_number(Number.parseFloat(discount))
                                                                            }}%)
                                                                        </center>
                                                                    </td>
                                                                    <td class="hidden-xs">
                                                                        <center>
                                                                            <span class="text-right" data-counter="counterup" data-value="7800">
                                                                                @{{ format_number(Number.parseFloat(sub_discount*(sub_Subtotal - subDiscountFiledRow)/100)+Number.parseFloat(subDiscountFiledRow)) }}
                                                                            </span>
                                                                            <small class="font-green-sharp">
                                                                                @{{selected_currency.symbol}}
                                                                            </small>
                                                                        </center>
                                                                    </td>
                                                                    <td>
                                                                        <center>@lang('layout.Total')</center>
                                                                    </td>
                                                                    <td>
                                                                        <center>
                                                                            <span data-counter="counterup" data-value="7800">
                                                                                @{{ format_number(Number.parseFloat((sub_Subtotal - (sub_discount*(sub_Subtotal - subDiscountFiledRow)/100) - subDiscountFiledRow) - saleTaxation))}}
                                                                            </span>
                                                                            <small class="font-green-sharp">
                                                                                @{{selected_currency.symbol}}
                                                                            </small>
                                                                        </center>
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                        </div>
                                                    @endif --}}
                                                    <div class="well" v-if="selected_customer" style="padding: 5px 1px 1px 1px;">
                                                        <table class="dashboard-tabel">
                                                            <tr>
                                                                <td style="text-align: center">@lang('layout.Currency') </td>
                                                                <td style="text-align: center">@lang('layout.Payable')</td>
                                                                <td style="text-align: center">@lang('layout.Receivable')</td>
                                                            </tr>
                                                            <tr v-for="summ in summary">
                                                                <td style="text-align: center">
                                                                    @{{ summ.currency }}
                                                                </td>
                                                                <td style="text-align: center"> @{{ format_number(Number(summ.payment)) }}</td>
                                                                <td style="text-align: center">
                                                                    @{{format_number(Number(summ.invoice)) }}
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!--END INVOICE TABS-->

                                    <div class="form-body">
                                        <div v-for="(row_currency,c_index) in multi_currency">
                                            <div class="row" style="background-color: #b7ecf9; border: 1px solid #627073;">
                                                
                                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                    <div class="form-group">
                                                        <div class="col-md-12">
                                                            <label class="control-label">@lang('layout.Currency')</label>
                                                            <v-select label="code" :options="row_currency.allCurency" @input="selectedRate" @Click.native="checkExistingCurrency(c_index)" @keyup.native="checkExistingCurrency(c_index)" v-model="row_currency.currency" auto></v-select>
                                                            <input type="hidden" :name="'currency['+c_index+']'" v-validate="'required'" data-vv-as="@lang('layout.Currency')" :value="!row_currency.currency?0:row_currency.currency.code">
                                                            <span class="required">@{{ errors.first('currency['+c_index+']') }}</span>
                                                        </div>
                                                    </div>
                                                </div>
                                                
                                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                    <div class="form-group">
                                                        <div class="col-md-12">
                                                            <label class="control-label">@lang('layout.Rate')</label>
                                                            <input type="number" :name="'currency_rate['+c_index+']'" v-validate="'required'" data-vv-as="@lang('layout.Rate')" v-model="!row_currency.currency?1:row_currency.currency.rate" class="form-control" :class="{'has-error':rate<=0}">
                                                            <span class="required">@{{ errors.first('currency_rate['+c_index+']') }}</span>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-lg-1 col-md-1 col-sm-6 col-xs-12">
                                                    <div class="form-group">
                                                        <div class="col-md-12">
                                                            <label class="control-label">&nbsp;</label>
                                                            <button type="button" @click="addNewCurrency(c_index)" class="form-control btn btn-info"><i class="fa fa-plus"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-lg-1 col-md-1 col-sm-6 col-xs-12" v-if="multi_currency.length > 1">
                                                    <div class="form-group">
                                                        <div class="col-md-12">
                                                            <label class="control-label">&nbsp;</label>
                                                            <button type="button" @click="deleteCurrency(c_index)" class="form-control btn btn-danger"><i class="glyphicon glyphicon-trash"></i></button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div v-if="row_currency.currency">

                                                <div class="row" style="overflow-x: scroll;">
                                                    @if(systemConfig()[23] == 1)
                                                    <table id="table_content" class="table table-bordered table-advance table-hover">
                                                        <thead>
                                                            <tr>
                                                                <th>#</th>
                                                                @if(getTaxation() =="true")
                                                                <th>@lang('layout.Tax')</th>
                                                                @endif
                                                                
                                                                <th v-show="showWhat('sale_category')=='yes'" style="min-width: 130px">@lang('layout.Category') </th>
                                                                <th v-show="showWhat('inventory_brand')=='yes'" style="min-width: 130px">@lang('layout.Brand') </th>
                                                                <th v-show="showWhat('item_by_site_in_sale')=='yes'" style="min-width: 130px">@lang('layout.Site') </th>
                                                                <th style="min-width: {{itemFieldWidth()}}px">@lang('layout.ItemName') </th>
                                                                @if(searchByCodeLocation()=="true")
                                                                <th style="min-width: 110px;">@lang('layout.Location')</th>
                                                                @endif
                                                                @if(getSerailNumber() =="true")
                                                                <th style="min-width: 100px">@lang('layout.SerialNum') </th>
                                                                @endif
                                                                <th v-show="showWhat('item_by_site_in_sale')!='yes'" style="min-width: 100px">@lang('layout.SiteName') </th>
                                                                <th v-show="showWhat('sale_description')=='yes'">@lang('layout.Description1') </th>
                                                                <th v-show="showWhat('sale_description2')=='yes'">@lang('layout.Description') :2 </th>
                                                                <th style="min-width: 100px">@lang('layout.Quantity') </th>
                                                                <th style="min-width: 100px">@lang('layout.OnHand') </th>
                                                                <th v-show="showWhat('other_measure')=='yes'" style="min-width: 100px">@lang('layout.OMeasureValue1')
                                                                </th>
                                                                <th v-show="showWhat('other_measure2')=='yes'" style="min-width: 100px">@lang('layout.OMeasureValue2')
                                                                </th>
                                                                <th style="min-width: 100px">@lang('layout.Measure') </th>
                                                                <th v-show="seeCost==true" style="min-width: 100px">@lang('layout.CostInInventory') ({{getHomeCurrency()['code']}})</th>
                                                                <th v-show="seeCost==true" style="min-width: 100px">@lang('layout.CostInInventory')</th>
                                                                <th v-if="oil_sale == true && seeCost==true" style="min-width: 100px">@lang('layout.OilCostInInventory')</th>
                                                                <th v-if="oil_sale == true" style="min-width: 100px">@lang('layout.Density') </th>
                                                                <th v-if="oil_sale == true" style="min-width: 100px">@lang('layout.OilQuantity') </th>
                                                                <th v-if="oil_sale == true" style="min-width: 100px">@lang('layout.Measure') </th>
                                                                @if(getShwoPriceLevel()=="per_item")
                                                                <th style="min-width: 100px">@lang('layout.PriceLevel') </th>
                                                                @endif
                                                                @if(getShwoPriceLevel()=="general_percent_per_item")
                                                                <th style="min-width: 100px">@lang('layout.PriceLevel') </th>
                                                                @endif

                                                                <th v-show="seePrice==true" style="min-width: 100px">@lang('layout.NewPrice') </th>

                                                                @if(getM2()!="")
                                                                @if(getFactorMeasure2()=="true")
                                                                <th style="min-width: 100px">@lang('layout.Measure2') </th>
                                                                @endif
                                                                @endif
                                                                @if(getM3()!="" && getSaleSubMeasure()!="true")
                                                                @if(getFactorMeasure3()=="true")
                                                                <th style="min-width: 100px">@lang('layout.Measure3') </th>
                                                                @endif
                                                                @endif
                                                                @if(getSaleSubMeasure()=="true")
                                                                <th style="min-width: 100px">@lang('layout.EquivalentTo') </th>
                                                                <th v-show="seePrice==true && sub_price==true" style="min-width: 100px">@lang('layout.SubPrice') </th>
                                                                @endif
                                                                @if(getM4()!="")
                                                                @if(getFactorMeasure4()=="true")
                                                                <th v-if="oil_sale == false" style="min-width: 100px">@lang('layout.Measure4') </th>
                                                                @endif
                                                                @endif
                                                                @if(getTaxation()=="true")
                                                                <th style="min-width: 100px">@lang('layout.Tax') </th>
                                                                <th style="min-width: 100px">@lang('layout.Percentage')%</th>
                                                                @endif
                                                                <th v-show="showWhat('sale_discount')=='yes'" style="min-width: 100px">@lang('layout.Discount') </th>
                                                                <th v-show="seePrice==true" style="min-width: 150px">@lang('layout.Total')</th>
                                                                @if(getSubTotal() =="true")
                                                                <th v-show="seePrice==true">@lang('layout.Subtotal')</th>
                                                                @endif
                                                                <th></th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <tr v-for="(item,index) in row_currency.inventories">
                                                                <td>@{{index+1}}</td>
                                                                @if(getTaxation() =="true")
                                                                <td>
                                                                    <div class="mt-checkbox" style="padding-left: 0px;">
                                                                        <label class="mt-checkbox mt-checkbox-outline">
                                                                            <input type="checkbox" :name="'row_tax_stat['+c_index+']['+index+']'" v-model="item.tax" checked />
                                                                            <span></span>
                                                                        </label>
                                                                    </div>
                                                                </td>
                                                                @endif


                                                                <td v-show="showWhat('sale_category')=='yes'">
                                                                    <v-select label="name" v-model="item.item_category" :options="inventory_category" @Click.native="itemCategoryChange(index,c_index)" @input="itemCategoryChange(index,c_index)"></v-select>
                                                                    <input type="hidden" :name="'inventory_category_id['+c_index+']['+index+']'" :value="(!item.item_category)?null:item.item_category.id">
                                                                </td>
                                                                <td v-show="showWhat('inventory_brand')=='yes'">
                                                                    <v-select label="name" v-model="item.item_brand" :options="brandItem" @Click.native="itemBrandChange(index,c_index)" @input="itemBrandChange(index,c_index)"></v-select>
                                                                    <input type="hidden"  :name="'inventory_brand_id['+c_index+']['+index+']'" :value="(!item.item_brand)?null:item.item_brand.id">
                                                                </td>

                                                                <td v-if="showWhat('item_by_site_in_sale')=='yes'">
                                                                    <v-select label="name" v-model="item.inventory_site" :options="inventory_sites" @Click.native="inventorySiteChange(index,c_index)" @input="inventorySiteChange(index,c_index),selectSaleNumber(index,c_index)"></v-select>
                                                                    <input type="hidden"  :name="'inventory_site_id['+c_index+']['+index+']'" :value="(!item.inventory_site)?null:item.inventory_site.id">
                                                                </td>
                                                                <td class="highlight">
                                                                    <!-- @click.native="addNew('inventory',index,c_index)" -->
                                                                    <div class="input-group">
                                                                        <v-select label="name" @input="(editKey)?onItemload(index,c_index):''" @keyup.native="addNew('inventory',index,c_index), editKey = true" @Click.native="addNew('inventory',index,c_index), editKey = true" v-model="item.inventory" :options="temp_items" @search="onItemSearch" @if(TabIndexInItemName() =="true") tabindex="1" @endif ></v-select>
                                                                        <input type="hidden" :name="'inventory_id['+c_index+']['+index+']'" v-validate="''" data-vv-as="@lang('layout.ItemName')" :value="(!item.item)?null:item.item.id">
                                                                        <span class="required">@{{ errors.first('inventory_id['+c_index+']['+index+']') }}</span>
                                                                        <span class="btn btn-success input-group-addon" @click="showInfo(index,c_index)"> <i class="fa fa-info"></i></span>
                                                                        {{-- <input type="hidden" :value="(!item.item)?null:item.item.sale_order_detail_id"  :name="'sale_order_detail_id['+c_index+']['+index+']'" > --}}
                                                                        <input type="hidden" :value="(selected_sale_order)?((!item.item || selected_customer.id !=selected_sale_order.member_id)?null:item.item.sale_order_detail_id):null"  :name="'sale_order_detail_id['+c_index+']['+index+']'" >
                                                                        <input type="hidden" :value="(!item.item)?null:item.item.order_detail_id"  :name="'online_order_detail_id['+c_index+']['+index+']'" >
                                                                    </div>
                                                                </td>
                                                                @if(searchByCodeLocation()=="true")
                                                                <td class="highlight">
                                                                    <v-select label="name" @Click.native="setIndex(index,c_index)" @input="locationItemload(index,c_index)" v-model="item.location" :options="(item.item==null)?[]:item.item.locationList" @search="locationSearch" ></v-select>
                                                                    <input type="hidden" :name="'location['+c_index+']['+index+']'" v-validate="''" data-vv-as="@lang('layout.Location')" :value="(!item.location)?null:item.location.name">
                                                                </td>
                                                                @endif
                                                                @if(getSerailNumber() =="true")
                                                                <td>
                                                                    @{{(!item.item)?null:item.item.number}}
                                                                </td>
                                                                @endif
                                                                <td class="highlight" v-show="showWhat('item_by_site_in_sale')!='yes'">
                                                                    <select v-model="(item.item==null)?null:item.item.site" @click="selectSaleNumber(index,c_index)"  @input="changeCostBylLocation(index,c_index)" class="form-control">
                                                                        <option value="null">@lang('layout.Select')</option>

                                                                        <span v-if="(item.item != null)">
                                                                            <option v-for="site in (item.item==null)?null:item.item.site_list" :value="site">
                                                                                @{{site.site_name}}
                                                                            </option>
                                                                        </span>
                                                                    </select>
                                                                    <input type="hidden"  :name="'inventory_site['+c_index+']['+index+']'" :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.site_id)">
                                                                </td>
                                                                <td v-show="showWhat('sale_description')=='yes'">
                                                                    <input type="text" placeholder="@lang('layout.Description1')"  :name="'inventory_description['+c_index+']['+index+']'" v-model="(item.item==null)?null:item.item.description" class="form-control">
                                                                </td>
                                                                <td v-show="showWhat('sale_description2')=='yes'">
                                                                    <input type="text" placeholder="@lang('layout.Description')"  :name="'description2['+c_index+']['+index+']'" v-model="(item.item==null)?null:item.item.description2" class="form-control">
                                                                </td>
                                                                <td>
                                                                    <input type="number" :name="'inventory_quantity['+c_index+']['+index+']'" oninput = "autowidths(event)" v-validate="(item.item==null)?'':'required'" data-vv-as="@lang('layout.Quantity')" v-model.number="(item.item==null)?null:item.item.quantity" class="form-control input-style input-number chan_length" @input="change_oil_qty(index,c_index), setNewRate('inventory',index,c_index)" placeholder="@lang('layout.Quantity')">
                                                                    <span class="required">@{{ errors.first('inventory_quantity['+c_index+']['+index+']') }}</span>
                                                                    <span v-show=" myRound((item.item==null)?0:saleItemQuantity(item.item,item.item.quantity)) < 0" class="required">@lang('layout.LowOnHand')</span>
                                                                </td>

                                                                <td>
                                                                    @{{myRound((item.item==null)?null:saleItemQuantity(item.item,item.item.quantity))}}

                                                                </td>
                                                                <td v-show="showWhat('other_measure')=='yes'">
                                                                    <div class="input-group">
                                                                        <input type="number"  :name="'other_measure_amount['+c_index+']['+index+']'" class="form-control input-style input-number chan_length" oninput = "autowidths(event)" placeholder="@lang('layout.OMeasureValue1')" @input="change_per_qty(index,c_index)" v-model.number="(item.item==null)?null:item.item.other_measure">
                                                                        <input type="hidden"  :name="'per_qty['+c_index+']['+index+']'" :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.per_qty)">
                                                                        @if(getCalQuantityOfOtherMeasure() == 'avgMethod')
                                                                        <span class="input-group-addon" v-if="(item.item==null)?null:((item.item.site==null)?null:item.item.site.per_qty) > 0">
                                                                            @{{myRound((item.item==null)?null:((item.item.site==null)?null:(item.item.site.OnHand / item.item.site.per_qty)))}}
                                                                        </span>
                                                                        @elseif(getCalQuantityOfOtherMeasure() == 'simpleMethod')
                                                                        <span class="input-group-addon" v-if="(item.item==null)?null:((item.item.site==null)?null:true)">
                                                                            @{{myRound((item.item==null)?null:((item.item.site==null)?null:item.item.site.other_measure))}}
                                                                        </span>
                                                                        @else
                                                                        <span class="input-group-addon">
                                                                            @{{(item.item==null)?null:item.item.o_measure_v}}
                                                                        </span>
                                                                        @endif
                                                                    </div>
                                                                </td>
                                                                <td v-show="showWhat('other_measure2')=='yes'">
                                                                    <div class="input-group">
                                                                        <input type="number"  :name="'other_measure_amount2['+c_index+']['+index+']'" class="form-control input-style input-number chan_length" oninput = "autowidths(event)" placeholder="@lang('layout.OMeasureValue2')" v-model.number="(item.item==null)?null:item.item.other_measure2">
                                                                        <input type="hidden"  :name="'per_qty2['+c_index+']['+index+']'" :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.per_qty2)">
                                                                        @if(getCalQuantityOfOtherMeasure() == 'avgMethod')
                                                                        <span class="input-group-addon" v-if="(item.item==null)?null:((item.item.site==null)?null:item.item.site.per_qty2) > 0">
                                                                            @{{myRound((item.item==null)?null:((item.item.site==null)?null:(item.item.site.OnHand / item.item.site.per_qty2)))}}
                                                                        </span>
                                                                        @elseif(getCalQuantityOfOtherMeasure() == 'simpleMethod')
                                                                        <span class="input-group-addon" v-if="(item.item==null)?null:((item.item.site==null)?null:true)">
                                                                            @{{myRound((item.item==null)?null:((item.item.site==null)?null:item.item.site.other_measure2))}}
                                                                        </span>
                                                                        @else
                                                                        <span class="input-group-addon">
                                                                            @{{(item.item==null)?null:item.item.o_measure_v1}}
                                                                        </span>
                                                                        @endif
                                                                    </div>
                                                                </td>
                                                                <td class="highlight">
                                                                    <select v-model="(item.item == null)?null:item.item.measure" class="form-control" @change="measureChange(index,c_index)" >
                                                                        <option value="null">@lang('layout.Select')</option>
                                                                        <span v-if="(item.item ==null)?false:true">
                                                                            <option v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure">
                                                                                @{{measure.measure_name}}
                                                                            </option>
                                                                        </span>

                                                                    </select>

                                                                    <input type="hidden"  :name="'inventory_measure['+c_index+']['+index+']'" :value="(item.item==null)?null:item.item.measure.measure_id">
                                                                </td>

                                                                <td v-show="seeCost==true">
                                                                    @{{(item.item==null)?null:myRound((item.item.LasCost * item.item.measure.measure_unit / item.item.measure_unit))}}
                                                                </td>
                                                                @if(systemConfig()[30] == 1)
                                                                <td v-show="seeCost==true">
                                                                    @{{(item.item==null)? 0:myRound((item.item.LasCost * item.item.measure.measure_unit / item.item.measure_unit) *row_currency.currency.static_rate / row_currency.currency.rate)}}
                                                                    @{{row_currency.currency.symbol}}
                                                                </td>
                                                                @else 
                                                                <td v-show="seeCost==true">
                                                                    @{{(item.item==null)? 0:myRound((item.item.LasCost * item.item.measure.measure_unit / item.item.measure_unit) *row_currency.currency.rate)}}
                                                                    @{{row_currency.currency.symbol}}
                                                                </td>
                                                                @endif  
                                                                @if(systemConfig()[30] == 1)
                                                                <td v-if="oil_sale == true && seeCost==true" >
                                                                    @{{(item.item==null)?null:((item.item.density)?myRound(((item.item.LasCost * item.item.measure.measure_unit / item.item.measure_unit) * item.item.density) *  row_currency.currency.static_rate /  row_currency.currency.rate):null)}}
                                                                </td>
                                                                @else 
                                                                <td v-if="oil_sale == true && seeCost==true" >
                                                                    @{{(item.item==null)?null:((item.item.density)?myRound(((item.item.LasCost * item.item.measure.measure_unit / item.item.measure_unit) * item.item.density) * row_currency.currency.rate):null)}}
                                                                </td>
                                                                @endif

                                                                <td v-if="oil_sale == true">
                                                                    <input type="number"  :name="'density['+c_index+']['+index+']'" class="form-control input-style input-number chan_length" placeholder="@lang('layout.Density')" @input="change_oil_qty(index,c_index)" v-model.number="(item.item==null)?null:item.item.density" oninput = "autowidths(event)" />
                                                                </td>
                                                                <td v-if="oil_sale == true">
                                                                    <input type="number"  :name="'oil_qty['+c_index+']['+index+']'" class="form-control input-style input-number chan_length" placeholder="@lang('layout.OilQuantity')" @input="change_qty_by_oil(index,c_index)" v-model.number="(item.item==null)?null:item.item.oil_qty" oninput = "autowidths(event)" />
                                                                </td>
                                                                <td v-if="oil_sale == true">
                                                                    <select  :name="'measure3['+c_index+']['+index+']'" class="form-control" v-model="(item.item==null)?null:item.item.measure3.measure_id">
                                                                        <option value="null">@lang('layout.Select')</option>
                                                                        <span v-if="(item.item ==null)?false:true">
                                                                            <option v-for="measure in (item.item==null)?null:item.item.measureListAll" :value="measure.measure_id">
                                                                                @{{measure.measure_name}}
                                                                            </option>
                                                                        </span>
                                                                    </select>
                                                                </td>

                                                                @if(getShwoPriceLevel()=="per_item")
                                                                <td>
                                                                    <select v-model="(item.item == null)?null:item.price_level" class="form-control" @change="change_sale_rate_by_price_level(index,c_index)">
                                                                        <option value="null">@lang('layout.Select')</option>
                                                                        <span v-if="(item.item ==null)?false:true">
                                                                            <option v-for="price_level in (item.item==null)?null:item.item.item_price_level" :value="price_level">
                                                                                @{{price_level.name}}
                                                                            </option>
                                                                        </span>
                                                                    </select>

                                                                    <input type="hidden"  :name="'item_price_level_id['+c_index+']['+index+']'" :value="(item.price_level == null)?null:item.price_level.id">
                                                                </td>
                                                                @endif 
                                                                @if(getShwoPriceLevel()=="general_percent_per_item")
                                                                <td>
                                                                    <select v-model="(item.item == null)?null:item.price_level" class="form-control" @change="change_sale_rate_by_price_level_general_per_item(index,c_index)">
                                                                        <option value="null">@lang('layout.Select')</option>
                                                                        <span v-if="(item.item ==null)?false:true">
                                                                            <option v-for="price_level in (item.item==null)?null:priceLevelGeneral" :value="price_level">
                                                                                @{{price_level.name}}
                                                                            </option>
                                                                        </span>
                                                                    </select> 
                                                                    <input type="hidden"  :name="'item_price_level_id['+c_index+']['+index+']'" :value="(item.price_level == null)?null:item.price_level.id">
                                                                </td>
                                                                @endif  
                                                                <td v-show="seePrice==true">
                                                                    <vue-numeric v-if="item.item"
                                                                        class="form-control chan_length"
                                                                        oninput = "autowidths(event)"
                                                                        v-model="item.item.cost"
                                                                        :max="99999999999999"
                                                                        currency=""
                                                                        :precision="((sub_price==true || p_total)?7:precision())"
                                                                        @input="setNewRate('inventory',index,c_index)">
                                                                    </vue-numeric>
                                                                    <input type="hidden" :name="'inventory_price['+c_index+']['+index+']'"   v-bind:value="(item.item==null)?null:saleNewRate(item.item,row_currency.currency.rate, ((sub_price==true || p_total)?7:precision()), row_currency.currency.static_rate)"
                                                                    ref="in" data-vv-as="@lang('layout.Price')" placeholder="@lang('layout.Price')">
                                                                    <span class="required">@{{ errors.first('inventory_price['+c_index+']['+index+']') }}</span> 
                                                                    <span v-show="((item.item==null)?null:checkCheap(item.item,row_currency.currency.rate,row_currency.currency.static_rate))==true" class="required">@lang('layout.SalesToTheDetriment')</span>
                                                                </td>

                                                                @if(getM2()!="" && getSaleSubMeasure()!="true")
                                                                @if(getFactorMeasure2()=="true")
                                                                <td> 
                                                                    <div class="input-group">
                                                                        <select  :name="'measure1['+c_index+']['+index+']'" class="form-control" v-model="(item.item==null)?null:item.item.measure1.measure_id">
                                                                            <option value="null">@lang('layout.Select')</option>
                                                                            <span v-if="(item.item ==null)?false:true">
                                                                                <option v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure.measure_id">
                                                                                    @{{measure.measure_name}}
                                                                                </option>
                                                                            </span>
                                                                        </select>
                                                                        @if(getSaleAmountSecondMeasure()=="true")
                                                                        <span class="input-group-addon">
                                                                            @{{myRound((item.item==null)?null:secoundMeasurQuantity(item.item,item.item.quantity))}}
                                                                        </span>
                                                                        @endif
                                                                    </div>
                                                                </td>
                                                                @endif
                                                                @endif
                                                                @if(getM3()!="")
                                                                @if(getFactorMeasure3()=="true")
                                                                <td>
                                                                    <select  :name="'measure2['+c_index+']['+index+']'" class="form-control" @change="measure2Change(index,c_index)" v-model="(item.item==null)?null:item.item.measure2.measure_id">
                                                                        <option value="null">@lang('layout.Select')</option>
                                                                        <span v-if="(item.item ==null)?false:true">
                                                                            <option v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure.measure_id">
                                                                                @{{measure.measure_name}}
                                                                            </option>
                                                                        </span>
                                                                    </select>
                                                                </td>
                                                                @endif
                                                                @endif
                                                                @if(getSaleSubMeasure() =="true")
                                                                <td>
                                                                    @{{myRound((item.item==null)?null:subMQuantity(item.item,item.item.quantity))}}
                                                                </td>
                                                                <td v-show="seePrice==true && sub_price==true">
                                                                    <div class="input-group">
                                                                        <input type="number" placeholder="@lang('layout.SubPrice')" v-model="(item.item==null)?null:item.sub_price" @input="setNewRateTotal(index,c_index)" oninput = "autowidths(event)" class="form-control chan_length">
                                                                        <span class="input-group-addon">
                                                                            @{{row_currency.currency.symbol}}
                                                                        </span>
                                                                    </div>
                                                                </td>
                                                                @endif
                                                                @if(getM4()!="")
                                                                @if(getFactorMeasure4()=="true")
                                                                <td v-if="oil_sale == false">
                                                                    <select  :name="'measure3['+c_index+']['+index+']'" class="form-control" v-model="(item.item==null)?null:item.item.measure3.measure_id">
                                                                        <option value="null">@lang('layout.Select')</option>
                                                                        <span v-if="(item.item ==null)?false:true">
                                                                            <option v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure.measure_id">
                                                                                @{{measure.measure_name}}
                                                                            </option>
                                                                        </span>
                                                                    </select>
                                                                </td>
                                                                @endif
                                                                @endif
                                                                @if(getTaxation()=="true")
                                                                <td>
                                                                    <span v-show="!item.tax">
                                                                        <v-select v-model="item.selected_taxation" label="name" :options="taxation">
                                                                        </v-select>
                                                                        <input type="hidden" :name="'row_taxation_id['+c_index+']['+index+']'" :value="!item.selected_taxation?null:item.selected_taxation.id" />
                                                                        <input type="hidden" :name="'row_taxation_vendor_id['+c_index+']['+index+']'" :value="!item.selected_taxation?null:item.selected_taxation.member_id" />
                                                                        <input type="hidden" :name="'row_tax_amount['+c_index+']['+index+']'" :value="!item.selected_taxation?null:item.row_tax_amount" />
                                                                    </span>
                                                                </td>
                                                                <td>
                                                                    <span v-show="!item.tax">
                                                                        <input type="number" class="form-control chan_length" :name="'row_percent_tax['+c_index+']['+index+']'" oninput = "autowidths(event)" v-model="!item.selected_taxation?null:item.selected_taxation.percent" />
                                                                    </span>
                                                                </td>
                                                                @endif
                                                                <td v-show="showWhat('sale_discount')=='yes'">
                                                                    <div class="input-group">
                                                                        <input type="number"  :name="'inventory_discount['+c_index+']['+index+']'" placeholder="@lang('layout.Discount')" v-model.number="(item.item==null)?null:item.item.discount" oninput = "autowidths(event)" class="form-control chan_length">
                                                                        <span class="input-group-addon" v-if="discountIsAmount">
                                                                            @{{row_currency.currency.symbol}}
                                                                        </span>
                                                                        <span class="input-group-addon" v-if="!discountIsAmount">
                                                                            %
                                                                        </span>

                                                                    </div>

                                                                </td>
                                                                <td v-if="oil_sale == false" v-show="seePrice==true">
                                                                    <input type="number" :value="(item.item==null)? 0:getItemTotal(item.item,row_currency.currency.rate,discountIsAmount,item.item.discount,row_currency.currency.hq_rate,per_qty_check, null, row_currency.currency.static_rate).result" :ref="`total${c_index}`" @input="setQuantityByTotal(index,c_index)"  class="form-control">
                                                                    {{-- @{{(item.item==null)? 0:getItemTotal(item.item,row_currency.currency.rate,discountIsAmount,item.item.discount,row_currency.currency.hq_rate,per_qty_check).result}} --}}
                                                                    {{-- @{{row_currency.currency.symbol}} --}}
                                                                </td>
                                                                <td v-if="oil_sale == true" v-show="seePrice==true">
                                                                    <input type="number" :value="(item.item==null)? 0:getItemTotalOil(item.item,row_currency.currency.rate,discountIsAmount,item.item.discount,row_currency.currency.hq_rate, null, row_currency.currency.static_rate).result" :ref="`total${c_index}`" @input="setQuantityByTotal(index,c_index)"  class="form-control">
                                                                    {{-- @{{(item.item==null)? 0:getItemTotalOil(item.item,row_currency.currency.rate,discountIsAmount,item.item.discount,row_currency.currency.hq_rate).result}} --}}
                                                                    {{-- @{{row_currency.currency.symbol}} --}}
                                                                </td>
                                                                @if(getSubTotal() =="true")
                                                                <td>
                                                                    <div class="mt-checkbox" style="padding-left: 0px;">
                                                                        <label class="mt-checkbox mt-checkbox-outline">
                                                                            <input type="checkbox" :name="'row_sub_total_stat['+c_index+']['+index+']'" v-model="item.sub_total" />
                                                                            <span></span>
                                                                        </label>
                                                                    </div>
                                                                </td>
                                                                @endif

                                                                <td>
                                                                    <span v-on:click="deleteItem('inventory',index)">
                                                                        <i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                                                </td>
                                                            </tr>
                                                            <tr style="background-color: #ffffff;">
                                                                <td></td>
                                                                <td></td>
                                                                <td>
                                                                    <center>
                                                                        <button type="button" @click="addNew('inventory',1000,c_index)" class="btn btn-success"><i class="fa fa-plus"></i></button>
                                                                    </center>
                                                                </td>
                                                                <td></td>
                                                                <td></td>
                                                                <td></td>
                                                                <td></td>
                                                                <td></td>
                                                                <td></td>
                                                            </tr>
                                                        </tbody>
                                                    </table>

                                                    <hr>
                                                    
                                                    @endif

                                                    @if(systemConfig()[26] == 1)
                                                    <!-- begin service -->
                                                    <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                                                        <thead>
                                                            <tr>
                                                                <th class="text-center" style="min-width: 8px;"> #</th>
                                                                <th class="text-center" style="min-width: 160px;">@lang('layout.ServiceName')</th>
                                                                <th v-show="showWhat('sale_description')=='yes'">@lang('layout.Description') </th>
                                                                <th v-show="showWhat('sale_description2')=='yes'">@lang('layout.Description') :2 </th>
                                                                <th class="text-center" style="min-width: 160px;">@lang('layout.Quantity')</th>
                                                                <th class="text-center" style="min-width: 160px;">@lang('layout.Measure')</th>
                                                                <th class="text-center" style="min-width: 160px;">@lang('layout.Price')</th>
                                                                <th class="text-center" style="min-width: 120px;">@lang('layout.Total')</th>
                                                                <th></th>

                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <tr v-for="(service,index) in row_currency.services">
                                                                <td>@{{index+1}}</td>
                                                                <td class="highlight">
                                                                    <v-select label="name" v-model="service.item" :options="(service.items)" @click.native="addNew('service',index,c_index)" @input="checkExistingService(index,c_index),service_rate(index,c_index)">

                                                                    </v-select>
                                                                    <input type="hidden"  :name="'service_id['+c_index+']['+index+']'" :value="(service.item==null)?null:service.item.id">
                                                                    <input type="hidden"  :name="'ser_online_order_detail_id['+c_index+']['+index+']'" :value="(service.item==null)?null:service.item.order_detail_id">
                                                                    {{-- <input type="hidden"  :name="'sale_order_service_id['+c_index+']['+index+']'" :value="(service.item==null)?null:service.item.sale_order_service_id"> --}}
                                                                    <input type="hidden"  :name="'sale_order_service_id['+c_index+']['+index+']'" :value="(selected_sale_order)?((service.item==null || selected_customer.id !=selected_sale_order.member_id)?null:service.item.sale_order_service_id):null">
                                                                </td>
                                                                <td v-show="showWhat('sale_description')=='yes'">
                                                                    <input type="text" placeholder="@lang('layout.Description')"  :name="'service_description['+c_index+']['+index+']'" v-model="(service==null)?null:service.description" class="form-control">
                                                                </td>
                                                                <td v-show="showWhat('sale_description2')=='yes'">
                                                                    <input type="text" placeholder="@lang('layout.Description')"  :name="'service_description2['+c_index+']['+index+']'" v-model="(service==null)?null:service.description2" class="form-control">
                                                                </td>
                                                                <td>
                                                                    <input class="form-control" type="number" :name="'service_quantity['+c_index+']['+index+']'" v-model.number="(!service)?null:service.quantity" placeholder="@lang('layout.Quantity')">
                                                                </td>
                                                                <td class="highlight">
                                                                    <select v-model="(service.item == null)?null:service.item.measure" class="form-control" @change="measureChangeservice(index,c_index)">
                                                                        <option value="null">@lang('layout.Select')</option>
                                                                        <span v-if="(service.item ==null)?false:true">
                                                                            <option v-for="measure in (service.item==null)?null:service.item.measure_list" :value="measure">
                                                                                @{{measure.measure_name}}
                                                                            </option>
                                                                        </span>

                                                                    </select>

                                                                    <input type="hidden"  :name="'service_measure['+c_index+']['+index+']'" :value="(service.item==null)?null:service.item.measure.measure_id">
                                                                </td>
                                                                <td>
                                                                    <div class="input-group">
                                                                        <input type="number"  :name="'service_price['+c_index+']['+index+']'" placeholder="@lang('layout.Price')" :value="(service==null)?null:saleNewRate(service,row_currency.currency.rate,null,row_currency.currency.static_rate )"  :ref="`ser${c_index}`" @input="setNewRate('service',index,c_index)" class="form-control">

                                                                        <span class="input-group-addon">
                                                                            @{{row_currency.currency.symbol}}
                                                                        </span>
                                                                    </div>

                                                                </td>
                                                                @if(systemConfig()[30] == 1)
                                                                <td>
                                                                    @{{ myRound(service.new_rate * service.quantity * row_currency.currency.static_rate / row_currency.currency.rate) }}
                                                                    @{{row_currency.currency.symbol}}
                                                                </td>
                                                                @else 
                                                                <td>
                                                                    @{{ myRound(service.new_rate * service.quantity * row_currency.currency.rate) }}
                                                                    @{{row_currency.currency.symbol}}
                                                                </td>
                                                                @endif

                                                                <td>
                                                                    <span v-on:click="deleteItem('service',index)"><i class="paddint-both glyphicon glyphicon-trash"></i></span>
                                                                </td>
                                                            </tr>

                                                        </tbody>
                                                    </table>
                                                    <!-- end service -->
                                                    @endif
                                                    <hr>
                                                    <!-- begin Receive -->
                                                    @permission('receive-create')
                                                    <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                                                        <thead>
                                                            <tr>
                                                                <th class="text-center" style="min-width: 8px;"> #</th>
                                                                {{-- <th class="text-center" style="min-width: 70px;">@lang('layout.Number')</th> --}}
                                                                <th class="text-center" style="min-width: 160px;">@lang('layout.SelectBank')</th>
                                                                <th class="text-center" style="min-width: 100px;"> @lang('layout.Amount')</th>
                                                                <th class="text-center" style="min-width: 120px;"> @lang('layout.Rate')</th>
                                                                <th class="text-center" style="min-width: 80px;">@lang('layout.Currency')</th>
                                                                <th class="text-center" style="min-width: 80px;"> @lang('layout.Amount')</th>
                                                                <th class="text-center" style="min-width: 120px;">@lang('layout.Total')</th>

                                                                <th class="text-center" style="min-width: 120px;">@lang('layout.Description')</th>

                                                                <th></th>

                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <tr v-for="(payment,index) in row_currency.payments">
                                                                <td>@{{index+1}}</td>
                                                                {{-- <td>
                                                                    <span>@{{(payment.item==null)?null:(payment.item.r_number)+index}}</span>
                                                                    <input type="hidden"  :name="'receive_number['+c_index+']['+index+']'" :value="(payment.item==null)?null:(payment.item.r_number)+index" />
                                                                </td> --}}

                                                                <td class="highlight">
                                                                    <v-select label="name" v-model="payment.item" :options="(payment.items)" @click.native="addNew('payment',index,c_index)" @input="checkExistingPayment(index,c_index)">
                                                                    </v-select>
                                                                    <input type="hidden" v-if="payment.item !=null"  :name="'payment_id['+c_index+']['+index+']'" :value="(payment.item==null)?null:payment.item.id">
                                                                </td>

                                                                <td> 
                                                                    <span v-if="payment.item !=null">
                                                                        @{{myRound(Number((payment.item==null)?null:payment.item.balance)+Number((payment.item==null)?null:payment.item.amount))}}
                                                                    </span>
                                                                </td> 
                                                                <td>
                                                                    <input v-bind:disabled="(payment.item==null)?false:(payment.item.code =='{{getHomeCurrency()['code']}}')" type="number" v-model.number="(payment.item==null)?null:payment.item.rate " class="form-control" placeholder="@lang('layout.Rate')" />
                                                                    <input v-if="payment.item !=null" type="hidden"  :name="'payment_rate['+c_index+']['+index+']'" v-bind:value="payment.item.rate">
                                                                </td>

                                                                <td>
                                                                    <input type="text"  :name="'payment_currency['+c_index+']['+index+']'" class="form-control" v-model="(payment.item==null)?null:payment.item.code" placeholder="@lang('layout.Currency')" disabled reqiured />

                                                                    <input v-if="payment.item !==null" type="hidden"  :name="'payment_currency['+c_index+']['+index+']'" v-bind:value="payment.item.code" />
                                                                </td>

                                                                <td>
                                                                    <vue-numeric v-if="payment.item"
                                                                        class="form-control"
                                                                        v-model="payment.item.amount"
                                                                        :max="99999999999999"
                                                                        :currency="payment.item.code"
                                                                        :precision="precision()"
                                                                        >
                                                                    </vue-numeric>
                                                                    <input v-if="payment.item !=null" type="hidden"  :name="'payment_amount['+c_index+']['+index+']'" v-bind:value="payment.item.amount">
                                                                </td>
                                                                <td>
                                                                    @{{ (payment.item==null)?null:totalPayment(payment.item,row_currency.currency.rate,row_currency.currency.hq_rate,row_currency.currency.static_rate).result }}
                                                                    @{{row_currency.currency.symbol}}
                                                                </td>

                                                                <td>
                                                                    <textarea class="form-control"  :name="'receive_description['+c_index+']['+index+']'" rows="2" placeholder="@lang('layout.Description')">@{{(payment.item==null)?null:payment.item.description}}</textarea>
                                                                </td>


                                                                <td>
                                                                    <span v-on:click="deleteItem('payment',index)">
                                                                        <i class="paddint-both glyphicon glyphicon-trash"></i>
                                                                    </span>
                                                                </td>
                                                            </tr>
                                                        </tbody>

                                                    </table>
                                                    @endpermission
                                                    <!-- end Receive -->
                                                    <hr>


                                                    <!--Begin Transfer Rent-->
                                                    @if(getTransferRent()=="true")
                                                    <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                                                        <thead>
                                                            <tr>
                                                                <th colspan="10" style="min-width: 100px;">@lang('layout.TransferRent')</th>
                                                            </tr>
                                                            <tr>
                                                                <th class="text-center" style="min-width: 160px;">@lang('layout.Type')</th>
                                                                <th class="text-center" style="min-width: 160px;">@lang('layout.Transmitter')</th>
                                                                <th class="text-center" style="min-width: 160px;" v-show="row_currency.transfer_rent_type=='cash'">@lang('layout.SelectBank')</th>
                                                                <th class="text-center" style="min-width: 120px;" v-show="row_currency.transfer_rent_type=='cash'"> @lang('layout.Rate')</th>
                                                                <th class="text-center" style="min-width: 80px;" v-show="row_currency.transfer_rent_type=='cash'">@lang('layout.Currency')</th>
                                                                <th class="text-center" style="min-width: 80px;"> @lang('layout.Amount')</th>
                                                                <th class="text-center" style="min-width: 120px;">@lang('layout.Description')</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <tr>
                                                                <td>
                                                                    <select class="form-control" :name="'transfer_rent_type['+c_index+']'" v-model="row_currency.transfer_rent_type">
                                                                        <option value="cash">@lang('type.cash')</option>
                                                                        <option value="credit">@lang('type.credit')</option>
                                                                    </select>
                                                                </td>
                                                                <td>
                                                                    <v-select label="name"  @search="VendorSearch" :options="transfer_rent_vendor" v-model="row_currency.transfer_rent_vendor_selected"></v-select>
                                                                    <input type="hidden" :name="'transfer_rent_vendor['+c_index+']'" :value="!row_currency.transfer_rent_vendor_selected?null:row_currency.transfer_rent_vendor_selected.id">
                                                                </td>

                                                                <td class="highlight" v-show="row_currency.transfer_rent_type=='cash'">
                                                                    <v-select label="name" v-model="row_currency.transfer_rent_bank_selected" :options="banks">

                                                                    </v-select>
                                                                    <input type="hidden" v-if="row_currency.transfer_rent_bank_selected !=null" :name="'transfer_rent_bank['+c_index+']'" :value="(row_currency.transfer_rent_bank_selected==null)?null:row_currency.transfer_rent_bank_selected.id">
                                                                </td>
                                                                <td v-show="row_currency.transfer_rent_type=='cash'">
                                                                    <input v-bind:disabled="(row_currency.transfer_rent_bank_selected==null)?false:(row_currency.transfer_rent_bank_selected.code =='{{getHomeCurrency()['code']}}')" type="number" v-model.number="(row_currency.transfer_rent_bank_selected==null)?null:row_currency.transfer_rent_bank_selected.rate " class="form-control" placeholder="@lang('layout.Rate')" />
                                                                    <input v-if="row_currency.transfer_rent_bank_selected !=null" type="hidden" :name="'transfer_rent_rate['+c_index+']'" v-bind:value="row_currency.transfer_rent_bank_selected.rate">
                                                                </td>
                                                                <td v-show="row_currency.transfer_rent_type=='cash'">
                                                                    <input type="text" :name="'transferRent_currency['+c_index+']'" class="form-control" v-model="(row_currency.transfer_rent_bank_selected==null)?null:row_currency.transfer_rent_bank_selected.code" placeholder="@lang('layout.Currency')" disabled reqiured />

                                                                    <input v-if="row_currency.transfer_rent_bank_selected !==null" type="hidden" :name="'transfer_rent_currency['+c_index+']'" v-bind:value="row_currency.transfer_rent_bank_selected.code" />
                                                                </td>

                                                                <td>
                                                                    <div class="input-group">
                                                                        <input  type="number" :name="'transfer_rent_amount['+c_index+']'" class="form-control" placeholder="@lang('layout.PayAmount')">

                                                                        <span  v-show="row_currency.transfer_rent_type=='cash'" class="input-group-addon">@{{(row_currency.transfer_rent_bank_selected==null)?null:row_currency.transfer_rent_bank_selected.code}}</span>
                                                                        <span  v-show="row_currency.transfer_rent_type=='credit'" class="input-group-addon">@{{(row_currency.currency==null)?null:row_currency.currency.code}}</span>
                                                                        
                                                                    </div>
                                                                </td>

                                                                <td>
                                                                    <textarea class="form-control" :name="'transfer_rent_description['+c_index+']'" rows="2" placeholder="@lang('layout.Description')"></textarea>
                                                                </td>
                                                            </tr>
                                                        </tbody>

                                                    </table>
                                                    <hr>
                                                    @endif
                                                    <!--End Transfer Rent-->


                                                </div>

                                                <!--Begin Draiver-->

                                                @if(getDriverInfo()=="true")
                                                <br>
                                                <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                                                    <thead>
                                                        <tr>
                                                            <th class="text-center" style="min-width: 8px;"> @lang('layout.DriverInfo') </th>

                                                        </tr>
                                                    </thead>
                                                </table>

                                                <div class="row">
                                                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                                        <!-- begin inputs -->
                                                        <div class="row">
                                                            <div class="col-md-3">
                                                                <div class="col-md-12">
                                                                    <label class="control-label ">@lang('layout.TransferCode')</label>
                                                                    <input type="text"  :name="'transfer_code['+c_index+']'" v-model="row_currency.driver_data.other_measure" class="form-control">
                                                                </div>
                                                            </div>
                                                            <div class="col-md-3">
                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.Transporter_name')</label>
                                                                    <input type="text"  :name="'transporter_name['+c_index+']'" v-model="row_currency.driver_data.driver_name" class="form-control">
                                                                </div>
                                                            </div>
                                                            <div class="col-md-3">
                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.Transporter_phone')</label>
                                                                    <input type="text"  :name="'transporter_phone['+c_index+']'" class="form-control">
                                                                </div>
                                                            </div>
                                                            <div class="col-md-3">
                                                                <div class="col-md-12">
                                                                    <label class="control-label ">@lang('layout.PlaceOfWeight')</label>
                                                                    <input type="text"  :name="'palce_of_weight['+c_index+']'" class="form-control">
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="row">
                                                            <div class="col-md-3">
                                                                <div class="col-md-12">
                                                                    <label class="control-label ">@lang('layout.SourcePlace')</label>
                                                                    <input type="text"  :name="'source_place['+c_index+']'" class="form-control">
                                                                </div>
                                                            </div>
                                                            <div class="col-md-3">
                                                                <div class="col-md-12">
                                                                    <label class="control-label ">@lang('layout.PlateNumber')</label>
                                                                    <input type="text"  :name="'plate_number['+c_index+']'" v-model="row_currency.driver_data.vehicle_name"  class="form-control">
                                                                </div>
                                                            </div>
                                                            <div class="col-md-3">
                                                                <div class="col-md-12">
                                                                    <label class="control-label ">@lang('layout.WayBillNumber')</label>
                                                                    <input type="text"  :name="'way_bill_number['+c_index+']'" v-model="row_currency.driver_data.wagon_number"  class="form-control">
                                                                </div>
                                                            </div>
                                                            <div class="col-md-3">
                                                                <div class="col-md-12">
                                                                    <label class="control-label ">@lang('layout.TotalWeight')</label>
                                                                    <input type="text"  :name="'total_weight['+c_index+']'" v-model="row_currency.driver_data.other_measure2"  class="form-control">
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="row">
                                                            <div class="col-md-3">
                                                                <div class="col-md-12">
                                                                    <label class="control-label ">@lang('layout.EmptyCarWeight')</label>
                                                                    <input type="text"  :name="'empty_car_weight['+c_index+']'" class="form-control">
                                                                </div>
                                                            </div>
                                                            <div class="col-md-3">
                                                                <div class="col-md-12">
                                                                    <label class="control-label ">@lang('layout.TotalBori')</label>
                                                                    <input type="text"  :name="'total_bori['+c_index+']'" v-model="row_currency.driver_data.description2"  class="form-control">
                                                                </div>
                                                            </div>
                                                            <div class="col-md-3">
                                                                <div class="col-md-12">
                                                                    <label class="control-label ">@lang('layout.Rent')</label>
                                                                    <input type="number"  :name="'rent['+c_index+']'" v-model="row_currency.driver_data.cost"  class="form-control">
                                                                </div>
                                                            </div>
                                                            <div class="col-md-3">
                                                                <div class="col-md-12">
                                                                    <label class="control-label ">@lang('layout.Description')</label>
                                                                    <textarea  :name="'transfer_description['+c_index+']'" class="form-control" v-text="(row_currency.driver_data)?row_currency.driver_data.description:null" ></textarea>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>

                                                </div>
                                                @endif
                                                <!--End Draiver-->
                                                <br/>
                                            </div>
                                        </div>


                                        @if(getInvoiceTotal() == 'true')
                                        <!-- begin total -->
                                        {{-- <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                            <div class="dashboard-stat2 " v-show="seePrice== true">
                                                <table class="dashboard-tabel" width="100%">
                                                    <tr>
                                                        <td>
                                                            <small>@lang('layout.GrandTotal'):</small>
                                                        </td>
                                                        <td class="text-right">
                                                            <span class="text-right" data-counter="counterup" data-value="7800">
                                                                @{{ subtotal.toFixed(precision())}}
                                                            </span>
                                                            <small class="font-green-sharp">
                                                                @{{selected_currency.symbol}}
                                                            </small>
                                                        </td>
                                                        <td>
                                                            <small>@lang('layout.Payment'):</small>
                                                        </td>
                                                        <td class="text-right">
                                                            <small class="font-green-sharp">
                                                                <span class="text-right" data-counter="counterup" data-value="7800">
                                                                    @{{ payeds.toFixed(precision())}}
                                                                </span>
                                                                <small class="font-green-sharp">
                                                                    @{{selected_currency.symbol}}
                                                                </small>
                                                            </small>
                                                        </td>
                                                        <td>
                                                            <small>@lang('layout.Discount'): (@{{
                                                                        Number.parseFloat(discount).toFixed(precision())
                                                                        }}%)
                                                            </small>
                                                        </td>
                                                        <td class="text-right">
                                                            <span class="text-right" data-counter="counterup" data-value="7800">
                                                                @{{ format_number(Number.parseFloat(discount*(newSubTotal - newSubDiscountFiledRow)/100)+Number.parseFloat(discountFiledRow)) }}
                                                            </span>
                                                            <small class="font-green-sharp">
                                                                @{{selected_currency.symbol}}
                                                            </small>
                                                        </td>
                                                        <td>
                                                            <small>@lang('layout.Total') :</small>
                                                        </td>
                                                        <td class="text-right"><span data-counter="counterup" data-value="7800">
                                                                @{{ format_number(Number.parseFloat(((subtotal - (discount*(newSubTotal - newSubDiscountFiledRow)/100) - discountFiledRow) - saleTaxation)-payeds))}}
                                                            </span>
                                                            <small class="font-green-sharp">
                                                                @{{selected_currency.symbol}}
                                                            </small>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </div>
                                        </div> --}}
                                        <!-- end total -->
                                        @endif
                                        <div class="row">
                                            @if(getHesabSabeqa() =='true')
                                            <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                <table class="table table-striped table-bordered table-advance ">
                                                    <tr>
                                                        <td class="t_body">
                                                            <div>
                                                                <label class="mt-checkbox mt-checkbox-outline">@lang('layout.HesabSabiqa')
                                                                    <input type="checkbox" name="hesab_sabeqa" value="ok" checked="checked">
                                                                    <span></span>
                                                                </label>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </div>
                                            @endif
                                            <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                <table class="table table-striped table-bordered table-advance ">
                                                    <tr>
                                                        <td class="t_body">
                                                            <div>
                                                                <label class="mt-checkbox mt-checkbox-outline">@lang('layout.NotShowingDiscount')
                                                                    <input type="checkbox" name="show_discount" value="ok">
                                                                    <span></span>
                                                                </label>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </div>

                                            @if(getWhatsApp() =='true')
                                            <!-- <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    <div class="col-md-12">
                                                        <label class="control-label"> <span class="fa fa-whatsapp" style="color:green;"></span> @lang('layout.Whatsapp')</label>
                                                        <label class="mt-checkbox mt-checkbox-outline">
                                                            <input type="checkbox" name="whatsapp" value="2" />
                                                            <span></span>
                                                        </label>
                                                    </div>
                                                </div>
                                            </div> -->
                                            @endif
                                            <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                <table class="table table-striped table-bordered table-advance ">
                                                    <tr>
                                                        <td class="t_body">
                                                            <div>
                                                                <label class="mt-checkbox mt-checkbox-outline">@lang('layout.ShowReceivables')
                                                                    <input type="checkbox" name="show_receive" value="ok">
                                                                    <span></span>
                                                                </label>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </div>
                                            @if(searchByCodeLocation()=="true")
                                            <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                <table class="table table-striped table-bordered table-advance ">
                                                    <tr>
                                                        <td class="t_body">
                                                            <div>
                                                                <label class="mt-checkbox mt-checkbox-outline">@lang('layout.PersianDescription')
                                                                    <input type="checkbox" name="show_persian_desc" value="ok">
                                                                    <span></span>
                                                                </label>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </div>
                                            @endif
                                        </div>
                                        <div class="row">
                                            @if(getPrintDescription()=="true")
                                            <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    <div class="col-md-12">
                                                        <label class="control-label">@lang('layout.PrintDescription')</label>
                                                        <textarea name="print_description" v-text="print_description"  class="form-control" rows="2"></textarea>
                                                    </div>
                                                </div>
                                            </div>
                                            @endif
                                            <div class="col-lg-6 col-md-6 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    <div class="col-md-12">
                                                        <label class="control-label">@lang('layout.Memo')</label>
                                                        <textarea name="memo"  class="form-control" rows="2"></textarea>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <?php
                                        $print_session = session()->get('print');

                                        $current_sale_id = "invoiceFactorPrint/".$print_session
                                        ?>
                                        @if($print_session)
                                        <div class="row">
                                            <iframe src="{{$current_sale_id}}" height="400" width="500"></iframe>
                                        </div>
                                        <?php
                                            session()->forget('print');
                                        ?>
                                        @endif
                                    </div>
                                    <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                                        <button type="button" v-if="((!isError) && (number_Error == false) && (isError1 == false))" @click="handleSubmit($event)" :disabled="disabled" class="btn green">@lang('layout.Submit')</button>
                                        <button type="button" v-if="((!isError) && (number_Error == false) && (isError1 == false))" :disabled="disabled" class="btn blue" @click="saveAndNew($event)">@lang('layout.SaveAndNew')</button>
                                        <a href="{{route('invoice.index')}}" @click="clearTemp" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>

                                    </div>
                                    <cmodal :show='showModal' @close="showModal=false">

                                    </cmodal>
                                </div>


                            </div>


                            {!! Form::close() !!}

                        </div>

                    </div>


                </div>
                <p> &nbsp; </p>
                <p> &nbsp; </p>
            </div>
        </div>
        <!-- END TAB PORTLET-->
    </div>
</div>

@endsection
@push('scripts')
<script src="{{URL::asset('assets/global/plugins/bootstrap-timepicker/js/bootstrap-timepicker.min.js')}}" type="text/javascript"></script>
<script src="{{URL::asset('assets/pages/scripts/components-date-time-pickers.min.js')}}" type="text/javascript"></script>

<script type="text/javascript">

function showHeader(partName){
    if(partName == "invoice_create_header")
    {
        $('#invoice_create_header_fa').toggleClass("fa-angle-up fa-angle-down");
        $('#invoice_create_header').toggle();
    }
}

//Add to auto print preview
function factorPrint(id,sendWhatsapp = null,type = null) {
    if (sendWhatsapp == null || sendWhatsapp == '') {
        sendWhatsapp = 'not';
    }
    var a = document.createElement('a');
    a.href = "{{url('invoiceFactorPrint')}}/" + id + "/" + sendWhatsapp + "/" + type;
    a.target = "_blank";
    document.body.appendChild(a);
    a.click();
    document.body.removeChild(a);
} 

 
    @if(App::getLocale())
    Vue.use(VeeValidate, {
        locale: '{{App::getLocale()}}',
    });
    @else
    Vue.use(VeeValidate, {
        locale: 'en',
    });
    @endif

    Vue.use(VueInputAutowidth);
    Vue.use(VueNumeric.default);

    Vue.component('v-select', VueSelect.VueSelect);

    Vue.component("modal", {
        template: "#modal-template",
        props: ['show'],

    });

    document.onkeydown = function (e) {
        // console.log('mylog', e.altKey, e.which, e.ctrlKey, e.code, e);
        // save invoice by f9
        // save invoice by f8
        if (e.which == 119) {
            v.saveAndNew();
        }
        
        if (e.which == 120) {
            v.autoSubmit();
        }

        // save invoice by shif && enter
        if (e.shiftKey && e.which == 13) {
            v.autoSubmit();
        }

        // save invoice by shif && enter
        if (e.ctrlKey && e.which == 13) {
            v.callOnItemloadGeneral();
        }
    }
    //begin new member
    Vue.component("cmodal", {
        template: '#cmodal-template',

        props: ['show'],
        data() {
            return {
                types: [],
                classes: [],
                receivables: [],
                payables: [],
                code: null,
                selectType: null,
                selectPay: null,
                selectedClass: null,
                selectReceive: null,
            }
        },
        mounted() {
            setTimeout(() => {
                this.getMemberCode();
            }, 500);
        },
        methods: {
            onSubmit() {

                v.showModal = false;
                //this.member.type = this.member.type.id;
                var datas = $("#modalForm").serializeArray();
                let vmc = this;
                $.ajax({
                    headers: {
                        'X-CSRF-TOKEN': "{{csrf_token()}}"
                    },
                    url: '{{route("customer.store")}}',
                    method: 'post',
                    data: {
                        "name": datas[0]['value'],
                        "code": datas[1]['value'],
                        'email': datas[2]['value'],
                        'phone': datas[3]['value'],
                        'address1': datas[4]['value'],
                        'type': this.selectType.id,
                        'receivable': this.selectReceive.id,
                        'payable': this.selectPay.id,
                        'class': (this.selectedClass) ? this.selectedClass.id : null
                    },
                    dataType: 'json',

                }).done(function(response) {
                    // var customer_id = 0;
                    if (response) {
                        v.selected_customer = response.customer;
                        vmc.getMemberCode();
                    }
                }).fail(function(error) {
                    console.log('error', error);
                });
            },
            getMemberCode() {
                let vmc = this;
                axios.get('{{route("customer.create")}}').then(
                response => {
                    vmc.types = response.data.types;
                    if (vmc.types) {
                        for (var i = 0; i < vmc.types.length; i++) {
                            if (vmc.types[i].type == "Customer") {
                                vmc.selectType = vmc.types[i];
                            }
                        }
                    }
                    vmc.receivables = response.data.receivable;
                    vmc.payables = response.data.payable;
                    vmc.code = response.data.code;
                    vmc.classes = response.data.member_class;
                    if(vmc.receivables.length>0)
                    {
                        vmc.selectReceive=vmc.receivables[0];
                    }
                    if(vmc.payables.length>0)
                    {
                        vmc.selectPay=vmc.payables[0];
                    }

                }).catch(error => console.log(error));
            }
        }
    });

    
    function callSaveTemp() {
        @if(ShowCreateToCustomer() != 'true' && saveTempData() == 'true')
        setTimeout((function () {
            v.saveTemp();
            // console.log(12);
        }), 4e4)
        @endif
    }

    function callSaveTempToShow() {
        @if(ShowCreateToCustomer() == 'true')
        setTimeout((function () {
            v.saveTempToShow();
            // console.log(13);
        }), 3e3)
        @endif
    }

    // end new member 
    var seePrice ={!! $seePrice !!};
    var seeCost ={!! $seeCost !!};

    var currency ={!! $currency !!};
    var banks = {!! $banks !!};
    var all_services = {!! $all_services !!};
    var inventory_category = {!! $inventory_category !!};
    var memberClass = {!! $memberClass !!};
    var transportCompany = {!! $transportCompany !!};
    var allDrivers = {!! $allDrivers !!};
    var saleArea = {!! $saleArea !!};
    var taxation = {!! $taxation !!};
    var commission = {!! $commission !!};
    var discountDate = {!! $discountDate !!};

    let homeCurrency = {!! $homeCurrency !!};
    let ratesFetched = {!! $rates !!};

    var inventory_sites = {!!$inventory_sites!!};
    var priceLevel = {!!$priceLevel!!};
    var priceLevelGeneral = {!!$priceLevelGeneral!!};
    var receive_number = {!!json_encode($receive_number)!!}; 
    
    var order_id = {!!$order_id!!}; 
    var online_order = {!!$online_order!!}; 
    var measureList = {!!$measureList!!}; 

    var member_cloth_id_session = {!!json_encode(session('member_cloth_id'))!!};
    var member_cloth_member_id_session = {!!json_encode(session('member_cloth_member_id'))!!};

    var memberClothAll =  {!!json_encode($memberClothAll)!!}; 

    var inventoryBrand =  {!!$inventoryBrand!!}; 
    var oilPart =  {!!$oilPart!!}; 
    
    var v = new Vue({
        el: '#appInvoice',
        data: {
            dynamic_time:'',
            number: "{{$number}}",
            old_number: "{{$number}}",
            frarmerNumber: "{{$frarmerNumber}}",
            number_msg: '',
            number_Error: false,
            disabled: false,
            forgivness: '',
            check_with_key: false,
            showModalSaleOrder: false,
            showModal: false,
            showInfoModal: false,
            oil_sale: false,
            sub_price: true,
            invoiceDescription: null,
            saleOrderList: [],
            selected_sale_order: null,
            purchase_orders: false,
            cheap: false,
            editKey: false,
            setDatas: [],
            customer: [],
            all_customer: [],
            selectedOilPart: null,
            oilPart: oilPart,
            seePrice: seePrice,
            seeCost: seeCost,
            taxation: taxation,
            selected_taxation: null,
            commission: commission,
            selected_commission: null,
            subTotalCommi:0,
            totalCommi:0,
            total_return:0,
            discount_date: discountDate,
            selected_discount_date: null,
            selected_customer: null,
            member_id: null,
            brand: null,
            location: null,
            cost: null,
            SNumber: null,
            on_hand: null,
            measure_name: null,
            AdvancePrice: null,
            AdvancePrice_cost: null,
            date: null,
            overdue_date: null,
            other_member_name: null,
            brandItem: inventoryBrand,
            selected_iventory_brand: null,
            driver_data: [{
                cost: null,
                description: null,
                description2: null,
                driver_name: null,
                other_measure: null,
                other_measure2: null,
                vehicle_name: null,
                wagon_number: null
                }
            ],
            print_description: null,
            banks: banks,
            all_services: all_services,
            selected_banks: null,
            currency: currency,
            selected_currency: {!!json_encode(getHomeCurrency()) !!},
            selected_payment_currency: homeCurrency,
            rate: 0,
            discountFiled: 0,
            discountFiledRow: 0,
            subDiscountFiledRow: 0,
            newSubDiscountFiledRow: 0,
            sale_taxation: 0,
            saleTaxation: 0,
            totalTax: 0,
            subTotalTax: 0,
            newSubTotal: 0,
            total_qty_amount: 0,
            per_qty_check: false,
            discountIsAmount: false,
            washing_form: false,
            wash_width: 0,
            wash_length: 0,
            temp_return_items: [],
            temp_items: [],
            totalAmountes: [],
            types: null,
            inventory_category: inventory_category,
            selected_iventory_category: null,
            inventory_sites: inventory_sites,
            inventory_sites1: inventory_sites,
            selected_iventory_site: null,
            selected_inventory: null,
            selected_item: null,
            selected_quantity: null,
            selected_quantity_error: false,
            selected_price: null,
            selected_inventory1: null,
            selected_index: 0,
            selected_currency_index: 0,
            newCost: [
                null,
                null,
                null,
                null
            ],
            inventories: [],
            inventory_return: [],
            services: [{
                    items: all_services,
                    item: null,
                },
                {
                    items: all_services,
                    item: null,
                },
            ],
            payments: [],
            payment_invoices: [{
                items: all_services,
                item: null,
                selected_payment_currency: null
            }],
            CusTypes: null,
            memberClass: memberClass,
            selected_class: null,

            saleArea: saleArea,
            selected_area: null,
            ref_no: '',
            msg: '',
            isError1: false,
            item_not_found: false,
            p_total: false,

            transportCompany: transportCompany,
            allDrivers: allDrivers,
            selected_transportCompany: null,
            selected_transportDriver: null,
            t_drivers: allDrivers,
            summary: [],
            priceLevel: priceLevel,
            selected_priceLevel: null,
            priceLevelGeneral: priceLevelGeneral,
            selected_priceLevelGeneral: null,
            receive_number: receive_number,
            order_id: order_id,
            online_order: online_order,
            measureList: measureList,
            far_measure: null,
            far_seed_amount: 0,
            counter_check: 0,
            counter_check1: 1,
            counter_check2: -1,
            member_cloth_list:[],
            selectedMemberCloth:null,
            memberClothAll:memberClothAll,
            member_cloth_id_session:member_cloth_id_session,
            member_cloth_member_id_session:member_cloth_member_id_session,
            last_item_sale:null,
            last_item_purchase:null,
            width:null,
            length:null,
            height:null,
            transferRent: [],
            transfer_rent_vendor:[],
            transfer_rent_vendor_selected:null,
            transfer_rent_bank_selected:null,
            transfer_rent_type :null,
            multi_currency:[{
                sum: 0,
                sum_sub: 0,
                sum_discount: 0,
                all_discount: 0,
                payment: 0,
                currency: homeCurrency,
                allCurency: currency,
                transfer_rent_bank_selected:null,
                transfer_rent_vendor_selected:null,
                transfer_rent_type:null,
                services: [{
                        items: all_services,
                        item: null,
                        quantity: 0,
                        new_rate: 0
                    },
                    {
                        items: all_services,
                        item: null,
                        quantity: 0,
                        new_rate: 0
                    },
                ],
                inventories: [{
                    inventory: null,
                    item: null,
                    location: null,
                    item_category: null,
                    item_brand: null,
                    tax: 'on',
                    selected_taxation: null,
                    sub_total: '',
                    inventory_site: null,
                    price_level: null
                }],
                payments: [{
                    items: banks,
                    item: null
                }],
                driver_data: [{
                    cost: null,
                    description: null,
                    description2: null,
                    driver_name: null,
                    other_measure: null,
                    other_measure2: null,
                    vehicle_name: null,
                    wagon_number: null
                    }
                ]

            }],
            transfer_rent_type :null
        },
        computed: {
            setRates() {

                let rates = [];
                this.currency.forEach((b) => {
                    ratesFetched.forEach((a) => {

                        if (a.currency_id == b.id) {
                            rates.push({
                                name: a.name,
                                code: a.code,
                                symbol: a.symbol,
                                static_rate: a.static_rate,
                                rate: a.rate != null ? Number.parseFloat(a.rate) : 1,
                                exchange_rate: a.rate != null ? Number.parseFloat(a.rate) : 1,
                                hq_rate: a.hq_rate != null ? Number.parseFloat(a.hq_rate) : 1,
                                currency: b.id,
                                id: b.id
                            });
                        }
                    })
                });

                this.currency.forEach((a) => {
                    let found = false;
                    rates.forEach((b) => {
                        if (a.id == b.id) {
                            found = true;
                            return;
                        }
                    });

                    if (!found) {
                        rates.push({
                            name: a.name,
                            code: a.code,
                            symbol: a.symbol,
                            static_rate: a.static_rate,
                            rate: 1,
                            exchange_rate: 1,
                            hq_rate: 1,
                            currency: a.id,
                            id: a.id
                        })
                    }
                });
                this.banks = [];

                banks.forEach((a) => {
                    rates.forEach((r) => {
                        if (a.code == r.code) {
                            this.banks.push({
                                amount: a.amount,
                                balance: a.balance,
                                code: a.code,
                                static_rate: a.static_rate,
                                id: a.id,
                                name: a.name,
                                rate: r.rate,
                                hq_rate: r.hq_rate,
                                r_number: receive_number
                            })
                        }
                    });
                });

                return rates;

            },
            selectedRate() {
                if (this.multi_currency) {
                    for (var c = 0; c < this.multi_currency.length; c++) {
                        if (this.multi_currency[c].currency) {
                            // var newrate = (this.multi_currency[c].currency) ? this.multi_currency[c].currency.rate : 0;
                            // if (this.discountIsAmount && this.discountFiled && this.rate > 0 && newrate > 0 && this.rate != newrate) {
                            //     this.discountFiled = ((this.discountFiled / this.rate) * newrate);
                            // }
                            // this.rate = (this.multi_currency[c].currency) ? this.multi_currency[c].currency.rate : 0;
                            if (this.multi_currency[c].inventories) {
                                for (var i = 0; i < this.multi_currency[c].inventories.length; i++) {
                                    if (this.multi_currency[c].inventories[i].item && this.multi_currency[c].inventories[i].item != null) {
                                        // console.log(3210000, this.multi_currency[c].inventories[i].item);
                                        if (this.multi_currency[c].inventories[i].item.new_rate) {
                                            @if(systemConfig()[30] == 1)
                                            this.multi_currency[c].inventories[i].item.cost = this.multi_currency[c].inventories[i].item.new_rate * this.multi_currency[c].currency.static_rate / this.multi_currency[c].currency.rate;
                                            @else 
                                            this.multi_currency[c].inventories[i].item.cost = this.multi_currency[c].inventories[i].item.new_rate * this.multi_currency[c].currency.rate;
                                            @endif
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            },
            discount() {
                if ("{{getSubTotal()}}" == "true" && this.sub_Subtotal > 0) {
                    this.newSubTotal = this.sub_Subtotal;
                    this.newSubDiscountFiledRow = this.subDiscountFiledRow;
                } else {
                    this.newSubTotal = this.subtotal;
                    this.newSubDiscountFiledRow = this.discountFiledRow;
                }
                if (this.discountIsAmount) {

                    if (this.newSubTotal > 0 && this.discountFiled) {
                        return (Number.parseFloat(this.discountFiled) * 100) / (this.newSubTotal - this.discountFiledRow);
                    } else {
                        return 0;
                    }
                } else {

                    return this.discountFiled
                }
            },
            sub_discount() {
                if (this.discountIsAmount) {
                    if (this.sub_Subtotal > 0 && this.discountFiled) {
                        return (Number.parseFloat(this.discountFiled) * 100) / (this.sub_Subtotal - this.subDiscountFiledRow);
                    } else {
                        return 0;
                    }
                } else {
                    return this.discountFiled
                }
            },

            // calculate subtotal
            checkedSubtotal: function() {
                var sum = 0;
                var sumTax = 0;
                for (var i = 0; i < this.inventories.length; i++) {
                    if (this.inventories[i].item && this.inventories[i].item != null) {
                        if (this.inventories[i].tax) {
                            // console.log(123)
                            if (this.oil_sale == true) {
                                var quantity = this.inventories[i]['item']['oil_qty'];
                            } else {
                                var quantity = this.inventories[i]['item']['quantity'];
                            }
                            if (this.inventories[i]['item']['other_measure'] > 0 && this.per_qty_check) {
                                var quantity = this.inventories[i]['item']['other_measure'];
                            }
                            var rate = this.inventories[i]['item']['rate'];
                            var new_rate = this.inventories[i]['item']['new_rate'];
                            var smeasure_unit = this.inventories[i]['item']['measure']['measure_unit'];
                            var measure_unit = this.inventories[i]['item']['measure_unit'];
                            if (new_rate != rate && quantity > 0) {
                                @if(systemConfig()[30] == 1)
                                sum += new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate;
                                @else 
                                sum += new_rate * quantity * this.selected_currency.rate;
                                @endif
                            } else {
                                @if(systemConfig()[30] == 1)
                                sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate);
                                @else 
                                sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
                                @endif
                            }

                        } else {
                            // console.log(333)
                            if (this.oil_sale == true) {
                                var quantity = this.inventories[i]['item']['oil_qty'];
                            } else {
                                var quantity = this.inventories[i]['item']['quantity'];
                            }
                            var rate = this.inventories[i]['item']['rate'];
                            var new_rate = this.inventories[i]['item']['new_rate'];
                            var smeasure_unit = this.inventories[i]['item']['measure']['measure_unit'];
                            var measure_unit = this.inventories[i]['item']['measure_unit'];
                            if (this.inventories[i]['selected_taxation'] != null) {
                                var selected_taxation = this.inventories[i]['selected_taxation']['percent'];

                                if (new_rate != rate && quantity > 0) {
                                    @if(systemConfig()[30] == 1)
                                    sumTax += ((new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate) * selected_taxation) / 100;
                                    @else 
                                    sumTax += ((new_rate * quantity * this.selected_currency.rate) * selected_taxation) / 100;
                                    @endif
                                    @if(systemConfig()[30] == 1)
                                    this.inventories[i]['row_tax_amount'] = ((new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate) * selected_taxation) / 100;
                                    @else 
                                    this.inventories[i]['row_tax_amount'] = ((new_rate * quantity * this.selected_currency.rate) * selected_taxation) / 100;
                                    @endif
                                } else {
                                    @if(systemConfig()[30] == 1)
                                    sumTax += ((quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate)) * selected_taxation) / 100;
                                    @else 
                                    sumTax += ((quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate)) * selected_taxation) / 100;
                                    @endif

                                    @if(systemConfig()[30] == 1)
                                    this.inventories[i]['row_tax_amount'] = ((quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.static_rate / this.selected_currency.rate)) * selected_taxation) / 100;
                                    @else 
                                    this.inventories[i]['row_tax_amount'] = ((quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate)) * selected_taxation) / 100;
                                    @endif
                                }
                            }

                        }
                    }
                }

                if (this.selected_taxation) {
                    var percent = this.selected_taxation.percent;
                    this.totalTax = ((sum * percent) / 100) + sumTax;
                    this.subTotalTax = ((sum * percent) / 100);
                }

                if (this.selected_commission) {
                    var percent = this.selected_commission.percent;
                    this.totalCommi = ((sum * percent) / 100);
                    this.subTotalCommi = ((sum * percent) / 100);
                }else{
                    this.totalCommi = 0;
                    this.subTotalCommi = 0;
                }

                return sum;
            },

            // calculate subtotal
            sub_Subtotal: function() {
                
                var sum = 0;
                var sum_discount = 0;

                if (this.multi_currency) {
                    for (var c = 0; c < this.multi_currency.length; c++) {
                        if (this.multi_currency[c].currency) {
                            if (this.multi_currency[c].inventories) {
                                for (var i = 0; i < this.multi_currency[c].inventories.length; i++) {
                                    if (this.multi_currency[c].inventories[i].item && this.multi_currency[c].inventories[i].item != null) {
                                        if (this.multi_currency[c].inventories[i].sub_total) {

                                            if (this.oil_sale == true) {
                                                var quantity = this.multi_currency[c].inventories[i]['item']['oil_qty'];
                                            } else {
                                                var quantity = this.multi_currency[c].inventories[i]['item']['quantity'];
                                            }
                                            if (this.multi_currency[c].inventories[i]['item']['other_measure'] > 0 && this.per_qty_check) {
                                                var quantity = this.multi_currency[c].inventories[i]['item']['other_measure'];
                                            }
                                            var rate = this.multi_currency[c].inventories[i]['item']['rate'];
                                            var new_rate = this.multi_currency[c].inventories[i]['item']['new_rate'];
                                            var smeasure_unit = this.multi_currency[c].inventories[i]['item']['measure']['measure_unit'];
                                            var measure_unit = this.multi_currency[c].inventories[i]['item']['measure_unit'];

                                            var discount = this.multi_currency[c].inventories[i]['item']['discount'];

                                            if (new_rate && quantity > 0) {
                                                @if(systemConfig()[30] == 1)
                                                sum += new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate;
                                                @else 
                                                sum += new_rate * quantity * this.selected_currency.rate;
                                                @endif
                                                if (this.discountIsAmount) {
                                                    if (discount > 0) {
                                                        sum_discount += (discount * quantity);
                                                    }
                                                } else {

                                                    if (discount > 0) {
                                                        @if(systemConfig()[30] == 1)
                                                        sum_discount += (parseFloat(discount) * (new_rate * quantity * this.selected_currency.static_rate / this.selected_currency.rate)) / 100;
                                                        @else 
                                                        sum_discount += (parseFloat(discount) * (new_rate * quantity * this.selected_currency.rate)) / 100;
                                                        @endif
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }

                this.subDiscountFiledRow = sum_discount;
                if ("{{getSubTotal()}}" == "true" && sum > 0) {
                    this.newSubTotal = sum;
                    this.newSubDiscountFiledRow = sum_discount;
                } else {
                    this.newSubTotal = this.subtotal;
                    this.newSubDiscountFiledRow = this.discountFiledRow;
                }
                return sum;
            },

            // calculate subtotal
            subtotal: function() {
                if (this.multi_currency) {
                    for (var c = 0; c < this.multi_currency.length; c++) {
                        var sum = 0;
                        var sum_sub = 0;
                        var sum_discount = 0;
                        var all_discount = 0;
                        var payment = 0;
                        if (this.multi_currency[c].currency) {
                            if (this.multi_currency[c].inventories) {
                                for (var i = 0; i < this.multi_currency[c].inventories.length; i++) {
                                    if (this.multi_currency[c].inventories[i].item && this.multi_currency[c].inventories[i].item != null) {
                                        //Total Qty all Invoic 
                                        // var row_amount = this.subMQuantity(this.multi_currency[c].inventories[i]['item'], this.multi_currency[c].inventories[i]['item']['quantity'])
                                        // // var row_amount = null;
                                        // total_qty += row_amount;

                                        if (this.oil_sale == true) {
                                            var quantity = this.multi_currency[c].inventories[i]['item']['oil_qty'];
                                        } else {
                                            var quantity = this.multi_currency[c].inventories[i]['item']['quantity'];
                                        }
                                        if (this.multi_currency[c].inventories[i]['item']['other_measure'] > 0 && this.per_qty_check) {
                                            var quantity = this.multi_currency[c].inventories[i]['item']['other_measure'];
                                        }
                                        var rate = this.multi_currency[c].inventories[i]['item']['rate'];
                                        var new_rate = this.multi_currency[c].inventories[i]['item']['new_rate'];
                                        var smeasure_unit = this.multi_currency[c].inventories[i]['item']['measure']['measure_unit'];
                                        var measure_unit = this.multi_currency[c].inventories[i]['item']['measure_unit'];

                                        var discount = this.multi_currency[c].inventories[i]['item']['discount'];

                                        // console.log('row_discount',row_discount);
                                        if (new_rate && quantity > 0) {
                                            @if(systemConfig()[30] == 1)
                                            sum += new_rate * quantity * this.multi_currency[c].currency.static_rate / this.multi_currency[c].currency.rate;
                                            @else 
                                            sum += new_rate * quantity * this.multi_currency[c].currency.rate;
                                            @endif

                                            @if(systemConfig()[30] == 1)
                                            sum_sub += new_rate * quantity * this.multi_currency[c].currency.static_rate / this.multi_currency[c].currency.rate;
                                            @else 
                                            sum_sub += new_rate * quantity * this.multi_currency[c].currency.rate;
                                            @endif
                                            
                                            if (this.discountIsAmount) {
                                                if (discount > 0) {
                                                    sum_discount += (discount * quantity);
                                                }
                                            } else { 
                                                if (discount > 0) {
                                                    @if(systemConfig()[30] == 1)
                                                    sum_discount += (parseFloat(discount) * (new_rate * quantity * this.multi_currency[c].currency.static_rate / this.multi_currency[c].currency.rate)) / 100;
                                                    @else 
                                                    sum_discount += (parseFloat(discount) * (new_rate * quantity * this.multi_currency[c].currency.rate)) / 100;
                                                    @endif
                                                }
                                            }
                                        }
                                    }
                                }
                                this.discountFiledRow = sum_discount;

                                @if(getSaleTaxation() == 'true')
                                this.saleTaxation = (this.sale_taxation * sum / 100);
                                // sum = sum - (this.sale_taxation*sum/100);
                                @endif

                                for (var i = 0; i < this.multi_currency[c].services.length; i++) {
                                    if (this.multi_currency[c].services[i].item && this.multi_currency[c].services[i].item != null) {

                                        var rate = this.multi_currency[c].services[i]['item']['rate'];
                                        var new_rate = this.multi_currency[c].services[i]['new_rate'];
                                        var smeasure_unit = this.multi_currency[c].services[i]['item']['measure']['measure_unit'];
                                        var measure_unit = this.multi_currency[c].services[i]['item']['measure_unit'];
                                        var quantity = this.multi_currency[c].services[i]['quantity'];
                                        if (new_rate && quantity > 0) {
                                            @if(systemConfig()[30] == 1)
                                            sum += new_rate * quantity * this.multi_currency[c].currency.static_rate / this.multi_currency[c].currency.rate;
                                            @else 
                                            sum += new_rate * quantity * this.multi_currency[c].currency.rate;
                                            @endif
                                        } else {
                                            @if(systemConfig()[30] == 1)
                                            sum += quantity * ((rate * smeasure_unit / measure_unit) * this.multi_currency[c].currency.static_rate / this.multi_currency[c].currency.rate);
                                            @else 
                                            sum += quantity * ((rate * smeasure_unit / measure_unit) * this.multi_currency[c].currency.rate);
                                            @endif
                                        }

                                    }
                                }

                                if (this.selected_taxation) {
                                    // var percent = this.selected_taxation.percent;
                                    var tax1 = this.checkedSubtotal;
                                    var tax = this.totalTax;
                                    sum = tax + sum;
                                    // var tax = this.checkedSubtotal;
                                    // sum = ((tax * percent)/100)+sum;
                                }

                                if (this.selected_commission) {
                                    var commi = this.totalCommi;
                                    @if(getSaleCommissionMarketer() !="true")
                                    sum = commi + sum;
                                    @endif
                                }
 
                                for (var i = 0; i < this.multi_currency[c].payments.length; i++) {
                                    if (this.multi_currency[c].payments[i].item != null && this.multi_currency[c].payments[i].item) {
                                        if (this.multi_currency[c].payments[i].item != null && this.multi_currency[c].payments[i]['item']['rate'] > 0) {
                                            @if(systemConfig()[30] == 1)
                                            payment += ((this.multi_currency[c].payments[i]['item']['amount'] / this.multi_currency[c].payments[i]['item']['static_rate'] * this.multi_currency[c].payments[i]['item']['rate']) * this.multi_currency[c].currency.static_rate / this.multi_currency[c].currency.rate);
                                            @else 
                                            payment += (this.multi_currency[c].payments[i]['item']['amount'] * this.multi_currency[c].currency.rate / this.multi_currency[c].payments[i]['item']['rate']);
                                            @endif
                                        }
                                    }  
                                }

                            }
                        }


                        if (this.discountFiled && sum > 0) {
                            if (this.discountIsAmount) {
                                all_discount = Number.parseFloat(this.discountFiled);
                            } else {
                                all_discount = (sum - sum_discount) * Number.parseFloat(this.discountFiled) / 100;
                            }
                        }
                        
                        this.multi_currency[c].sum = sum;
                        this.multi_currency[c].sum_sub = sum_sub;
                        this.multi_currency[c].sum_discount = sum_discount;
                        this.multi_currency[c].all_discount = all_discount;
                        this.multi_currency[c].payment = payment;
                    }
                }

                return sum;
            },

            // check payed amount
            payeds: function() {
                var sum = 0;
                for (var i = 0; i < this.payments.length; i++) { 
                    if (this.payments[i].item != null && this.payments[i].item) {
                        if (this.payments[i].item != null && this.payments[i]['item']['rate'] > 0) { 
                            @if(systemConfig()[30] == 1)
                            sum += ((this.payments[i]['item']['amount'] / this.payments[i]['item']['static_rate'] * this.payments[i]['item']['rate']) * this.selected_currency.static_rate / this.selected_currency.rate);
                            @else 
                            sum += (this.payments[i]['item']['amount'] * this.selected_currency.rate / this.payments[i]['item']['rate']);
                            @endif
                        }
                    }
                }
                return sum;
            },

            // check data validation
            isError: function() {
                var isError = false;
                //var flag=false;
                // for (var i = 0; i < this.inventories.length; i++)
                // {

                //    if (this.inventories[i].item)
                //    {
                //      flag=true;
                //      if(((this.inventories[i]['item']['rate'] <=0) ))
                //      {
                //        rate=this.inventories[i]['item']['rate'];
                //        new_rate=this.inventories[i]['item']['new_rate'];
                //        if(rate <=0 && new_rate <=0)
                //        {
                //             isError = true;
                //        }

                //      }
                //    }
                // }
                if (this.selected_customer == null) {
                    isError = true;
                }
                return isError;


            },
        },
        mounted: function() {
            this.dynamicTime()
            @if(autoSelectCustomer()!='false')
            this.selectMemeber({!! getDropdown('sale', 'customer') !!});
            @endif

            // console.log('DDDDD', this.banks)
            @if(autoSelectCustomer()!='false')
            this.selectMemeber({!! getDropdown('invoice', 'customer') !!});
            @endif

            if(this.member_cloth_id_session && this.member_cloth_member_id_session)
            {
                this.selectMemeber(this.member_cloth_member_id_session);
                // this.selected_customer = _.find(this.customer, (m) => m.id == this.member_cloth_member_id_session);
                if(this.selected_customer)
                {

                this.selectedMemberCloth = _.find(this.memberClothAll, (c) => c.id == this.member_cloth_id_session);

                // console.log('ssssssssss',this.memberClothAll,this.selectedMemberCloth)
                }

            }
            
            var selected_site = null;
            if (showWhat('item_by_site_in_sale') == 'yes') {
                selected_site = _.find(this.inventory_sites, (v) => v.id == {!!getDropdown('invoice', 'site') !!});
                this.selected_iventory_site = selected_site;
            }

            this.inventories.push({
                inventory: null,
                item: null,
                location: null,
                item_category: null,
                item_brand: null,
                tax: 'on',
                selected_taxation: null,
                sub_total: '',
                inventory_site: selected_site,
                price_level: null
            });

            this.inventory_return.push({
                inventory: null,
                item: null,
                item_category: null,
                item_brand: null,
                tax: 'on',
                selected_taxation: null,
                sub_total: '',
                inventory_site: selected_site,
                price_level: null
            });

            var selected_banks = null;
            var bank = _.find(this.banks, (v) => v.id == {!!getDropdown('invoice', 'account') !!});
            if (bank) {
                selected_banks = bank;
            }

            this.payments.push({
                items: this.banks,
                item: selected_banks
            });



            if (this.order_id) {
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'onlineOrderItems',
                        order_id: this.order_id
                    }
                })
                .then(function(response) {
                        // console.log('myrespo1', response);
                    if (response.data) {
                    if (response.data.items) {
                    if (response.data.items.length > 0) {
                        // console.log('myrespo 777', response.data.items);
                        v.inventories = [];
                        for (var r = 0; r < response.data.items.length; r++) {
                            v.inventories.push({
                                inventory: response.data.items[r],
                                item: response.data.items[r],
                                location: null,
                                item_category: null,
                                item_brand: null,
                                tax: 'on',
                                selected_taxation: null,
                                sub_total: ''
                            });
                        }
                        v.inventories.push({
                            inventory: null,
                            item: null,
                            location: null,
                            item_category: null,
                            item_brand: null,
                            tax: 'on',
                            selected_taxation: null,
                            sub_total: ''
                        });
                        
                        v.purchase_orders = true;

                        v.invoiceDescription = v.online_order.description;
                        
                        for (var a = 0; a < v.currency.length; a++) {
                            if (v.currency[a].code == v.online_order.currency) {
                                v.selected_currency = v.currency[a];
                                // v.selected_currency.rate = v.selected_sale_order.rate;
                            }
                        }
                    }
                    }
                    if (response.data.service) {
                        if (response.data.service.length > 0) {
                            v.services = [];
                            for (var r = 0; r < response.data.service.length; r++) {
                                var flag = false;
                                var tempService;
                                for (var h = 0; h < v.all_services.length; h++) {
                                    if (v.all_services[h].id == response.data.service[r].id) {
                                        flag = true;
                                        tempService = v.all_services[h];
                                        tempService.quantity = response.data.service[r].quantity;
                                        tempService.rate = response.data.service[r].new_rate;
                                        tempService.new_rate = response.data.service[r].new_rate;
                                        tempService.order_detail_id = response.data.service[r].order_detail_id;
                                    }
                                }
                                if (flag) {
                                    v.services.push({item: tempService, items: v.all_services, quantity: 0, new_rate: tempService.new_rate})
                                }
                            }
                            for (var w = 1; w > response.data.service.length; w--) {
                                v.services.push({item: null, items: all_services, quantity: 0, new_rate: 0});
                            }

                        }
                    }
                    }
                })
                .catch(function(error) {
                    console.log(error);
                })
            } else {
                @if(saveTempData() == 'true' && 1==2)
                axios.get("{{route('temp.getData')}}", {
                    params: {
                        type: 'invoice'
                    }
                })
                .then(function(response) {
                        // console.log('myrespo1', response);
                        
                    if (response.data) {
                    if (response.data.form) {
                        
                        // v.purchase_orders = true;
                        v.invoiceDescription = response.data.form.description;
                        v.number = response.data.form.number;
                        v.ref_no = response.data.form.ref_no;
                        v.date = response.data.form.date;
                        v.overdue_date = response.data.form.overdue_date;
                        v.other_member_name = response.data.form.other_member_name;
                        v.sale_taxation = response.data.form.sale_taxation;
                        v.print_description = response.data.form.print_description;
                        if (response.data.form.member_id) {
                            
                        // console.log('myrespo1', response.data.form.member_id);
                            v.selectMemeber(response.data.form.member_id);
                            // v.selected_customer = _.find(v.customer, (k) => k.id == response.data.form.member_id);
                        }
                        if (response.data.form.class_id) {
                            v.selected_class = _.find(v.memberClass, (c) => c.id == response.data.form.class_id);
                        }
                        if (response.data.form.sale_area_id) {
                            v.selected_area = _.find(this.saleArea, (s) => s.id == response.data.form.sale_area_id);
                        }

                        v.discountFiled = response.data.form.discount;
                        if (response.data.form.discount_type) {
                            if (response.data.form.discount_type == 'percent') {
                                v.discountIsAmount = false;
                            }
                            else {
                                v.discountIsAmount = true;
                            }
                        }
					
                        // if (this.invoice.taxation_id && this.taxation) {
                        //     this.selected_taxation = _.find(this.taxation, (s) => s.id == this.invoice.taxation_id);
                        //     this.selected_taxation.percent = this.invoice.tax_percent;
                        // }
                        // if (this.invoice.sale_discount_id && this.discount_date) {
                        //     this.selected_discount_date = _.find(this.discount_date, (s) => s.id == this.invoice.sale_discount_id);
                        // }
                        
                        for (var a = 0; a < v.currency.length; a++) {
                            if (v.currency[a].code == response.data.form.currency) {
                                v.selected_currency = v.currency[a];
                                v.selected_currency.rate = response.data.form.rate;
                            }
                        }

                    }
                    if (response.data.items) {
                    if (response.data.items.length > 0) {
                        v.inventories = [];
                        for (var r = 0; r < response.data.items.length; r++) {
                            v.inventories.push({
                                inventory: response.data.items[r],
                                item: response.data.items[r],
                                location: null,
                                item_category: null,
                                item_brand: null,
                                tax: 'on',
                                selected_taxation: null,
                                sub_total: ''
                            });
                        }
                        v.inventories.push({
                            inventory: null,
                            item: null,
                            location: null,
                            item_category: null,
                            item_brand: null,
                            tax: 'on',
                            selected_taxation: null,
                            sub_total: ''
                        });
                        
                    }
                    }
                    if (response.data.service) {
                        if (response.data.service.length > 0) {
                            v.services = [];
                            for (var r = 0; r < response.data.service.length; r++) {
                                var flag = false;
                                var tempService;
                                for (var h = 0; h < v.all_services.length; h++) {
                                    if (v.all_services[h].id == response.data.service[r].id) {
                                        flag = true;
                                        tempService = v.all_services[h];
                                        tempService.quantity = response.data.service[r].quantity;
                                        tempService.rate = response.data.service[r].new_rate;
                                        tempService.new_rate = response.data.service[r].new_rate;
                                        tempService.order_detail_id = response.data.service[r].order_detail_id;
                                    }
                                }
                                if (flag) {
                                    v.services.push({item: tempService, items: v.all_services, quantity: 0, new_rate: tempService.new_rate})
                                }
                            }
                            for (var w = 1; w > response.data.service.length; w--) {
                                v.services.push({item: null, items: all_services, quantity: 0, new_rate: 0});
                            }

                        }
                    }
                    if (response.data.payment) {
                        if (response.data.payment.length > 0) {
                            v.payments = [];
                            for (var t = 0; t < response.data.payment.length; t++) {
                                var foundFlag = false;
                                var tempBank = null;
                                for (var y = 0; y < v.banks.length; y++) {
                                    if (response.data.payment[t].recevie_payment_id == v.banks[y].id) {
                                        foundFlag = true;
                                        tempBank = v.banks[y];
                                        tempBank.amount = response.data.payment[t].amount;
                                        tempBank.rate = response.data.payment[t].rate; 
                                        tempBank.description = response.data.payment[t].description;
                                        tempBank.number = response.data.payment[t].number;
                                    }
                                }
                                if (foundFlag) {
                                    v.payments.push({item: tempBank, items: v.banks});
                                }
                            }
                            v.payments.push({item: null, items: v.banks});
                        }
                    }
                    if (response.data.driver) {
                        v.driver_data = response.data.driver
                        // console.log(233,v.driver_data);
                    }
                    }
                })
                .catch(function(error) {
                    console.log(error);
                })
                @endif
            }
            @if(systemConfig()[27] == 1 && oilSale() == 'true')
                this.oil_sale = true;
            @endif
            
            callSaveTemp();
            callSaveTempToShow();

            @if(TabIndexInItemName() =="true")
                this.$refs.barcode_search1.focus();
            @endif
        },
        methods: {
            //BEGIN - Used for dynamic input time
            dynamicTime()
                {
                    this.time_interval = setInterval(() => {
                        const now = new Date()
                        @if(getHourType() == 24)
                            const hours = now.getHours().toString().padStart(2,'0')
                            const minutes = now.getMinutes().toString().padStart(2,'0') 
                            // const seconds = now.getSeconds().toString().padStart(2,'0')
                            this.dynamic_time = `${hours}:${minutes}`
                        @else
                            const timeString = now.toLocaleTimeString('en-US',{hour:'numeric',minute:'numeric',hour12:true});
                            this.dynamic_time = `${timeString}`
                        @endif
                        
                    },1000);
                },
                stopDynamicTime()
                {
                    clearInterval(v.time_interval)
                },
                changeTime()
                {
                    v.dynamic_time = v.$refs.time_input.value
                },
            //END - Used for dynamic input time
            getSummary() {
                if (this.selected_customer) {
                    if(this.selected_customer.id != this.member_cloth_member_id_session)
                    {
                        this.member_cloth_list = [];
                        this.selectedMemberCloth = null;
                        this.take_member_cloth_data(this);
                    }

                    this.getSummaryRecor(this.selected_customer.id, this);

                }

            },
            getSummaryRecor(id, v) {
                axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'memberStatment',
                            member_id: id,
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            v.summary = response.data;
                        } else {
                            v.summary = [];
                        }
                    })
                    .catch(function(error) {
                        console.log(error);
                    });
            },

            take_member_cloth_data(v) {

                axios.get("{{route('member.memberCloth')}}", {
                    params: {
                        member_id: this.selected_customer.id
                    },
                }).then(function (response) {
                    v.member_cloth_list = response.data;
                })
                .catch(function (error) {
                    console.log(error);
                });
                }, 

            checkRefNo() {
                var chack = 'false';
                var ref_no = v.ref_no;
                if (ref_no != null) {


                    axios.get("{{route('callMethod.search')}}", {

                            params: {
                                ref_no: v.ref_no,
                                method_name: 'Search_ref_no',
                                table_name: 'sales'
                            },
                        })
                        .then(function(response) {
                            @if(getDuplicatedRefNo()!="true")
                            if (response.data.result != null) {
                                console.log(response.data.result);
                                v.msg = "@lang('layout.DuplicateData')";
                                v.isError1 = true;
                            } else {
                                v.msg = 'no';
                                v.isError1 = false;

                            }
                            @endif
                        })
                        .catch(function(error) {
                            console.log(error);
                        });

                }
            },
            checkNo() {
                var chack = 'false';
                var number = v.number;
                if (number != null && !v.selectedOilPart) {
                    axios.get("{{route('callMethod.search')}}", {

                            params: {
                                number: v.number,
                                method_name: 'Search_number',
                                table_name: 'sales'
                            },
                        })
                        .then(function(response) {
                            // console.log(response.data.result);
                            if (response.data.result != null) {
                                // console.log(response.data.result);
                                // v.temp_items=response.data;
                                v.number_msg = "@lang('layout.DuplicateData')";
                                v.number_Error = true;
                            } else {
                                v.number_msg = 'no';
                                v.number_Error = false;

                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        });

                } else {
                    v.number_msg = 'no';
                    v.number_Error = false;
                }
            },
            ChangeOil() {
                if (v.oil_sale == false) {
                    v.oil_sale = true;
                } else {
                    v.oil_sale = false;
                }
                // console.log(v.oil_sale);
            },
            subPrice() {
                if (v.sub_price == false) {
                    v.sub_price = true;
                } else {
                    v.sub_price = false;
                }
                // console.log(v.sub_price);
            },
            change_oil_qty(index,c_index) {
                if (this.multi_currency[c_index].inventories[index]['item'] && this.multi_currency[c_index].inventories[index]['item'] != null) {

                    var quantity = this.multi_currency[c_index].inventories[index]['item']['quantity'];
                    var density = this.multi_currency[c_index].inventories[index]['item']['density'];
                    if (quantity > 0 && density > 0) {
                        this.multi_currency[c_index].inventories[index]['item']['oil_qty'] = Number.parseFloat(quantity / density).toFixed(7);
                    }
                    // var oil_qty = this.multi_currency[c_index].inventories[index]['item']['oil_qty'];
                }
            },
            change_qty_by_oil(index,c_index) {
                if (this.multi_currency[c_index].inventories[index]['item'] && this.multi_currency[c_index].inventories[index]['item'] != null) {

                    var oil_qty = this.multi_currency[c_index].inventories[index]['item']['oil_qty'];
                    var density = this.multi_currency[c_index].inventories[index]['item']['density'];
                    if (oil_qty > 0 && density > 0) {
                        this.multi_currency[c_index].inventories[index]['item']['quantity'] = Number.parseFloat(oil_qty * density).toFixed(7);
                    }
                    // var oil_qty = this.multi_currency[c_index].inventories[index]['item']['oil_qty'];
                }
            },
            change_per_qty(index,c_index) {
                if (this.multi_currency[c_index].inventories[index]['item'] && this.multi_currency[c_index].inventories[index]['item'] != null) {
                    var other_measure = this.multi_currency[c_index].inventories[index]['item']['other_measure'];
                    var per_qty = this.multi_currency[c_index].inventories[index]['item']['site']['per_qty'];
                    if (other_measure > 0 && per_qty > 0 && this.per_qty_check) {
                        @if(getSaleByOtherMeasure() == "true")
                        this.multi_currency[c_index].inventories[index]['item']['quantity'] = myRound(other_measure * per_qty);
                        @endif
                    }
                    if (other_measure > 0 && per_qty > 0) {
                        @if(getSelectQuantityByOtherMeasure() == "true")
                        this.multi_currency[c_index].inventories[index]['item']['quantity'] = myRound(other_measure * per_qty);
                        @endif
                    }
                }
            },
            selectSaleNumber(index,c_index) {
                if (v.multi_currency[0].inventories[0]['item'] != null || v.multi_currency[0].inventories[0]['inventory_site'] != null) {
                    @if(getInvoicNoBySite() == "true")
                    var site = null;
                    if (v.multi_currency[0].inventories[0]['inventory_site'] != null) {
                        site = v.multi_currency[0].inventories[0]['inventory_site'];
                    }
                    if (site == null) {
                        site = v.multi_currency[0].inventories[0]['item']['site'];
                    }
                    if (site != null && site.number != null && site.site_id != null) {
                        axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    method_name: 'SaleNumberBySite',
                                    type: 'Invoice',
                                    site_id: site.site_id
                                }
                            })
                            .then(function(response) {
                                // console.log('myrespo1', response.data);
                                if (Number(response.data) > 0) {
                                    v.number = Number(response.data) + 1;
                                    v.old_number = Number(response.data) + 1;
                                } else if (Number(site.number) > 0) {
                                    v.number = Number(site.number);
                                    v.old_number = Number(site.number);
                                }
                            })
                            .catch(function(error) {
                                console.log(error);
                            })

                    }
                    @endif

                    @if(systemConfig()[27] == 1)
                    if (v.multi_currency[c_index].inventories[index]['item']['site'] && v.oil_sale) {
                        v.multi_currency[c_index].inventories[index].item.density = v.multi_currency[c_index].inventories[index].item.site.per_qty;
                        v.change_qty_by_oil(index,c_index);
                    }
                    @endif
                }
            },

            changeCostBylLocation(index,c_index) {
                @if(costByLocation()=="true")
                setTimeout(() => {
                    if (v.multi_currency[c_index].inventories[index]['item'] != null) {
                        if (v.multi_currency[c_index].inventories[index]['item']['site']) {
                            if (v.multi_currency[c_index].inventories[index].item.site.cost) {
                                v.multi_currency[c_index].inventories[index].item.LasCost = v.multi_currency[c_index].inventories[index].item.site.cost;
                            }
                        }
                    } 
                }, 200);
                @endif
            },
            
            handleSubmit(e) {
                this.$validator.validate().then(valid => {
                    if (valid) {
                        if (v.member_chack() == 'true') {
                            var r = confirm("@lang('layout.member_payable_levels')");
                            if (r == true) {
                                v.disabled = true;
                                v.submitForm(e.target);
                            }
                        } else {
                            v.disabled = true;
                            v.submitForm(e.target);
                        }
                    }
                });
            },

            autoSubmit() {
                this.$validator.validate().then(valid => {
                    if (valid) {
                        if (this.isError == true) {
                            alert('there is no item');
                            return false;
                        }
                        document.getElementById("sales-form").submit();
                    }
                });
            },

            subMQuantity(item = null, quantity = null) {
                if (item != null) {
                    var result = 0;
                    if (item.site) {
                        // console.log(38383,item.measureListAll.length);
                        if (item.measureListAll) {
                            for (var i = 0; i < item.measureListAll.length; i++) {
                                // console.log(3838,item.measureListAll[i],item.measure_unit,item.measure.measure_unit);
                                if (item.measureListAll[i].measure_id == item.measure2.measure_id) {
                                    result = (quantity * item.measure.measure_unit) / (item.measure_unit);
                                    result = (result * item.measure_unit) / (item.measureListAll[i].measure_unit);
                                }
                            }
                        }



                    }
                    return result;
                }
            },
            secoundMeasurQuantity(item = null, quantity = null) {
                if (item != null) {
                    var result = 0;
                    if (item.site) {
                        // console.log(38383,item.measureListAll.length);
                        if (item.measureListAll) {
                            for (var i = 0; i < item.measureListAll.length; i++) {
                                // console.log(3838,item.measureListAll[i],item.measure_unit,item.measure.measure_unit);
                                if (item.measureListAll[i].measure_id == item.measure1.measure_id) {
                                    result = (quantity * item.measure.measure_unit) / (item.measure_unit);
                                    result = (result * item.measure_unit) / (item.measureListAll[i].measure_unit);
                                }
                            }
                        }



                    }
                    return result;
                }
            },

            // chack_member_payable_levels
            member_chack() {
                var chack = 'false';
                var member_id = v.member_id;
                if (member_id != null) {

                    // var totals = Number.parseFloat((v.subtotal - (v.discount * v.subtotal / 100)) - v.payeds);
                    var currency = $("input[name=currency]").val();


                    $.ajax({
                        url: "{{route('callMethod.search')}}",
                        async: false,
                        data: {
                            member_id: v.member_id,
                            method_name: 'Search_member_payable_levels',
                            currency: currency,
                        },
                        success: function(data) {
                            var r_amount = Number.parseFloat(data.amount);
                            var r_m_amount = Number.parseFloat(data.m_amount);
                            // var totalss = Number.parseFloat(((isNaN(r_m_amount) ? 0 : r_m_amount) + totals));
                            
                            // if (r_amount != 0 && r_amount < totalss) {
                            //     chack = 'true';
                            // } else {
                            //     chack = 'false';
                            // }


                        }.bind(this),

                        error: function(error) {
                            console.log(error)
                        }
                    });
                    /*
                            axios.get("{{route('callMethod.search')}}",
				   {

					params:{
					  member_id:v.member_id,
					  method_name:'Search_member_payable_levels',
					  currency:currency,
					  
					},
				   })
				   .then(function (response)
				   {
					 
						var r_amount = response.data.amount;
						var r_m_amount = response.data.m_amount;
						if(r_amount < (r_m_amount + totals)){
							chack = 'true';
						}
				   })
				   .catch(function (error)
				   {
					  console.log(error);
				   });
			  */
                }
                return chack;
            },

            // calculate item price based on measure change
            measureChange(index,c_index) {

                if (this.multi_currency[c_index].inventories[index].item != null) {
                    var item = this.multi_currency[c_index].inventories[index].item;

                    var temp = ((item.rate * item.measure.measure_unit / item.measure_unit));
                    result = Number.parseFloat(temp).toFixed(precision());

                    this.multi_currency[c_index].inventories[index].item.new_rate = result;

                    // if(this.multi_currency[c_index].inventories[index].item.price_level){

                    //  this.multi_currency[c_index].inventories[index].item.price_level.id = null;
                    // }

                    if (this.multi_currency[c_index].inventories[index].item.quantity > 0 && this.multi_currency[c_index].inventories[index].sub_price > 0) {
                        if (this.multi_currency[c_index].inventories[index].item.measure2) {
                            var item = this.multi_currency[c_index].inventories[index].item;
                            var sub_quantity = v.subMQuantity(item, item.quantity);
                            var sub_price = this.multi_currency[c_index].inventories[index].sub_price;
                            var total_price = (sub_quantity * sub_price);
                            var quantity = item.quantity;
                            if (quantity > 0) {
                                if (this.multi_currency[c_index].currency.rate > 0) {
                                    @if(systemConfig()[30] == 1)
                                    item.new_rate = Number.parseFloat((total_price / quantity) / this.multi_currency[c_index].currency.static_rate * this.multi_currency[c_index].currency.rate).toFixed(7);
                                    @else 
                                    item.new_rate = Number.parseFloat((total_price / quantity) / this.multi_currency[c_index].currency.rate).toFixed(7);
                                    @endif
                                } else {
                                    item.new_rate = Number.parseFloat(total_price / quantity).toFixed(7);
                                }
                            }
                        }
                    }

                    // this.multi_currency[c_index].inventories[index].item.new_rate = this.$refs.in[index].value/this.multi_currency[c_index].currency.rate;

                    // var temp1 = ((item.LasCost * item.measure.measure_unit / item.measure_unit));
                    // var LasCost = Number.parseFloat(temp1).toFixed(precision());
                    // this.multi_currency[c_index].inventories[index].item.LasCost = LasCost;

                }
            },



            // Change Item Sale Rate According Item Price Level
            change_sale_rate_by_price_level(index,c_index) {

                if (this.multi_currency[c_index].inventories[index].item != null) {

                    var item = this.multi_currency[c_index].inventories[index].item;
                    var item_price_level = this.multi_currency[c_index].inventories[index].item.item_price_level;


                    var temp = ((item.rate * item.measure.measure_unit / item.measure_unit));
                    result = Number.parseFloat(temp).toFixed(precision());
                    this.multi_currency[c_index].inventories[index].item.new_rate = result;
                    // console.log("SAEED", this.multi_currency[c_index].inventories[index].item.new_rate, temp)
                    // console.log(result);
                    var myDataArray = this.multi_currency[c_index].inventories[index].item.item_price_level;
                    if (this.multi_currency[c_index].inventories[index].price_level != undefined) {
                        var item = this.multi_currency[c_index].inventories[index].item;
                        for (var i = 0; i < myDataArray.length; i++) {
                            if (myDataArray[i]['id'] == this.multi_currency[c_index].inventories[index].price_level.id) {
                                var temp = ((myDataArray[i]['rate'] * item.measure.measure_unit / item.measure_unit));
                                result = Number.parseFloat(temp).toFixed(precision());

                                // if (this.selected_currency.rate > 0) {
                                //     item.new_rate = myRound((result) / this.selected_currency.rate);
                                // } else {
                                    item.new_rate = myRound(result);
                                // }
                            }

                        }
                    }
                }
            },

            // Change Item Sale Rate According Item Price Level
            change_sale_rate_by_price_level_general() {
                
                if (this.inventories != null && this.selected_priceLevelGeneral) {
                    var price_type = this.selected_priceLevelGeneral.price_type;
                    var percent = Number.parseFloat(this.selected_priceLevelGeneral.percent);

                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].item && this.inventories[i].item != null) {
                                var rate = this.inventories[i]['item']['rate'];
                                var smeasure_unit = this.inventories[i]['item']['measure']['measure_unit'];
                                var measure_unit = this.inventories[i]['item']['measure_unit'];
                                var rate1 = (rate * smeasure_unit / measure_unit);
                                rate1 = Number.parseFloat(rate1);

                                if(price_type == 'up' && percent > 0 && rate1 > 0){
                                    var result = Number.parseFloat((rate1 * percent) / 100);
                                    this.inventories[i]['item']['new_rate'] = Number.parseFloat(rate1 + result);
                                } else if(price_type == 'down' && percent > 0 && rate1 > 0){
                                    var result = Number.parseFloat((rate1 * percent) / 100);
                                    this.inventories[i]['item']['new_rate'] = Number.parseFloat(rate1 - result);
                                }  
                        }
                    }
                }
            },
            // Change Item Sale Rate According Item Price Level
            change_sale_rate_by_price_level_general_per_item(index,c_index) {
                if (this.multi_currency[c_index].inventories != null) {
                    if (this.multi_currency[c_index].inventories[index].item != null) {
                        var item = this.multi_currency[c_index].inventories[index].item;
                        var item_price_level = this.multi_currency[c_index].inventories[index].price_level;
                        var price_type = item_price_level.price_type;
                        var percent = Number.parseFloat(item_price_level.percent);
                        
                        var rate = this.multi_currency[c_index].inventories[index]['item']['rate'];
                        var smeasure_unit = this.multi_currency[c_index].inventories[index]['item']['measure']['measure_unit'];
                        var measure_unit = this.multi_currency[c_index].inventories[index]['item']['measure_unit'];
                        var rate1 = (rate * smeasure_unit / measure_unit);
                        rate1 = Number.parseFloat(rate1);
                        
                        if(price_type == 'up' && percent > 0 && rate1 > 0){
                            var result = Number.parseFloat((rate1 * percent) / 100);
                            this.multi_currency[c_index].inventories[index]['item']['new_rate'] = Number.parseFloat(rate1 + result);
                        } else if(price_type == 'down' && percent > 0 && rate1 > 0){
                            var result = Number.parseFloat((rate1 * percent) / 100);
                            this.multi_currency[c_index].inventories[index]['item']['new_rate'] = Number.parseFloat(rate1 - result);
                        } 
                    }
                }
            },
            // calculate item price based on measure change
            measure2Change(index,c_index) {
                if (this.multi_currency[c_index].inventories[index].item != null) {
                    if (this.multi_currency[c_index].inventories[index].item.quantity > 0 && this.multi_currency[c_index].inventories[index].sub_price > 0) {
                        if (this.multi_currency[c_index].inventories[index].item.measure2) {
                            var item = this.multi_currency[c_index].inventories[index].item;
                            var sub_quantity = v.subMQuantity(item, item.quantity);
                            var sub_price = this.multi_currency[c_index].inventories[index].sub_price;
                            var total_price = (sub_quantity * sub_price);
                            var quantity = item.quantity;
                            if (quantity > 0) {
                                if (this.multi_currency[c_index].currency.rate > 0) {
                                    @if(systemConfig()[30] == 1)
                                    item.new_rate = Number.parseFloat((total_price / quantity) / this.multi_currency[c_index].currency.static_rate * this.multi_currency[c_index].currency.rate).toFixed(7);
                                    @else 
                                    item.new_rate = Number.parseFloat((total_price / quantity) / this.multi_currency[c_index].currency.rate).toFixed(7);
                                    @endif
                                } else {
                                    item.new_rate = Number.parseFloat(total_price / quantity).toFixed(7);
                                }
                            }
                        }
                    }
                }
            },
            selectMemeber(id = null) {
                if (id) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SearchMember',
                            id: id,
                            type: 'Customer'
                        }
                    })
                    .then(function(response) {
                        if (response.data) {
                            // console.log(response.data);
                            v.selected_customer = null;
                            v.selected_customer = response.data;
                        }
                    })
                    .catch(function(error) {
                        console.log(error);
                    })
                }
            },
            memberClassChange() {
                if (v.selected_class) {
                    v.customer = [];
                    // v.selected_customer = null;
                    let class_id = v.selected_class.id;
                
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SearchMember',
                            class_id: class_id,
                            type: 'Customer'
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            // console.log(response.data);
                            v.customer = [];
                            v.customer = response.data;
                        }
                    })
                    .catch(function(error) {
                        console.log(error);
                    })
                }
            },
            MemberSearch: _.debounce((search, loading) => {
                loading(true);
                let class_id = (v.selected_class != undefined) ? v.selected_class.id : null;
                
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'SearchMember', 
                        keyword: search,
                        class_id: class_id,
                        type: 'Customer'
                    }
                })
                .then(function(response) {
                    if (response.data.length > 0) {
                        // console.log(response.data);
                        v.customer = [];
                        v.customer = response.data;
                    }
                    loading(false);
                })
                .catch(function(error) {
                    loading(false);
                    console.log(error);
                })
            }, getDebounceTime()),

            //Vendor Search for Transfer Rent
            VendorSearch: _.debounce((search, loading) => {
                loading(true);
                axios.get("{{route('callMethod.search')}}", {
                    params: {
                        method_name: 'SearchMember', 
                        keyword: search,
                        type: 'Vendor'
                    }
                })
                .then(function(response) {
                    if (response.data.length > 0) {
                        // console.log(response.data);
                        v.transfer_rent_vendor = [];
                        v.transfer_rent_vendor = response.data;
                    }
                    loading(false);
                })
                .catch(function(error) {
                    loading(false);
                    console.log(error);
                })
            }, getDebounceTime()),


            changePriceLevel() {

                this.inventories = [];

                this.inventories.push({
                    inventory: null,
                    item: null,
                    location: null,
                    item_category: this.selected_iventory_category,
                    item_brand: null,
                    tax: 'on',
                    selected_taxation: null,
                    sub_total: '',
                    inventory_site: this.selected_iventory_site,
                    price_level: null
                });

            },
            //Get Transport Company Drivers 
            getDrivers() {
                if (this.selected_transportCompany) {
                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                transport_id: this.selected_transportCompany.id,
                                method_name: 'Search_transport_company_drivers'
                            },
                        })
                        .then(function(response) {
                            if (response.data.result != null) {
                                console.log('all Drivers', response.data.result);
                                v.t_drivers = response.data.result;
                                v.selected_transportDriver = null;
                            } else {

                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        });
                }
            },

            //Get Just Drivers  without Transport Company Select
            getAllDrivers() {
                if (!v.selected_transportCompany) {
                    v.t_drivers = v.allDrivers;
                }
            },

            // calculate item price based on measure change
            measureChangeservice(index,c_index) {

                if (this.multi_currency[c_index].services[index].item != null) {
                    var item = this.multi_currency[c_index].services[index].item;
                    @if(systemConfig()[30] == 1)
                    var temp = ((item.rate * item.measure.measure_unit / item.measure_unit) * this.multi_currency[c_index].currency.static_rate / this.multi_currency[c_index].currency.rate);
                    @else 
                    var temp = ((item.rate * item.measure.measure_unit / item.measure_unit) * this.multi_currency[c_index].currency.rate);
                    @endif
                    result = Number.parseFloat(temp).toFixed(precision());

                    this.multi_currency[c_index].services[index].item.new_rate = result;

                    // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.multi_currency[c_index].currency.rate;

                }
            },
            // detect member change and searh
            memberChange() {
                if (this.selected_customer) {
                    v.member_id = this.selected_customer.id;
                    // get member contract
                    this.saleOrderSearch(this.selected_customer.id, this);

                    @if(getShwoPriceLevel()=="general_percent")
                    var price_level_id = this.selected_customer.price_level_id;
                    if(price_level_id){
                        this.selected_priceLevelGeneral = _.find(this.priceLevelGeneral, (s) => s.id == price_level_id);
                    }else{
                        this.selected_priceLevelGeneral = null;
                    }
                    @endif
                }
            },

            // detect setSaleNumber and searh
            setSaleNumber() {
                if (this.selectedOilPart) {
                    if (this.selectedOilPart.sale_number) {
                        this.number = this.selectedOilPart.sale_number;
                    }

                    v.inventories = [];
                    v.inventories.push({
                        inventory: null,
                        item: null,
                        location: null,
                        item_category: null,
                        item_brand: null,
                        tax: 'on',
                        selected_taxation: null,
                        sub_total: ''
                    });
                }
            },

            // sale order change
            saleOrderChang() {
                console.log('test 33');
            },
            // end sale order change
            // set new price
            setNewRate(type = null, index = null, c_index = null) {
                if (type == 'inventory') {
                    
                    if (this.multi_currency[c_index].inventories[index].item) {
                        @if(systemConfig()[30] == 1)
                        this.multi_currency[c_index].inventories[index].item.new_rate = this.multi_currency[c_index].inventories[index].item.cost / this.multi_currency[c_index].currency.static_rate * this.multi_currency[c_index].currency.rate;
                        @else 
                        this.multi_currency[c_index].inventories[index].item.new_rate = this.multi_currency[c_index].inventories[index].item.cost / this.multi_currency[c_index].currency.rate;
                        @endif
                        
                        // this.multi_currency[c_index].inventories[index].item.new_rate = this.$refs.in[index].value / this.multi_currency[c_index].currency.rate;
                        @if(getSaleSubMeasure() =="true")
                        if (this.multi_currency[c_index].inventories[index].item.quantity > 0 && this.multi_currency[c_index].inventories[index].sub_price) {
                            if (this.multi_currency[c_index].inventories[index].item.measure2) {
                                var item = this.multi_currency[c_index].inventories[index].item;
                                var sub_quantity = v.subMQuantity(item, item.quantity);
                                var total_price = (item.new_rate * item.quantity);
                                if (sub_quantity > 0) {
                                    @if(systemConfig()[30] == 1)
                                    this.multi_currency[c_index].inventories[index].sub_price = Number.parseFloat((total_price / sub_quantity) * this.multi_currency[c_index].currency.static_rate / this.multi_currency[c_index].currency.rate).toFixed(precision());
                                    @else 
                                    this.multi_currency[c_index].inventories[index].sub_price = Number.parseFloat((total_price / sub_quantity) * this.multi_currency[c_index].currency.rate).toFixed(precision());
                                    @endif
                                }
                            }
                        }
                        @endif
                        @if(systemConfig()[30] == 1)
                        if (((this.multi_currency[c_index].inventories[index].item.LasCost * this.multi_currency[c_index].inventories[index].item.measure.measure_unit / this.multi_currency[c_index].inventories[index].item.measure_unit) * this.multi_currency[c_index].currency.static_rate / this.multi_currency[c_index].currency.rate) > (this.multi_currency[c_index].inventories[index].item.new_rate * this.multi_currency[c_index].currency.static_rate / this.multi_currency[c_index].currency.rate)) {
                            this.cheap = true;
                        } else {
                            this.cheap = false;
                        }
                        @else 
                        if (((this.multi_currency[c_index].inventories[index].item.LasCost * this.multi_currency[c_index].inventories[index].item.measure.measure_unit / this.multi_currency[c_index].inventories[index].item.measure_unit) * this.multi_currency[c_index].currency.rate) > (this.multi_currency[c_index].inventories[index].item.new_rate * this.multi_currency[c_index].currency.rate)) {
                            this.cheap = true;
                        } else {
                            this.cheap = false;
                        }
                        @endif
                    }
                }
                if (type == 'service') {
                    if (this.multi_currency[c_index].services[index].item) {
                        var serv = 'ser'+c_index;
                        // console.log('service changed', this.$refs[serv][index], serv);
                        @if(systemConfig()[30] == 1)
                        this.multi_currency[c_index].services[index].new_rate = this.$refs[serv][index].value / this.multi_currency[c_index].currency.static_rate * this.multi_currency[c_index].currency.rate;
                        @else 
                        this.multi_currency[c_index].services[index].new_rate = this.$refs[serv][index].value / this.multi_currency[c_index].currency.rate;
                        @endif
                    }
                }
                var far_seed_amount = 0;
                for (var i = 0; i < this.multi_currency[c_index].inventories.length; i++) {
                    if (this.multi_currency[c_index].inventories[i].item && this.multi_currency[c_index].inventories[i].item != null) {
                        var quantity = this.multi_currency[c_index].inventories[i]['item']['quantity'];
                        far_seed_amount += quantity;
                    }
                }
                if (this.multi_currency[c_index].inventories[0].item) {
                    v.far_measure = this.multi_currency[c_index].inventories[0]['item']['measure']['measure_id'];
                    // console.log(333,v.far_measure);
                }
                this.far_seed_amount = far_seed_amount;
            },


            setQuantityByTotal(index,c_index) {
                var totalInd = 'total'+c_index;
                if (v.counter_check == 0) {
                    v.counter_check = 1;
                    setTimeout((function () {
                        v.counter_check1 = v.$refs[totalInd][index].value;
                        v.setQuantityByT(index,c_index);
                    }), 2e2)
                }  
            },
            setQuantityByT(index,c_index) {
                var totalInd = 'total'+c_index;
                setTimeout((function () {
                    v.counter_check2 = v.$refs[totalInd][index].value;
                    v.setQuantityByTotals(index,c_index);
                }), 2e3)
            },
            setQuantityByTotals(index,c_index) {
                var totalInd = 'total'+c_index;
                if (v.counter_check1 != v.counter_check2) {
                    v.counter_check1 = v.$refs[totalInd][index].value;
                    v.setQuantityByT(index,c_index);
                }else{
                    v.p_total = true;
                    if (v.$refs[totalInd][index].value) {
                        if (v.multi_currency[c_index].inventories[index].item) {
                            if (v.oil_sale == true) {
                                if (v.multi_currency[c_index].inventories[index]['item']['cost']) {
                                    var cost = v.multi_currency[c_index].inventories[index]['item']['cost'];
                                    v.multi_currency[c_index].inventories[index].item.oil_qty = Number.parseFloat(v.$refs[totalInd][index].value / cost).toFixed(7);
                                    v.change_qty_by_oil(index,c_index);

                                    // v.multi_currency[c_index].inventories[index].item.new_rate = (v.$refs[totalInd][index].value / oil_qty) / v.multi_currency[c_index].currency.rate;
                                }
                            } else {
                                if (v.multi_currency[c_index].inventories[index]['item']['cost']) {
                                    // var quantity = v.multi_currency[c_index].inventories[index]['item']['quantity'];
                                    
                                    var cost = v.multi_currency[c_index].inventories[index]['item']['cost'];
                                    v.multi_currency[c_index].inventories[index].item.quantity =  Number.parseFloat(v.$refs[totalInd][index].value / cost).toFixed(7);

                                    // v.multi_currency[c_index].inventories[index].item.new_rate = (v.$refs[totalInd][index].value / quantity) / v.multi_currency[c_index].currency.rate;
                                    // v.multi_currency[c_index].inventories[index].item.cost = v.$refs[totalInd][index].value / quantity;
                                }
                            }
                        }
                    }
                    v.counter_check = 0; 
                }
            },
            setNewRateTotal(index, c_index) {
                if (this.multi_currency[c_index].inventories[index].item && this.multi_currency[c_index].inventories[index].sub_price > 0) {
                    if (this.multi_currency[c_index].inventories[index].item.measure2) {
                        var item = this.multi_currency[c_index].inventories[index].item;
                        var sub_quantity = v.subMQuantity(item, item.quantity);
                        var sub_price = this.multi_currency[c_index].inventories[index].sub_price;
                        var total_price = (sub_quantity * sub_price);
                        var quantity = item.quantity;
                        if (quantity > 0) {
                            if (this.multi_currency[c_index].currency.rate > 0) {
                                @if(systemConfig()[30] == 1)
                                item.new_rate = Number.parseFloat((total_price / quantity) / this.multi_currency[c_index].currency.static_rate * this.multi_currency[c_index].currency.rate).toFixed(7);
                                @else 
                                item.new_rate = Number.parseFloat((total_price / quantity) / this.multi_currency[c_index].currency.rate).toFixed(7);
                                @endif
                            } else {
                                item.new_rate = Number.parseFloat(total_price / quantity).toFixed(7);
                            }
                        }
                        // console.log('asda changed111', sub_quantity,item.quantity,sub_price,item);
                    }
                }
            },
            // quantitySubRate(index = null) {
            // if (this.multi_currency[c_index].inventories[index].item) {
            // var quantity = this.multi_currency[c_index].inventories[index].item.quantity
            // var sub_quantity = v.subMQuantity(this.multi_currency[c_index].inventories[index].item,this.multi_currency[c_index].inventories[index].item.quantity);
            // if(quantity > 0 && sub_quantity > 0){
            // var total_price =  (this.multi_currency[c_index].inventories[index].item.new_rate * quantity);
            // this.multi_currency[c_index].inventories[index].sub_price = myRound(total_price/sub_quantity);
            // }
            // }
            // },

            onItemSearch: _.debounce((search, loading) => {
                
                loading(true);
                let inventory_category_id = 0;
                let inventory_site_id = 0;
                let inventory_brand_id = 0;
                
                if (v.multi_currency[v.selected_currency_index].inventories[v.selected_index]) {
                    inventory_category_id = (v.multi_currency[v.selected_currency_index].inventories[v.selected_index]['item_category'] != undefined) ? v.multi_currency[v.selected_currency_index].inventories[v.selected_index]['item_category'].id : '';
                    inventory_site_id = (v.multi_currency[v.selected_currency_index].inventories[v.selected_index]['inventory_site'] != undefined) ? v.multi_currency[v.selected_currency_index].inventories[v.selected_index]['inventory_site'].id : '';
                    inventory_brand_id = (v.multi_currency[v.selected_currency_index].inventories[v.selected_index]['item_brand'] != undefined) ? v.multi_currency[v.selected_currency_index].inventories[v.selected_index]['item_brand'].id : '';
                }

                @if(TabIndexInItemName() =="true")
                    inventory_category_id = (v.selected_iventory_category != undefined)?v.selected_iventory_category.id:inventory_category_id;
                    // inventory_site_id = (v.selected_iventory_site != undefined)?v.selected_iventory_site.id:inventory_site_id;
                @endif

                // console.log(21,inventory_category_id,inventory_site_id,search);

                axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'itemesSearchSale', 
                            keyword: search,
                            inventory_category_id: inventory_category_id,
                            inventory_brand_id: inventory_brand_id,
                            inventory_site_id: inventory_site_id,
                        }
                    })
                    .then(function(response) {
                            // console.log(response);
                        if (response.data.length > 0) {
                            v.temp_items = [];
                            v.temp_return_items = [];
                            v.temp_items = response.data;
                            v.temp_return_items = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        console.log(error);
                    })
            }, getDebounceTime()),

            onItemload(index,c_index) {
                v.selected_index = index;
                v.selected_currency_index = c_index;
                if (v.multi_currency[c_index].inventories[index].inventory != null) {
                    // console.log('klk',v.multi_currency[c_index].inventories[index]);
                    var inventory_id = v.multi_currency[c_index].inventories[index].inventory.id;
                    let inventory_category_id = (v.multi_currency[c_index].inventories[index]['item_category'] != undefined) ? v.multi_currency[c_index].inventories[index]['item_category'].id : '';
                    let inventory_brand_id = (v.multi_currency[c_index].inventories[index]['item_brand'] != undefined) ? v.multi_currency[c_index].inventories[index]['item_brand'].id : '';
                    let inventory_site_id = (v.multi_currency[c_index].inventories[index]['inventory_site'] != undefined) ? v.multi_currency[c_index].inventories[index]['inventory_site'].id : '';
                    let price_level_id = (this.selected_priceLevel) ? this.selected_priceLevel.id : '';
                    // console.log('rrrrr', inventory_brand_id);
                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                member_id: v.member_id,
                                method_name: 'itemSearchSale',
                                inventory_id: inventory_id,
                                inventory_category_id: inventory_category_id,
                                inventory_brand_id: inventory_brand_id,
                                inventory_site_id: inventory_site_id,
                                price_level_id: price_level_id,
                            }
                        })
                        .then(function(response) {
                            v.multi_currency[c_index].inventories[index].item = null;
                            if (response.data.length > 0) {
                                console.log('Price Level Lala', response.data);
                                var checkD = true; 
                                @if(NotDuplicateItem() =="true")
                                if (v.multi_currency[c_index].inventories != null && response.data[0].id) {
                                    for (var i = 0; i < v.multi_currency[c_index].inventories.length; i++) {
                                        if (v.multi_currency[c_index].inventories[i].item && v.multi_currency[c_index].inventories[i].item != null) {
                                            if (v.multi_currency[c_index].inventories[i].item.id == response.data[0].id) {
                                                checkD = false;
                                            }
                                        }
                                    }
                                }
                                @endif
                                

                                var site_id = null;
                                if (v.selectedOilPart) {
                                    if (v.selectedOilPart.site_id) {
                                        site_id = v.selectedOilPart.site_id;
                                    }
                                }
                                if (!site_id) {
                                    @if(getDefaultSite() > 0)
                                        site_id = {{getDefaultSite()}};
                                    @else
                                        site_id = {{getDropdown('invoice', 'site')}};
                                    @endif
                                }
                                
                                if (checkD) {
                                    v.multi_currency[c_index].inventories[index].item = response.data[0];
                                    v.multi_currency[c_index].inventories[index].location = null;
                                    if (showWhat('item_by_site_in_sale') != 'yes') {
                                        if (site_id) {
                                            for (var i = 0; i < v.multi_currency[c_index].inventories[index].item.site_list.length; i++) {
                                                if (v.multi_currency[c_index].inventories[index].item.site_list[i].site_id == site_id) {
                                                    v.multi_currency[c_index].inventories[index].item.site = v.multi_currency[c_index].inventories[index].item.site_list[i];
                                                }
                                            }
                                        }
                                    }
                                    v.selectSaleNumber(0,0);

                                    v.temp_items = [];
                                    @if(getShwoPriceLevel()=="general_percent")
                                    setTimeout((function () {
                                        v.change_sale_rate_by_price_level_general();
                                    }), 400);
                                    @endif
                                } else {
                                    v.multi_currency[c_index].inventories[index].item = null;
                                    v.multi_currency[c_index].inventories[index].inventory = null;
                                }
                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        })

                }
            },
            
            locationSearch: _.debounce((search, loading) => {
                loading(true);
                let inventory_id = (v.multi_currency[v.selected_currency_index].inventories[v.selected_index]['item'] != undefined) ? v.multi_currency[v.selected_currency_index].inventories[v.selected_index]['item'].id : '';
                // console.log(3333, v.multi_currency[v.selected_currency_index].inventories, v.selected_index, inventory_id, search);
                if (inventory_id) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            member_id: v.member_id,
                            method_name: 'itemesSearchLocation',
                            keyword: search,
                            inventory_id: inventory_id
                        }
                    })
                    .then(function(response) {
                        // console.log(132, response.data);
                        if (response.data.length > 0) {
                            v.multi_currency[v.selected_currency_index].inventories[v.selected_index]['item']['locationList'] = response.data;
                        }
                        loading(false);
                    })
                    .catch(function(error) {
                        console.log(error);
                    })
                } else {
                    loading(false);
                }
            }, getDebounceTime()),

            locationItemload(index,c_index) {
                v.selected_index = index;
                v.selected_currency_index = c_index;

                if (v.multi_currency[c_index].inventories[index].item != null && v.multi_currency[c_index].inventories[index].location != null) {
                    var inventory_id = v.multi_currency[c_index].inventories[index].item.id;
                    var location = v.multi_currency[c_index].inventories[index].location.name;

                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'itemSiteByLocation',
                                inventory_id: inventory_id,
                                location: location
                            }
                        })
                        .then(function(response) {
                            // console.log(4444, response.data);
                            if (response.data.item.length > 0) {
                                v.multi_currency[c_index].inventories[index].item.site_list = response.data.item;
                                v.multi_currency[c_index].inventories[index].item.site = response.data.selectItem;
                                @if(costByLocation()=="true")
                                if (response.data.selectItem) {
                                    v.multi_currency[c_index].inventories[index].item.LasCost = response.data.selectItem.cost;
                                    v.multi_currency[c_index].inventories[index].item.description = response.data.selectItem.description;
                                }
                                @endif
                            } else {
                                v.multi_currency[c_index].inventories[index].item.site_list = [];
                                v.multi_currency[c_index].inventories[index].item.site = null;
                            }

                        })
                        .catch(function(error) {
                            console.log(error);
                        })
                }
            },

            callOnItemloadGeneral() {
                if (v.counter_check == 0) {
                    v.counter_check = 1;
                    @if(getBarcodeType()=="true")
                    setTimeout((function () {
                        v.counter_check1 = v.selected_inventory1;
                        v.call2();
                        // console.log(12);
                    }), 1e1)
                    @else
                    setTimeout((function () {
                        v.counter_check1 = v.selected_inventory1;
                        v.call2();
                        // console.log(12);
                    }), 2e2)
                    @endif
                }  
            
            // else{
            //     console.log('mylog', altKey, which, e.ctrlKey, e.code, e);
            //     if (v.counter_check == 0) {
                    
            //         v.counter_check = 1;
            //         @if(getBarcodeType()=="true")
            //         setTimeout((function () {
            //             v.counter_check1 = v.selected_inventory1;
            //             v.call2();
            //             // console.log(12);
            //         }), 1e1)
            //         @else
            //         setTimeout((function () {
            //             v.counter_check1 = v.selected_inventory1;
            //             v.call2();
            //             // console.log(12);
            //         }), 2e2)
            //         @endif
            //     }
            // }

            },
            call2() {
                @if(getBarcodeType()=="true")
                setTimeout((function () {
                    v.counter_check2 = v.selected_inventory1;
                    v.onItemloadGeneral();
                    // console.log(13);
                }), 1e1)
                @else
                setTimeout((function () {
                    v.counter_check2 = v.selected_inventory1;
                    v.onItemloadGeneral();
                    // console.log(13);
                }), 2e2)
                @endif
            },
            onItemloadGeneral(id = null) {
                if (v.counter_check1 != v.counter_check2) {
                    v.counter_check1 = v.selected_inventory1;
                    v.call2();
                }else{
                    if (v.selected_inventory != undefined || id || v.selected_inventory1) {
                        
                        var inventory_id = id;
                        if (v.selected_inventory != undefined) {
                            inventory_id = v.selected_inventory.id;
                        }

                        let number = v.selected_inventory1;

                        // console.log(888, number);
                        let inventory_category_id = (v.selected_iventory_category != undefined)?v.selected_iventory_category.id:'';
                        let inventory_site_id = (v.selected_iventory_site != undefined)?v.selected_iventory_site.id:'';

                        axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    member_id: v.member_id,
                                    method_name: 'itemSearchSale',
                                    inventory_id: inventory_id,
                                    inventory_category_id: inventory_category_id,
                                    // inventory_brand_id: inventory_brand_id,
                                    inventory_site_id: inventory_site_id,
                                    number: number,
                                }
                            })
                            .then(function(response) {
                                if (response.data.length > 0) {
                                    var che = null;
                                    var checkD = true;

                                    @if(NotDuplicateItem() =="true")
                                    if (v.inventories != null && response.data[0].id) {
                                        for (var i = 0; i < v.inventories.length; i++) {
                                            if (v.inventories[i].item && v.inventories[i].item != null) {
                                                if (v.inventories[i].item.id == response.data[0].id) {
                                                    v.inventories[i].item.quantity = ( Number.parseFloat(v.inventories[i].item.quantity) + 1);
                                                    checkD = false;
                                                }
                                            }
                                        }
                                    }
                                    @endif

                                    if (checkD) {
                                        for (var i = 0; i < v.inventories.length; i++) {
                                            if (v.inventories[i].item && v.inventories[i].item != null) {
                                                che = 'ok';
                                            } else {
                                                v.inventories.splice(i, 1);
                                            }
                                        }
                                        if(!che){
                                            v.inventories = [];
                                        }
                                        // console.log(response.data[0]);
                                        if (inventory_site_id) {
                                            for (var i = 0; i < response.data[0].site_list.length; i++) {
                                                if (response.data[0].site_list[i].site_id == inventory_site_id) {
                                                    response.data[0].site = response.data[0].site_list[i];
                                                }
                                            }
                                        }
                                        response.data[0].quantity = (v.selected_quantity > 0)?v.selected_quantity:1;

                                        v.inventories.unshift({
                                            inventory: response.data[0],
                                            item: response.data[0],
                                            location: null,
                                            selected_taxation: null,
                                            tax: 'on',
                                            sub_total: response.data[0].sub_total_stat,
                                            item_category: response.data[0].item_category,
                                            item_brand: response.data[0].inventory_brand,
                                            price_level:null
                                        });

                                        v.selected_inventory = null;
                                        v.selected_inventory1 = null;
                                        v.counter_check = 0;
                                        v.temp_items = [];
                                        v.selectSaleNumber(0,0);
                                        @if(getShwoPriceLevel()=="general_percent")
                                        setTimeout((function () {
                                            v.change_sale_rate_by_price_level_general();
                                        }), 400);
                                        @endif

                                        // const inp = v.$refs.barcode_search.$refs.search;
                                        // console.log(v.$refs.barcode_search.$refs.search.value);
                                        // v.$refs.barcode_search.$refs.search.focus();
                                        // v.$refs.barcode_search.$refs.search = null;
                                        v.$refs.barcode_search1.focus();

                                    }else{
                                        setTimeout((function () {
                                            v.selected_inventory = null;
                                            v.selected_inventory1 = null;
                                            v.counter_check = 0;
                                            v.$refs.barcode_search1.focus();
                                        }), 2e2)
                                    }
                                    
                                }else{
                                    // $('#success-sound')[0].play();
                                    // $('#error-sound')[0].play();
                                    v.item_not_found = true;
                                    setTimeout((function () {
                                        v.item_not_found = false;
                                        v.selected_inventory = null;
                                        v.selected_inventory1 = null;
                                        v.counter_check = 0;
                                        v.$refs.barcode_search1.focus();
                                        // console.log(12);
                                    }), 2e3)
                                }
                            })
                            .catch(function(error) {
                                console.log(error);
                            })

                    }
                }
            },

            loadItemGeneral() {
                if (v.selected_inventory != undefined) {
                    var inventory_id = v.selected_inventory.id;
                   
                    // console.log(888, number);
                    let inventory_category_id = (v.selected_iventory_category != undefined)?v.selected_iventory_category.id:'';
                    let inventory_site_id = (v.selected_iventory_site != undefined)?v.selected_iventory_site.site_id:'';

                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                member_id: v.member_id,
                                method_name: 'itemSearchSale',
                                inventory_id: inventory_id,
                                inventory_category_id: inventory_category_id,
                                // inventory_brand_id: inventory_brand_id,
                                inventory_site_id: inventory_site_id,
                                // number: number,
                            }
                        })
                        .then(function(response) {
                            if (response.data.length > 0) {

                                var checkD = true;
                                @if(NotDuplicateItem() =="true")
                                if (v.inventories != null && response.data[0].id) {
                                    for (var i = 0; i < v.inventories.length; i++) {
                                        if (v.inventories[i].item && v.inventories[i].item != null) {
                                            if (v.inventories[i].item.id == response.data[0].id) {
                                                checkD = false;
                                            }
                                        }
                                    }
                                }
                                @endif

                                var rate = 0;
                                var static_rate = 0;
                                if (v.selected_currency.rate > 0) {
                                    rate = v.selected_currency.rate;
                                    static_rate = v.selected_currency.static_rate;
                                }

                                if (checkD) {
                                    v.selected_item = null;
                                    v.selected_iventory_site = null;
                                    v.selected_item = response.data[0];
                                    @if(systemConfig()[30] == 1)
                                    v.selected_price = (Number.parseFloat(response.data[0].rate) * static_rate /  Number.parseFloat(rate)).toFixed(precision());
                                    @else 
                                    v.selected_price = (Number.parseFloat(response.data[0].rate) * Number.parseFloat(rate)).toFixed(precision());
                                    @endif
                                    v.inventory_sites1 = response.data[0].site_list;  
                                    v.last_item_sale = response.data[0].last_item_sale;  
                                    v.last_item_purchase = response.data[0].last_item_purchase;  
                                    v.AdvancePrice = response.data[0].advance_price;
                                    v.AdvancePrice_cost = response.data[0].advance_price_cost;
                                    // console.log(123, response.data[0]);
                                }else{
                                    v.selected_inventory = null;
                                    v.selected_inventory1 = null;
                                    v.counter_check = 0;
                                    v.temp_items = [];
                                    v.selected_item = null;
                                    v.selected_price = 0;
                                    v.selected_quantity = 0;
                                    v.$refs.barcode_search.$refs.search.focus();
                                }
                            }else{
                                // $('#success-sound')[0].play();
                                // $('#error-sound')[0].play();
                                v.item_not_found = true;
                                setTimeout((function () {
                                    v.item_not_found = false;
                                    v.$refs.barcode_search.focus();
                                }), 2e3)
                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        })

                }
            },

            changeMesurss() {
                setTimeout(() => {
                    if (v.selected_item) {
                        if (v.selected_item.measure && v.selected_item.measure_unit && v.selected_currency) {
                            var rate = v.selected_currency.rate;
                            var static_rate = v.selected_currency.static_rate;
                            @if(systemConfig()[30] == 1)
                            v.selected_price = (((Number.parseFloat(v.selected_item.rate) / Number.parseFloat(v.selected_item.measure_unit)) * Number.parseFloat(v.selected_item.measure.measure_unit)) * static_rate / Number.parseFloat(rate)).toFixed(precision());
                            @else 
                            v.selected_price = (((Number.parseFloat(v.selected_item.rate) / Number.parseFloat(v.selected_item.measure_unit)) * Number.parseFloat(v.selected_item.measure.measure_unit)) * Number.parseFloat(rate)).toFixed(precision());
                            @endif
                        }
                    } 
                }, 300);
            },

            addData() {
                if (v.selected_item && v.selected_quantity > 0) {
                    v.selected_quantity_error = false;
                    v.AdvancePrice = null;
                    v.AdvancePrice_cost = null;
                    var che = null;
                    for (var i = 0; i < v.inventories.length; i++) {
                        if (v.inventories[i].item && v.inventories[i].item != null) {
                            che = 'ok';
                        } else {
                            v.inventories.splice(i, 1);
                        }
                    }
                    if(!che){
                        v.inventories = [];
                    }

                    let inventory_site_id = (v.selected_iventory_site != undefined)?v.selected_iventory_site.site_id:'';
                    if (inventory_site_id) {
                        for (var i = 0; i < v.selected_item.site_list.length; i++) {
                            if (v.selected_item.site_list[i].site_id == inventory_site_id) {
                                v.selected_item.site = v.selected_item.site_list[i];
                            }
                        }
                    }

                    var rate = 0;
                    var static_rate = 0;
                    if (v.selected_currency.rate > 0) {
                        rate = v.selected_currency.rate;
                        static_rate = v.selected_currency.static_rate;
                    } 
                    v.selected_item.quantity = (v.selected_quantity > 0)?v.selected_quantity:1;
                    @if(systemConfig()[30] == 1)
                    v.selected_item.new_rate = (v.selected_price > 0)?(Number.parseFloat(v.selected_price) / static_rate * Number.parseFloat(rate)):1;
                    @else 
                    v.selected_item.new_rate = (v.selected_price > 0)?(Number.parseFloat(v.selected_price) / Number.parseFloat(rate)):1;
                    @endif
                    // push add index at the end of array
                    // unshift add index at the begin of array
                    v.inventories.unshift({
                        inventory: v.selected_item,
                        item: v.selected_item,
                        location: null,
                        selected_taxation: null,
                        tax: 'on',
                        sub_total: v.selected_item.sub_total_stat,
                        item_category: v.selected_item.item_category,
                        item_brand: v.selected_item.inventory_brand,
                        price_level:null
                    });

                    v.selected_inventory = null;
                    v.selected_inventory1 = null;
                    v.counter_check = 0;
                    // v.temp_items = [];
                    v.selectSaleNumber(0,0);
                    @if(getShwoPriceLevel()=="general_percent")
                    setTimeout((function () {
                        v.change_sale_rate_by_price_level_general();
                    }), 400);
                    @endif

                    // const inp = v.$refs.barcode_search.$refs.search;
                    // console.log(v.$refs.barcode_search.$refs.search.value);
                    v.$refs.barcode_search.$refs.search.focus();
                    // v.$refs.barcode_search.$refs.search = null;
                    // v.$refs.barcode_search.focus();

                    v.selected_item = null;
                    v.selected_price = 0;
                    v.selected_quantity = 0;
                    
                }else{
                    v.$refs.selected_quantity.focus();
                    v.selected_quantity_error = true;
                }
            },
            
            resetData() {
                v.AdvancePrice = null;
                v.AdvancePrice_cost = null;
                v.selected_inventory = null;
                v.selected_item = null;
                v.temp_items = [];
                v.selected_iventory_site = null;
                v.selected_price = 0;
                v.selected_quantity = 0;
                v.$refs.barcode_search.$refs.search.focus();
            },

            // changeLength() {
            //     if(this.$refs.in){
            //         this.$refs.in.forEach((data) => {
            //             if (data) {
            //                 var newdata = data.style.width=((data.value.length+10)*8)+'px';
            //                 return newdata;
            //             }
            //         })
            //     }
            // },

            // end item search
            setIndex(index, c_index) {
                this.selected_index = index;
                this.selected_currency_index = c_index;
            },
            inventorySiteChange(index,c_index) {
                v.setIndex(index,c_index);

                v.selected_iventory_site = this.multi_currency[c_index].inventories[index]['inventory_site'];
                if (this.multi_currency[c_index].inventories[index]['inventory_site'] != null) {
                    let inventory_site_id = this.multi_currency[c_index].inventories[index]['inventory_site'].id;
                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                member_id: v.member_id,
                                method_name: 'itemesSearchSale',
                                inventory_site_id: inventory_site_id
                            }
                        })
                        .then(function(response) {
                            if (v.purchase_orders) {} else {
                                v.multi_currency[c_index].inventories[index]['item'] = null;
                                v.multi_currency[c_index].inventories[index]['inventory'] = null;
                            }
                            v.temp_items = [];
                            if (response.data.length > 0) {
                                v.temp_items = response.data;
                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        });
                }

            },

            itemCategoryChange(index,c_index) {
                v.setIndex(index,c_index);

                v.selected_iventory_category = this.multi_currency[c_index].inventories[index]['item_category'];
                if (this.multi_currency[c_index].inventories[index]['item_category'] != null) {

                    let inventory_brand_id = (v.multi_currency[c_index].inventories[index]['item_brand'] != undefined) ? v.multi_currency[c_index].inventories[index]['item_brand'].id : '';
                    
                    let inventory_category_id = this.multi_currency[c_index].inventories[index]['item_category'].id;
                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                member_id: v.member_id,
                                method_name: 'itemesSearchSale',
                                inventory_category_id: inventory_category_id,
                                inventory_brand_id: inventory_brand_id
                            }
                        })
                        .then(function(response) {
                            if (v.purchase_orders) {} else {
                                v.multi_currency[c_index].inventories[index]['item'] = null;
                                v.multi_currency[c_index].inventories[index]['inventory'] = null;
                            }
                            v.temp_items = [];
                            if (response.data.length > 0) {
                                v.temp_items = response.data;
                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        });
                }

            },

            itemBrandChange(index,c_index) {
                v.setIndex(index,c_index);

                v.selected_iventory_brand = this.multi_currency[c_index].inventories[index]['item_brand'];
                if (this.multi_currency[c_index].inventories[index]['item_brand'] != null) {
                    let inventory_category_id = (v.multi_currency[c_index].inventories[index]['item_category'] != undefined) ? v.multi_currency[c_index].inventories[index]['item_category'].id : '';
                    let inventory_brand_id = this.multi_currency[c_index].inventories[index]['item_brand'].id;
                    
                    axios.get("{{route('callMethod.search')}}", {
                            params: {
                                member_id: v.member_id,
                                method_name: 'itemesSearchSale',
                                inventory_category_id: inventory_category_id,
                                inventory_brand_id: inventory_brand_id
                            }
                        })
                        .then(function(response) {
                            if (v.purchase_orders) {} else {
                                v.multi_currency[c_index].inventories[index]['item'] = null;
                                v.multi_currency[c_index].inventories[index]['inventory'] = null;
                            }
                            v.temp_items = [];
                            if (response.data.length > 0) {
                                v.temp_items = response.data;
                            }
                        })
                        .catch(function(error) {
                            console.log(error);
                        });
                }

            },
            // contract search


            saleOrderSearch(id, vm) {
                vm.saleOrderList = [];
                axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'memberSaleOrder',
                            member_id: id,
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            vm.showModalSaleOrder = true;
                            vm.saleOrderList = response.data;
                            // console.log('sale order', response.data);
                        }
                        // loading(false);
                    })
                    .catch(function(error) {
                        console.log(error);
                    })
            },
            getsalesOrders() {
                this.showModalSaleOrder = false;
                this.selected_class = _.find(this.memberClass, (c) => c.id == this.selected_sale_order.class_id);
                axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'SaleOrderItems',
                            sale_order_id: this.selected_sale_order.id,
                            type: 'saleOrder'
                        }
                    })
                    .then(function(response) {
                        if (response.data.length > 0) {
                            console.log('myrespo', response.data);
                            v.inventories = [];
                            v.services = [];
                            for (var r = 0; r < response.data.length; r++) {
                                if (response.data[r].type == 'item') {
                                    v.inventories.push({
                                        inventory: response.data[r],
                                        item: response.data[r],
                                        location: response.data[r].selectedLocation,
                                        item_category: response.data[r].item_category,
                                        item_brand: null,
                                        tax: 'on',
                                        selected_taxation: null,
                                        sub_total: ''
                                    });
                                }
                                if (response.data[r].type == 'service') {
                                    v.services.push({item: response.data[r], items: v.all_services, quantity: response.data[r].quantity, new_rate: response.data[r].new_rate});
                                }
                            }
                            v.inventories.push({
                                inventory: null,
                                item: null,
                                location: null,
                                item_category: null,
                                item_brand: null,
                                tax: 'on',
                                selected_taxation: null,
                                sub_total: ''
                            });
                            v.services.push({item: null, items: all_services, quantity: 0, new_rate: 0});
                            // console.log('test check', v.selected_sale_order);

                            v.purchase_orders = true;

                            v.discountFiled = v.selected_sale_order.discount;
                            
                            if (v.selected_sale_order.discount_type) {
                                if (v.selected_sale_order.discount_type == 'currency') {
                                    v.discountIsAmount = true;
                                } else {
                                    v.discountIsAmount = false;
                                }
                            }

                            v.invoiceDescription = v.selected_sale_order.description;
                            v.selected_area = v.selected_sale_order
                            v.selected_area = _.find(v.saleArea, (c) => c.id == v.selected_sale_order.sale_area_id);


                            for (var a = 0; a < this.currency.length; a++) {
                                if (v.currency[a].code == v.selected_sale_order.currency) {
                                    v.selected_currency = v.currency[a];
                                    v.selected_currency.rate = v.selected_sale_order.rate;
                                    v.rate = v.selected_sale_order.rate;
                                }
                            }
                        }
                    })
                    .catch(function(error) {
                        console.log(error);
                    })
            },
            // end contract search

            // generic function for adding item to list
            addNewCurrency(index) {
                if (this.multi_currency[index + 1] == undefined) {
                    this.multi_currency.push({
                        sum: 0,
                        sum_sub: 0,
                        sum_discount: 0,
                        all_discount: 0,
                        payment: 0,
                        currency: null,
                        allCurency: currency,
                        transfer_rent_bank_selected:null,
                        transfer_rent_vendor_selected:null,
                        transfer_rent_type:null,
                        services: [{
                                items: all_services,
                                item: null,
                                quantity: 0,
                                new_rate: 0
                            },
                            {
                                items: all_services,
                                item: null,
                                quantity: 0,
                                new_rate: 0
                            },
                        ],
                        inventories: [{
                            inventory: null,
                            item: null,
                            location: null,
                            item_category: null,
                            item_brand: null,
                            tax: 'on',
                            selected_taxation: null,
                            sub_total: '',
                            inventory_site: null,
                            price_level: null
                        }],
                        payments: [{
                            items: banks,
                            item: null
                        }],
                        driver_data: [{
                            cost: null,
                            description: null,
                            description2: null,
                            driver_name: null,
                            other_measure: null,
                            other_measure2: null,
                            vehicle_name: null,
                            wagon_number: null
                            }
                        ]

                    });
                }
            },

            // generic function for adding item to list
            addNew(type = null, index = 0, c_index = 0) {
                v.selected_index = index;
                v.selected_currency_index = c_index;

                if (v.multi_currency[c_index].inventories[index] != undefined) {
                    v.selected_iventory_category = this.multi_currency[c_index].inventories[index]['item_category'];
                    v.selected_iventory_brand = this.multi_currency[c_index].inventories[index]['item_brand'];
                    v.selected_iventory_site = this.multi_currency[c_index].inventories[index]['inventory_site'];
                    @if(getShwoPriceLevel()=="general_percent")
                    this.change_sale_rate_by_price_level_general();
                    @endif
                }
                // this.temp_items = [];
                if (type != null) {
                    if (type == 'inventory') {
                        if (this.multi_currency[c_index].inventories[index + 1] == undefined) {
                            this.temp_items = [];
                            this.multi_currency[c_index].inventories.push({ 
                                inventory: null,
                                item: null,
                                location: null,
                                item_category: this.selected_iventory_category,
                                item_brand: this.selected_iventory_brand,
                                tax: 'on',
                                selected_taxation: null,
                                sub_total: '',
                                inventory_site: this.selected_iventory_site,
                                price_level: null
                            });
                        }


                    }
                    if (type == 'service') {
                        if (this.multi_currency[c_index].services[index + 1] == undefined) {
                            this.checkExistingService(index,c_index,'');
                            this.multi_currency[c_index].services.push({
                                items: this.all_services,
                                item: null,
                                quantity: 0,
                                new_rate: 0
                            });
                        }
                    }
                    if (type == 'payment') {
                        if (this.multi_currency[c_index].payments[index + 1] == undefined) {
                            this.checkExistingPayment(index,c_index,'');
                            this.multi_currency[c_index].payments.push({
                                items: this.banks,
                                item: null,
                            });
                        }
                    }
                    if (type == 'payment_invoice') {
                        if (this.payment_invoices[index + 1] == undefined) {
                            this.payment_invoices.push({
                                items: null,
                                item: null,
                                selected_payment_currency: null
                            });
                        }
                    }
                }

            },
            // in here you can check and decide to allow duplicate bank for payment or not
            checkExistingPayment(index,c_index,name = '') {
                var bank_temp = banks.slice();
                for (var i = 0; i < this.multi_currency[c_index].payments.length; i++) {
                    if (this.multi_currency[c_index].payments[i].item != null) {
                        var fined = bank_temp.findIndex((item) => item.name == this.multi_currency[c_index].payments[i].item.name);
                        if (fined != -1) {
                            var o = bank_temp.splice(bank_temp.findIndex((item) => item.name == this.multi_currency[c_index].payments[i].item.name), 1);
                        }
                    }
                }
                this.multi_currency[c_index].payments[index].items = bank_temp.filter((item) => {
                    return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                });
                //this.multi_currency[c_index].payments[index].items =bank_temp;
            },
            // in here you can check and decide to allow duplicate service or not
            checkExistingService(index,c_index, name = '') {
                var service_temp = all_services.slice();
                var service_temp1 = [];
                for (var i = 0; i < this.multi_currency[c_index].services.length; i++) {
                    if (this.multi_currency[c_index].services[i].item != null) {
                        var fined = service_temp.findIndex((item) => item.name == this.multi_currency[c_index].services[i].item.name);
                        if (fined != -1) {
                            var o = service_temp.splice(service_temp.findIndex((item) => item.name == this.multi_currency[c_index].services[i].item.name), 1);
                        }
                    }
                }
                this.multi_currency[c_index].services[index].items = service_temp.filter((item) => {
                    return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                });
                //this.payments[index].items =bank_temp;
            },
            // in here you can check and decide to allow duplicate service or not
            service_rate(index,c_index) {
                if (this.multi_currency[c_index].services[index].item != null) {
                    this.multi_currency[c_index].services[index].new_rate = this.multi_currency[c_index].services[index].item.new_rate;
                }
            },
            
            // in here you can check and decide to allow duplicate service or not
            checkExistingCurrency(index, code = '') {
                var temp_currency = this.currency.slice();
                for (var i = 0; i < this.multi_currency.length; i++) {
                    if (this.multi_currency[i].currency != null) {
                        var fined = temp_currency.findIndex((item) => item.code == this.multi_currency[i].currency.code);
                        if (fined != -1) {
                            var o = temp_currency.splice(temp_currency.findIndex((item) => item.code == this.multi_currency[i].currency.code), 1);
                        }
                    }
                }
                
                this.multi_currency[index].allCurency = temp_currency.filter((item) => {
                    return (new RegExp(code.toLowerCase())).test(item.code.toLowerCase())
                });
            },
            
            // delete item from list
            deleteItem(type = null, index) {
                this.editKey = false;
                if (type != null) {

                    if (type == 'inventory') {
                        this.inventories.splice(index, 1);
                    }
                    if (type == 'return') {
                        this.inventory_return.splice(index, 1);
                    }
                    if (type == 'service') {
                        this.services.splice(index, 1);
                    }
                    if (type == 'payment') {
                        this.payments.splice(index, 1);
                    }
                    if (type == 'payment_invoice') {
                        this.payment_invoices.splice(index, 1);
                    }
                }

            },

            // delete item from list
            deleteCurrency(index) {
                this.editKey = false;
                this.multi_currency.splice(index, 1);
            },

            // submit the form
            submitForm() {

                if (this.isError == true) {
                    alert('there is no item');
                    return false;
                }
                v.disabled = true;
                swal({
                    title: "@lang('layout.AreYouSure?')",
                    buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                    text: "",
                    icon: "info",
                    dangerMode: true,
                }).then((willDelete) => {
                    if (willDelete) {
                        document.getElementById("sales-form").submit()
                    } else {
                        v.disabled = false;
                    }
                });

            },
            // submit the form
            showInfo(index,c_index) {
                if (v.multi_currency[c_index].inventories[index].item != null) {
                    v.showInfoModal = true;
                    v.brand = v.multi_currency[c_index].inventories[index]['item']['brand'];
                    v.location = v.multi_currency[c_index].inventories[index]['item']['location'];
                    v.SNumber = v.multi_currency[c_index].inventories[index]['item']['number'];
                    v.AdvancePrice = v.multi_currency[c_index].inventories[index]['item']['advance_price'];
                    v.on_hand = v.multi_currency[c_index].inventories[index]['item']['on_hand'];
                    v.measure_name = v.multi_currency[c_index].inventories[index]['item']['measure']['measure_name'];
                    v.last_item_sale = v.multi_currency[c_index].inventories[index]['item']['last_item_sale'];
                    v.width = v.multi_currency[c_index].inventories[index]['item']['width'];
                    v.length = v.multi_currency[c_index].inventories[index]['item']['length'];
                    v.height = v.multi_currency[c_index].inventories[index]['item']['height'];
                    
                    // console.log('ffff',v.multi_currency[c_index].inventories[index]['item']);
                    // if(v.seeCost==true){
                    @if(systemConfig()[30] == 1)
                    v.cost = (v.multi_currency[c_index].inventories[index]['item']['LasCost'] * v.multi_currency[c_index].currency.static_rate / v.multi_currency[c_index].currency.rate);
                    @else 
                    v.cost = (v.multi_currency[c_index].inventories[index]['item']['LasCost'] * v.multi_currency[c_index].currency.rate);
                    @endif
                    // }
                }

            },
            defaultValue() {
                this.selected_customer = null;
                this.selected_index = 0;

                this.inventories = [{
                    inventory: null,
                    item: null,
                    item_category: this.selected_iventory_category,
                    tax: 'on',
                    selected_taxation: null,
                    sub_total: ''
                }, ];
                this.services = [{
                        items: all_services,
                        item: null,
                    },
                    {
                        items: all_services,
                        item: null,
                    },
                ];
                this.payments = [{
                    items: all_services,
                    item: null,
                }];

                this.invoiceDescription = null;
                this.saleOrderList = [];
                this.selected_sale_order = null;
                this.member_id = null;
                this.discountFiled = 0;
                this.temp_items = [];
            },
            saveAndNew() {
                this.$validator.validate()
                    .then(valid => {
                        if (valid) {
                            if (v.member_chack() == 'true') {
                                var r = confirm("@lang('layout.member_payable_levels')");
                                if (r == true) {
                                    v.disabled = true;
                                    var url = "{{route('invoice.storeMultiple')}}";
                                    form_id = 'sales-form';
                                    var data = $('#' + form_id).serialize();
                                    toggleBlock(true);
                                    axios.post(url, data)
                                        .then(function(response) {
                                            toggleBlock(0);
                                            // console.log('sss11', response.data);
                                            if (response.data.result == 1) {
                                                $('#' + form_id).trigger('reset');
                                                //$('#success-sound')[0].play();
                                                toastr.success('', response.data.message);
                                                v.number = Number(v.old_number) + 1;
                                                v.old_number = Number(v.old_number) + 1;
                                                v.ref_no = null;
                                                // v.defaultValue();
                                                // factorPrint(response.data.sale_id)
                                                location.reload();
                                            } else {
                                                v.disabled = false;
                                                var message = "{{__('message.Warning')}}";
                                                //$('#error-sound')[0].play();
                                                // toastr.warning('', message);
                                                toastr.warning('', response.data[1]);
                                            }
                                        })
                                        .catch(function(error) {
                                            toggleBlock(0);
                                            v.disabled = false;
                                            // console.log(error,v.disabled);
                                            var message = "{{__('message.Warning')}}";
                                            //$('#error-sound')[0].play();
                                            toastr.warning('', message);
                                        });
                                }
                            } else {

                                v.disabled = true;
                                var url = "{{route('invoice.storeMultiple')}}";
                                form_id = 'sales-form';
                                var data = $('#' + form_id).serialize();
                                toggleBlock(true);
                                axios.post(url, data)
                                    .then(function(response) {
                                        toggleBlock(0);
                                        // console.log('sss11', response.data);
                                        if (response.data.result == 1) {
                                            $('#' + form_id).trigger('reset');
                                            //$('#success-sound')[0].play();
                                            toastr.success('', response.data.message);
                                            v.number = Number(v.old_number) + 1;
                                            v.old_number = Number(v.old_number) + 1;
                                            v.ref_no = null;
                                            // v.defaultValue();
                                            // factorPrint(response.data.sale_id)
                                            location.reload();
                                        } else {
                                            v.disabled = false;
                                            var message = "{{__('message.Warning')}}";
                                            //$('#error-sound')[0].play();
                                            // toastr.warning('', message);
                                            toastr.warning('', response.data[1]);
                                        }
                                    })
                                    .catch(function(error) {
                                        toggleBlock(0);
                                        v.disabled = false;
                                        // console.log(error,v.disabled);
                                        var message = "{{__('message.Warning')}}";
                                        //$('#error-sound')[0].play();
                                        toastr.warning('', message);
                                    });
                            }

                        }
                    })
            },

            saveTemp() {
                var url = "{{route('temp.store')}}";
                form_id = 'sales-form';
                var data = $('#' + form_id).serialize();
                axios.post(url, data)
                .then(function(response) {
                    // console.log('sss11', response);
                    callSaveTemp();
                })
                .catch(function(error) {
                    console.log(error);
                    callSaveTemp();
                });
            },
            saveTempToShow() {
                var url = "{{route('temp.store')}}";
                form_id = 'sales-form';
                var data = $('#' + form_id).serialize();
                axios.post(url, data)
                .then(function(response) {
                    // console.log('sss11', response);
                    callSaveTempToShow();
                })
                .catch(function(error) {
                    console.log(error);
                    callSaveTempToShow();
                });
            },
            clearTemp() {
                axios.get("{{route('temp.clear')}}", {
                    params: {
                        type: 'invoice'
                    }
                })
                .then(function(response) {
                    console.log('sss11', response);
                })
                .catch(function(error) {
                    console.log(error);
                });
            },
        },
    });

 
</script>



@endpush