@extends('layouts.app')
<link href="{{url('css/custome-table.css')}}" rel="stylesheet" type="text/css">

<style>
    .paid_stamp{
        
        width: 160px;
        height: 80px;
        /* background-color: gray; */
        font-size: 60px;
        font-weight: bold;
        -ms-transform: rotate(-20deg);
        transform: rotate(-20deg);
        padding: 5px;
        text-shadow: 3px 3px;
        @if(session()->get("system_direction") == "rtl")
        margin-right:60%;
        @else
        margin-left:60%;
        @endif
    }     
    

</style>

@section('content')
    @include("layouts.Cmodal")
    @include("invoices.modal")
    <div class="row">
        <div class="portlet light bordered ">
            <!-- BEGIN TAB PORTLET-->
            <div class="portlet light bordered sale">
                <div class="portlet-title">
                    <div class="caption">
                        <i class="icon-anchor font-green-sharp"></i>&nbsp;
                        <span class="caption-subject font-green-sharp bold uppercase">@lang('layout.EditInvoice') </span>
                    </div>
                    <div class="actions">                    
                    </div>

                    @if($paid_stamp!='')
                        <div  class="paid_stamp">{{$paid_stamp}}
                        <span style="font-size: 25px; text-shadow: 0px 0px;">{{$paid_date}}</span>
                        </div>
                    @endif
                </div>
                
                
                <div id="appInvoice" class="portlet-body">

                    <div class="tabbable tabbable-tabdrop">

                        <div>
                            {{Form::model($invoice,['route' => ['invoice.add_store',$invoice->id],'method' => 'PATCH','class' => 'form-horizontal','id'=>'sales-form'])}}
                            {{ csrf_field() }}
                            <div class="tab-content">

                                <div class="tab-pane active" id="tab1">

                                    <div id="appInvoice" v-cloak class="portlet-body form" style="margin-bottom:50%;">
                                        <!-- begin sale order modal -->

                                        <!-- end sale order modal -->

                                        <!-- BEGIN FORM-->

                                        <div class="form-body">
                                            <div class="row">
                                                <div class="col-lg-9 col-md-9 col-sm-12 col-xs-12">
                                                    <!-- begin inputs -->
                                                    <div class="row">

                                                        <div v-show="showWhat('sale_area')=='yes'"
                                                             class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                            <div class="form-group">

                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.SaleArea')</label>

                                                                    <v-select label="name" :options="saleArea"
                                                                              v-model="selected_area"></v-select>
                                                                    <input type="hidden" name="sale_area_id"
                                                                           :value="!selected_area?null:selected_area.id">
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12"
                                                             v-show="showWhat('member_class')=='yes'">
                                                            <div class="form-group">

                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.MemberClass')</label>

                                                                    <v-select label="name" :options="memberClass"
                                                                              v-model="selected_class"
                                                                              @input="memberClassChange()"></v-select>
                                                                    <input type="hidden" name="class_id"
                                                                           :value="!selected_class?null:selected_class.id">
                                                                </div>
                                                            </div>
                                                        </div>
                                                        @if(getShwoPriceLevel()=="general")
                                                        <div 
                                                          class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                            <div class="form-group">

                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.PriceLevel') </label>

                                                                    <v-select 
                                                                    label="name" 
                                                                    :options="priceLevel"
                                                                    v-model="selected_priceLevel"
                                                                    >
                                                                </v-select>
                                                                     <input type="hidden" name="price_level_id"
                                                                        :value="!selected_priceLevel?null:selected_priceLevel.id" >
                                                                </div>
                                                            </div>
                                                        </div> 
                                                        @endif
                                                        @if(getShwoPriceLevel()=="general_percent")
                                                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                            <div class="form-group">

                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.PriceLevel') </label>
                                                                    <v-select label="name" :options="priceLevelGeneral" v-model="selected_priceLevelGeneral" >
                                                                    </v-select>
                                                                    <input type="hidden" name="price_level_id" :value="!selected_priceLevelGeneral?null:selected_priceLevelGeneral.id">
                                                                </div>
                                                            </div>
                                                        </div>
                                                        @endif

                                                        @if(systemConfig()[13] != 0 )
                                                            <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                                <label class="control-label">@lang('menu.Membercloth')</label>
                                                                <v-select class="vue-select2" label="name"
                                                                        :options="member_cloth_list" v-model="selectedMemberCloth">
                                                                </v-select>
                                                                <input type="hidden" name="member_cloth_id"
                                                                    v-model.number="(!selectedMemberCloth)?null:selectedMemberCloth.id">
                                                            </div>
                                                    @endif 


                                                    </div>
                                                    <div class="row">
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <div class="form-group">
                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.Customer')</label>
                                                                    <!-- <div class="input-group"> -->
                                                                        <v-select label="name" @input="memberChange(),getSummary()"
                                                                        @search="MemberSearch" :options="customer" v-model="selected_customer" disabled></v-select>
                                                                        <input type="hidden" name="customer" :value="!selected_customer?null:selected_customer.id" required>
                                                                        <!-- <span class="btn btn-success input-group-addon " title="@lang('button.AddNewCustomer')" @click="showModal = true" style="background-color:  rgb(84, 199, 211)">
                                                                            <i class="fa fa-plus" style="color: white"></i>
                                                                        </span> 
                                                                    </div> -->
                                                                </div>
                                                            </div>
                                                        </div>

                                                         <div v-show="showWhat('descriptionASMemberName')=='yes'" class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                                <div  class="form-group">
                                                                    <div class="col-md-12">
                                                                        <label class=" control-label">@lang('layout.OtherMemberName')</label>
                                                                        <div>
                                                                        <input type="text" name="other_member_name"  value="{{$invoice->other_member_name}}"  class="form-control">
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                           </div>

                                                        <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                            <div class="form-group">

                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.InvoiceNumber')</label>

                                                                    <input type="number" name="number"
                                                                           value="{{$invoice->number}}"
                                                                           class="form-control" readonly>
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                            <div class="form-group">

                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.ReferenceNumber')</label>

                                                                    <input type="text" name="ref_no" v-model="ref_no"
                                                                           class="form-control" @input="checkRefNo()">
                                                                    <span v-if="isError1 ==true" class="input-has-error"
                                                                          style="color: red">@{{msg}}</span>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        @if(getFactorPending()=="true")
                                                        <!-- <div class="col-md-1 " style="padding: 0px !important;">
                                                            <label class=" control-label">@lang('layout.Factor') @lang('layout.Pending')</label>
                                                            <div>
                                                                <label class="mt-checkbox mt-checkbox-outline">
                                                                    <input type="checkbox" name="pending" value="on" <?php if($invoice->pending == 'on'){ echo "checked"; } ?> >
                                                                    <span></span>
                                                                </label>
                                                            </div>
                                                        </div> -->
                                                        @endif

                                                    </div>

                                                    <div class="row">

                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <div class="form-group">

                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.Currency')</label>


                                                                    <v-select label="code" @input="selectedRate"
                                                                              :options="currency"
                                                                              v-model="selected_currency" disabled></v-select>
                                                                    <input type="hidden" name="currency"
                                                                           :value="selected_currency.code">

                                                                </div>
                                                            </div>
                                                        </div>

                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <div class="form-group">

                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.Rate')</label>

                                                                    <input type="number" name="currency_rate"
                                                                           name="rate"
                                                                           v-model="!selected_currency?0:selected_currency.rate"
                                                                           class="form-control"
                                                                           :class="{'has-error':rate<=0}">

                                                                    <input type="hidden" name="currency_rate_hq"
                                                                           v-model="!selected_currency?0:selected_currency.hq_rate"
                                                                           class="form-control">
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <div class="form-group">

                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.Discount')</label>

                                                                    <div class="input-group">

                                                                        <input v-model="discountFiled"
                                                                               class="form-control"
                                                                               type="number" min="0" max="100" readonly>
                                                                        <span v-if="discountIsAmount"
                                                                              @click="discountIsAmount = !discountIsAmount"
                                                                              class="input-group-addon">@{{selected_currency.symbol}}
                                                              <input type="hidden" class="input-group-addon"
                                                                     name="discount_type" value="currency">
                                                          </span>
                                                                        <span v-else
                                                                              @click="discountIsAmount = !discountIsAmount"
                                                                              class="input-group-addon">%
                                                              <input type="hidden" name="discount_type" value="percent">
                                                          </span>
                                                                        <input type="hidden" name="discountTotal"
                                                                               :value="discount">
                                                                        <input type="hidden" name="discount"
                                                                               :value="discountFiled">
                                                                    </div>

                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>

                                                    <div class="row">

                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <div class="form-group">
                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.Description')</label>
                                                                    <textarea name="description" class="form-control"
                                                                              rows="1">{{$invoice->description}}</textarea>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <div class="form-group">

                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.Date')</label>

                                                                    <input type="text" name="date"
                                                                           class="form-control date"
                                                                           value="{{$invoice->date}}"
                                                                           autocomplete="off">
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <div class="form-group">

                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.OverdueDate')</label>

                                                                    <input type="text" name="overdue_date"
                                                                           class="form-control date"
                                                                           value="{{$invoice->overdue_date}}"
                                                                           autocomplete="off">
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
													
													<!--Begin Taxation -->
                                                @if(getTaxation()=="true")
												<div class="row">
                                                  <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <div class="form-group">

                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.Tax')</label>
                                                                        <v-select 
                                                                            v-model="selected_taxation"
                                                                            label="name" :options="taxation" disabled>
                                                                        </v-select>
                                                                          <input type="hidden" name="taxation_id" :value="!selected_taxation?null:selected_taxation.id" />
                                                                          <input type="hidden" name="taxation_vendor_id" :value="!selected_taxation?null:selected_taxation.member_id" />
																		  <input type="hidden" name="taxation_value" :value="subTotalTax" readonly />
                                                                </div>
                                                            </div>
                                                        </div>
												    <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
														<div class="form-group">

															<div class="col-md-12">
																<label class="control-label">@lang('layout.Percentage') %</label>
																	<input type="number" name="percent_tax" class="form-control" 
																	   v-model="!selected_taxation?null:selected_taxation.percent">
															</div>
														</div>
												   </div>
												</div>
												@endif
                                                <!--End Taxation -->

                                                <div class="row">
                                                    <!--Begin commission -->
                                                    @if(getSaleCommission()=="true")
                                                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                            <div class="form-group">

                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.Commission')</label>
                                                                    <v-select v-model="selected_commission" label="name" :options="commission" disabled>
                                                                    </v-select>
                                                                    <input type="hidden" name="commission_id" :value="!selected_commission?null:selected_commission.id" />
                                                                    <input type="hidden" name="commission_vendor_id" :value="!selected_commission?null:selected_commission.member_id" />
                                                                    <input type="hidden" name="commission_value" :value="subTotalCommi" readonly />
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                            <div class="form-group">

                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.Percentage') %</label>
                                                                    <input type="number" name="commission_percent" class="form-control" v-model="!selected_commission?null:selected_commission.percent" readonly>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    @endif
                                                    <!--End commission -->
                                                </div>

                                                <!--Begin Sale Discount Date -->
                                                @if(getSaleDiscountDate()=="true")
												<div class="row">
                                                  <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                            <div class="form-group">

                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('menu.DiscountDate')</label>
                                                                        <v-select 
                                                                            v-model="selected_discount_date"
                                                                            label="name" :options="discount_date" >
                                                                        </v-select>
                                                                          <input type="hidden" name="discount_date_id" :value="!selected_discount_date?null:selected_discount_date.id" />
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
												@endif
                                                <!--End Sale Discount Date -->

                                                    <!--Begin Alerts-->
                                                    @if(getChangeItem()=="true")
                                                        <div class="row">
                                                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                                <div class="form-group">

                                                                    <div class="col-md-12">
                                                                        <label class="control-label">@lang('layout.ExDate')</label>

                                                                        <input type="text" name="alert_date"
                                                                               value="{{$invoice->alertDate}}"
                                                                               class="form-control date"
                                                                               autocomplete="off">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                                <div class="form-group">
                                                                    <div class="col-md-12">
                                                                        <label class="control-label">@lang('layout.ExDescription')</label>
                                                                        <textarea name="alert_description"
                                                                                  class="form-control"
                                                                                  rows="1">{{$invoice->alert_description}}</textarea>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                @endif
                                                <!--End Alerts-->

                                                <!--Begin Transport Company-->
                                              @if(getTransportCompany()=="true")
                                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                    <div class="form-group">

                                                      <div class="col-md-12">
                                                        <label class="control-label">@lang('menu.TransportCompany')</label>
                                                          <v-select 
                                                            v-model="selected_transportCompany"
                                                            label="name" 
                                                            :options="transportCompany"
                                                            @input="getDrivers"
                                                            @click.native="getAllDrivers"
                                                            >
                                                              
                                                          </v-select>

                                                            <input type="hidden" name="transportCompany_id"
                                                             :value="!selected_transportCompany?null:selected_transportCompany.id">
                                                      </div>
                                                    </div>
                                                  </div>
                                                   <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                      <div class="form-group">

                                                        <div class="col-md-12">
                                                          <label class="control-label">@lang('layout.Driver')</label>
                                                                    
                                                            <v-select 
                                                              label="name" 
                                                              :options="t_drivers"
                                                              
                                                              v-model="selected_transportDriver"
                                                              >
                                                                
                                                            </v-select>
                                                            <input type="hidden" name="trasnsport_driver_id"
                                                               :value="!selected_transportDriver?null:selected_transportDriver.id">

                                                            

                                                        </div>
                                                      </div>
                                                     </div>
                                                 @endif
                                              <!--End Transport Company-->
											  @if(getNegativeSale() == 'true')
											  <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
													<div class="col-md-12 form-group">
														<label class=" control-label">@lang('layout.NegativeSale')</label>
														<div class="col-md-12 mt-checkbox">
														 <label class="mt-checkbox mt-checkbox-outline">
														 <input type="checkbox" name="negative_sale" <?php if($invoice->sale_type == 'ok'){echo 'checked';} ?> value="ok" >
														 <span></span>
														 </label>
														</div>
													</div>
											   </div>
                                                 @endif

                                                 @if(getSaleToBase() == 'true')
                                                <div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
                                                    <div class="col-md-12 form-group">
                                                        <label class=" control-label">@lang('layout.SaleBaseCurrency')</label>
                                                        <div class="col-md-12 mt-checkbox">
                                                            <label class="mt-checkbox mt-checkbox-outline">
                                                                <input type="checkbox" name="sale_base_currency" <?php if($invoice->sale_base_currency == 'ok'){echo 'checked';} ?> value="ok">
                                                                <span></span>
                                                            </label>
                                                        </div>
                                                    </div>
                                                </div>
                                                @endif

                                                <!-- end inputs -->
												
												@if(oilSale() == 'true')
												<div class="col-lg-2 col-md-2 col-sm-12 col-xs-12">
													<div class="col-md-12 form-group">
															<label class=" control-label">@lang('layout.Oil')</label>
															<div>
															 <label class="mt-checkbox mt-checkbox-outline">
															 <input type="checkbox" @click="ChangeOil" <?php if($invoice->oil == 1){echo 'checked';} ?> name="oil_sale" value="ok" >
															 <span></span>
															 </label>
															</div>
													</div>
											   </div>
                                                @endif
												@if(getSaleTaxation() == 'true')
												<div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
													<div class="form-group">
														<div class="col-md-12">
															<label class="control-label">@lang('layout.Tax')</label>

															<div class="input-group">

																<input v-model="sale_taxation"
																	   class="form-control"
																	   type="number" min="0" max="100" />
																<span class="input-group-addon">%</span>
																<input type="hidden" name="sale_taxation"
																	   :value="sale_taxation" />
																	   <input type="hidden" name="sale_taxation_value"
																	   :value="saleTaxation" />
															</div>

														</div>
													</div>
												</div>
												@endif
                                                @if(getSaleByOtherMeasure() == "true")
                                                <div class="col-md-4 form-group">
                                                        <label class=" control-label">@lang('layout.PerQty')</label>
                                                        <div>
                                                            <label class="mt-checkbox mt-checkbox-outline">
                                                            <input type="checkbox" name="per_qty_check" v-model="per_qty_check" <?php if($invoice->per_qty == 'on'){echo 'checked';} ?> >
                                                            <span></span>
                                                            </label>
                                                        </div>
                                                </div>
                                                @endif

                                                @if(getSaleByOtherMeasureRate() == "true")
                                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                    <div class="col-md-12 form-group">
                                                        <label class=" control-label">@lang('layout.SaleByOtherMeasureRate')</label>
                                                        <div>
                                                            <label class="mt-checkbox mt-checkbox-outline">
                                                                <input type="checkbox" name="per_qty_check" v-model="per_qty_check" <?php if($invoice->per_qty == 'on'){echo 'checked';} ?> >
                                                                <span></span>
                                                            </label>
                                                        </div>
                                                    </div>
                                                </div>
                                                @endif
                                                @if(ShowSaveTempItemToCustomer() == "true")
                                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12">
                                                    <div class="col-md-12 form-group">
                                                        <label class=" control-label">@lang('layout.SaveTempItemToCustomer')</label>
                                                        <div>
                                                            <label class="mt-checkbox mt-checkbox-outline">
                                                                <input type="checkbox" name="save_temp_item" value="yes" <?php if($invoice->save_temp_item == 'yes'){echo 'checked';} ?> >
                                                                <span></span>
                                                            </label>
                                                        </div>
                                                    </div>
                                                </div>
                                                @endif

                                                <!--Begin search Item-->
                                                <div class="row col-lg-12 col-md-12 col-sm-12 col-xs-12" >
                                                    <div class="col-lg-5 col-md-5 col-sm-12 col-xs-12" style="padding: 0px !important;" >
                                                        <div class="col-lg-8 col-md-8 col-sm-12 col-xs-12"  >
                                                            <div class="form-group">
                                                                <!-- <div class="col-md-12"> -->
                                                                    <!-- <label class="control-label">@lang('layout.ItemName')</label> -->
                                                                    <v-select label="name" ref="barcode_search" @input="loadItemGeneral()"  v-model="selected_inventory" :options="temp_items" @search="onItemSearch" placeholder="@lang('layout.ItemName')" ></v-select>
                                                                <!-- </div> -->
                                                            </div>
                                                            <p v-if="selected_itemes">
                                                                @lang('layout.OnHand'):@{{(selected_itemes)?(Number.parseFloat(selected_itemes.on_hand * selected_itemes.measure_unit / selected_itemes.measure.measure_unit).toFixed(2)):''}} @{{(selected_itemes)?selected_itemes.measure.measure_name:''}}
                                                            </p>
                                                        </div>
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12"  >
                                                                <div class="form-group">
                                                                    <!-- <label class="control-label">@lang('layout.Site')</label> -->
                                                                    <v-select label="name" v-model="selected_iventory_site" :options="inventory_sites" placeholder="@lang('layout.Site')"></v-select>
                                                                </div>
                                                                <p v-if="selected_itemes && selected_iventory_site" >
                                                                    @{{(selected_itemes && selected_iventory_site)?(Number.parseFloat(selected_iventory_site.OnHand * selected_itemes.measure_unit / selected_itemes.measure.measure_unit).toFixed(2)):''}}
                                                                </p>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-5 col-md-5 col-sm-12 col-xs-12" style="padding: 0px !important;" >
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12"  >
                                                            <div class="form-group">
                                                                <!-- <div class="col-md-12"> -->
                                                                    <!-- <label class="control-label">@lang('layout.Quantity')</label> -->
                                                                    <input type="number" v-model.number="selected_quantity" ref="selected_quantity" class="form-control input-style input-number" placeholder="@lang('layout.Quantity')">
                                                                    <span class="required" v-if="selected_quantity_error" >@lang('layout.Quantity')</span>
                                                                <!-- </div> -->
                                                            </div>
                                                            <p v-if="AdvancePrice" >
                                                            @lang('layout.ByAdvancePricing') : @{{ AdvancePrice }}
                                                            </p>
                                                        </div>
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12"  >
                                                            <div class="form-group">
                                                                <!-- <div class="col-md-12"> -->
                                                                    <!-- <label class="control-label">@lang('layout.Quantity')</label> -->
                                                                    <select v-model="(selected_itemes == null)?null:selected_itemes.measure" class="form-control" >
                                                                        <option value="null">@lang('layout.Select')</option>
                                                                        <span v-if="(selected_itemes ==null)?false:true">
                                                                            <option v-for="measure in (selected_itemes==null)?null:selected_itemes.measure_list" :value="measure">
                                                                                @{{measure.measure_name}}
                                                                            </option>
                                                                        </span>
                                                                    </select>
                                                                <!-- </div> -->
                                                            </div>
                                                            <p v-if="AdvancePrice_cost && AdvancePrice" >
                                                            @lang('layout.Price') : @{{(selected_itemes==null)?null:Number.parseFloat((AdvancePrice_cost * selected_itemes.measure.measure_unit / selected_itemes.measure_unit) * selected_currency.rate).toFixed(precision())}} @{{selected_currency.symbol}}
                                                            </p>
                                                        </div>
                                                        <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12" v-show="seePrice==true" >
                                                            <div class="form-group">
                                                                <!-- <div class="col-md-12"> -->
                                                                    <!-- <label class="control-label">@lang('layout.Price')</label> -->
                                                                    <input type="number" v-model.number="selected_price" class="form-control input-style input-number" placeholder="@lang('layout.Price')">
                                                                <!-- </div> -->
                                                            </div>
                                                            <p v-if="selected_itemes && seeCost==true" >
                                                            @lang('layout.CostInInventory'): @{{(selected_itemes==null)?null:Number.parseFloat((selected_itemes.LasCost * selected_itemes.measure.measure_unit / selected_itemes.measure_unit) * selected_currency.rate).toFixed(precision())}} @{{selected_currency.symbol}}
                                                            </p>
                                                        </div>
                                                    </div>
                                                    <div class="col-lg-1 col-md-1 col-sm-12 col-xs-12" style="padding: 0px !important;" >
                                                        @lang('layout.Total'): @{{(selected_itemes==null)?null:Number.parseFloat(selected_quantity * selected_price).toFixed(precision())}} @{{selected_currency.symbol}}
                                                    </div>
                                                    <div class="col-lg-1 col-md-1 col-sm-12 col-xs-12" style="padding: 0px !important;"  >
                                                        <button type="button" @click="addData()" class="btn btn-success"><i class="fa fa-plus"></i></button>
                                                        <button type="button" @click="resetData()" class="btn"><i class="fa fa-times"></i></button>
                                                    </div>
                                                </div>
                                                <!--END search Item-->
												
                                                </div>
                                                <div class="col-lg-3 col-md-3 col-sm-12 col-xs-12"
                                                     v-show="seePrice==true">

                                                    <!-- begin total -->
                                                    <div class="dashboard-stat2 "  style="padding: 5px 1px 1px 1px; margin-bottom: 5px;">
                                                        <table class="dashboard-tabel" width="100%">
                                                            <tr>
                                                                <td>
                                                                    <small>@lang('layout.Total') :</small>
                                                                </td>
                                                                <td class="text-right"><span data-counter="counterup" data-value="7800">
                                                                    @{{ format_number(Number.parseFloat(((subtotal - (discount*(newSubTotal - newSubDiscountFiledRow)/100) - discountFiledRow) - saleTaxation)-payeds))}}
                                                                </span>
                                                                    <small class="font-green-sharp">
                                                                        @{{selected_currency.symbol}}
                                                                    </small>
                                                                </td>
                                                            </tr>

                                                            <tr>
                                                                <td>
                                                                    <small>@lang('layout.Discount'): (@{{
                                                                        Number.parseFloat(discount).toFixed(precision())
                                                                        }}%)
                                                                    </small>
                                                                </td>
                                                                <td class="text-right">
                                                                    <span class="text-right" data-counter="counterup" data-value="7800">
                                                                    @{{ format_number(Number.parseFloat(discount*(newSubTotal - newSubDiscountFiledRow)/100)+Number.parseFloat(discountFiledRow)) }}
                                                                    </span>
                                                                    <small class="font-green-sharp">
                                                                        @{{selected_currency.symbol}}
                                                                    </small>
                                                                </td>
                                                            </tr>
															@if(getSaleTaxation() == 'true')
															<tr>
                                                                <td>
                                                                    <small>@lang('menu.Taxation'): (@{{
                                                                        format_number(Number.parseFloat(sale_taxation))
                                                                        }}%)
                                                                    </small>
                                                                </td>
                                                                <td class="text-right">
                                                                   <span class="text-right" data-counter="counterup"
                                                                         data-value="7800">
                                                                       @{{ format_number(Number.parseFloat(saleTaxation)) }}
                                                                   </span>
                                                                    <small class="font-green-sharp">
                                                                        @{{selected_currency.symbol}}
                                                                    </small>
                                                                </td>
                                                            </tr>
															@endif

                                                            <tr>
                                                                <td>
                                                                    <small>@lang('layout.Payment'):</small>
                                                                </td>
                                                                <td class="text-right">
                                                                    <small class="font-green-sharp">
                                                                    <span class="text-right" data-counter="counterup"
                                                                            data-value="7800">@{{ payeds.toFixed(precision())}}</span>
                                                                        <small class="font-green-sharp">
                                                                            @{{selected_currency.symbol}}
                                                                        </small>
                                                                    </small>
                                                                </td>
                                                            </tr>


                                                            <tr>
                                                                <td>
                                                                    <small>@lang('layout.GrandTotal'):</small>
                                                                </td>
                                                                <td class="text-right">
                                                                <span class="text-right" data-counter="counterup"
                                                                        data-value="7800">@{{ subtotal.toFixed(precision())}}</span>
                                                                    <small class="font-green-sharp">
                                                                        @{{selected_currency.symbol}}
                                                                    </small>
                                                                </td>
                                                            </tr>


                                                        </table>

                                                    </div>
													
													@if(getTaxation() =="true")
                                                    <!-- begin total tax -->
                                                    <div class="dashboard-stat2 " v-show="seePrice== true"  style="padding: 5px 1px 1px 1px; margin-bottom: 5px;">
                                                        <table class="dashboard-tabel" width="100%">
                                                            <tr>
                                                                <td>
                                                                    <small>@lang('layout.Total') @lang('layout.Tax') :</small>
                                                                </td>
                                                                <td class="text-right">
                                                                    <span data-counter="counterup"
                                                                                             data-value="7800">
                                                                        @{{ myRound(totalTax)}}
                                                                    </span>
                                                                    <small class="font-green-sharp">
                                                                        @{{selected_currency.symbol}}
                                                                    </small>
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td>
                                                                    <small>@lang('layout.Sub-Total'):</small>
                                                                </td>
                                                                <td class="text-right">
                                                                  <span class="text-right" data-counter="counterup"
                                                                        data-value="7800">
                                                                      @{{ format_number(Number(checkedSubtotal))}}
                                                                  </span>
                                                                    <small class="font-green-sharp">
                                                                        @{{selected_currency.symbol}}
                                                                    </small>
                                                                </td>
                                                            </tr>
                                                        </table>

                                                    </div>
                                                    <!-- end total -->
                                                    @endif

                                                    @if(getSaleCommission() =="true")
                                                    <!-- begin total commission -->
                                                    <div class="dashboard-stat2 " v-show="seePrice== true" style="padding: 5px 1px 1px 1px; margin-bottom: 5px;">
                                                        <table class="dashboard-tabel" width="100%">
                                                            <tr>
                                                                <td>
                                                                    <small>@lang('layout.Total') @lang('layout.Commission') :</small>
                                                                </td>
                                                                <td class="text-right">
                                                                    <span data-counter="counterup" data-value="7800">
                                                                        @{{ myRound(totalCommi)}}
                                                                    </span>
                                                                    <small class="font-green-sharp">
                                                                        @{{selected_currency.symbol}}
                                                                    </small>
                                                                </td>
                                                            </tr> 
                                                            <tr>
                                                                <td>
                                                                    <small>@lang('layout.Sub-Total'):</small>
                                                                </td>
                                                                <td class="text-right">
                                                                    <span class="text-right" data-counter="counterup" data-value="7800">
                                                                        @{{ format_number(Number(checkedSubtotal))}}
                                                                    </span>
                                                                    <small class="font-green-sharp">
                                                                        @{{selected_currency.symbol}}
                                                                    </small>
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </div>
                                                    <!-- end total -->
                                                    @endif
                                                    <div class="dashboard-stat2" v-if="selected_customer"  style="padding: 5px 1px 1px 1px; margin-bottom: 5px;">

                                                        <table class="dashboard-tabel table-bordered" width="100%">
                                                            <thead>
                                                            <tr>
                                                                <th>@lang('layout.Currency') </th>
                                                                <th>@lang('layout.Payable')</th>
                                                                <th>@lang('layout.Receivable')</th>
                                                            </tr>
                                                            </thead>
                                                            <tbody>
                                                                    <span>
                                                                    <tr v-for="summ in summary">
                                                                    <td class="highlight">
                                                                        @{{ summ.currency }}
                                                                    </td>
                                                                    <td class="hidden-xs"> @{{ format_number(Number(summ.payment)) }}</td>
                                                                    <td>
                                                                        @{{format_number(Number(summ.invoice)) }}
                                                                    </td>
                                                                    </tr>
                                                                </span>
                                                            </tbody>
                                                        </table>
                                                    </div>

                                                    @if(getSubTotal() == 'true')
                                                    <div class="dashboard-stat2" style="padding: 5px 1px 1px 1px; margin-bottom: 5px;">

                                                        <table class="dashboard-tabel table-bordered" width="100%">
                                                            <thead>
                                                            <tr>
                                                                <th><center>@lang('layout.Sub-Total')</center></th>
                                                                <th><center>@lang('layout.Discount'): (@{{
                                                                        format_number(Number.parseFloat(discount))
                                                                        }}%)
                                                                        </center></th>
                                                                <th><center>@lang('layout.Total')</center></th>
                                                            </tr>
                                                            </thead>
                                                            <tbody>
                                                                   <span>
                                                                   <tr>
                                                                      <td class="highlight">
                                                                      <center> 
                                                                        <span class="text-right" data-counter="counterup"
                                                                                data-value="7800">
                                                                            @{{ format_number(Number(sub_Subtotal))}}
                                                                        </span>
                                                                        <small class="font-green-sharp">
                                                                            @{{selected_currency.symbol}}
                                                                        </small> 
                                                                        </center>
                                                                      </td>
                                                                      <td class="hidden-xs"><center>
                                                                        <span class="text-right" data-counter="counterup"
                                                                            data-value="7800">
                                                                            @{{ format_number(Number.parseFloat(sub_discount*(sub_Subtotal - subDiscountFiledRow)/100)+Number.parseFloat(subDiscountFiledRow)) }}
                                                                        </span>
                                                                        <small class="font-green-sharp">
                                                                            @{{selected_currency.symbol}}
                                                                        </small>  
                                                                        </center></td> 
                                                                      <td><center>
                                                                            <span data-counter="counterup" data-value="7800">
                                                                                @{{ format_number(Number.parseFloat((sub_Subtotal - (sub_discount*(sub_Subtotal - subDiscountFiledRow)/100) - subDiscountFiledRow) - saleTaxation))}}
                                                                            </span>
                                                                            <small class="font-green-sharp">
                                                                                @{{selected_currency.symbol}}
                                                                            </small>      
                                                                        </center></td>
                                                                    </tr>
                                                                </span>
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                    @endif

                                                    <!-- end total -->

                                                    @if(ShowLastSale()=="true")
                                                    <div class="dashboard-stat2" v-if="last_item_sale != null && last_item_sale != ''" style="overflow-x: scroll; height:130px; padding: 5px 1px 1px 1px; margin-bottom: 5px;">
                                                        <table class="dashboard-tabel table-bordered" width="100%">
                                                                <thead>
                                                                    <tr>
                                                                        <th class="highlight">@lang('layout.CustomerName')</th>
                                                                        <th class="highlight">@lang('layout.Measure')</th>
                                                                        <th class="highlight">@lang('layout.SalePrice')</th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody>
                                                                    <tr v-for="(last_it,index) in last_item_sale">
                                                                        <td>@{{last_it.member}}</td>
                                                                        <td>@{{last_it.Measure}}</td>
                                                                        <td>@{{myRound(last_it.price)}} @{{last_it.currency}}</td>
                                                                    </tr>
                                                                </tbody>
                                                        </table>
                                                    </div>
                                                    
                                                    <div class="dashboard-stat2" v-if="last_item_purchase != null && last_item_purchase != ''" style="overflow-x: scroll; height:110px; padding: 5px 1px 1px 1px; margin-bottom: 5px;">
                                                        <table class="dashboard-tabel table-bordered" width="100%">
                                                                <thead>
                                                                    <tr>
                                                                        <th class="highlight">@lang('layout.Vendor')</th>
                                                                        <th class="highlight">@lang('layout.Measure')</th>
                                                                        <th class="highlight">@lang('layout.Cost')</th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody>
                                                                    <tr v-for="(last_it,index) in last_item_purchase">
                                                                        <td>@{{last_it.member}}</td>
                                                                        <td>@{{last_it.Measure}}</td>
                                                                        <td>@{{myRound(last_it.cost)}} @{{last_it.currency}}</td>
                                                                    </tr>
                                                                </tbody>
                                                        </table>
                                                    </div>

                                                    @endif

                                                </div>

                                            </div>

                                            <div class="row" v-if="inventories.length>0" style="overflow-x: scroll;">
                                                <table id="table_content" class="table table-bordered table-advance table-hover">
                                                    <thead>
                                                    <tr>
                                                        <th>#</th>
                                                        <th>@lang('layout.Edit')</th>
														@if(getTaxation() =="true")
                                                        <th>@lang('layout.Tax')</th>
														@endif
                                                        <th v-show="showWhat('sale_category')=='yes'" style="min-width: 130px">@lang('layout.Category') </th>
                                                        <th v-show="showWhat('inventory_brand')=='yes'" style="min-width: 130px">@lang('layout.Brand') </th>
                                                        @if(getSerailNumber() =="true")
                                                            <th style="min-width: 100px">@lang('layout.SerialNum') </th>
                                                        @endif
                                                        <th style="min-width: {{itemFieldWidth()}}px">@lang('layout.ItemName') </th>
                                                        @if(searchByCodeLocation()=="true")
                                                        <th style="min-width: 110px;">@lang('layout.Location')</th>
                                                        @endif
                                                        <th style="min-width: 100px">@lang('layout.SiteName') </th>
                                                        <th v-show="showWhat('sale_description')=='yes'">@lang('layout.Description') </th>
                                                        <th v-show="showWhat('sale_description2')=='yes'">@lang('layout.Description')
                                                            :2
                                                        </th>
                                                        <th style="min-width: 50px">@lang('layout.Quantity') </th>
                                                        <th style="min-width: 100px">@lang('layout.OnHand') </th>
                                                        <th v-show="showWhat('other_measure')=='yes'"
                                                            style="min-width: 50px">@lang('layout.OMeasureValue1')
                                                        </th>
                                                        <th v-show="showWhat('other_measure2')=='yes'"
                                                            style="min-width: 50px">@lang('layout.OMeasureValue2')
                                                        </th>
                                                        <th style="min-width: 100px">@lang('layout.Measure') </th>
                                                        <th v-show="seeCost==true" style="min-width: 80px">@lang('layout.CostInInventory') </th>
														<th v-if="oil_sale == true" style="min-width: 50px">@lang('layout.Density') </th>
                                                        <th v-if="oil_sale == true" style="min-width: 50px">@lang('layout.OilQuantity') </th>
                                                        <th v-if="oil_sale == true" style="min-width: 100px">@lang('layout.Measure') </th>
                                                        @if(getShwoPriceLevel()=="per_item")	
                                                        <th style="min-width: 100px">@lang('layout.PriceLevel') </th>
                                                        @endif
                                                        @if(getShwoPriceLevel()=="general_percent_per_item")
                                                        <th style="min-width: 100px">@lang('layout.PriceLevel') </th>
                                                        @endif
                                                        <th v-show="seePrice==true"
                                                            style="min-width: 50px">@lang('layout.NewPrice') </th>
                                                        @if(getM2()!="")
                                                        @if(getFactorMeasure2()=="true")	
														<th style="min-width: 100px">@lang('layout.Measure2') </th>
                                                        @endif
                                                        @endif
														@if(getSubMeasure()=="true")	
                                                        <th style="min-width: 100px">@lang('layout.EquivalentTo') </th>
                                                        @endif
                                                        @if(getM3()!="" && getSubMeasure()!="true")	
                                                        @if(getFactorMeasure3()=="true")
                                                        <th style="min-width: 100px">@lang('layout.Measure3') </th>
                                                        @endif
                                                        @endif
                                                        @if(getM4()!="")
                                                        @if(getFactorMeasure4()=="true")	
                                                        <th  v-if="oil_sale == false" style="min-width: 100px">@lang('layout.Measure4') </th>
                                                        @endif
                                                        @endif
														@if(getTaxation()=="true")	
                                                        <th  style="min-width: 100px">@lang('layout.Tax') </th>
                                                        <th  style="min-width: 50px">@lang('layout.Percentage')%</th>
                                                        @endif
                                                        <th v-show="showWhat('sale_discount')=='yes'"
                                                            style="min-width: 50px">@lang('layout.Discount') </th>
                                                        <th v-show="seePrice==true"
                                                            style="min-width: 80px">@lang('layout.Total') 
                                                        </th>
                                                        @if(getSubTotal() =="true")
                                                        <th v-show="seePrice==true">@lang('layout.Subtotal')</th>
                                                        @endif
                                                        <th></th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <tr v-for="(item,index) in inventories">

                                                        <input type="hidden" name="sale_order_detail_id[]" :value="(item.item==null)?null:item.item.sale_order_detail_id">
                                                        <input type="hidden" :value="(!item.item)?null:item.item.online_order_detail_id" name="online_order_detail_id[]">
                                                        <td>@{{index+1}}</td>
                                                        <td>
															<div class="mt-checkbox" style="padding-left: 0px;">
															 <label class="mt-checkbox mt-checkbox-outline">
															 <input type="checkbox" v-model="item.edit" />
															 <span></span>
															 </label>
															</div>
														</td>
														@if(getTaxation() =="true")
														<td>
															<div class="mt-checkbox" style="padding-left: 0px;">
															 <label class="mt-checkbox mt-checkbox-outline">
															 <input type="checkbox" :name="'row_tax_stat['+index+']'" v-model="item.tax" checked />
															 <span></span>
															 </label>
															</div>
														</td>
														@endif
                                                        <td v-show="showWhat('sale_category')=='yes'">
                                                            <v-select label="name" v-model="item.item_category"
                                                                      :options="inventory_category"
                                                                      @keyup.native="itemCategoryChange(index)"
                                                                      @Click.native="itemCategoryChange(index)"></v-select>
                                                            <input type="hidden" name="inventory_category_id[]"
                                                                   :value="(!item.item_category)?null:item.item_category.id">
                                                        </td>
                                                        <td v-show="showWhat('inventory_brand')=='yes'">
                                                            <v-select label="name" v-model="item.item_brand" :options="brandItem" @Click.native="itemBrandChange(index)" @keyup.native="itemBrandChange(index)"></v-select>
                                                            <input type="hidden" name="inventory_brand_id[]" :value="(!item.item_brand)?null:item.item_brand.id">
                                                        </td>
                                                        @if(getSerailNumber() =="true")
                                                            <td>
                                                                @{{(!item.item)?null:item.item.number}}
                                                            </td>
                                                        @endif
                                                        <td class="highlight">
                                                            <v-select label="name" :disabled="!item.edit"
                                                                @input="(item.edit)?onItemload(index):''"
                                                                @Click.native="setIndex(index)"
                                                                v-model="item.inventory" :options="temp_items"
                                                                @search="onItemSearch"></v-select>
                                                            <input type="hidden" name="inventory_id[]" :value="(!item.item)?null:item.item.id">

                                                        </td>
                                                        @if(searchByCodeLocation()=="true")
                                                        <td class="highlight">
                                                            <v-select label="name" :disabled="!item.edit" @Click.native="setIndex(index)" @input="(item.edit)?locationItemload(index):''" v-model="item.location" :options="(item.item==null)?[]:item.item.locationList" @search="locationSearch" ></v-select>
                                                            <input type="hidden" :name="'location['+index+']'" v-validate="''" data-vv-as="@lang('layout.Location')" :value="(!item.location)?null:item.location.name">
                                                        </td>
                                                        @endif
                                                        <td class="highlight">
                                                            <select v-model="(item.item==null)?null:item.item.site"
                                                                    class="form-control">
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(item.item != null)">
                                                          <option v-for="site in (item.item==null)?null:item.item.site_list"
                                                                  :value="site">
                                                            @{{site.site_name}} 
                                                          </option> 
                                                        </span>
                                                            </select>

                                                            <input type="hidden" name="inventory_site[]"
                                                                   :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.site_id)">
                                                        </td>
                                                        <td v-show="showWhat('sale_description')=='yes'">
                                                            <input type="text" placeholder="@lang('layout.Description')"
                                                                   v-model="(item.item==null)?null:item.item.description"
                                                                   oninput = "autowidths(event)"
                                                                   name="inventory_description[]" class="form-control chan_length">
                                                        </td>
                                                        <td v-show="showWhat('sale_description2')=='yes'">
                                                            <input type="text" placeholder="@lang('layout.Description')"
                                                                   v-model="(item.item==null)?null:item.item.description2"
                                                                   oninput = "autowidths(event)"
                                                                   name="description2[]" class="form-control chan_length">
                                                        </td>

                                                        <td>
                                                            <input type="number" name="inventory_quantity[]"  oninput = "autowidths(event)"
                                                                   v-model.number="(item.item==null)?null:item.item.quantity"
                                                                   class="form-control input-style input-number chan_length" @input="change_oil_qty(index)"
                                                                   placeholder="@lang('layout.Quantity')">
                                                        </td>

                                                        <td>
                                                            @{{myRound((item.item==null)?null:saleItemQuantity(item.item,item.item.quantity,0))}}
                                                        </td>
                                                        <td v-show="showWhat('other_measure')=='yes'">
                                                            <div class="input-group">
                                                            <input type="number" name="other_measure_amount[]"
                                                                   v-model.number="(item.item==null)?null:item.item.other_measure"
                                                                   oninput = "autowidths(event)"
                                                                   class="form-control input-style input-number chan_length"
                                                                   @input="change_per_qty(index)" placeholder="@lang('layout.OMeasureValue1')">
                                                                   <input type="hidden" name="per_qty[]" :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.per_qty)">
                                                                @if(getCalQuantityOfOtherMeasure() == 'avgMethod')
                                                                <span class="input-group-addon" v-if="(item.item==null)?null:((item.item.site==null)?null:item.item.site.per_qty) > 0">
                                                                    @{{myRound((item.item==null)?null:((item.item.site==null)?null:(item.item.site.OnHand / item.item.site.per_qty)))}}
                                                                </span>
                                                                @elseif(getCalQuantityOfOtherMeasure() == 'simpleMethod')
                                                                <span class="input-group-addon" v-if="(item.item==null)?null:((item.item.site==null)?null:true)">
                                                                    @{{myRound((item.item==null)?null:((item.item.site==null)?null:item.item.site.other_measure))}}
                                                                </span>
                                                                @else
                                                                <span class="input-group-addon">
                                                                    @{{(item.item==null)?null:item.item.o_measure_v}}
                                                                </span>
                                                                @endif
                                                            </div>
                                                        </td>
                                                        <td v-show="showWhat('other_measure2')=='yes'">
                                                            <div class="input-group">
                                                                <input type="number" name="other_measure_amount2[]"
                                                                   v-model.number="(item.item==null)?null:item.item.other_measure2"
                                                                   oninput = "autowidths(event)"
                                                                   class="form-control input-style input-number chan_length" placeholder="@lang('layout.OMeasureValue2')">
                                                                <input type="hidden" name="per_qty2[]" :value="(item.item==null)?null:((item.item.site==null)?null:item.item.site.per_qty2)">
                                                                @if(getCalQuantityOfOtherMeasure() == 'avgMethod')
                                                                <span class="input-group-addon" v-if="(item.item==null)?null:((item.item.site==null)?null:item.item.site.per_qty2) > 0">
                                                                    @{{myRound((item.item==null)?null:((item.item.site==null)?null:(item.item.site.OnHand / item.item.site.per_qty2)))}}
                                                                </span>
                                                                @elseif(getCalQuantityOfOtherMeasure() == 'simpleMethod')
                                                                <span class="input-group-addon" v-if="(item.item==null)?null:((item.item.site==null)?null:true)">
                                                                    @{{myRound((item.item==null)?null:((item.item.site==null)?null:item.item.site.other_measure2))}}
                                                                </span>
                                                                @else
                                                                <span class="input-group-addon">
                                                                    @{{(item.item==null)?null:item.item.o_measure_v1}}
                                                                </span>
                                                                @endif
                                                            </div>
                                                        </td>
                                                        <td class="highlight">
                                                            <select v-model="(item.item == null)?null:item.item.measure"
                                                                    class="form-control" @change="measureChange(index)">
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(item.item ==null)?false:true">
                                                              <option v-for="measure in (item.item==null)?null:item.item.measure_list"
                                                                      :value="measure">
                                                              @{{measure.measure_name}}
                                                            </option> 
                                                          </span>


                                                            </select>

                                                            <input type="hidden" name="inventory_measure[]"
                                                                   :value="(item.item==null)?null:item.item.measure.measure_id">
                                                        </td>
                                                        <td v-show="seeCost==true">
                                                            @{{(item.item==null)? 0:myRound((item.item.LasCost * item.item.measure.measure_unit / item.item.measure_unit) *selected_currency.rate)}}
                                                            @{{selected_currency.symbol}}
                                                        </td>
														
														<td v-if="oil_sale == true">
                                                            <input type="number" name="density[]"
                                                                   class="form-control input-style input-number chan_length"
                                                                   placeholder="@lang('layout.Density')" @input="change_oil_qty(index)"
                                                                   oninput = "autowidths(event)"
                                                                    v-model.number="(item.item==null)?null:item.item.density">
                                                        </td>
														<td v-if="oil_sale == true">
                                                            <input type="number" name="oil_qty[]"
                                                                oninput = "autowidths(event)"
                                                                   class="form-control input-style input-number chan_length" readonly
                                                                   placeholder="@lang('layout.OilQuantity')"
                                                                    v-model.number="(item.item==null)?null:item.item.oil_qty">
                                                        </td>
														<td v-if="oil_sale == true">
															  <select name="measure3[]" class="form-control" v-model="(item.item==null)?null:item.item.measure3.measure_id">
																  <option value="null">@lang('layout.Select')</option>
																  <span v-if="(item.item ==null)?false:true">
																	  <option  v-for="measure in (item.item==null)?null:item.item.measureListAll" :value="measure.measure_id">
																	  @{{measure.measure_name}}
																	</option> 
																  </span>
															  </select>
                                                          </td>
                                                          @if(getShwoPriceLevel()=="per_item")
                                                          <td>
                                                            <select  v-model="(item.item == null)?null:item.price_level" 
                                                                    class="form-control" @change="change_sale_rate_by_price_level(index)">
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(item.item ==null)?false:true">
                                                                    <option v-for="price_level in (item.item==null)?null:item.item.item_price_level"
                                                                            :value="price_level">
                                                                    @{{price_level.name}}
                                                                    </option>
                                                                </span>
                                                            </select>

                                                            <input type="hidden" name="item_price_level_id[]" :value="(item.price_level == null)?null:item.price_level.id">
                                                        </td>
                                                        @endif

                                                        @if(getShwoPriceLevel()=="general_percent_per_item")
                                                        <td>
                                                            <select v-model="(item.item == null)?null:item.price_level" class="form-control" @change="change_sale_rate_by_price_level_general_per_item(index)">
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(item.item ==null)?false:true">
                                                                    <option v-for="price_level in (item.item==null)?null:priceLevelGeneral" :value="price_level">
                                                                        @{{price_level.name}}
                                                                    </option>
                                                                </span>
                                                            </select>

                                                            <input type="hidden" name="item_price_level_id[]" :value="(item.price_level == null)?null:item.price_level.id">
                                                        </td>
                                                        @endif


                                                        <td v-show="seePrice==true">
                                                            <div class="input-group">
                                                                <input type="number" name="inventory_price[]"
                                                                    oninput = "autowidths(event)"
                                                                       placeholder="@lang('layout.Price')"
                                                                       v-bind:value="(item.item==null)?null:saleNewRate(item.item,selected_currency.rate)"
                                                                       ref="in" @input="setNewRate('inventory',index)"
                                                                       class="form-control chan_length">
                                                                <span class="input-group-addon">
                                                        @{{selected_currency.symbol}}
                                                      </span>
                                                            </div>
                                                        </td>
                                                          @if(getM2()!="" && getSubMeasure()!="true")
                                                          @if(getFactorMeasure2()=="true")	  
                                                   <td>
                                                       <div class="input-group">
                      															  <select name="measure1[]" class="form-control" v-model="(item.item==null)?null:item.item.measure1.measure_id">
                      																  <option value="null">@lang('layout.Select')</option>
                      																  <span v-if="(item.item ==null)?false:true">
                      																	  <option  v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure.measure_id">
                      																	  @{{measure.measure_name}}
                      																	</option> 
                      																  </span>
                                                                                    </select>
                                                                                    @if(getSaleAmountSecondMeasure()=="true")	
                                                                <span class="input-group-addon">
                                                                    @{{myRound((item.item==null)?null:secoundMeasurQuantity(item.item,item.item.quantity))}}
                                                                </span>
                                                                @endif
                                                            </div>
                      														  </td>
                      														@endif
                      														@endif
                                                                              @if(getM3()!="")
                                                                              @if(getFactorMeasure3()=="true")	  
                      														  <td>
                      															  <select name="measure2[]" class="form-control"  v-model="(item.item==null)?null:item.item.measure2.measure_id">
                      																  <option value="null">@lang('layout.Select')</option>
                      																  <span v-if="(item.item ==null)?false:true">
                      																	  <option  v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure.measure_id">
                      																	  @{{measure.measure_name}}
                      																	</option> 
                      																  </span>
                      															  </select>
                      														  </td>
                      														@endif
                      														@endif
																			@if(getSubMeasure() =="true")	  
																			  <td>
																				  @{{myRound((item.item==null)?null:subMQuantity(item.item,item.item.quantity))}}
																			  </td>
																			@endif
                                                                              @if(getM4()!="")	
                                                                              @if(getFactorMeasure4()=="true")
                      														  <td v-show="seePrice==false">
                      															  <select name="measure3[]" class="form-control"  v-model="(item.item==null)?null:item.item.measure3.measure_id">
                      																  <option value="null">@lang('layout.Select')</option>
                      																  <span v-if="(item.item ==null)?false:true">
                      																	  <option  v-for="measure in (item.item==null)?null:item.item.measure_list" :value="measure.measure_id">
                      																	  @{{measure.measure_name}}
                      																	</option> 
                      																  </span>
                      															  </select>
                      														  </td>
                                                        @endif
                                                        @endif
														
														@if(getTaxation()=="true")
															<td>
															<span v-show="!item.tax">
																<v-select 
																	v-model="item.selected_taxation"
																	label="name" :options="taxation"
																	@input="getDrivers">
																</v-select>
																  <input type="hidden" :name="'row_taxation_id['+index+']'" :value="!item.selected_taxation?null:item.selected_taxation.id" />
																  <input type="hidden" :name="'row_taxation_vendor_id['+index+']'" :value="!item.selected_taxation?null:item.selected_taxation.member_id" />
																  <input type="hidden" :name="'row_tax_amount['+index+']'" :value="!item.selected_taxation?null:item.row_tax_amount" />
															</span>
															</td>
															<td>
															<span v-show="!item.tax">
																<input type="number" class="form-control chan_length" :name="'row_percent_tax['+index+']'"
                                                                oninput = "autowidths(event)"
                                                                v-model="!item.selected_taxation?null:item.selected_taxation.percent" />
															</span>
															</td>
														@endif



                                                        <td v-show="showWhat('sale_discount')=='yes'">
                                                            <div class="input-group">
                                                                <input type="number" name="inventory_discount[]"
                                                                       placeholder="@lang('layout.Discount')"
                                                                       v-model.number="(item.item==null)?null:item.item.discount"
                                                                       oninput = "autowidths(event)"
                                                                       class="form-control chan_length">
                                                                <span v-if="discountIsAmount" class="input-group-addon">
                                                        @{{selected_currency.symbol}}
                                                      </span>
                                                                <span v-if="!discountIsAmount"
                                                                      class="input-group-addon">
                                                        %
                                                      </span>
                                                            </div>

                                                        </td>
                                                        <td v-if="oil_sale==false" v-show="seePrice==true">
                                                            @{{(item.item==null)? 0:getItemTotal(item.item,selected_currency.rate,discountIsAmount,item.item.discount,1,per_qty_check).result}}
                                                            @{{selected_currency.symbol}}
                                                        </td>
														
                                                        <td v-if="oil_sale==true" v-show="seePrice==true">
                                                            @{{(item.item==null)? 0:getItemTotalOil(item.item,selected_currency.rate,discountIsAmount,item.item.discount).result}}
                                                            @{{selected_currency.symbol}}
                                                        </td>

                                                        @if(getSubTotal() =="true")
                                                        <td>
															<div class="mt-checkbox" style="padding-left: 0px;">
															 <label class="mt-checkbox mt-checkbox-outline">
															 <input type="checkbox" :name="'row_sub_total_stat['+index+']'" v-model="item.sub_total" />
															 <span></span>
															 </label>
															</div>
                                                        </td>
														@endif

                                                        <td>
                                                            <span v-on:click="deleteItem('inventory',index)"><i
                                                                        class="paddint-both glyphicon glyphicon-trash"></i></span>

                                                        </td>
                                                    </tr>
                                                    <tr style="background-color: #ffffff;">
                                                        <td></td>
                                                        <td>
                                                            <center>
                                                                <button type="button" @click="addNew('inventory',1000)"
                                                                        class="btn btn-success"><i
                                                                            class="fa fa-plus"></i></button>
                                                            </center>
                                                        </td>
                                                        <td></td>
                                                        <td></td>
                                                        <td></td>
                                                        <td></td>
                                                        <td></td>
                                                        <td></td>
                                                        <td></td>
                                                    </tr>
                                                    </tbody>
                                                </table>

                                                <hr>
                                                <!-- begin service -->
                                                <table id="table_content"
                                                       class="table table-striped table-bordered table-advance table-hover">
                                                    <thead>
                                                    <tr>
                                                        <th class="text-center" style="min-width: 8px;"> #</th>
                                                        <th class="text-center"
                                                            style="min-width: 160px;">@lang('layout.ServiceName')</th>
                                                        <th v-show="showWhat('sale_description')=='yes'">@lang('layout.Description') </th>
                                                        <th v-show="showWhat('sale_description2')=='yes'">@lang('layout.Description') :2 </th>
                                                        <th class="text-center"
                                                            style="min-width: 160px;">@lang('layout.Quantity')</th>
                                                        <th class="text-center"
                                                            style="min-width: 160px;">@lang('layout.Measure')</th>
                                                        <th class="text-center"
                                                            style="min-width: 160px;">@lang('layout.Price')</th>
                                                        <th class="text-center"
                                                            style="min-width: 120px;">@lang('layout.Total')</th>
                                                        <th></th>

                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <tr v-for="(service,index) in services">
                                                        <td>@{{index+1}}</td>
                                                        <td class="highlight">
                                                            <v-select label="name" v-model="service.item"
                                                                      :options="(service.items)"
                                                                      @click.native="addNew('service',index)"
                                                                      @input="checkExistingService(index)">

                                                            </v-select>
                                                            <input type="hidden" name="service_id[]" :value="(service.item==null)?null:service.item.id">
                                                            <input type="hidden" name="ser_online_order_detail_id[]" :value="(service.item==null)?null:service.item.online_order_detail_id">
                                                            <input type="hidden" name="sale_order_service_id[]" :value="(service.item==null)?null:service.item.order_detail_id">
                                                        </td>
                                                        <td v-show="showWhat('sale_description')=='yes'">
                                                            <input type="text" placeholder="@lang('layout.Description')" name="service_description[]" v-model="(service.item==null)?null:service.item.description" class="form-control">
                                                        </td>
                                                        <td v-show="showWhat('sale_description2')=='yes'">
                                                            <input type="text" placeholder="@lang('layout.Description')" name="service_description2[]" v-model="(service.item==null)?null:service.item.description2" class="form-control">
                                                        </td>
                                                        <td>
                                                            <input class="form-control" name="service_quantity[]"
                                                                   v-model.number="(!service.item)?null:service.item.quantity"
                                                                   placeholder="@lang('layout.Quantity')">
                                                        </td>
                                                        <td class="highlight">
                                                            <select v-model="(service.item == null)?null:service.item.measure"
                                                                    class="form-control"
                                                                    @change="measureChangeservice(index)">
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <span v-if="(service.item ==null)?false:true">
                                                              <option v-for="measure in (service.item==null)?null:service.item.measure_list"
                                                                      :value="measure">
                                                              @{{measure.measure_name}}
                                                            </option> 
                                                          </span>

                                                            </select>

                                                            <input type="hidden" name="service_measure[]"
                                                                   :value="(service.item==null)?null:service.item.measure.measure_id">
                                                        </td>
                                                        <td>
                                                            <div class="input-group">
                                                                <input type="number" name="service_price[]"
                                                                       placeholder="@lang('layout.Price')"
                                                                       :value="(service.item==null)?null:saleNewRate(service.item,selected_currency.rate)"
                                                                       ref="ser" @input="setNewRate('service',index)"
                                                                       class="form-control">


                                                                <span class="input-group-addon">
                                                          @{{selected_currency.symbol}}
                                                        </span>
                                                            </div>

                                                        </td>
                                                        <td>
                                                            <div class="input-group">
                                                                <input type="number" class="form-control inner_input"
                                                                       :value="(service.item==null)?null:getItemTotalService(service.item,selected_currency.rate).result"
                                                                       placeholder="@lang('layout.Total')" disabled>
                                                                <span class="input-group-addon">
                                                            <b>@{{selected_currency.symbol}}</b>
                                                        </span>
                                                            </div>


                                                        </td>
                                                        <td>
                                                            <span v-on:click="deleteItem('service',index)"><i
                                                                        class="paddint-both glyphicon glyphicon-trash"></i></span>
                                                        </td>
                                                    </tr>
                                                    </tbody>
                                                </table>
                                                <!-- end service -->
                                                <hr>
                                                <!-- begin payments -->
                                                <table id="table_content"
                                                       class="table table-striped table-bordered table-advance table-hover">
                                                    <thead>
                                                    <tr>
                                                        <th class="text-center" style="min-width: 8px;"> #</th>
                                                        <th class="text-center"
                                                            style="min-width: 70px;">@lang('layout.Number')</th>
                                                        <th class="text-center"
                                                            style="min-width: 160px;">@lang('layout.SelectBank')</th>
                                                        <th class="text-center"
                                                            style="min-width: 100px;"> @lang('layout.Amount')</th>
                                                        <th class="text-center"
                                                            style="min-width: 120px;"> @lang('layout.Rate')</th>
                                                        <th class="text-center"
                                                            style="min-width: 80px;">@lang('layout.Currency')</th>
                                                        <th class="text-center"
                                                            style="min-width: 80px;"> @lang('layout.Amount')</th>
                                                        <th class="text-center"
                                                            style="min-width: 120px;">@lang('layout.Total')</th>
                                                        <th class="text-center"
                                                            style="min-width: 120px;">@lang('layout.Description')</th>
                                                        <th></th>

                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <tr v-for="(payment,index) in payments">
                                                        <td>@{{index+1}}</td>
                                                        <td>
                                                            <span>@{{(payment.item==null)?null:(payment.item.number)}}</span>
                                                            <input  type="hidden"
                                                                name="receive_number[]"
                                                                :value="(payment.item==null)?null:(payment.item.number)"
                                                                />
                                                        </td>

                                                        <td class="highlight">
                                                            <v-select label="name" v-model="payment.item"
                                                                      :options="(payment.items)"
                                                                      @click.native="addNew('payment',index)"
                                                                      @input="checkExistingPayment(index)">

                                                            </v-select>
                                                            <input type="hidden" v-if="payment.item !=null"
                                                                   name="payment_id[]"
                                                                   :value="(payment.item==null)?null:payment.item.id">
                                                        </td>

                                                        <td>
                                                 
                                                      <span v-if="payment.item !=null">
                                                        @{{myRound(Number((payment.item==null)?null:payment.item.balance)-Number((payment.item==null)?null:payment.item.amount))}}
                                                      </span>
                                                        </td>
                                                        <td>
                                                            <input v-bind:disabled="(payment.item==null)?false:(payment.item.code =='{{getHomeCurrency()["code"]}}')"
                                                                   type="number"
                                                                   v-model.number="(payment.item==null)?null:payment.item.rate "
                                                                   class="form-control"
                                                                   placeholder="@lang('layout.Rate')"/>
                                                            <input v-if="payment.item !=null" type="hidden"
                                                                   name="payment_rate[]"
                                                                   v-bind:value="payment.item.rate">
                                                        </td>
                                                        <td>
                                                            <input type="text" name="payment_currency[]"
                                                                   class="form-control"
                                                                   v-model="(payment.item==null)?null:payment.item.code"
                                                                   placeholder="@lang('layout.Currency')" disabled
                                                                   reqiured/>

                                                            <input v-if="payment.item !==null" type="hidden"
                                                                   name="payment_currency[]"
                                                                   v-bind:value="payment.item.code"/>
                                                        </td>
                                                        <td>
                                                            <div class="input-group">
                                                                <input type="number" class="form-control"
                                                                       v-model.number="(payment.item==null)?null:payment.item.amount "
                                                                       placeholder="@lang('layout.PayAmount')"/>

                                                                <input v-if="payment.item !=null" type="hidden"
                                                                       name="payment_amount[]"
                                                                       v-bind:value="payment.item.amount">

                                                                <span class="input-group-addon">@{{(payment.item==null)?null:payment.item.code}}</span>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <div class="input-group">
                                                                <input type="number" class="form-control"
                                                                       :value="(payment.item==null)?null:totalPayment(payment.item,selected_currency.rate).result"
                                                                       placeholder="@lang('layout.Total')"
                                                                       style="min-width: 100px"/>
                                                                <span class="input-group-addon">@{{selected_currency.symbol}}</span>
                                                            </div>
                                                        </td>
                                                        <td> 
                                                            <textarea class="form-control" name="receive_description[]"
                                                            v-model="(payment.item==null)?null:payment.item.description"
                                                            rows="2"
                                                            placeholder="@lang('layout.Description')"
                                                               >
                                                                
                                                            </textarea>
                                                        </td>
                                                        <td>
                                                            <span v-on:click="deleteItem('payment',index)"><i
                                                                        class="paddint-both glyphicon glyphicon-trash"></i></span>
                                                        </td>
                                                    </tr>
                                                    </tbody>

                                                </table>
                                                <!-- end payments -->



                                                <!--------------------------------------------------------------------------->

                                               <hr>
                                                 @if(getInvoicePayment()== "true")
                                                <!-- begin Invoic  payments -->
                                                <table id="table_content"
                                                       class="table table-striped table-bordered table-advance table-hover">
                                                    <thead>
                                                    <tr>
                                                        <th  colspan="6" 
                                                            style="min-width: 100px;">
                                                            <i class="fa fa-money" style="color: green"></i>&nbsp; @lang('layout.InvoicePayment') : (@lang('message.InvoicePaymetNote'))

                                                        </th>
                                                       

                                                    </tr> 

                                                    <tr>
                                                        <th class="text-center" style="min-width: 8px;"> #</th>
                                                        <th class="text-center"
                                                            style="min-width: 80px;">@lang('layout.Currency')<span class="required"> * </span></th>
                                                        <th class="text-center"
                                                            style="min-width: 120px;"> @lang('layout.Rate')<span class="required"> * </span></th>
                                                        <th class="text-center"
                                                            style="min-width: 80px;"> @lang('layout.Amount')<span class="required"> * </span></th>
                                                        <th class="text-center"
                                                            style="min-width: 100px;"> @lang('layout.Description')<span class="required"> * </span></th>


                                                        <th></th>

                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    <tr v-for="(payment_invoice,index) in payment_invoices">
                                                        <td>@{{index+1}}</td>
                                                    
                                                        <td>
                                                            <v-select label="code" 
                                                              :options="currency"
                                                              v-model="payment_invoice.selected_payment_currency"></v-select>

                                                             <input type="hidden" :name="'currency_payment['+index+']'"
                                                                 :value="(payment_invoice.selected_payment_currency==null)?null:payment_invoice.selected_payment_currency.code">

                                                        </td>
                                                        <td>
                                                            
                                                          <input type="number" :name="'currency_payment_rate['+index+']'" 
                                                           class="form-control"
                                                           v-model="(payment_invoice.selected_payment_currency==null)?payment_invoice.rate:payment_invoice.selected_payment_currency.rate"
                                                           :class="{'has-error':rate<=0}"
                                                           >
                                                        </td>
                                                        <td>
                                                           <input type="number" name="amount_payment[]" class="form-control" 
                                                           v-model="payment_invoice.amount" >
                                                        </td>

                                                           <td>
                                                            <textarea
                                                             class="form-control" 
                                                             name="payment_description[]" v-model="payment_invoice.description"></textarea>
                                                        </td>

                                                        <td>
                                                            <span v-on:click="deleteItem('payment_invoice',index)">
                                                                <i class="paddint-both glyphicon glyphicon-trash" style="color: red"></i>
                                                            </span>
                                                        </td>
                                                    </tr>

                                                    <tr style="background-color: #ffffff;">
                                                        <td></td>
                                                        <td>
                                                            <center>
                                                                <button type="button" @click="addNew('payment_invoice',1000)"
                                                                        class="btn btn-success">
                                                                        <i class="fa fa-plus"></i>
                                                                </button>
                                                            </center>
                                                        </td>
                                                        <td></td>
                                                        <td></td>
                                                        <td></td>
                                                        <td></td>
                                                    </tr>
                                                    </tbody>

                                                </table>
                                                <!-- end Invoice payments -->
                                                @endif
                                                <!--------------------------------------------------------------------------->
                                            </div>

                                            <!--Begin Draiver-->

                                            @if(getDriverInfo()=="true")
                                                <br>
                                                <table id="table_content"
                                                       class="table table-striped table-bordered table-advance table-hover">
                                                    <thead>
                                                    <tr>
                                                        <th class="text-center"
                                                            style="min-width: 8px;"> @lang('layout.DriverInfo') </th>

                                                    </tr>
                                                    </thead>
                                                </table>

                                                <div class="row">
                                                    <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                                        <!-- begin inputs -->
                                                        <div class="row">
                                                            <div class="col-md-3">
                                                                <div class="col-md-12">
                                                                    <label class="control-label ">@lang('layout.TransferCode')</label>
                                                                    {{Form::text('transfer_code',$invoice->transferCode,['class' => 'form-control','placeholder' => __('layout.TransferCode')])}}

                                                                </div>
                                                            </div>

                                                            <div class="col-md-3">

                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.Transporter_name')</label>
                                                                    <input type="test" name="transporter_name"
                                                                           value="{{$invoice->driver}}"
                                                                           class="form-control">

                                                                </div>
                                                            </div>
                                                            <div class="col-md-3">

                                                                <div class="col-md-12">
                                                                    <label class="control-label">@lang('layout.Transporter_phone')</label>
                                                                    <input type="test" name="transporter_phone"
                                                                           value="{{$invoice->driverPhone}}"
                                                                           class="form-control">

                                                                </div>
                                                            </div>
                                                            <div class="col-md-3">
                                                                <div class="col-md-12">
                                                                    <label class="control-label ">@lang('layout.PlaceOfWeight')</label>
                                                                    {{Form::text('palce_of_weight',$invoice->PlaceOfWeight,['class' => 'form-control','placeholder' => __('layout.PlaceOfWeight')])}}
                                                                </div>
                                                            </div>


                                                        </div>
                                                        <div class="row">

                                                            <div class="col-md-3">
                                                                <div class="col-md-12">
                                                                    <label class="control-label ">@lang('layout.SourcePlace')</label>
                                                                    {{Form::text('source_place',$invoice->sourcePlace,['class' => 'form-control','placeholder' => __('layout.SourcePlace')])}}
                                                                </div>
                                                            </div>
                                                            <div class="col-md-3">
                                                                <div class="col-md-12">
                                                                    <label class="control-label ">@lang('layout.PlateNumber')</label>
                                                                    <input type="text" name="plate_number"
                                                                           value="{{$invoice->plateNumber}}"
                                                                           placeholder="@lang('layout.PlateNumber')"
                                                                           class="form-control">

                                                                </div>
                                                            </div>
                                                            <div class="col-md-3">
                                                                <div class="col-md-12">
                                                                    <label class="control-label ">@lang('layout.WayBillNumber')</label>
                                                                    <input type="text" name="way_bill_number"
                                                                           value="{{$invoice->wayBillNumber}}"
                                                                           placeholder="@lang('layout.WayBillNumber')"
                                                                           class="form-control">

                                                                </div>
                                                            </div>
                                                            <div class="col-md-3">
                                                                <div class="col-md-12">
                                                                    <label class="control-label ">@lang('layout.TotalWeight')</label>
                                                                    <input type="text" name="total_weight"
                                                                           value="{{$invoice->totalWeight}}"
                                                                           placeholder="@lang('layout.TotalWeight')"
                                                                           class="form-control">
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="row">
                                                            <div class="col-md-3">
                                                                <div class="col-md-12">
                                                                    <label class="control-label ">@lang('layout.EmptyCarWeight')</label>
                                                                    <input type="text" name="empty_car_weight"
                                                                           value="{{$invoice->emptyCarWeight}}"
                                                                           placeholder="@lang('layout.EmptyCarWeight')"
                                                                           class="form-control">
                                                                </div>
                                                            </div>
                                                            <div class="col-md-3">
                                                                <div class="col-md-12">
                                                                    <label class="control-label ">@lang('layout.TotalBori')</label>
                                                                    <input type="text" name="total_bori"
                                                                           placeholder="@lang('layout.TotalBori')"
                                                                           value="{{$invoice->bori}}"
                                                                           class="form-control">
                                                                </div>
                                                            </div>
                                                            <div class="col-md-3">
                                                                <div class="col-md-12">
                                                                    <label class="control-label ">@lang('layout.Rent')</label>
                                                                    <input type="number" name="rent"
                                                                           placeholder="@lang('layout.Rent')"
                                                                           class="form-control"
                                                                           value="{{$invoice->rent}}"
                                                                           >
                                                                </div>
                                                            </div>

                                                            <div class="col-md-3">
                                                                <div class="col-md-12">
                                                                    <label class="control-label ">@lang('layout.Description')</label>
                                                                    {{Form::textarea('transfer_description',$invoice->trDesription,['class' => 'form-control','rows' => '3','placeholder' => __('layout.Description')])}}
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>

                                                </div>
                                            @endif
                                        <!--End Draiver-->

                                        <!--Begin Farmer Contract-->

                                        @if(systemConfig()[16] != 0)
                                        <br>
                                        <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                                            <thead>
                                                <tr>
                                                    <th class="text-center" style="min-width: 8px;"> @lang('layout.FarmerContract') </th>

                                                </tr>
                                            </thead>
                                        </table>
                                        <div class="row">
                                            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                                <!-- begin inputs -->
                                                <div class="row">
                                                    <div class="col-md-4">
                                                        <div class="col-md-12">
                                                            <label class="control-label ">@lang('layout.Number')</label>
                                                            <input type="text" name="far_number" value="{{($frarmerData)?$frarmerData->number:''}}" class="form-control">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="col-md-12">
                                                            <label class="control-label">@lang('layout.ReferenceNumber')</label>
                                                            <input type="text" name="far_ref_no" value="{{($frarmerData)?$frarmerData->ref_no:''}}" class="form-control">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="col-md-12">
                                                            <label class="control-label">@lang('layout.OverdueDate')</label>
                                                            <input type="test" name="far_overdue_date" value="{{($frarmerData)?$frarmerData->overdue_date:''}}" class="form-control date">
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-4">
                                                        <div class="col-md-12">
                                                            <label class="control-label ">@lang('layout.LandSize')</label>
                                                            <input type="text" name="far_land_size" value="{{($frarmerData)?$frarmerData->land_size:''}}" class="form-control">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="col-md-12">
                                                            <label class="control-label">@lang('layout.DrawingAmount')</label>
                                                            <input type="number" name="far_land_drawing_amount" value="{{($frarmerData)?$frarmerData->land_drawing_amount:''}}" class="form-control">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="col-md-12">
                                                            <label class="control-label">@lang('layout.Measure')</label> 
                                                            <select name="far_land_drawing_measure" class="form-control" v-model="far_drawing_measure" >
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <option v-for="measure in measureList" :value="measure.measure_id">
                                                                    @{{measure.measure_name}}
                                                                </option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-4">
                                                        <div class="col-md-12">
                                                            <label class="control-label ">@lang('layout.SeedAmount')</label>
                                                            <input type="number" name="far_seed_amount" v-model="far_seed_amount" class="form-control">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-4">
                                                        <div class="col-md-12">
                                                            <label class="control-label">@lang('layout.Measure')</label> 
                                                            <select name="far_measure_id" class="form-control" v-model="far_measure" >
                                                                <option value="null">@lang('layout.Select')</option>
                                                                <option v-for="measure in measureList" :value="measure.measure_id">
                                                                    @{{measure.measure_name}}
                                                                </option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        @endif
                                        <!--End Farmer Contract-->

                                        <!--Begin Carpet Contract-->
                                        @if(systemConfig()[21] == 1)
                                        <br/>
                                        <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                            <div class="form-group">
                                                <div class="col-md-12">
                                                    <label class="control-label">@lang('layout.WashingForm')</label>
                                                    <label class="mt-checkbox mt-checkbox-outline">
                                                        <input type="checkbox" name="washing_form" v-model="washing_form">
                                                        <span></span>
                                                    </label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row" v-show="washing_form">
                                            <table id="table_content" class="table table-striped table-bordered table-advance table-hover">
                                                <thead>
                                                    <tr>
                                                        <th class="text-center" style="min-width: 8px;"> @lang('layout.WashingForm') </th>
                                                    </tr>
                                                </thead>
                                            </table>
                                            <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                                <!-- begin inputs -->
                                                <div class="row">
                                                    <div class="col-md-3">
                                                        <label class="control-label">@lang('layout.DateIn')</label>
                                                        <input type="text" name="wash_date_in" class="form-control date" value="{{($washingData)?$washingData->date_in:''}}" autocomplete="off">
                                                    </div>
                                                    <div class="col-md-3">
                                                        <label class="control-label ">@lang('layout.Numbers')</label>
                                                        <input type="text" name="wash_number" value="{{($washingData)?$washingData->company_number:''}}" class="form-control">
                                                    </div>
                                                    <div class="col-md-3">
                                                        <label class="control-label ">@lang('layout.WashingCompanyNumber')</label>
                                                        <input type="text" name="wash_washing_company_number" value="{{($washingData)?$washingData->washing_company_number:''}}" class="form-control">
                                                    </div>
                                                    <div class="col-md-3">
                                                        <label class="control-label">@lang('layout.DeliveryDate')</label>
                                                        <input type="text" name="wash_delivery_date" value="{{($washingData)?$washingData->delivery_date:''}}" class="form-control date" autocomplete="off">
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="col-md-3">
                                                        <label class="control-label">@lang('layout.Type') @lang('layout.Carpet')</label>
                                                        <input type="text" name="wash_carpet_type" value="{{($washingData)?$washingData->carpet_type:''}}" class="form-control" autocomplete="off">
                                                    </div>
                                                    <div class="col-md-3">
                                                        <label class="control-label ">@lang('layout.Length')</label>
                                                        <input type="number" name="wash_length" v-model="wash_length" class="form-control">
                                                    </div>
                                                    <div class="col-md-3">
                                                        <label class="control-label ">@lang('layout.Width')</label>
                                                        <input type="number" name="wash_width" v-model="wash_width" class="form-control">
                                                    </div>
                                                    <div class="col-md-3">
                                                        <label class="control-label ">@lang('layout.Area') @lang('layout.Total')</label>
                                                        <input type="number" :value="myRound(wash_length * wash_width)" class="form-control">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <br/>
                                        @endif
                                        <!--End Carpet Contract-->

                                            @if(getInvoiceTotal() == 'true')
                                            <!-- begin total -->
                                                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                                    <div class="dashboard-stat2 " v-show="seePrice== true">
                                                        <table class="dashboard-tabel" width="100%">
                                                            <tr>
                                                                <td>
                                                                    <small>@lang('layout.GrandTotal'):</small>
                                                                </td>
                                                                <td class="text-right">
                                                                <span class="text-right" data-counter="counterup"
                                                                        data-value="7800">@{{ subtotal.toFixed(precision())}}</span>
                                                                    <small class="font-green-sharp">
                                                                        @{{selected_currency.symbol}}
                                                                    </small>
                                                                </td>
                                                                <td>
                                                                    <small>@lang('layout.Payment'):</small>
                                                                </td>
                                                                <td class="text-right">
                                                                    <small class="font-green-sharp">
                                                                    <span class="text-right" data-counter="counterup"
                                                                            data-value="7800">@{{ payeds.toFixed(precision())}}</span>
                                                                        <small class="font-green-sharp">
                                                                            @{{selected_currency.symbol}}
                                                                        </small>
                                                                    </small>
                                                                </td>
                                                                <td>
                                                                    <small>@lang('layout.Discount'): (@{{
                                                                        Number.parseFloat(discount).toFixed(precision())
                                                                        }}%)
                                                                    </small>
                                                                </td>
                                                                <td class="text-right">
                                                                    <span class="text-right" data-counter="counterup" data-value="7800">
                                                                        @{{ format_number(Number.parseFloat(discount*(newSubTotal - newSubDiscountFiledRow)/100)+Number.parseFloat(discountFiledRow)) }}
                                                                    </span>
                                                                    <small class="font-green-sharp">
                                                                        @{{selected_currency.symbol}}
                                                                    </small>
                                                                </td>
                                                                <td>
                                                                    <small>@lang('layout.Total') :</small>
                                                                </td>
                                                                <td class="text-right"><span data-counter="counterup" data-value="7800">
                                                                    @{{ format_number(Number.parseFloat(((subtotal - (discount*(newSubTotal - newSubDiscountFiledRow)/100) - discountFiledRow) - saleTaxation)-payeds))}}    
                                                                </span>
                                                                    <small class="font-green-sharp">
                                                                        @{{selected_currency.symbol}}
                                                                    </small>
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </div>
                                                </div>
                                                <!-- end total -->
                                            @endif
                                            <div class="row">
                                            @if(getPrintDescription()=="true")                      
                                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                    <div class="form-group">
                                                        <div class="col-md-12">
                                                            <label class="control-label">@lang('layout.PrintDescription')</label>
                                                            <textarea name="print_description" class="form-control"
                                                                        rows="2">{{$invoice->print_description}}</textarea>
                                                        </div>
                                                    </div>
                                                </div>
                                            @endif
                                            @if(getHesabSabeqa() =='true')                    
                                                <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                    <div class="form-group">
                                                        <div class="col-md-12">
                                                            <label class="control-label">@lang('layout.HesabSabiqa')</label>
                                                                <label class="mt-checkbox mt-checkbox-outline">
                                                                    <input type="checkbox"  name="hesab_sabeqa" value="ok" v-model="hesab_sabeqah_checked" >
                                                                    <span></span>
                                                                </label>
                                                        </div>
                                                    </div>
                                                </div>
                                            @endif

                                            <div class="col-lg-4 col-md-4 col-sm-12 col-xs-12">
                                                <div class="form-group">
                                                    <div class="col-md-12">
                                                        <label class="control-label">@lang('layout.ShowReceivables')</label>
                                                            <label class="mt-checkbox mt-checkbox-outline">
                                                                <input type="checkbox"  name="show_receive" value="ok" v-model="show_receive_checked" >
                                                                <span></span>
                                                            </label>
                                                    </div>
                                                </div>
                                            </div>

                                            </div>
                                            <div class="row">
                                                <div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                                    <div class="form-group">
                                                        <div class="col-md-12">
                                                            <label class="control-label">@lang('layout.Memo')</label>
                                                            <textarea name="memo" class="form-control" rows="2">{{$invoice->memo}}</textarea>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                                            <button type="button" v-if="isError1 ==false" v-if="!isError" @click="submitForm" :disabled="disabled" class="btn green">@lang('layout.Update')</button>
                                            <button type="button" v-if="((!isError) && (isError1 == false))" :disabled="disabled" class="btn blue" @click="saveAndNew($event)">@lang('layout.Check') / @lang('layout.Update')</button>
                                        
                                            <a href="{{route('invoice.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>

                                        </div>
                                        <cmodal :show='showModal' @close="showModal=false">

                                        </cmodal>
                                    </div>


                                </div>


                                {!! Form::close() !!}

                            </div>

                        </div>


                    </div>
                    <p> &nbsp; </p>
                    <p> &nbsp; </p>
                </div>
            </div>
            <!-- END TAB PORTLET-->
        </div>
    </div>

@endsection
@push('scripts')


    <script type="text/javascript">
        Vue.component('v-select', VueSelect.VueSelect);
                                                                        
        Vue.use(VueInputAutowidth)

        Vue.component("modal", {
            template: "#modal-template",
            props: ['show'],

        });

        //begin new member
        Vue.component("cmodal", {
            template: '#cmodal-template',

            props: ['show'],
            data() {
                return {
                    types: [],
                    classes: [],
                    receivables: [],
                    payables: [],
                    code: null,
                    selectType: null,
                    selectPay: null,
                    selectedClass: null,
                    selectReceive: null,
                }
            },
            created() {

                axios.get('{{route("customer.create")}}').then(
                    response => {
                        this.types = response.data.types;
                        if (this.types) {
                            for (var i = 0; i < this.types.length; i++) {
                                if (this.types[i].type == "Customer") {
                                    this.selectType = this.types[i];
                                }
                            }
                        }
                        this.receivables = response.data.receivable;
                        this.payables = response.data.payable;
                        this.code = response.data.code;
                        this.classes = response.data.member_class;
                        if(this.receivables.length>0)
                        {
                            this.selectReceive=this.receivables[0];
                        }
                        if(this.payables.length>0)
                        {
                            this.selectPay=this.payables[0];
                        }


                    }).catch(error => console.log(error));
            },
            methods: {
                onSubmit() {

                    v.showModal = false;
                    var datas = $("#modalForm").serializeArray();
                    $.ajax({
                        headers: {'X-CSRF-TOKEN': "{{csrf_token()}}"},
                        url: '{{route("customer.store")}}',
                        method: 'post',
                        data: {
                            "name": datas[0]['value'],
                            "code": datas[1]['value'],
                            'email': datas[2]['value'],
                            'phone': datas[3]['value'],
                            'address1': datas[4]['value'],
                            'type': this.selectType.id,
                            'receivable': this.selectReceive.id,
                            'payable': this.selectPay.id,
                            'class': (this.selectedClass) ? this.selectedClass.id : null
                        },
                        dataType: 'json',

                    }).done(function (response) {
                        if (response) {
                            v.selected_customer = response.customer;
                        }

                    }).fail(function (error) {
                        console.log('error', error);
                    });

                }
            }
        });

        // end new member

        var seePrice ={!! $seePrice !!};
        var seeCost ={!! $seeCost !!};
        var currency ={!! $currency !!};
        var currency1 ={!! $currency !!};
        var selectedCurrency = {!! $selectedCurrency !!};
        var banks = {!! $banks !!};
        var selectedBanks = {!! $selectedBanks !!};
        var all_services = {!! $all_services !!};
        var selectedService = {!! $selectedService !!};
        var selectedItem = {!! $selectedItem !!};
        var invoice = {!! $invoice !!};
        var inventory_category = {!! $inventory_category !!};
        var memberClass = {!! $memberClass !!};
        var saleArea = {!! $saleArea !!};
        var transportCompany         = {!! $transportCompany !!};
        var allDrivers               = {!! $allDrivers !!};
        var selectedTransportCompany = {!! $selectedTransportCompany !!};
        var selectedDriver           = {!! $selectedDriver !!};
        var selected_invoice_payment = {!! $selected_invoice_payment !!};
        var taxation = {!! $taxation !!};
        var commission = {!! $commission !!};
        var discountDate = {!! $discountDate !!};
        var priceLevel = {!!$priceLevel!!};
        var priceLevelGeneral = {!!$priceLevelGeneral!!};
        var selected_priceLevel = {!!$selected_priceLevel!!};
        var receive_number = {!!json_encode($receive_number)!!}; 
        var frarmerData = {!! json_encode($frarmerData) !!}; 
        var measureList = {!! $measureList !!}; 
        var member_cloth_id = {!!json_encode($invoice->member_cloth_id)!!};
        var inventoryBrand = {!!$inventoryBrand!!};
        var inventory_sites = {!!$inventory_sites!!};

        var v = new Vue({
            el: '#appInvoice',
            data: {
                showModal: false,
                oil_sale:{{($invoice->oil == 1)?'true':'false'}},
                invoice: invoice,
                per_qty_check:{{($invoice->per_qty == 'on')?'true':'false'}},
                customer: [],
                all_customer: [],
                seePrice: seePrice,
                seeCost: seeCost,
                selected_customer:{!!$selectedCustomer!!},
                selected_item: selectedItem,
                banks: banks,
                selected_banks: selectedBanks,
                all_services: all_services,
                selected_service: selectedService,
                currency: currency,
                selected_currency: selectedCurrency,
                selected_payment_currency: null,
                rate: 0,
                discountFiled: 0,
                discountFiledRow: 0,
                sale_taxation: invoice.sale_taxation,
                saleTaxation: 0,
                discountIsAmount: false,
                disabled: false,
                taxation: taxation,
                selected_taxation: null,
                commission: commission,
                selected_commission: null,
                subTotalCommi:0,
                totalCommi:0,
                discount_date: discountDate,
                selected_discount_date: null,
                totalTax: 0,
                subTotalTax: 0,
                brandItem: inventoryBrand,
                selected_iventory_brand: null,
                subDiscountFiledRow: 0,
                newSubDiscountFiledRow: 0,
                newSubTotal: 0,
                washing_form: false,
                wash_width: 0,
                wash_length: 0,
                inventory_category: inventory_category,

                inventory_sites: inventory_sites,
                selected_iventory_site: null,
                selected_inventory: null,
                selected_itemes: null,
                selected_quantity: null,
                selected_quantity_error: false,
                selected_price: null,
                AdvancePrice: null,
                AdvancePrice_cost: null,
                last_item_sale:null,
                last_item_purchase:null,

                selected_index: 0,
                temp_items: [],
                totalAmountes: [],
                newCost: [
                    null,
                    null,
                    null,
                    null],
                inventories: [],
                services: [],
                payments: [],
                payment_invoices: [],
                CusTypes: null,
                memberClass: memberClass,
                selected_class: null,
                saleArea: saleArea,
                selected_area: null,
                ref_no: "{{$invoice->ref_Number}}",
                msg: '',
                isError1: false,

                transportCompany: transportCompany,
                allDrivers: allDrivers,
                selected_transportCompany: selectedTransportCompany,
                selected_transportDriver: selectedDriver,
                t_drivers: allDrivers,
                selected_invoice_payment: selected_invoice_payment,
                summary: [],
                hesab_sabeqah_checked:"{{$invoice->hesab_sabeqa}}",
                show_receive_checked:"{{$invoice->show_receive}}",
                priceLevel:priceLevel,
                selected_priceLevel:null,
                priceLevelGeneral: priceLevelGeneral,
                selected_priceLevelGeneral: null,
                receive_number:receive_number,
                frarmerData: frarmerData,
                measureList: measureList,
                far_measure: null,
                far_drawing_measure: null,
                far_seed_amount: 0,
                member_cloth_list:[],
                selectedMemberCloth:null,
                member_cloth_id:member_cloth_id
            },
            computed: {

                selectedRate() {
                    this.rate = (this.selected_currency) ? this.selected_currency.rate : 0;

                },
                discount() {
                    if("{{getSubTotal()}}"=="true" && this.sub_Subtotal > 0){
                        this.newSubTotal = this.sub_Subtotal;
                        this.newSubDiscountFiledRow = this.subDiscountFiledRow;
                    }else{
                        this.newSubTotal = this.subtotal;
                        this.newSubDiscountFiledRow = this.discountFiledRow;
                    }
                    if (this.discountIsAmount) {
                        if (this.newSubTotal > 0 && this.discountFiled) {
                            return (parseFloat(this.discountFiled) * 100) / (this.newSubTotal - this.discountFiledRow);
                        } else {
                            return 0;
                        }
                    } else {

                        return this.discountFiled
                    }
                },

                sub_discount() {
                    if (this.discountIsAmount) {
                        if (this.sub_Subtotal > 0 && this.discountFiled) {
                            return (parseFloat(this.discountFiled) * 100) / (this.sub_Subtotal - this.subDiscountFiledRow);
                        } else {
                            return 0;
                        }
                    } else {
                        return this.discountFiled
                    }
                },
				
				// calculate subtotal
                checkedSubtotal: function () {
                    var sum = 0;
                    var sumTax = 0;
                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].item && this.inventories[i].item != null) {
                        if (this.inventories[i].tax) {

							if(this.oil_sale == true){
                            var quantity = this.inventories[i]['item']['oil_qty'];
							}else{
                            var quantity = this.inventories[i]['item']['quantity'];
							}
                            if (this.inventories[i]['item']['other_measure'] > 0 && this.per_qty_check) {
                                var quantity = this.inventories[i]['item']['other_measure'];
                            }
                            var rate = this.inventories[i]['item']['rate'];
                            var new_rate = this.inventories[i]['item']['new_rate'];
                            var smeasure_unit = this.inventories[i]['item']['measure']['measure_unit'];
                            var measure_unit = this.inventories[i]['item']['measure_unit'];
                            if (new_rate != rate && quantity > 0) {
                                sum += new_rate * quantity * this.selected_currency.rate;
                            }
                            else {
                                sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
                            }
							
                        }else{

							if(this.oil_sale == true){
                            var quantity = this.inventories[i]['item']['oil_qty'];
							}else{
                            var quantity = this.inventories[i]['item']['quantity'];
							}
                            if (this.inventories[i]['item']['other_measure'] > 0 && this.per_qty_check) {
                                var quantity = this.inventories[i]['item']['other_measure'];
                            }
                            var rate = this.inventories[i]['item']['rate'];
                            var new_rate = this.inventories[i]['item']['new_rate'];
                            var smeasure_unit = this.inventories[i]['item']['measure']['measure_unit'];
                            var measure_unit = this.inventories[i]['item']['measure_unit'];
                            if (this.inventories[i]['selected_taxation'] != null) {
                            var selected_taxation = this.inventories[i]['selected_taxation']['percent'];
                            
                            if (new_rate != rate && quantity > 0) {
                                sumTax += ((new_rate * quantity * this.selected_currency.rate) * selected_taxation) / 100;
                                this.inventories[i]['row_tax_amount'] = ((new_rate * quantity * this.selected_currency.rate) * selected_taxation) / 100;
                            }
                            else {
                                sumTax += ((quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate)) * selected_taxation) / 100;
                                this.inventories[i]['row_tax_amount'] = ((quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate)) * selected_taxation) / 100;
                            }
							}
							
                        }
                        }
                    }
					
					if(this.selected_taxation){
						var percent = this.selected_taxation.percent;
						this.totalTax = ((sum * percent)/100)+sumTax;
						this.subTotalTax = ((sum * percent)/100);
					}

                    if (this.selected_commission) {
                        var percent = this.selected_commission.percent;
                        this.totalCommi = ((sum * percent) / 100);
                        this.subTotalCommi = ((sum * percent) / 100);
                    }else{
                        this.totalCommi = 0;
                        this.subTotalCommi = 0;
                    }

                    return sum;
                },

                // calculate subtotal
                sub_Subtotal: function () {
                    var sum = 0;
                    var sum_discount = 0;
                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].item && this.inventories[i].item != null) {
                        if (this.inventories[i].sub_total) {

							if(this.oil_sale == true){
                            var quantity = this.inventories[i]['item']['oil_qty'];
							}else{
                            var quantity = this.inventories[i]['item']['quantity'];
							}
                            if (this.inventories[i]['item']['other_measure'] > 0 && this.per_qty_check) {
                                var quantity = this.inventories[i]['item']['other_measure'];
                            }
                            var rate = this.inventories[i]['item']['rate'];
                            var new_rate = this.inventories[i]['item']['new_rate'];
                            var smeasure_unit = this.inventories[i]['item']['measure']['measure_unit'];
                            var measure_unit = this.inventories[i]['item']['measure_unit'];

                            var discount = this.inventories[i]['item']['discount'];

                            if (new_rate != rate && quantity > 0) {
                                sum += new_rate * quantity * this.selected_currency.rate;
                                if (this.discountIsAmount) {
									if (discount > 0) {
								     sum_discount += (discount * quantity);
									}
								} else {

									if (discount > 0) {
									sum_discount += (parseFloat(discount) * (new_rate * quantity * this.selected_currency.rate)) / 100;
									}
								}
                            }
                            else {
                                sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
                                if (this.discountIsAmount) {
									if (discount > 0) {
								     sum_discount += (discount * quantity);
									}
								} else {

									if (discount > 0) {
										sum_discount += (parseFloat(discount) * (quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate))) / 100;
									}
								}
                            }
							
                        }
                        }
                    }
                    this.subDiscountFiledRow = sum_discount;
                    if("{{getSubTotal()}}"=="true" && sum > 0){
                        this.newSubTotal = sum;
                        this.newSubDiscountFiledRow = sum_discount;
                    }else{
                        this.newSubTotal = this.subtotal;
                        this.newSubDiscountFiledRow = this.discountFiledRow;
                    }
                    return sum;
                },

                // calculate subtotal
                subtotal: function () {
                    var sum = 0;
                    var sum_discount = 0;
                    for (var i = 0; i < this.inventories.length; i++) {
                        if (this.inventories[i].item && this.inventories[i].item != null) {

							if(this.oil_sale == true){
                            var quantity = this.inventories[i]['item']['oil_qty'];
							}else{
                            var quantity = this.inventories[i]['item']['quantity'];
							}
							if (this.inventories[i]['item']['other_measure'] > 0 && this.per_qty_check) {
                                var quantity = this.inventories[i]['item']['other_measure'];
                            }
                            var rate = this.inventories[i]['item']['rate'];
                            var new_rate = this.inventories[i]['item']['new_rate'];
                            var smeasure_unit = this.inventories[i]['item']['measure']['measure_unit'];
                            var measure_unit = this.inventories[i]['item']['measure_unit'];
                            var discount = this.inventories[i]['item']['discount'];
                            if (new_rate != rate && quantity > 0) {
                                sum += new_rate * quantity * this.selected_currency.rate;
                                if (this.discountIsAmount) {
									if (discount > 0) {
								     sum_discount += (discount * quantity);
									}
								} else {

									if (discount > 0) {
									sum_discount += (parseFloat(discount) * (new_rate * quantity * this.selected_currency.rate)) / 100;
									}
								}
                            }
                            else {
                                sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
                                if (this.discountIsAmount) {
									if (discount > 0) {
								     sum_discount += (discount * quantity);
									}
								} else {

									if (discount > 0) {
										sum_discount += (parseFloat(discount) * (quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate))) / 100;
									}
								}
                            }

                        }
                    }

                    this.discountFiledRow = sum_discount;
					@if(getSaleTaxation() == 'true')
					this.saleTaxation = (this.sale_taxation*sum/100);
					@endif
                    for (var i = 0; i < this.services.length; i++) {
                        if (this.services[i].item && this.services[i].item != null) {

                            var rate = this.services[i]['item']['rate'];
                            var new_rate = this.services[i]['item']['new_rate'];
                            var smeasure_unit = this.services[i]['item']['measure']['measure_unit'];
                            var measure_unit = this.services[i]['item']['measure_unit'];
                            var quantity = this.services[i]['item']['quantity'];
                            if (new_rate != rate && quantity > 0) {
                                sum += new_rate * quantity * this.selected_currency.rate;
                            }
                            else {
                                sum += quantity * ((rate * smeasure_unit / measure_unit) * this.selected_currency.rate);
                            }

                        }
                    }
					
					if(this.selected_taxation){
						var tax1 = this.checkedSubtotal;
						var tax = this.totalTax;
						sum = tax+sum;
					}

                    if (this.selected_commission) {
                        var commi = this.totalCommi;
                        sum = commi + sum;
                    }
					
                    return sum;
                },

                // check payed amount
                payeds: function () {
                    var sum = 0;
                    for (var i = 0; i < this.payments.length; i++) {

                        if (this.payments[i].item != null && this.payments[i].item) {
                            if (this.payments[i].item != null && this.payments[i]['item']['rate'] > 0) {
                                //
                                sum += (this.payments[i]['item']['amount'] * this.selected_currency.rate / this.payments[i]['item']['rate']);
                            }
                        }
                    }
                    return sum;
                },

                // check data validation
                isError: function () {
                    var isError = false;
                    //var flag=false;
                    // for (var i = 0; i < this.inventories.length; i++)
                    // {

                    //    if (this.inventories[i].item)
                    //    {
                    //      flag=true;
                    //      if(((this.inventories[i]['item']['rate'] <=0) ))
                    //      {
                    //        rate=this.inventories[i]['item']['rate'];
                    //        new_rate=this.inventories[i]['item']['new_rate'];
                    //        if(rate <=0 && new_rate <=0)
                    //        {
                    //             isError = true;
                    //        }

                    //      }
                    //    }
                    // }
                    if (this.selected_customer == undefined || this.selected_customer == null) {
                        isError = true;
                    }
                    return isError;


                },
            },
            mounted: function () {

                @if(getShwoPriceLevel()=="general")
                    this.selected_priceLevel = selected_priceLevel;
                @endif

                @if(getShwoPriceLevel()=="general_percent")
                    this.selected_priceLevelGeneral = selected_priceLevel;
                @endif

                // initialize the selected item

                // for (var i = 0; i < this.selected_item.length; i++) {
				// 		// console.log('llllp',this.selected_item[i]);
				// 	if(this.oil_sale == true){
				// 		this.selected_item[i]['new_rate'] = this.selected_item[i]['new_rate'] * this.selected_item[i]['density'];
				// 		this.selected_item[i]['rate'] = this.selected_item[i]['rate'] * this.selected_item[i]['density'];
				// 		this.selected_item[i]['cost'] = this.selected_item[i]['cost'] * this.selected_item[i]['density'];
				// 	}
					
				// 	var selected_taxations = null;
				// 	if (this.selected_item[i].row_taxation_id && this.taxation) {
				// 		selected_taxations = _.find(this.taxation, (s) => s.id == this.selected_item[i].row_taxation_id);
				// 		selected_taxations.percent = this.selected_item[i].row_tax_percent;
                //     }
                    
                //     var price_level = this.selected_item[i].price_level;
                //     @if(getShwoPriceLevel()=="general_percent_per_item")
				// 	if (this.selected_item[i].price_level_id) {
				// 		price_level = _.find(this.priceLevelGeneral, (s) => s.id == this.selected_item[i].price_level_id);
                        
                //     }
                //     @endif
                    
                //     this.inventories.push({
                //         inventory: this.selected_item[i],
                //         item: this.selected_item[i],
                //         selected_taxation: selected_taxations,
                //         tax: this.selected_item[i].row_tax_stat,
                //         sub_total: this.selected_item[i].sub_total_stat,
                //         item_category: this.selected_item[i].item_category,
                //         item_brand: this.selected_item[i].inventory_brand,
                //         price_level:price_level
                //     });
                // }
                for (var m = 2; m > 0; m--) {
                    this.inventories.push({inventory: null, item: null, location: null, item_category: null, item_brand: null, tax: 'on', edit: true, selected_taxation: null, sub_total: '',price_level:null});
                }
                // end item
                ////////////////////////////////////////////////////////////////////////////////
                // for (var p = 0; p < this.selected_invoice_payment.length; p++) {
                //     var selected_payment_currency = _.find(currency1,(v)=>v.code==this.selected_invoice_payment[p].currency);
                //     if (selected_payment_currency) {
                //         selected_payment_currency.rate = this.selected_invoice_payment[p].rate;
                //     }
                //     this.payment_invoices.push({
                //         amount: this.selected_invoice_payment[p].amount,
                //         description: this.selected_invoice_payment[p].description,
                //         rate: this.selected_invoice_payment[p].rate,
                //         selected_payment_currency:selected_payment_currency
                //     });
                // }
                // for (var q = 2; q > this.selected_invoice_payment.length; q--) {
                    this.payment_invoices.push({amount: null,description: null,rate: null,selected_payment_currency:null});
                // }
                // console.log('llllllll',this.payment_invoices)
                
                ////////////////////////////////////////////////////////////////////////////////
                // begin payment initialization

                // for (var t = 0; t < this.selected_banks.length; t++) {
                //     var foundFlag = false;
                //     var tempBank = null;
                //     for (var y = 0; y < this.banks.length; y++) {
                //         if (this.selected_banks[t].id == this.banks[y].id) {
                //             foundFlag = true;
                //             tempBank = this.banks[y];
                //             tempBank.amount = this.selected_banks[t].balance;
                //             tempBank.rate = this.selected_banks[t].rate; 
                            
                //             tempBank.description = this.selected_banks[t].description;
                //             tempBank.number = this.selected_banks[t].number;
                //         }
                //     }
                //     if (foundFlag) {
                //         this.payments.push({item: tempBank, items: this.banks});
                //     }
                // }
                // for (var w = 1; w > this.selected_banks.length; w--) {
                    this.payments.push({item: null, items: banks});
                // }
                // end payment initialization

                // begin service

                // for (var r = 0; r < this.selected_service.length; r++) {
                //     var flag = false;
                //     var tempService;
                //     for (var h = 0; h < this.all_services.length; h++) {
                //         if (this.all_services[h].id == this.selected_service[r].item_id) {
                //             flag = true;
                //             tempService = this.all_services[h];
                //             tempService.quantity = this.selected_service[r].qty;
                //             tempService.rate = this.selected_service[r].sales_price;
                //             tempService.new_rate = this.selected_service[r].sales_price;
                //             tempService.online_order_detail_id = this.selected_service[r].online_order_detail_id;
                //             tempService.order_detail_id = this.selected_service[r].order_detail_id;
                //             tempService.description = this.selected_service[r].description;
                //             tempService.description2 = this.selected_service[r].description2;
                //         }
                //     }
                //     if (flag) {
                //         this.services.push({item: tempService, items: this.all_services})
                //     }
                // }
                // for (var w = 1; w > this.selected_service.length; w--) {
                    this.services.push({item: null, items: all_services});
                // }
                // end service

                if (this.invoice) {
                    // this.selected_customer=_.find(this.all_customer,(v)=>v.id==this.invoice.member_id);
                    this.selected_class = _.find(this.memberClass, (c) => c.id == this.invoice.class_id);
                    this.selected_area = _.find(this.saleArea, (s) => s.id == this.invoice.sale_area_id);

                    this.discountFiled = this.invoice.discount;
                    if (this.invoice.discount_type) {
                        if (this.invoice.discount_type == 'percent') {
                            this.discountIsAmount = false;
                        }
                        else {
                            this.discountIsAmount = true;
                        }
                    }
					
					if (this.invoice.taxation_id && this.taxation) {
						this.selected_taxation = _.find(this.taxation, (s) => s.id == this.invoice.taxation_id);
						this.selected_taxation.percent = this.invoice.tax_percent;
                    }
					
					if (this.invoice.commission_id && this.commission) {
						this.selected_commission = _.find(this.commission, (s) => s.id == this.invoice.commission_id);
						this.selected_commission.percent = this.invoice.commission_percent;
                    }
					if (this.invoice.sale_discount_id && this.discount_date) {
						this.selected_discount_date = _.find(this.discount_date, (s) => s.id == this.invoice.sale_discount_id);
                    }
					
                }

                @if(systemConfig()[16] != 0 && $frarmerData) 
                    this.far_seed_amount = {{$frarmerData->seed_amount}};
                    this.far_drawing_measure = {{$frarmerData->land_drawing_measure}};
                    this.far_measure = {{$frarmerData->measure_id}}; 
                @endif

                @if(systemConfig()[21] != 0 && $washingData) 
                    this.washing_form = true;
                    this.wash_width = {{$washingData->width}};
                    this.wash_length = {{$washingData->length}};
                @endif
            },
            methods:
                {
                  getSummary() {
                        if (this.selected_customer) {
                            this.member_cloth_list = [];
                            this.selectedMemberCloth = null;
                            this.getSummaryRecor(this.selected_customer.id, this);
                            this.take_member_cloth_data(this);

                        }

                    },
                    getSummaryRecor(id, v) {
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'memberStatment',
                                member_id: id,
                            }
                        })
                            .then(function (response) {
                                if (response.data.length > 0) {
                                    v.summary = response.data;
                                }
                                else
                                {
                                    v.summary=[];
                                }
                            })
                            .catch(function (error) {
                                console.log(error);
                            });
                    },

                    take_member_cloth_data(v) {

                        axios.get("{{route('member.memberCloth')}}", {
                            params: {
                                member_id: this.selected_customer.id
                            },
                        }).then(function (response) {
                            v.member_cloth_list = response.data;

                            for (var j = 0; j < v.member_cloth_list.length; j++) {
                                if (this.member_cloth_id != null && v.member_cloth_list[j].id == this.member_cloth_id) {
                                    v.selectedMemberCloth= v.member_cloth_list[j];
                                    // console.log('ppppsss',v.selectedProject);
                                }
                            }

                        })
                            .catch(function (error) {
                                console.log(error);
                            });
                        }, 


                    checkRefNo() {

                        //console.log(vm.ref_no)

                        var chack = 'false';
                        var ref_no = v.ref_no;
                        if (ref_no != null) {


                            axios.get("{{route('callMethod.search')}}",
                                {

                                    params: {
                                        ref_no: v.ref_no,
                                        method_name: 'Search_ref_no',
                                        table_name: 'sales'
                                    },
                                })
                                .then(function (response) {
                                    // console.log(response.data.result);
                                    if (response.data.result != null) {
                                        console.log(response.data.result);
                                        // v.temp_items=response.data;
                                        v.msg = "@lang('layout.DuplicateData')";
                                        v.isError1 = true;
                                    }
                                    else {
                                        v.msg = 'no';
                                        v.isError1 = false;

                                    }
                                })
                                .catch(function (error) {
                                    console.log(error);
                                });

                        }
                    },
					
					ChangeOil() {
                        if (v.oil_sale == false) {
							v.oil_sale = true;
                        }else{
							v.oil_sale = false;
						}
						// console.log(v.oil_sale);
                    },
					change_oil_qty(index) {
                        if (this.inventories[index]['item'] && this.inventories[index]['item'] != null) {
							
							var quantity = this.inventories[index]['item']['quantity'];
							var density = this.inventories[index]['item']['density'];
							if(quantity > 0 && density > 0){
							this.inventories[index]['item']['oil_qty'] = myRound(quantity / density);
							}
							var oil_qty = this.inventories[index]['item']['oil_qty'];
                        }

                        var far_seed_amount = 0;
                        for (var i = 0; i < this.inventories.length; i++) {
                            if (this.inventories[i].item && this.inventories[i].item != null) {
                                var quantity = this.inventories[i]['item']['quantity'];
                                far_seed_amount += quantity;
                            }
                        }
                        // if (this.inventories[0].item) {
                        //     v.far_measure = this.inventories[0]['item']['measure']['measure_id'];
                        // }
                        this.far_seed_amount = far_seed_amount;
                    },

                    change_per_qty(index) {
                        if (this.inventories[index]['item'] && this.inventories[index]['item'] != null) {
							var other_measure = this.inventories[index]['item']['other_measure'];
                            var per_qty = this.inventories[index]['item']['site']['per_qty'];
                            // console.log(222, other_measure , per_qty , this.per_qty_check );
							if(other_measure > 0 && per_qty > 0 && this.per_qty_check){
							this.inventories[index]['item']['quantity'] = myRound(other_measure * per_qty);
							}
                        }
                    },

                    subMQuantity(item = null, quantity = null) {
						if (item != null) {
							var result = 0;
							if (item.site) {
								// console.log(38383,item.measureListAll.length);
								
								for (var i = 0; i < item.measureListAll.length; i++) {
								// console.log(3838,item.measureListAll[i]);
									if (item.measureListAll[i].measure_id == item.measure2.measure_id) {
										result = (quantity * item.measure.measure_unit) / (item.measure_unit);
										result = (result * item.measure_unit) / (item.measureListAll[i].measure_unit);
									}
								}
								
								
							}
							return result;
						}
					},
                    secoundMeasurQuantity(item = null, quantity = null) {
						if (item != null) {
							var result = 0;
							if (item.site) {
								// console.log(38383,item.measureListAll.length);
								if(item.measureListAll){
                                    for (var i = 0; i < item.measureListAll.length; i++) {
								// console.log(3838,item.measureListAll[i],item.measure_unit,item.measure.measure_unit);
									if (item.measureListAll[i].measure_id == item.measure1.measure_id) {
										result = (quantity * item.measure.measure_unit) / (item.measure_unit);
										result = (result * item.measure_unit) / (item.measureListAll[i].measure_unit);
									}
								}
                                }
							
								
								
							}
							return result;
						}
					},
					
                    memberClassChange() {
                        if (v.selected_class) {
                            v.customer = [];
                            // v.selected_customer = null;
                            let class_id = v.selected_class.id;
                        
                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    method_name: 'SearchMember',
                                    class_id: class_id,
                                    type: 'Customer'
                                }
                            })
                            .then(function(response) {
                                if (response.data.length > 0) {
                                    // console.log(response.data);
                                    v.customer = [];
                                    v.customer = response.data;
                                }
                            })
                            .catch(function(error) {
                                console.log(error);
                            })
                        }
                    },
                    MemberSearch: _.debounce((search, loading) => {
                        loading(true);
                        let class_id = (v.selected_class != undefined) ? v.selected_class.id : null;
                        
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                method_name: 'SearchMember', 
                                keyword: search,
                                class_id: class_id,
                                type: 'Customer'
                            }
                        })
                        .then(function(response) {
                            if (response.data.length > 0) {
                                // console.log(response.data);
                                v.customer = [];
                                v.customer = response.data;
                            }
                            loading(false);
                        })
                        .catch(function(error) {
                            loading(false);
                            console.log(error);
                        })
                    }, getDebounceTime()),

                    // calculate item price based on measure change
                    measureChange(index) {

                        if (this.inventories[index].item != null) {
                            var item = this.inventories[index].item;

                            var temp = ((item.rate * item.measure.measure_unit / item.measure_unit));
                            result = Number.parseFloat(temp).toFixed(precision());

                            this.inventories[index].item.new_rate = result;

                            // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;

                        }
                    },

                    // Change Item Sale Rate According Item Price Level
                    change_sale_rate_by_price_level(index){

                        if (this.inventories[index].item != null) {

                            var item = this.inventories[index].item;
                            var item_price_level = this.inventories[index].item.item_price_level;


                            var temp = ((item.rate * item.measure.measure_unit / item.measure_unit));
                            result = Number.parseFloat(temp).toFixed(precision());
                            this.inventories[index].item.new_rate = result;

                            var myDataArray=  this.inventories[index].item.item_price_level;
                                if(this.inventories[index].price_level!=undefined){
                                    var item = this.inventories[index].item;
                                    for(var i=0;i<myDataArray.length;i++)
                                    {
                                        if (myDataArray[i]['id'] == this.inventories[index].price_level.id) { 
                                            var temp = ((myDataArray[i]['rate'] * item.measure.measure_unit / item.measure_unit));
                                            result = Number.parseFloat(temp).toFixed(precision());

                                            // if(this.selected_currency.rate > 0){
                                            //     item.new_rate = myRound((result)/this.selected_currency.rate);
                                            // }else{
                                                item.new_rate = myRound(result);
                                            // }
                                        }
                                    
                                    }
                                }
                        }
                    },

                    // Change Item Sale Rate According Item Price Level
                    change_sale_rate_by_price_level_general_per_item(index) {
                        
                        if (this.inventories != null) {
                            if (this.inventories[index].item != null) {
                                var item = this.inventories[index].item;
                                var item_price_level = this.inventories[index].price_level;
                                var price_type = item_price_level.price_type;
                                var percent = Number.parseFloat(item_price_level.percent);
                                
                                var rate = this.inventories[index]['item']['rate'];
                                var smeasure_unit = this.inventories[index]['item']['measure']['measure_unit'];
                                var measure_unit = this.inventories[index]['item']['measure_unit'];
                                var rate1 = (rate * smeasure_unit / measure_unit);
                                rate1 = Number.parseFloat(rate1);

                                if(price_type == 'up' && percent > 0 && rate1 > 0){
                                    var result = Number.parseFloat((rate1 * percent) / 100);
                                    this.inventories[index]['item']['new_rate'] = Number.parseFloat(rate1 + result);
                                } else if(price_type == 'down' && percent > 0 && rate1 > 0){
                                    var result = Number.parseFloat((rate1 * percent) / 100);
                                    this.inventories[index]['item']['new_rate'] = Number.parseFloat(rate1 - result);
                                } 
                            }
                        }
                    },
                    
                    // calculate item price based on measure change
                    measureChangeservice(index) {

                        if (this.services[index].item != null) {
                            var item = this.services[index].item;

                            var temp = ((item.rate * item.measure.measure_unit / item.measure_unit) * this.selected_currency.rate);
                            result = Number.parseFloat(temp).toFixed(precision());

                            this.services[index].item.new_rate = result;

                            // this.inventories[index].item.new_rate = this.$refs.in[index].value/this.selected_currency.rate;

                        }
                    },
                    // detect member change and searh
                    memberChange() {
                        if (this.selected_customer) {
                            // get member contract
                        }
                    },
                    // end sale order change

                    //Get Transport Company Drivers 
                    getDrivers() {
                      if (this.selected_transportCompany) {
                        axios.get("{{route('callMethod.search')}}",
                          {
                            params: {
                              transport_id: this.selected_transportCompany.id,
                              method_name: 'Search_transport_company_drivers'
                            },
                          })
                          .then(function (response) {
                            if (response.data.result != null) {
                              console.log('all Drivers',response.data.result);
                              v.t_drivers=response.data.result;
                              // v.selected_transportDriver=null;
                            }
                            else {

                            }
                          })
                          .catch(function (error) {
                            console.log(error);
                          });
                      }
                    },

                    //Get Just Drivers  without Transport Company Select
                      getAllDrivers() {
                          if (!v.selected_transportCompany) {
                          v.t_drivers=v.allDrivers;
                          }
                      },



                    // set new price
                    setNewRate(type = null, index = null) {
                        if (type == 'inventory') {
                            if (this.inventories[index].item) {

                                this.inventories[index].item.new_rate = this.$refs.in[index].value / this.selected_currency.rate;
                            }
                        }
                        if (type == 'service') {
                            if (this.services[index].item) {
                                console.log('service changed');
                                this.services[index].item.new_rate = this.$refs.ser[index].value / this.selected_currency.rate;
                            }
                        }
                    },


                    //ajax call to get items

                    onItemSearch: _.debounce((search, loading) => {

                        loading(true);

                        let inventory_category_id = 0;
                        let inventory_brand_id = 0;
                        if (v.inventories[v.selected_index]) {
                            inventory_category_id = (v.inventories[v.selected_index]['item_category'] != undefined) ? v.inventories[v.selected_index]['item_category'].id : '';
                            inventory_brand_id = (v.inventories[v.selected_index]['item_brand'] != undefined) ? v.inventories[v.selected_index]['item_brand'].id : '';
                        }
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                member_id: v.member_id,
                                method_name: 'itemesSearchSale',
                                keyword: search,
                                inventory_category_id: inventory_category_id,
                                inventory_brand_id: inventory_brand_id,
                            }
                        })
                            .then(function (response) {
                                v.temp_items = [];
                                if (response.data.length > 0) {
                                    v.temp_items = response.data;
                                }
                                loading(false);
                            })
                            .catch(function (error) {
                                console.log(error);
                            })
                    }, getDebounceTime()),

                    onItemload(index) {
                        v.selected_index = index;
                        if (v.inventories[index].inventory != null) {
                            // console.log('klk',v.inventories[index].inventory,v.inventories);
                            var inventory_id = v.inventories[index].inventory.id;
                            let inventory_category_id = (v.inventories[index]['item_category'] != undefined) ? v.inventories[index]['item_category'].id : '';
                            let inventory_brand_id = (v.inventories[index]['item_brand'] != undefined) ? v.inventories[index]['item_brand'].id : '';
                            let price_level_id = (this.selected_priceLevel) ? this.selected_priceLevel.id : '';

                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    member_id: v.member_id,
                                    method_name: 'itemSearchSale',
                                    inventory_id: inventory_id,
                                    inventory_category_id: inventory_category_id,
                                    inventory_brand_id: inventory_brand_id,
                                    price_level_id:price_level_id
                                }
                            })
                            .then(function (response) {
                                v.inventories[index].item = null;
                                v.inventories[index].location = null;
                                if (response.data.length > 0) {
                                    v.inventories[index].item = response.data[0];
                                    v.temp_items = [];
                                    @if(getShwoPriceLevel()=="general_percent")
                                    setTimeout((function () {
                                        v.change_sale_rate_by_price_level_general(index);
                                    }), 400);
                                    @endif
                                }
                            })
                            .catch(function (error) {
                                console.log(error);
                            })
                        }
                    },

                    loadItemGeneral() {
                        if (v.selected_inventory != undefined) {
                            var inventory_id = v.selected_inventory.id;
                        
                            // console.log(888, number);
                            let inventory_category_id = (v.selected_iventory_category != undefined)?v.selected_iventory_category.id:'';
                            let inventory_site_id = (v.selected_iventory_site != undefined)?v.selected_iventory_site.site_id:'';

                            axios.get("{{route('callMethod.search')}}", {
                                    params: {
                                        member_id: v.member_id,
                                        method_name: 'itemSearchSale',
                                        inventory_id: inventory_id,
                                        inventory_category_id: inventory_category_id,
                                        // inventory_brand_id: inventory_brand_id,
                                        inventory_site_id: inventory_site_id,
                                        // number: number,
                                    }
                                })
                                .then(function(response) {
                                    if (response.data.length > 0) {

                                        var checkD = true;
                                        @if(NotDuplicateItem() =="true")
                                        if (v.inventories != null && response.data[0].id) {
                                            for (var i = 0; i < v.inventories.length; i++) {
                                                if (v.inventories[i].item && v.inventories[i].item != null) {
                                                    if (v.inventories[i].item.id == response.data[0].id) {
                                                        checkD = false;
                                                    }
                                                }
                                            }
                                        }
                                        @endif

                                        var rate = 0;
                                        if (v.selected_currency.rate > 0) {
                                            rate = v.selected_currency.rate;
                                        }

                                        if (checkD) {
                                            v.selected_iventory_site = null;
                                            v.selected_itemes = response.data[0];
                                            v.selected_price = (Number.parseFloat(response.data[0].rate) * Number.parseFloat(rate)).toFixed(precision());
                                            v.inventory_sites = response.data[0].site_list;  
                                            v.last_item_sale = response.data[0].last_item_sale;  
                                            v.last_item_purchase = response.data[0].last_item_purchase;  
                                            v.AdvancePrice = response.data[0].advance_price;
                                            v.AdvancePrice_cost = response.data[0].advance_price_cost;
                                            // console.log(123, response.data[0]);
                                        }else{
                                            v.selected_inventory = null;
                                            v.selected_inventory1 = null;
                                            v.counter_check = 0;
                                            v.temp_items = [];
                                            v.selected_itemes = null;
                                            v.selected_price = 0;
                                            v.selected_quantity = 0;
                                            v.$refs.barcode_search.$refs.search.focus();
                                        }
                                    }else{
                                        // $('#success-sound')[0].play();
                                        // $('#error-sound')[0].play();
                                        v.item_not_found = true;
                                        setTimeout((function () {
                                            v.item_not_found = false;
                                            v.$refs.barcode_search.focus();
                                        }), 2e3)
                                    }
                                })
                                .catch(function(error) {
                                    console.log(error);
                                })

                        }
                    },

                    locationSearch: _.debounce((search, loading) => {
                        loading(true);
                        let inventory_id = (v.inventories[v.selected_index]['item'] != undefined) ? v.inventories[v.selected_index]['item'].id : '';
                        // console.log(3333, v.inventories, v.selected_index, inventory_id, search);
                        if (inventory_id) {
                            axios.get("{{route('callMethod.search')}}", {
                                params: {
                                    member_id: v.member_id,
                                    method_name: 'itemesSearchLocation',
                                    keyword: search,
                                    inventory_id: inventory_id
                                }
                            })
                            .then(function(response) {
                                if (response.data.length > 0) {
                                    v.inventories[v.selected_index]['item']['locationList'] = response.data;
                                }
                                loading(false);
                            })
                            .catch(function(error) {
                                console.log(error);
                            })
                        } else {
                            loading(false);
                        }
                    }, getDebounceTime()),

                    locationItemload(index) {
                        v.selected_index = index;
                        if (v.inventories[index].item != null && v.inventories[index].location != null) {
                            var inventory_id = v.inventories[index].item.id;
                            var location = v.inventories[index].location.name;

                            axios.get("{{route('callMethod.search')}}", {
                                    params: {
                                        method_name: 'itemSiteByLocation',
                                        inventory_id: inventory_id,
                                        location: location
                                    }
                                })
                                .then(function(response) {
                                    // console.log(4444, response.data);
                                    if (response.data.item.length > 0) {
                                        v.inventories[index].item.site_list = response.data.item;
                                        v.inventories[index].item.site = response.data.selectItem;
                                    }
                                })
                                .catch(function(error) {
                                    console.log(error);
                                })
                        }
                    },

                    addData() {
                        if (v.selected_itemes && v.selected_quantity > 0) {
                            v.selected_quantity_error = false;
                            v.AdvancePrice = null;
                            v.AdvancePrice_cost = null;
                            var che = null;
                            for (var i = 0; i < v.inventories.length; i++) {
                                if (!v.inventories[i].item) {
                                    v.inventories.splice(i, 1);
                                }
                            }

                            let inventory_site_id = (v.selected_iventory_site != undefined)?v.selected_iventory_site.site_id:'';
                            if (inventory_site_id) {
                                for (var i = 0; i < v.selected_itemes.site_list.length; i++) {
                                    if (v.selected_itemes.site_list[i].site_id == inventory_site_id) {
                                        v.selected_itemes.site = v.selected_itemes.site_list[i];
                                    }
                                }
                            }

                            var rate = 0;
                            if (v.selected_currency.rate > 0) {
                                rate = v.selected_currency.rate;
                            }

                            v.selected_itemes.quantity = (v.selected_quantity > 0)?v.selected_quantity:1;
                            v.selected_itemes.new_rate = (v.selected_price > 0)?(Number.parseFloat(v.selected_price) / Number.parseFloat(rate)):1;

                            v.inventories.push({
                                inventory: v.selected_itemes,
                                item: v.selected_itemes,
                                location: null,
                                selected_taxation: null,
                                tax: v.selected_itemes.row_tax_stat,
                                sub_total: v.selected_itemes.sub_total_stat,
                                item_category: v.selected_itemes.item_category,
                                item_brand: v.selected_itemes.inventory_brand,
                                edit: true,
                                price_level:null
                            });

                            v.selected_inventory = null;
                            v.selected_inventory1 = null;
                            v.counter_check = 0;
                            // v.temp_items = [];
                            @if(getShwoPriceLevel()=="general_percent")
                            setTimeout((function () {
                                v.change_sale_rate_by_price_level_general();
                            }), 400);
                            @endif

                            // const inp = v.$refs.barcode_search.$refs.search;
                            // console.log(v.$refs.barcode_search.$refs.search.value);
                            v.$refs.barcode_search.$refs.search.focus();
                            // v.$refs.barcode_search.$refs.search = null;
                            // v.$refs.barcode_search.focus();

                            v.selected_itemes = null;
                            v.selected_price = 0;
                            v.selected_quantity = 0;
                            
                        }else{
                            v.$refs.selected_quantity.focus();
                            v.selected_quantity_error = true;
                        }
                    },
                    
                    resetData() {
                        v.AdvancePrice = null;
                        v.AdvancePrice_cost = null;
                        v.selected_inventory = null;
                        v.selected_itemes = null;
                        v.temp_items = [];
                        v.selected_iventory_site = null;
                        v.selected_price = 0;
                        v.selected_quantity = 0;
                        v.$refs.barcode_search.$refs.search.focus();
                    },

                    // end item search
                    setIndex(e) {
                        v.temp_items = [];
                        this.selected_index = e;
                    },
                    itemCategoryChange(index) {
                        v.temp_items = [];
                        this.selected_index = index;
                        let inventory_category_id = (v.inventories[v.selected_index]['item_category'] != undefined) ? v.inventories[v.selected_index]['item_category'].id : '';
                        let inventory_brand_id = (v.inventories[v.selected_index]['item_brand'] != undefined) ? v.inventories[v.selected_index]['item_brand'].id : '';
                        axios.get("{{route('callMethod.search')}}", {
                            params: {
                                member_id: v.member_id,
                                method_name: 'itemesSearchSale',
                                inventory_category_id: inventory_category_id,
                                inventory_brand_id: inventory_brand_id
                            }
                        })
                            .then(function (response) {
                                v.temp_items = [];
                                if (response.data.length > 0) {
                                    v.temp_items = response.data;
                                }
                            })
                            .catch(function (error) {
                                console.log(error);
                            });

                    },

                    itemBrandChange(index) {
                        v.temp_items = [];
                        this.selected_index = index;
                        v.selected_iventory_brand = this.inventories[index]['item_brand'];
                        if (this.inventories[index]['item_brand'] != null) {
                            let inventory_category_id = (v.inventories[index]['item_category'] != undefined) ? v.inventories[index]['item_category'].id : '';
                            let inventory_brand_id = this.inventories[index]['item_brand'].id;
                            
                            axios.get("{{route('callMethod.search')}}", {
                                    params: {
                                        member_id: v.member_id,
                                        method_name: 'itemesSearchSale',
                                        inventory_category_id: inventory_category_id,
                                        inventory_brand_id: inventory_brand_id
                                    }
                                })
                                .then(function(response) {
                                    v.temp_items = [];
                                    if (response.data.length > 0) {
                                        v.temp_items = response.data;
                                    }
                                })
                                .catch(function(error) {
                                    console.log(error);
                                });
                        }

                    },

                    // end item search

                        // Change Item Sale Rate According Item Price Level
                    change_sale_rate_by_price_level_general(i) {
                        
                        if (this.inventories != null && this.selected_priceLevelGeneral) {
                            var price_type = this.selected_priceLevelGeneral.price_type;
                            var percent = Number.parseFloat(this.selected_priceLevelGeneral.percent);

                            if (this.inventories[i].item && this.inventories[i].item != null) {
                                    var rate = this.inventories[i]['item']['rate'];
                                    var smeasure_unit = this.inventories[i]['item']['measure']['measure_unit'];
                                    var measure_unit = this.inventories[i]['item']['measure_unit'];
                                    var rate1 = (rate * smeasure_unit / measure_unit);
                                    rate1 = Number.parseFloat(rate1);

                                    if(price_type == 'up' && percent > 0 && rate1 > 0){
                                        var result = Number.parseFloat((rate1 * percent) / 100);
                                        this.inventories[i]['item']['new_rate'] = Number.parseFloat(rate1 + result);
                                    } else if(price_type == 'down' && percent > 0 && rate1 > 0){
                                        var result = Number.parseFloat((rate1 * percent) / 100);
                                        this.inventories[i]['item']['new_rate'] = Number.parseFloat(rate1 - result);
                                    }  
                            }
                        }
                    },


                    // generic function for adding item to list
                    addNew(type = null, index) {
                        // this.temp_items = [];
                        if (type != null) {
                            if (type == 'inventory') {
                                if (this.inventories[index + 1] == undefined) {
                                    this.temp_items = [];
                                    this.inventories.push({inventory: null, item: null, location: null, item_category: null, item_brand: null, tax: 'on', edit: true, selected_taxation: null, sub_total: '',price_level:null});
                                }
                            }
                            if (type == 'service') {
                                if (this.services[index + 1] == undefined) {
                                    this.checkExistingService(index, '');
                                    this.services.push({
                                        items: this.all_services,
                                        item: null,
                                    });
                                }
                            }
                            if (type == 'payment') {
                                if (this.payments[index + 1] == undefined) {
                                    var banks = this.banks;
                                    this.banks =[];
                                    banks.forEach((a)=>{
                                                this.banks.push({
                                                    amount: a.amount,
                                                    balance: a.balance,
                                                    code: a.code,
                                                    id: a.id,
                                                    name: a.name,
                                                    rate: a.rate,
                                                    number:receive_number+(index-(this.selected_banks.length))
                                                })
                                    });


                                    this.checkExistingPayment(index, '');
                                    this.payments.push({
                                        items: this.banks,
                                        item: null,
                                    });
                                }
                            }
                             if (type == 'payment_invoice') {
                                if (this.payment_invoices[index + 1] == undefined) {
                                    this.payment_invoices.push({
                                        amount: null,
                                        description: null,
                                        rate: null,
                                        selected_payment_currency:null
                                    });
                                }
                            }
                        }

                    },

                    // in here you can check and decide to allow duplicate bank for payment or not
                    checkExistingPayment(index = null, name = '') {
                        var bank_temp = this.banks.slice();
                        var bank_temp1 = [];
                        for (var i = 0; i < this.payments.length; i++) {
                            if (this.payments[i].item != null) {
                                var fined = bank_temp.findIndex((item) => item.name == this.payments[i].item.name);
                                if (fined != -1) {
                                    var o = bank_temp.splice(bank_temp.findIndex((item) => item.name == this.payments[i].item.name), 1);
                                }
                            }
                        }
                        this.payments[index].items = bank_temp.filter((item) => {
                            return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                        });
                        //this.payments[index].items =bank_temp;


                    },

                    // in here you can check and decide to allow duplicate service or not
                    checkExistingService(index = null, name = '') {
                        var service_temp = this.all_services.slice();
                        var service_temp1 = [];
                        for (var i = 0; i < this.services.length; i++) {
                            if (this.services[i].item != null) {
                                var fined = service_temp.findIndex((item) => item.name == this.services[i].item.name);
                                if (fined != -1) {
                                    var o = service_temp.splice(service_temp.findIndex((item) => item.name == this.services[i].item.name), 1);
                                }
                            }
                        }
                        this.services[index].items = service_temp.filter((item) => {
                            return (new RegExp(name.toLowerCase())).test(item.name.toLowerCase())
                        });
                        //this.payments[index].items =bank_temp;


                    },
                    // delete item from list
                    deleteItem(type = null, index) {
                        if (type != null) {
                            console.log(type);
                            if (type == 'inventory') {
                                swal({
                                    title: "@lang('layout.AreYouSure?')",
                                    buttons: ["@lang('layout.Cancel')", "@lang('layout.yes')"],
                                    text: "",
                                    icon: "info",
                                    dangerMode: true,
                                }).then((willDelete) => {
                                    if (willDelete) {
                                        this.inventories.splice(index, 1);
                                    }
                                    else {
                                        
                                    }
                                });
                            }
                            if (type == 'service') {
                                if (type == 'service') {
                                swal({
                                    title: "@lang('layout.AreYouSure?')",
                                    buttons: ["@lang('layout.Cancel')", "@lang('layout.yes')"],
                                    text: "",
                                    icon: "info",
                                    dangerMode: true,
                                }).then((willDelete) => {
                                    if (willDelete) {
                                        this.services.splice(index, 1);
                                    }
                                    else {
                                        
                                    }
                                });
                                }
                            }
                            if (type == 'payment') {
                                this.payments.splice(index, 1);
                            }
                            if (type == 'payment_invoice') {
                                this.payment_invoices.splice(index, 1);
                            }
                        }

                    },
                    // submit the form
                    submitForm() {

                        if (this.isError == true) {
                            alert('there is no item');
                            return false;
                        }
                        v.disabled = true;
                        swal({
                            title: "@lang('layout.AreYouSure?')",
                            buttons: ["@lang('layout.Cancel')", "@lang('layout.Submit')"],
                            text: "",
                            icon: "info",
                            dangerMode: true,
                        }).then((willDelete) => {
                            if (willDelete) {
                                document.getElementById("sales-form").submit()
                            }
                            else {
                                v.disabled = false;
                            }
                        });

                    },

                    saveAndNew() {
                        if (!this.isError) {
                            v.disabled = true;
                            var url = "{{route('invoice.update',$invoice->id)}}";
                            form_id = 'sales-form';
                            var data = $('#' + form_id).serialize();
                            toggleBlock(true);
                            axios.post(url, data)
                                .then(function(response) {
                                    toggleBlock(0);
                                    // console.log('sss11', response.data);
                                    if (response.data.result == 1) {

                                        var a = document.createElement('a');
                                        a.href = "{{route('invoice.index')}}";
                                        document.body.appendChild(a);
                                        a.click();
                                        document.body.removeChild(a);

                                        // location.reload("{{route('invoice.index')}}");
                                    } else {
                                        v.disabled = false;
                                        var message = "{{__('message.Warning')}}";
                                        //$('#error-sound')[0].play();
                                        toastr.warning('', message);
                                        // toastr.warning('', response.data[1]);
                                    }
                                })
                                .catch(function(error) {
                                    toggleBlock(0);
                                    v.disabled = false;
                                    // console.log(error,v.disabled);
                                    var message = "{{__('message.Warning')}}";
                                    //$('#error-sound')[0].play();
                                    toastr.warning('', message);
                                });

                        } else {
                            alert('there is no item');
                            return false;
                        }
                    },

                },


        });

    </script>



@endpush