@extends('layouts.factor-master')

@section('content')
<?php
$report = customeReportNew('invoice_index');

$_date = !in_array('date', $report);
$_invoice_number = !in_array('invoice_number', $report);
$_customer = !in_array('customer', $report);
$_code = !in_array('code', $report);
$_account_name = !in_array('account_name', $report);
$_amount = !in_array('amount', $report);
$_unit = !in_array('unit', $report);
$_rate = !in_array('rate', $report);
$_discount_type = !in_array('discount_type', $report);
$_discount = !in_array('discount', $report);
$_description = !in_array('description', $report);
$_reference_number = !in_array('reference_number', $report);
$_total = !in_array('total', $report);
$_hour = !in_array('hour', $report);
$_forgivness = !in_array('forgivness', $report);
$_old_counter = !in_array('old_counter', $report);
$_new_counter = !in_array('new_counter', $report);
$_record = !in_array('record', $report);
$_user = !in_array('user', $report);
$_transportCompany = !in_array('transportCompany', $report);
$_driver = !in_array('driver', $report);
 
$report_percent = customeReportNewPercent('invoice_index');
    $_invoice_number_percent= (array_key_exists('invoice_number___percent', $report_percent))?$report_percent['invoice_number___percent']:null;
    $_date_percent= (array_key_exists('date___percent', $report_percent))?$report_percent['date___percent']:null;
    $_customer_percent= (array_key_exists('customer___percent', $report_percent))?$report_percent['customer___percent']:null;
    $_code_percent= (array_key_exists('code___percent', $report_percent))?$report_percent['code___percent']:null;
    $_account_name_percent= (array_key_exists('account_name___percent', $report_percent))?$report_percent['account_name___percent']:null;
    $_amount_percent= (array_key_exists('amount___percent', $report_percent))?$report_percent['amount___percent']:null;
    $_unit_percent= (array_key_exists('unit___percent', $report_percent))?$report_percent['unit___percent']:null;
    $_rate_percent= (array_key_exists('rate___percent', $report_percent))?$report_percent['rate___percent']:null;
    $_discount_type_percent= (array_key_exists('discount_type___percent', $report_percent))?$report_percent['discount_type___percent']:null;
    $_discount_percent= (array_key_exists('discount___percent', $report_percent))?$report_percent['discount___percent']:null;
    $_description_percent= (array_key_exists('description___percent', $report_percent))?$report_percent['description___percent']:null;
    $_reference_number_percent= (array_key_exists('reference_number___percent', $report_percent))?$report_percent['reference_number___percent']:null;
    $_total_percent= (array_key_exists('total___percent', $report_percent))?$report_percent['total___percent']:null;
    $_hour_percent= (array_key_exists('hour___percent', $report_percent))?$report_percent['hour___percent']:null;
    $_forgivness_percent= (array_key_exists('forgivness___percent', $report_percent))?$report_percent['forgivness___percent']:null;
    $_old_counter_percent= (array_key_exists('old_counter___percent', $report_percent))?$report_percent['old_counter___percent']:null;
    $_new_counter_percent= (array_key_exists('new_counter___percent', $report_percent))?$report_percent['new_counter___percent']:null;
    $_record_percent= (array_key_exists('record___percent', $report_percent))?$report_percent['record___percent']:null;
    $_user_percent= (array_key_exists('user___percent', $report_percent))?$report_percent['user___percent']:null;
    $_transportCompany_percent= (array_key_exists('transportCompany___percent', $report_percent))?$report_percent['transportCompany___percent']:null;
    $_driver_percent= (array_key_exists('driver___percent', $report_percent))?$report_percent['driver___percent']:null;
?>
<h3 class="table-caption" style="text-align: center;">@lang('layout.InvoiceReport')</h3>
<table class="main-table">
    <tr>
      @if($from_date)
      <td>
      <span>@lang('layout.FromDate')</span>:
      <BDO DIR="LTR">    @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($from_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif      {{convertDate($from_date)}}</BDO>
    </td>
    @endif
    @if($to_date)
    <td>
      <span>@lang('layout.ToDate')</span>:
      <BDO DIR="LTR">    @if(\Setting::get('jalali_and_gerogarian_date') == 'true')  {{convertDate($to_date, null, null, ((\Setting::get('date_type') == 'jalali')?'gregorian':'jalali'))}}  <span dir="rtl"> &nbsp;&nbsp;&nbsp;  @lang('layout.MarchingAt')  </span>  @endif      {{convertDate($to_date)}}</BDO>
    </td>
    @endif
    </tr>
  </table>
   
@if($member_name || $member_class_name || $area_name || $inventory_site_name)
<table class="main-table" style="margin: 6px 0px;" >
   
    <tr>
      @if($member_name)
      <td>
        <span>@lang('layout.Customer')</span>: {{$member_name}}
      </td>
      @endif
   
      @if($member_class_name)
      <td>
        <span>@lang('layout.MemberClass')</span>: {{$member_class_name}}
      </td>
      @endif

      @if($area_name)
      <td>
        <span>@lang('layout.SaleArea')</span>: {{$area_name}}
      </td>
      @endif
      @if($inventory_site_name)
      <td>
        <span>@lang('layout.SiteName')</span>: {{$inventory_site_name}}
      </td>
      @endif
     
    </tr>
   
</table>
@endif


<br>

@if($comanies && $comanies !=[])
@foreach($comanies AS $row)
<h2 class="table-caption" style="text-align: center;">{{$row->name}}</h2>

<table class="main-table" cellpadding="5px">
    <thead>
        <tr class="bg">
            <td>
                <div class="center"> @lang('layout.Record') </div>
            </td>
            @if($_invoice_number)
            <td >
                <div class="center"> @lang('layout.InvoiceNumber') </div>
            </td>@endif
            @if($_reference_number)
            <td >
                <div class="center"> @lang('layout.ReferenceNumber')</div>
            </td>
            @endif
            @if($_date)
            <td >
                <div class="center"> @lang('layout.Date')</div>
            </td>@endif
            @if($_description)
            <td >
                <div class="center"> @lang('layout.Description') </div>
            </td>@endif
            @if(!$member_name)
            @if($_customer)
            <td>
                <div class="center"> @lang('layout.Customer')</div>
            </td>
            @endif
            @if($_code)
            <td>
                <div class="center"> @lang('layout.Code')</div>
            </td>
            @endif
           @endif
            @if(getTransportCompany()=="true")
            <td>
                <div class="center"> @lang('menu.TransportCompany')</div>
            </td>
            <td>
                <div class="center"> @lang('layout.Driver')</div>
            </td>
            @endif


            @if($_account_name)
            <td >
                <div class="center"> @lang('layout.AccountName')</div>
            </td>@endif
            @if($_amount)
            <td >
                <div class="center"> @lang('layout.Amount')</div>
            </td>@endif
            @if($_unit)
            <td>
                <div class="center"> @lang('layout.Unit')</div>
            </td>@endif
            @if($_rate)
            <td >
                <div class="center"> @lang('layout.Rate')</div>
            </td>@endif
            @if($_discount_type)
            <td >
                <div class="center"> @lang('layout.DiscountType')</div>
            </td>@endif
            @if($_discount)
            <td >
                <div class="center"> @lang('layout.Discount')</div>
            </td>
            @endif
            @if(getSaleTaxation() == 'true')
            <td>
                <div class="center"> @lang('layout.Tax')</div>
            </td>
            @endif
            @if(getFactorPending() == 'true')
                <td><div class="center"> @lang('layout.Status')</div></td>
            @endif
           
            <td>
                <div class="center"> @lang('layout.User')</div>
            </td>

        </tr>
    </thead>
    <?php
    $count = 0;
    $total_home_currency = 0;
    $currencies = [];
    ?>
    @foreach($data AS $record)
    <tr>
        <?php

        if ($record['company_id'] == $row->id) {

            $total_home_currency += $record->exchanged_amount;
            if (array_key_exists($record->Currency, $currencies)) {
                $currencies[$record->Currency] = $currencies[$record->Currency] + $record->Amount;
            } else {

                $currencies[$record->Currency] = $record->Amount;
            }
        ?>

            <td class="center">{{++$count}}</td>
            @if($_invoice_number)
            <td class="center">{{$record->Number}}</td>@endif
            @if($_reference_number)
            <td class="center">{{$record->ref_Number}}</td>
            @endif
            @if($_date)
            <td class="center">{{convertDate($record->Date)}}</td>@endif
            @if($_description)
            <td class="center">
                {{$record->description}} 
            </td>
            @endif
            @if(!$member_name)
            @if($_customer)
            <td class="center">{{$record->Name}}</td>
            @endif
            @if($_code)
            <td class="center">{{$record->code}}</td>
            @endif
           @endif
            @if(getTransportCompany()=="true")
            <td class="center">{{$record->trasnport_name}}</td>
            <td class="center">{{$record->driver_name}}</td>
            @endif

            @if($_account_name)
            <td class="center">{{$record->Account}}</td>@endif
            @if($_amount)
            <td class="center">{{round($record->Amount,2)}}</td>@endif
            @if($_unit)
            <td class="center">{{$record->Unit}}</td>@endif
            @if($_rate)
            <td class="center">{{$record->rate}}</td>@endif
            @if($_discount_type)
            <td class="center">{{$record->discount_type}}</td>@endif
            @if($_discount)
            @if($record->discount_type == 'percent')<td class="center">{{$record->discount1}}</td>
            @else<td class="center">{{$record->Discount}}</td>@endif
            @endif
            @if(getSaleTaxation() == 'true')
            <td class="center">{{$record->sale_taxation}} %</td>
            @endif
            @if(getFactorPending() == 'true')
                <td class="center">@if($record->pending == 'on') @lang('layout.Pending') @else @lang('layout.Confirm') @endif</td>
            @endif
          
            <td class="center">{{$record->user}}</td>

        <?php } ?>

    </tr>
    @endforeach
</table>

@if($_total)
<table class="main-table">
    <tr class="bg">
        <td colspan="3">
            <div class="center">@lang('layout.PerCurrency')</div>
        </td>
    </tr>
    <tr>
        <td>
            <div class="center"> @lang('layout.Record') </div>
        </td>
        <td>
            <div class="center"> @lang('layout.Currency') </div>
        </td>
        <td>
            <div class="center"> @lang('layout.Amount') </div>
        </td>
    </tr>
    <?php
    $count = 0;
    foreach ($currencies as $key => $currency) {
    ?>
        <tr>
            <td>
                <div class="center">{{++$count}}</div>
            </td>
            <td>
                <div class="center">{{$key}}</div>
            </td>
            <td>
                <div class="center">{{round($currency,2)}}</div>
            </td>

        </tr>
    <?php
    }
    ?>
    <tr>
        <td colspan="2">
            <div class="center">@lang('layout.HomeCurrencyTotal')</div>
        </td>
        <td>
            <div class="center">{{round($total_home_currency,2)}}  {{getHomeCurrency()[getCurrencyType()]}} </div>
        </td>

    </tr>
</table>
@endif

@if($percent)
<h3 class="table-caption" style="text-align: center;">@lang('layout.Total') @lang('layout.Percentage')</h3>
<table class="main-table">

  <thead>
    <tr class="bg">
      <td>
        <div class="center"> @lang('layout.Record') </div>
      </td>
      <td>
        <div class="center"> @lang('layout.ItemName')</div>
      </td>
      <td>
        <div class="center"> @lang('layout.Unit')</div>
      </td>
      <td>
        <div class="center"> @lang('layout.Quantity')</div>
      </td>
      <td>
        <div class="center"> @lang('layout.Amount')</div>
      </td>
      <td>
        <div class="center"> @lang('layout.TotalAmount')</div>
      </td>
      <td>
        <div class="center"> @lang('layout.Unit')</div>
      </td>
      <td>
        <div class="center"> @lang('layout.Percentage') %</div>
      </td>

    </tr>
  </thead>
  <?php
  $count = 0;
  ?>
  @foreach($summary AS $record)
  @if($record->company_id == $row->id)
  <tr>
    <td class="center">{{++$count}}</td>
    <td class="center">{{$record->item_name}}</td>
    <td class="center">{{$record->um}}</td>
    <td class="center">{{$record->quantityOut}}</td>
    <td class="center">{{myRound($record->price)}}</td>
    <td class="center">{{myRound($record->amount)}}</td>
    <td class="center">{{getHomeCurrency()[getCurrencyType()]}}</td>
    <td class="center">{{myRound($record->percentage)}} %</td>
  </tr>
  @endif
  @endforeach
</table>
@endif

@endforeach
@else

<table class="main-table" cellpadding="5px">
    <thead>
        <tr class="bg">
            @if($_record)
            <td class="center" >
                <div ><b> @lang('layout.Record') </b></div>
            </td>
            @endif
            @if($_invoice_number)
            <td class="center"  @if($_invoice_number_percent) width="{{$_invoice_number_percent}}%" @endif>
                <div><b> @lang('layout.InvoiceNumber') </b></div>
            </td>@endif
            @if($_reference_number)
            <td  class="center" @if($_reference_number_percent) width="{{$_reference_number_percent}}%" @endif>
                <div><b> @lang('layout.ReferenceNumber') </b></div>
            </td>
            @endif
            @if($_date)
            <td class="center"  @if($_date_percent) width="{{$_date_percent}}%" @endif>
                <div > <b> @lang('layout.Date') </b></div>
            </td>@endif
            @if($_hour)<td class="center" @if($_hour_percent) width="{{$_hour_percent}}%" @endif ><div ><b> @lang('layout.Hour') </b></div></td>@endif
            @if($_description)
            <td class="center" @if($_description_percent) width="{{$_description_percent}}%" @endif>
                <div > <b> @lang('layout.Description') </b></div>
            </td>
            @endif
            @if(systemConfig()[27] == 1)
            @if($_old_counter)
            <td class="center" @if($_old_counter_percent) width="{{$_old_counter_percent}}%" @endif>
                <div ><b> @lang('layout.OldCounter') </b></div>
            </td>
            @endif
            @if($_new_counter)
            <td class="center" @if($_new_counter_percent) width="{{$_new_counter_percent}}%" @endif>
                <div ><b> @lang('layout.NewCounter') </b></div>
            </td>
            @endif
            @endif
            @if(!$member_name)
                @if($_customer)
                    <td class="center"   @if($_customer_percent) width="{{$_customer_percent}}%" @endif>
                        <div ><b> @lang('layout.Customer') </b></div>
                    </td>
                @endif
                @if($_code)
                    <td class="center"   @if($_code_percent) width="{{$_code_percent}}%" @endif>
                        <div ><b> @lang('layout.Code') </b></div>
                    </td>
                @endif
            @endif
            @if($_forgivness)
                <td class="center" @if($_forgivness_percent) width="{{$_forgivness_percent}}%" @endif>
                    <div ><b> @lang('layout.Forgivness') </b></div>
                </td>
            @endif
            @if(getTransportCompany()=="true")
            @if($_transportCompany)
            <td class="center" >
                <div ><b> @lang('menu.TransportCompany') </b></div>
            </td>
            @endif
            @if($_driver)
            <td class="center" >
                <div ><b> @lang('layout.Driver') </b></div>
            </td>
            @endif
            @endif


            @if($_account_name)
            <td class="center"  @if($_account_name_percent) width="{{$_account_name_percent}}%" @endif>
                <div ><b> @lang('layout.AccountName') </b></div>
            </td>@endif
            @if($_amount)
            <td class="center"  @if($_amount_percent) width="{{$_amount_percent}}%" @endif>
                <div ><b> @lang('layout.Amount') </b></div>
            </td>@endif
            @if($_unit)
            <td class="center"   @if($_unit_percent) width="{{$_unit_percent}}%" @endif>
                <div ><b> @lang('layout.Unit') </b></div>
            </td>@endif
            @if($_rate)
            <td class="center"  @if($_rate_percent) width="{{$_rate_percent}}%" @endif>
                <div ><b> @lang('layout.Rate') </b></div>
            </td>@endif
            @if($_discount_type)
            <td class="center"  @if($_discount_type_percent) width="{{$_discount_type_percent}}%" @endif>
                <div ><b> @lang('layout.DiscountType') </b></div>
            </td>@endif
            @if($_discount)
            <td class="center"  @if($_discount_percent) width="{{$_discount_percent}}%" @endif>
                <div ><b> @lang('layout.Discount') </b></div>
            </td>@endif
            @if(getSaleTaxation() == 'true')
            <td class="center" >
                <div ><b> @lang('layout.Tax') </b></div>
            </td>
            @endif
            @if(getFactorPending() == 'true')
                <td class="center" ><div ><b> @lang('layout.Status') </b></div></td>
            @endif
            @if($_user)
            <td class="center" >
                <div ><b> @lang('layout.User') </b></div>
            </td>
            @endif
        </tr>
    </thead>
    <?php
    $count = 0;
    $total_home_currency = 0;
    $currencies = [];
    ?>
    @foreach($data AS $record)
    <tr>


        <?php

        $total_home_currency += $record->exchanged_amount;
        if (array_key_exists($record->Currency, $currencies)) {
            $currencies[$record->Currency] = $currencies[$record->Currency] + $record->Amount;
        } else {

            $currencies[$record->Currency] = $record->Amount;
        }
        ?>
        @if($_record)
        <td class="center">{{++$count}}</td>
        @endif
        @if($_invoice_number)
        <td class="center">{{$record->Number}}</td>@endif
        @if($_reference_number)
        <td class="center">{{$record->ref_Number}}</td>@endif
        @if($_date)
        <td class="center">{{convertDate($record->Date)}}</td>@endif
        @if($_hour)
        <td  class="center">
        @if(getHourType() == 24)
        {{ (($record->hour != null)?(date_format(date_create($record->hour), 'H:i')):'') }}
        @else
        {{ (($record->hour != null)?(date_format(date_create($record->hour), 'h:i:a')):'') }}
        @endif
        </td>
        @endif
        @if($_description)
        <td style="@if($_description_percent) text-align: justify @endif">
            {{$record->description}} 
        </td>@endif
        @if(systemConfig()[27] == 1)
        @if($_old_counter)
        <td>
            {{$record->old_oil_counter}} 
        </td>@endif
        @if($_new_counter)
        <td>
            {{$record->new_oil_counter}} 
        </td>@endif
        @endif
        @if(!$member_name)
        @if($_customer)
        <td>{{$record->Name}}</td>
        @endif
        @if($_code)
        <td>{{$record->code}}</td>
        @endif
        @endif
        @if($_forgivness)
            <td> 
                @if($record->forgivness) {{ __('layout.'.ucfirst($record->forgivness)) }} @endif
            </td>
        @endif
        @if(getTransportCompany()=="true")
        @if($_transportCompany)
        <td>{{$record->trasnport_name}}</td>
        @endif
        @if($_driver)
        <td>{{$record->driver_name}}</td>
        @endif
        @endif
        @if($_account_name)
        <td class="center">{{$record->Account}}</td>@endif
        @if($_amount)
        <td class="center">{{round($record->Amount,2)}}</td>@endif
        @if($_unit)
        <td class="center">{{$record->Unit}}</td>@endif
        @if($_rate)
        <td class="center">{{$record->rate}}</td>@endif
        @if($_discount_type)
        <td class="center">{{$record->discount_type}}</td>@endif
        @if($_discount)
        @if($record->discount_type == 'percent')<td class="center">{{$record->discount1}}</td>
        @else<td class="center">{{$record->Discount}}</td>@endif
        @endif
        @if(getSaleTaxation() == 'true')
        <td class="center">{{$record->sale_taxation}} %</td>
        @endif
        @if(getFactorPending() == 'true')
            <td class="center">@if($record->pending == 'on') @lang('layout.Pending') @else @lang('layout.Confirm') @endif</td>
        @endif
        @if($_user)<td class="center">{{$record->user}}</td>@endif
    </tr>
    @endforeach
</table>
@if($_total)
<table class="main-table">
    <tr class="bg">
        <td colspan="3">
            <div class="center"><b> @lang('layout.PerCurrency') </b></div>
        </td>
    </tr>
    <tr>
        <td>
            <div class="center"><b> @lang('layout.Record') </b></div>
        </td>
        <td>
            <div class="center"><b> @lang('layout.Currency') </b></div>
        </td>
        <td>
            <div class="center"><b> @lang('layout.Amount') </b></div>
        </td>
    </tr>
    <?php
    $count = 0;
    foreach ($currencies as $key => $currency) {
    ?>
        <tr>
            <td>
                <div class="center">{{++$count}}</div>
            </td>
            <td>
                <div class="center">{{$key}}</div>
            </td>
            <td>
                <div class="center">{{round($currency,2)}}</div>
            </td>
        </tr>
    <?php
    }
    ?>
    <tr>
        <td colspan="2">
            <div class="center">@lang('layout.HomeCurrencyTotal')</div>
        </td>
        <td>
            <div class="center">{{round($total_home_currency,2)}}   {{getHomeCurrency()[getCurrencyType()]}}</div>
        </td>
    </tr>
</table>
@endif
@if($percent)
<h3 class="table-caption" style="text-align: center;">@lang('layout.Total') @lang('layout.Percentage')</h3>
<table class="main-table">
  <thead>
    <tr class="bg">
      <td>
        <div class="center"> @lang('layout.Record') </div>
      </td>
      <td>
        <div class="center"> @lang('layout.ItemName')</div>
      </td>
      <td>
        <div class="center"> @lang('layout.Unit')</div>
      </td>
      <td>
        <div class="center"> @lang('layout.Quantity')</div>
      </td>
      <td>
        <div class="center"> @lang('layout.Amount')</div>
      </td>
      <td>
        <div class="center"> @lang('layout.TotalAmount')</div>
      </td>
      <td>
        <div class="center"> @lang('layout.Unit')</div>
      </td>
      <td>
        <div class="center"> @lang('layout.Percentage') %</div>
      </td>
    </tr>
  </thead>
  <?php
  $count = 0;
  ?>
  @foreach($summary AS $record)
  <tr>
    <td class="center">{{++$count}}</td>
    <td class="center">{{$record->item_name}}</td>
    <td class="center">{{$record->um}}</td>
    <td class="center">{{$record->quantityOut}}</td>
    <td class="center">{{myRound($record->price)}}</td>
    <td class="center">{{myRound($record->amount)}}</td>
    <td class="center">{{getHomeCurrency()[getCurrencyType()]}}</td>
    <td class="center">{{myRound($record->percentage)}} %</td>
  </tr>
  @endforeach
</table>
@endif
@endif
<!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table>
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
            </table>
        </td>
        @endforeach
    </tr>
</table>
<!-- End signature -->
@endsection