@extends('layouts.app')
@section('content')


    <!-- END PAGE HEADER-->


    <!-- BEGIN TAB PORTLET-->


    <div class="row">

        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>
                    <span class="caption-subject bold uppercase">@lang('layout.InvoicePaymentList')</span>
                </div>
                <div class="tools"> </div>
                <div class="btn-group pull-right">
                    @permission('invoice-payment-create')
                        <a href="{{route('invoicePayment.create')}}">
                            <button id="sample_editable_1_new" class="btn green btn-sm btn-outline">
                                <i class="fa fa-plus"></i> @lang('layout.AddNew')
                            </button></a>
                    @endpermission    
                </div>
            </div>
            <div class="portlet-body">
                <table class="table table-striped table-bordered table-hover" id="sale">
                    <thead>
                    <tr>
                        {{--<th>@lang('layout.ID')</th>--}}
                        <th>@lang('layout.CustomerName')</th>
                        <th>@lang('layout.InvoiceNumber')</th>
                        <th>@lang('layout.Account')</th>
                        <th>@lang('layout.Amount')</th>
                        <th>@lang('layout.Currency')</th>
                        <th>@lang('layout.Rate')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>

                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- END TAB PORTLET-->

    <!-- END CONTENT BODY -->


@stop

@push('scripts')

<script>

    $(document).ready(function() {


        $('#sale').DataTable( {
            ajax:'{{route("invoicePayment.index")}}',
            pageLength:'{{getPageRows()}}',
            sort:false,
            scrollCollapse: true,
            paging:         true,
            serverSide: true,
            columns: [
               /* { data: 'id', name: 'id' },*/
                { data: 'name', name: 'name' },
                { data: 'number', name: 'name' },
                { data: 'account', name: 'percent' },
                { data: 'amount', name: 'account' },
                { data: 'currency', name: 'account' },
                { data: 'rate', name: 'account' },
                { data: 'date', name: 'date' },
                { data: 'actions', name: 'account' },
//            { data: 'measure_unit_id', name: 'quantity' },
//            { data: 'measure_unit', name: 'rate' },


            ]


        } );


    } );
</script>


@endpush
