@extends('layouts.app')
@section('style')

@stop



@section('content')
    <div id="app" v-cloak>
        <div class="row">

            <div class="col-md-9">
                <div class="row">

                    <!-- BEGIN SAMPLE TABLE PORTLET-->
                    <div class="portlet light bordered">
                        <div class="portlet-title">
                            <div class="caption">
                                <i class="icon-social-dribbble font-green"></i>
                                <span class="caption-subject font-green bold uppercase">@lang('layout.CustomerInvoiceList') </span>
                            </div>
                            <div class="actions">
                                <a class="btn btn-circle btn-icon-only btn-default" href="javascript:;">
                                    <i class="icon-cloud-upload"></i>
                                </a>
                                <a class="btn btn-circle btn-icon-only btn-default" href="javascript:;">
                                    <i class="icon-wrench"></i>
                                </a>
                                <a class="btn btn-circle btn-icon-only btn-default" href="javascript:;">
                                    <i class="icon-trash"></i>
                                </a>
                            </div>
                        </div>
                        <div class="portlet-body">
                            <div class="table-scrollable">
                                <table class="table table-hover">
                                    <thead>
                                    <tr>
                                        <th>@lang('layout.Number') </th>
                                        <th>@lang('layout.Customer') </th>
                                        <th>@lang('layout.SalesNumber') </th>
                                        <th>@lang('layout.Account') </th>
                                        <th>@lang('layout.Date') </th>
                                        <th>@lang('layout.Due Date') </th>
                                        <th>@lang('layout.Currency') </th>
                                        <th>@lang('layout.Amount') </th>
                                        <th>@lang('layout.Actions') </th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <tr v-for="invoiceItem in invoice" :class="{'active':invoiceItem.id == selectedInvoice.id}" v-on:click="selectInvoice(invoiceItem)">

                                        <td> @{{ invoiceItem.number }} </td>
                                        <td> @{{ invoiceItem.customer }} </td>
                                        <td> @{{ invoiceItem.salesNumber }} </td>
                                        <td> @{{ invoiceItem.account }} </td>
                                        <td> @{{ invoiceItem.currency }} </td>
                                        <td> @{{ invoiceItem.date }} </td>
                                        <td> @{{ invoiceItem.due_date }} </td>
                                        <td> @{{ invoiceItem.total }} </td>
                                        <td> @{{ invoiceItem.paid }} </td>

                                    </tr>

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <!-- END SAMPLE TABLE PORTLET-->

                </div>
            </div>
            <div class="col-md-3">
                <div class="row">
                    <!-- BEGIN SAMPLE FORM PORTLET-->
                    <div class="portlet light bordered">
                        <div class="portlet-title">
                            <div class="caption">
                                <i class="icon-social-dribbble font-blue-sharp"></i>
                                <span class="caption-subject font-blue-sharp bold uppercase">@lang('layout.InvoicePaymentForm') </span>
                            </div>
                        </div>
                        <div class="portlet-body form">
                            {{Form::open(['route' => 'invoicePayment.store','method' => 'POST','class' => 'form-horizontaljj','id'=>'payment-form'])}}

                            <div class="form-body">
                                <div class="form-group">
                                    <label for="single" class="control-label">@lang('layout.SelectCustomer')</label>

                                    <select name="customer" class="form-control " id="invoice-number"
                                            v-model="customer">
                                        <option v-for="custom,key in customers"
                                                :value="key">@{{ custom }}
                                        </option>
                                    </select>

                                </div>
                                <div class="form-group">
                                    <label for="invoice-number" class="control-label">@lang('layout.SelectInvoice')</label>
                                    <select  class="form-control " id="invoice-number"
                                            v-model="selectedInvoiceNumber">
                                        <option v-for="invos in invoicelist"
                                                :value="invos.id">@{{invos.number}}
                                        </option>
                                    </select>
                                    <input type="hidden" name="invoice" :value="selectedInvoice.id">
                                </div>
                                <div class="form-group">
                                    <label for="invoice-number" class="control-label">@lang('layout.SelectCurrency')</label>
                                    <select  class="form-control " id="invoice-number"
                                            v-model="currecySelect">
                                        <option v-for="invos in currencyList"
                                                :value="invos">@{{invos.code}}
                                        </option>
                                    </select>
                                    <input type="hidden" name="currency" :value="currecySelect.code">
                                    <input type="hidden" name="rate" :value="currecySelect.rate">
                                    <input type="hidden" name="currentRate" :value="selectedInvoice.rate">
                                </div>
                                <div class="form-group">
                                    <label for="invoice-number" class="control-label">@lang('layout.SelectBankAccount')</label>
                                    <select name="bank" class="form-control " id="invoice-number"
                                            v-model="selectedBank">
                                        <option v-for="bank in filteredBank"
                                                :value="bank.id">@{{bank.name}}
                                        </option>
                                    </select>
                                    {{--<input type="hidden" name="bank" :value="selectedBank">--}}
                                </div>
                                <span v-if="(selectedInvoice.currency != currecySelect.code)">
                                    <div v-if="(selectedInvoice.currency != '{{getHomeCurrency()["code"]}}')"
                                         class="form-group">
                                         <label>@lang('layout.InvoiceCurencyRate')</label>
                                              <div class="input-group input-group-sm">
                                        <span class="input-group-addon"
                                              id="sizing-addon1">@{{ selectedInvoice.currency }}</span>
                                        <input type="text" v-model="selectedInvoice.rate" class="form-control"
                                               placeholder="">
                                              </div>
                                    </div>
                                    <div v-if="(currecySelect.code != '{{getHomeCurrency()["code"]}}')"
                                         class="form-group">
                                        <label>@lang('layout.PaymentCurencyRate')</label>
                                              <div class="input-group input-group-sm">
                                        <span class="input-group-addon"
                                              id="sizing-addon1">@{{ currecySelect.code }}</span>

                                        <input type="text" v-model="currecySelect.rate" class="form-control"
                                               placeholder="">
                                              </div>
                                    </div>
                                </span>
                                <div class="form-group">
                                    <div class="row">
                                        <div class="col-md-4">
                                            <label>@lang('layout.Currency')</label>
                                            <input type="text" class="form-control input-sm"
                                                   v-model="selectedInvoice.currency" disabled placeholder="Currency">
                                        </div>
                                        <div class="col-md-8">
                                            <label>@lang('layout.Total')</label>
                                            <input type="text" class="form-control input-sm"
                                                   v-model="selectedInvoice.total" disabled placeholder="Total Amount">
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label>@lang('layout.PaidAmount')</label>
                                    <div class="input-group input-group-sm">
                                        <span class="input-group-addon" id="sizing-addon1">@{{ selectedInvoice.currency }}</span>
                                        <input type="text" class="form-control" v-model="selectedInvoice.paid" disabled
                                               placeholder="Paid Amount" aria-describedby="sizing-addon1"></div>
                                </div>
                                <div class="form-group">
                                    <label>@lang('layout.DuAmount')</label>
                                    <div class="input-group input-group-sm">
                                        <span class="input-group-addon" id="sizing-addon1">@{{ selectedInvoice.currency }}</span>
                                        <input type="text" class="form-control"

                                               :value="(selectedInvoice.total-selectedInvoice.paid)-(toPay * selectedInvoice.rate)/currecySelect.rate"
                                               disabled placeholder="Paid Amount" aria-describedby="sizing-addon1">
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label>@lang('layout.AmountToPay')</label>
                                    <div class="input-group input-group-sm">
                                        <span class="input-group-addon"
                                              id="sizing-addon1">@{{ currecySelect.code }}</span>
                                        <input name="amount" type="number" class="form-control" v-model="toPay"
                                               placeholder="Paid Amount" aria-describedby="sizing-addon1"></div>
                                </div>

                            </div>
                            <div v-if="((selectedInvoice.total-selectedInvoice.paid)-(toPay * selectedInvoice.rate)/currecySelect.rate) >= 0 "class="form-actions right" >
                               <a href="{{route('invoicePayment.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>

                                <button type="button" class="btn default">@lang('layout.Cancel')</button>
                                <button type="button" class="btn green" v-on:click="formSubmit">@lang('layout.Submit')</button>
                            </div>
                            {{Form::close()}}
                        </div>
                    </div>

                </div>
            </div>


            {{--<button  v-if="isError" type="button" class="btn default" @click="submitform">Submit</button>--}}

        </div>
    </div>


    {{--<pre>@{{ $data | json }}</pre>--}}
    {{--<pre>@{{ $items | json }}</pre>--}}


    <script type="text/x-template" id="checkbox-template">

        <div>
            <b>#@{{item.id}}</b>
            <span>@{{ item.name }}</span>
            {{--<span>@{{item.qty }}</span>--}}
            {{--<span>@{{item.description}}</span>--}}
        </div>
    </script>
@endsection

@push('scripts')

    <script src="{{url('/vue/vue-resource.js')}}"></script>
    <script src="{{url('/vue/sweetalert1.min.js')}}"></script>
    <script src="{{url('/vue/v-autocomplete.js')}}"></script>
    {{--<script>--}}

    {{--</script>--}}


    <script>




        Vue.use(VeeValidate);

        var app = new Vue({

            el: '#app',
            data: {
                invoicelist: null,
                invoice:[],
                currencyList:{!! $currencies !!},
                bankList:{!! $banks !!},
                filteredBank:null,
                selectedBank:null,
                currecySelect:{},
                selectedInvoiceNumber:null,
                selectedInvoice:{},
                customers:{!! $customer !!},
                customer:1,
                toPay:0
            },
            watch: {
                selectedInvoiceNumber: function () {



                    this.selectedInvoice  = this.invoicelist.find(item => item.id == this.selectedInvoiceNumber )
                    this.currecySelect = this.currencyList.filter(item => item.code == this.selectedInvoice.currency )[0];

                    this.currecySelect.rate = this.selectedInvoice.rate;
                    this.toPay = ((this.selectedInvoice.total - this.selectedInvoice.paid) *this.currecySelect.rate /this.selectedInvoice.rate);

                },
                currecySelect: function () {
                    this.filteredBank = this.bankList.filter(item => item.code == this.currecySelect.code );
                    this.toPay = ((this.selectedInvoice.total - this.selectedInvoice.paid) * this.currecySelect.rate /this.selectedInvoice.rate);
                },

                customer: function () {

                   axios.post("{{url('/customeinvo/')}}/"+this.customer)
                        .then(function (response) {
                            app.invoicelist = response.data
                            app.invoice = response.data
                            if(app.invoice .length == 0){

                                app.invoice = {};
                            }



                            // app.selectedInvoiceNumber = 1;
                            // $('#myTable1').DataTable().ajax.reload();

                        })
                        .catch(function (error) {

                            // vu.fieldErrors = error.response.data

                        });
                },
                toPay: function () {


                }

            },
            computed:{

            },
            methods: {
                selectInvoice(invoice){
                    this.selectedInvoiceNumber = invoice.id;
                    // this.selectecInvoice = 7;
                },
                customer: function (id) {
                     axios.post("{{url('/customeinvo/')}}"+id)
                        .then(function (response) {
                            this.invoice = response.response.data

                            // $('#myTable1').DataTable().ajax.reload();

                        })
                        .catch(function (error) {

                            // vu.fieldErrors = error.response.data

                        });
                },
                formSubmit(){



                    swal({
                        title: "Are you sure?",
                        text: "",
                        icon: "info",
                        buttons: true,
                        dangerMode: true,
                    })
                        .then((willDelete) => {
                            if (willDelete) {
                                document.getElementById("payment-form").submit()

                            } else {

                            }
                        });

                }
            {{--submintPay: function () {--}}
                    {{--var req = axios.post("{{url('/customeinvo/'}}"+customer)--}}
                        {{--.then(function (response) {--}}
                            {{--this.invoice = response.response.data--}}

                            {{--// $('#myTable1').DataTable().ajax.reload();--}}

                        {{--})--}}
                        {{--.catch(function (error) {--}}

                            {{--// vu.fieldErrors = error.response.data--}}

                        {{--});--}}
                {{--}--}}

            }
        });




        // var app = new Vue({
        //
        //     el: '#app',
//
//             computed: {
//                 subtotal: function () {
//                     var sum = 0;
//                     for (var i = 0; i < this.rows.length; i++) {
//                         if (this.rows[i].item)
//                             sum += this.rows[i]['item']['qty'] * this.rows[i]['item']['price'];
//
//                     }
//                     for (var i = 0; i < this.services.length; i++) {
//                         if (this.services[i].item)
//                             sum += this.services[i]['item']['qty'] * this.services[i]['item']['price'];
//
//                     }
//
//                     return sum;
//                 },
//                 payeds: function () {
//                     var sum = 0;
//                     for (var i = 0; i < this.payment.length; i++) {
//
//                         if (this.payment[i].item) {
// //
//                             sum += (this.payment[i]['item']['amount'] / this.payment[i]['item']['rate']) * this.selectedCurrency.rate;
//                         }
//                     }
//                     return sum;
//                 },
//
//
//                 isError: function () {
//                     var isError = false
//                     for (var i = 0; i < this.rows.length; i++) {
//                         if (this.rows[i].item && ((this.rows[i]['item']['qty'] > this.rows[i]['item']['onHand']) || (this.rows[i]['item']['qty'] < 0))){
//                             isError = true;
//                         }
//
//
//                     }
//                     if((isError) || (this.discount < 0) || (this.discount > 100 )){
//                         return false;
//                     }else {
//                         return true;
//                     }
//
//                 },
//
//
//                 discount: function () {
//
//                 }
//
//             },
//             methods: {
//                 addRow() {
//                     this.rows.push({
//                         items: [],
//                         item: null
//
//
//                     })
//                 },
//                 newService() {
//                     this.services.push({
//                         items: [],
//                         item: null
//                     })
//                 },
//                 newPayment() {
//                     this.payment.push({
//                         items: [],
//                         item: null
//                     })
//                 },
//                 deleteRow(index) {
//                     this.rows.splice(index, 1)
//                 },
//                 deleteService(index) {
//                     this.services.splice(index, 1)
//                 },
//                 itemSelected(item) {
//                     this.item = item;
// //                this.rows.item = item;
//                 },
//                 serviceSelected(item) {
//                     this.item = item;
// //                this.rows.item = item;
//                 },
//                 itemClicked(item) {
//                     this.item = item;
// //                this.rows.item = item;
//                 },
//                 serviceClicked(item) {
//                     this.item = item;
// //                this.rows.item = item;
//                 },
//                 getLabel(item) {
//                     return item.name
//                     this.rows.item = item;
//                 },
//                 update(text) {
//                     var Animals1 = Animals.slice();
//
//                     for (var i = 0; i < this.rows.length; i++) {
//                         if (this.rows[i].item != null) {
//                             if (Animals1.findIndex((item) => item.name == this.rows[i].item.name) != -1)
//                                 Animals1.splice(Animals1.findIndex((item) => item.name == this.rows[i].item.name), 1)
//
//                         }
//
//                     }
//
//                     this.rows[this.index].items = Animals1.filter((item) => {
//                         return (new RegExp(text.toLowerCase())).test(item.name.toLowerCase())
//                     })
//                     if (this.index == this.rows.length - 1)
//                         this.addRow()
//                     if (this.rows[this.index].item != null)
//                         this.priceUpdate(this.index)
//
//                 },
//                 serviceUpdate(text) {
//                     var Animals1 = Services.slice();
//
//                     for (var i = 0; i < this.services.length; i++) {
//                         if (this.services[i].item != null) {
//                             if (Animals1.findIndex((item) => item.name == this.services[i].item.name) != -1)
//                                 Animals1.splice(Animals1.findIndex((item) => item.name == this.services[i].item.name), 1)
//
//                         }
//
//                     }
//
//                     this.services[this.sindex].items = Animals1.filter((item) => {
//                         return (new RegExp(text.toLowerCase())).test(item.name.toLowerCase())
//                     })
//                     if (this.sindex == this.services.length - 1)
//                         this.newService()
//                     if (this.services[this.sindex].item != null)
//                         this.priceUpdate(this.sindex)
//
//                 },
//                 paymentUpdate(text) {
//                     var Animals1 = Account.slice();
//
//                     for (var i = 0; i < this.payment.length; i++) {
//                         if (this.payment[i].item != null) {
//                             if (Animals1.findIndex((item) => item.name == this.payment[i].item.name) != -1)
//                                 Animals1.splice(Animals1.findIndex((item) => item.name == this.payment[i].item.name), 1)
//
//                         }
//
//                     }
//
//                     this.payment[this.bindex].items = Animals1.filter((item) => {
//                         return (new RegExp(text.toLowerCase())).test(item.name.toLowerCase())
//                     })
//                     if (this.bindex == this.payment.length - 1)
//                         this.newPayment()
//                     if (this.payment[this.bindex].item != null)
//                         this.payeds;
//
//                 },
//                 convertMeasure(index) {
//                     var row = this.rows[index];
//                     if (row.item != null) {
//                         row.item.price = (((row.item.measure.unit * row.item.dprice) / row.item.dunint) * this.selectedCurrency.rate);
//                         row.item.cost = (((row.item.measure.unit * row.item.dcost) / row.item.dunint) * this.selectedCurrency.rate);
//                         row.item.onHand = ((row.item.dunint * row.item.dqty) / row.item.measure.unit);
//
//                     }
//                 },
//                 convertServiceMeasure(index) {
//                     var row = this.services[index];
//                     if (row.item != null) {
//                         row.item.price = (((row.item.measure.unit * row.item.dprice) / row.item.dunint) * this.selectedCurrency.rate);
//                         row.item.cost = (((row.item.measure.unit * row.item.dcost) / row.item.dunint) * this.selectedCurrency.rate);
//                     }
//                 },
//                 accountUpdate() {
//                     var b = _.clone(Banks)
//                     // this.accounts = b.filter((account) => {
//                     //     return (new RegExp(this.selectedCurrency.code.toLowerCase())).test(account.code.toLowerCase())
//                     // })
//                     this.listAccounts = _.clone(this.accounts)
//                     this.account = null;
//
//                     this.priceUpdate()
//                 },
//                 bankUpdate(text) {
//                     var b = _.clone(this.accounts)
//
//                     this.listAccounts = b.filter((account) => {
//                         return (new RegExp(text.toLowerCase())).test(account.name.toLowerCase())
//                     })
//
//                 },
//                 priceUpdate() {
//                     for (var i = 0; i < this.rows.length; i++) {
//                         if (this.rows[i].item != null) {
//                             var row = this.rows[i];
//                             row.item.price = (((row.item.measure.unit * row.item.dprice) / row.item.dunint) * this.selectedCurrency.rate);
//                             row.item.cost = (((row.item.measure.unit * row.item.dcost) / row.item.dunint) * this.selectedCurrency.rate);
// //
//
//                         }
//
//                     }
//
//                     for (var i = 0; i < this.services.length; i++) {
//                         if (this.services[i].item != null) {
//                             var row = this.services[i];
//                             row.item.price = (((row.item.measure.unit * row.item.dprice) / row.item.dunint) * this.selectedCurrency.rate);
//                             row.item.cost = (((row.item.measure.unit * row.item.dcost) / row.item.dunint) * this.selectedCurrency.rate);
// //
//
//                         }
//
//                     }
//
//                 },
//                 test(text) {
//                     this.index = text
//                     this.update('')
//                 },
//                 serviceIndex(text) {
//                     this.sindex = text
//                     this.serviceUpdate('')
//                 },
//                 paymentIndex(text) {
//                     this.bindex = text
//                     this.paymentUpdate('')
//                 },
//                 addNew(index) {
//                     if (this.rows.length - 1 == index) {
//                         this.rows.push({
//                             item: null
//                         })
//
//                     }
//                 },
//                 submitform() {
//                     var isEror = false
//                     for (var i = 0; i < this.rows.length; i++) {
//                         if (this.rows[i].item && ((this.rows[i]['item']['qty'] > this.rows[i]['item']['onHand']) || (this.rows[i]['item']['qty'] < 0))){
//                             isEror = true;
//                         }
//
//
//                     }
//                     if(isEror){
//                         return false
//                     }
//
//
//                     swal({
//                         title: "Are you sure?",
//                         text: "",
//                         icon: "info",
//                         buttons: true,
//                         dangerMode: true,
//                     })
//                         .then((willDelete) => {
//                             if (willDelete) {
//                                 document.getElementById("sales-form").submit()
//
//                             } else {
//
//                             }
//                         });
//
//
//                 },
//                 sss() {
//                     alert('dd')
//                     document.getElementById("invoice-submit").submit()
//                 },
//             }

        // })
        // app.accountUpdate();


    </script>
@endpush