@extends('layouts.app')

@section('content')

    <div id="print-modal">
        <report-modal :pdf-route="pdfRoute" :excel-route="excelRoute" v-if="is_show"
                      :value-type="'allInvestment'"
                      @closed="closeModal">

            <div slot="body">
                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <label class="control-label ">@lang('layout.SelectMember') </label>
                            <v-select class="vue-select2" v-model="selectedMember" label="name" @search="onMemberSearch" :options="member">
                            </v-select>
                            <input type="hidden" name="member_id" v-model.number="(!selectedMember)?null:selectedMember.id">
                        </div>
                    </div>
                </div>


                <div class="row">
                    <div class="form-group">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label"> @lang('layout.Date')</label>
                                <div class="input-group">
                                    <input class="form-control date" id="range-from-example" name="from_date" autocomplete="off">

                                    <span class="input-group-addon"> @lang('layout.To') </span>
                                    <input class="form-control date" id="range-to-example" name="to_date" autocomplete="off">

                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </report-modal>
    </div>

    <div class="row">
        <!-- BEGIN EXAMPLE TABLE PORTLET-->
        <div class="portlet light bordered">
            <div class="portlet-title">
                <div class="caption font-dark">
                    <i class="icon-settings font-dark"></i>&nbsp;
                    <span class="caption-subject bold uppercase">@lang('layout.InvestmentList')</span>
                </div>
                <div class="tools"></div>
                <div class=" pull-right">
                    <span id="anchore-modal">
                       <a href="#" @click.prevent="showModal" id="" class="btn  btn-success">
                          <i class="fa fa-print"></i>
                       </a>
                    </span>
                    @permission('drawing-list')
                    <a href="{{route('investment.create')}}">
                        <!-- <button id="sample_editable_1_new" class="btn green btn-sm btn-outline"> -->
                        <button id="sample_editable_1_new" class="btn btn-success">
                            <i class="fa fa-plus"></i> @lang('layout.AddNew')
                        </button>
                    </a>
                    @endpermission
                </div>
            </div>
            <div class="portlet-body">
                <template v-cloak id="company_ll">
                    <company @company="setCompany"></company>
                </template>
                <table class="table table-striped table-bordered table-hover" id="drawing">
                    <thead>
                    <tr>
                        <th>@lang('layout.Number')</th>
                        <th>@lang('layout.Name')</th>
                        <th>@lang('layout.Account')</th>
                        <th>@lang('layout.Equity')</th>
                        <th>@lang('layout.Amount')</th>
                        <th>@lang('layout.Currency')</th>
                        <th>@lang('layout.Rate')</th>
                        <th>@lang('layout.Date')</th>
                        <th>@lang('layout.User')</th>
                        <th>@lang('layout.Description')</th>
                        <th>@lang('layout.Actions')</th>
                    </tr>
                    </thead>

                </table>
            </div>
        </div>
        <!-- END EXAMPLE TABLE PORTLET-->
    </div>


    <!-- END TAB PORTLET-->

    <!-- END CONTENT BODY -->


@stop
@include('groupCompanyFilter.select')
@include('print.modal')
@push('scripts')
    <script>
        Vue.component("v-select", VueSelect.VueSelect);
        $(document).ready(function () {
            $.fn.dataTable.ext.errMode='{{dataTableWarning()}}';
            $('#drawing').DataTable({
                ajax: '{{route("investment.index")}}',
                pageLength: '{{getPageRows()}}',
                order: [["{{orderByColumn()=='number'?0:6}}", "{{getRowOrder()}}"]],
                sort: true,
                responsive:'{{responsiveDataTable()}}',
                pagingType:'{{paginationType()}}',
                scrollCollapse: true,
                paging: true,
                serverSide: true,
                columns: [
                    {data: 'number', name: 'drawings.number'},
                    {data: 'name', name: 'members.name'},
                    {data: 'account', name: 'accounts.name'},
                    {data: 'drawing_account', name: 'drawing_account', orderable: false, searchable: false},
                    {data: 'amount', name: 'transactions.amount'},
                    {data: 'currency', name: 'transactions.unit'},
                    {data: 'rate', name: 'rate', orderable: false, searchable: false},
                    {data: 'date', name: 'date'},
                    {data: 'username', name: 'users.name'},
                    {data: 'description', name: 'description'},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false},
                ]
            });
        });


        // for new modal


        var vm = new Vue({
            el: '#print-modal',
            data: {
                is_show: false,
                pdfRoute: '{!!route('export.PDFAll') !!}',
                excelRoute: '{!! route('export.ExcelAll') !!}',

                selectedMember: null,
                member:[],

            },
            methods: {
                closeModal: function () {
                    this.is_show = !this.is_show
                },
                onMemberSearch(search, loading) {
                    loading(true);
                    this.searchMember(search, loading, this);
                },
                //ajax call to get items
                searchMember(search, loading, vm) {
                    axios.get("{{route('callMethod.search')}}", {
                        params: {
                            method_name: 'member',
                            type: 'Owner',
                            search: search,
                        }
                    })
                    .then(function (response) {
                        this.member = [];
                        if (response.data.length > 0) {
                            vm.member = response.data;
                            // console.log('data', vm.member);
                        }
                        loading(false);
                    })
                    .catch(function (error) {
                        console.log(error);
                    })
                },
            }
        });


        new Vue({
            el: '#anchore-modal',
            methods: {
                showModal: function () {
                    console.log('trr')
                    vm.$data.is_show = true;

                }
            }
        });

        new Vue({
            el: '#company_ll',
            methods: {
                setCompany: function (event) {
                    window.location.reload();
                }
            }
        });
    </script>
@endpush
