@extends('layouts.app')
@section('content')
    <div class="row">

        <div class="portlet light bg-inverse" style="min-height: 100%;">
            <div class="portlet-title">
                <div class="caption">
                    <i class="icon-equalizer font-green-haze"></i>&nbsp;
                    <span class="caption-subject font-green-haze bold uppercase">@lang('layout.EditInvestment') </span>
                    <!-- <span class="caption-helper">some info...</span> -->
                </div>
                <div class="tools">
                  
                </div>
            </div>
            <div class="portlet-body form" style="margin-bottom:50%;">
                <!-- BEGIN FORM-->
                {!! Form::model($investment, ['method' => 'PATCH','class'=>'form-horizontal','route' => ['investment.update',$investment->id]]) !!}
                    <div class="form-body" id="app" v-cloak>
                        <div class="row">
                            <div class="col-md-8">
                                <div class="row">
                                    <div class="col-md-6"> 
                                        <label class="control-label">@lang('layout.SelectMember')</label>
                                        <v-select class="vue-select2" v-model="selectedEmployee" label="name"
                                                :options="{{$member}}">
                                        </v-select>
                                        <input type="hidden" name="member_id" v-model.number="(!selectedEmployee)?null:selectedEmployee.member_id">
                                    </div>
                                    <div class="col-md-3">
                                        <label class="control-label">@lang('layout.Equity')</label>
                                        {{Form::select('equity_account_id',$equity,$investment->daccount,['class' => 'form-control'])}}
                                    </div>
                                     <div class="col-md-3">
                                        <label class="control-label">@lang('layout.Number')</label>
                                        <input type="number"   name="number" class="form-control" step="any" min="0"  value="{{$investment->drawing_number}}">
                                        
                                    </div>

                                </div>
                                <div class="row">
                                    <div class="col-md-6" style="padding: 0px;">
                                        <div :class="currency_len">
                                           <label class="control-label">@lang('layout.InvestmentCurrency')</label>
                                            <select  class="form-control" v-model="selectedCurrency" v-on:change="setSize(selectedCurrency.code)" @if(systemConfig()[29] == 1) disabled @endif >
                                                 <option v-for="curre in currency" :value="curre">@{{ curre.code }}</option>
                                            </select>
                                            <input type="hidden" name="currency" v-bind:value="selectedCurrency.code"/> 
                                        </div>
                                        <div :class="rate_len" v-if="selectedCurrency.code != '{{getHomeCurrency()["code"]}}'">
                                            <label class="control-label">@lang('layout.Rate') </label>
                                            <div :class="{'has-error':selectedCurrency.rate < 0}">
                                                <div class="input-group">
                                                    <input  v-model="selected_rate" class="form-control"
                                                           type="number" min="0" step="any">
                                                    <span class="input-group-addon">@{{selectedCurrency.symbol}}</span>
                                                </div>
                                                <input type="hidden" name="currency_rate" :value="selected_rate">
                                            </div>
                                        </div>
                                    </div> 
                                    <div class="col-md-6">
                                        <label class="control-label">@lang('layout.Account')</label>
                                        <div class="input-group">
                                            <select class="form-control" name="account_id" v-model="defaultAccount" v-on:change="test(defaultAccount)">
                                                <option v-for="Account in accountUpdate" :value="Account.id">@{{
                                                    Account.name }}
                                                </option>
                                            </select>
                                            <span class="input-group-addon">@{{ ( Number(selectedBank.balance)+(Number(amount)-Number(defaultAmount))).toFixed(precision()) }}</span>
                                        </div>
                                    </div>
                                </div> 
                                <div class="row">  
                                    <div class="col-md-6" style="padding: 0px;">
                                        <div :class="pcurrency_len">
                                           <label class="control-label">@lang('layout.Currency')</label>
                                            <select  class="form-control" v-model="paymentCurrency" v-on:change="setPaymentSize(paymentCurrency.code)" disabled>
                                                 <option v-for="curre in currency1" :value="curre">@{{ curre.code }}</option>
                                            </select>
                                            <input type="hidden" name="paymentCurrency" v-bind:value="paymentCurrency.code"/> 
                                        </div> 
                                        <div :class="prate_len" v-if="paymentCurrency.code != '{{getHomeCurrency()["code"]}}'">
                                            <label class="control-label">@lang('layout.Rate') </label>
                                            <div :class="{'has-error':paymentCurrency.rate < 0}">
                                                <div class="input-group">
                                                    <input  v-model="selected_rate1" class="form-control"
                                                           type="number" min="0" step="any">
                                                    <span class="input-group-addon">@{{paymentCurrency.symbol}}</span>
                                                </div>
                                                <input type="hidden" name="paymentrate" :value="selected_rate1">
                                            </div>
                                        </div> 
                                    </div>                                       
                                    <div class="col-md-6">
                                        <label class="control-label">@lang('layout.Amount')</label>
                                        {{Form::number('amount',null,['class' => 'form-control' ,'step' => 'any','min' =>'0','v-model'=>'amount'])}}
                                    </div> 
                                </div>
                                <div class="row">
                                    <div class="">
                                          <div class="col-md-3">
                                            <label class="control-label">@lang('layout.ExchangedAmount')</label>
                                            
                                            @if(systemConfig()[30] == 1)
                                            <div class="input-group">
                                                <input type="number" :value="((amount /static_rate * selected_rate)   *  static_rate1  / selected_rate1).toFixed(3)" class="form-control" min="0" step="any">
                                                <span class="input-group-addon">@{{paymentCurrency.symbol}}</span>
                                            </div> 
                                            @else 
                                            <div class="input-group">
                                                <input type="number" :value="(amount*selected_rate1/(selected_rate)).toFixed(3)" class="form-control" min="0" step="any">
                                                <span class="input-group-addon">@{{paymentCurrency.symbol}}</span>
                                            </div>   
                                            @endif

                                            </div>


                                          <div class="col-md-3">
                                                <label class="control-label">@lang('layout.Date')</label>
                                               {{Form::text('date',$investment->date,['class' => 'form-control date','id'=>'date','autocomplete'=>'off'])}}
                                            
                                          </div>

                                        <div class="col-md-6">
                                            <label class="control-label">@lang('layout.Description')</label>
                                            {{Form::textarea('description',null,['class'=>'form-control','rows'=>'3'])}}
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="panel panel-default" style="background-color:rgb(204, 216, 228);position: relative;top: 24px;">
                                    <div class="panel-body">
                                        <table class="table table-bordered">
                                            <thead>
                                                <tr>
                                                    <th>@lang('layout.Currency') </th>
                                                    <th>@lang('layout.Payable')</th>
                                                    <th>@lang('layout.Receivable')</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <span v-if="selectedEmployee">
                                                   <tr v-for="summ in (selectedEmployee)?selectedEmployee.sumary:null" >
                                                      <td class="highlight">
                                                         @{{ summ.currency }}
                                                      </td>
                                                      <td class="hidden-xs"> @{{ summ.payable }}</td>
                                                      <td>
                                                          @{{summ.receivable }}
                                                      </td>
                                                    </tr>
                                                </span>
                                            </tbody>
                                        </table>
                                    </div>
                                </div>                            
                            </div>
                        </div>
                    </div>
                    <div class="col-xs-12 col-sm-10 col-md-11 text-center">
                         <button type="button" onclick="regForm(this)" class="btn green">@lang('layout.Submit')</button>
                        <a href="{{route('salaryDetails.index')}}" class="btn default"><i class="fa fa-mail-reply"></i> @lang('layout.Cancel')</a>
                    </div>  
                {!! Form::close() !!}
            </div>                  
            <!-- END FORM-->
        </div>
    </div> 
@endsection
@push('scripts')
<script>

  

     Vue.component("v-select", VueSelect.VueSelect);
        var Banks     = {!! $bank!!}
        var Member    = {!!$member!!}
        var selectedMember = {!! json_encode($selectedMember) !!}
        var Currency  = {!! $currency!!}
        var Currency1  = {!! $currency!!}
        var one = {!! json_encode(getHomeCurrency()) !!}
        var two = {!! json_encode(getHomeCurrency()) !!}
        var code = "{!! getHomeCurrency()["code"] !!}";

       

    new Vue({
        el: '#app',
        data: {
            selectedCurrency:one,
            paymentCurrency:two,
            default_currency:two,
            currency:{!! json_encode(currencyList()) !!},
            currency1:{!! json_encode(currencyList()) !!},
                bankes: {!! $banks !!},
                selectedBank: null,
                defaultValue: 0,
                defaultAccount: 0,
                amount:{!!$investment->amount!!},
                defaultAmount:{!!$investment->amount!!},
                selected_rate:{!!$investment->rate!!},
                selected_rate1:{!!$investment->secondRate!!},
                listAccounts:[],
                selectedEmployee:selectedMember,
                currencyList: Currency,
                type: 'bank',
                account: {},
                currency_len: 'col-md-12',
                rate_len: 'col-md-0',
                pcurrency_len: 'col-md-12',
                prate_len: 'col-md-0',
                code: code,
                first_currency: 0,
                second_currency: 0,
                defaultAccount: "{{ $investment->account_id }}",
                firstAccount: "{{ $investment->account_id }}",
                date: "{{$investment->date}}",
                static_rate: {!!$investment->static_rate!!},
                static_rate1: {!!$investment->static_rate2!!}

        },
        computed: {
            accountUpdate() {
                var b = _.clone(Banks)
                var test = this.accounts = b.filter((account) => {
                    return (new RegExp(this.selectedCurrency.code.toLowerCase())).test(account.code.toLowerCase())
                })
                this.defaultValue = test[0].id;
                        
                        for(var x in this.bankes){
                            for(z in this.bankes[x]){
                                if(this.firstAccount != -1){
                                    if(this.bankes[x][z] == this.firstAccount && z == 'id'){
                                        this.selectedBank = this.bankes[x];
                                        this.defaultAccount = this.firstAccount;
                                        this.firstAccount = -1;
                                        break;
                                    } 
                                }
                                else if(this.bankes[x][z] == this.defaultValue && z == 'id'){
                                    this.selectedBank = this.bankes[x];
                                    this.defaultAccount = this.defaultValue;                                    
                                    break;
                                }
                            }

                        }
                return test;    
            },
        },
        created(){
                this.checkSelected();
            },
        methods: {
                checkSelected(){
                    var allCarrencies = {!! json_encode(currencyList()) !!};
                    for(var x in allCarrencies){
                        for(z in allCarrencies[x]){
                             
                            if(allCarrencies[x][z] == "{!! $investment->currency !!}"){
                                if(allCarrencies[x][z] != "USD"){
                                    this.currency_len = 'col-md-6';
                                    this.rate_len     = 'col-md-6';
                                }
                                this.selectedCurrency = allCarrencies[x];
                            }

                            if(allCarrencies[x][z] == "{!! $investment->dcurrency !!}"){
                                if(allCarrencies[x][z] != "USD"){
                                    this.pcurrency_len= 'col-md-6';
                                    this.prate_len    = 'col-md-6';
                                }
                                this.paymentCurrency  = allCarrencies[x];
                                
                            }
                        }

                    }

                },
                setSize(selected_code) {
                    // this.paymentCurrency=this.selectedCurrency;
                    this.selected_rate = this.selectedCurrency.exchange_rate;
                    this.selected_rate1 = this.paymentCurrency.exchange_rate;
                    this.static_rate1 = this.paymentCurrency.static_rate;
                    this.static_rate = this.selectedCurrency.static_rate;
                    if(selected_code ==  this.code){
                        this.currency_len = 'col-md-12';
                        this.rate_len = 'col-md-0';
                    }
                    else {
                        this.currency_len = 'col-md-6';
                        this.rate_len = 'col-md-6';
                    }
                    this.pcurrency_len=this.currency_len;
                    this.prate_len=this.rate_len;
                }, 
                setPaymentSize(selected_code) {
                    // this.selected_rate = this.paymentCurrency.exchange_rate;
                    this.selected_rate1 = this.paymentCurrency.exchange_rate;
                    this.static_rate1 = this.paymentCurrency.static_rate;
                    
                    if(selected_code ==  this.code){
                        this.pcurrency_len = 'col-md-12';
                        this.prate_len = 'col-md-0';
                    }
                    else  {
                        this.pcurrency_len = 'col-md-6';
                        this.prate_len = 'col-md-6';
                    }
                },
                check_code(code){
                    if(this.paymentCurrency.code == this.selectedCurrency.code){
                        this.selected_rate1 = this.selected_rate;
                    }

                },
                test(defaultAccount){
                    for(var x in this.bankes){
                            for(z in this.bankes[x]){
                                if(this.bankes[x][z] == defaultAccount && z == 'id'){
                                    this.selectedBank = this.bankes[x];
                                    break;
                                }
                            }

                        }

                },
              
        }
    });  

</script>
@endpush
 
 