@extends('layouts.factor-master')

@section('content')
<?php
$report = customeReport('investment');
$_date=in_array('date', $report);
$_description=in_array('description', $report);
$_name=in_array('name', $report);
$_account=in_array('account', $report);
$_amount=in_array('amount', $report);
$_currency=in_array('currency', $report);
$_rate=in_array('rate', $report);
?>

 <h3 class="table-caption" style="text-align: center;">@lang('layout.InvestmentReport')</h3>
  <table   class="main-table">
    <tr>
      @if($from_date)
     <td>
      <span>@lang('layout.FromDate')</span>:
      <BDO DIR="LTR">{{convertDate($from_date)}}</BDO>
    </td>
    @endif
    @if($to_date)
    <td>
      <span>@lang('layout.ToDate')</span>:
      <BDO DIR="LTR">{{convertDate($to_date)}}</BDO>
    </td>
    @endif
  </tr>
  </table>
<table class="main-table">
<thead>
  <tr class="bg">
 <td class="center"  ><div>@lang('layout.No')</div></td>
 @if($_date)<td class="center"  ><div> @lang('layout.Date')</div></td>@endif
 @if($_description)<td class="center"  ><div> @lang('layout.Description')</div></td>@endif
 @if($_name)<td class="center"  ><div> @lang('layout.Name') </div></td>@endif
 @if($_account) <td class="center"  ><div> @lang('layout.Account')</div></td>@endif
 @if($_account) <td class="center"  ><div> @lang('layout.Equity')</div></td>@endif
 @if($_amount)<td class="center"  ><div> @lang('layout.Amount')</div></td>@endif
 @if($_currency)<td class="center"  ><div> @lang('layout.Currency')</div></td>@endif
 @if($_rate)<td class="center"  ><div> @lang('layout.Rate')</div></td>@endif
 <td class="center"  ><div> @lang('layout.User')</div></td>

</tr>
</thead>
<?php
$count = 0;
$total_home_currency=0;
  $currencies=[];
?>
@foreach($data AS $record)
<tr>

<?php
   $total_home_currency+=$record->exchanged_amount;
   if(array_key_exists($record->Currency, $currencies))
   {
    $currencies[$record->Currency]=$currencies[$record->Currency]+$record->Amount;
  }
  else
  {

    $currencies[$record->Currency]=$record->Amount;
  }
  ?>

<td class="center">{{++$count}}</td>
<@if($_date)td  class="center">{{convertDate($record->Date)}}</td>@endif
@if($_description)<td  class="center">{{$record->Description}}</td>@endif
@if($_name)<td  class="center">{{$record->Name}}</td>@endif
@if($_account)<td  class="center">{{$record->Account}}</td>@endif
@if($_account)<td  class="center">{{$record->DrawingAccount}}</td>@endif
@if($_amount)<td  class="center">{{round($record->Amount,2)}}</td>@endif
@if($_currency)<td  class="center">{{$record->Currency}}</td>@endif
@if($_rate)<td  class="center">{{$record->Rate}}</td>@endif
<td  class="center">{{$record->user}}</td>
</tr>
@endforeach   
</table>

<table class="main-table">
 <tr class="bg">
  <td colspan="3"><div class="center">@lang('layout.PerCurrency')</div></td>
</tr>
<tr>
  <td><div class="center">  @lang('layout.Record') </div></td>
  <td><div class="center"> @lang('layout.Currency') </div></td>
  <td><div class="center"> @lang('layout.Amount') </div></td>
</tr>
<?php
$count=0;
foreach($currencies As $key=>$currency)
{
  ?>
  <tr>
    <td><div class="center">{{++$count}}</div></td>
    <td><div class="center">{{$key}}</div></td>
    <td><div class="center">{{round($currency,2)}}</div></td>

  </tr>
  <?php
}
?>
<tr>
 <td colspan="2"><div class="center">@lang('layout.HomeCurrencyTotal')</div></td>
 <td><div class="center">{{round($total_home_currency,2)}}   {{getHomeCurrency()[getCurrencyType()]}}</div></td>

</tr>
</table>

 <!--  signature -->
<table style="width: 100%" class="signtable">
    <tr>
        @foreach(getCompanyInfo('sign','reports') AS $info)
        <td style="text-align: left; width:40%">
            <table >
               
                <tr>
                    <td align="right" class="signsize">{{$info['name']}}</td>
                </tr>
                
            </table>
        </td>
         @endforeach
    </tr>
</table>
 <!-- End signature -->
@endsection